%define kmod_name		mpi3mr
%define kmod_driver_version	8.14.1.0.0
%define kmod_rpm_release	1
%define kmod_kernel_version	%(uname -r)
%define kmod_kernel_version_dep	%{kmod_kernel_version}
%define kmod_install_path	extra/mpi3mr
%global kernel_source() 	/usr/src/kernels/%{kmod_kernel_version}
%define __find_requires 	/usr/lib/rpm/redhat/find-requires.ksyms
%define __find_provides 	/usr/lib/rpm/redhat/find-provides.ksyms %{kmod_name} %{?epoch:%{epoch}:}%{version}-%{release}
%define sbindir 		%( if [ -d "/sbin" -a \! -h "/sbin" ]; then echo "/sbin"; else echo %{_sbindir}; fi )
%define dup_state_dir 		%{_localstatedir}/lib/rpm-state/kmod-dups
%define kver_state_dir 		%{dup_state_dir}/kver
%define kver_state_file 	%{kver_state_dir}/%{kmod_kernel_version}
%define dup_module_list 	%{dup_state_dir}/rpm-kmod-%{kmod_name}-modules

Name:			kmod-mpi3mr
Version:		%{kmod_driver_version}
Release:		%{kmod_rpm_release}
Summary:		%{kmod_name} kernel module(s)
Group:			System/Kernel
License:		GPLv2
URL:			http://www.lsilogic.com
Distribution:		LSI Corporation
Source0:		%{kmod_name}-%{kmod_driver_version}.tar.bz2
Source1:                %{kmod_name}.conf 
Source2:                dracut-%{kmod_name}.conf
BuildRoot:		%(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
Provides:		kernel-modules >= %{kmod_kernel_version}
Provides:		kmod-%{kmod_name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires(post):		%{sbindir}/weak-modules
Requires(post):		%{sbindir}/depmod 
Requires(postun):       %{sbindir}/depmod 
Requires(postun):	%{sbindir}/weak-modules

%description
LSI MPT Fusion HBA drivers (12gb SAS)

This package provides the mpi3mr kernel modules built for
the Linux kernel %{kmod_kernel_version} for the %(arch)
family of processors.
The GPG Public Key of digitally signed Broadcom DCSG drivers is located in:
https://docs.broadcom.com/docs/dcsg-gpg-verification-guide

%post
if [ -e "/boot/System.map-%{kmod_kernel_version}" ]; then
	%{sbindir}/depmod -aeF "/boot/System.map-%{kmod_kernel_version}" "%{kmod_kernel_version}" > /dev/null || :
fi
modules=( $(find /lib/modules/%{kmod_kernel_version}/extra/mpi3mr | grep '\.ko$') )
printf '%s\n' "${modules[@]}" | %{sbindir}/weak-modules --add-modules

mkdir -p "%{kver_state_dir}"
touch "%{kver_state_file}"

%preun
mkdir -p "%{dup_state_dir}"
rpm -ql kmod-mpi3mr-%{kmod_driver_version} | grep '\.ko$' > "%{dup_module_list}"

%postun
if [ -e "/boot/System.map-%{kmod_kernel_version}" ]; then
	%{sbindir}/depmod -aeF "/boot/System.map-%{kmod_kernel_version}" "%{kmod_kernel_version}" > /dev/null || :
fi
modules=( $(cat "%{dup_module_list}") )
rm -f "%{dup_module_list}"
printf '%s\n' "${modules[@]}" | %{sbindir}/weak-modules --remove-modules

rmdir "%{dup_state_dir}" 2> /dev/null

exit 0

%files
%defattr(644,root,root,755)
/lib/modules/%{kmod_kernel_version}
/etc/depmod.d/%{kmod_name}.conf
/etc/dracut.conf.d/%{kmod_name}.conf

%prep
%setup -n %{kmod_name}-%{kmod_driver_version}
set -- *
mkdir source
mv "$@" source/
mkdir obj

%build
rm -rf obj
cp -r source obj
make -C %{kernel_source} M=$PWD/obj

# mark modules executable so that strip-to-file can strip them
find obj -name "*.ko" -type f -exec chmod u+x '{}' +
whitelist="/lib/modules/kabi-current/kabi_whitelist_%{_target_cpu}"

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=extra/mpi3mr
make -C %{kernel_source} modules_install M=$PWD/obj
# Cleanup unnecessary kernel-generated module dependency files.
find $INSTALL_MOD_PATH/lib/modules -iname 'modules.*' -exec rm {} \;

sed -e s/this_weakupdate-/`uname -r | cut -f1 -d-`/ \
../../SOURCES/mpi3mr.conf > \
../../SOURCES/mpi3mr.a
mv ../../SOURCES/mpi3mr.a ../../SOURCES/mpi3mr.conf
install -m 644 -D %{SOURCE1} $RPM_BUILD_ROOT/etc/depmod.d/%{kmod_name}.conf
install -m 644 -D %{SOURCE2} $RPM_BUILD_ROOT/etc/dracut.conf.d/%{kmod_name}.conf

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
