#!/usr/bin/bash

# Update depmod after installing driver
if [ -f /boot/System.map-$(uname -r) ]; then
	depmod -a "$(uname -r)" -F "/boot/System.map-$(uname -r)"
else
	depmod -a "$(uname -r)"
fi  

# To add the mpi3mr module from the /update/dkms directory to the initrd image,
# append "mpi3mr" to /etc/initramfs-tools/modules.
if ! grep -q "mpi3mr" "/etc/initramfs-tools/modules"; then
	echo "mpi3mr" >> "/etc/initramfs-tools/modules"
fi

# Back up the current initrd
echo "Backing up initrd.img-$(uname -r)" "initrd.img-$(uname -r).old-dkms"
cp -f "/boot/initrd.img-$(uname -r)" "/boot/initrd.img-$(uname -r).old-dkms"

# Update initrd
update-initramfs -u -k "$(uname -r)"

