%define name mpi3mr
%define version 8.14.1.0.0
%define release 1
%define kernel `uname -r`
Summary: LSI MPT Fusion drivers for SAS 3.0
Name: %{name}
Version: %{version}
Release: %{release}
Vendor: LSI Corporation
License: GPL
Group: System Environment/Kernel
Source0: %{name}-%{version}.tar.gz
Source1: Module.supported
URL: http://www.lsi.com
Distribution: LSI Coporation
BuildRoot: /var/tmp/%{name}-buildroot


%description
Drivers for (i686, x86_64, ia64, ppc64 and updates) for the
LSI Corporation mpi3mr  Architecture
The GPG Public Key of digitally signed Broadcom DCSG drivers is located in:
https://docs.broadcom.com/docs/dcsg-gpg-verification-guide

# prep #########################################################################
%prep
echo prep %{version}
%setup -c -b 0
cp %_sourcedir/Module.supported drivers/scsi/mpi3mr/Module.supported


# build ########################################################################
%build
echo build %{version}
make build  KERNEL=%{kernel};

# install ######################################################################
%install
echo install %{version}
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}

MPTLINUX_IPATH=/lib/modules/%{kernel}/weak-updates/mpi3mr

if modinfo mpi3mr -n |xargs file |grep -c "compressed" >> /dev/null; then
	driver_bin="mpi3mr.ko.xz"
elif [ `find /lib/modules/%{kernel}/ -name mpi3mr.ko.xz*` ]; then
	driver_bin="mpi3mr.ko.xz"
else
	driver_bin="mpi3mr.ko"
fi

mkdir -p $RPM_BUILD_ROOT/lib/modules/%{kernel}/weak-updates/mpi3mr

# create the file list used in %files to indicate which files are in package
echo "$MPTLINUX_IPATH/${driver_bin}.new" >> $RPM_BUILD_DIR/file.list.%{name}

make install PREFIX=$RPM_BUILD_ROOT KERNEL=%{kernel}
if [ ${driver_bin} == "mpi3mr.ko.xz" ]; then
	xz $RPM_BUILD_ROOT/$MPTLINUX_IPATH/mpi3mr.ko
fi
mv -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_bin} \
	$RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_bin}.new


# pre #########################################################################
%pre
echo pre %{version}
system_arch=`uname -m`
if [ %{_target_cpu} != ${system_arch} ]; then
	echo "ERROR: Failed installing this rpm!!!!"
	echo "This rpm is intended for %{_target_cpu} platform. It seems your system is ${system_arch}.";
	exit 1;
fi;

# post #########################################################################
%post
echo post %{version}

if modinfo mpi3mr -n |xargs file |grep -c "compressed" >> /dev/null; then
	driver_bin="mpi3mr.ko.xz"
elif [ `find /lib/modules/%{kernel}/ -name mpi3mr.ko.xz*` ]; then
	driver_bin="mpi3mr.ko.xz"
else
	driver_bin="mpi3mr.ko"
fi

if [ ! -e /boot/vmlinuz-%{kernel} ] && [ ! -e /boot/vmlinux-%{kernel} ]; then
	continue;
fi;

MPTLINUX_IPATH=/lib/modules/%{kernel}/weak-updates/mpi3mr
if [ ! -e $MPTLINUX_IPATH/${driver_bin}.new ]; then
	continue;
fi;

MPTLINUX_ORIG_IPATH=/lib/modules/%{kernel}/kernel/drivers/scsi/mpi3mr
echo "The mpi3mr driver for kernel %{kernel} is now version %{version}";
cp -f $MPTLINUX_IPATH/${driver_bin}.new $MPTLINUX_IPATH/${driver_bin}

# Remake the initrd image
MPTLINUX_IPATH=/lib/modules/%{kernel}/kernel/drivers/scsi/mpi3mr
if [ -e $MPTLINUX_IPATH/${driver_bin} ]; then
	mv $MPTLINUX_IPATH/${driver_bin} \
		$MPTLINUX_IPATH/${driver_bin}.orig
fi;

MPTLINUX_IPATH=/lib/modules/%{kernel}/updates
if [ -e $MPTLINUX_IPATH/${driver_bin} ]; then
	mv $MPTLINUX_IPATH/${driver_bin} \
		$MPTLINUX_IPATH/${driver_bin}.orig
fi;

MPTLINUX_IPATH=/lib/modules/%{kernel}/extra/mpi3mr
if [ -e $MPTLINUX_IPATH/${driver_bin} ]; then
	mv $MPTLINUX_IPATH/${driver_bin} \
		$MPTLINUX_IPATH/${driver_bin}.orig
fi;

bootpart=/boot;
depmod -v %{kernel} > /dev/null 2>&1;

#   By default mkinitramfs command includes only those modules present in kernel/driver/ path
#   in to the initrd image. So inorder to include ${driver_bin} module which is present in weak-update
#   directory in to initrd image then append "mpi3mr" line to /etc/initramfs-tools/modules.
#   /etc/initramfs-tools/modules stores those modules that we want to include in our initramfs.

if which mkinitramfs |grep -c "mkinitramfs" >> /dev/null; then
	if which mkinitramfs |grep -c "no mkinitramfs" >> /dev/null ; then
		module_init_tool ="unknown"
	else
		module_init_tool ="mkinitramfs"
		mkinitramfs_modules=/etc/initramfs-tools/modules
		pattern=`grep -R "mpi3mr" ${mkinitramfs_modules}`
		if [ $? -ne 0 ]; then
			echo "mpi3mr" >> ${mkinitramfs_modules}
		else
			sed -e s/"$pattern"/mpi3mr/ ${mkinitramfs_modules} > /tmp/mkinitramfs_modules
			mv /tmp/mkinitramfs_modules ${mkinitramfs_modules}
		fi;

		mkinitramfs -k -o ${bootpart}/initrd.img-%{kernel} %{kernel}
		echo -e "${module_init_tool} post Install Done."
		exit 0;
	fi
fi

if which mkinitrd |grep -c "mkinitrd" >> /dev/null; then
	if which mkinitrd |grep -c "no mkinitrd" >> /dev/null ; then
		module_init_tool ="unknown"
	else
		module_init_tool ="mkinitrd"
		mkinitrd -f /boot/initramfs-%{kernel}.img %{kernel}
		ln -s initrd-%{kernel}.img  initramfs-%{kernel}.img
		echo -e "${module_init_tool} post Install Done."
		exit 0;
	fi
fi
		
echo -e "post Install Done."

# postun #######################################################################
%postun
echo postun %{version}

if modinfo mpi3mr -n |xargs file |grep -c "compressed" >> /dev/null; then
	driver_bin="mpi3mr.ko.xz"
elif [ `find /lib/modules/%{kernel}/ -name mpi3mr.ko.xz*` ]; then
	driver_bin="mpi3mr.ko.xz"
else
	driver_bin="mpi3mr.ko"
fi

MPTLINUX_IPATH=/lib/modules/%{kernel}/weak-updates/mpi3mr
if [ ! -e $MPTLINUX_IPATH/${driver_bin}.new ] && \
    [ -e $MPTLINUX_IPATH/${driver_bin} ]; then

	rm -rf $MPTLINUX_IPATH;

	MPTLINUX_IPATH=/lib/modules/%{kernel}/kernel/drivers/scsi/mpi3mr
	if [ -e $MPTLINUX_IPATH/${driver_bin}.orig ]; then
		mv $MPTLINUX_IPATH/${driver_bin}.orig \
			$MPTLINUX_IPATH/${driver_bin}
	fi;

	MPTLINUX_IPATH=/lib/modules/%{kernel}/updates
	if [ -e $MPTLINUX_IPATH/${driver_bin}.orig ]; then
		mv $MPTLINUX_IPATH/${driver_bin}.orig \
			$MPTLINUX_IPATH/${driver_bin}
	fi;

	MPTLINUX_IPATH=/lib/modules/%{kernel}/extra/mpi3mr
	if [ -e $MPTLINUX_IPATH/${driver_bin}.orig ]; then
		mv $MPTLINUX_IPATH/${driver_bin}.orig \
			$MPTLINUX_IPATH/${driver_bin}
	fi;
fi;

bootpart=/boot;

if [ ! -f /lib/modules/%{kernel}/kernel/drivers/scsi/mpi3mr/${driver_bin} ] && \
   [ ! -f /lib/modules/%{kernel}/udpates/${driver_bin} ] && \
   [ ! -f /lib/modules/%{kernel}/weak-updates/mpi3mr/${driver_bin} ] && \
   [ ! -f /lib/modules/%{kernel}/extra/mpi3mr/${driver_bin} ]; then
	sed -e '/mpi3mr/d' /etc/modprobe.conf > modprobe.edit;
	mv -f modprobe.edit /etc/modprobe.conf;
fi;

depmod -v %{kernel} > /dev/null 2>&1;


if which mkinitramfs |grep -c "mkinitramfs" >> /dev/null; then
	if which mkinitramfs |grep -c "no mkinitramfs" >> /dev/null ; then
		module_init_tool ="unknown"
	else
		module_init_tool ="mkinitramfs"
		#  Delete the "mpi3mr" line from /etc/initramfs-tools/modules file
		mkinitramfs_modules=/etc/initramfs-tools/modules
		sed '/mpi3mr/d' ${mkinitramfs_modules} > /tmp/module_remove
		mv /tmp/module_remove ${mkinitramfs_modules}
		mkinitramfs -k -o ${bootpart}/initrd.img-%{kernel} %{kernel}
		echo -e "${module_init_tool} Uninstall Done."
		exit 0;
	fi
fi

if which mkinitrd |grep -c "mkinitrd" >> /dev/null; then
	if which mkinitrd |grep -c "no mkinitrd" >> /dev/null ; then
		module_init_tool ="unknown"
	else
		module_init_tool ="mkinitrd"
		mkinitrd -f /boot/initramfs-%{kernel}.img %{kernel}
		ln -s initrd-%{kernel}.img  initramfs-%{kernel}.img
		echo -e "${module_init_tool} Uninstall Done."
		exit 0;
	fi
fi

echo -e "Uninstall Done."

# files ########################################################################
%files -f ../file.list.%{name}

# changelog  ###################################################################
%changelog
