
#include <linux/mm.h>
#include <linux/dma-mapping.h>
#include <linux/sched.h>
#include <linux/export.h>
#include <linux/hugetlb.h>
#include <linux/slab.h>
#ifdef HAVE_DEFINE_DMA_ATTRS
#include <linux/dma-attrs.h>
#endif

#include <rdma/ib_umem_odp.h>
#include <rdma/ib_umem.h>
#include <rdma/ib_verbs.h>

#include "peer_umem.h"
#include "peer_compat.h"

struct ib_umem *__ib_umem_get_compat(struct ib_device *ibdev,
				     struct ib_ucontext *ucontext,
				     struct ib_udata *udata,
				     unsigned long addr,
				     size_t size, int access,
				     int dmasync)
{
#ifdef HAVE_IB_DEVICE_IN_IB_UMEM_GET
	return ib_umem_get(ibdev, addr, size, access);
#else
#ifndef HAVE_UDATA_IN_IB_UMEM_GET
	return ib_umem_get(ucontext, addr, size, access, dmasync);
#else
	return ib_umem_get(udata, addr, size, access
#ifdef HAVE_DMASYNC_IB_UMEM_GET
			, dmasync
#endif
			);
#endif
#endif
}

