#
# spec file for package broadcom-bnxt_en-bnxt_re (Version 1.10.3-234.0.171.0)
#
# Copyright (c) 2021 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://support.novell.com
#


%define dversion 1.10.3-234.0.171.0

Name:           broadcom-bnxt_en
BuildRequires:  kernel-syms sles-release kmod
License:        GPL-2.0
Group:          System/Kernel
Summary:        Broadcom NetXtreme Gigabit Ethernet and RoCE Driver
Version:	%(echo %dversion | sed 's/-/./g')
Release:        150500.1.1
Source0:	netxtreme-bnxt_en-%{dversion}.tar.gz
Source1:        SUSE_README.TXT
BuildRoot:      %{_tmppath}/%{name}-%{dversion}-build

%define kernelver %(rpm -q --queryformat '%%{VERSION}-%%{RELEASE}' kernel-syms | sed 's/\\.[^.]*$//')
%define osreleasefile %(ls /etc/os-release)

%if "%{osreleasefile}" == "/etc/os-release"
%define sle_version %(grep -Po 'VERSION_ID="\\K[^"]*' /etc/os-release | sed 's/\\.//g')
%else
%define sle_version %(sed -n '/VERSION = /{s///p;q;}' /etc/SuSE-release)%(sed -n '/PATCHLEVEL = /{s///p;q;}' /etc/SuSE-release)
%endif


#Driver Names
%define bnxt_en_driver bnxt_en
%define bnxt_re_driver bnxt_re

%kernel_module_package -x rt

%description
This package contains the Linux and RoCE driver for the Broadcom Gigabit NetXtreme Server Adapters.

%package KMP
Summary: Documentation for the Broadcom NetXtreme Gigabit ethernet driver
Group:   System/Kernel

%description KMP
This package contains the Linux and RoCE driver for the Broadcom Gigabit NetXtreme Server Adapters.

%package doc
Summary: Documentation for the Broadcom NetXtreme Gigabit ethernet driver
Group: System/Kernel

%description doc
This package contains the documentation for the Broadcom NetXtreme Gigabit ethernet driver.

%prep
%setup -n netxtreme-bnxt_en-%{dversion}
set -- *
mkdir source
mv "$@" source/
cp %{SOURCE1} .
cp source/bnxt_en/COPYING .
cp source/bnxt_en/README.TXT bnxt_en_README.TXT
#cp source/bnxt_en/RELEASE.TXT bnxt_en_RELEASE.TXT
cp source/bnxt_re/README.TXT bnxt_re_README.TXT
#cp source/bnxt_re/RELEASE.TXT bnxt_re_RELEASE.TXT
echo "bnxt_en external" > source/bnxt_en/Module.supported
echo "bnxt_re external" > source/bnxt_re/Module.supported
mkdir obj

%build
echo "sle version %{sle_version}"
echo "kernel version %{kernelver}"

%bcond_with retpoline
%if %{with retpoline}
export KCFLAGS='-mindirect-branch=thunk-inline -mindirect-branch-register'
find source -name *.c -print0 | xargs -0 sed -i '/MODULE_LICENSE(/a MODULE_INFO(retpoline, "Y");'
%endif

export EXTRA_CFLAGS='-DVERSION=\"%dversion\"'
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    export BNXT_QPLIB_INC=$PWD/obj/$flavor/bnxt_re/bnxt_qplib
    export BNXT_EN_INC=$PWD/obj/$flavor/bnxt_en/
    make -C /usr/src/linux-obj/%_target_cpu/$flavor KVER=%{kernelver}-$flavor modules \
        M=$PWD/obj/$flavor/bnxt_en/
    %if %sle_version >= 120
      make -C /usr/src/linux-obj/%_target_cpu/$flavor KVER=%{kernelver}-$flavor modules \
          M=$PWD/obj/$flavor/bnxt_re/
    %endif
# Workaround for SLE 15
    %if %sle_version == 15
      make -C /usr/src/linux-obj/%_target_cpu/$flavor KVER=%{kernelver}-$flavor modules \
          M=$PWD/obj/$flavor/bnxt_re/
    %endif
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
for flavor in %flavors_to_build; do
    export INSTALL_MOD_DIR=updates
    make -C /usr/src/linux-obj/%_target_cpu/$flavor KVER=$kernel_version-$flavor modules_install \
        M=$PWD/obj/$flavor/bnxt_en/
    %if %sle_version >= 120
      export INSTALL_MOD_DIR=updates/drivers/infiniband/hw/%{bnxt_re_driver}/
      make -C /usr/src/linux-obj/%_target_cpu/$flavor KVER=$kernel_version-$flavor modules_install \
          M=$PWD/obj/$flavor/%{bnxt_re_driver}
    %endif
# Workaround for SLE 15
    %if %sle_version == 15
      export INSTALL_MOD_DIR=updates/drivers/infiniband/hw/%{bnxt_re_driver}/
      make -C /usr/src/linux-obj/%_target_cpu/$flavor KVER=$kernel_version-$flavor modules_install \
          M=$PWD/obj/$flavor/%{bnxt_re_driver}
    %endif
done

%files doc
%defattr(-, root, root)
%doc bnxt_*.TXT COPYING SUSE_README.TXT


%changelog
* Wed Jul 30 2025 hui.zhi.zhao@suse.com
- version: 1.10.3-234.0.171.0 bsc#1247387
* Mon Jul 28 2025 hui.zhi.zhao@suse.com
- version: 1.10.3-234.0.158.2 bsc#1247025
* Wed Jun 25 2025 hui.zhi.zhao@suse.com
- version: 1.10.3-234.0.154.0 bsc#1245318
* Wed Jun 18 2025 hui.zhi.zhao@suse.com
- version: 1.10.3-233.0.198.0 bsc#1244728
* Wed Jun 11 2025 hui.zhi.zhao@suse.com
- version: 1.10.3-234.0.146.0 bsc#1244258
* Wed Jun 11 2025 hui.zhi.zhao@suse.com
- version: 1.10.3-233.0.192.0 bsc#1244253
* Tue May 27 2025 hui.zhi.zhao@suse.com
- version: 1.10.3-234.0.138.0 bsc#1243687
* Fri Mar 28 2025 hui.zhi.zhao@suse.com
- version: 1.0.3-233.0.152.2 bsc#1240199
* Thu Mar  6 2025 hui.zhi.zhao@suse.com
- version: 1.0.3-233.0.152.0 bsc#1238628
* Mon Dec 16 2024 hui.zhi.zhao@suse.com
- version: 1.0.3-232.0.155.5 bsc#1234606
* Tue Nov 26 2024 hui.zhi.zhao@suse.com
- version: 1.0.3-232.0.155.0 bsc#1233755
* Fri Nov 22 2024 hui.zhi.zhao@suse.com
- version: 1.0.3-232.0.153.0 bsc#1233645
* Mon Nov 11 2024 hui.zhi.zhao@suse.com
- version: 1.0.3-232.0.139.0 bsc#1232852
* Fri Sep 27 2024 hui.zhi.zhao@suse.com
- version: 1.10.3-231.0.162.0 bsc#1231014
* Wed Sep 18 2024 hui.zhi.zhao@suse.com
- version: 1.10.3-231.0.160.0 bsc#1230609
* Mon Sep  9 2024 hui.zhi.zhao@suse.com
- version: 1.10.3-230.0.167.0 bsc#1230313
* Tue Sep  3 2024 hui.zhi.zhao@suse.com
- version: 1.10.3-231.0.155.0 bsc#1230077
* Mon Aug 26 2024 hui.zhi.zhao@suse.com
- version: 1.10.3.231.0.153.0 bsc#1229722
* Thu Jun  6 2024 hui.zhi.zhao@suse.com
- version: 1.10.3.230.0.132.0 bsc#1226004
* Fri Mar 15 2024 hui.zhi.zhao@suse.com
- version: 1.10.3.229.0.139.0 bsc#1221366
* Tue Nov  7 2023 hui.zhi.zhao@suse.com
- version: 1.10.2.228.0.133.0 bsc#1216939
* Wed Oct 11 2023 hui.zhi.zhao@suse.com
- version: 1.10.2.227.0.135.0 bsc#1216130
* Thu Aug 24 2023 hui.zhi.zhao@suse.com
- version: 1.10.2.227.0.130.0 bsc#1214549
* Mon Jul 17 2023 hui.zhi.zhao@suse.com
- version: 1.10.2.223.0.183.0 bsc#1212830
* Thu Jun  1 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-225.0.155.0 bsc#1211882
* Sat May 20 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-226.0.141.0 bsc#1211552
* Fri Apr 21 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-225.3.12.0 bsc#1210721
* Mon Apr 17 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-224.0.168.0 bsc#1210543
* Thu Mar 30 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-225.0.147.0 bsc#1209944
* Wed Mar 29 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-223.0.207.0 bsc#1209849
* Wed Mar  8 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-222.0.173.0 bsc#1209036
* Tue Mar  7 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-225.2.1.0 bsc#1208994
* Fri Feb 17 2023 hui.zhi.zhao@suse.com
- version: 1.10.2-225.0.143.0 bsc#1208402
* Fri Feb  3 2023 hui.zhi.zhao@suse.com
- Version: 1.10.2-224.0.163.0 bsc#1207861
* Thu Feb  2 2023 hui.zhi.zhao@suse.com
- Version: 1.10.2-225.0.139.0 bsc#1207855
* Mon Nov 28 2022 hui.zhi.zhao@suse.com
- Version: 1.10.2-222.0.169.0 bsc#1205821
* Tue Nov 15 2022 hui.zhi.zhao@suse.com
- Version: 1.10.2-224.0.157.0 bsc#1205399
* Wed Nov  2 2022 hui.zhi.zhao@suse.com
- Version: 1.10.2-225.0.71.0 bsc#1204960
* Wed Aug  3 2022 hui.zhi.zhao@suse.com
- Version: 1.10.2-223.0.162.0 bsc#1202055
* Fri Jul  8 2022 lance.ortiz@suse.com
- version 1.10.2-222.0.150.0 bsc#1201277
* Wed May 11 2022 lance.ortiz@suse.com
- version 1.10.2-222.0.142.0 bsc# 1199416
* Thu Mar 10 2022 lance.ortiz@suse.com
- version 1.10.2.119.0.57.0 bsc#1196895
* Mon Feb 28 2022 lance.ortiz@suse.com
- version 1.10.2.220.0.114.0 bsc#1196479
* Thu Jan  6 2022 lance.ortiz@suse.com
- version 1.10.2.220.0.13.0 bsc#1194273
* Wed Nov 10 2021 lance.ortiz@suse.com
- version 1.10.2-220.0.11.0 bsc#1192541
* Tue Aug 17 2021 lance.ortiz@suse.com
- version 1.10.2.220.0.0.135 bsc#1189417
* Thu Aug 12 2021 lance.ortiz@suse.com
- version 1.10.2.219.0.55.0 bsc#1189395
* Thu Aug  5 2021 lance.ortiz@suse.com
- version 1.10.2-218.0.106.0 bsc#1189151
* Tue Jul 27 2021 lance.ortiz@suse.com
- version 1.10.2-218.0.105.0 bsc#1188707
* Wed Jul 21 2021 lance.ortiz@suse.com
- version 1.10.2-218.0.103.0 bsc# 1188448
* Tue May 11 2021 lance.ortiz@suse.com
- version 1.10.2-218.0.219.2 bsc#1185887
* Tue Feb 23 2021 lance.ortiz@suse.com
- version 1.10.2-218.0.73.0 bsc#1182630
* Mon Jan  4 2021 lance.ortiz@suse.com
- version 1.10.2-218.0.67.0 bsc#1180533
* Tue Dec 15 2020 lance.ortiz@suse.com
- version 1.10.1-218.0.129.3 bsc#1179949
* Mon Oct 12 2020 lance.ortiz@suse.com
- version 1.10.1-218.0.44.0 bsc#1177493
* Mon Aug 17 2020 lance.ortiz@suse.com
- version 1.10.1-218.0.25.0 bsc# 1175211
* Thu Aug  6 2020 lance.ortiz@suse.com
- version 1.10.1-128.1.24.0 bsc 1174931
  <<<<<<< ./broadcom-bnxt_en.changes.mine
* Wed Jul 15 2020 lance.ortiz@suse.com
-version 1.10.1-216.0.416.1 bsc#1174015
  =======
* Tue Jun 23 2020 andavis@suse.com
-Version 1.10.1-216.0.169.4 build for SLES 15 SP2 bsc 1173176
  >>>>>>> ./broadcom-bnxt_en.changes.r40
* Thu May 14 2020 lance.ortiz@suse.com
-Version 1.10.1-216.0.169.4 bsc 1171488
* Fri May  1 2020 lance.ortiz@suse.com
-Version 1.10.1-216.0.152.1 bsc#1170969
* Fri Apr  3 2020 lance.ortiz@suse.com
- Version 1.10.1-216.0.153.1 bsc#1168550
* Fri Mar 20 2020 lance.ortiz@suse.com
- Version 1.10.1-214.0.259.5 bsc#1167187
* Tue Feb  4 2020 lance.ortiz@suse.com
- Version 1.10.1-216.0.152.0 bsc#1162308
* Mon Dec  9 2019 lance.ortiz@suse.com
-Version 1.10.0-214.0.259.1
* Mon Nov  4 2019 lance.ortiz@suse.com
-update to version 1.10.1-216.0.126.2
* Fri Oct  4 2019 lance.ortiz@suse.com
-update to version 10.0-214.0.259.0
* Mon Aug 19 2019 lance.ortiz@suse.com
-update to version 10.0-214.0.258.0
* Wed Jul 10 2019 lance.ortiz@suse.com
-update to version 10.0-214.0.253.1
* Sat Jul  6 2019 lance.ortiz@suse.com
-update to version 10.0-214.0.239
* Fri Jun  7 2019 lance.ortiz@suse.com
-updated to version 10.0-214.0 including SLES15SP1
* Thu Dec 27 2018 lance.ortiz@suse.com
-updated to version 1.9.2-214.0.182.0 including SLES12 SP4
* Tue Sep  4 2018 lance.ortiz@suse.com
-updated to version 1.9.2-214.0.150.0
