// SPDX-License-Identifier: BSD-3-Clause
/* Copyright(c) 2014-2025 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_template_db_tbl.h"

/* Mapper templates for header class list */
struct bnxt_ulp_mapper_tmpl_info ulp_thor_class_tmpl_list[] = {
	/* class_tid: 1, ingress */
	[1] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 74,
	.start_tbl_idx = 0,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 0,
		.cond_nums = 2 }
	},
	/* class_tid: 2, egress */
	[2] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 46,
	.start_tbl_idx = 74,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2030,
		.cond_nums = 2 }
	},
	/* class_tid: 3, ingress */
	[3] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 23,
	.start_tbl_idx = 120,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 3995,
		.cond_nums = 0 }
	},
	/* class_tid: 4, egress */
	[4] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 35,
	.start_tbl_idx = 143,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 4011,
		.cond_nums = 0 }
	}
};

struct bnxt_ulp_mapper_tbl_info ulp_thor_class_tbl_list[] = {
	{ /* class_tid: 1, , table: port_table.rd */
	.description = "port_table.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 0,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.ident_start_idx = 0,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.vxlan_ip_check */
	.description = "control.vxlan_ip_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.false_message = "invalid vxlan header combination",
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 0,
		.cond_nums = 3 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: tunnel_gparse_cache.custom_tunnel_rd */
	.description = "tunnel_gparse_cache.custom_tunnel_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_GPARSE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 7,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 10,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 1,
	.blob_key_bit_size = 8,
	.key_bit_size = 8,
	.key_num_fields = 1,
	.ident_start_idx = 2,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.custom_tunnel */
	.description = "control.custom_tunnel",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 2,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 17,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: control.custom_tunnel_port_check_value */
	.description = "control.custom_tunnel_port_check_value",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.false_message = "port does not match configured custom tunnel port",
	.execute_info = {
		.cond_true_goto  = 5,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 18,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_TUNNEL_PORT,
		.func_src2 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr2 = BNXT_ULP_RF_IDX_TUNNEL_PORT,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 1, , table: cust_tunnel.configure_vxlan_port */
	.description = "cust_tunnel.configure_vxlan_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_AND,
		.cond_start_idx = 3,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 0,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 1, , table: cust_tunnel.configure_vxlan_ip_port */
	.description = "cust_tunnel.configure_vxlan_ip_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN_IP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 2,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_AND,
		.cond_start_idx = 4,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 1,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 1, , table: cust_tunnel.configure_geneve_port */
	.description = "cust_tunnel.configure_geneve_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_GENEVE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 23,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 2,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 1, , table: tunnel_gparse_cache.custom_tunnel_wr */
	.description = "tunnel_gparse_cache.custom_tunnel_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_GPARSE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 24,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 2,
	.blob_key_bit_size = 8,
	.key_bit_size = 8,
	.key_num_fields = 1,
	.result_start_idx = 3,
	.result_bit_size = 80,
	.result_num_fields = 3
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam_cache.rd */
	.description = "l2_cntxt_tcam_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 29,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 3,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 4,
	.ident_nums = 3
	},
	{ /* class_tid: 1, , table: control.check_f1_f2_flow */
	.description = "control.check_f1_f2_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 29,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: tunnel_cache.f1_f2_rd */
	.description = "tunnel_cache.f1_f2_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 31,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 4,
	.blob_key_bit_size = 19,
	.key_bit_size = 19,
	.key_num_fields = 2,
	.ident_start_idx = 7,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.tunnel_cache_check */
	.description = "control.tunnel_cache_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 3,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 31,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.f1_f2_alloc_l2_cntxt */
	.description = "l2_cntxt_tcam.f1_f2_alloc_l2_cntxt",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 32,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 8,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: tunnel_cache.f1_f2_wr */
	.description = "tunnel_cache.f1_f2_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 32,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 6,
	.blob_key_bit_size = 19,
	.key_bit_size = 19,
	.key_num_fields = 2,
	.result_start_idx = 6,
	.result_bit_size = 52,
	.result_num_fields = 3
	},
	{ /* class_tid: 1, , table: control.check_f2_flow */
	.description = "control.check_f2_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 29,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 32,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.dmac_calculation */
	.description = "control.dmac_calculation",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 33,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 48,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 2,
		.func_dst_opr = BNXT_ULP_RF_IDX_O_DMAC }
	},
	{ /* class_tid: 1, , table: control.check_tunnel_recycle */
	.description = "control.check_tunnel_recycle",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 9,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_AND,
		.cond_start_idx = 5,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.multi_tunnel_check */
	.description = "control.multi_tunnel_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.false_message = "reject multi tunnel flow if group id or partial mask is specified",
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 40,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: multi_flow_tunnel_cache.rd */
	.description = "multi_flow_tunnel_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_FLOW_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 42,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 8,
	.blob_key_bit_size = 447,
	.key_bit_size = 447,
	.key_num_fields = 9,
	.ident_start_idx = 9,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.multi_flow_cache_check */
	.description = "control.multi_flow_cache_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 66,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: jump_index_table.multi_flow_alloc */
	.description = "jump_index_table.multi_flow_alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 67,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 9,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: control.multi_flow_metadata_cal */
	.description = "control.multi_flow_metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 67,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 1, , table: control.outer_present_mode_1 */
	.description = "control.outer_present_mode_1",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 67,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_ADD }
	},
	{ /* class_tid: 1, , table: multi_flow_tunnel_cache.wr */
	.description = "multi_flow_tunnel_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_FLOW_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 67,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 17,
	.blob_key_bit_size = 447,
	.key_bit_size = 447,
	.key_num_fields = 9,
	.result_start_idx = 9,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: control.multi_flow_outer_loop_bit */
	.description = "control.multi_flow_outer_loop_bit",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 7,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 95,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_LOOP }
	},
	{ /* class_tid: 1, , table: control.group_id_check */
	.description = "control.group_id_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 11,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 95,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: flow_chain_cache.group_check */
	.description = "flow_chain_cache.group_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 96,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 26,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.ident_start_idx = 10,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.flow_chain_group_id */
	.description = "control.flow_chain_group_id",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 96,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: jump_index_table.alloc */
	.description = "jump_index_table.alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 97,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 11,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: control.metadata_cal */
	.description = "control.metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 97,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 1, , table: flow_chain_cache.write */
	.description = "flow_chain_cache.write",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 97,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 27,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.result_start_idx = 11,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: flow_chain_l2_cntxt.chaining_check */
	.description = "flow_chain_l2_cntxt.chaining_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_L2_CNTXT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 97,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 28,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 11,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.flow_chain_group_l2_cntxt_check */
	.description = "control.flow_chain_group_l2_cntxt_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 101,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.chain_entry */
	.description = "l2_cntxt_tcam.chain_entry",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 102,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 29,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 13,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 12,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.chain_entry_dup */
	.description = "l2_cntxt_tcam.chain_entry_dup",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 104,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 50,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 19,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 13,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: flow_chain_l2_cntxt.write */
	.description = "flow_chain_l2_cntxt.write",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_L2_CNTXT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 107,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 71,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 25,
	.result_bit_size = 42,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: mac_addr_cache.rd */
	.description = "mac_addr_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 109,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 72,
	.blob_key_bit_size = 174,
	.key_bit_size = 174,
	.key_num_fields = 9,
	.ident_start_idx = 13,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.mac_addr_cache_miss */
	.description = "control.mac_addr_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 116,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.allocate_l2_context */
	.description = "l2_cntxt_tcam.allocate_l2_context",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 117,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 14,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry */
	.description = "l2_cntxt_tcam.ingress_entry",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 119,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 81,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 27,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 15,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry_dup */
	.description = "l2_cntxt_tcam.ingress_entry_dup",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 121,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 102,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 33,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 15,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: mac_addr_cache.wr */
	.description = "mac_addr_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 124,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 123,
	.blob_key_bit_size = 174,
	.key_bit_size = 174,
	.key_num_fields = 9,
	.result_start_idx = 39,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 1, , table: control.check_f1_flow */
	.description = "control.check_f1_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 129,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.l2_only_check */
	.description = "control.l2_only_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "Reject due to missing Ethertype for L2 flows",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 6,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.tunnel_ipv6_sip_check */
	.description = "control.tunnel_ipv6_sip_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "reject ipv6 tunnel flow with tunnel source ip",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 8,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: profile_tcam_bypass.chain_catch_all */
	.description = "profile_tcam_bypass.chain_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 144,
		.cond_nums = 3 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = ULP_THOR_SYM_PROF_TCAM_PRI_CHAIN_CATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 132,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 44,
	.result_bit_size = 33,
	.result_num_fields = 4,
	.ident_start_idx = 15,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: control.terminating_flow */
	.description = "control.terminating_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 148,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 5,
		.func_dst_opr = BNXT_ULP_RF_IDX_TERM_FLOW }
	},
	{ /* class_tid: 1, , table: proto_header_cache.rd */
	.description = "proto_header_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 159,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 175,
	.blob_key_bit_size = 75,
	.key_bit_size = 75,
	.key_num_fields = 3,
	.ident_start_idx = 15,
	.ident_nums = 7
	},
	{ /* class_tid: 1, , table: control.proto_header_cache_miss */
	.description = "control.proto_header_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 12,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 161,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	.description = "hdr_overlap_cache.overlap_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 162,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 178,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 2,
	.partial_key_start_idx = 180,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.ident_start_idx = 22,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.overlap_miss */
	.description = "control.overlap_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 164,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1
	},
	{ /* class_tid: 1, , table: profile_tcam.allocate_wc_profile */
	.description = "profile_tcam.allocate_wc_profile",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 165,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 24,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: fkb_select.wc_gen_template */
	.description = "fkb_select.wc_gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_WC_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 165,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 48,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	.description = "hdr_overlap_cache.overlap_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 427,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 181,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 2,
	.partial_key_start_idx = 183,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.result_start_idx = 154,
	.result_bit_size = 48,
	.result_num_fields = 3
	},
	{ /* class_tid: 1, , table: fkb_select.em_gen_template_alloc */
	.description = "fkb_select.em_gen_template_alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 429,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 157,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: em_key_recipe.alloc_only */
	.description = "em_key_recipe.alloc_only",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 430,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 263,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: control.profile_tcam_priority */
	.description = "control.profile_tcam_priority",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 430,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 51,
		.func_dst_opr = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY }
	},
	{ /* class_tid: 1, , table: profile_tcam.gen_template */
	.description = "profile_tcam.gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 446,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_REGFILE,
	.pri_operand  = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 184,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 263,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 25,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: wm_key_recipe.0 */
	.description = "wm_key_recipe.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 691,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 227,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 34,
	.result_start_idx = 271,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: proto_header_cache.wr */
	.description = "proto_header_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1237,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 261,
	.blob_key_bit_size = 75,
	.key_bit_size = 75,
	.key_num_fields = 3,
	.result_start_idx = 271,
	.result_bit_size = 106,
	.result_num_fields = 8
	},
	{ /* class_tid: 1, , table: em_flow_conflict_cache.rd */
	.description = "em_flow_conflict_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 9,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1239,
		.cond_nums = 5 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 264,
	.blob_key_bit_size = 77,
	.key_bit_size = 77,
	.key_num_fields = 4,
	.ident_start_idx = 26,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.em_flow_conflict_cache_miss */
	.description = "control.em_flow_conflict_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1246,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: fkb_select.em_gen_template */
	.description = "fkb_select.em_gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1247,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 279,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: em_key_recipe.0 */
	.description = "em_key_recipe.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1499,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 268,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 34,
	.result_start_idx = 385,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: em_flow_conflict_cache.wr */
	.description = "em_flow_conflict_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2017,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 302,
	.blob_key_bit_size = 77,
	.key_bit_size = 77,
	.key_num_fields = 4,
	.result_start_idx = 385,
	.result_bit_size = 96,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: control.field_sig_validation */
	.description = "control.field_sig_validation",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 4,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2019,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_FLOW_SIG_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_FLOW_SIG_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 1, , table: control.outer_loop_add_check */
	.description = "control.outer_loop_add_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 5,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2021,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: em.ingress_generic_template */
	.description = "em.ingress_generic_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2023,
		.cond_nums = 5 },
	.tbl_opcode = BNXT_ULP_EM_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 387,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 1, , table: control.em_add_check */
	.description = "control.em_add_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2028,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: wm.ingress_generic_template */
	.description = "wm.ingress_generic_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_WC_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2029,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 393,
	.result_bit_size = 38,
	.result_num_fields = 5
	},
	{ /* class_tid: 1, , table: control.outer_loop_check */
	.description = "control.outer_loop_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2029,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.reset_outer_loop */
	.description = "control.reset_outer_loop",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2030,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_LOOP }
	},
	{ /* class_tid: 1, , table: control.inner_loop_cal */
	.description = "control.inner_loop_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = -26,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2030,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_INNER_LOOP }
	},
	{ /* class_tid: 2, , table: l2_cntxt_tcam_cache.rd */
	.description = "l2_cntxt_tcam_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2032,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 306,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 27,
	.ident_nums = 2
	},
	{ /* class_tid: 2, , table: control.l2_only_check */
	.description = "control.l2_only_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.true_message = "Reject due to missing Ethertype for L2 flows",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 9,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.tunnel_ipv6_sip_check */
	.description = "control.tunnel_ipv6_sip_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.true_message = "reject ipv6 tunnel flow with tunnel source ip or source mac",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 11,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.check_tunnel_recycle */
	.description = "control.check_tunnel_recycle",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 9,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_AND,
		.cond_start_idx = 13,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.multi_tunnel_check */
	.description = "control.multi_tunnel_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.false_message = "reject multi tunnel flow if group id or partial mask is specified",
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2054,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: multi_flow_tunnel_cache.rd */
	.description = "multi_flow_tunnel_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_FLOW_TUNNEL_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2056,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 307,
	.blob_key_bit_size = 447,
	.key_bit_size = 447,
	.key_num_fields = 9,
	.ident_start_idx = 29,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.multi_flow_cache_check */
	.description = "control.multi_flow_cache_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2084,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: jump_index_table.multi_flow_alloc */
	.description = "jump_index_table.multi_flow_alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2085,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 398,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: control.multi_flow_metadata_cal */
	.description = "control.multi_flow_metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2085,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 2, , table: control.outer_present_mode_1 */
	.description = "control.outer_present_mode_1",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2085,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_ADD }
	},
	{ /* class_tid: 2, , table: multi_flow_tunnel_cache.wr */
	.description = "multi_flow_tunnel_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_FLOW_TUNNEL_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2085,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 316,
	.blob_key_bit_size = 447,
	.key_bit_size = 447,
	.key_num_fields = 9,
	.result_start_idx = 398,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 2, , table: control.multi_flow_outer_loop_bit */
	.description = "control.multi_flow_outer_loop_bit",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2113,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_LOOP }
	},
	{ /* class_tid: 2, , table: control.terminating_flow */
	.description = "control.terminating_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2113,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 335,
		.func_dst_opr = BNXT_ULP_RF_IDX_TERM_FLOW }
	},
	{ /* class_tid: 2, , table: control.group_id_check */
	.description = "control.group_id_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 7,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2121,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: flow_chain_cache.group_check */
	.description = "flow_chain_cache.group_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2122,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 325,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.ident_start_idx = 30,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.flow_chain_group_id */
	.description = "control.flow_chain_group_id",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2122,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: jump_index_table.alloc */
	.description = "jump_index_table.alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2123,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 400,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: control.metadata_cal */
	.description = "control.metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2123,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 2, , table: flow_chain_cache.write */
	.description = "flow_chain_cache.write",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2123,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 326,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.result_start_idx = 400,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 2, , table: profile_tcam_bypass.chain_only_flow */
	.description = "profile_tcam_bypass.chain_only_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2123,
		.cond_nums = 3 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = ULP_THOR_SYM_PROF_TCAM_PRI_CHAIN_CATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 327,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 402,
	.result_bit_size = 33,
	.result_num_fields = 4,
	.ident_start_idx = 31,
	.ident_nums = 0
	},
	{ /* class_tid: 2, , table: proto_header_cache.rd */
	.description = "proto_header_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2126,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 370,
	.blob_key_bit_size = 75,
	.key_bit_size = 75,
	.key_num_fields = 3,
	.ident_start_idx = 31,
	.ident_nums = 7
	},
	{ /* class_tid: 2, , table: control.proto_header_cache_miss */
	.description = "control.proto_header_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 12,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2128,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	.description = "hdr_overlap_cache.overlap_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2129,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 373,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 2,
	.partial_key_start_idx = 375,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.ident_start_idx = 38,
	.ident_nums = 2
	},
	{ /* class_tid: 2, , table: control.overlap_miss */
	.description = "control.overlap_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2131,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1
	},
	{ /* class_tid: 2, , table: profile_tcam.allocate_wc_profile */
	.description = "profile_tcam.allocate_wc_profile",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2132,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 40,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: fkb_select.wc_gen_template */
	.description = "fkb_select.wc_gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_WC_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2132,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 406,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	.description = "hdr_overlap_cache.overlap_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2397,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 376,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 2,
	.partial_key_start_idx = 378,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.result_start_idx = 512,
	.result_bit_size = 48,
	.result_num_fields = 3
	},
	{ /* class_tid: 2, , table: fkb_select.em_gen_template_alloc */
	.description = "fkb_select.em_gen_template_alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2399,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 515,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: em_key_recipe.alloc_only */
	.description = "em_key_recipe.alloc_only",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2400,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 621,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: control.profile_tcam_priority */
	.description = "control.profile_tcam_priority",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2400,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 381,
		.func_dst_opr = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY }
	},
	{ /* class_tid: 2, , table: profile_tcam.gen_template */
	.description = "profile_tcam.gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2416,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_REGFILE,
	.pri_operand  = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 379,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 621,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 41,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: wm_key_recipe.0 */
	.description = "wm_key_recipe.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2659,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 422,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 34,
	.result_start_idx = 629,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: proto_header_cache.wr */
	.description = "proto_header_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3211,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 456,
	.blob_key_bit_size = 75,
	.key_bit_size = 75,
	.key_num_fields = 3,
	.result_start_idx = 629,
	.result_bit_size = 106,
	.result_num_fields = 8
	},
	{ /* class_tid: 2, , table: em_flow_conflict_cache.rd */
	.description = "em_flow_conflict_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 9,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3213,
		.cond_nums = 5 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 459,
	.blob_key_bit_size = 77,
	.key_bit_size = 77,
	.key_num_fields = 4,
	.ident_start_idx = 42,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.em_flow_conflict_cache_miss */
	.description = "control.em_flow_conflict_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3220,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: fkb_select.em_gen_template */
	.description = "fkb_select.em_gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3221,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 637,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: em_key_recipe.0 */
	.description = "em_key_recipe.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3471,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 463,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 34,
	.result_start_idx = 743,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: em_flow_conflict_cache.wr */
	.description = "em_flow_conflict_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3983,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 497,
	.blob_key_bit_size = 77,
	.key_bit_size = 77,
	.key_num_fields = 4,
	.result_start_idx = 743,
	.result_bit_size = 96,
	.result_num_fields = 2
	},
	{ /* class_tid: 2, , table: control.field_sig_validation */
	.description = "control.field_sig_validation",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 4,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3985,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_FLOW_SIG_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_FLOW_SIG_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 2, , table: control.outer_loop_add_check */
	.description = "control.outer_loop_add_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 5,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3987,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: em.egress_generic_template */
	.description = "em.egress_generic_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3989,
		.cond_nums = 4 },
	.tbl_opcode = BNXT_ULP_EM_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 745,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 2, , table: control.em_add_check */
	.description = "control.em_add_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3993,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: wm.egress_generic_template */
	.description = "wm.egress_generic_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_WC_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3994,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 751,
	.result_bit_size = 38,
	.result_num_fields = 5
	},
	{ /* class_tid: 2, , table: control.outer_loop_check */
	.description = "control.outer_loop_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3994,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.reset_outer_loop */
	.description = "control.reset_outer_loop",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3995,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_LOOP }
	},
	{ /* class_tid: 2, , table: control.inner_loop_cal */
	.description = "control.inner_loop_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = -25,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3995,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_INNER_LOOP }
	},
	{ /* class_tid: 3, , table: int_full_act_record.0 */
	.description = "int_full_act_record.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3995,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 756,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 3, , table: port_table.ing_wr_0 */
	.description = "port_table.ing_wr_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3995,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 501,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 773,
	.result_bit_size = 195,
	.result_num_fields = 9
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_rd */
	.description = "l2_cntxt_tcam_cache.ing_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3995,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 502,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 43,
	.ident_nums = 1
	},
	{ /* class_tid: 3, , table: control.ing_0 */
	.description = "control.ing_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3995,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_rd_sock */
	.description = "l2_cntxt_tcam_cache.ing_rd_sock",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3996,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_PHY_PORT_SVIF,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC },
	.key_start_idx = 503,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 44,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.ing_0 */
	.description = "l2_cntxt_tcam.ing_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3997,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC },
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 504,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 782,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 46,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_wr */
	.description = "l2_cntxt_tcam_cache.ing_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4001,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 525,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 788,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: profile_tcam.prof_func_catch_all */
	.description = "profile_tcam.prof_func_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4005,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 5,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 526,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 793,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 48,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: parif_def_arec_ptr.ing_0 */
	.description = "parif_def_arec_ptr.ing_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_DFLT_ACT_REC_PTR,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4005,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_PHY_PORT_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 801,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: parif_def_err_arec_ptr.ing_0 */
	.description = "parif_def_err_arec_ptr.ing_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_ERR_ACT_REC_PTR,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4005,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_PHY_PORT_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 802,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: int_full_act_record.egr_0 */
	.description = "int_full_act_record.egr_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4005,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 803,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 3, , table: port_table.egr_wr_0 */
	.description = "port_table.egr_wr_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4005,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 569,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 820,
	.result_bit_size = 195,
	.result_num_fields = 9
	},
	{ /* class_tid: 3, , table: ilt_tbl.egr */
	.description = "ilt_tbl.egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4005,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 829,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.non_vfr_egr_rd */
	.description = "l2_cntxt_tcam_cache.non_vfr_egr_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4005,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 570,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 48,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: control.non_vfr_egr_2 */
	.description = "control.non_vfr_egr_2",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4005,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.non_vfr_egr_0 */
	.description = "l2_cntxt_tcam.non_vfr_egr_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4006,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 571,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 837,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 48,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: profile_tcam.non_vfr_prof_func_egr_catch_all */
	.description = "profile_tcam.non_vfr_prof_func_egr_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4006,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 5,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 592,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 843,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 50,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.non_vfr_egr_wr */
	.description = "l2_cntxt_tcam_cache.non_vfr_egr_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4006,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 635,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 851,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: tunnel_gparse_cache.def_cust_tun_rd */
	.description = "tunnel_gparse_cache.def_cust_tun_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_GPARSE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 14,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 636,
	.blob_key_bit_size = 8,
	.key_bit_size = 8,
	.key_num_fields = 1,
	.ident_start_idx = 50,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: control.default_custom_tunnel */
	.description = "control.default_custom_tunnel",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4008,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: cust_tunnel.def_conf_vxlan_port */
	.description = "cust_tunnel.def_conf_vxlan_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4009,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 856,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: cust_tunnel.def_conf_vxlan_ip_port */
	.description = "cust_tunnel.def_conf_vxlan_ip_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN_IP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4010,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 857,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: tunnel_gparse_cache.def_cust_tun_wr */
	.description = "tunnel_gparse_cache.def_cust_tun_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_GPARSE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4011,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 637,
	.blob_key_bit_size = 8,
	.key_bit_size = 8,
	.key_num_fields = 1,
	.result_start_idx = 858,
	.result_bit_size = 80,
	.result_num_fields = 3
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_rd */
	.description = "profile_tcam_cache.vfr_glb_act_rec_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4011,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 638,
	.blob_key_bit_size = 15,
	.key_bit_size = 15,
	.key_num_fields = 3,
	.ident_start_idx = 52,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.prof_tcam_cache.vfr_glb_act_rec_rd.0 */
	.description = "control.prof_tcam_cache.vfr_glb_act_rec_rd.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4011,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: mod_record.vf_2_vfr_egr */
	.description = "mod_record.vf_2_vfr_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_ACT_MODIFY_64B,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4012,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_MODIFY_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 861,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 4, , table: int_full_act_record.vf_2_vfr_loopback */
	.description = "int_full_act_record.vf_2_vfr_loopback",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4012,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_LB_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 881,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 4, , table: parif_def_arec_ptr.vf_egr */
	.description = "parif_def_arec_ptr.vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_DFLT_ACT_REC_PTR,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4012,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_CONST,
	.tbl_operand = ULP_THOR_SYM_LOOPBACK_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 898,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 4, , table: parif_def_err_arec_ptr.vf_egr */
	.description = "parif_def_err_arec_ptr.vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_ERR_ACT_REC_PTR,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4012,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_CONST,
	.tbl_operand = ULP_THOR_SYM_LOOPBACK_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 899,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_wr */
	.description = "profile_tcam_cache.vfr_glb_act_rec_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4012,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 641,
	.blob_key_bit_size = 15,
	.key_bit_size = 15,
	.key_num_fields = 3,
	.result_start_idx = 900,
	.result_bit_size = 138,
	.result_num_fields = 7
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_rd_egr */
	.description = "l2_cntxt_tcam_cache.vf_rd_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4012,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 644,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 52,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.vf_2_vfr.0 */
	.description = "control.vf_2_vfr.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4012,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.get_drv_func_prof_func */
	.description = "l2_cntxt_tcam_cache.get_drv_func_prof_func",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4013,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 645,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 52,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vf_egr */
	.description = "l2_cntxt_tcam.vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4013,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 646,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 907,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 53,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: profile_tcam.prof_func_catch_all */
	.description = "profile_tcam.prof_func_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4013,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 5,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 667,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 913,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_egr_wr */
	.description = "l2_cntxt_tcam_cache.vf_egr_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4013,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 710,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 921,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 4, , table: int_full_act_record.vf_2_vfr_ing */
	.description = "int_full_act_record.vf_2_vfr_ing",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4013,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_PUSH_AND_SET_VFR_FLAG,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 926,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_rd */
	.description = "profile_tcam_cache.vfr_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4013,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 711,
	.blob_key_bit_size = 15,
	.key_bit_size = 15,
	.key_num_fields = 3,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.prof_tcam_cache.vfr.0 */
	.description = "control.prof_tcam_cache.vfr.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 10,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4013,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: int_full_act_record.drop_action */
	.description = "int_full_act_record.drop_action",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_DROP_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 943,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vf_2_vfr_ing.0 */
	.description = "l2_cntxt_tcam.vf_2_vfr_ing.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 714,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 960,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vfr_2_vf_ing.0 */
	.description = "l2_cntxt_tcam.vfr_2_vf_ing.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 735,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 966,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: fkb_select.vfr_em */
	.description = "fkb_select.vfr_em",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 972,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 4, , table: fkb_select.vf_em */
	.description = "fkb_select.vf_em",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_1,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 1078,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 4, , table: profile_tcam.vf_2_vfr.0 */
	.description = "profile_tcam.vf_2_vfr.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 756,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 1184,
	.result_bit_size = 33,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: profile_tcam.vfr_2_vf.0 */
	.description = "profile_tcam.vfr_2_vf.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 799,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 1192,
	.result_bit_size = 33,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_wr */
	.description = "profile_tcam_cache.vfr_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 842,
	.blob_key_bit_size = 15,
	.key_bit_size = 15,
	.key_num_fields = 3,
	.result_start_idx = 1200,
	.result_bit_size = 138,
	.result_num_fields = 7
	},
	{ /* class_tid: 4, , table: ilt_tbl.vfr_ing */
	.description = "ilt_tbl.vfr_ing",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_VF_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 1207,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: em.vf_2_vfr.0 */
	.description = "em.vf_2_vfr.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 845,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 3,
	.result_start_idx = 1215,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.rd_egr0 */
	.description = "l2_cntxt_tcam_cache.rd_egr0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4014,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 848,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.0 */
	.description = "control.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4014,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: ilt_tbl.vfr_egr */
	.description = "ilt_tbl.vfr_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4015,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 1221,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vfr_wr_egr0 */
	.description = "l2_cntxt_tcam_cache.vfr_wr_egr0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4015,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 849,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 1229,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 4, , table: ilt_tbl.vf_egr */
	.description = "ilt_tbl.vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4015,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_VF_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 1234,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: mod_record.vfr_2_vf_egr */
	.description = "mod_record.vfr_2_vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_ACT_MODIFY_64B,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4015,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MODIFY_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 1242,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 4, , table: int_full_act_record.vfr_egr */
	.description = "int_full_act_record.vfr_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_VFR_CFA_ACTION,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4015,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 1262,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: int_full_act_record.vfr_2_vf.ing0 */
	.description = "int_full_act_record.vfr_2_vf.ing0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4015,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 1279,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: em.vfr_2_vf.0 */
	.description = "em.vfr_2_vf.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4015,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.key_start_idx = 850,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 2,
	.result_start_idx = 1296,
	.result_bit_size = 0,
	.result_num_fields = 6
	}
};

struct bnxt_ulp_mapper_cond_list_info ulp_thor_class_cond_oper_list[] = {
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:2*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 2,
		.cond_nums = 3
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:2*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 5,
		.cond_nums = 2
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:2*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 7,
		.cond_nums = 3
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_vxlan_port:19*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 19,
		.cond_nums = 2
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_vxlan_ip_port:21*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 21,
		.cond_nums = 2
	},
	/* cond_execute: class_tid: 1, control.check_tunnel_recycle:37*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 37,
		.cond_nums = 3
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:130*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 130,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:130*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 135,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 1, control.tunnel_ipv6_sip_check:140*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 140,
		.cond_nums = 4
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:2032*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2032,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:2032*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2037,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:2042*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2042,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:2042*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2047,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.check_tunnel_recycle:2052*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2052,
		.cond_nums = 2
	},
	/* cond_execute: class_tid: 3, tunnel_gparse_cache.def_cust_tun_rd:4006*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 4006,
		.cond_nums = 2
	}
};

struct bnxt_ulp_mapper_cond_info ulp_thor_class_cond_list[] = {
	/* cond_reject: thor, class_tid: 1 */
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:2*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:2*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:2*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* cond_execute: class_tid: 1, tunnel_gparse_cache.custom_tunnel_rd:10*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, tunnel_gparse_cache.custom_tunnel_rd:12*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, tunnel_gparse_cache.custom_tunnel_rd:14*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* cond_execute: class_tid: 1, control.custom_tunnel:17*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.custom_tunnel_port_check_value:18*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_vxlan_port:19*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DYNAMIC_VXLAN_PORT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_vxlan_ip_port:21*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DYNAMIC_VXLAN_PORT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_geneve_port:23*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DYNAMIC_GENEVE_PORT
	},
	/* field_cond: class_tid: 1, tunnel_gparse_cache.custom_tunnel_wr:24*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, tunnel_gparse_cache.custom_tunnel_wr:26*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* cond_execute: class_tid: 1, control.check_f1_f2_flow:29*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* cond_execute: class_tid: 1, control.tunnel_cache_check:31*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.check_f2_flow:32*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:33*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:35*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_PORT_DMAC
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:36*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_PARENT_DMAC
	},
	/* cond_execute: class_tid: 1, control.check_tunnel_recycle:37*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	/* cond_execute: class_tid: 1, control.multi_tunnel_check:40*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_OUTER_EM_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:42*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:44*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:46*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:48*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:50*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:52*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:54*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:56*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:58*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:60*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:62*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:64*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* cond_execute: class_tid: 1, control.multi_flow_cache_check:66*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:67*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:69*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:71*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:73*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:75*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:77*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:79*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:81*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:83*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:85*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:87*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:89*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:91*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:93*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* cond_execute: class_tid: 1, control.group_id_check:95*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* cond_execute: class_tid: 1, control.flow_chain_group_id:96*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, flow_chain_l2_cntxt.chaining_check:97*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* field_cond: class_tid: 1, flow_chain_l2_cntxt.chaining_check:99*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, flow_chain_l2_cntxt.chaining_check:100*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* cond_execute: class_tid: 1, control.flow_chain_group_l2_cntxt_check:101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.chain_entry:102*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.chain_entry:103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam.chain_entry_dup:104*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.chain_entry_dup:105*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.chain_entry_dup:106*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, flow_chain_l2_cntxt.write:107*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, flow_chain_l2_cntxt.write:108*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* cond_execute: class_tid: 1, mac_addr_cache.rd:109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_O_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:111*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:112*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:113*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:114*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.mac_addr_cache_miss:116*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam.allocate_l2_context:117*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:119*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:120*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam.ingress_entry_dup:121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry_dup:122*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry_dup:123*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:124*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:125*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:126*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:127*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.check_f1_flow:129*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* cond_execute: class_tid: 1, control.tunnel_ipv6_sip_check:140*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* cond_execute: class_tid: 1, profile_tcam_bypass.chain_catch_all:144*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 1, profile_tcam_bypass.chain_catch_all:147*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 1, control.terminating_flow:148*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:151*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:154*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:156*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:158*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* field_cond: class_tid: 1, proto_header_cache.rd:159*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.proto_header_cache_miss:161*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, hdr_overlap_cache.overlap_check:162*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.overlap_miss:164*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:165*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:167*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:169*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:170*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:174*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:178*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:183*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:193*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:198*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:202*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:203*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:207*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:211*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:215*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:219*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:223*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:227*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:231*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:235*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:239*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:243*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:247*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:252*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:256*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:259*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:262*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:266*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:269*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:273*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:276*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:281*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:285*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:290*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:295*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:299*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:303*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:308*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:312*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:317*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:322*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:326*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:330*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:335*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:340*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:344*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:348*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:353*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:358*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:362*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:366*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:371*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:376*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:380*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:384*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:389*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:394*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:398*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:402*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:404*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:407*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:408*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:411*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:413*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:416*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:417*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:420*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:422*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:424*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:425*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, hdr_overlap_cache.overlap_wr:427*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, fkb_select.em_gen_template_alloc:429*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:430*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:432*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:434*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:436*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:438*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:440*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:442*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:444*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:446*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:448*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:450*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:452*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:454*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:456*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:458*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:460*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:462*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:464*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:466*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:468*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:472*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:474*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:476*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:478*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:480*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:482*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:484*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:486*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:488*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:490*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:492*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:494*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:496*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:498*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:500*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:502*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:504*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:506*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:508*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:510*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:514*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:516*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:518*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:520*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:522*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:524*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:526*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:528*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:530*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:532*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:534*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:536*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:538*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:540*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:542*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:544*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:546*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:550*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:552*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:556*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:558*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:560*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:562*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:564*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:566*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:575*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:578*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:579*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:580*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:582*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:584*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:586*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:588*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:590*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:592*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:594*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:596*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:598*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:600*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:602*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:604*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:606*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:608*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:610*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:612*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:614*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:616*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:617*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:618*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:619*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:621*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:623*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:627*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:631*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:633*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:635*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:637*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:639*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:641*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:643*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:645*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:647*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:648*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:650*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:652*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:653*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:655*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:657*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:659*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:661*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:663*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:665*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:667*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:669*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:671*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:673*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:675*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:680*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:683*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:684*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:685*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:687*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:689*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:691*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:693*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:695*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:697*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:699*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:700*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:701*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:705*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:709*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:713*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:717*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:722*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:727*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:732*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:737*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:742*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:747*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:752*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:757*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:761*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:765*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:769*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:770*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:774*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:775*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:779*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:783*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:787*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:791*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:795*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:799*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:803*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:807*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:811*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:815*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:819*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:823*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:827*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:831*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:835*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:839*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:851*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:855*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:860*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:864*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:869*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:873*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:876*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:879*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:882*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:885*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:892*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:896*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:899*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:903*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:906*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:910*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:913*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:918*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:922*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:927*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:936*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:941*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:945*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:949*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:954*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:963*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:967*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:972*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:976*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:981*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:985*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:989*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:992*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:996*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:999*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1003*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1006*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1010*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1013*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1017*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1020*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1024*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1027*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1031*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1034*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1038*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1041*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1045*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1049*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1052*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1055*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1059*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1063*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1066*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1069*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1072*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1075*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1077*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1079*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1083*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1087*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1090*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1093*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1096*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1099*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1107*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1111*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1114*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1117*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1125*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1128*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1131*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1135*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1139*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1142*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1145*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1149*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1153*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1156*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1159*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1161*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1165*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1169*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1172*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1175*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1177*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1181*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1185*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1191*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1193*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1197*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1201*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1207*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1209*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1212*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1216*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1218*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1221*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1223*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1226*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1230*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1232*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1235*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, proto_header_cache.wr:1237*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, em_flow_conflict_cache.rd:1239*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_EM_FOR_TC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DEF_PRIO
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* field_cond: class_tid: 1, em_flow_conflict_cache.rd:1244*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.em_flow_conflict_cache_miss:1246*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1247*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1249*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1251*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1252*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1257*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1261*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1266*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1271*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1276*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1281*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1285*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1289*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1293*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1297*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1301*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1305*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1309*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1313*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1317*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1321*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1325*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1329*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1334*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1338*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1341*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1344*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1349*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1353*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1357*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1360*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1365*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1369*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1374*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1379*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1383*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1387*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1392*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1396*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1400*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1404*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1407*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1410*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1414*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1418*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1421*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1424*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1428*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1432*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1435*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1438*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1442*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1446*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1449*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1452*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1456*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1460*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1463*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1466*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1474*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1477*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1480*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1484*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1488*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1491*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1494*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1495*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1497*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1499*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1501*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1503*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1505*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1507*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1508*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1514*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1519*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1523*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1527*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1532*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1537*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1542*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1547*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1552*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1557*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1562*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1567*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1571*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1575*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1579*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1583*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1587*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1591*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1595*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1599*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1603*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1607*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1611*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1615*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1619*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1623*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1627*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1631*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1635*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1639*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1643*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1647*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1651*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1655*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1659*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1663*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1668*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1672*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1681*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1684*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1687*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1690*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1693*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1698*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1702*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1707*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1711*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1715*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1718*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1722*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1725*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1730*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1734*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1739*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1743*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1748*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1753*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1757*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1761*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1766*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1771*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1775*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1779*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1784*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1788*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1793*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1797*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1801*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1804*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1808*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1811*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1815*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1818*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1822*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1825*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1832*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1836*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1839*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1846*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1850*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1853*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1857*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1864*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1867*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1871*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1875*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1878*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1881*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1885*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1892*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1895*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1899*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1903*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1906*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1909*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1913*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1917*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1920*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1923*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1927*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1934*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1937*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1941*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1945*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1948*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1951*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1955*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1962*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1965*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1969*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1973*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1976*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1979*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1983*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1987*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1990*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1993*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1996*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2000*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2002*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2005*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2012*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2014*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, em_flow_conflict_cache.wr:2017*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.field_sig_validation:2019*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_FLOW_SIG_ID
	},
	/* cond_execute: class_tid: 1, control.outer_loop_add_check:2021*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_ADD
	},
	/* cond_execute: class_tid: 1, em.ingress_generic_template:2023*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_EM_FOR_TC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DEF_PRIO
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* cond_execute: class_tid: 1, control.em_add_check:2028*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL
	},
	/* cond_execute: class_tid: 1, control.outer_loop_check:2029*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* cond_reject: thor, class_tid: 2 */
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:2032*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:2032*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:2042*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:2042*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* cond_execute: class_tid: 2, control.check_tunnel_recycle:2052*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* cond_execute: class_tid: 2, control.multi_tunnel_check:2054*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_OUTER_EM_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2056*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2058*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2060*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2062*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2064*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2066*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2068*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2070*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2072*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2074*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2076*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2078*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2080*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2082*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* cond_execute: class_tid: 2, control.multi_flow_cache_check:2084*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2085*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2087*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2089*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2091*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2093*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2095*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2097*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2099*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2105*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2107*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2111*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, control.terminating_flow:2113*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:2115*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:2117*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:2119*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* cond_execute: class_tid: 2, control.group_id_check:2121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* cond_execute: class_tid: 2, control.flow_chain_group_id:2122*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 2, profile_tcam_bypass.chain_only_flow:2123*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 2, proto_header_cache.rd:2126*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, control.proto_header_cache_miss:2128*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, hdr_overlap_cache.overlap_check:2129*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, control.overlap_miss:2131*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2132*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2136*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2137*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2141*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2145*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2148*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2153*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2158*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2163*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2168*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2172*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2173*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2177*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2181*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2185*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2189*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2193*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2197*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2201*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2205*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2209*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2213*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2217*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2222*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2226*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2229*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2232*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2236*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2239*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2243*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2246*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2251*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2255*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2260*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2265*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2269*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2273*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2278*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2287*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2292*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2296*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2300*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2305*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2310*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2314*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2318*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2323*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2328*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2332*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2336*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2341*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2346*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2350*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2354*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2359*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2364*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2368*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2372*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2374*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2377*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2378*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2381*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2383*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2386*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2387*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2390*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2392*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2394*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2395*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, hdr_overlap_cache.overlap_wr:2397*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, fkb_select.em_gen_template_alloc:2399*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:2400*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:2402*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:2404*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:2406*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:2408*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:2410*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:2412*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:2414*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2416*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2418*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2420*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2422*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2424*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2426*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2428*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2430*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2432*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2434*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2436*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2438*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2440*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2442*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2444*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2446*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2448*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2450*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2452*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2454*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2456*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2458*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2460*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2462*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2464*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2466*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2468*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2472*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2474*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2476*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2478*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2480*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2482*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2484*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2486*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2488*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2490*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2492*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2494*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2496*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2498*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2500*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2502*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2504*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2506*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2508*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2510*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2514*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2516*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2518*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2520*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2522*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2524*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2526*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2528*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2530*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2532*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2534*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2536*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2539*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2542*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2545*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2549*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2550*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2552*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2556*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2558*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2560*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2562*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2564*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2566*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2568*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2570*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2574*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2576*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2578*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2580*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2582*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2584*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2586*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2587*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2588*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2589*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2591*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2593*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2595*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2597*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2599*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2601*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2603*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2605*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2607*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2609*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2611*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2613*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2615*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2617*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2618*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2620*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2622*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2623*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2627*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2631*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2633*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2635*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2637*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2639*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2641*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2643*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2645*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2647*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2650*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2653*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2654*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2655*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2657*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2659*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2661*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2663*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2665*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2667*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2668*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2669*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2673*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2681*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2684*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2688*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2691*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2696*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2701*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2706*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2711*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2716*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2721*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2726*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2731*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2735*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2739*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2743*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2744*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2748*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2749*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2753*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2757*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2761*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2765*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2769*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2773*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2777*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2781*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2785*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2789*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2793*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2797*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2801*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2805*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2809*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2813*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2817*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2821*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2825*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2834*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2838*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2850*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2853*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2856*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2859*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2863*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2866*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2870*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2873*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2877*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2880*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2884*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2887*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2892*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2896*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2901*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2905*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2910*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2915*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2919*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2923*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2928*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2933*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2937*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2941*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2946*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2950*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2955*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2963*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2966*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2970*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2973*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2977*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2980*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2984*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2987*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2991*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2994*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2998*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3001*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3005*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3012*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3015*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3019*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3023*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3026*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3029*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3033*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3037*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3040*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3043*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3046*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3049*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3051*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3053*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3057*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3061*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3064*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3067*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3070*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3073*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3075*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3077*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3081*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3085*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3088*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3091*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3095*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3099*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3102*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3105*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3113*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3116*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3119*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3123*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3127*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3133*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3135*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3139*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3143*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3146*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3149*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3151*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3155*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3159*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3162*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3165*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3167*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3171*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3175*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3178*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3181*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3183*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3186*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3190*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3192*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3195*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3197*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3200*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3206*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3209*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, proto_header_cache.wr:3211*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, em_flow_conflict_cache.rd:3213*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_EM_FOR_TC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DEF_PRIO
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* field_cond: class_tid: 2, em_flow_conflict_cache.rd:3218*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, control.em_flow_conflict_cache_miss:3220*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3221*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3223*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3225*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3226*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3230*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3234*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3239*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3244*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3249*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3254*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3258*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3262*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3266*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3270*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3274*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3278*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3286*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3290*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3294*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3298*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3302*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3307*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3311*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3314*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3317*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3321*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3324*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3328*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3331*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3336*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3340*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3345*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3350*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3354*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3358*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3363*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3367*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3371*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3375*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3378*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3381*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3385*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3389*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3392*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3395*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3399*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3403*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3406*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3409*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3413*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3417*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3420*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3423*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3427*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3431*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3434*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3437*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3441*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3445*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3448*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3451*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3455*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3459*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3462*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3465*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3467*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:3469*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3471*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3473*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3475*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3477*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3479*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3480*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3481*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3485*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3489*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3493*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3497*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3502*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3507*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3517*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3522*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3527*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3532*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3537*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3541*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3545*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3549*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3553*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3557*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3561*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3565*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3573*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3577*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3581*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3585*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3589*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3593*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3597*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3601*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3605*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3609*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3613*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3617*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3621*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3633*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3638*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3642*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3647*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3651*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3654*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3657*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3660*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3663*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3667*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3670*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3674*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3681*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3684*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3688*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3691*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3696*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3700*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3705*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3709*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3714*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3719*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3723*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3727*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3732*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3737*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3741*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3745*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3750*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3754*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3759*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3763*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3767*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3770*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3774*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3777*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3781*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3784*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3788*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3791*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3795*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3798*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3802*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3805*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3809*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3812*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3816*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3819*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3823*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3827*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3830*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3833*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3837*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3841*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3844*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3851*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3855*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3858*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3865*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3869*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3872*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3875*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3879*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3883*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3886*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3893*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3897*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3900*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3903*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3907*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3911*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3914*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3917*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3921*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3925*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3928*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3935*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3939*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3942*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3945*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3949*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3953*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3956*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3962*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3966*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3968*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3971*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3974*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3978*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3980*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, em_flow_conflict_cache.wr:3983*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, control.field_sig_validation:3985*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_FLOW_SIG_ID
	},
	/* cond_execute: class_tid: 2, control.outer_loop_add_check:3987*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_ADD
	},
	/* cond_execute: class_tid: 2, em.egress_generic_template:3989*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DEF_PRIO
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* cond_execute: class_tid: 2, control.em_add_check:3993*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL
	},
	/* cond_execute: class_tid: 2, control.outer_loop_check:3994*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* cond_execute: class_tid: 3, control.ing_0:3995*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, l2_cntxt_tcam_cache.ing_rd_sock:3996*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 3, l2_cntxt_tcam.ing_0:3997*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* field_cond: class_tid: 3, l2_cntxt_tcam.ing_0:3999*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* field_cond: class_tid: 3, l2_cntxt_tcam_cache.ing_wr:4001*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* field_cond: class_tid: 3, l2_cntxt_tcam_cache.ing_wr:4003*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* cond_execute: class_tid: 3, control.non_vfr_egr_2:4005*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, tunnel_gparse_cache.def_cust_tun_rd:4006*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_STATIC_VXLAN_PORT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_STATIC_VXLAN_IP_PORT
	},
	/* cond_execute: class_tid: 3, control.default_custom_tunnel:4008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, cust_tunnel.def_conf_vxlan_port:4009*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_STATIC_VXLAN_PORT
	},
	/* cond_execute: class_tid: 3, cust_tunnel.def_conf_vxlan_ip_port:4010*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_STATIC_VXLAN_IP_PORT
	},
	/* cond_execute: class_tid: 4, control.prof_tcam_cache.vfr_glb_act_rec_rd.0:4011*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.vf_2_vfr.0:4012*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.prof_tcam_cache.vfr.0:4013*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.0:4014*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	}
};

struct bnxt_ulp_mapper_key_info ulp_thor_class_key_info_list[] = {
	/* class_tid: 1, , table: port_table.rd */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_gparse_cache.custom_tunnel_rd */
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(12 >> 8) & 0xff,
			12 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT
		}
	},
	/* class_tid: 1, , table: tunnel_gparse_cache.custom_tunnel_wr */
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(24 >> 8) & 0xff,
			24 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(1 >> 8) & 0xff,
		1 & 0xff}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_cache.f1_f2_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_TUNNEL_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_TUNNEL_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_cache.f1_f2_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_TUNNEL_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_TUNNEL_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: multi_flow_tunnel_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_HDR_BIT,
		.field_opr1 = {
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 56) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 48) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 40) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 32) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 24) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 16) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 8) & 0xff,
		(uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(42 >> 8) & 0xff,
			42 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(44 >> 8) & 0xff,
			44 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(46 >> 8) & 0xff,
			46 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(48 >> 8) & 0xff,
			48 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(50 >> 8) & 0xff,
			50 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(52 >> 8) & 0xff,
			52 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(54 >> 8) & 0xff,
			54 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(56 >> 8) & 0xff,
			56 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(58 >> 8) & 0xff,
			58 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(60 >> 8) & 0xff,
			60 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(62 >> 8) & 0xff,
			62 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(64 >> 8) & 0xff,
			64 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: multi_flow_tunnel_cache.wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_HDR_BIT,
		.field_opr1 = {
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 56) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 48) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 40) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 32) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 24) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 16) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 8) & 0xff,
		(uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(67 >> 8) & 0xff,
			67 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(69 >> 8) & 0xff,
			69 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(71 >> 8) & 0xff,
			71 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(73 >> 8) & 0xff,
			73 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(75 >> 8) & 0xff,
			75 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(77 >> 8) & 0xff,
			77 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(79 >> 8) & 0xff,
			79 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(81 >> 8) & 0xff,
			81 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(83 >> 8) & 0xff,
			83 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(85 >> 8) & 0xff,
			85 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(87 >> 8) & 0xff,
			87 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(89 >> 8) & 0xff,
			89 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(91 >> 8) & 0xff,
			91 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(93 >> 8) & 0xff,
			93 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: flow_chain_cache.group_check */
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: flow_chain_cache.write */
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: flow_chain_l2_cntxt.chaining_check */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(99 >> 8) & 0xff,
			99 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(100 >> 8) & 0xff,
			100 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.chain_entry */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL_MASK >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(102 >> 8) & 0xff,
			102 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(103 >> 8) & 0xff,
			103 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.chain_entry_dup */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL_MASK >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_SOCKET_DIRECT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_SOCKET_DIRECT_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(105 >> 8) & 0xff,
			105 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(106 >> 8) & 0xff,
			106 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: flow_chain_l2_cntxt.write */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(107 >> 8) & 0xff,
			107 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(108 >> 8) & 0xff,
			108 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 1, , table: mac_addr_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(111 >> 8) & 0xff,
			111 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(112 >> 8) & 0xff,
			112 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(113 >> 8) & 0xff,
			113 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(114 >> 8) & 0xff,
			114 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_filter_id",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_filter_id",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL_MASK >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(119 >> 8) & 0xff,
			119 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(120 >> 8) & 0xff,
			120 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		3}
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry_dup */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL_MASK >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_SOCKET_DIRECT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_SOCKET_DIRECT_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(122 >> 8) & 0xff,
			122 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(123 >> 8) & 0xff,
			123 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		3}
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: mac_addr_cache.wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(124 >> 8) & 0xff,
			124 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(125 >> 8) & 0xff,
			125 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(126 >> 8) & 0xff,
			126 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(127 >> 8) & 0xff,
			127 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_filter_id",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_filter_id",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: profile_tcam_bypass.chain_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(147 >> 8) & 0xff,
			147 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: proto_header_cache.rd */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(159 >> 8) & 0xff,
			159 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(162 >> 8) & 0xff,
			162 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(427 >> 8) & 0xff,
			427 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: profile_tcam.gen_template */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(446 >> 8) & 0xff,
			446 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(59 >> 8) & 0xff,
		59 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(454 >> 8) & 0xff,
			454 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(62 >> 8) & 0xff,
		62 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(462 >> 8) & 0xff,
			462 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(65 >> 8) & 0xff,
		65 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(470 >> 8) & 0xff,
			470 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(68 >> 8) & 0xff,
		68 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(478 >> 8) & 0xff,
			478 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(71 >> 8) & 0xff,
		71 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(486 >> 8) & 0xff,
			486 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(74 >> 8) & 0xff,
		74 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(494 >> 8) & 0xff,
			494 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(77 >> 8) & 0xff,
		77 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(502 >> 8) & 0xff,
			502 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(80 >> 8) & 0xff,
		80 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(510 >> 8) & 0xff,
			510 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(83 >> 8) & 0xff,
		83 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(518 >> 8) & 0xff,
			518 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(86 >> 8) & 0xff,
		86 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(526 >> 8) & 0xff,
			526 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(89 >> 8) & 0xff,
		89 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(534 >> 8) & 0xff,
			534 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(92 >> 8) & 0xff,
		92 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(542 >> 8) & 0xff,
			542 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(95 >> 8) & 0xff,
		95 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(550 >> 8) & 0xff,
			550 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(98 >> 8) & 0xff,
		98 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(558 >> 8) & 0xff,
			558 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(101 >> 8) & 0xff,
		101 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(566 >> 8) & 0xff,
			566 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(104 >> 8) & 0xff,
		104 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(572 >> 8) & 0xff,
			572 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(105 >> 8) & 0xff,
		105 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(578 >> 8) & 0xff,
			578 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(579 >> 8) & 0xff,
			579 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(580 >> 8) & 0xff,
			580 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(106 >> 8) & 0xff,
		106 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(584 >> 8) & 0xff,
			584 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(107 >> 8) & 0xff,
		107 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(588 >> 8) & 0xff,
			588 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(108 >> 8) & 0xff,
		108 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(592 >> 8) & 0xff,
			592 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(109 >> 8) & 0xff,
		109 & 0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(604 >> 8) & 0xff,
			604 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(114 >> 8) & 0xff,
		114 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(616 >> 8) & 0xff,
			616 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(617 >> 8) & 0xff,
			617 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(618 >> 8) & 0xff,
			618 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(619 >> 8) & 0xff,
			619 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(119 >> 8) & 0xff,
		119 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(623 >> 8) & 0xff,
			623 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(120 >> 8) & 0xff,
		120 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(627 >> 8) & 0xff,
			627 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(121 >> 8) & 0xff,
		121 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(631 >> 8) & 0xff,
			631 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(122 >> 8) & 0xff,
		122 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(635 >> 8) & 0xff,
			635 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(123 >> 8) & 0xff,
		123 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(639 >> 8) & 0xff,
			639 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(124 >> 8) & 0xff,
		124 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(643 >> 8) & 0xff,
			643 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(125 >> 8) & 0xff,
		125 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(648 >> 8) & 0xff,
			648 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(127 >> 8) & 0xff,
		127 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(653 >> 8) & 0xff,
			653 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(129 >> 8) & 0xff,
		129 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(657 >> 8) & 0xff,
			657 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(130 >> 8) & 0xff,
		130 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(661 >> 8) & 0xff,
			661 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(131 >> 8) & 0xff,
		131 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(665 >> 8) & 0xff,
			665 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(132 >> 8) & 0xff,
		132 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(669 >> 8) & 0xff,
			669 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(133 >> 8) & 0xff,
		133 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(673 >> 8) & 0xff,
			673 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(134 >> 8) & 0xff,
		134 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(677 >> 8) & 0xff,
			677 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(680 >> 8) & 0xff,
			680 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(683 >> 8) & 0xff,
			683 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(684 >> 8) & 0xff,
			684 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(685 >> 8) & 0xff,
			685 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(135 >> 8) & 0xff,
		135 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(689 >> 8) & 0xff,
			689 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: wm_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(691 >> 8) & 0xff,
			691 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(693 >> 8) & 0xff,
			693 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(695 >> 8) & 0xff,
			695 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(697 >> 8) & 0xff,
			697 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(699 >> 8) & 0xff,
			699 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(700 >> 8) & 0xff,
			700 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(701 >> 8) & 0xff,
			701 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(705 >> 8) & 0xff,
			705 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(709 >> 8) & 0xff,
			709 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(713 >> 8) & 0xff,
			713 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(717 >> 8) & 0xff,
			717 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(722 >> 8) & 0xff,
			722 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(727 >> 8) & 0xff,
			727 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(136 >> 8) & 0xff,
		136 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(737 >> 8) & 0xff,
			737 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(137 >> 8) & 0xff,
		137 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(747 >> 8) & 0xff,
			747 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(752 >> 8) & 0xff,
			752 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(757 >> 8) & 0xff,
			757 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(761 >> 8) & 0xff,
			761 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(765 >> 8) & 0xff,
			765 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(138 >> 8) & 0xff,
		138 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(770 >> 8) & 0xff,
			770 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(139 >> 8) & 0xff,
		139 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(775 >> 8) & 0xff,
			775 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(779 >> 8) & 0xff,
			779 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(783 >> 8) & 0xff,
			783 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(787 >> 8) & 0xff,
			787 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(791 >> 8) & 0xff,
			791 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(140 >> 8) & 0xff,
		140 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(799 >> 8) & 0xff,
			799 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(141 >> 8) & 0xff,
		141 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(807 >> 8) & 0xff,
			807 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(142 >> 8) & 0xff,
		142 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(815 >> 8) & 0xff,
			815 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(143 >> 8) & 0xff,
		143 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(823 >> 8) & 0xff,
			823 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(144 >> 8) & 0xff,
		144 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(831 >> 8) & 0xff,
			831 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(145 >> 8) & 0xff,
		145 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(839 >> 8) & 0xff,
			839 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(146 >> 8) & 0xff,
		146 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(847 >> 8) & 0xff,
			847 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(147 >> 8) & 0xff,
		147 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(855 >> 8) & 0xff,
			855 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(148 >> 8) & 0xff,
		148 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(864 >> 8) & 0xff,
			864 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(149 >> 8) & 0xff,
		149 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(873 >> 8) & 0xff,
			873 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(150 >> 8) & 0xff,
		150 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(879 >> 8) & 0xff,
			879 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(151 >> 8) & 0xff,
		151 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(885 >> 8) & 0xff,
			885 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(152 >> 8) & 0xff,
		152 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(892 >> 8) & 0xff,
			892 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(153 >> 8) & 0xff,
		153 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(899 >> 8) & 0xff,
			899 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(154 >> 8) & 0xff,
		154 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(906 >> 8) & 0xff,
			906 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(155 >> 8) & 0xff,
		155 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(913 >> 8) & 0xff,
			913 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(156 >> 8) & 0xff,
		156 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(922 >> 8) & 0xff,
			922 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(157 >> 8) & 0xff,
		157 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(931 >> 8) & 0xff,
			931 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(158 >> 8) & 0xff,
		158 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(949 >> 8) & 0xff,
			949 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(161 >> 8) & 0xff,
		161 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(967 >> 8) & 0xff,
			967 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(164 >> 8) & 0xff,
		164 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(976 >> 8) & 0xff,
			976 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(165 >> 8) & 0xff,
		165 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(985 >> 8) & 0xff,
			985 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(166 >> 8) & 0xff,
		166 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(992 >> 8) & 0xff,
			992 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(167 >> 8) & 0xff,
		167 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(999 >> 8) & 0xff,
			999 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(168 >> 8) & 0xff,
		168 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1006 >> 8) & 0xff,
			1006 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(169 >> 8) & 0xff,
		169 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1013 >> 8) & 0xff,
			1013 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(170 >> 8) & 0xff,
		170 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1020 >> 8) & 0xff,
			1020 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(171 >> 8) & 0xff,
		171 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1027 >> 8) & 0xff,
			1027 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(172 >> 8) & 0xff,
		172 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1034 >> 8) & 0xff,
			1034 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(173 >> 8) & 0xff,
		173 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1041 >> 8) & 0xff,
			1041 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(174 >> 8) & 0xff,
		174 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1055 >> 8) & 0xff,
			1055 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(177 >> 8) & 0xff,
		177 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1069 >> 8) & 0xff,
			1069 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(180 >> 8) & 0xff,
		180 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1093 >> 8) & 0xff,
			1093 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(187 >> 8) & 0xff,
		187 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1117 >> 8) & 0xff,
			1117 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(194 >> 8) & 0xff,
		194 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1131 >> 8) & 0xff,
			1131 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(197 >> 8) & 0xff,
		197 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1145 >> 8) & 0xff,
			1145 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(200 >> 8) & 0xff,
		200 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1161 >> 8) & 0xff,
			1161 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(204 >> 8) & 0xff,
		204 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1177 >> 8) & 0xff,
			1177 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(208 >> 8) & 0xff,
		208 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1193 >> 8) & 0xff,
			1193 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(212 >> 8) & 0xff,
		212 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1209 >> 8) & 0xff,
			1209 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(216 >> 8) & 0xff,
		216 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1223 >> 8) & 0xff,
			1223 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(220 >> 8) & 0xff,
		220 & 0xff}
		}
	},
	/* class_tid: 1, , table: proto_header_cache.wr */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1237 >> 8) & 0xff,
			1237 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: em_flow_conflict_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1244 >> 8) & 0xff,
			1244 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: em_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1499 >> 8) & 0xff,
			1499 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1501 >> 8) & 0xff,
			1501 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1503 >> 8) & 0xff,
			1503 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1505 >> 8) & 0xff,
			1505 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1507 >> 8) & 0xff,
			1507 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1508 >> 8) & 0xff,
			1508 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1509 >> 8) & 0xff,
			1509 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1514 >> 8) & 0xff,
			1514 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1519 >> 8) & 0xff,
			1519 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1523 >> 8) & 0xff,
			1523 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1527 >> 8) & 0xff,
			1527 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1532 >> 8) & 0xff,
			1532 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1537 >> 8) & 0xff,
			1537 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(263 >> 8) & 0xff,
		263 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1547 >> 8) & 0xff,
			1547 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(264 >> 8) & 0xff,
		264 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1557 >> 8) & 0xff,
			1557 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1562 >> 8) & 0xff,
			1562 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1567 >> 8) & 0xff,
			1567 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1571 >> 8) & 0xff,
			1571 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1575 >> 8) & 0xff,
			1575 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1579 >> 8) & 0xff,
			1579 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1583 >> 8) & 0xff,
			1583 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1587 >> 8) & 0xff,
			1587 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1591 >> 8) & 0xff,
			1591 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1595 >> 8) & 0xff,
			1595 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1599 >> 8) & 0xff,
			1599 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(265 >> 8) & 0xff,
		265 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1607 >> 8) & 0xff,
			1607 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(266 >> 8) & 0xff,
		266 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1615 >> 8) & 0xff,
			1615 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(267 >> 8) & 0xff,
		267 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1623 >> 8) & 0xff,
			1623 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(268 >> 8) & 0xff,
		268 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1631 >> 8) & 0xff,
			1631 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(269 >> 8) & 0xff,
		269 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1639 >> 8) & 0xff,
			1639 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(270 >> 8) & 0xff,
		270 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1647 >> 8) & 0xff,
			1647 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(271 >> 8) & 0xff,
		271 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1655 >> 8) & 0xff,
			1655 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(272 >> 8) & 0xff,
		272 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1663 >> 8) & 0xff,
			1663 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(273 >> 8) & 0xff,
		273 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1672 >> 8) & 0xff,
			1672 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(274 >> 8) & 0xff,
		274 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1681 >> 8) & 0xff,
			1681 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(275 >> 8) & 0xff,
		275 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1687 >> 8) & 0xff,
			1687 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(276 >> 8) & 0xff,
		276 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1693 >> 8) & 0xff,
			1693 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(277 >> 8) & 0xff,
		277 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1702 >> 8) & 0xff,
			1702 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(278 >> 8) & 0xff,
		278 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1711 >> 8) & 0xff,
			1711 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(279 >> 8) & 0xff,
		279 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1718 >> 8) & 0xff,
			1718 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(280 >> 8) & 0xff,
		280 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1725 >> 8) & 0xff,
			1725 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(281 >> 8) & 0xff,
		281 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1734 >> 8) & 0xff,
			1734 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(282 >> 8) & 0xff,
		282 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1743 >> 8) & 0xff,
			1743 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(283 >> 8) & 0xff,
		283 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1761 >> 8) & 0xff,
			1761 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(286 >> 8) & 0xff,
		286 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1779 >> 8) & 0xff,
			1779 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(289 >> 8) & 0xff,
		289 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1788 >> 8) & 0xff,
			1788 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(290 >> 8) & 0xff,
		290 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1797 >> 8) & 0xff,
			1797 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(291 >> 8) & 0xff,
		291 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1804 >> 8) & 0xff,
			1804 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(292 >> 8) & 0xff,
		292 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1811 >> 8) & 0xff,
			1811 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(293 >> 8) & 0xff,
		293 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1818 >> 8) & 0xff,
			1818 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(294 >> 8) & 0xff,
		294 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1825 >> 8) & 0xff,
			1825 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(295 >> 8) & 0xff,
		295 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1832 >> 8) & 0xff,
			1832 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(296 >> 8) & 0xff,
		296 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1839 >> 8) & 0xff,
			1839 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(297 >> 8) & 0xff,
		297 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1846 >> 8) & 0xff,
			1846 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(298 >> 8) & 0xff,
		298 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1853 >> 8) & 0xff,
			1853 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(299 >> 8) & 0xff,
		299 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1867 >> 8) & 0xff,
			1867 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(302 >> 8) & 0xff,
		302 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1881 >> 8) & 0xff,
			1881 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(305 >> 8) & 0xff,
		305 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1895 >> 8) & 0xff,
			1895 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(308 >> 8) & 0xff,
		308 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1909 >> 8) & 0xff,
			1909 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(311 >> 8) & 0xff,
		311 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1923 >> 8) & 0xff,
			1923 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(314 >> 8) & 0xff,
		314 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1937 >> 8) & 0xff,
			1937 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(317 >> 8) & 0xff,
		317 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1951 >> 8) & 0xff,
			1951 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(320 >> 8) & 0xff,
		320 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1965 >> 8) & 0xff,
			1965 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(323 >> 8) & 0xff,
		323 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1979 >> 8) & 0xff,
			1979 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(326 >> 8) & 0xff,
		326 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1993 >> 8) & 0xff,
			1993 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(329 >> 8) & 0xff,
		329 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2005 >> 8) & 0xff,
			2005 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(332 >> 8) & 0xff,
		332 & 0xff}
		}
	},
	/* class_tid: 1, , table: em_flow_conflict_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2017 >> 8) & 0xff,
			2017 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: l2_cntxt_tcam_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 2, , table: multi_flow_tunnel_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_HDR_BIT,
		.field_opr1 = {
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 56) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 48) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 40) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 32) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 24) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 16) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 8) & 0xff,
		(uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2056 >> 8) & 0xff,
			2056 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2058 >> 8) & 0xff,
			2058 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2060 >> 8) & 0xff,
			2060 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2062 >> 8) & 0xff,
			2062 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2064 >> 8) & 0xff,
			2064 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2066 >> 8) & 0xff,
			2066 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2068 >> 8) & 0xff,
			2068 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2070 >> 8) & 0xff,
			2070 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2072 >> 8) & 0xff,
			2072 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2074 >> 8) & 0xff,
			2074 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2076 >> 8) & 0xff,
			2076 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2078 >> 8) & 0xff,
			2078 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2080 >> 8) & 0xff,
			2080 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2082 >> 8) & 0xff,
			2082 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 2, , table: multi_flow_tunnel_cache.wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_HDR_BIT,
		.field_opr1 = {
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 56) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 48) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 40) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 32) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 24) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 16) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 8) & 0xff,
		(uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2085 >> 8) & 0xff,
			2085 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2087 >> 8) & 0xff,
			2087 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2089 >> 8) & 0xff,
			2089 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2091 >> 8) & 0xff,
			2091 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2093 >> 8) & 0xff,
			2093 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2095 >> 8) & 0xff,
			2095 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2097 >> 8) & 0xff,
			2097 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2099 >> 8) & 0xff,
			2099 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2101 >> 8) & 0xff,
			2101 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2103 >> 8) & 0xff,
			2103 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2105 >> 8) & 0xff,
			2105 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2107 >> 8) & 0xff,
			2107 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2109 >> 8) & 0xff,
			2109 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2111 >> 8) & 0xff,
			2111 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 2, , table: flow_chain_cache.group_check */
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff}
		}
	},
	/* class_tid: 2, , table: flow_chain_cache.write */
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff}
		}
	},
	/* class_tid: 2, , table: profile_tcam_bypass.chain_only_flow */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 2, , table: proto_header_cache.rd */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2126 >> 8) & 0xff,
			2126 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2129 >> 8) & 0xff,
			2129 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2397 >> 8) & 0xff,
			2397 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: profile_tcam.gen_template */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2416 >> 8) & 0xff,
			2416 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(389 >> 8) & 0xff,
		389 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2424 >> 8) & 0xff,
			2424 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(392 >> 8) & 0xff,
		392 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2432 >> 8) & 0xff,
			2432 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(395 >> 8) & 0xff,
		395 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2440 >> 8) & 0xff,
			2440 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(398 >> 8) & 0xff,
		398 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2448 >> 8) & 0xff,
			2448 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(401 >> 8) & 0xff,
		401 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2456 >> 8) & 0xff,
			2456 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(404 >> 8) & 0xff,
		404 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2464 >> 8) & 0xff,
			2464 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(407 >> 8) & 0xff,
		407 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2472 >> 8) & 0xff,
			2472 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(410 >> 8) & 0xff,
		410 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2480 >> 8) & 0xff,
			2480 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(413 >> 8) & 0xff,
		413 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2488 >> 8) & 0xff,
			2488 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(416 >> 8) & 0xff,
		416 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2496 >> 8) & 0xff,
			2496 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(419 >> 8) & 0xff,
		419 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2504 >> 8) & 0xff,
			2504 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(422 >> 8) & 0xff,
		422 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2512 >> 8) & 0xff,
			2512 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(425 >> 8) & 0xff,
		425 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2520 >> 8) & 0xff,
			2520 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(428 >> 8) & 0xff,
		428 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2528 >> 8) & 0xff,
			2528 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(431 >> 8) & 0xff,
		431 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2536 >> 8) & 0xff,
			2536 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(434 >> 8) & 0xff,
		434 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2542 >> 8) & 0xff,
			2542 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(435 >> 8) & 0xff,
		435 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2548 >> 8) & 0xff,
			2548 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2549 >> 8) & 0xff,
			2549 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2550 >> 8) & 0xff,
			2550 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(436 >> 8) & 0xff,
		436 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2554 >> 8) & 0xff,
			2554 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(437 >> 8) & 0xff,
		437 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2558 >> 8) & 0xff,
			2558 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(438 >> 8) & 0xff,
		438 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2562 >> 8) & 0xff,
			2562 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(439 >> 8) & 0xff,
		439 & 0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2574 >> 8) & 0xff,
			2574 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(444 >> 8) & 0xff,
		444 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2586 >> 8) & 0xff,
			2586 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2587 >> 8) & 0xff,
			2587 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2588 >> 8) & 0xff,
			2588 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2589 >> 8) & 0xff,
			2589 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(449 >> 8) & 0xff,
		449 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2593 >> 8) & 0xff,
			2593 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(450 >> 8) & 0xff,
		450 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2597 >> 8) & 0xff,
			2597 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(451 >> 8) & 0xff,
		451 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2601 >> 8) & 0xff,
			2601 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(452 >> 8) & 0xff,
		452 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2605 >> 8) & 0xff,
			2605 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(453 >> 8) & 0xff,
		453 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2609 >> 8) & 0xff,
			2609 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(454 >> 8) & 0xff,
		454 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2613 >> 8) & 0xff,
			2613 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(455 >> 8) & 0xff,
		455 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2618 >> 8) & 0xff,
			2618 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(457 >> 8) & 0xff,
		457 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2623 >> 8) & 0xff,
			2623 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(459 >> 8) & 0xff,
		459 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2627 >> 8) & 0xff,
			2627 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(460 >> 8) & 0xff,
		460 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2631 >> 8) & 0xff,
			2631 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(461 >> 8) & 0xff,
		461 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2635 >> 8) & 0xff,
			2635 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(462 >> 8) & 0xff,
		462 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2639 >> 8) & 0xff,
			2639 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(463 >> 8) & 0xff,
		463 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2643 >> 8) & 0xff,
			2643 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(464 >> 8) & 0xff,
		464 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2647 >> 8) & 0xff,
			2647 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2650 >> 8) & 0xff,
			2650 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2653 >> 8) & 0xff,
			2653 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2654 >> 8) & 0xff,
			2654 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2655 >> 8) & 0xff,
			2655 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2657 >> 8) & 0xff,
			2657 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 2, , table: wm_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2659 >> 8) & 0xff,
			2659 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2661 >> 8) & 0xff,
			2661 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2663 >> 8) & 0xff,
			2663 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2665 >> 8) & 0xff,
			2665 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2667 >> 8) & 0xff,
			2667 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2668 >> 8) & 0xff,
			2668 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2669 >> 8) & 0xff,
			2669 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2673 >> 8) & 0xff,
			2673 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2677 >> 8) & 0xff,
			2677 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(465 >> 8) & 0xff,
		465 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2684 >> 8) & 0xff,
			2684 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(466 >> 8) & 0xff,
		466 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2691 >> 8) & 0xff,
			2691 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2696 >> 8) & 0xff,
			2696 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2701 >> 8) & 0xff,
			2701 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(467 >> 8) & 0xff,
		467 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2711 >> 8) & 0xff,
			2711 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(468 >> 8) & 0xff,
		468 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2721 >> 8) & 0xff,
			2721 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2726 >> 8) & 0xff,
			2726 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2731 >> 8) & 0xff,
			2731 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2735 >> 8) & 0xff,
			2735 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2739 >> 8) & 0xff,
			2739 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(469 >> 8) & 0xff,
		469 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2744 >> 8) & 0xff,
			2744 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(470 >> 8) & 0xff,
		470 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2749 >> 8) & 0xff,
			2749 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2753 >> 8) & 0xff,
			2753 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2757 >> 8) & 0xff,
			2757 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2761 >> 8) & 0xff,
			2761 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2765 >> 8) & 0xff,
			2765 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(471 >> 8) & 0xff,
		471 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2773 >> 8) & 0xff,
			2773 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(472 >> 8) & 0xff,
		472 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2781 >> 8) & 0xff,
			2781 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(473 >> 8) & 0xff,
		473 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2789 >> 8) & 0xff,
			2789 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(474 >> 8) & 0xff,
		474 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2797 >> 8) & 0xff,
			2797 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(475 >> 8) & 0xff,
		475 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2805 >> 8) & 0xff,
			2805 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(476 >> 8) & 0xff,
		476 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2813 >> 8) & 0xff,
			2813 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(477 >> 8) & 0xff,
		477 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2821 >> 8) & 0xff,
			2821 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(478 >> 8) & 0xff,
		478 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2829 >> 8) & 0xff,
			2829 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(479 >> 8) & 0xff,
		479 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2838 >> 8) & 0xff,
			2838 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(480 >> 8) & 0xff,
		480 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2847 >> 8) & 0xff,
			2847 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(481 >> 8) & 0xff,
		481 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2853 >> 8) & 0xff,
			2853 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(482 >> 8) & 0xff,
		482 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2859 >> 8) & 0xff,
			2859 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(483 >> 8) & 0xff,
		483 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2866 >> 8) & 0xff,
			2866 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(484 >> 8) & 0xff,
		484 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2873 >> 8) & 0xff,
			2873 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(485 >> 8) & 0xff,
		485 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2880 >> 8) & 0xff,
			2880 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(486 >> 8) & 0xff,
		486 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2887 >> 8) & 0xff,
			2887 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(487 >> 8) & 0xff,
		487 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2896 >> 8) & 0xff,
			2896 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(488 >> 8) & 0xff,
		488 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2905 >> 8) & 0xff,
			2905 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(489 >> 8) & 0xff,
		489 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2923 >> 8) & 0xff,
			2923 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(492 >> 8) & 0xff,
		492 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2941 >> 8) & 0xff,
			2941 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(495 >> 8) & 0xff,
		495 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2950 >> 8) & 0xff,
			2950 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(496 >> 8) & 0xff,
		496 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2959 >> 8) & 0xff,
			2959 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(497 >> 8) & 0xff,
		497 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2966 >> 8) & 0xff,
			2966 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(498 >> 8) & 0xff,
		498 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2973 >> 8) & 0xff,
			2973 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(499 >> 8) & 0xff,
		499 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2980 >> 8) & 0xff,
			2980 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(500 >> 8) & 0xff,
		500 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2987 >> 8) & 0xff,
			2987 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(501 >> 8) & 0xff,
		501 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2994 >> 8) & 0xff,
			2994 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(502 >> 8) & 0xff,
		502 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3001 >> 8) & 0xff,
			3001 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(503 >> 8) & 0xff,
		503 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3008 >> 8) & 0xff,
			3008 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(504 >> 8) & 0xff,
		504 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3015 >> 8) & 0xff,
			3015 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(505 >> 8) & 0xff,
		505 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3029 >> 8) & 0xff,
			3029 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(508 >> 8) & 0xff,
		508 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3043 >> 8) & 0xff,
			3043 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(511 >> 8) & 0xff,
		511 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3067 >> 8) & 0xff,
			3067 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(518 >> 8) & 0xff,
		518 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3091 >> 8) & 0xff,
			3091 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(525 >> 8) & 0xff,
		525 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3105 >> 8) & 0xff,
			3105 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(528 >> 8) & 0xff,
		528 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3119 >> 8) & 0xff,
			3119 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(531 >> 8) & 0xff,
		531 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3135 >> 8) & 0xff,
			3135 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(535 >> 8) & 0xff,
		535 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3151 >> 8) & 0xff,
			3151 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(539 >> 8) & 0xff,
		539 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3167 >> 8) & 0xff,
			3167 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(543 >> 8) & 0xff,
		543 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3183 >> 8) & 0xff,
			3183 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(547 >> 8) & 0xff,
		547 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3197 >> 8) & 0xff,
			3197 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(551 >> 8) & 0xff,
		551 & 0xff}
		}
	},
	/* class_tid: 2, , table: proto_header_cache.wr */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(3211 >> 8) & 0xff,
			3211 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		3},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: em_flow_conflict_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(3218 >> 8) & 0xff,
			3218 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: em_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3471 >> 8) & 0xff,
			3471 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3473 >> 8) & 0xff,
			3473 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(3475 >> 8) & 0xff,
			3475 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(3477 >> 8) & 0xff,
			3477 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3479 >> 8) & 0xff,
			3479 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3480 >> 8) & 0xff,
			3480 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3481 >> 8) & 0xff,
			3481 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3485 >> 8) & 0xff,
			3485 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3489 >> 8) & 0xff,
			3489 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3493 >> 8) & 0xff,
			3493 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3497 >> 8) & 0xff,
			3497 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3502 >> 8) & 0xff,
			3502 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3507 >> 8) & 0xff,
			3507 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(594 >> 8) & 0xff,
		594 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3517 >> 8) & 0xff,
			3517 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(595 >> 8) & 0xff,
		595 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3527 >> 8) & 0xff,
			3527 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3532 >> 8) & 0xff,
			3532 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3537 >> 8) & 0xff,
			3537 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3541 >> 8) & 0xff,
			3541 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3545 >> 8) & 0xff,
			3545 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3549 >> 8) & 0xff,
			3549 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3553 >> 8) & 0xff,
			3553 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3557 >> 8) & 0xff,
			3557 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3561 >> 8) & 0xff,
			3561 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3565 >> 8) & 0xff,
			3565 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3569 >> 8) & 0xff,
			3569 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(596 >> 8) & 0xff,
		596 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3577 >> 8) & 0xff,
			3577 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(597 >> 8) & 0xff,
		597 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3585 >> 8) & 0xff,
			3585 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(598 >> 8) & 0xff,
		598 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3593 >> 8) & 0xff,
			3593 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(599 >> 8) & 0xff,
		599 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3601 >> 8) & 0xff,
			3601 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(600 >> 8) & 0xff,
		600 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3609 >> 8) & 0xff,
			3609 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(601 >> 8) & 0xff,
		601 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3617 >> 8) & 0xff,
			3617 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(602 >> 8) & 0xff,
		602 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3625 >> 8) & 0xff,
			3625 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(603 >> 8) & 0xff,
		603 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3633 >> 8) & 0xff,
			3633 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(604 >> 8) & 0xff,
		604 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3642 >> 8) & 0xff,
			3642 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(605 >> 8) & 0xff,
		605 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3651 >> 8) & 0xff,
			3651 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(606 >> 8) & 0xff,
		606 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3657 >> 8) & 0xff,
			3657 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(607 >> 8) & 0xff,
		607 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3663 >> 8) & 0xff,
			3663 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(608 >> 8) & 0xff,
		608 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3670 >> 8) & 0xff,
			3670 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(609 >> 8) & 0xff,
		609 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3677 >> 8) & 0xff,
			3677 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(610 >> 8) & 0xff,
		610 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3684 >> 8) & 0xff,
			3684 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(611 >> 8) & 0xff,
		611 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3691 >> 8) & 0xff,
			3691 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(612 >> 8) & 0xff,
		612 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3700 >> 8) & 0xff,
			3700 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(613 >> 8) & 0xff,
		613 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3709 >> 8) & 0xff,
			3709 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(614 >> 8) & 0xff,
		614 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3727 >> 8) & 0xff,
			3727 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(617 >> 8) & 0xff,
		617 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3745 >> 8) & 0xff,
			3745 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(620 >> 8) & 0xff,
		620 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3754 >> 8) & 0xff,
			3754 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(621 >> 8) & 0xff,
		621 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3763 >> 8) & 0xff,
			3763 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(622 >> 8) & 0xff,
		622 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3770 >> 8) & 0xff,
			3770 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(623 >> 8) & 0xff,
		623 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3777 >> 8) & 0xff,
			3777 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(624 >> 8) & 0xff,
		624 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3784 >> 8) & 0xff,
			3784 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(625 >> 8) & 0xff,
		625 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3791 >> 8) & 0xff,
			3791 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(626 >> 8) & 0xff,
		626 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3798 >> 8) & 0xff,
			3798 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(627 >> 8) & 0xff,
		627 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3805 >> 8) & 0xff,
			3805 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(628 >> 8) & 0xff,
		628 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3812 >> 8) & 0xff,
			3812 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(629 >> 8) & 0xff,
		629 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3819 >> 8) & 0xff,
			3819 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(630 >> 8) & 0xff,
		630 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3833 >> 8) & 0xff,
			3833 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(633 >> 8) & 0xff,
		633 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3847 >> 8) & 0xff,
			3847 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(636 >> 8) & 0xff,
		636 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3861 >> 8) & 0xff,
			3861 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(639 >> 8) & 0xff,
		639 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3875 >> 8) & 0xff,
			3875 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(642 >> 8) & 0xff,
		642 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3889 >> 8) & 0xff,
			3889 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(645 >> 8) & 0xff,
		645 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3903 >> 8) & 0xff,
			3903 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(648 >> 8) & 0xff,
		648 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3917 >> 8) & 0xff,
			3917 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(651 >> 8) & 0xff,
		651 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3931 >> 8) & 0xff,
			3931 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(654 >> 8) & 0xff,
		654 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3945 >> 8) & 0xff,
			3945 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(657 >> 8) & 0xff,
		657 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3959 >> 8) & 0xff,
			3959 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(660 >> 8) & 0xff,
		660 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3971 >> 8) & 0xff,
			3971 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(663 >> 8) & 0xff,
		663 & 0xff}
		}
	},
	/* class_tid: 2, , table: em_flow_conflict_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(3983 >> 8) & 0xff,
			3983 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 3, , table: port_table.ing_wr_0 */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_rd_sock */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_CC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_CC & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr3 = {
		(1 >> 8) & 0xff,
		1 & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam.ing_0 */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: profile_tcam.prof_func_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: port_table.egr_wr_0 */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.non_vfr_egr_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam.non_vfr_egr_0 */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: profile_tcam.non_vfr_prof_func_egr_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.non_vfr_egr_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: tunnel_gparse_cache.def_cust_tun_rd */
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN}
		}
	},
	/* class_tid: 3, , table: tunnel_gparse_cache.def_cust_tun_wr */
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN}
		}
	},
	/* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_sig_id",
		.field_bit_size = 6,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hdr_sig_id",
		.field_bit_size = 6,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_sig_id",
		.field_bit_size = 6,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hdr_sig_id",
		.field_bit_size = 6,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_rd_egr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.get_drv_func_prof_func */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam.vf_egr */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: profile_tcam.prof_func_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_egr_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: profile_tcam_cache.vfr_rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_sig_id",
		.field_bit_size = 6,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hdr_sig_id",
		.field_bit_size = 6,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam.vf_2_vfr_ing.0 */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_