#ifndef __PEER_COMPAT_H__
#define __PEER_COMPAT_H__

#include "peer_mem.h"

#ifdef HAVE_IB_CLIENT_ADD_RET
typedef int CLIENT_ADD_RET;
#else
typedef void CLIENT_ADD_RET;
#endif

static inline bool ib_access_writable_compat(int access)
{
	/*
	 * We ask for writable memory if any of the following
	 * access flags are set.  "Local write" and "remote write"
	 * obviously require write access.  "Remote atomic" can do
	 * things like fetch and add, which will modify memory, and
	 * "MW bind" can change permissions by binding a window.
	 */
#ifndef HAVE_IB_ACCESS_WRITABLE
		return !!(access & (IB_ACCESS_LOCAL_WRITE |
				    IB_ACCESS_REMOTE_WRITE |
				    IB_ACCESS_REMOTE_ATOMIC |
				    IB_ACCESS_MW_BIND));
#else
	return ib_access_writable(access);
#endif

}

struct ib_umem *__ib_umem_get_compat(struct ib_device *ibdev,
				     struct ib_ucontext *ucontext,
				     struct ib_udata *udata,
				     unsigned long addr,
				     size_t size, int access,
				     int dmasync);
#endif
