#
# spec file for package broadcom bnxt_en driver (Version 1.10.3)
#
# Copyright (c) 2007 Novell, Inc.
# Copyright (c) 2009 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.
# Please submit bugfixes or comments via http://support.novell.com
#
#Authors:
#--------
#    Philip Oswald
#    Modifed for Cumulus/Whitney by Arjun Ananthamurthy <arjunna@broadcom.com>
#    spec file modifications:  poswald@suse.com, andavis@suse.com
#

## condition to check if retpoline is needed?
%bcond_with retpoline

Name:           bnxt_en
BuildRequires:  %kernel_module_package_buildreqs
License:        GPL-2.0
Group:          System/Kernel
Summary:        Broadcom NetXtreme-C/E Gigabit Ethernet Driver
Version:        1.10.3
Release:234.0.171.0.sles15sp6
Source0:        %name-%{version}-234.0.171.0.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-234.0.171.0-build
Packager:       Broadcom Inc
Vendor:         Broadcom Inc

%kernel_module_package

%define docsinfo "Documentation for the Broadcom NetXtreme Gigabit ethernet driver."
%define _rpmfilename %%{ARCH}/%%{NAME}-%%{VERSION}-%%{RELEASE}.%%{ARCH}.rpm

%description
This package contains the Linux driver for the Broadcom Gigabit NetXtreme Server Adapters
Users can fetch the source for this driver from http://go.broadcom.com/ethernetnic_nxe_rpms
GPG Key: http://go.broadcom.com/ethernetnic_nxe_rpms

%debug_package

%package KMP
License:        GPL v2 or later
Summary:        Broadcom NetXtreme Driver for Linux
Group:          System/Kernel
%description KMP
This package contains the Linux driver for the Broadcom Gigabit NetXtreme Server Adapters
Users can fetch the source for this driver from http://go.broadcom.com/ethernetnic_nxe_rpms
GPG Key: http://go.broadcom.com/ethernetnic_nxe_rpms

%package doc
Summary: Documentation for the Broadcom NetXtreme Gigabit ethernet driver
Group: System/Kernel

%description doc
%{docsinfo}

%prep
%setup -q -n bnxt_en-%{version}-234.0.171.0
set -- *
mkdir source
mv "$@" source/
echo "bnxt_en.ko external" > source/Module.supported
mkdir obj

%build
%if %{with retpoline}
    find source/ -name *.c -print0 | xargs -0 sed -i '/MODULE_LICENSE(/a MODULE_INFO(retpoline, "Y");'
%endif

# Regenerate MANIFEST HASH
if [ -e source/MANIFEST ]; then
  cd source
  sha512sum $(cat MANIFEST | cut -c 131-) > MANIFEST
  cd ../
else
  echo "Error: missing source/MANIFEST"
  exit 1
fi

export EXTRA_CFLAGS+='-DVERSION=\"%version\"'
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules \
        M=$PWD/obj/$flavor 1>&2
    [ "`find . -name .BNXT_SRC_DELTA.modified | wc -l`" = 0 ] || { echo "Error: found `find . -name .BNXT_SRC_DELTA.modified`!" 1>&2; exit 1; }
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules_install \
            M=$PWD/obj/$flavor
done
chmod u+x ${RPM_BUILD_ROOT}/lib/modules/*/updates/*

%files doc
%defattr(0644, root, root)
%doc source/README.TXT

%changelog
