/*
 * Copyright (c) 2017,  Boradcom Ltd. All rights reserved.
 * Copyright (c) 2016,  Mellanox Technologies. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if !defined(IB_PEER_UMEM_H)
#define IB_PEER_UMEM_H

#include <rdma/ib_verbs.h>
#include "peer_mem.h"

struct ib_peer_umem {
	/* peer memory that manages this umem */
	struct ib_peer_memory_client *ib_peer_mem;
	struct invalidation_ctx *invalidation_ctx;
	/* peer memory private context */
	void *peer_mem_client_context;
};

struct ib_peer_mem_tbl_entry {
	struct hlist_node entry;
	struct ib_umem *umem;
	struct ib_peer_umem peer_umem;
	struct ib_peer_mem_device *peer_dev;
	int page_shift;
};

void peer_mem_init_hash_tbl(struct ib_peer_mem_device *peer_dev);

#ifdef CONFIG_INFINIBAND_USER_MEM
struct ib_umem *ib_umem_get_flags(struct ib_device *ibdev,
				  struct ib_ucontext *context,
				  struct ib_udata *udata,
				  unsigned long addr, size_t size,
				  int access, unsigned long flags);
void ib_umem_release_flags(struct ib_umem *umem);
int ib_umem_get_peer_page_shift(struct ib_umem *umem);
#endif
int ib_umem_activate_invalidation_notifier(struct ib_umem *umem,
					   void (*func)(void *cookie,
							struct ib_umem *umem,
					   unsigned long addr, size_t size),
					   void *cookie);
#endif
