/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2019-2023 Broadcom
 * All rights reserved.
 */

#ifndef ULP_TEMPLATE_DEBUG_H_
#define ULP_TEMPLATE_DEBUG_H_

#ifdef TC_BNXT_TRUFLOW_DEBUG

/* THIS FILE IS AUTOGENERATED AND MUST NOT BE MODIFIED WITHOUT FEEDING BACK
 * TO THE TEMPLATE COMPILER.
 */

const char *bnxt_ulp_hdr_bit_names[] = {
	"BNXT_ULP_HDR_BIT_O_ETH",
	"BNXT_ULP_HDR_BIT_OO_VLAN",
	"BNXT_ULP_HDR_BIT_OI_VLAN",
	"BNXT_ULP_HDR_BIT_O_IPV4",
	"BNXT_ULP_HDR_BIT_O_IPV6",
	"BNXT_ULP_HDR_BIT_O_TCP",
	"BNXT_ULP_HDR_BIT_O_UDP",
	"BNXT_ULP_HDR_BIT_O_ICMP",
	"BNXT_ULP_HDR_BIT_T_VXLAN",
	"BNXT_ULP_HDR_BIT_T_GRE",
	"BNXT_ULP_HDR_BIT_I_ETH",
	"BNXT_ULP_HDR_BIT_IO_VLAN",
	"BNXT_ULP_HDR_BIT_II_VLAN",
	"BNXT_ULP_HDR_BIT_I_IPV4",
	"BNXT_ULP_HDR_BIT_I_IPV6",
	"BNXT_ULP_HDR_BIT_I_TCP",
	"BNXT_ULP_HDR_BIT_I_UDP",
	"BNXT_ULP_HDR_BIT_I_ICMP",
	"BNXT_ULP_HDR_BIT_O_ECPRI",
	"BNXT_ULP_HDR_BIT_O_ROE",
	"BNXT_ULP_HDR_BIT_F1",
	"BNXT_ULP_HDR_BIT_F2",
	"BNXT_ULP_HDR_BIT_SVIF_IGNORE",
	"BNXT_ULP_HDR_BIT_SVIF",
	"BNXT_ULP_HDR_BIT_O_SRV6",
	"BNXT_ULP_HDR_BIT_I_BTH",
	"BNXT_ULP_HDR_BIT_O_BTH",
	"BNXT_ULP_HDR_BIT_T_VXLAN_GPE",
	"BNXT_ULP_HDR_BIT_T_GENEVE",
	"BNXT_ULP_HDR_BIT_OO_UNTAGGED",
	"BNXT_ULP_HDR_BIT_OI_UNTAGGED",
	"BNXT_ULP_HDR_BIT_IO_UNTAGGED",
	"BNXT_ULP_HDR_BIT_II_UNTAGGED",
	"BNXT_ULP_HDR_BIT_NON_TUNNEL",
	"BNXT_ULP_HDR_BIT_L2_ONLY",
	"BNXT_ULP_HDR_BIT_O_L4_FLOW",
	"BNXT_ULP_HDR_BIT_I_L4_FLOW",
	"BNXT_ULP_HDR_BIT_NON_GENERIC",
	"BNXT_ULP_HDR_BIT_GENERIC",
	"BNXT_ULP_HDR_BIT_O_L2_FILTER",
	"BNXT_ULP_HDR_BIT_I_L2_FILTER",
	"BNXT_ULP_PROTO_LAST",
};

const char *bnxt_ulp_action_bit_names[] = {
	"BNXT_ULP_ACT_BIT_MARK",
	"BNXT_ULP_ACT_BIT_DROP",
	"BNXT_ULP_ACT_BIT_COUNT",
	"BNXT_ULP_ACT_BIT_RSS",
	"BNXT_ULP_ACT_BIT_METER",
	"BNXT_ULP_ACT_BIT_VXLAN_DECAP",
	"BNXT_ULP_ACT_BIT_POP_MPLS",
	"BNXT_ULP_ACT_BIT_PUSH_MPLS",
	"BNXT_ULP_ACT_BIT_MAC_SWAP",
	"BNXT_ULP_ACT_BIT_SET_MAC_SRC",
	"BNXT_ULP_ACT_BIT_SET_MAC_DST",
	"BNXT_ULP_ACT_BIT_POP_VLAN",
	"BNXT_ULP_ACT_BIT_PUSH_VLAN",
	"BNXT_ULP_ACT_BIT_SET_VLAN_PCP",
	"BNXT_ULP_ACT_BIT_SET_VLAN_VID",
	"BNXT_ULP_ACT_BIT_SET_IPV4_SRC",
	"BNXT_ULP_ACT_BIT_SET_IPV4_DST",
	"BNXT_ULP_ACT_BIT_SET_IPV6_SRC",
	"BNXT_ULP_ACT_BIT_SET_IPV6_DST",
	"BNXT_ULP_ACT_BIT_DEC_TTL",
	"BNXT_ULP_ACT_BIT_SET_TTL",
	"BNXT_ULP_ACT_BIT_SET_TP_SRC",
	"BNXT_ULP_ACT_BIT_SET_TP_DST",
	"BNXT_ULP_ACT_BIT_VXLAN_ENCAP",
	"BNXT_ULP_ACT_BIT_JUMP",
	"BNXT_ULP_ACT_BIT_SHARED",
	"BNXT_ULP_ACT_BIT_SAMPLE",
	"BNXT_ULP_ACT_BIT_SHARED_SAMPLE",
	"BNXT_ULP_ACT_BIT_QUEUE",
	"BNXT_ULP_ACT_BIT_DELETE",
	"BNXT_ULP_ACT_BIT_UPDATE",
	"BNXT_ULP_ACT_BIT_SHARED_METER",
	"BNXT_ULP_ACT_BIT_METER_PROFILE",
	"BNXT_ULP_ACT_BIT_GOTO_CHAIN",
	"BNXT_ULP_ACT_BIT_VF_TO_VF",
	"BNXT_ULP_ACT_BIT_IP_ENCAP",
	"BNXT_ULP_ACT_BIT_IP_DECAP",
	"BNXT_ULP_ACT_BIT_L2_ENCAP",
	"BNXT_ULP_ACT_BIT_L2_DECAP",
	"BNXT_ULP_ACT_BIT_GENEVE_DECAP",
	"BNXT_ULP_ACT_BIT_GENEVE_ENCAP",
	"BNXT_ULP_ACT_BIT_MULTIPLE_PORT",
	"BNXT_ULP_ACT_BIT_NON_GENERIC",
	"BNXT_ULP_ACT_BIT_GENERIC",
	"BNXT_ULP_ACT_BIT_LAST"
};

const char *bnxt_ulp_tc_parser_action_prop_names[] = {
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN_SZ] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN_SZ",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SZ] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SZ",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_SZ] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_SZ",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_TYPE] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_TYPE",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_NUM] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_NUM",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_L3_TYPE] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_L3_TYPE",
	[BNXT_ULP_ACT_PROP_IDX_MPLS_POP_NUM] =
		"BNXT_ULP_ACT_PROP_IDX_MPLS_POP_NUM",
	[BNXT_ULP_ACT_PROP_IDX_MPLS_PUSH_NUM] =
		"BNXT_ULP_ACT_PROP_IDX_MPLS_PUSH_NUM",
	[BNXT_ULP_ACT_PROP_IDX_PORT_ID] =
		"BNXT_ULP_ACT_PROP_IDX_PORT_ID",
	[BNXT_ULP_ACT_PROP_IDX_VNIC] =
		"BNXT_ULP_ACT_PROP_IDX_VNIC",
	[BNXT_ULP_ACT_PROP_IDX_VPORT] =
		"BNXT_ULP_ACT_PROP_IDX_VPORT",
	[BNXT_ULP_ACT_PROP_IDX_MARK] =
		"BNXT_ULP_ACT_PROP_IDX_MARK",
	[BNXT_ULP_ACT_PROP_IDX_COUNT] =
		"BNXT_ULP_ACT_PROP_IDX_COUNT",
	[BNXT_ULP_ACT_PROP_IDX_METER] =
		"BNXT_ULP_ACT_PROP_IDX_METER",
	[BNXT_ULP_ACT_PROP_IDX_SET_MAC_SRC] =
		"BNXT_ULP_ACT_PROP_IDX_SET_MAC_SRC",
	[BNXT_ULP_ACT_PROP_IDX_SET_MAC_DST] =
		"BNXT_ULP_ACT_PROP_IDX_SET_MAC_DST",
	[BNXT_ULP_ACT_PROP_IDX_PUSH_VLAN] =
		"BNXT_ULP_ACT_PROP_IDX_PUSH_VLAN",
	[BNXT_ULP_ACT_PROP_IDX_SET_VLAN_PCP] =
		"BNXT_ULP_ACT_PROP_IDX_SET_VLAN_PCP",
	[BNXT_ULP_ACT_PROP_IDX_SET_VLAN_VID] =
		"BNXT_ULP_ACT_PROP_IDX_SET_VLAN_VID",
	[BNXT_ULP_ACT_PROP_IDX_SET_IPV4_SRC] =
		"BNXT_ULP_ACT_PROP_IDX_SET_IPV4_SRC",
	[BNXT_ULP_ACT_PROP_IDX_SET_IPV4_DST] =
		"BNXT_ULP_ACT_PROP_IDX_SET_IPV4_DST",
	[BNXT_ULP_ACT_PROP_IDX_SET_IPV6_SRC] =
		"BNXT_ULP_ACT_PROP_IDX_SET_IPV6_SRC",
	[BNXT_ULP_ACT_PROP_IDX_SET_IPV6_DST] =
		"BNXT_ULP_ACT_PROP_IDX_SET_IPV6_DST",
	[BNXT_ULP_ACT_PROP_IDX_SET_TP_SRC] =
		"BNXT_ULP_ACT_PROP_IDX_SET_TP_SRC",
	[BNXT_ULP_ACT_PROP_IDX_SET_TP_DST] =
		"BNXT_ULP_ACT_PROP_IDX_SET_TP_DST",
	[BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_0] =
		"BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_0",
	[BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_1] =
		"BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_1",
	[BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_2] =
		"BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_2",
	[BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_3] =
		"BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_3",
	[BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_4] =
		"BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_4",
	[BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_5] =
		"BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_5",
	[BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_6] =
		"BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_6",
	[BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_7] =
		"BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_7",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_DMAC] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_DMAC",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_SMAC] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_SMAC",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_IP] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_IP",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SRC] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SRC",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_UDP] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_UDP",
	[BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN] =
		"BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN",
	[BNXT_ULP_ACT_PROP_IDX_JUMP] =
		"BNXT_ULP_ACT_PROP_IDX_JUMP",
	[BNXT_ULP_ACT_PROP_IDX_SHARED_HANDLE] =
		"BNXT_ULP_ACT_PROP_IDX_SHARED_HANDLE",
	[BNXT_ULP_ACT_PROP_IDX_RSS_TYPES] =
		"BNXT_ULP_ACT_PROP_IDX_RSS_TYPES",
	[BNXT_ULP_ACT_PROP_IDX_RSS_LEVEL] =
		"BNXT_ULP_ACT_PROP_IDX_RSS_LEVEL",
	[BNXT_ULP_ACT_PROP_IDX_RSS_KEY_LEN] =
		"BNXT_ULP_ACT_PROP_IDX_RSS_KEY_LEN",
	[BNXT_ULP_ACT_PROP_IDX_RSS_KEY] =
		"BNXT_ULP_ACT_PROP_IDX_RSS_KEY",
	[BNXT_ULP_ACT_PROP_IDX_RSS_QUEUE_NUM] =
		"BNXT_ULP_ACT_PROP_IDX_RSS_QUEUE_NUM",
	[BNXT_ULP_ACT_PROP_IDX_RSS_QUEUE] =
		"BNXT_ULP_ACT_PROP_IDX_RSS_QUEUE",
	[BNXT_ULP_ACT_PROP_IDX_QUEUE_INDEX] =
	       "BNXT_ULP_ACT_PROP_IDX_QUEUE_INDEX",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_ID] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_ID",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_CIR] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_CIR",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_EIR] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_EIR",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBS] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBS",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBS] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBS",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_RFC2698] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_RFC2698",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_PM] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_PM",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBND] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBND",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBND] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBND",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBSM] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBSM",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBSM] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBSM",
	[BNXT_ULP_ACT_PROP_IDX_METER_PROF_CF] =
		"BNXT_ULP_ACT_PROP_IDX_METER_PROF_CF",
	[BNXT_ULP_ACT_PROP_IDX_METER_INST_ID] =
		"BNXT_ULP_ACT_PROP_IDX_METER_INST_ID",
	[BNXT_ULP_ACT_PROP_IDX_METER_INST_ECN_RMP_EN] =
		"BNXT_ULP_ACT_PROP_IDX_METER_INST_ECN_RMP_EN",
	[BNXT_ULP_ACT_PROP_IDX_METER_INST_MTR_VAL] =
		"BNXT_ULP_ACT_PROP_IDX_METER_INST_MTR_VAL",
	[BNXT_ULP_ACT_PROP_IDX_LAST] =
		"BNXT_ULP_ACT_PROP_IDX_LAST"
};

const char *bnxt_ulp_flow_matcher_field_mask_opcode_names[] = {
	"MASK_IGNORE",
	"MASK_ANY",
	"MASK_EXACT",
	"MASK_WC",
	"MASK_LAST",
};

const char *bnxt_ulp_tc_template_field_names[] = {
	/* Ingress Template 0 */
	"BNXT_ULP_HF0_SVIF_INDEX",
	"BNXT_ULP_HF0_O_ETH_DMAC",
	"BNXT_ULP_HF0_O_ETH_SMAC",
	"BNXT_ULP_HF0_O_ETH_TYPE",
	"BNXT_ULP_HF0_OO_VLAN_CFI_PRI",
	"BNXT_ULP_HF0_OO_VLAN_VID",
	"BNXT_ULP_HF0_OO_VLAN_TYPE",
	"BNXT_ULP_HF0_OI_VLAN_CFI_PRI",
	"BNXT_ULP_HF0_OI_VLAN_VID",
	"BNXT_ULP_HF0_OI_VLAN_TYPE",
	"BNXT_ULP_HF0_O_IPV4_VER",
	"BNXT_ULP_HF0_O_IPV4_TOS",
	"BNXT_ULP_HF0_O_IPV4_LEN",
	"BNXT_ULP_HF0_O_IPV4_FRAG_ID",
	"BNXT_ULP_HF0_O_IPV4_FRAG_OFF",
	"BNXT_ULP_HF0_O_IPV4_TTL",
	"BNXT_ULP_HF0_O_IPV4_NEXT_PID",
	"BNXT_ULP_HF0_O_IPV4_CSUM",
	"BNXT_ULP_HF0_O_IPV4_SRC_ADDR",
	"BNXT_ULP_HF0_O_IPV4_DST_ADDR",
	"BNXT_ULP_HF0_O_UDP_SRC_PORT",
	"BNXT_ULP_HF0_O_UDP_DST_PORT",
	"BNXT_ULP_HF0_O_UDP_LENGTH",
	"BNXT_ULP_HF0_O_UDP_CSUM",
	"BNXT_ULP_HF0_VXLAN_FLAGS",
	"BNXT_ULP_HF0_VXLAN_RSVD0",
	"BNXT_ULP_HF0_VXLAN_VNI",
	"BNXT_ULP_HF0_VXLAN_RSVD1",
	"BNXT_ULP_HF0_I_ETH_DMAC",
	"BNXT_ULP_HF0_I_ETH_SMAC",
	"BNXT_ULP_HF0_I_ETH_TYPE",
	"BNXT_ULP_HF0_IO_VLAN_CFI_PRI",
	"BNXT_ULP_HF0_IO_VLAN_VID",
	"BNXT_ULP_HF0_IO_VLAN_TYPE",
	"BNXT_ULP_HF0_II_VLAN_CFI_PRI",
	"BNXT_ULP_HF0_II_VLAN_VID",
	"BNXT_ULP_HF0_II_VLAN_TYPE",
	"BNXT_ULP_HF0_I_IPV4_VER",
	"BNXT_ULP_HF0_I_IPV4_TOS",
	"BNXT_ULP_HF0_I_IPV4_LEN",
	"BNXT_ULP_HF0_I_IPV4_FRAG_ID",
	"BNXT_ULP_HF0_I_IPV4_FRAG_OFF",
	"BNXT_ULP_HF0_I_IPV4_TTL",
	"BNXT_ULP_HF0_I_IPV4_NEXT_PID",
	"BNXT_ULP_HF0_I_IPV4_CSUM",
	"BNXT_ULP_HF0_I_IPV4_SRC_ADDR",
	"BNXT_ULP_HF0_I_IPV4_DST_ADDR",
	"BNXT_ULP_HF0_I_TCP_SRC_PORT",
	"BNXT_ULP_HF0_I_TCP_DST_PORT",
	"BNXT_ULP_HF0_I_TCP_SENT_SEQ",
	"BNXT_ULP_HF0_I_TCP_RECV_ACK",
	"BNXT_ULP_HF0_I_TCP_DATA_OFF",
	"BNXT_ULP_HF0_I_TCP_TCP_FLAGS",
	"BNXT_ULP_HF0_I_TCP_RX_WIN",
	"BNXT_ULP_HF0_I_TCP_CSUM",
	"BNXT_ULP_HF0_I_TCP_UR",

	/* Ingress template 1 */
	"BNXT_ULP_HF1_MPLS_TAG_NUM",
	"BNXT_ULP_HF1_O_VTAG_NUM",
	"BNXT_ULP_HF1_I_VTAG_NUM",
	"BNXT_ULP_HF1_SVIF_INDEX",
	"BNXT_ULP_HF1_O_ETH_DMAC",
	"BNXT_ULP_HF1_O_ETH_SMAC",
	"BNXT_ULP_HF1_O_ETH_TYPE",
	"BNXT_ULP_HF1_O_OVLAN_CFI_PRI",
	"BNXT_ULP_HF1_O_OVLAN_VID",
	"BNXT_ULP_HF1_O_OVLAN_TYPE",
	"BNXT_ULP_HF1_O_IVLAN_CFI_PRI",
	"BNXT_ULP_HF1_O_IVLAN_VID",
	"BNXT_ULP_HF1_O_IVLAN_TYPE",
	"BNXT_ULP_HF1_O_IPV4_VER",
	"BNXT_ULP_HF1_O_IPV4_TOS",
	"BNXT_ULP_HF1_O_IPV4_LEN",
	"BNXT_ULP_HF1_O_IPV4_FRAG_ID",
	"BNXT_ULP_HF1_O_IPV4_FRAG_OFF",
	"BNXT_ULP_HF1_O_IPV4_TTL",
	"BNXT_ULP_HF1_O_IPV4_NEXT_PID",
	"BNXT_ULP_HF1_O_IPV4_CSUM",
	"BNXT_ULP_HF1_O_IPV4_SRC_ADDR",
	"BNXT_ULP_HF1_O_IPV4_DST_ADDR",
	"BNXT_ULP_HF1_O_UDP_SRC_PORT",
	"BNXT_ULP_HF1_O_UDP_DST_PORT",
	"BNXT_ULP_HF1_O_UDP_LENGTH",
	"BNXT_ULP_HF1_O_UDP_CSUM",
	"BNXT_ULP_HF1_VXLAN_FLAGS",
	"BNXT_ULP_HF1_VXLAN_RSVD0",
	"BNXT_ULP_HF1_VXLAN_VNI",
	"BNXT_ULP_HF1_VXLAN_RSVD1",
	"BNXT_ULP_HF1_I_ETH_DMAC",
	"BNXT_ULP_HF1_I_ETH_SMAC",
	"BNXT_ULP_HF1_I_ETH_TYPE",
	"BNXT_ULP_HF1_I_OVLAN_CFI_PRI",
	"BNXT_ULP_HF1_I_OVLAN_VID",
	"BNXT_ULP_HF1_I_OVLAN_TYPE",
	"BNXT_ULP_HF1_I_IVLAN_CFI_PRI",
	"BNXT_ULP_HF1_I_IVLAN_VID",
	"BNXT_ULP_HF1_I_IVLAN_TYPE",
	"BNXT_ULP_HF1_I_IPV4_VER",
	"BNXT_ULP_HF1_I_IPV4_TOS",
	"BNXT_ULP_HF1_I_IPV4_LEN",
	"BNXT_ULP_HF1_I_IPV4_FRAG_ID",
	"BNXT_ULP_HF1_I_IPV4_FRAG_OFF",
	"BNXT_ULP_HF1_I_IPV4_TTL",
	"BNXT_ULP_HF1_I_IPV4_NEXT_PID",
	"BNXT_ULP_HF1_I_IPV4_CSUM",
	"BNXT_ULP_HF1_I_IPV4_SRC_ADDR",
	"BNXT_ULP_HF1_I_IPV4_DST_ADDR",
	"BNXT_ULP_HF1_I_UDP_SRC_PORT",
	"BNXT_ULP_HF1_I_UDP_DST_PORT",
	"BNXT_ULP_HF1_I_UDP_UR",

	/* Egress template 2 */
	"BNXT_ULP_HF2_MPLS_TAG_NUM",
	"BNXT_ULP_HF2_O_VTAG_NUM",
	"BNXT_ULP_HF2_I_VTAG_NUM",
	"BNXT_ULP_HF2_SVIF_INDEX",
	"BNXT_ULP_HF2_O_ETH_DMAC",
	"BNXT_ULP_HF2_O_ETH_SMAC",
	"BNXT_ULP_HF2_O_ETH_TYPE",
	"BNXT_ULP_HF2_O_OVLAN_CFI_PRI",
	"BNXT_ULP_HF2_O_OVLAN_VID",
	"BNXT_ULP_HF2_O_OVLAN_TYPE",
	"BNXT_ULP_HF2_O_IVLAN_CFI_PRI",
	"BNXT_ULP_HF2_O_IVLAN_VID",
	"BNXT_ULP_HF2_O_IVLAN_TYPE",
	"BNXT_ULP_HF2_O_IPV4_VER",
	"BNXT_ULP_HF2_O_IPV4_TOS",
	"BNXT_ULP_HF2_O_IPV4_LEN",
	"BNXT_ULP_HF2_O_IPV4_FRAG_ID",
	"BNXT_ULP_HF2_O_IPV4_FRAG_OFF",
	"BNXT_ULP_HF2_O_IPV4_TTL",
	"BNXT_ULP_HF2_O_IPV4_NEXT_PID",
	"BNXT_ULP_HF2_O_IPV4_CSUM",
	"BNXT_ULP_HF2_O_IPV4_SRC_ADDR",
	"BNXT_ULP_HF2_O_IPV4_DST_ADDR",
	"BNXT_ULP_HF2_O_UDP_SRC_PORT",
	"BNXT_ULP_HF2_O_UDP_DST_PORT",
	"BNXT_ULP_HF2_O_UDP_LENGTH",
	"BNXT_ULP_HF2_O_UDP_CSUM",
	"BNXT_ULP_HF2_VXLAN_FLAGS",
	"BNXT_ULP_HF2_VXLAN_RSVD0",
	"BNXT_ULP_HF2_VXLAN_VNI",
	"BNXT_ULP_HF2_VXLAN_RSVD1",
	"BNXT_ULP_HF2_I_ETH_DMAC",
	"BNXT_ULP_HF2_I_ETH_SMAC",
	"BNXT_ULP_HF2_I_ETH_TYPE",
	"BNXT_ULP_HF2_I_OVLAN_CFI_PRI",
	"BNXT_ULP_HF2_I_OVLAN_VID",
	"BNXT_ULP_HF2_I_OVLAN_TYPE",
	"BNXT_ULP_HF2_I_IVLAN_CFI_PRI",
	"BNXT_ULP_HF2_I_IVLAN_VID",
	"BNXT_ULP_HF2_I_IVLAN_TYPE",
	"BNXT_ULP_HF2_I_IPV4_VER",
	"BNXT_ULP_HF2_I_IPV4_TOS",
	"BNXT_ULP_HF2_I_IPV4_LEN",
	"BNXT_ULP_HF2_I_IPV4_FRAG_ID",
	"BNXT_ULP_HF2_I_IPV4_FRAG_OFF",
	"BNXT_ULP_HF2_I_IPV4_TTL",
	"BNXT_ULP_HF2_I_IPV4_NEXT_PID",
	"BNXT_ULP_HF2_I_IPV4_CSUM",
	"BNXT_ULP_HF2_I_IPV4_SRC_ADDR",
	"BNXT_ULP_HF2_I_IPV4_DST_ADDR",
	"BNXT_ULP_HF2_I_UDP_SRC_PORT",
	"BNXT_ULP_HF2_I_UDP_DST_PORT",
	"BNXT_ULP_HF2_I_UDP_UR",
};

struct bnxt_ulp_bitpos {
	u64 val_o_eth;
	u64 val_oo_vlan;
	u64 val_oi_vlan;
	u64 val_o_ipv4;
	u64 val_o_ipv6;
	u64 val_o_tcp;
	u64 val_o_udp;
	u64 val_o_icmp;
	u64 val_t_vxlan;
	u64 val_t_gre;
	u64 val_i_eth;
	u64 val_io_vlan;
	u64 val_ii_vlan;
	u64 val_i_ipv4;
	u64 val_i_ipv6;
	u64 val_i_tcp;
	u64 val_i_udp;
	u64 val_i_icmp;
	u64 val_f1;
	u64 val_f2;

	u64 val_mark;
	u64 val_drop;
	u64 val_count;
	u64 val_rss;
	u64 val_meter;
	u64 val_vxlan_decap;
	u64 val_pop_mpls;
	u64 val_push_mpls;
	u64 val_mac_swap;
	u64 val_set_mac_src;
	u64 val_set_mac_dst;
	u64 val_pop_vlan;
	u64 val_push_vlan;
	u64 val_set_vlan_pcp;
	u64 val_set_vlan_vid;
	u64 val_set_ipv4_src;
	u64 val_set_ipv4_dst;
	u64 val_set_ipv6_src;
	u64 val_set_ipv6_dst;
	u64 val_dec_ttl;
	u64 val_set_tp_src;
	u64 val_set_tp_dst;
	u64 val_vxlan_encap;
	u64 val_jump;
	u64 val_shared;
	u64 val_sample;
	u64 val_shared_sample;

};

#endif /* TC_BNXT_TRUFLOW_DEBUG */
#endif
