#
# spec file for package broadcom bnxt_en driver (Version 234.0.171.0)
#
# Copyright (c) 2007 Novell, Inc.
# Copyright (c) 2009 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.
# Please submit bugfixes or comments via http://support.novell.com
#
#Authors:
#--------
#    Philip Oswald
#    Modifed for Cumulus/Whitney by Arjun Ananthamurthy <arjunna@broadcom.com>
#    spec file modifications:  poswald@suse.com, andavis@suse.com
#

## condition to check if retpoline is needed?
%bcond_with retpoline

Name:           netxtreme-peer-mem
BuildRequires:  %kernel_module_package_buildreqs
License:        GPL-2.0
Group:          System/Kernel
Summary:        Broadcom peer-mem Driver
Version:        234.0.171.0
Release:        1.sles15sp6
Source0:        %name-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Packager:       Broadcom Inc
Vendor:         Broadcom Inc


%define docsinfo "Documentation for the Broadcom NICCLI peer-mem Driver."
%define _rpmfilename %%{ARCH}/%%{NAME}-%%{VERSION}-%%{RELEASE}.%%{ARCH}.rpm
%define kernel_version    %(uname -r | awk -F"-" '{print $1"-"$2}')

%ifarch aarch64
    %kernel_module_package -x 64kb
%else
    %if "%{flavors_to_build}" == "rt"
        %kernel_module_package -x default
    %else
        %kernel_module_package -x rt
    %endif
%endif


%description
This package contains the Linux driver for the Broadcom NICCLI peer-mem Driver
Users can fetch the source for this driver from http://go.broadcom.com/ethernetnic_nxe_rpms
GPG Key: http://go.broadcom.com/ethernetnic_nxe_rpms

%debug_package

%package KMP
License:        GPL v2 or later
Summary:        Broadcom NICCLI peer-mem Driver for Linux
Group:          System/Kernel
%description KMP
This package contains the Linux driver for the Broadcom peer-mem
Users can fetch the source for this driver from http://go.broadcom.com/ethernetnic_nxe_rpms
GPG Key: http://go.broadcom.com/ethernetnic_nxe_rpms

%package doc
Summary: Documentation for the Broadcom NICCLI peer-mem Driver
Group: System/Kernel

%description doc
%{docsinfo}

%prep
%setup -q -n %{name}-%{version}
set -- *
mkdir source
mv "$@" source/
mkdir obj

%build
export EXTRA_CFLAGS+='-DVERSION=\"%version\"'
for flavor in %flavors_to_build; do
    echo flavor=$flavor
    echo kernel_source=%{kernel_source $flavor}
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    export BNXT_QPLIB_INC=$PWD/obj/$flavor/bnxt_re/bnxt_qplib
    export BNXT_EN_INC=$PWD/obj/$flavor/bnxt_en
    export BNXT_PEER_MEM_INC=$PWD/obj/$flavor/peer_mem
    #make -C %{kernel_source $flavor} modules M=$PWD/obj/$flavor 1>&2
    make -C %{kernel_source $flavor} KVER=%{kernel_version}-$flavor modules M=$PWD/obj/$flavor/peer_mem 1>&2
    make -C %{kernel_source $flavor} KVER=%{kernel_version}-$flavor modules M=$PWD/obj/$flavor/bnxt_en 1>&2
    make -C %{kernel_source $flavor} KVER=%{kernel_version}-$flavor modules M=$PWD/obj/$flavor/bnxt_re 1>&2
    find $PWD/obj/$flavor -type f -name '*.ko'
    find %{kernel_source $flavor} -type f
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
for flavor in %flavors_to_build; do
    export INSTALL_MOD_DIR=updates
    make -C %{kernel_source $flavor} KVER=%{kernel_version}-$flavor modules_install M=$PWD/obj/$flavor/peer_mem
    make -C %{kernel_source $flavor} KVER=%{kernel_version}-$flavor modules_install M=$PWD/obj/$flavor/bnxt_en
    export INSTALL_MOD_DIR=updates/drivers/infiniband/hw/bnxt_re
    make -C %{kernel_source $flavor} KVER=%{kernel_version}-$flavor modules_install M=$PWD/obj/$flavor/bnxt_re
done
find ${RPM_BUILD_ROOT} -type f
chmod u+x ${RPM_BUILD_ROOT}/lib/modules/*/updates/*

%files doc
%defattr(0644, root, root)
%doc source/README.TXT

%changelog
