#
# spec file for package bnxt_en
#
# Copyright (c) 2021 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

%define driver_version    1.10.3
%define release_version   234.0.171.0
%define flavors_to_build  default

%define kernel_version    %(uname -r | awk -F"-" '{print $1"-"$2}')


Name:           bnxt_en
Version:        %{driver_version}
Release:234.0.171.0.sles15sp5
License:        GPL v2 or later
Summary:        Broadcom NetXtreme Gigabit Ethernet and RoCE Driver
Url:            www.broadcom.net
Group:          System/Kernel
Source0:        netxtreme-%{name}-%{driver_version}-%{release_version}.tar.gz
BuildRequires:  %kernel_module_package_buildreqs
BuildRoot:      %{_tmppath}/%{name}-%{driver_version}-%{release_version}-build
Packager:       Broadcom Inc
Vendor:         Broadcom Inc



%ifarch aarch64
    %kernel_module_package -x 64kb
%else
    %if "%{flavors_to_build}" == "rt"
        %kernel_module_package -x default
    %else
        %kernel_module_package -x rt
    %endif
%endif



%debug_package



%description
This package contains the Broadcom NetXtreme Gigabit ethernet and RoCE driver.
Users can fetch the source for this driver from http://go.broadcom.com/ethernetnic_nxe_rpms
GPG Key: http://go.broadcom.com/ethernetnic_nxe_rpms

%package doc
Summary: Documentation for the Broadcom NetXtreme Gigabit ethernet driver
Group: System/Kernel

%description doc
Documentation for the Broadcom NetXtreme Gigabit ethernet driver



%prep
%setup -q -n netxtreme-bnxt_en-%{driver_version}-%{release_version}

set -- *
mkdir -v obj
mkdir -v source
mv -v "$@" source/
cp -v source/bnxt_en/COPYING .
cp -v source/bnxt_en/README.TXT bnxt_en_README.TXT
cp -v source/bnxt_re/README.TXT bnxt_re_README.TXT
echo "bnxt_en external" > source/bnxt_en/Module.supported
echo "bnxt_re external" > source/bnxt_re/Module.supported



%build
%bcond_with retpoline
%if %{with retpoline}
    export KCFLAGS='-mindirect-branch=thunk-inline -mindirect-branch-register'
    find source -name *.c -print0 | xargs -0 sed -i '/MODULE_LICENSE(/a MODULE_INFO(retpoline, "Y");'
%endif

# Regenerate MANIFEST HASH
if [ -e source/bnxt_en/MANIFEST ]; then
  cd source/bnxt_en
  sha512sum $(cat MANIFEST | cut -c 131-) > MANIFEST
  cd ../../
else
  echo "Error: missing source/bnxt_en/MANIFEST"
  exit 1
fi

# KMP build
for flavor in %{flavors_to_build}; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    export BNXT_QPLIB_INC=$PWD/obj/$flavor/bnxt_re/bnxt_qplib
    export BNXT_EN_INC=$PWD/obj/$flavor/bnxt_en
    make -C /usr/src/linux-obj/%{_target_cpu}/$flavor KVER=%{kernel_version}-$flavor modules \
        M=$PWD/obj/$flavor/bnxt_en 1>&2
    make -C /usr/src/linux-obj/%{_target_cpu}/$flavor KVER=%{kernel_version}-$flavor modules \
        M=$PWD/obj/$flavor/bnxt_re 1>&2
    [ "`find . -name .BNXT_SRC_DELTA.modified | wc -l`" = 0 ] || { echo "Error: found `find . -name .BNXT_SRC_DELTA.modified`!"; exit 1; }
done



%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
for flavor in %{flavors_to_build}; do
    export INSTALL_MOD_DIR=updates
    make -C /usr/src/linux-obj/%{_target_cpu}/$flavor KVER=%{kernel_version}-$flavor modules_install \
        M=$PWD/obj/$flavor/bnxt_en
    export INSTALL_MOD_DIR=updates/drivers/infiniband/hw/bnxt_re
    make -C /usr/src/linux-obj/%{_target_cpu}/$flavor KVER=%{kernel_version}-$flavor modules_install \
       M=$PWD/obj/$flavor/bnxt_re
done



%files doc
%defattr(-, root, root)
%doc bnxt_*.TXT



%changelog
