%bcond_with retpoline


Name     : netxtreme-peer-mem
Version  : 234.0.171.0
Release  : 1.rhel9u5
Group    : System Environment/Base
Packager : Broadcom Inc
Vendor   : Broadcom Inc
URL      : http://www.broadcom.com
License  : GPLv2
Source0  : %{name}-%{version}.tar.gz
Source1  : %{name}.files
BuildRoot: %{_tmppath}/%{name}-buildroot
BuildRequires: %kernel_module_package_buildreqs
Summary  : Broadcom Peer-Mem Driver

%define packinfo "This package contains the Broadcom Peer-Mem driver."
%define sourceinfo Users can fetch the source for this driver from http://go.broadcom.com/ethernetnic_nxe_rpms
%define gpginfo GPG Key: http://go.broadcom.com/ethernetnic_nxe_rpms
%define docsinfo "Documentation for the Broadcom NetXtreme Gigabit ethernet driver."

%define _host_vendor redhat

%if %{!?KVER:1}%{?KVER:0}
%define flav ""
%endif
%if %{!?KVER:0}%{?KVER:1}
%define flav default
%define kverrel %(echo %{KVER} | sed -e 's/\([0-9]\.[0-9]\+\.[0-9]*\-[0-9]*\.[Ee][Ll][5-7]*\).*/\1/')
%endif

%kernel_module_package -f %{SOURCE1} default

%description
%{packinfo}
%{gpginfo}

%description   -n kmod-%name
This package provides the %name kernel modules built for the Linux
kernel %(echo `uname -r`) for the %_target_cpu family of processors.
%{sourceinfo}
%{gpginfo}

%package doc
Summary: Documentation for the Broadcom NetXtreme Gigabit ethernet driver
Group: System/Kernel

%description doc
%{docsinfo}

# https://github.com/rpm-software-management/rpm/blob/4a9440006398646583f0d9ae1837dad2875013aa/macros.in#L506
# Default setting from /usr/lib/rpm/macros is "compat"
%define _build_id_links  none

%prep
%setup -q -n netxtreme-peer-mem-%{version}
set -- *
mkdir -p source
mv -f "$@" source/
mkdir -p obj


%build
export KVER=%{kverrel}
export KABIRPM=1
export EXTRA_CFLAGS+='-DVERSION=\"%version\"'

%if %{!?KVER:0}%{?KVER:1}
%define flavors %{flav}
%else
%define flavors %{flavors_to_build}
%endif

# Check for Kernel peer mem APIs
if grep -s -o "ib_umem_get_peer" "/lib/modules/${KVER}/build/include/rdma/ib_umem.h" || grep -s -o "ib_umem_get_peer" /usr/src/ofa_kernel/x86_64/${kernelver}/include/rdma/ib_umem.h ; then
   echo "Kernel stack supports peer mem APIs. Skip Broadcom peer mem module"
   exit 1
fi

for flavor in %{flavors}; do
  rm -rf obj/$flavor
  cp -r source obj/$flavor
  export LINUXSRC=%{kernel_source $flavor}
  if [ $flavor == "default" ]; then
     kernel_flavor=${KVER}
  else
     kernel_flavor=${KVER}${flavor}
  fi
  make -C obj/$flavor KVER=$kernel_flavor 1>&2
  find obj/$flavor -type f -name '*.ko'
done


%install
export KVER=%{kverrel}
export KABIRPM=1
export EXTRA_CFLAGS+='-DVERSION=\"%version\"'

%if %{!?KVER:0}%{?KVER:1}
%define flavors %{flav}
%else
%define flavors %{flavors_to_build}
%endif

for flavor in %{flavors}; do
  export LINUXSRC=%{kernel_source $flavor}
  if [ $flavor == "default" ]; then
     kernel_flavor=${KVER}
  else
     kernel_flavor=${KVER}${flavor}
  fi
  dest_dir_peer_mem=${RPM_BUILD_ROOT}/lib/modules/$kernel_flavor/extra/%{name}/
  dest_dir_bnxt_en=${RPM_BUILD_ROOT}/lib/modules/$kernel_flavor/extra/bnxt_en/
  dest_dir_bnxt_re=${RPM_BUILD_ROOT}/lib/modules/$kernel_flavor/extra/bnxt_en//drivers/infiniband/hw/bnxt_re/
  mkdir -pv ${dest_dir_peer_mem}
  mkdir -pv ${dest_dir_bnxt_en}
  mkdir -pv ${dest_dir_bnxt_re}
  find obj/$flavor -name '*.ko'
  install -m 744 obj/default/peer_mem/ib_peer_mem.ko ${dest_dir_peer_mem}
  install -m 744 obj/default/bnxt_en/bnxt_en.ko ${dest_dir_bnxt_en}
  install -m 744 obj/default/bnxt_re/bnxt_re.ko ${dest_dir_bnxt_re}
done

%post
depmod -a

%postun
depmod -a

%clean
rm -rf %{buildroot}

%files doc
%doc source/README.TXT

%define major_change (Severity:Critical)
%define medium_change (Severity:Medium)
%define minor_change (Severity:Minor)

%changelog
