%bcond_with retpoline


Name     : bnxt_en
Version  : 1.10.3
Release:234.0.171.0.rhel9u5
Group    : System Environment/Base
Packager : Broadcom Inc
Vendor   : Broadcom Inc
URL      : http://www.broadcom.com
License  : GPLv2
Source0  : %{name}-%{version}-234.0.171.0.tar.gz
Source1  : %{name}.files
Source2  : %{name}.conf
BuildRoot: %{_tmppath}/%{name}-buildroot
BuildRequires: %kernel_module_package_buildreqs
Summary  : Broadcom NetXtreme-C/E Gigabit Ethernet Driver

%define packinfo "This package contains the Broadcom NetXtreme-C/E Gigabit ethernet driver."
%define sourceinfo Users can fetch the source for this driver from http://go.broadcom.com/ethernetnic_nxe_rpms
%define gpginfo GPG Key: http://go.broadcom.com/ethernetnic_nxe_rpms
%define docsinfo "Documentation for the Broadcom NetXtreme Gigabit ethernet driver."

%define _host_vendor redhat

%if %{!?KVER:1}%{?KVER:0}
%define flav ""
%endif
%if %{!?KVER:0}%{?KVER:1}
%define flav default
%define kverrel %(echo %{KVER} | sed -e 's/\([0-9]\.[0-9]\+\.[0-9]*\-[0-9]*\.[Ee][Ll][5-7]*\).*/\1/')
%endif

%kernel_module_package -f %{SOURCE1} default

%description
%{packinfo}
%{gpginfo}

%description   -n kmod-%name
This package provides the %name kernel modules built for the Linux
kernel %(echo `uname -r`) for the %_target_cpu family of processors.
%{sourceinfo}
%{gpginfo}

%package doc
Summary: Documentation for the Broadcom NetXtreme Gigabit ethernet driver
Group: System/Kernel

%description doc
%{docsinfo}

# https://github.com/rpm-software-management/rpm/blob/4a9440006398646583f0d9ae1837dad2875013aa/macros.in#L506
# Default setting from /usr/lib/rpm/macros is "compat"
%define _build_id_links  none

%prep
%setup -q -n %{name}-%{version}-234.0.171.0
set -- *
mkdir -p source
mv -f "$@" source/
mkdir -p obj

%build
export KVER=%{kverrel}
export KABIRPM=1
export EXTRA_CFLAGS+='-DVERSION=\"%version\"'

%if %{with retpoline}
    find source/ -name *.c -print0 | xargs -0 sed -i '/MODULE_LICENSE(/a MODULE_INFO(retpoline, "Y");'
%endif

# Regenerate MANIFEST HASH
if [ -e source/MANIFEST ]; then
  cd source
  sha512sum $(cat MANIFEST | cut -c 131-) > MANIFEST
  cd ../
else
  echo "Error: missing source/MANIFEST"
  exit 1
fi

%if %{!?KVER:0}%{?KVER:1}
%define flavors %{flav}
%else
%define flavors %{flavors_to_build}
%endif

for flavor in %{flavors}; do
  rm -rf obj/$flavor
  cp -r source obj/$flavor
  export LINUXSRC=%{kernel_source $flavor}
  if [ $flavor == "default" ]; then
     kernel_flavor=${KVER}
  else
     kernel_flavor=${KVER}${flavor}
  fi
  make -C obj/$flavor KVER=$kernel_flavor 1>&2
  [ "`find . -name .BNXT_SRC_DELTA.modified | wc -l`" = 0 ] || { echo "Error: found `find . -name .BNXT_SRC_DELTA.modified`!" 1>&2; exit 1; }
done

%install
export KVER=%{kverrel}
export KABIRPM=1
export EXTRA_CFLAGS+='-DVERSION=\"%version\"'

%if %{!?KVER:0}%{?KVER:1}
%define flavors %{flav}
%else
%define flavors %{flavors_to_build}
%endif

for flavor in %{flavors}; do
  export LINUXSRC=%{kernel_source $flavor}
  if [ $flavor == "default" ]; then
     kernel_flavor=${KVER}
  else
     kernel_flavor=${KVER}${flavor}
  fi
  dest_dir=${RPM_BUILD_ROOT}/lib/modules/$kernel_flavor/extra/%{name}/
  mkdir -p ${dest_dir}
  install -m 744 obj/$flavor/%{name}.ko ${dest_dir}
done

install -m 644 -D %{SOURCE2} $RPM_BUILD_ROOT/etc/depmod.d/%{name}.conf

#man_dir=${RPM_BUILD_ROOT}/usr/share/man/man4
#mkdir -p ${man_dir}
#gzip -c source/%{name}.4 > ${man_dir}/%{name}.4.gz

%post
depmod -a

%postun
depmod -a

%clean
rm -rf %{buildroot}

%files doc
%doc source/README.TXT
#%_mandir/man4/%{name}.4.gz

%define major_change (Severity:Critical)
%define medium_change (Severity:Medium)
%define minor_change (Severity:Minor)

%changelog
