/* SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause */
/* Copyright(c) 2019-2020  Realtek Corporation
 */

#ifndef __RTW89_REG_H__
#define __RTW89_REG_H__

#define R_AX_SYS_WL_EFUSE_CTRL 0x000A
#define B_AX_AUTOLOAD_SUS BIT(5)

#define R_AX_SYS_ISO_CTRL 0x0000
#define B_AX_PWC_EV2EF_MASK GENMASK(15, 14)
#define B_AX_PWC_EV2EF_B15 BIT(15)
#define B_AX_PWC_EV2EF_B14 BIT(14)
#define B_AX_ISO_EB2CORE BIT(8)

#define R_AX_SYS_FUNC_EN 0x0002
#define B_AX_FEN_BB_GLB_RSTN BIT(1)
#define B_AX_FEN_BBRSTB BIT(0)

#define R_AX_SYS_PW_CTRL 0x0004
#define B_AX_SOP_ASWRM BIT(31)
#define B_AX_SOP_PWMM_DSWR BIT(29)
#define B_AX_SOP_EDSWR BIT(28)
#define B_AX_XTAL_OFF_A_DIE BIT(22)
#define B_AX_DIS_WLBT_PDNSUSEN_SOPC BIT(18)
#define B_AX_RDY_SYSPWR BIT(17)
#define B_AX_EN_WLON BIT(16)
#define B_AX_APDM_HPDN BIT(15)
#define B_AX_PSUS_OFF_CAPC_EN BIT(14)
#define B_AX_AFSM_PCIE_SUS_EN BIT(12)
#define B_AX_AFSM_WLSUS_EN BIT(11)
#define B_AX_APFM_SWLPS BIT(10)
#define B_AX_APFM_OFFMAC BIT(9)
#define B_AX_APFN_ONMAC BIT(8)

#define R_AX_SYS_CLK_CTRL 0x0008
#define B_AX_CPU_CLK_EN BIT(14)

#define R_AX_SYS_SWR_CTRL1 0x0010
#define B_AX_SYM_CTRL_SPS_PWMFREQ BIT(10)

#define R_AX_SYS_ADIE_PAD_PWR_CTRL 0x0018
#define B_AX_SYM_PADPDN_WL_PTA_1P3 BIT(6)
#define B_AX_SYM_PADPDN_WL_RFC_1P3 BIT(5)

#define R_AX_RSV_CTRL 0x001C
#define B_AX_R_DIS_PRST BIT(6)
#define B_AX_WLOCK_1C_BIT6 BIT(5)

#define R_AX_AFE_LDO_CTRL 0x0020
#define B_AX_AON_OFF_PC_EN BIT(23)

#define R_AX_EFUSE_CTRL_1 0x0038
#define B_AX_EF_PGPD_MASK GENMASK(30, 28)
#define B_AX_EF_RDT BIT(27)
#define B_AX_EF_VDDQST_MASK GENMASK(26, 24)
#define B_AX_EF_PGTS_MASK GENMASK(23, 20)
#define B_AX_EF_PD_DIS BIT(11)
#define B_AX_EF_POR BIT(10)
#define B_AX_EF_CELL_SEL_MASK GENMASK(9, 8)

#define R_AX_EFUSE_CTRL 0x0030
#define B_AX_EF_MODE_SEL_MASK GENMASK(31, 30)
#define B_AX_EF_RDY BIT(29)
#define B_AX_EF_COMP_RESULT BIT(28)
#define B_AX_EF_ADDR_MASK GENMASK(26, 16)
#define B_AX_EF_DATA_MASK GENMASK(15, 0)

#define R_AX_EFUSE_CTRL_1_V1 0x0038
#define B_AX_EF_ENT BIT(31)
#define B_AX_EF_BURST BIT(19)
#define B_AX_EF_TEST_SEL_MASK GENMASK(18, 16)
#define B_AX_EF_TROW_EN BIT(15)
#define B_AX_EF_ERR_FLAG BIT(14)
#define B_AX_EF_DSB_EN BIT(11)
#define B_AX_PCIE_CALIB_EN_V1 BIT(12)
#define B_AX_WDT_WAKE_PCIE_EN BIT(10)
#define B_AX_WDT_WAKE_USB_EN BIT(9)

#define R_AX_GPIO_MUXCFG 0x0040
#define B_AX_BOOT_MODE BIT(19)
#define B_AX_WL_EECS_EXT_32K_SEL BIT(18)
#define B_AX_WL_SEC_BONDING_OPT_STS BIT(17)
#define B_AX_SECSIC_SEL BIT(16)
#define B_AX_ENHTP BIT(14)
#define B_AX_BT_AOD_GPIO3 BIT(13)
#define B_AX_ENSIC BIT(12)
#define B_AX_SIC_SWRST BIT(11)
#define B_AX_PO_WIFI_PTA_PINS BIT(10)
#define B_AX_PO_BT_PTA_PINS BIT(9)
#define B_AX_ENUARTTX BIT(8)
#define B_AX_BTMODE_MASK GENMASK(7, 6)
#define MAC_AX_BT_MODE_0_3 0
#define MAC_AX_BT_MODE_2 2
#define MAC_AX_RTK_MODE 0
#define MAC_AX_CSR_MODE 1
#define B_AX_ENBT BIT(5)
#define B_AX_EROM_EN BIT(4)
#define B_AX_ENUARTRX BIT(2)
#define B_AX_GPIOSEL_MASK GENMASK(1, 0)

#define R_AX_DBG_CTRL 0x0058
#define B_AX_DBG_SEL1_4BIT GENMASK(31, 30)
#define B_AX_DBG_SEL1_16BIT BIT(27)
#define B_AX_DBG_SEL1 GENMASK(23, 16)
#define B_AX_DBG_SEL0_4BIT GENMASK(15, 14)
#define B_AX_DBG_SEL0_16BIT BIT(11)
#define B_AX_DBG_SEL0 GENMASK(7, 0)

#define R_AX_GPIO_EXT_CTRL 0x0060
#define B_AX_GPIO_MOD_15_TO_8_MASK GENMASK(31, 24)
#define B_AX_GPIO_MOD_9 BIT(25)
#define B_AX_GPIO_IO_SEL_15_TO_8_MASK GENMASK(23, 16)
#define B_AX_GPIO_IO_SEL_9 BIT(17)
#define B_AX_GPIO_OUT_15_TO_8_MASK GENMASK(15, 8)
#define B_AX_GPIO_IN_15_TO_8_MASK GENMASK(7, 0)
#define B_AX_GPIO_IN_9 BIT(1)

#define R_AX_SYS_SDIO_CTRL 0x0070
#define B_AX_PCIE_DIS_L2_CTRL_LDO_HCI BIT(15)
#define B_AX_PCIE_DIS_WLSUS_AFT_PDN BIT(14)
#define B_AX_PCIE_FORCE_PWR_NGAT BIT(13)
#define B_AX_PCIE_CALIB_EN_V1 BIT(12)
#define B_AX_PCIE_AUXCLK_GATE BIT(11)
#define B_AX_LTE_MUX_CTRL_PATH BIT(26)

#define R_AX_HCI_OPT_CTRL 0x0074
#define BIT_WAKE_CTRL_V1 BIT(23)
#define BIT_WAKE_CTRL BIT(5)

#define R_AX_HCI_BG_CTRL 0x0078
#define B_AX_IBX_EN_VALUE BIT(15)
#define B_AX_IB_EN_VALUE BIT(14)
#define B_AX_FORCED_IB_EN BIT(4)
#define B_AX_EN_REGBG BIT(3)
#define B_AX_R_AX_BG_LPF BIT(2)
#define B_AX_R_AX_BG GENMASK(1, 0)

#define R_AX_HCI_LDO_CTRL 0x007A
#define B_AX_R_AX_VADJ_MASK GENMASK(3, 0)

#define R_AX_PLATFORM_ENABLE 0x0088
#define B_AX_AXIDMA_EN BIT(3)
#define B_AX_APB_WRAP_EN BIT(2)
#define B_AX_WCPU_EN BIT(1)
#define B_AX_PLATFORM_EN BIT(0)

#define R_AX_WLLPS_CTRL 0x0090
#define B_AX_LPSOP_ASWRM BIT(17)
#define B_AX_LPSOP_DSWRM BIT(9)
#define B_AX_FORCE_LEAVE_LPS BIT(3)
#define B_AX_DIS_WLBT_LPSEN_LOPC BIT(1)
#define SW_LPS_OPTION 0x0001A0B2

#define R_AX_SCOREBOARD  0x00AC
#define B_AX_TOGGLE BIT(31)
#define B_MAC_AX_SB_FW_MASK GENMASK(30, 24)
#define B_MAC_AX_SB_DRV_MASK GENMASK(23, 0)
#define B_MAC_AX_BTGS1_NOTIFY BIT(0)
#define MAC_AX_NOTIFY_TP_MAJOR 0x81
#define MAC_AX_NOTIFY_PWR_MAJOR 0x80

#define R_AX_DBG_PORT_SEL 0x00C0
#define B_AX_DEBUG_ST_MASK GENMASK(31, 0)

#define R_AX_PAD_CTRL2 0x00C4
#define B_AX_FORCE_U3_CK BIT(23)
#define B_AX_USB2_FORCE BIT(22)
#define B_AX_USB3_FORCE BIT(21)
#define B_AX_USB3_USB2_TRANSITION BIT(20)
#define B_AX_USB23_SW_MODE_V1 GENMASK(19, 18)
#define USB_MODE_U2 0x1
#define USB_MODE_U3 0x2
#define B_AX_NO_PDN_CHIPOFF_V1 BIT(17)
#define B_AX_RSM_EN_V1 BIT(16)
#define B_AX_MATCH_CNT GENMASK(15, 8)
#define USB_SWITCH_DELAY 0xF

#define R_AX_PMC_DBG_CTRL2 0x00CC
#define B_AX_SYSON_DIS_PMCR_AX_WRMSK BIT(2)

#define R_AX_PCIE_MIO_INTF 0x00E4
#define B_AX_PCIE_MIO_ADDR_PAGE_V1_MASK GENMASK(20, 16)
#define B_AX_PCIE_MIO_BYIOREG BIT(13)
#define B_AX_PCIE_MIO_RE BIT(12)
#define B_AX_PCIE_MIO_WE_MASK GENMASK(11, 8)
#define MIO_WRITE_BYTE_ALL 0xF
#define B_AX_PCIE_MIO_ADDR_MASK GENMASK(7, 0)
#define MIO_ADDR_PAGE_MASK GENMASK(12, 8)

#define R_AX_PCIE_MIO_INTD 0x00E8
#define B_AX_PCIE_MIO_DATA_MASK GENMASK(31, 0)

#define R_AX_SYS_CFG1 0x00F0
#define B_AX_CHIP_VER_MASK GENMASK(15, 12)

#define R_AX_SYS_STATUS1 0x00F4
#define B_AX_SEL_0XC0_MASK GENMASK(17, 16)
#define B_AX_AUTO_WLPON BIT(10)
#define B_AX_PAD_HCI_SEL_V2_MASK GENMASK(5, 3)
#define MAC_AX_HCI_SEL_SDIO_UART 0
#define MAC_AX_HCI_SEL_MULTI_USB 1
#define MAC_AX_HCI_SEL_PCIE_UART 2
#define MAC_AX_HCI_SEL_PCIE_USB 3
#define MAC_AX_HCI_SEL_MULTI_SDIO 4

#define R_AX_HALT_H2C_CTRL 0x0160
#define R_AX_HALT_H2C 0x0168
#define B_AX_HALT_H2C_TRIGGER BIT(0)
#define R_AX_HALT_C2H_CTRL 0x0164
#define R_AX_HALT_C2H 0x016C

#define R_AX_WCPU_FW_CTRL 0x01E0
#define B_AX_IDMEM_SHARE_MODE_RECORD_MASK GENMASK(27, 24)
#define B_AX_IDMEM_SHARE_MODE_RECORD_VALID BIT(23)
#define B_AX_WCPU_FWDL_STS_MASK GENMASK(7, 5)
#define B_AX_FWDL_PATH_RDY BIT(2)
#define B_AX_H2C_PATH_RDY BIT(1)
#define B_AX_WCPU_FWDL_EN BIT(0)

#define R_AX_RPWM 0x01E4
#define R_AX_PCIE_HRPWM 0x10C0
#define PS_RPWM_TOGGLE BIT(15)
#define PS_RPWM_ACK BIT(14)
#define PS_RPWM_SEQ_NUM GENMASK(13, 12)
#define PS_RPWM_NOTIFY_WAKE BIT(8)
#define PS_RPWM_STATE 0x7
#define RPWM_SEQ_NUM_MAX 3
#define PS_CPWM_SEQ_NUM GENMASK(13, 12)
#define PS_CPWM_RSP_SEQ_NUM GENMASK(9, 8)
#define PS_CPWM_STATE GENMASK(2, 0)
#define CPWM_SEQ_NUM_MAX 3

#define R_AX_BOOT_REASON 0x01E6
#define B_AX_BOOT_REASON_MASK GENMASK(2, 0)

#define R_AX_LDM 0x01E8
#define B_AX_EN_32K BIT(31)

#define R_AX_UDM0 0x01F0
#define R_AX_UDM1 0x01F4
#define B_AX_UDM1_MASK GENMASK(31, 16)
#define B_AX_UDM1_HALMAC_C2H_ENQ_CNT_MASK GENMASK(15, 12)
#define B_AX_UDM1_HALMAC_H2C_DEQ_CNT_MASK GENMASK(11, 8)
#define B_AX_UDM1_WCPU_C2H_ENQ_CNT_MASK GENMASK(7, 4)
#define B_AX_UDM1_WCPU_H2C_DEQ_CNT_MASK GENMASK(3, 0)
#define R_AX_UDM2 0x01F8
#define R_AX_UDM3 0x01FC

#define R_AX_SPS_DIG_ON_CTRL0 0x0200
#define B_AX_VREFPFM_L_MASK GENMASK(25, 22)
#define B_AX_REG_ZCDC_H_MASK GENMASK(18, 17)
#define B_AX_OCP_L1_MASK GENMASK(15, 13)
#define B_AX_VOL_L1_MASK GENMASK(3, 0)

#define R_AX_SPSLDO_ON_CTRL1 0x0204
#define B_AX_FPWMDELAY BIT(3)

#define R_AX_LDO_AON_CTRL0 0x0218
#define B_AX_PD_REGU_L BIT(16)

#define R_AX_SPSANA_ON_CTRL1 0x0224

#define R_AX_SPS_ANA_ON_CTRL2 0x0228
#define RTL8852B_RFE_05_SPS_ANA 0x4A82

#define R_AX_WLAN_XTAL_SI_CTRL 0x0270
#define B_AX_WL_XTAL_SI_CMD_POLL BIT(31)
#define B_AX_BT_XTAL_SI_ERR_FLAG BIT(30)
#define B_AX_WL_XTAL_GNT BIT(29)
#define B_AX_BT_XTAL_GNT BIT(28)
#define B_AX_WL_XTAL_SI_MODE_MASK GENMASK(25, 24)
#define XTAL_SI_NORMAL_WRITE 0x00
#define XTAL_SI_NORMAL_READ 0x01
#define B_AX_WL_XTAL_SI_BITMASK_MASK GENMASK(23, 16)
#define B_AX_WL_XTAL_SI_DATA_MASK GENMASK(15, 8)
#define B_AX_WL_XTAL_SI_ADDR_MASK GENMASK(7, 0)

#define R_AX_WLAN_XTAL_SI_CONFIG 0x0274
#define B_AX_XTAL_SI_ADDR_NOT_CHK BIT(0)

#define R_AX_XTAL_ON_CTRL0 0x0280
#define B_AX_XTAL_SC_LPS BIT(31)
#define B_AX_XTAL_SC_XO_MASK GENMASK(23, 17)
#define B_AX_XTAL_SC_XI_MASK GENMASK(16, 10)
#define B_AX_XTAL_SC_MASK GENMASK(6, 0)

#define R_AX_XTAL_ON_CTRL3 0x028C
#define B_AX_XTAL_SC_INIT_A_BLOCK_MASK GENMASK(30, 24)
#define B_AX_XTAL_SC_LPS_A_BLOCK_MASK GENMASK(22, 16)
#define B_AX_XTAL_SC_XO_A_BLOCK_MASK GENMASK(14, 8)
#define B_AX_XTAL_SC_XI_A_BLOCK_MASK GENMASK(6, 0)

#define R_AX_GPIO0_7_FUNC_SEL 0x02D0

#define R_AX_GPIO8_15_FUNC_SEL 0x02D4
#define B_AX_PINMUX_GPIO9_FUNC_SEL_MASK GENMASK(7, 4)

#define R_AX_EECS_EESK_FUNC_SEL 0x02D8
#define B_AX_PINMUX_EESK_FUNC_SEL_MASK GENMASK(7, 4)

#define R_AX_GPIO16_23_FUNC_SEL 0x02D8
#define B_AX_PINMUX_GPIO17_FUNC_SEL_MASK GENMASK(7, 4)
#define B_AX_PINMUX_GPIO16_FUNC_SEL_MASK GENMASK(3, 0)

#define R_AX_LED1_FUNC_SEL 0x02DC
#define B_AX_PINMUX_EESK_FUNC_SEL_V1_MASK GENMASK(27, 24)
#define PINMUX_EESK_FUNC_SEL_BT_LOG 0x1

#define R_AX_GPIO0_15_EECS_EESK_LED1_PULL_LOW_EN 0x02E4
#define B_AX_LED1_PULL_LOW_EN BIT(18)
#define B_AX_EESK_PULL_LOW_EN BIT(17)
#define B_AX_EECS_PULL_LOW_EN BIT(16)

#define R_AX_GPIO0_16_EECS_EESK_LED1_PULL_LOW_EN 0x02E4
#define B_AX_GPIO16_PULL_LOW_EN_V1 BIT(19)
#define B_AX_GPIO10_PULL_LOW_EN BIT(10)

#define R_AX_WLRF_CTRL 0x02F0
#define B_AX_AFC_AFEDIG BIT(17)
#define B_AX_WLRF1_CTRL_7 BIT(15)
#define B_AX_WLRF1_CTRL_1 BIT(9)
#define B_AX_WLRF_CTRL_7 BIT(7)
#define B_AX_WLRF_CTRL_1 BIT(1)

#define R_AX_IC_PWR_STATE 0x03F0
#define B_AX_WHOLE_SYS_PWR_STE_MASK GENMASK(25, 16)
#define B_AX_WLMAC_PWR_STE_MASK GENMASK(9, 8)
#define MAC_AX_MAC_OFF 0
#define MAC_AX_MAC_ON 1
#define MAC_AX_MAC_LPS 2
#define B_AX_UART_HCISYS_PWR_STE_MASK GENMASK(7, 6)
#define B_AX_SDIO_HCISYS_PWR_STE_MASK GENMASK(5, 4)
#define B_AX_USB_HCISYS_PWR_STE_MASK GENMASK(3, 2)
#define B_AX_PCIE_HCISYS_PWR_STE_MASK GENMASK(1, 0)

#define R_AX_SPS_DIG_OFF_CTRL0 0x0400
#define B_AX_R1_L1_MASK GENMASK(7, 6)
#define B_AX_C3_L1_MASK GENMASK(5, 4)
#define B_AX_C2_L1_MASK GENMASK(3, 2)
#define B_AX_C1_L1_MASK GENMASK(1, 0)

#define R_AX_AFE_OFF_CTRL1 0x0444
#define B_AX_S1_LDO_VSEL_F_MASK GENMASK(25, 24)
#define B_AX_S1_LDO2PWRCUT_F BIT(23)
#define B_AX_S0_LDO_VSEL_F_MASK GENMASK(22, 21)

#define R_AX_DBG_WOW 0x0504
#define B_AX_DBG_WOW_CPU_IO_RX_EN BIT(8)

#define R_AX_SEC_CTRL 0x0C00
#define B_AX_SEC_IDMEM_SIZE_CONFIG_MASK GENMASK(17, 16)

#define R_AX_FILTER_MODEL_ADDR 0x0C04

#define R_AX_HAXI_INIT_CFG1 0x1000
#define B_AX_WD_ITVL_IDLE_V1_MASK GENMASK(31, 28)
#define B_AX_WD_ITVL_ACT_V1_MASK GENMASK(27, 24)
#define B_AX_DMA_MODE_MASK GENMASK(19, 18)
#define DMA_MOD_PCIE_1B 0x0
#define DMA_MOD_PCIE_4B 0x1
#define DMA_MOD_USB 0x2
#define DMA_MOD_SDIO 0x3
#define B_AX_STOP_AXI_MST BIT(17)
#define B_AX_HAXI_RST_KEEP_REG BIT(16)
#define B_AX_RXHCI_EN_V1 BIT(15)
#define B_AX_RXBD_MODE_V1 BIT(14)
#define B_AX_HAXI_MAX_RXDMA_MASK GENMASK(9, 8)
#define B_AX_TXHCI_EN_V1 BIT(7)
#define B_AX_FLUSH_AXI_MST BIT(4)
#define B_AX_RST_BDRAM BIT(3)
#define B_AX_HAXI_MAX_TXDMA_MASK GENMASK(1, 0)

#define R_AX_HAXI_DMA_STOP1 0x1010
#define B_AX_STOP_WPDMA BIT(19)
#define B_AX_STOP_CH12 BIT(18)
#define B_AX_STOP_CH9 BIT(17)
#define B_AX_STOP_CH8 BIT(16)
#define B_AX_STOP_ACH7 BIT(15)
#define B_AX_STOP_ACH6 BIT(14)
#define B_AX_STOP_ACH5 BIT(13)
#define B_AX_STOP_ACH4 BIT(12)
#define B_AX_STOP_ACH3 BIT(11)
#define B_AX_STOP_ACH2 BIT(10)
#define B_AX_STOP_ACH1 BIT(9)
#define B_AX_STOP_ACH0 BIT(8)

#define R_AX_HAXI_DMA_BUSY1 0x101C
#define B_AX_HAXIIO_BUSY BIT(20)
#define B_AX_WPDMA_BUSY BIT(19)
#define B_AX_CH12_BUSY BIT(18)
#define B_AX_CH9_BUSY BIT(17)
#define B_AX_CH8_BUSY BIT(16)
#define B_AX_ACH7_BUSY BIT(15)
#define B_AX_ACH6_BUSY BIT(14)
#define B_AX_ACH5_BUSY BIT(13)
#define B_AX_ACH4_BUSY BIT(12)
#define B_AX_ACH3_BUSY BIT(11)
#define B_AX_ACH2_BUSY BIT(10)
#define B_AX_ACH1_BUSY BIT(9)
#define B_AX_ACH0_BUSY BIT(8)

#define R_AX_USB_ENDPOINT_0 0x1060
#define B_AX_EP_IDX GENMASK(3, 0)
#define R_AX_USB_ENDPOINT_2 0x1068
#define NUMP 0x1
#define R_AX_USB_HOST_REQUEST_2 0x1078
#define B_AX_R_USBIO_MODE BIT(4)
#define R_AX_USB3_MAC_NPI_CONFIG_INTF_0 0x1114
#define B_AX_SSPHY_LFPS_FILTER BIT(31)
#define R_AX_USB_WLAN0_1 0x1174
#define B_AX_USBRX_RST BIT(9)
#define B_AX_USBTX_RST BIT(8)

#define R_AX_PCIE_DBG_CTRL 0x11C0
#define B_AX_DBG_DUMMY_MASK GENMASK(23, 16)
#define B_AX_PCIE_DBG_SEL_MASK GENMASK(15, 13)
#define B_AX_MRD_TIMEOUT_EN BIT(10)
#define B_AX_ASFF_FULL_NO_STK BIT(1)
#define B_AX_EN_STUCK_DBG BIT(0)

#define R_AX_HAXI_DMA_STOP2 0x11C0
#define B_AX_STOP_CH11 BIT(1)
#define B_AX_STOP_CH10 BIT(0)

#define R_AX_HAXI_DMA_BUSY2 0x11C8
#define B_AX_CH11_BUSY BIT(1)
#define B_AX_CH10_BUSY BIT(0)

#define R_AX_HAXI_DMA_BUSY3 0x1208
#define B_AX_RPQ_BUSY BIT(1)
#define B_AX_RXQ_BUSY BIT(0)

#define R_AX_LTR_DEC_CTRL 0x1600
#define B_AX_LTR_IDX_DRV_VLD BIT(16)
#define B_AX_LTR_CURR_IDX_DRV_MASK GENMASK(15, 14)
#define B_AX_LTR_IDX_FW_VLD BIT(13)
#define B_AX_LTR_CURR_IDX_FW_MASK GENMASK(12, 11)
#define B_AX_LTR_IDX_HW_VLD BIT(10)
#define B_AX_LTR_CURR_IDX_HW_MASK GENMASK(9, 8)
#define B_AX_LTR_REQ_DRV BIT(7)
#define B_AX_LTR_IDX_DRV_MASK GENMASK(6, 5)
#define PCIE_LTR_IDX_IDLE 3
#define B_AX_LTR_DRV_DEC_EN BIT(4)
#define B_AX_LTR_FW_DEC_EN BIT(3)
#define B_AX_LTR_HW_DEC_EN BIT(2)
#define B_AX_LTR_SPACE_IDX_V1_MASK GENMASK(1, 0)
#define LTR_EN_BITS (B_AX_LTR_HW_DEC_EN | B_AX_LTR_FW_DEC_EN | B_AX_LTR_DRV_DEC_EN)

#define R_AX_LTR_LATENCY_IDX0 0x1604
#define R_AX_LTR_LATENCY_IDX1 0x1608
#define R_AX_LTR_LATENCY_IDX2 0x160C
#define R_AX_LTR_LATENCY_IDX3 0x1610

#define R_AX_HCI_FC_CTRL_V1 0x1700
#define R_AX_CH_PAGE_CTRL_V1 0x1704

#define R_AX_ACH0_PAGE_CTRL_V1 0x1710
#define R_AX_ACH1_PAGE_CTRL_V1 0x1714
#define R_AX_ACH2_PAGE_CTRL_V1 0x1718
#define R_AX_ACH3_PAGE_CTRL_V1 0x171C
#define R_AX_ACH4_PAGE_CTRL_V1 0x1720
#define R_AX_ACH5_PAGE_CTRL_V1 0x1724
#define R_AX_ACH6_PAGE_CTRL_V1 0x1728
#define R_AX_ACH7_PAGE_CTRL_V1 0x172C
#define R_AX_CH8_PAGE_CTRL_V1 0x1730
#define R_AX_CH9_PAGE_CTRL_V1 0x1734
#define R_AX_CH10_PAGE_CTRL_V1 0x1738
#define R_AX_CH11_PAGE_CTRL_V1 0x173C

#define R_AX_ACH0_PAGE_INFO_V1 0x1750
#define R_AX_ACH1_PAGE_INFO_V1 0x1754
#define R_AX_ACH2_PAGE_INFO_V1 0x1758
#define R_AX_ACH3_PAGE_INFO_V1 0x175C
#define R_AX_ACH4_PAGE_INFO_V1 0x1760
#define R_AX_ACH5_PAGE_INFO_V1 0x1764
#define R_AX_ACH6_PAGE_INFO_V1 0x1768
#define R_AX_ACH7_PAGE_INFO_V1 0x176C
#define R_AX_CH8_PAGE_INFO_V1 0x1770
#define R_AX_CH9_PAGE_INFO_V1 0x1774
#define R_AX_CH10_PAGE_INFO_V1 0x1778
#define R_AX_CH11_PAGE_INFO_V1 0x177C
#define R_AX_CH12_PAGE_INFO_V1 0x1780

#define R_AX_PUB_PAGE_INFO3_V1 0x178C
#define R_AX_PUB_PAGE_CTRL1_V1 0x1790
#define R_AX_PUB_PAGE_CTRL2_V1 0x1794
#define R_AX_PUB_PAGE_INFO1_V1 0x1798
#define R_AX_PUB_PAGE_INFO2_V1 0x179C
#define R_AX_WP_PAGE_CTRL1_V1 0x17A0
#define R_AX_WP_PAGE_CTRL2_V1 0x17A4
#define R_AX_WP_PAGE_INFO1_V1 0x17A8

#define R_AX_USB_ENDPOINT_0_V1 0x5060
#define B_AX_EP_IDX_V1 GENMASK(3, 0)
#define R_AX_USB_ENDPOINT_2_V1 0x5068
#define R_AX_USB_HOST_REQUEST_2_V1 0x5078
#define B_AX_R_USBIO_MODE_V1 BIT(4)
#define R_AX_USB3_MAC_NPI_CONFIG_INTF_0_V1 0x5114
#define B_AX_SSPHY_LFPS_FILTER_V1 BIT(31)
#define R_AX_USB_WLAN0_1_V1 0x5174
#define B_AX_USBRX_RST_V1 BIT(9)
#define B_AX_USBTX_RST_V1 BIT(8)

#define R_AX_H2CREG_DATA0_V1 0x7140
#define R_AX_H2CREG_DATA1_V1 0x7144
#define R_AX_H2CREG_DATA2_V1 0x7148
#define R_AX_H2CREG_DATA3_V1 0x714C
#define R_AX_C2HREG_DATA0_V1 0x7150
#define R_AX_C2HREG_DATA1_V1 0x7154
#define R_AX_C2HREG_DATA2_V1 0x7158
#define R_AX_C2HREG_DATA3_V1 0x715C
#define R_AX_H2CREG_CTRL_V1 0x7160
#define R_AX_C2HREG_CTRL_V1 0x7164

#define R_AX_HCI_FUNC_EN_V1 0x7880

#define R_AX_PHYREG_SET 0x8040
#define PHYREG_SET_ALL_CYCLE 0x8
#define PHYREG_SET_XYN_CYCLE 0xE

#define R_AX_HD0IMR 0x8110
#define B_AX_WDT_PTFM_INT_EN BIT(5)
#define B_AX_CPWM_INT_EN BIT(2)
#define B_AX_GT3_INT_EN BIT(1)
#define B_AX_C2H_INT_EN BIT(0)
#define R_AX_HD0ISR 0x8114
#define B_AX_C2H_INT BIT(0)

#define R_AX_H2CREG_DATA0 0x8140
#define R_AX_H2CREG_DATA1 0x8144
#define R_AX_H2CREG_DATA2 0x8148
#define R_AX_H2CREG_DATA3 0x814C
#define R_AX_C2HREG_DATA0 0x8150
#define R_AX_C2HREG_DATA1 0x8154
#define R_AX_C2HREG_DATA2 0x8158
#define R_AX_C2HREG_DATA3 0x815C
#define R_AX_H2CREG_CTRL 0x8160
#define B_AX_H2CREG_TRIGGER BIT(0)
#define R_AX_C2HREG_CTRL 0x8164
#define B_AX_C2HREG_TRIGGER BIT(0)
#define R_AX_CPWM 0x8170

#define R_AX_HCI_FUNC_EN 0x8380
#define B_AX_HCI_RXDMA_EN BIT(1)
#define B_AX_HCI_TXDMA_EN BIT(0)

#define R_AX_BOOT_DBG 0x83F0

#define R_AX_DMAC_FUNC_EN 0x8400
#define B_AX_DMAC_CRPRT BIT(31)
#define B_AX_MAC_FUNC_EN BIT(30)
#define B_AX_DMAC_FUNC_EN BIT(29)
#define B_AX_MPDU_PROC_EN BIT(28)
#define B_AX_WD_RLS_EN BIT(27)
#define B_AX_DLE_WDE_EN BIT(26)
#define B_AX_TXPKT_CTRL_EN BIT(25)
#define B_AX_STA_SCH_EN BIT(24)
#define B_AX_DLE_PLE_EN BIT(23)
#define B_AX_PKT_BUF_EN BIT(22)
#define B_AX_DMAC_TBL_EN BIT(21)
#define B_AX_PKT_IN_EN BIT(20)
#define B_AX_DLE_CPUIO_EN BIT(19)
#define B_AX_DISPATCHER_EN BIT(18)
#define B_AX_BBRPT_EN BIT(17)
#define B_AX_MAC_SEC_EN BIT(16)
#define B_AX_DMACREG_GCKEN BIT(15)
#define B_AX_MAC_UN_EN BIT(15)
#define B_AX_H_AXIDMA_EN BIT(14)

#define R_AX_DMAC_CLK_EN 0x8404
#define B_AX_WD_RLS_CLK_EN BIT(27)
#define B_AX_DLE_WDE_CLK_EN BIT(26)
#define B_AX_TXPKT_CTRL_CLK_EN BIT(25)
#define B_AX_STA_SCH_CLK_EN BIT(24)
#define B_AX_DLE_PLE_CLK_EN BIT(23)
#define B_AX_PKT_IN_CLK_EN BIT(20)
#define B_AX_DLE_CPUIO_CLK_EN BIT(19)
#define B_AX_DISPATCHER_CLK_EN BIT(18)
#define B_AX_BBRPT_CLK_EN BIT(17)
#define B_AX_MAC_SEC_CLK_EN BIT(16)
#define B_AX_AXIDMA_CLK_EN BIT(9)

#define PCI_LTR_IDLE_TIMER_1US 0
#define PCI_LTR_IDLE_TIMER_10US 1
#define PCI_LTR_IDLE_TIMER_100US 2
#define PCI_LTR_IDLE_TIMER_200US 3
#define PCI_LTR_IDLE_TIMER_400US 4
#define PCI_LTR_IDLE_TIMER_800US 5
#define PCI_LTR_IDLE_TIMER_1_6MS 6
#define PCI_LTR_IDLE_TIMER_3_2MS 7
#define PCI_LTR_IDLE_TIMER_R_ERR 0xFD
#define PCI_LTR_IDLE_TIMER_DEF 0xFE
#define PCI_LTR_IDLE_TIMER_IGNORE 0xFF

#define PCI_LTR_SPC_10US 0
#define PCI_LTR_SPC_100US 1
#define PCI_LTR_SPC_500US 2
#define PCI_LTR_SPC_1MS 3
#define PCI_LTR_SPC_R_ERR 0xFD
#define PCI_LTR_SPC_DEF 0xFE
#define PCI_LTR_SPC_IGNORE 0xFF

#define R_AX_LTR_CTRL_0 0x8410
#define B_AX_LTR_SPACE_IDX_MASK GENMASK(13, 12)
#define B_AX_LTR_IDLE_TIMER_IDX_MASK GENMASK(10, 8)
#define B_AX_LTR_WD_NOEMP_CHK BIT(6)
#define B_AX_APP_LTR_ACT BIT(5)
#define B_AX_APP_LTR_IDLE BIT(4)
#define B_AX_LTR_EN BIT(1)
#define B_AX_LTR_WD_NOEMP_CHK_V1 BIT(1)
#define B_AX_LTR_HW_EN BIT(0)

#define R_AX_LTR_CTRL_1 0x8414
#define B_AX_LTR_RX1_TH_MASK GENMASK(27, 16)
#define B_AX_LTR_RX0_TH_MASK GENMASK(11, 0)

#define R_AX_LTR_IDLE_LATENCY 0x8418

#define R_AX_LTR_ACTIVE_LATENCY 0x841C

#define R_AX_SER_DBG_INFO 0x8424
#define B_AX_L0_TO_L1_EVENT_MASK GENMASK(31, 28)
#define B_AX_SER_L1_COUNTER_MASK GENMASK(27, 24)
#define B_AX_RMAC_PPDU_HANG_CNT_MASK GENMASK(23, 16)
#define B_AX_SER_L0_COUNTER_MASK GENMASK(7, 0)

#define R_AX_DLE_EMPTY0 0x8430
#define B_AX_PLE_EMPTY_QTA_DMAC_CPUIO BIT(26)
#define B_AX_PLE_EMPTY_QTA_DMAC_MPDU_TX BIT(25)
#define B_AX_PLE_EMPTY_QTA_DMAC_WLAN_CPU BIT(24)
#define B_AX_PLE_EMPTY_QTA_DMAC_H2C BIT(23)
#define B_AX_PLE_EMPTY_QTA_DMAC_B1_TXPL BIT(22)
#define B_AX_PLE_EMPTY_QTA_DMAC_B0_TXPL BIT(21)
#define B_AX_WDE_EMPTY_QTA_DMAC_CPUIO BIT(20)
#define B_AX_WDE_EMPTY_QTA_DMAC_PKTIN BIT(19)
#define B_AX_WDE_EMPTY_QTA_DMAC_DATA_CPU BIT(18)
#define B_AX_WDE_EMPTY_QTA_DMAC_WLAN_CPU BIT(17)
#define B_AX_WDE_EMPTY_QTA_DMAC_HIF BIT(16)
#define B_AX_WDE_EMPTY_QUE_DMAC_PKTIN BIT(10)
#define B_AX_PLE_EMPTY_QUE_DMAC_SEC_TX BIT(9)
#define B_AX_PLE_EMPTY_QUE_DMAC_MPDU_TX BIT(8)
#define B_AX_WDE_EMPTY_QUE_OTHERS BIT(7)
#define B_AX_WDE_EMPTY_QUE_CMAC0_WMM1 BIT(4)
#define B_AX_WDE_EMPTY_QUE_CMAC0_WMM0 BIT(3)
#define B_AX_WDE_EMPTY_QUE_CMAC1_MBH BIT(2)
#define B_AX_WDE_EMPTY_QUE_CMAC0_MBH BIT(1)
#define B_AX_WDE_EMPTY_QUE_CMAC0_ALL_AC BIT(0)

#define R_AX_DLE_EMPTY1 0x8434
#define B_AX_PLE_EMPTY_QTA_DMAC_WDRLS BIT(20)
#define B_AX_PLE_EMPTY_QTA_CMAC1_DMA_BBRPT BIT(19)
#define B_AX_PLE_EMPTY_QTA_CMAC1_DMA_RX BIT(18)
#define B_AX_PLE_EMPTY_QTA_CMAC0_DMA_RX BIT(17)
#define B_AX_PLE_EMPTY_QTA_DMAC_C2H BIT(16)
#define B_AX_PLE_EMPTY_QUE_DMAC_PLRLS BIT(5)
#define B_AX_PLE_EMPTY_QUE_DMAC_CPUIO BIT(4)
#define B_AX_PLE_EMPTY_QUE_DMAC_SEC_RX BIT(3)
#define B_AX_PLE_EMPTY_QUE_DMAC_MPDU_RX BIT(2)
#define B_AX_PLE_EMPTY_QUE_DMAC_HDP BIT(1)
#define B_AX_WDE_EMPTY_QUE_DMAC_WDRLS BIT(0)

#define R_AX_DMAC_ERR_IMR 0x8520
#define B_AX_DLE_CPUIO_ERR_INT_EN BIT(10)
#define B_AX_APB_BRIDGE_ERR_INT_EN BIT(9)
#define B_AX_DISPATCH_ERR_INT_EN BIT(8)
#define B_AX_PKTIN_ERR_INT_EN BIT(7)
#define B_AX_PLE_DLE_ERR_INT_EN BIT(6)
#define B_AX_TXPKTCTRL_ERR_INT_EN BIT(5)
#define B_AX_WDE_DLE_ERR_INT_EN BIT(4)
#define B_AX_STA_SCHEDULER_ERR_INT_EN BIT(3)
#define B_AX_MPDU_ERR_INT_EN BIT(2)
#define B_AX_WSEC_ERR_INT_EN BIT(1)
#define B_AX_WDRLS_ERR_INT_EN BIT(0)
#define DMAC_ERR_IMR_EN GENMASK(31, 0)
#define DMAC_ERR_IMR_DIS 0

#define R_AX_DMAC_ERR_ISR 0x8524
#define B_AX_HAXIDMA_ERR_FLAG BIT(14)
#define B_AX_PAXIDMA_ERR_FLAG BIT(13)
#define B_AX_HCI_BUF_ERR_FLAG BIT(12)
#define B_AX_BBRPT_ERR_FLAG BIT(11)
#define B_AX_DLE_CPUIO_ERR_FLAG BIT(10)
#define B_AX_APB_BRIDGE_ERR_FLAG BIT(9)
#define B_AX_DISPATCH_ERR_FLAG BIT(8)
#define B_AX_PKTIN_ERR_FLAG BIT(7)
#define B_AX_PLE_DLE_ERR_FLAG BIT(6)
#define B_AX_TXPKTCTRL_ERR_FLAG BIT(5)
#define B_AX_WDE_DLE_ERR_FLAG BIT(4)
#define B_AX_STA_SCHEDULER_ERR_FLAG BIT(3)
#define B_AX_MPDU_ERR_FLAG BIT(2)
#define B_AX_WSEC_ERR_FLAG BIT(1)
#define B_AX_WDRLS_ERR_FLAG BIT(0)

#define R_AX_DISPATCHER_GLOBAL_SETTING_0 0x8800
#define B_AX_PL_PAGE_128B_SEL BIT(9)
#define B_AX_WD_PAGE_64B_SEL BIT(8)
#define R_AX_OTHER_DISPATCHER_ERR_ISR 0x8804
#define R_AX_HOST_DISPATCHER_ERR_ISR 0x8808
#define R_AX_CPU_DISPATCHER_ERR_ISR 0x880C
#define R_AX_TX_ADDRESS_INFO_MODE_SETTING 0x8810
#define B_AX_HOST_ADDR_INFO_8B_SEL BIT(0)

#define R_AX_HOST_DISPATCHER_ERR_IMR 0x8850
#define B_AX_HDT_RX_WRITE_UNDERFLOW_INT_EN BIT(31)
#define B_AX_HDT_RX_WRITE_OVERFLOW_INT_EN BIT(30)
#define B_AX_HDT_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_AX_HDT_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_AX_HDT_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_AX_HDT_TOTAL_LEN_ERR_INT_EN BIT(26)
#define B_AX_HDT_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_AX_HDT_RXAGG_CFG_ERR_INT_EN BIT(24)
#define B_AX_HDT_OUTPUT_ERR_INT_EN BIT(21)
#define B_AX_HDT_RES_ERR_INT_EN BIT(20)
#define B_AX_HDT_BURST_NUM_ERR_INT_EN BIT(19)
#define B_AX_HDT_NULLPKT_ERR_INT_EN BIT(18)
#define B_AX_HDT_FLOW_CTRL_ERR_INT_EN BIT(17)
#define B_AX_HDT_PLD_CMD_UNDERFLOW_INT_EN BIT(16)
#define B_AX_HDT_PLD_CMD_OVERLOW_INT_EN BIT(15)
#define B_AX_HDT_TX_WRITE_UNDERFLOW_INT_EN BIT(14)
#define B_AX_HDT_TX_WRITE_OVERFLOW_INT_EN BIT(13)
#define B_AX_HDT_TCP_CHK_ERR_INT_EN BIT(12)
#define B_AX_HDT_TXPKTSIZE_ERR_INT_EN BIT(11)
#define B_AX_HDT_PRE_COST_ERR_INT_EN BIT(10)
#define B_AX_HDT_WD_CHK_ERR_INT_EN BIT(9)
#define B_AX_HDT_CHANNEL_DMA_ERR_INT_EN BIT(8)
#define B_AX_HDT_OFFSET_UNMATCH_INT_EN BIT(7)
#define B_AX_HDT_PAYLOAD_UNDERFLOW_INT_EN BIT(6)
#define B_AX_HDT_PAYLOAD_OVERFLOW_INT_EN BIT(5)
#define B_AX_HDT_PERMU_UNDERFLOW_INT_EN BIT(4)
#define B_AX_HDT_PERMU_OVERFLOW_INT_EN BIT(3)
#define B_AX_HDT_PKT_FAIL_DBG_INT_EN BIT(2)
#define B_AX_HDT_CHANNEL_ID_ERR_INT_EN BIT(1)
#define B_AX_HDT_CHANNEL_DIFF_ERR_INT_EN BIT(0)
#define B_AX_HOST_DISP_IMR_CLR (B_AX_HDT_CHANNEL_DIFF_ERR_INT_EN | \
				B_AX_HDT_CHANNEL_ID_ERR_INT_EN | \
				B_AX_HDT_PKT_FAIL_DBG_INT_EN | \
				B_AX_HDT_PERMU_OVERFLOW_INT_EN | \
				B_AX_HDT_PERMU_UNDERFLOW_INT_EN | \
				B_AX_HDT_PAYLOAD_OVERFLOW_INT_EN | \
				B_AX_HDT_PAYLOAD_UNDERFLOW_INT_EN | \
				B_AX_HDT_OFFSET_UNMATCH_INT_EN | \
				B_AX_HDT_CHANNEL_DMA_ERR_INT_EN | \
				B_AX_HDT_WD_CHK_ERR_INT_EN | \
				B_AX_HDT_PRE_COST_ERR_INT_EN | \
				B_AX_HDT_TXPKTSIZE_ERR_INT_EN | \
				B_AX_HDT_TCP_CHK_ERR_INT_EN | \
				B_AX_HDT_TX_WRITE_OVERFLOW_INT_EN | \
				B_AX_HDT_TX_WRITE_UNDERFLOW_INT_EN | \
				B_AX_HDT_PLD_CMD_OVERLOW_INT_EN | \
				B_AX_HDT_PLD_CMD_UNDERFLOW_INT_EN | \
				B_AX_HDT_FLOW_CTRL_ERR_INT_EN | \
				B_AX_HDT_NULLPKT_ERR_INT_EN | \
				B_AX_HDT_BURST_NUM_ERR_INT_EN | \
				B_AX_HDT_RXAGG_CFG_ERR_INT_EN | \
				B_AX_HDT_SHIFT_EN_ERR_INT_EN | \
				B_AX_HDT_TOTAL_LEN_ERR_INT_EN | \
				B_AX_HDT_DMA_PROCESS_ERR_INT_EN | \
				B_AX_HDT_SHIFT_DMA_CFG_ERR_INT_EN | \
				B_AX_HDT_CHKSUM_FSM_ERR_INT_EN | \
				B_AX_HDT_RX_WRITE_OVERFLOW_INT_EN | \
				B_AX_HDT_RX_WRITE_UNDERFLOW_INT_EN)
#define B_AX_HOST_DISP_IMR_SET (B_AX_HDT_CHANNEL_DIFF_ERR_INT_EN | \
				B_AX_HDT_PAYLOAD_OVERFLOW_INT_EN | \
				B_AX_HDT_PAYLOAD_UNDERFLOW_INT_EN | \
				B_AX_HDT_CHANNEL_DMA_ERR_INT_EN | \
				B_AX_HDT_TOTAL_LEN_ERR_INT_EN | \
				B_AX_HDT_DMA_PROCESS_ERR_INT_EN)
#define B_AX_HOST_DISP_IMR_SET_V01 (B_AX_HDT_CHANNEL_DIFF_ERR_INT_EN | \
				    B_AX_HDT_PAYLOAD_OVERFLOW_INT_EN | \
				    B_AX_HDT_PAYLOAD_UNDERFLOW_INT_EN | \
				    B_AX_HDT_CHANNEL_DMA_ERR_INT_EN | \
				    B_AX_HDT_TOTAL_LEN_ERR_INT_EN | \
				    B_AX_HDT_DMA_PROCESS_ERR_INT_EN | \
				    B_AX_HDT_RX_WRITE_OVERFLOW_INT_EN | \
				    B_AX_HDT_RX_WRITE_UNDERFLOW_INT_EN)

#define B_AX_HR_WRFF_UNDERFLOW_ERR_INT_EN BIT(31)
#define B_AX_HR_WRFF_OVERFLOW_ERR_INT_EN BIT(30)
#define B_AX_HR_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_AX_HR_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_AX_HR_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_AX_HR_TOTAL_LEN_UNDER_ERR_INT_EN BIT(26)
#define B_AX_HR_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_AX_HR_AGG_CFG_ERR_INT_EN BIT(24)
#define B_AX_HR_DMA_RD_CNT_DEQ_ERR_INT_EN BIT(23)
#define B_AX_HR_PLD_LEN_ZERO_ERR_INT_EN BIT(22)
#define B_AX_HT_ILL_CH_ERR_INT_EN BIT(20)
#define B_AX_HT_ADDR_INFO_LEN_ERR_INT_EN BIT(18)
#define B_AX_HT_WD_LEN_OVER_ERR_INT_EN BIT(17)
#define B_AX_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN BIT(16)
#define B_AX_HT_PLD_CMD_OVERFLOW_ERR_INT_EN BIT(15)
#define B_AX_HT_WRFF_UNDERFLOW_ERR_INT_EN BIT(14)
#define B_AX_HT_WRFF_OVERFLOW_ERR_INT_EN BIT(13)
#define B_AX_HT_CHKSUM_FSM_ERR_INT_EN BIT(12)
#define B_AX_HT_TXPKTSIZE_ERR_INT_EN BIT(11)
#define B_AX_HT_PRE_SUB_ERR_INT_EN BIT(10)
#define B_AX_HT_WD_CHKSUM_ERR_INT_EN BIT(9)
#define B_AX_HT_CHANNEL_DMA_ERR_INT_EN BIT(8)
#define B_AX_HT_OFFSET_UNMATCH_ERR_INT_EN BIT(7)
#define B_AX_HT_PAYLOAD_UNDER_ERR_INT_EN BIT(6)
#define B_AX_HT_PAYLOAD_OVER_ERR_INT_EN BIT(5)
#define B_AX_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN BIT(4)
#define B_AX_HT_PERMU_FF_OVERFLOW_ERR_INT_EN BIT(3)
#define B_AX_HT_PKT_FAIL_ERR_INT_EN BIT(2)
#define B_AX_HT_CH_ID_ERR_INT_EN BIT(1)
#define B_AX_HT_EP_CH_DIFF_ERR_INT_EN BIT(0)
#define B_AX_HOST_DISP_IMR_CLR_V1 (B_AX_HT_EP_CH_DIFF_ERR_INT_EN | \
				   B_AX_HT_CH_ID_ERR_INT_EN | \
				   B_AX_HT_PKT_FAIL_ERR_INT_EN | \
				   B_AX_HT_PERMU_FF_OVERFLOW_ERR_INT_EN | \
				   B_AX_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN | \
				   B_AX_HT_PAYLOAD_OVER_ERR_INT_EN | \
				   B_AX_HT_PAYLOAD_UNDER_ERR_INT_EN | \
				   B_AX_HT_OFFSET_UNMATCH_ERR_INT_EN | \
				   B_AX_HT_CHANNEL_DMA_ERR_INT_EN | \
				   B_AX_HT_WD_CHKSUM_ERR_INT_EN | \
				   B_AX_HT_PRE_SUB_ERR_INT_EN | \
				   B_AX_HT_TXPKTSIZE_ERR_INT_EN | \
				   B_AX_HT_CHKSUM_FSM_ERR_INT_EN | \
				   B_AX_HT_WRFF_OVERFLOW_ERR_INT_EN | \
				   B_AX_HT_WRFF_UNDERFLOW_ERR_INT_EN | \
				   B_AX_HT_PLD_CMD_OVERFLOW_ERR_INT_EN | \
				   B_AX_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN | \
				   B_AX_HT_WD_LEN_OVER_ERR_INT_EN | \
				   B_AX_HT_ADDR_INFO_LEN_ERR_INT_EN | \
				   B_AX_HT_ILL_CH_ERR_INT_EN | \
				   B_AX_HR_PLD_LEN_ZERO_ERR_INT_EN | \
				   B_AX_HR_DMA_RD_CNT_DEQ_ERR_INT_EN | \
				   B_AX_HR_AGG_CFG_ERR_INT_EN | \
				   B_AX_HR_SHIFT_EN_ERR_INT_EN | \
				   B_AX_HR_TOTAL_LEN_UNDER_ERR_INT_EN | \
				   B_AX_HR_DMA_PROCESS_ERR_INT_EN | \
				   B_AX_HR_SHIFT_DMA_CFG_ERR_INT_EN | \
				   B_AX_HR_CHKSUM_FSM_ERR_INT_EN | \
				   B_AX_HR_WRFF_OVERFLOW_ERR_INT_EN | \
				   B_AX_HR_WRFF_UNDERFLOW_ERR_INT_EN)
#define B_AX_HOST_DISP_IMR_SET_V1 (B_AX_HT_PAYLOAD_OVER_ERR_INT_EN | \
				   B_AX_HT_PAYLOAD_UNDER_ERR_INT_EN | \
				   B_AX_HT_ILL_CH_ERR_INT_EN | \
				   B_AX_HR_TOTAL_LEN_UNDER_ERR_INT_EN | \
				   B_AX_HR_DMA_PROCESS_ERR_INT_EN)

#define R_AX_CPU_DISPATCHER_ERR_IMR 0x8854
#define B_AX_CPU_RX_WRITE_UNDERFLOW_INT_EN BIT(31)
#define B_AX_CPU_RX_WRITE_OVERFLOW_INT_EN BIT(30)
#define B_AX_CPU_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_AX_CPU_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_AX_CPU_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_AX_CPU_TOTAL_LEN_ERR_INT_EN BIT(26)
#define B_AX_CPU_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_AX_CPU_RXAGG_CFG_ERR_INT_EN BIT(24)
#define B_AX_CPU_OUTPUT_ERR_INT_EN BIT(20)
#define B_AX_CPU_RESP_ERR_INT_EN BIT(19)
#define B_AX_CPU_BURST_NUM_ERR_INT_EN BIT(18)
#define B_AX_CPU_NULLPKT_ERR_INT_EN BIT(17)
#define B_AX_CPU_FLOW_CTRL_ERR_INT_EN BIT(16)
#define B_AX_CPU_F2P_SEQ_ERR_INT_EN BIT(15)
#define B_AX_CPU_F2P_QSEL_ERR_INT_EN BIT(14)
#define B_AX_CPU_PLD_CMD_UNDERFLOW_INT_EN BIT(13)
#define B_AX_CPU_PLD_CMD_OVERLOW_INT_EN BIT(12)
#define B_AX_CPU_PRE_COST_ERR_INT_EN BIT(11)
#define B_AX_CPU_WD_CHK_ERR_INT_EN BIT(10)
#define B_AX_CPU_CHANNEL_DMA_ERR_INT_EN BIT(9)
#define B_AX_CPU_OFFSET_UNMATCH_INT_EN BIT(8)
#define B_AX_CPU_PAYLOAD_CHKSUM_ERR_INT_EN BIT(7)
#define B_AX_CPU_PAYLOAD_UNDERFLOW_INT_EN BIT(6)
#define B_AX_CPU_PAYLOAD_OVERFLOW_INT_EN BIT(5)
#define B_AX_CPU_PERMU_UNDERFLOW_INT_EN BIT(4)
#define B_AX_CPU_PERMU_OVERFLOW_INT_EN BIT(3)
#define B_AX_CPU_CHANNEL_ID_ERR_INT_EN BIT(2)
#define B_AX_CPU_PKT_FAIL_DBG_INT_EN BIT(1)
#define B_AX_CPU_CHANNEL_DIFF_ERR_INT_EN BIT(0)
#define B_AX_CPU_DISP_IMR_CLR (B_AX_CPU_CHANNEL_DIFF_ERR_INT_EN | \
			       B_AX_CPU_PKT_FAIL_DBG_INT_EN | \
			       B_AX_CPU_CHANNEL_ID_ERR_INT_EN | \
			       B_AX_CPU_PERMU_OVERFLOW_INT_EN | \
			       B_AX_CPU_PERMU_UNDERFLOW_INT_EN | \
			       B_AX_CPU_PAYLOAD_OVERFLOW_INT_EN | \
			       B_AX_CPU_PAYLOAD_UNDERFLOW_INT_EN | \
			       B_AX_CPU_PAYLOAD_CHKSUM_ERR_INT_EN | \
			       B_AX_CPU_OFFSET_UNMATCH_INT_EN | \
			       B_AX_CPU_CHANNEL_DMA_ERR_INT_EN | \
			       B_AX_CPU_WD_CHK_ERR_INT_EN | \
			       B_AX_CPU_PRE_COST_ERR_INT_EN | \
			       B_AX_CPU_PLD_CMD_OVERLOW_INT_EN | \
			       B_AX_CPU_PLD_CMD_UNDERFLOW_INT_EN | \
			       B_AX_CPU_F2P_QSEL_ERR_INT_EN | \
			       B_AX_CPU_F2P_SEQ_ERR_INT_EN | \
			       B_AX_CPU_FLOW_CTRL_ERR_INT_EN | \
			       B_AX_CPU_NULLPKT_ERR_INT_EN | \
			       B_AX_CPU_BURST_NUM_ERR_INT_EN | \
			       B_AX_CPU_RXAGG_CFG_ERR_INT_EN | \
			       B_AX_CPU_SHIFT_EN_ERR_INT_EN | \
			       B_AX_CPU_TOTAL_LEN_ERR_INT_EN | \
			       B_AX_CPU_DMA_PROCESS_ERR_INT_EN | \
			       B_AX_CPU_SHIFT_DMA_CFG_ERR_INT_EN | \
			       B_AX_CPU_CHKSUM_FSM_ERR_INT_EN | \
			       B_AX_CPU_RX_WRITE_OVERFLOW_INT_EN | \
			       B_AX_CPU_RX_WRITE_UNDERFLOW_INT_EN)
#define B_AX_CPU_DISP_IMR_SET (B_AX_CPU_PKT_FAIL_DBG_INT_EN | \
			       B_AX_CPU_PAYLOAD_OVERFLOW_INT_EN | \
			       B_AX_CPU_PAYLOAD_UNDERFLOW_INT_EN | \
			       B_AX_CPU_TOTAL_LEN_ERR_INT_EN)

#define B_AX_CR_PLD_LEN_ERR_INT_EN BIT(30)
#define B_AX_CR_WRFF_UNDERFLOW_ERR_INT_EN BIT(29)
#define B_AX_CR_WRFF_OVERFLOW_ERR_INT_EN BIT(28)
#define B_AX_CR_SHIFT_DMA_CFG_ERR_INT_EN BIT(27)
#define B_AX_CR_DMA_PROCESS_ERR_INT_EN BIT(26)
#define B_AX_CR_TOTAL_LEN_UNDER_ERR_INT_EN BIT(25)
#define B_AX_CR_SHIFT_EN_ERR_INT_EN BIT(24)
#define B_AX_REUSE_FIFO_B_UNDER_ERR_INT_EN BIT(22)
#define B_AX_REUSE_FIFO_B_OVER_ERR_INT_EN BIT(21)
#define B_AX_REUSE_FIFO_A_UNDER_ERR_INT_EN BIT(20)
#define B_AX_REUSE_FIFO_A_OVER_ERR_INT_EN BIT(19)
#define B_AX_CT_ADDR_INFO_LEN_MISS_ERR_INT_EN BIT(17)
#define B_AX_CT_WD_LEN_OVER_ERR_INT_EN BIT(16)
#define B_AX_CT_F2P_SEQ_ERR_INT_EN BIT(15)
#define B_AX_CT_F2P_QSEL_ERR_INT_EN BIT(14)
#define B_AX_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN BIT(13)
#define B_AX_CT_PLD_CMD_OVERFLOW_ERR_INT_EN BIT(12)
#define B_AX_CT_PRE_SUB_ERR_INT_EN BIT(11)
#define B_AX_CT_WD_CHKSUM_ERR_INT_EN BIT(10)
#define B_AX_CT_CHANNEL_DMA_ERR_INT_EN BIT(9)
#define B_AX_CT_OFFSET_UNMATCH_ERR_INT_EN BIT(8)
#define B_AX_CT_PAYLOAD_CHKSUM_ERR_INT_EN BIT(7)
#define B_AX_CT_PAYLOAD_UNDER_ERR_INT_EN BIT(6)
#define B_AX_CT_PAYLOAD_OVER_ERR_INT_EN BIT(5)
#define B_AX_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN BIT(4)
#define B_AX_CT_PERMU_FF_OVERFLOW_ERR_INT_EN BIT(3)
#define B_AX_CT_CH_ID_ERR_INT_EN BIT(2)
#define B_AX_CT_EP_CH_DIFF_ERR_INT_EN BIT(0)
#define B_AX_CPU_DISP_IMR_CLR_V1 (B_AX_CT_EP_CH_DIFF_ERR_INT_EN | \
				  B_AX_CT_CH_ID_ERR_INT_EN | \
				  B_AX_CT_PERMU_FF_OVERFLOW_ERR_INT_EN | \
				  B_AX_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN | \
				  B_AX_CT_PAYLOAD_OVER_ERR_INT_EN | \
				  B_AX_CT_PAYLOAD_UNDER_ERR_INT_EN | \
				  B_AX_CT_PAYLOAD_CHKSUM_ERR_INT_EN | \
				  B_AX_CT_OFFSET_UNMATCH_ERR_INT_EN | \
				  B_AX_CT_CHANNEL_DMA_ERR_INT_EN | \
				  B_AX_CT_WD_CHKSUM_ERR_INT_EN | \
				  B_AX_CT_PRE_SUB_ERR_INT_EN | \
				  B_AX_CT_PLD_CMD_OVERFLOW_ERR_INT_EN | \
				  B_AX_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN | \
				  B_AX_CT_F2P_QSEL_ERR_INT_EN | \
				  B_AX_CT_F2P_SEQ_ERR_INT_EN | \
				  B_AX_CT_WD_LEN_OVER_ERR_INT_EN | \
				  B_AX_CT_ADDR_INFO_LEN_MISS_ERR_INT_EN | \
				  B_AX_REUSE_FIFO_A_OVER_ERR_INT_EN | \
				  B_AX_REUSE_FIFO_A_UNDER_ERR_INT_EN | \
				  B_AX_REUSE_FIFO_B_OVER_ERR_INT_EN | \
				  B_AX_REUSE_FIFO_B_UNDER_ERR_INT_EN | \
				  B_AX_CR_SHIFT_EN_ERR_INT_EN | \
				  B_AX_CR_TOTAL_LEN_UNDER_ERR_INT_EN | \
				  B_AX_CR_DMA_PROCESS_ERR_INT_EN | \
				  B_AX_CR_SHIFT_DMA_CFG_ERR_INT_EN | \
				  B_AX_CR_WRFF_OVERFLOW_ERR_INT_EN | \
				  B_AX_CR_WRFF_UNDERFLOW_ERR_INT_EN | \
				  B_AX_CR_PLD_LEN_ERR_INT_EN)
#define B_AX_CPU_DISP_IMR_SET_V1 (B_AX_CT_PAYLOAD_OVER_ERR_INT_EN | \
				  B_AX_CT_PAYLOAD_UNDER_ERR_INT_EN | \
				  B_AX_CR_TOTAL_LEN_UNDER_ERR_INT_EN | \
				  B_AX_CR_DMA_PROCESS_ERR_INT_EN | \
				  B_AX_CR_WRFF_OVERFLOW_ERR_INT_EN | \
				  B_AX_CR_WRFF_UNDERFLOW_ERR_INT_EN)

#define R_AX_OTHER_DISPATCHER_ERR_IMR 0x8858
#define B_AX_OTHER_STF_WROQT_UNDERFLOW_INT_EN BIT(29)
#define B_AX_OTHER_STF_WROQT_OVERFLOW_INT_EN BIT(28)
#define B_AX_OTHER_STF_WRFF_UNDERFLOW_INT_EN BIT(27)
#define B_AX_OTHER_STF_WRFF_OVERFLOW_INT_EN BIT(26)
#define B_AX_OTHER_STF_CMD_UNDERFLOW_INT_EN BIT(25)
#define B_AX_OTHER_STF_CMD_OVERFLOW_INT_EN BIT(24)
#define B_AX_HOST_ADDR_INFO_LEN_ZERO_ERR_INT_EN BIT(17)
#define B_AX_CPU_ADDR_INFO_LEN_ZERO_ERR_INT_EN BIT(16)
#define B_AX_PLE_OUTPUT_ERR_INT_EN BIT(12)
#define B_AX_PLE_RESP_ERR_INT_EN BIT(11)
#define B_AX_PLE_BURST_NUM_ERR_INT_EN BIT(10)
#define B_AX_PLE_NULL_PKT_ERR_INT_EN BIT(9)
#define B_AX_PLE_FLOW_CTRL_ERR_INT_EN BIT(8)
#define B_AX_WDE_OUTPUT_ERR_INT_EN BIT(4)
#define B_AX_WDE_RESP_ERR_INT_EN BIT(3)
#define B_AX_WDE_BURST_NUM_ERR_INT_EN BIT(2)
#define B_AX_WDE_NULL_PKT_ERR_INT_EN BIT(1)
#define B_AX_WDE_FLOW_CTRL_ERR_INT_EN BIT(0)
#define B_AX_OTHER_DISP_IMR_CLR (B_AX_OTHER_STF_WROQT_UNDERFLOW_INT_EN | \
				 B_AX_OTHER_STF_WROQT_OVERFLOW_INT_EN | \
				 B_AX_OTHER_STF_WRFF_UNDERFLOW_INT_EN | \
				 B_AX_OTHER_STF_WRFF_OVERFLOW_INT_EN | \
				 B_AX_OTHER_STF_CMD_UNDERFLOW_INT_EN | \
				 B_AX_OTHER_STF_CMD_OVERFLOW_INT_EN | \
				 B_AX_HOST_ADDR_INFO_LEN_ZERO_ERR_INT_EN | \
				 B_AX_CPU_ADDR_INFO_LEN_ZERO_ERR_INT_EN | \
				 B_AX_PLE_OUTPUT_ERR_INT_EN | \
				 B_AX_PLE_RESP_ERR_INT_EN | \
				 B_AX_PLE_BURST_NUM_ERR_INT_EN | \
				 B_AX_PLE_NULL_PKT_ERR_INT_EN | \
				 B_AX_PLE_FLOW_CTRL_ERR_INT_EN | \
				 B_AX_WDE_OUTPUT_ERR_INT_EN | \
				 B_AX_WDE_RESP_ERR_INT_EN | \
				 B_AX_WDE_BURST_NUM_ERR_INT_EN | \
				 B_AX_WDE_NULL_PKT_ERR_INT_EN | \
				 B_AX_WDE_FLOW_CTRL_ERR_INT_EN)

#define B_AX_REUSE_SIZE_ERR_INT_EN BIT(31)
#define B_AX_REUSE_EN_ERR_INT_EN BIT(30)
#define B_AX_STF_OQT_UNDERFLOW_ERR_INT_EN BIT(29)
#define B_AX_STF_OQT_OVERFLOW_ERR_INT_EN BIT(28)
#define B_AX_STF_WRFF_UNDERFLOW_ERR_INT_EN BIT(27)
#define B_AX_STF_WRFF_OVERFLOW_ERR_INT_EN BIT(26)
#define B_AX_STF_CMD_UNDERFLOW_ERR_INT_EN BIT(25)
#define B_AX_STF_CMD_OVERFLOW_ERR_INT_EN BIT(24)
#define B_AX_REUSE_SIZE_ZERO_ERR_INT_EN BIT(23)
#define B_AX_REUSE_PKT_CNT_ERR_INT_EN BIT(22)
#define B_AX_CDT_PTR_TIMEOUT_ERR_INT_EN BIT(21)
#define B_AX_CDT_HCI_TIMEOUT_ERR_INT_EN BIT(20)
#define B_AX_HDT_PTR_TIMEOUT_ERR_INT_EN BIT(19)
#define B_AX_HDT_HCI_TIMEOUT_ERR_INT_EN BIT(18)
#define B_AX_CDT_ADDR_INFO_LEN_ERR_INT_EN BIT(17)
#define B_AX_HDT_ADDR_INFO_LEN_ERR_INT_EN BIT(16)
#define B_AX_CDR_DMA_TIMEOUT_ERR_INT_EN BIT(15)
#define B_AX_CDR_RX_TIMEOUT_ERR_INT_EN BIT(14)
#define B_AX_PLE_RESPOSE_ERR_INT_EN BIT(11)
#define B_AX_HDR_DMA_TIMEOUT_ERR_INT_EN BIT(7)
#define B_AX_HDR_RX_TIMEOUT_ERR_INT_EN BIT(6)
#define B_AX_WDE_RESPONSE_ERR_INT_EN BIT(3)
#define B_AX_OTHER_DISP_IMR_CLR_V1 (B_AX_CT_EP_CH_DIFF_ERR_INT_EN | \
				    B_AX_WDE_FLOW_CTRL_ERR_INT_EN | \
				    B_AX_WDE_NULL_PKT_ERR_INT_EN | \
				    B_AX_WDE_BURST_NUM_ERR_INT_EN | \
				    B_AX_WDE_RESPONSE_ERR_INT_EN | \
				    B_AX_WDE_OUTPUT_ERR_INT_EN | \
				    B_AX_HDR_RX_TIMEOUT_ERR_INT_EN | \
				    B_AX_HDR_DMA_TIMEOUT_ERR_INT_EN | \
				    B_AX_PLE_FLOW_CTRL_ERR_INT_EN | \
				    B_AX_PLE_NULL_PKT_ERR_INT_EN | \
				    B_AX_PLE_BURST_NUM_ERR_INT_EN | \
				    B_AX_PLE_RESPOSE_ERR_INT_EN | \
				    B_AX_PLE_OUTPUT_ERR_INT_EN | \
				    B_AX_CDR_RX_TIMEOUT_ERR_INT_EN | \
				    B_AX_CDR_DMA_TIMEOUT_ERR_INT_EN | \
				    B_AX_HDT_ADDR_INFO_LEN_ERR_INT_EN | \
				    B_AX_CDT_ADDR_INFO_LEN_ERR_INT_EN | \
				    B_AX_HDT_HCI_TIMEOUT_ERR_INT_EN | \
				    B_AX_HDT_PTR_TIMEOUT_ERR_INT_EN | \
				    B_AX_CDT_HCI_TIMEOUT_ERR_INT_EN | \
				    B_AX_CDT_PTR_TIMEOUT_ERR_INT_EN | \
				    B_AX_REUSE_PKT_CNT_ERR_INT_EN | \
				    B_AX_REUSE_SIZE_ZERO_ERR_INT_EN | \
				    B_AX_STF_CMD_OVERFLOW_ERR_INT_EN | \
				    B_AX_STF_CMD_UNDERFLOW_ERR_INT_EN | \
				    B_AX_STF_WRFF_OVERFLOW_ERR_INT_EN | \
				    B_AX_STF_WRFF_UNDERFLOW_ERR_INT_EN | \
				    B_AX_STF_OQT_OVERFLOW_ERR_INT_EN | \
				    B_AX_STF_OQT_UNDERFLOW_ERR_INT_EN | \
				    B_AX_REUSE_EN_ERR_INT_EN | \
				    B_AX_REUSE_SIZE_ERR_INT_EN)
#define B_AX_OTHER_DISP_IMR_SET_V1 (B_AX_CDR_RX_TIMEOUT_ERR_INT_EN | \
				    B_AX_CDR_DMA_TIMEOUT_ERR_INT_EN | \
				    B_AX_HDT_HCI_TIMEOUT_ERR_INT_EN | \
				    B_AX_HDT_PTR_TIMEOUT_ERR_INT_EN | \
				    B_AX_CDT_HCI_TIMEOUT_ERR_INT_EN | \
				    B_AX_CDT_PTR_TIMEOUT_ERR_INT_EN | \
				    B_AX_STF_OQT_OVERFLOW_ERR_INT_EN | \
				    B_AX_STF_OQT_UNDERFLOW_ERR_INT_EN)

#define R_AX_DISPATCHER_DBG_PORT 0x8860
#define B_AX_DISPATCHER_DBG_SEL_MASK GENMASK(11, 8)
#define B_AX_DISPATCHER_INTN_SEL_MASK GENMASK(7, 4)
#define B_AX_DISPATCHER_CH_SEL_MASK GENMASK(3, 0)

#define R_AX_RXDMA_SETTING 0x8908
#define B_AX_BULK_SIZE GENMASK(1, 0)
#define USB11_BULKSIZE 0x2
#define USB2_BULKSIZE 0x1
#define USB3_BULKSIZE 0x0

#define R_AX_RX_FUNCTION_STOP 0x8920
#define B_AX_HDR_RX_STOP BIT(0)

#define R_AX_HCI_FC_CTRL 0x8A00
#define B_AX_HCI_FC_CH12_FULL_COND_MASK GENMASK(11, 10)
#define B_AX_HCI_FC_WP_CH811_FULL_COND_MASK GENMASK(9, 8)
#define B_AX_HCI_FC_WP_CH07_FULL_COND_MASK GENMASK(7, 6)
#define B_AX_HCI_FC_WD_FULL_COND_MASK GENMASK(5, 4)
#define B_AX_HCI_FC_CH12_EN BIT(3)
#define B_AX_HCI_FC_MODE_MASK GENMASK(2, 1)
#define B_AX_HCI_FC_EN BIT(0)

#define R_AX_CH_PAGE_CTRL 0x8A04
#define B_AX_PREC_PAGE_CH12_MASK GENMASK(24, 16)
#define B_AX_PREC_PAGE_CH011_MASK GENMASK(8, 0)

#define B_AX_MAX_PG_MASK GENMASK(28, 16)
#define B_AX_MIN_PG_MASK GENMASK(12, 0)
#define B_AX_GRP BIT(31)
#define R_AX_ACH0_PAGE_CTRL 0x8A10
#define R_AX_ACH1_PAGE_CTRL 0x8A14
#define R_AX_ACH2_PAGE_CTRL 0x8A18
#define R_AX_ACH3_PAGE_CTRL 0x8A1C
#define R_AX_ACH4_PAGE_CTRL 0x8A20
#define R_AX_ACH5_PAGE_CTRL 0x8A24
#define R_AX_ACH6_PAGE_CTRL 0x8A28
#define R_AX_ACH7_PAGE_CTRL 0x8A2C
#define R_AX_CH8_PAGE_CTRL 0x8A30
#define R_AX_CH9_PAGE_CTRL 0x8A34
#define R_AX_CH10_PAGE_CTRL 0x8A38
#define R_AX_CH11_PAGE_CTRL 0x8A3C

#define B_AX_AVAL_PG_MASK GENMASK(27, 16)
#define B_AX_USE_PG_MASK GENMASK(12, 0)
#define R_AX_ACH0_PAGE_INFO 0x8A50
#define R_AX_ACH1_PAGE_INFO 0x8A54
#define R_AX_ACH2_PAGE_INFO 0x8A58
#define R_AX_ACH3_PAGE_INFO 0x8A5C
#define R_AX_ACH4_PAGE_INFO 0x8A60
#define R_AX_ACH5_PAGE_INFO 0x8A64
#define R_AX_ACH6_PAGE_INFO 0x8A68
#define R_AX_ACH7_PAGE_INFO 0x8A6C
#define R_AX_CH8_PAGE_INFO 0x8A70
#define R_AX_CH9_PAGE_INFO 0x8A74
#define R_AX_CH10_PAGE_INFO 0x8A78
#define R_AX_CH11_PAGE_INFO 0x8A7C
#define R_AX_CH12_PAGE_INFO 0x8A80

#define R_AX_PUB_PAGE_INFO3 0x8A8C
#define B_AX_G1_AVAL_PG_MASK GENMASK(28, 16)
#define B_AX_G0_AVAL_PG_MASK GENMASK(12, 0)

#define R_AX_PUB_PAGE_CTRL1 0x8A90
#define B_AX_PUBPG_G1_MASK GENMASK(28, 16)
#define B_AX_PUBPG_G0_MASK GENMASK(12, 0)

#define R_AX_PUB_PAGE_CTRL2 0x8A94
#define B_AX_PUBPG_ALL_MASK GENMASK(12, 0)

#define R_AX_PUB_PAGE_INFO1 0x8A98
#define B_AX_G1_USE_PG_MASK GENMASK(28, 16)
#define B_AX_G0_USE_PG_MASK GENMASK(12, 0)

#define R_AX_PUB_PAGE_INFO2 0x8A9C
#define B_AX_PUB_AVAL_PG_MASK GENMASK(12, 0)

#define R_AX_WP_PAGE_CTRL1 0x8AA0
#define B_AX_PREC_PAGE_WP_CH811_MASK GENMASK(24, 16)
#define B_AX_PREC_PAGE_WP_CH07_MASK GENMASK(8, 0)

#define R_AX_WP_PAGE_CTRL2 0x8AA4
#define B_AX_WP_THRD_MASK GENMASK(12, 0)

#define R_AX_WP_PAGE_INFO1 0x8AA8
#define B_AX_WP_AVAL_PG_MASK GENMASK(28, 16)

#define R_AX_WDE_PKTBUF_CFG 0x8C08
#define B_AX_WDE_START_BOUND_MASK GENMASK(13, 8)
#define B_AX_WDE_PAGE_SEL_MASK GENMASK(1, 0)
#define B_AX_WDE_FREE_PAGE_NUM_MASK GENMASK(28, 16)

#define R_AX_WDE_ERRFLAG_MSG 0x8C30
#define B_AX_WDE_ERR_FLAG_MSG_MASK GENMASK(31, 0)

#define R_AX_WDE_ERR_FLAG_CFG_NUM1 0x8C34
#define B_AX_WDE_ERR_FLAG_NUM1_VLD BIT(31)
#define B_AX_WDE_ERR_FLAG_NUM1_MSTIDX_MASK GENMASK(27, 24)
#define B_AX_WDE_ERR_FLAG_NUM1_ISRIDX_MASK GENMASK(20, 16)
#define B_AX_WDE_DATCHN_FRZTMR_MODE BIT(2)
#define B_AX_WDE_QUEMGN_FRZTMR_MODE BIT(1)
#define B_AX_WDE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_AX_WDE_ERR_IMR 0x8C38
#define B_AX_WDE_DATCHN_UAPG_ERR_INT_EN BIT(30)
#define B_AX_WDE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_AX_WDE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN BIT(13)
#define B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN BIT(12)
#define B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN BIT(7)
#define B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN BIT(6)
#define B_AX_WDE_GETNPG_STRPG_ERR_INT_EN BIT(5)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(4)
#define B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN BIT(3)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(2)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN BIT(1)
#define B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN BIT(0)
#define B_AX_WDE_IMR_CLR (B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN | \
			  B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN | \
			  B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			  B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN | \
			  B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			  B_AX_WDE_GETNPG_STRPG_ERR_INT_EN | \
			  B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN | \
			  B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN | \
			  B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN | \
			  B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN | \
			  B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN | \
			  B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			  B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			  B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN | \
			  B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN | \
			  B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN | \
			  B_AX_WDE_DATCHN_ARBT_ERR_INT_EN | \
			  B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN | \
			  B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN)
#define B_AX_WDE_IMR_CLR_V01 (B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN | \
			      B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN | \
			      B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			      B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN | \
			      B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			      B_AX_WDE_GETNPG_STRPG_ERR_INT_EN | \
			      B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN | \
			      B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN | \
			      B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN | \
			      B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN | \
			      B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN | \
			      B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			      B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			      B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN | \
			      B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN | \
			      B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_ARBT_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_RRDY_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_UAPG_ERR_INT_EN)
#define B_AX_WDE_IMR_SET (B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN | \
			  B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN | \
			  B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			  B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN | \
			  B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			  B_AX_WDE_GETNPG_STRPG_ERR_INT_EN | \
			  B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN | \
			  B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN | \
			  B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN | \
			  B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN | \
			  B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN | \
			  B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			  B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			  B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN | \
			  B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN | \
			  B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN | \
			  B_AX_WDE_DATCHN_ARBT_ERR_INT_EN | \
			  B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN | \
			  B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN)
#define B_AX_WDE_IMR_SET_V01 (B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN | \
			      B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN | \
			      B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			      B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN | \
			      B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			      B_AX_WDE_GETNPG_STRPG_ERR_INT_EN | \
			      B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN | \
			      B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN | \
			      B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN | \
			      B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN | \
			      B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN | \
			      B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			      B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			      B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN | \
			      B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN | \
			      B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_ARBT_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_RRDY_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN | \
			      B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN)

#define B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_AX_WDE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_AX_WDE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN_V1 BIT(9)
#define B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN_V1 BIT(8)
#define B_AX_WDE_GETNPG_STRPG_ERR_INT_EN_V1 BIT(7)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 BIT(6)
#define B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN_V1 BIT(5)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 BIT(4)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN_V1 BIT(3)
#define B_AX_WDE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_AX_WDE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_AX_WDE_IMR_CLR_V1 (B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN | \
			     B_AX_WDE_BUFREQ_SIZE0_INT_EN | \
			     B_AX_WDE_BUFREQ_SIZELMT_INT_EN | \
			     B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN_V1 | \
			     B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 | \
			     B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN_V1 | \
			     B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 | \
			     B_AX_WDE_GETNPG_STRPG_ERR_INT_EN_V1 | \
			     B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN_V1 | \
			     B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN_V1 | \
			     B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN | \
			     B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN | \
			     B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN | \
			     B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			     B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			     B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN | \
			     B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN | \
			     B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_ARBT_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_RRDY_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN)
#define B_AX_WDE_IMR_SET_V1 (B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN | \
			     B_AX_WDE_BUFREQ_SIZE0_INT_EN | \
			     B_AX_WDE_BUFREQ_SIZELMT_INT_EN | \
			     B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN_V1 | \
			     B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 | \
			     B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN_V1 | \
			     B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 | \
			     B_AX_WDE_GETNPG_STRPG_ERR_INT_EN_V1 | \
			     B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN_V1 | \
			     B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN_V1 | \
			     B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN | \
			     B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN | \
			     B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN | \
			     B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			     B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			     B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN | \
			     B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN | \
			     B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_ARBT_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_RRDY_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN | \
			     B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN)

#define R_AX_WDE_ERR_ISR 0x8C3C
#define B_AX_WDE_DATCHN_RRDY_ERR BIT(27)
#define B_AX_WDE_DATCHN_FRZTO_ERR BIT(26)
#define B_AX_WDE_DATCHN_NULLPG_ERR BIT(25)
#define B_AX_WDE_DATCHN_ARBT_ERR BIT(24)
#define B_AX_WDE_QUEMGN_FRZTO_ERR BIT(19)
#define B_AX_WDE_NXTPKTLL_AD_ERR BIT(18)
#define B_AX_WDE_PREPKTLLT_AD_ERR BIT(17)
#define B_AX_WDE_ENQ_PKTCNT_NVAL_ERR BIT(16)
#define B_AX_WDE_ENQ_PKTCNT_OVRF_ERR BIT(15)
#define B_AX_WDE_QUE_SRCQUEID_ERR BIT(14)
#define B_AX_WDE_QUE_DSTQUEID_ERR BIT(13)
#define B_AX_WDE_QUE_CMDTYPE_ERR BIT(12)
#define B_AX_WDE_BUFMGN_FRZTO_ERR BIT(7)
#define B_AX_WDE_GETNPG_PGOFST_ERR BIT(6)
#define B_AX_WDE_GETNPG_STRPG_ERR BIT(5)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR BIT(4)
#define B_AX_WDE_BUFRTN_SIZE_ERR BIT(3)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR BIT(2)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR BIT(1)
#define B_AX_WDE_BUFREQ_QTAID_ERR BIT(0)

#define B_AX_WDE_MAX_SIZE_MASK GENMASK(27, 16)
#define B_AX_WDE_MIN_SIZE_MASK GENMASK(11, 0)
#define R_AX_WDE_QTA0_CFG 0x8C40
#define R_AX_WDE_QTA1_CFG 0x8C44
#define R_AX_WDE_QTA2_CFG 0x8C48
#define R_AX_WDE_QTA3_CFG 0x8C4C
#define R_AX_WDE_QTA4_CFG 0x8C50

#define B_AX_DLE_PUB_PGNUM GENMASK(12, 0)
#define B_AX_DLE_FREE_HEADPG GENMASK(11, 0)
#define B_AX_DLE_FREE_TAILPG GENMASK(27, 16)
#define B_AX_DLE_USE_PGNUM GENMASK(27, 16)
#define B_AX_DLE_RSV_PGNUM GENMASK(11, 0)
#define B_AX_DLE_QEMPTY_GRP GENMASK(31, 0)

#define R_AX_WDE_INI_STATUS 0x8D00
#define B_AX_WDE_Q_MGN_INI_RDY BIT(1)
#define B_AX_WDE_BUF_MGN_INI_RDY BIT(0)
#define WDE_MGN_INI_RDY (B_AX_WDE_Q_MGN_INI_RDY | B_AX_WDE_BUF_MGN_INI_RDY)
#define R_AX_WDE_DBG_FUN_INTF_CTL 0x8D10
#define B_AX_WDE_DFI_ACTIVE BIT(31)
#define B_AX_WDE_DFI_TRGSEL_MASK GENMASK(19, 16)
#define B_AX_WDE_DFI_ADDR_MASK GENMASK(15, 0)
#define R_AX_WDE_DBG_FUN_INTF_DATA 0x8D14
#define B_AX_WDE_DFI_DATA_MASK GENMASK(31, 0)

#define R_AX_PLE_PKTBUF_CFG 0x9008
#define B_AX_PLE_START_BOUND_MASK GENMASK(13, 8)
#define B_AX_PLE_PAGE_SEL_MASK GENMASK(1, 0)
#define B_AX_PLE_FREE_PAGE_NUM_MASK GENMASK(28, 16)

#define R_AX_PLE_DBGERR_LOCKEN 0x9020
#define B_AX_PLE_LOCKEN_DLEPIF07 BIT(7)
#define B_AX_PLE_LOCKEN_DLEPIF06 BIT(6)
#define B_AX_PLE_LOCKEN_DLEPIF05 BIT(5)
#define B_AX_PLE_LOCKEN_DLEPIF04 BIT(4)
#define B_AX_PLE_LOCKEN_DLEPIF03 BIT(3)
#define B_AX_PLE_LOCKEN_DLEPIF02 BIT(2)
#define B_AX_PLE_LOCKEN_DLEPIF01 BIT(1)
#define B_AX_PLE_LOCKEN_DLEPIF00 BIT(0)

#define R_AX_PLE_DBGERR_STS 0x9024
#define B_AX_PLE_LOCKON_DLEPIF07 BIT(7)
#define B_AX_PLE_LOCKON_DLEPIF06 BIT(6)
#define B_AX_PLE_LOCKON_DLEPIF05 BIT(5)
#define B_AX_PLE_LOCKON_DLEPIF04 BIT(4)
#define B_AX_PLE_LOCKON_DLEPIF03 BIT(3)
#define B_AX_PLE_LOCKON_DLEPIF02 BIT(2)
#define B_AX_PLE_LOCKON_DLEPIF01 BIT(1)
#define B_AX_PLE_LOCKON_DLEPIF00 BIT(0)

#define R_AX_PLE_ERR_FLAG_CFG_NUM1 0x9034
#define B_AX_PLE_ERR_FLAG_NUM1_VLD BIT(31)
#define B_AX_PLE_ERR_FLAG_NUM1_MSTIDX_MASK GENMASK(27, 24)
#define B_AX_PLE_ERR_FLAG_NUM1_ISRIDX_MASK GENMASK(20, 16)
#define B_AX_PLE_DATCHN_FRZTMR_MODE BIT(2)
#define B_AX_PLE_QUEMGN_FRZTMR_MODE BIT(1)
#define B_AX_PLE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_AX_PLE_ERRFLAG_MSG 0x9030
#define B_AX_PLE_ERR_FLAG_MSG_MASK GENMASK(31, 0)
#define B_AX_PLE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_AX_PLE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN_V1 BIT(9)
#define B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN_V1 BIT(8)
#define B_AX_PLE_GETNPG_STRPG_ERR_INT_EN_V1 BIT(7)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 BIT(6)
#define B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN_V1 BIT(5)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 BIT(4)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN_V1 BIT(3)
#define B_AX_PLE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_AX_PLE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_AX_PLE_DATCHN_CAMREQ_ERR BIT(29)
#define B_AX_PLE_DATCHN_ADRERR_ERR BIT(28)
#define B_AX_PLE_BUFMGN_FRZTO_ERR_V1 BIT(9)
#define B_AX_PLE_GETNPG_PGOFST_ERR_V1 BIT(8)
#define B_AX_PLE_GETNPG_STRPG_ERR_V1 BIT(7)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_V1 BIT(6)
#define B_AX_PLE_BUFRTN_SIZE_ERR_V1 BIT(5)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_V1 BIT(4)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_V1 BIT(3)
#define B_AX_PLE_BUFREQ_SIZELMT_ERR BIT(2)
#define B_AX_PLE_BUFREQ_SIZE0_ERR BIT(1)

#define R_AX_PLE_ERR_IMR 0x9038
#define B_AX_PLE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_AX_PLE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN BIT(13)
#define B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN BIT(12)
#define B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN BIT(7)
#define B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN BIT(6)
#define B_AX_PLE_GETNPG_STRPG_ERR_INT_EN BIT(5)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(4)
#define B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN BIT(3)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(2)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN BIT(1)
#define B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN BIT(0)
#define B_AX_PLE_IMR_CLR (B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN | \
			  B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN | \
			  B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			  B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN | \
			  B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			  B_AX_PLE_GETNPG_STRPG_ERR_INT_EN | \
			  B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN | \
			  B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN | \
			  B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN | \
			  B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN | \
			  B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN | \
			  B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			  B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			  B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN | \
			  B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN | \
			  B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN | \
			  B_AX_PLE_DATCHN_ARBT_ERR_INT_EN | \
			  B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN | \
			  B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN)
#define B_AX_PLE_IMR_SET (B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN | \
			  B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN | \
			  B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			  B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN | \
			  B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			  B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN | \
			  B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN | \
			  B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN | \
			  B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN | \
			  B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN | \
			  B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			  B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			  B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN | \
			  B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN | \
			  B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN | \
			  B_AX_PLE_DATCHN_ARBT_ERR_INT_EN | \
			  B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN | \
			  B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN)

#define B_AX_PLE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_AX_PLE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN_V1 BIT(9)
#define B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN_V1 BIT(8)
#define B_AX_PLE_GETNPG_STRPG_ERR_INT_EN_V1 BIT(7)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 BIT(6)
#define B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN_V1 BIT(5)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 BIT(4)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN_V1 BIT(3)
#define B_AX_PLE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_AX_PLE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_AX_PLE_IMR_CLR_V1 (B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN | \
			     B_AX_PLE_BUFREQ_SIZE0_INT_EN | \
			     B_AX_PLE_BUFREQ_SIZELMT_INT_EN | \
			     B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN_V1 | \
			     B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 | \
			     B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN_V1 | \
			     B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 | \
			     B_AX_PLE_GETNPG_STRPG_ERR_INT_EN_V1 | \
			     B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN_V1 | \
			     B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN_V1 | \
			     B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN | \
			     B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN | \
			     B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN | \
			     B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			     B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			     B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN | \
			     B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN | \
			     B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_ARBT_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_RRDY_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_ADRERR_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_CAMREQ_ERR_INT_EN)
#define B_AX_PLE_IMR_SET_V1 (B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN | \
			     B_AX_PLE_BUFREQ_SIZE0_INT_EN | \
			     B_AX_PLE_BUFREQ_SIZELMT_INT_EN | \
			     B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN_V1 | \
			     B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 | \
			     B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN_V1 | \
			     B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 | \
			     B_AX_PLE_GETNPG_STRPG_ERR_INT_EN_V1 | \
			     B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN_V1 | \
			     B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN_V1 | \
			     B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN | \
			     B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN | \
			     B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN | \
			     B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			     B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			     B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN | \
			     B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN | \
			     B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_ARBT_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_RRDY_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_ADRERR_ERR_INT_EN | \
			     B_AX_PLE_DATCHN_CAMREQ_ERR_INT_EN)

#define R_AX_PLE_ERR_FLAG_ISR 0x903C
#define B_AX_PLE_MAX_SIZE_MASK GENMASK(27, 16)
#define B_AX_PLE_MIN_SIZE_MASK GENMASK(11, 0)
#define R_AX_PLE_QTA0_CFG 0x9040
#define R_AX_PLE_QTA1_CFG 0x9044
#define R_AX_PLE_QTA2_CFG 0x9048
#define R_AX_PLE_QTA3_CFG 0x904C
#define R_AX_PLE_QTA4_CFG 0x9050
#define R_AX_PLE_QTA5_CFG 0x9054
#define R_AX_PLE_QTA6_CFG 0x9058
#define B_AX_PLE_Q6_MAX_SIZE_MASK GENMASK(27, 16)
#define B_AX_PLE_Q6_MIN_SIZE_MASK GENMASK(11, 0)
#define R_AX_PLE_QTA7_CFG 0x905C
#define B_AX_PLE_Q7_MAX_SIZE_MASK GENMASK(27, 16)
#define B_AX_PLE_Q7_MIN_SIZE_MASK GENMASK(11, 0)
#define R_AX_PLE_QTA8_CFG 0x9060
#define R_AX_PLE_QTA9_CFG 0x9064
#define R_AX_PLE_QTA10_CFG 0x9068
#define R_AX_PLE_QTA11_CFG 0x906C

#define R_AX_PLE_INI_STATUS 0x9100
#define B_AX_PLE_Q_MGN_INI_RDY BIT(1)
#define B_AX_PLE_BUF_MGN_INI_RDY BIT(0)
#define PLE_MGN_INI_RDY (B_AX_PLE_Q_MGN_INI_RDY | B_AX_PLE_BUF_MGN_INI_RDY)
#define R_AX_PLE_DBG_FUN_INTF_CTL 0x9110
#define B_AX_PLE_DFI_ACTIVE BIT(31)
#define B_AX_PLE_DFI_TRGSEL_MASK GENMASK(19, 16)
#define B_AX_PLE_DFI_ADDR_MASK GENMASK(15, 0)
#define R_AX_PLE_DBG_FUN_INTF_DATA 0x9114
#define B_AX_PLE_DFI_DATA_MASK GENMASK(31, 0)

#define R_AX_WDRLS_CFG 0x9408
#define B_AX_RLSRPT_BUFREQ_TO_MASK GENMASK(15, 8)
#define B_AX_WDRLS_MODE_MASK GENMASK(1, 0)

#define R_AX_RLSRPT0_CFG0 0x9410
#define B_AX_RLSRPT0_FLTR_MAP_MASK GENMASK(27, 24)
#define B_AX_RLSRPT0_PKTTYPE_MASK GENMASK(19, 16)
#define B_AX_RLSRPT0_PID_MASK GENMASK(10, 8)
#define B_AX_RLSRPT0_QID_MASK GENMASK(5, 0)

#define R_AX_RLSRPT0_CFG1 0x9414
#define B_AX_RLSRPT0_TO_MASK GENMASK(23, 16)
#define B_AX_RLSRPT0_AGGNUM_MASK GENMASK(7, 0)

#define R_AX_WDRLS_ERR_IMR 0x9430
#define B_AX_WDRLS_RPT1_FRZTO_ERR_INT_EN BIT(13)
#define B_AX_WDRLS_RPT1_AGGNUM0_ERR_INT_EN BIT(12)
#define B_AX_WDRLS_RPT0_FRZTO_ERR_INT_EN BIT(9)
#define B_AX_WDRLS_RPT0_AGGNUM0_ERR_INT_EN BIT(8)
#define B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN BIT(5)
#define B_AX_WDRLS_PLEBREQ_TO_ERR_INT_EN BIT(4)
#define B_AX_WDRLS_CTL_FRZTO_ERR_INT_EN BIT(2)
#define B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN BIT(1)
#define B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN BIT(0)
#define B_AX_WDRLS_IMR_EN_CLR (B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN | \
			       B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN | \
			       B_AX_WDRLS_CTL_FRZTO_ERR_INT_EN | \
			       B_AX_WDRLS_PLEBREQ_TO_ERR_INT_EN | \
			       B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN | \
			       B_AX_WDRLS_RPT0_AGGNUM0_ERR_INT_EN | \
			       B_AX_WDRLS_RPT0_FRZTO_ERR_INT_EN | \
			       B_AX_WDRLS_RPT1_AGGNUM0_ERR_INT_EN | \
			       B_AX_WDRLS_RPT1_FRZTO_ERR_INT_EN)
#define B_AX_WDRLS_IMR_SET (B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN | \
			    B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN | \
			    B_AX_WDRLS_CTL_FRZTO_ERR_INT_EN | \
			    B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN | \
			    B_AX_WDRLS_RPT0_AGGNUM0_ERR_INT_EN | \
			    B_AX_WDRLS_RPT0_FRZTO_ERR_INT_EN | \
			    B_AX_WDRLS_RPT1_AGGNUM0_ERR_INT_EN | \
			    B_AX_WDRLS_RPT1_FRZTO_ERR_INT_EN)
#define B_AX_WDRLS_IMR_SET_V1 (B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN | \
			      B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN | \
			      B_AX_WDRLS_CTL_FRZTO_ERR_INT_EN | \
			      B_AX_WDRLS_PLEBREQ_TO_ERR_INT_EN | \
			      B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN | \
			      B_AX_WDRLS_RPT0_AGGNUM0_ERR_INT_EN | \
			      B_AX_WDRLS_RPT0_FRZTO_ERR_INT_EN | \
			      B_AX_WDRLS_RPT1_AGGNUM0_ERR_INT_EN | \
			      B_AX_WDRLS_RPT1_FRZTO_ERR_INT_EN)

#define R_AX_WDRLS_ERR_ISR 0x9434

#define R_AX_BBRPT_COM_ERR_IMR 0x9608
#define B_AX_BBRPT_COM_HANG_EN BIT(1)
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN BIT(0)

#define R_AX_BBRPT_COM_ERR_IMR_ISR 0x960C
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR BIT(16)
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN BIT(0)

#define R_AX_BBRPT_COM_ERR_ISR 0x960C
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_V1 BIT(0)

#define R_AX_BBRPT_CHINFO_ERR_ISR 0x962C
#define B_AX_BBPRT_CHIF_TO_ERR_V1 BIT(7)
#define B_AX_BBPRT_CHIF_NULL_ERR_V1 BIT(6)
#define B_AX_BBPRT_CHIF_LEFT2_ERR_V1 BIT(5)
#define B_AX_BBPRT_CHIF_LEFT1_ERR_V1 BIT(4)
#define B_AX_BBPRT_CHIF_HDRL_ERR_V1 BIT(3)
#define B_AX_BBPRT_CHIF_BOVF_ERR_V1 BIT(2)
#define B_AX_BBPRT_CHIF_OVF_ERR_V1 BIT(1)
#define B_AX_BBPRT_CHIF_BB_TO_ERR_V1 BIT(0)

#define R_AX_BBRPT_CHINFO_ERR_IMR 0x9628
#define B_AX_BBPRT_CHIF_TO_ERR_INT_EN BIT(7)
#define B_AX_BBPRT_CHIF_NULL_ERR_INT_EN BIT(6)
#define B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN BIT(5)
#define B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN BIT(4)
#define B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN BIT(3)
#define B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN BIT(2)
#define B_AX_BBPRT_CHIF_OVF_ERR_INT_EN BIT(1)
#define B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN BIT(0)
#define R_AX_BBRPT_CHINFO_IMR_SET_V1 (B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN | \
				      B_AX_BBPRT_CHIF_OVF_ERR_INT_EN | \
				      B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN | \
				      B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN | \
				      B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN | \
				      B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN | \
				      B_AX_BBPRT_CHIF_NULL_ERR_INT_EN | \
				      B_AX_BBPRT_CHIF_TO_ERR_INT_EN)

#define R_AX_BBRPT_CHINFO_ERR_IMR_ISR 0x962C
#define B_AX_BBPRT_CHIF_TO_ERR BIT(23)
#define B_AX_BBPRT_CHIF_NULL_ERR BIT(22)
#define B_AX_BBPRT_CHIF_LEFT2_ERR BIT(21)
#define B_AX_BBPRT_CHIF_LEFT1_ERR BIT(20)
#define B_AX_BBPRT_CHIF_HDRL_ERR BIT(19)
#define B_AX_BBPRT_CHIF_BOVF_ERR BIT(18)
#define B_AX_BBPRT_CHIF_OVF_ERR BIT(17)
#define B_AX_BBPRT_CHIF_BB_TO_ERR BIT(16)
#define B_AX_BBPRT_CHIF_TO_ERR_INT_EN BIT(7)
#define B_AX_BBPRT_CHIF_NULL_ERR_INT_EN BIT(6)
#define B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN BIT(5)
#define B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN BIT(4)
#define B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN BIT(3)
#define B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN BIT(2)
#define B_AX_BBPRT_CHIF_OVF_ERR_INT_EN BIT(1)
#define B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN BIT(0)
#define B_AX_BBRPT_CHINFO_IMR_CLR (B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN | \
				   B_AX_BBPRT_CHIF_OVF_ERR_INT_EN | \
				   B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN | \
				   B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN | \
				   B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN | \
				   B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN | \
				   B_AX_BBPRT_CHIF_NULL_ERR_INT_EN | \
				   B_AX_BBPRT_CHIF_TO_ERR_INT_EN)

#define R_AX_BBRPT_DFS_ERR_IMR 0x9638
#define B_AX_BBRPT_DFS_TO_ERR_INT_EN BIT(0)

#define R_AX_BBRPT_DFS_ERR_IMR_ISR 0x963C
#define B_AX_BBRPT_DFS_TO_ERR BIT(16)
#define B_AX_BBRPT_DFS_TO_ERR_INT_EN BIT(0)

#define R_AX_BBRPT_DFS_ERR_ISR 0x963C
#define B_AX_BBRPT_DFS_TO_ERR_V1 BIT(0)

#define R_AX_LA_ERRFLAG 0x966C
#define B_AX_LA_ISR_DATA_LOSS_ERR BIT(16)
#define B_AX_LA_IMR_DATA_LOSS_ERR BIT(0)

#define R_AX_WD_BUF_REQ 0x9800
#define R_AX_PL_BUF_REQ 0x9820
#define B_AX_WD_BUF_REQ_EXEC BIT(31)
#define B_AX_WD_BUF_REQ_QUOTA_ID_MASK GENMASK(23, 16)
#define B_AX_WD_BUF_REQ_LEN_MASK GENMASK(15, 0)

#define R_AX_WD_BUF_STATUS 0x9804
#define R_AX_PL_BUF_STATUS 0x9824
#define B_AX_WD_BUF_STAT_DONE BIT(31)
#define B_AX_WD_BUF_STAT_PKTID_MASK GENMASK(11, 0)
#define S_WD_BUF_STAT_PKTID_INVALID GENMASK(11, 0)

#define R_AX_WD_CPUQ_OP_0 0x9810
#define R_AX_PL_CPUQ_OP_0 0x9830
#define B_AX_WD_CPUQ_OP_EXEC BIT(31)
#define B_AX_CPUQ_OP_CMD_TYPE_MASK GENMASK(27, 24)
#define B_AX_CPUQ_OP_MACID_MASK GENMASK(23, 16)
#define B_AX_CPUQ_OP_PKTNUM_MASK GENMASK(7, 0)

#define R_AX_WD_CPUQ_OP_1 0x9814
#define R_AX_PL_CPUQ_OP_1 0x9834
#define B_AX_CPUQ_OP_SRC_PID_MASK GENMASK(24, 22)
#define B_AX_CPUQ_OP_SRC_QID_MASK GENMASK(21, 16)
#define B_AX_CPUQ_OP_DST_PID_MASK GENMASK(8, 6)
#define B_AX_CPUQ_OP_DST_QID_MASK GENMASK(5, 0)

#define R_AX_WD_CPUQ_OP_2 0x9818
#define R_AX_PL_CPUQ_OP_2 0x9838
#define B_AX_WD_CPUQ_OP_STRT_PKTID_MASK GENMASK(27, 16)
#define B_AX_WD_CPUQ_OP_END_PKTID_MASK GENMASK(11, 0)

#define R_AX_WD_CPUQ_OP_STATUS 0x981C
#define R_AX_PL_CPUQ_OP_STATUS 0x983C
#define B_AX_WD_CPUQ_OP_STAT_DONE BIT(31)
#define B_AX_WD_CPUQ_OP_PKTID_MASK GENMASK(11, 0)

#define R_AX_CPUIO_ERR_IMR 0x9840
#define B_AX_PLEQUE_OP_ERR_INT_EN BIT(12)
#define B_AX_PLEBUF_OP_ERR_INT_EN BIT(8)
#define B_AX_WDEQUE_OP_ERR_INT_EN BIT(4)
#define B_AX_WDEBUF_OP_ERR_INT_EN BIT(0)
#define B_AX_CPUIO_IMR_CLR (B_AX_WDEBUF_OP_ERR_INT_EN | \
			    B_AX_WDEQUE_OP_ERR_INT_EN | \
			    B_AX_PLEBUF_OP_ERR_INT_EN | \
			    B_AX_PLEQUE_OP_ERR_INT_EN)
#define B_AX_CPUIO_IMR_SET (B_AX_WDEBUF_OP_ERR_INT_EN | \
			    B_AX_WDEQUE_OP_ERR_INT_EN | \
			    B_AX_PLEBUF_OP_ERR_INT_EN | \
			    B_AX_PLEQUE_OP_ERR_INT_EN)

#define R_AX_CPUIO_ERR_ISR 0x9844

#define R_AX_SEC_ERR_IMR_ISR 0x991C

#define R_AX_PKTIN_SETTING 0x9A00
#define B_AX_WD_ADDR_INFO_LENGTH BIT(1)

#define R_AX_PKTIN_ERR_IMR 0x9A20
#define B_AX_PKTIN_GETPKTID_ERR_INT_EN BIT(0)

#define R_AX_PKTIN_ERR_ISR 0x9A24

#define R_AX_MPDU_TX_ERR_ISR 0x9BF0
#define R_AX_MPDU_TX_ERR_IMR 0x9BF4
#define B_AX_TX_KSRCH_ERR_EN BIT(9)
#define B_AX_TX_NW_TYPE_ERR_EN BIT(8)
#define B_AX_TX_LLC_PRE_ERR_EN BIT(7)
#define B_AX_TX_ETH_TYPE_ERR_EN BIT(6)
#define B_AX_TX_HDR3_SIZE_ERR_INT_EN BIT(5)
#define B_AX_TX_OFFSET_ERR_INT_EN BIT(4)
#define B_AX_TX_MPDU_SIZE_ZERO_INT_EN BIT(3)
#define B_AX_TX_NXT_ERRPKTID_INT_EN BIT(2)
#define B_AX_TX_GET_ERRPKTID_INT_EN BIT(1)
#define B_AX_MPDU_TX_IMR_SET_V1 (B_AX_TX_GET_ERRPKTID_INT_EN | \
				 B_AX_TX_NXT_ERRPKTID_INT_EN | \
				 B_AX_TX_MPDU_SIZE_ZERO_INT_EN | \
				 B_AX_TX_HDR3_SIZE_ERR_INT_EN | \
				 B_AX_TX_ETH_TYPE_ERR_EN | \
				 B_AX_TX_NW_TYPE_ERR_EN | \
				 B_AX_TX_KSRCH_ERR_EN)

#define R_AX_MPDU_PROC 0x9C00
#define B_AX_A_ICV_ERR BIT(1)
#define B_AX_APPEND_FCS BIT(0)

#define R_AX_ACTION_FWD0 0x9C04
#define TRXCFG_MPDU_PROC_ACT_FRWD 0x02A95A95

#define R_AX_ACTION_FWD1 0x9C08

#define R_AX_TF_FWD 0x9C14
#define TRXCFG_MPDU_PROC_TF_FRWD 0x0000AA55

#define R_AX_HW_RPT_FWD 0x9C18
#define B_AX_FWD_PPDU_STAT_MASK GENMASK(1, 0)
#define RTW89_PRPT_DEST_HOST 1
#define RTW89_PRPT_DEST_WLCPU 2

#define R_AX_CUT_AMSDU_CTRL 0x9C40
#define TRXCFG_MPDU_PROC_CUT_CTRL	0x010E05F0

#define R_AX_WOW_CTRL 0x9C50
#define B_AX_WOW_WOWEN BIT(1)

#define R_AX_MPDU_RX_ERR_ISR 0x9CF0
#define R_AX_MPDU_RX_ERR_IMR 0x9CF4
#define B_AX_RPT_ERR_INT_EN BIT(3)
#define B_AX_MHDRLEN_ERR_INT_EN BIT(1)
#define B_AX_GETPKTID_ERR_INT_EN BIT(0)
#define B_AX_MPDU_RX_IMR_SET_V1 B_AX_RPT_ERR_INT_EN

#define R_AX_SEC_ENG_CTRL 0x9D00
#define B_AX_SEC_DBG_PORT_FIELD_MASK GENMASK(19, 16)
#define B_AX_TX_PARTIAL_MODE BIT(11)
#define B_AX_CLK_EN_CGCMP BIT(10)
#define B_AX_CLK_EN_WAPI BIT(9)
#define B_AX_CLK_EN_WEP_TKIP BIT(8)
#define B_AX_BMC_MGNT_DEC BIT(5)
#define B_AX_UC_MGNT_DEC BIT(4)
#define B_AX_MC_DEC BIT(3)
#define B_AX_BC_DEC BIT(2)
#define B_AX_SEC_RX_DEC BIT(1)
#define B_AX_SEC_TX_ENC BIT(0)

#define R_AX_SEC_MPDU_PROC 0x9D04
#define B_AX_APPEND_ICV BIT(1)
#define B_AX_APPEND_MIC BIT(0)

#define R_AX_SEC_CAM_ACCESS 0x9D10
#define R_AX_SEC_CAM_RDATA 0x9D14
#define R_AX_SEC_CAM_WDATA 0x9D18

#define R_AX_SEC_DEBUG 0x9D1C
#define B_AX_IMR_ERROR BIT(3)

#define R_AX_SEC_DEBUG1 0x9D1C
#define B_AX_TX_TIMEOUT_SEL_MASK GENMASK(31, 30)
#define AX_TX_TO_VAL  0x2

#define R_AX_SEC_TX_DEBUG 0x9D20
#define R_AX_SEC_RX_DEBUG 0x9D24
#define R_AX_SEC_TRX_PKT_CNT 0x9D28

#define R_AX_SEC_DEBUG2 0x9D28
#define B_AX_DBG_READ_SH 2
#define B_AX_DBG_READ_MSK 0x3fffffff

#define R_AX_SEC_TRX_BLK_CNT 0x9D2C

#define R_AX_SEC_ERROR_FLAG_IMR 0x9D2C
#define B_AX_RX_HANG_IMR BIT(1)
#define B_AX_TX_HANG_IMR BIT(0)

#define R_AX_SEC_ERROR_FLAG 0x9D30
#define B_AX_RX_HANG_ERROR_V1 BIT(1)
#define B_AX_TX_HANG_ERROR_V1 BIT(0)

#define R_AX_SS_CTRL 0x9E10
#define B_AX_SS_INIT_DONE_1 BIT(31)
#define B_AX_SS_WARM_INIT_FLG BIT(29)
#define B_AX_SS_NONEMPTY_SS2FINFO_EN BIT(28)
#define B_AX_SS_EN BIT(0)

#define R_AX_SS2FINFO_PATH 0x9E50
#define B_AX_SS_UL_REL BIT(31)
#define B_AX_SS_REL_QUEUE_MASK GENMASK(29, 24)
#define B_AX_SS_REL_PORT_MASK GENMASK(18, 16)
#define B_AX_SS_DEST_QUEUE_MASK GENMASK(13, 8)
#define SS2F_PATH_WLCPU 0x0A
#define B_AX_SS_DEST_PORT_MASK GENMASK(2, 0)

#define R_AX_SS_MACID_PAUSE_0 0x9EB0
#define B_AX_SS_MACID31_0_PAUSE_SH 0
#define B_AX_SS_MACID31_0_PAUSE_MASK GENMASK(31, 0)

#define R_AX_SS_MACID_PAUSE_1 0x9EB4
#define B_AX_SS_MACID63_32_PAUSE_SH 0
#define B_AX_SS_MACID63_32_PAUSE_MASK GENMASK(31, 0)

#define R_AX_SS_MACID_PAUSE_2 0x9EB8
#define B_AX_SS_MACID95_64_PAUSE_SH 0
#define B_AX_SS_MACID95_64_PAUSE_MASK GENMASK(31, 0)

#define R_AX_SS_MACID_PAUSE_3 0x9EBC
#define B_AX_SS_MACID127_96_PAUSE_SH 0
#define B_AX_SS_MACID127_96_PAUSE_MASK GENMASK(31, 0)

#define R_AX_STA_SCHEDULER_ERR_IMR 0x9EF0
#define B_AX_PLE_B_PKTID_ERR_INT_EN BIT(2)
#define B_AX_RPT_HANG_TIMEOUT_INT_EN BIT(1)
#define B_AX_SEARCH_HANG_TIMEOUT_INT_EN BIT(0)
#define B_AX_STA_SCHEDULER_IMR_SET (B_AX_SEARCH_HANG_TIMEOUT_INT_EN | \
				    B_AX_RPT_HANG_TIMEOUT_INT_EN | \
				    B_AX_PLE_B_PKTID_ERR_INT_EN)

#define R_AX_STA_SCHEDULER_ERR_ISR 0x9EF4

#define R_AX_TXPKTCTL_ERR_IMR_ISR 0x9F1C
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR BIT(25)
#define B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR BIT(24)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR BIT(19)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR BIT(18)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR BIT(17)
#define B_AX_TXPKTCTL_USRCTL_REINIT_ERR BIT(16)
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN BIT(9)
#define B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN BIT(8)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN BIT(3)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN BIT(2)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN BIT(1)
#define B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN BIT(0)
#define B_AX_TXPKTCTL_IMR_B0_CLR (B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN | \
				  B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN | \
				  B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN | \
				  B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN | \
				  B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN | \
				  B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN)
#define B_AX_TXPKTCTL_IMR_B1_CLR (B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN | \
				  B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN | \
				  B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN | \
				  B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN | \
				  B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN | \
				  B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN)
#define B_AX_TXPKTCTL_IMR_B0_SET (B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN | \
				  B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN)
#define B_AX_TXPKTCTL_IMR_B1_SET (B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN | \
				  B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN | \
				  B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN | \
				  B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN)

#define R_AX_TXPKTCTL_ERR_IMR_ISR_B1 0x9F2C
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN BIT(9)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN BIT(3)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN BIT(2)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN BIT(1)

#define R_AX_DBG_FUN_INTF_CTL 0x9F30
#define B_AX_DFI_ACTIVE BIT(31)
#define B_AX_DFI_TRGSEL_MASK GENMASK(19, 16)
#define B_AX_DFI_ADDR_MASK GENMASK(15, 0)
#define R_AX_DBG_FUN_INTF_DATA 0x9F34
#define B_AX_DFI_DATA_MASK GENMASK(31, 0)

#define R_AX_TXPKTCTL_B0_PRELD_CFG0 0x9F48
#define B_AX_B0_PRELD_FEN BIT(31)
#define B_AX_B0_PRELD_USEMAXSZ_MASK GENMASK(25, 16)
#define PRELD_B0_ENT_NUM 10
#define PRELD_B01_ENT_NUM_8922D 2
#define PRELD_AMSDU_SIZE 52
#define PRELD_NEXT_MIN_SIZE 255
#define B_AX_B0_PRELD_CAM_G1ENTNUM_MASK GENMASK(12, 8)
#define B_AX_B0_PRELD_CAM_G0ENTNUM_MASK GENMASK(4, 0)

#define R_AX_TXPKTCTL_B0_PRELD_CFG1 0x9F4C
#define B_AX_B0_PRELD_NXT_TXENDWIN_MASK GENMASK(11, 8)
#define PRELD_NEXT_WND 1
#define B_AX_B0_PRELD_NXT_RSVMINSZ_MASK GENMASK(7, 0)

#define R_AX_TXPKTCTL_B0_ERRFLAG_IMR 0x9F78
#define B_AX_B0_IMR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_AX_B0_IMR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_AX_B0_IMR_ERR_MPDUIF_DATAERR BIT(18)
#define B_AX_B0_IMR_ERR_MPDUINFO_RECFG BIT(16)
#define B_AX_B0_IMR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_AX_B0_IMR_ERR_CMDPSR_FRZTO BIT(10)
#define B_AX_B0_IMR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_AX_B0_IMR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_AX_B0_IMR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_AX_B0_IMR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_AX_B0_IMR_ERR_USRCTL_NOINIT BIT(1)
#define B_AX_B0_IMR_ERR_USRCTL_REINIT BIT(0)
#define B_AX_TXPKTCTL_IMR_B0_CLR_V1 (B_AX_B0_IMR_ERR_USRCTL_REINIT | \
				     B_AX_B0_IMR_ERR_USRCTL_NOINIT | \
				     B_AX_B0_IMR_ERR_USRCTL_RDNRLSCMD | \
				     B_AX_B0_IMR_ERR_USRCTL_RLSBMPLEN | \
				     B_AX_B0_IMR_ERR_CMDPSR_1STCMDERR | \
				     B_AX_B0_IMR_ERR_CMDPSR_CMDTYPE | \
				     B_AX_B0_IMR_ERR_CMDPSR_FRZTO | \
				     B_AX_B0_IMR_ERR_CMDPSR_TBLSZ | \
				     B_AX_B0_IMR_ERR_MPDUINFO_RECFG | \
				     B_AX_B0_IMR_ERR_MPDUIF_DATAERR | \
				     B_AX_B0_IMR_ERR_PRELD_RLSPKTSZERR | \
				     B_AX_B0_IMR_ERR_PRELD_ENTNUMCFG)
#define B_AX_TXPKTCTL_IMR_B0_SET_V1 (B_AX_B0_IMR_ERR_USRCTL_REINIT | \
				     B_AX_B0_IMR_ERR_USRCTL_NOINIT | \
				     B_AX_B0_IMR_ERR_CMDPSR_1STCMDERR | \
				     B_AX_B0_IMR_ERR_CMDPSR_CMDTYPE | \
				     B_AX_B0_IMR_ERR_CMDPSR_TBLSZ | \
				     B_AX_B0_IMR_ERR_MPDUINFO_RECFG | \
				     B_AX_B0_IMR_ERR_MPDUIF_DATAERR | \
				     B_AX_B0_IMR_ERR_PRELD_RLSPKTSZERR | \
				     B_AX_B0_IMR_ERR_PRELD_ENTNUMCFG)

#define R_AX_TXPKTCTL_B0_ERRFLAG_ISR 0x9F7C
#define B_AX_B0_ISR_ERR_PRELD_EVT3 BIT(23)
#define B_AX_B0_ISR_ERR_PRELD_EVT2 BIT(22)
#define B_AX_B0_ISR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_AX_B0_ISR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_AX_B0_ISR_ERR_MPDUIF_ERR1 BIT(19)
#define B_AX_B0_ISR_ERR_MPDUIF_DATAERR BIT(18)
#define B_AX_B0_ISR_ERR_MPDUINFO_ERR1 BIT(17)
#define B_AX_B0_ISR_ERR_MPDUINFO_RECFG BIT(16)
#define B_AX_B0_ISR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_AX_B0_ISR_ERR_CMDPSR_FRZTO BIT(10)
#define B_AX_B0_ISR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_AX_B0_ISR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_AX_B0_ISR_ERR_USRCTL_EVT7 BIT(7)
#define B_AX_B0_ISR_ERR_USRCTL_EVT6 BIT(6)
#define B_AX_B0_ISR_ERR_USRCTL_EVT5 BIT(5)
#define B_AX_B0_ISR_ERR_USRCTL_EVT4 BIT(4)
#define B_AX_B0_ISR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_AX_B0_ISR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_AX_B0_ISR_ERR_USRCTL_NOINIT BIT(1)
#define B_AX_B0_ISR_ERR_USRCTL_REINIT BIT(0)

#define R_AX_TXPKTCTL_B1_PRELD_CFG0 0x9F88
#define B_AX_B1_PRELD_FEN BIT(31)
#define B_AX_B1_PRELD_USEMAXSZ_MASK GENMASK(25, 16)
#define PRELD_B1_ENT_NUM 4
#define B_AX_B1_PRELD_CAM_G1ENTNUM_MASK GENMASK(12, 8)
#define B_AX_B1_PRELD_CAM_G0ENTNUM_MASK GENMASK(4, 0)

#define R_AX_TXPKTCTL_B1_PRELD_CFG1 0x9F8C
#define B_AX_B1_PRELD_NXT_TXENDWIN_MASK GENMASK(11, 8)
#define B_AX_B1_PRELD_NXT_RSVMINSZ_MASK GENMASK(7, 0)

#define R_AX_TXPKTCTL_B1_ERRFLAG_IMR 0x9FB8
#define B_AX_B1_IMR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_AX_B1_IMR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_AX_B1_IMR_ERR_MPDUIF_DATAERR BIT(18)
#define B_AX_B1_IMR_ERR_MPDUINFO_RECFG BIT(16)
#define B_AX_B1_IMR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_AX_B1_IMR_ERR_CMDPSR_FRZTO BIT(10)
#define B_AX_B1_IMR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_AX_B1_IMR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_AX_B1_IMR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_AX_B1_IMR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_AX_B1_IMR_ERR_USRCTL_NOINIT BIT(1)
#define B_AX_B1_IMR_ERR_USRCTL_REINIT BIT(0)
#define B_AX_TXPKTCTL_IMR_B1_CLR_V1 (B_AX_B1_IMR_ERR_USRCTL_REINIT | \
				     B_AX_B1_IMR_ERR_USRCTL_NOINIT | \
				     B_AX_B1_IMR_ERR_USRCTL_RDNRLSCMD | \
				     B_AX_B1_IMR_ERR_USRCTL_RLSBMPLEN | \
				     B_AX_B1_IMR_ERR_CMDPSR_1STCMDERR | \
				     B_AX_B1_IMR_ERR_CMDPSR_CMDTYPE | \
				     B_AX_B1_IMR_ERR_CMDPSR_FRZTO | \
				     B_AX_B1_IMR_ERR_CMDPSR_TBLSZ | \
				     B_AX_B1_IMR_ERR_MPDUINFO_RECFG | \
				     B_AX_B1_IMR_ERR_MPDUIF_DATAERR | \
				     B_AX_B1_IMR_ERR_PRELD_RLSPKTSZERR | \
				     B_AX_B1_IMR_ERR_PRELD_ENTNUMCFG)
#define B_AX_TXPKTCTL_IMR_B1_SET_V1 (B_AX_B1_IMR_ERR_USRCTL_REINIT | \
				     B_AX_B1_IMR_ERR_USRCTL_NOINIT | \
				     B_AX_B1_IMR_ERR_CMDPSR_1STCMDERR | \
				     B_AX_B1_IMR_ERR_CMDPSR_CMDTYPE | \
				     B_AX_B1_IMR_ERR_CMDPSR_FRZTO | \
				     B_AX_B1_IMR_ERR_CMDPSR_TBLSZ | \
				     B_AX_B1_IMR_ERR_MPDUINFO_RECFG | \
				     B_AX_B1_IMR_ERR_MPDUIF_DATAERR | \
				     B_AX_B1_IMR_ERR_PRELD_RLSPKTSZERR | \
				     B_AX_B1_IMR_ERR_PRELD_ENTNUMCFG)

#define R_AX_TXPKTCTL_B1_ERRFLAG_ISR 0x9FBC
#define B_AX_B1_ISR_ERR_PRELD_EVT3 BIT(23)
#define B_AX_B1_ISR_ERR_PRELD_EVT2 BIT(22)
#define B_AX_B1_ISR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_AX_B1_ISR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_AX_B1_ISR_ERR_MPDUIF_ERR1 BIT(19)
#define B_AX_B1_ISR_ERR_MPDUIF_DATAERR BIT(18)
#define B_AX_B1_ISR_ERR_MPDUINFO_ERR1 BIT(17)
#define B_AX_B1_ISR_ERR_MPDUINFO_RECFG BIT(16)
#define B_AX_B1_ISR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_AX_B1_ISR_ERR_CMDPSR_FRZTO BIT(10)
#define B_AX_B1_ISR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_AX_B1_ISR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_AX_B1_ISR_ERR_USRCTL_EVT7 BIT(7)
#define B_AX_B1_ISR_ERR_USRCTL_EVT6 BIT(6)
#define B_AX_B1_ISR_ERR_USRCTL_EVT5 BIT(5)
#define B_AX_B1_ISR_ERR_USRCTL_EVT4 BIT(4)
#define B_AX_B1_ISR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_AX_B1_ISR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_AX_B1_ISR_ERR_USRCTL_NOINIT BIT(1)
#define B_AX_B1_ISR_ERR_USRCTL_REINIT BIT(0)

#define R_AX_AFE_CTRL1 0x0024
#define B_AX_CMAC_CLK_SEL BIT(21)

#define B_AX_R_SYM_WLCMAC1_P4_PC_EN BIT(4)
#define B_AX_R_SYM_WLCMAC1_P3_PC_EN BIT(3)
#define B_AX_R_SYM_WLCMAC1_P2_PC_EN BIT(2)
#define B_AX_R_SYM_WLCMAC1_P1_PC_EN BIT(1)
#define B_AX_R_SYM_WLCMAC1_PC_EN BIT(0)

#define R_AX_SYS_ISO_CTRL_EXTEND 0x0080
#define B_AX_CMAC1_FEN BIT(30)
#define B_AX_R_SYM_FEN_WLBBGLB_1 BIT(17)
#define B_AX_R_SYM_FEN_WLBBFUN_1 BIT(16)
#define B_AX_R_SYM_ISO_CMAC12PP BIT(5)

#define R_AX_SYSON_FSM_MON 0x00A0
#define B_AX_FSM_MON_SEL_MASK GENMASK(26, 24)
#define B_AX_DOP_ELDO BIT(23)
#define B_AX_FSM_MON_UPD BIT(15)
#define B_AX_FSM_PAR_MASK GENMASK(14, 0)

#define R_AX_CMAC_REG_START 0xC000

#define R_AX_CMAC_FUNC_EN 0xC000
#define R_AX_CMAC_FUNC_EN_C1 0xE000
#define B_AX_CMAC_CRPRT BIT(31)
#define B_AX_CMAC_EN BIT(30)
#define B_AX_CMAC_TXEN BIT(29)
#define B_AX_CMAC_RXEN BIT(28)
#define B_AX_FORCE_CMACREG_GCKEN BIT(15)
#define B_AX_PHYINTF_EN BIT(5)
#define B_AX_CMAC_DMA_EN BIT(4)
#define B_AX_PTCLTOP_EN BIT(3)
#define B_AX_SCHEDULER_EN BIT(2)
#define B_AX_TMAC_EN BIT(1)
#define B_AX_RMAC_EN BIT(0)

#define R_AX_CK_EN 0xC004
#define R_AX_CK_EN_C1 0xE004
#define B_AX_CMAC_ALLCKEN GENMASK(31, 0)
#define B_AX_CMAC_CKEN BIT(30)
#define B_AX_PHYINTF_CKEN BIT(5)
#define B_AX_CMAC_DMA_CKEN BIT(4)
#define B_AX_PTCLTOP_CKEN BIT(3)
#define B_AX_SCHEDULER_CKEN BIT(2)
#define B_AX_TMAC_CKEN BIT(1)
#define B_AX_RMAC_CKEN BIT(0)

#define R_AX_WMAC_RFMOD 0xC010
#define R_AX_WMAC_RFMOD_C1 0xE010
#define B_AX_WMAC_RFMOD_MASK GENMASK(1, 0)
#define AX_WMAC_RFMOD_20M 0
#define AX_WMAC_RFMOD_40M 1
#define AX_WMAC_RFMOD_80M 2
#define AX_WMAC_RFMOD_160M 3

#define R_AX_GID_POSITION0 0xC070
#define R_AX_GID_POSITION0_C1 0xE070
#define R_AX_GID_POSITION1 0xC074
#define R_AX_GID_POSITION1_C1 0xE074
#define R_AX_GID_POSITION2 0xC078
#define R_AX_GID_POSITION2_C1 0xE078
#define R_AX_GID_POSITION3 0xC07C
#define R_AX_GID_POSITION3_C1 0xE07C
#define R_AX_GID_POSITION_EN0 0xC080
#define R_AX_GID_POSITION_EN0_C1 0xE080
#define R_AX_GID_POSITION_EN1 0xC084
#define R_AX_GID_POSITION_EN1_C1 0xE084

#define R_AX_TX_SUB_CARRIER_VALUE 0xC088
#define R_AX_TX_SUB_CARRIER_VALUE_C1 0xE088
#define B_AX_TXSC_80M_MASK GENMASK(11, 8)
#define B_AX_TXSC_40M_MASK GENMASK(7, 4)
#define B_AX_TXSC_20M_MASK GENMASK(3, 0)

#define R_AX_PTCL_RRSR1 0xC090
#define R_AX_PTCL_RRSR1_C1 0xE090
#define B_AX_RRSR_RATE_EN_MASK GENMASK(11, 8)
#define RRSR_OFDM_CCK_EN 3
#define B_AX_RSC_MASK GENMASK(7, 6)
#define B_AX_RRSR_CCK_MASK GENMASK(3, 0)

#define R_AX_CMAC_ERR_IMR 0xC160
#define R_AX_CMAC_ERR_IMR_C1 0xE160
#define B_AX_WMAC_TX_ERR_IND_EN BIT(7)
#define B_AX_WMAC_RX_ERR_IND_EN BIT(6)
#define B_AX_TXPWR_CTRL_ERR_IND_EN BIT(5)
#define B_AX_PHYINTF_ERR_IND_EN BIT(4)
#define B_AX_DMA_TOP_ERR_IND_EN BIT(3)
#define B_AX_PTCL_TOP_ERR_IND_EN BIT(1)
#define B_AX_SCHEDULE_TOP_ERR_IND_EN BIT(0)
#define CMAC0_ERR_IMR_EN GENMASK(31, 0)
#define CMAC1_ERR_IMR_EN GENMASK(31, 0)
#define CMAC0_ERR_IMR_DIS 0
#define CMAC1_ERR_IMR_DIS 0

#define R_AX_CMAC_ERR_ISR 0xC164
#define R_AX_CMAC_ERR_ISR_C1 0xE164
#define B_AX_WMAC_TX_ERR_IND BIT(7)
#define B_AX_WMAC_RX_ERR_IND BIT(6)
#define B_AX_TXPWR_CTRL_ERR_IND BIT(5)
#define B_AX_PHYINTF_ERR_IND BIT(4)
#define B_AX_DMA_TOP_ERR_IND BIT(3)
#define B_AX_PTCL_TOP_ERR_IND BIT(1)
#define B_AX_SCHEDULE_TOP_ERR_IND BIT(0)

#define R_AX_PORT0_TSF_SYNC 0xC2A0
#define R_AX_PORT0_TSF_SYNC_C1 0xE2A0
#define R_AX_PORT1_TSF_SYNC 0xC2A4
#define R_AX_PORT1_TSF_SYNC_C1 0xE2A4
#define R_AX_PORT2_TSF_SYNC 0xC2A8
#define R_AX_PORT2_TSF_SYNC_C1 0xE2A8
#define R_AX_PORT3_TSF_SYNC 0xC2AC
#define R_AX_PORT3_TSF_SYNC_C1 0xE2AC
#define R_AX_PORT4_TSF_SYNC 0xC2B0
#define R_AX_PORT4_TSF_SYNC_C1 0xE2B0
#define B_AX_SYNC_NOW BIT(30)
#define B_AX_SYNC_ONCE BIT(29)
#define B_AX_SYNC_AUTO BIT(28)
#define B_AX_SYNC_PORT_SRC GENMASK(26, 24)
#define B_AX_SYNC_PORT_OFFSET_SIGN BIT(18)
#define B_AX_SYNC_PORT_OFFSET_VAL GENMASK(17, 0)

#define R_AX_MACID_SLEEP_0 0xC2C0
#define R_AX_MACID_SLEEP_0_C1 0xE2C0
#define B_AX_MACID31_0_SLEEP_SH 0
#define B_AX_MACID31_0_SLEEP_MASK GENMASK(31, 0)

#define R_AX_MACID_SLEEP_1 0xC2C4
#define R_AX_MACID_SLEEP_1_C1 0xE2C4
#define B_AX_MACID63_32_SLEEP_SH 0
#define B_AX_MACID63_32_SLEEP_MASK GENMASK(31, 0)

#define R_AX_MACID_SLEEP_2 0xC2C8
#define R_AX_MACID_SLEEP_2_C1 0xE2C8
#define B_AX_MACID95_64_SLEEP_SH 0
#define B_AX_MACID95_64_SLEEP_MASK GENMASK(31, 0)

#define R_AX_MACID_SLEEP_3 0xC2CC
#define R_AX_MACID_SLEEP_3_C1 0xE2CC
#define B_AX_MACID127_96_SLEEP_SH 0
#define B_AX_MACID127_96_SLEEP_MASK GENMASK(31, 0)

#define SCH_PREBKF_24US 0x18
#define R_AX_PREBKF_CFG_0 0xC338
#define R_AX_PREBKF_CFG_0_C1 0xE338
#define B_AX_PREBKF_TIME_MASK GENMASK(4, 0)

#define R_AX_PREBKF_CFG_1 0xC33C
#define R_AX_PREBKF_CFG_1_C1 0xE33C
#define B_AX_SIFS_TIMEOUT_TB_AGGR_MASK GENMASK(30, 24)
#define B_AX_SIFS_PREBKF_MASK GENMASK(23, 16)
#define B_AX_SIFS_TIMEOUT_T2_MASK GENMASK(14, 8)
#define B_AX_SIFS_MACTXEN_T1_MASK GENMASK(6, 0)
#define SIFS_MACTXEN_T1 0x47
#define SIFS_MACTXEN_T1_V1 0x41

#define R_AX_CCA_CFG_0 0xC340
#define R_AX_CCA_CFG_0_C1 0xE340
#define B_AX_BTCCA_BRK_TXOP_EN BIT(9)
#define B_AX_BTCCA_EN BIT(5)
#define B_AX_EDCCA_EN BIT(4)
#define B_AX_SEC80_EN BIT(3)
#define B_AX_SEC40_EN BIT(2)
#define B_AX_SEC20_EN BIT(1)
#define B_AX_CCA_EN BIT(0)

#define R_AX_CTN_TXEN 0xC348
#define R_AX_CTN_TXEN_C1 0xE348
#define B_AX_CTN_TXEN_TWT_1 BIT(15)
#define B_AX_CTN_TXEN_TWT_0 BIT(14)
#define B_AX_CTN_TXEN_ULQ BIT(13)
#define B_AX_CTN_TXEN_BCNQ BIT(12)
#define B_AX_CTN_TXEN_HGQ BIT(11)
#define B_AX_CTN_TXEN_CPUMGQ BIT(10)
#define B_AX_CTN_TXEN_MGQ1 BIT(9)
#define B_AX_CTN_TXEN_MGQ BIT(8)
#define B_AX_CTN_TXEN_VO_1 BIT(7)
#define B_AX_CTN_TXEN_VI_1 BIT(6)
#define B_AX_CTN_TXEN_BK_1 BIT(5)
#define B_AX_CTN_TXEN_BE_1 BIT(4)
#define B_AX_CTN_TXEN_VO_0 BIT(3)
#define B_AX_CTN_TXEN_VI_0 BIT(2)
#define B_AX_CTN_TXEN_BK_0 BIT(1)
#define B_AX_CTN_TXEN_BE_0 BIT(0)
#define B_AX_CTN_TXEN_ALL_MASK GENMASK(15, 0)

#define R_AX_MUEDCA_BE_PARAM_0 0xC350
#define R_AX_MUEDCA_BE_PARAM_0_C1 0xE350
#define B_AX_MUEDCA_BE_PARAM_0_TIMER_MASK GENMASK(31, 16)
#define B_AX_MUEDCA_BE_PARAM_0_CW_MASK GENMASK(15, 8)
#define B_AX_MUEDCA_BE_PARAM_0_AIFS_MASK GENMASK(7, 0)

#define R_AX_MUEDCA_BK_PARAM_0 0xC354
#define R_AX_MUEDCA_BK_PARAM_0_C1 0xE354
#define R_AX_MUEDCA_VI_PARAM_0 0xC358
#define R_AX_MUEDCA_VI_PARAM_0_C1 0xE358
#define R_AX_MUEDCA_VO_PARAM_0 0xC35C
#define R_AX_MUEDCA_VO_PARAM_0_C1 0xE35C

#define R_AX_MUEDCA_EN 0xC370
#define R_AX_MUEDCA_EN_C1 0xE370
#define B_AX_MUEDCA_WMM_SEL BIT(8)
#define B_AX_SET_MUEDCATIMER_TF_0 BIT(4)
#define B_AX_MUEDCA_EN_0 BIT(0)

#define R_AX_CCA_CONTROL 0xC390
#define R_AX_CCA_CONTROL_C1 0xE390
#define B_AX_TB_CHK_TX_NAV BIT(31)
#define B_AX_TB_CHK_BASIC_NAV BIT(30)
#define B_AX_TB_CHK_BTCCA BIT(29)
#define B_AX_TB_CHK_EDCCA BIT(28)
#define B_AX_TB_CHK_CCA_S80 BIT(27)
#define B_AX_TB_CHK_CCA_S40 BIT(26)
#define B_AX_TB_CHK_CCA_S20 BIT(25)
#define B_AX_TB_CHK_CCA_P20 BIT(24)
#define B_AX_SIFS_CHK_BTCCA BIT(21)
#define B_AX_SIFS_CHK_EDCCA BIT(20)
#define B_AX_SIFS_CHK_CCA_S80 BIT(19)
#define B_AX_SIFS_CHK_CCA_S40 BIT(18)
#define B_AX_SIFS_CHK_CCA_S20 BIT(17)
#define B_AX_SIFS_CHK_CCA_P20 BIT(16)
#define B_AX_CTN_CHK_TXNAV BIT(8)
#define B_AX_CTN_CHK_INTRA_NAV BIT(7)
#define B_AX_CTN_CHK_BASIC_NAV BIT(6)
#define B_AX_CTN_CHK_BTCCA BIT(5)
#define B_AX_CTN_CHK_EDCCA BIT(4)
#define B_AX_CTN_CHK_CCA_S80 BIT(3)
#define B_AX_CTN_CHK_CCA_S40 BIT(2)
#define B_AX_CTN_CHK_CCA_S20 BIT(1)
#define B_AX_CTN_CHK_CCA_P20 BIT(0)

#define R_AX_CTN_DRV_TXEN 0xC398
#define R_AX_CTN_DRV_TXEN_C1 0xE398
#define B_AX_CTN_TXEN_TWT_3 BIT(17)
#define B_AX_CTN_TXEN_TWT_2 BIT(16)
#define B_AX_CTN_TXEN_ALL_MASK_V1 GENMASK(17, 0)

#define R_AX_SCHEDULE_ERR_IMR 0xC3E8
#define R_AX_SCHEDULE_ERR_IMR_C1 0xE3E8
#define B_AX_SORT_NON_IDLE_ERR_INT_EN BIT(1)

#define R_AX_SCHEDULE_ERR_ISR 0xC3EC
#define R_AX_SCHEDULE_ERR_ISR_C1 0xE3EC

#define R_AX_SCH_DBG_SEL 0xC3F4
#define R_AX_SCH_DBG_SEL_C1 0xE3F4
#define B_AX_SCH_DBG_EN BIT(16)
#define B_AX_SCH_CFG_CMD_SEL GENMASK(15, 8)
#define B_AX_SCH_DBG_SEL_MASK GENMASK(7, 0)

#define R_AX_SCH_DBG 0xC3F8
#define R_AX_SCH_DBG_C1 0xE3F8
#define B_AX_SCHEDULER_DBG_MASK GENMASK(31, 0)

#define R_AX_SCH_EXT_CTRL 0xC3FC
#define R_AX_SCH_EXT_CTRL_C1 0xE3FC
#define B_AX_PORT_RST_TSF_ADV BIT(1)

#define R_AX_PORT_CFG_P0 0xC400
#define R_AX_PORT_CFG_P1 0xC440
#define R_AX_PORT_CFG_P2 0xC480
#define R_AX_PORT_CFG_P3 0xC4C0
#define R_AX_PORT_CFG_P4 0xC500
#define B_AX_BRK_SETUP BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL BIT(15)
#define B_AX_BCN_DROP_ALLOW BIT(14)
#define B_AX_TBTT_PROHIB_EN BIT(13)
#define B_AX_BCNTX_EN BIT(12)
#define B_AX_NET_TYPE_MASK GENMASK(11, 10)
#define B_AX_BCN_FORCETX_EN BIT(9)
#define B_AX_TXBCN_BTCCA_EN BIT(8)
#define B_AX_BCNERR_CNT_EN BIT(7)
#define B_AX_BCN_AGRES BIT(6)
#define B_AX_TSFTR_RST BIT(5)
#define B_AX_RX_BSSID_FIT_EN BIT(4)
#define B_AX_TSF_UDT_EN BIT(3)
#define B_AX_PORT_FUNC_EN BIT(2)
#define B_AX_TXBCN_RPT_EN BIT(1)
#define B_AX_RXBCN_RPT_EN BIT(0)

#define R_AX_TBTT_PROHIB_P0 0xC404
#define R_AX_TBTT_PROHIB_P1 0xC444
#define R_AX_TBTT_PROHIB_P2 0xC484
#define R_AX_TBTT_PROHIB_P3 0xC4C4
#define R_AX_TBTT_PROHIB_P4 0xC504
#define B_AX_TBTT_HOLD_MASK GENMASK(27, 16)
#define B_AX_TBTT_SETUP_MASK GENMASK(7, 0)

#define R_AX_BCN_AREA_P0 0xC408
#define R_AX_BCN_AREA_P1 0xC448
#define R_AX_BCN_AREA_P2 0xC488
#define R_AX_BCN_AREA_P3 0xC4C8
#define R_AX_BCN_AREA_P4 0xC508
#define B_AX_BCN_MSK_AREA_MASK GENMASK(27, 16)
#define B_AX_BCN_CTN_AREA_MASK GENMASK(11, 0)

#define R_AX_BCNERLYINT_CFG_P0 0xC40C
#define R_AX_BCNERLYINT_CFG_P1 0xC44C
#define R_AX_BCNERLYINT_CFG_P2 0xC48C
#define R_AX_BCNERLYINT_CFG_P3 0xC4CC
#define R_AX_BCNERLYINT_CFG_P4 0xC50C
#define B_AX_BCNERLY_MASK GENMASK(11, 0)

#define R_AX_TBTTERLYINT_CFG_P0 0xC40E
#define R_AX_TBTTERLYINT_CFG_P1 0xC44E
#define R_AX_TBTTERLYINT_CFG_P2 0xC48E
#define R_AX_TBTTERLYINT_CFG_P3 0xC4CE
#define R_AX_TBTTERLYINT_CFG_P4 0xC50E
#define B_AX_TBTTERLY_MASK GENMASK(11, 0)

#define R_AX_TBTT_AGG_P0 0xC412
#define R_AX_TBTT_AGG_P1 0xC452
#define R_AX_TBTT_AGG_P2 0xC492
#define R_AX_TBTT_AGG_P3 0xC4D2
#define R_AX_TBTT_AGG_P4 0xC512
#define B_AX_TBTT_AGG_NUM_MASK GENMASK(15, 8)

#define R_AX_BCN_SPACE_CFG_P0 0xC414
#define R_AX_BCN_SPACE_CFG_P1 0xC454
#define R_AX_BCN_SPACE_CFG_P2 0xC494
#define R_AX_BCN_SPACE_CFG_P3 0xC4D4
#define R_AX_BCN_SPACE_CFG_P4 0xC514
#define B_AX_SUB_BCN_SPACE_MASK GENMASK(23, 16)
#define B_AX_BCN_SPACE_MASK GENMASK(15, 0)

#define R_AX_BCN_FORCETX_P0 0xC418
#define R_AX_BCN_FORCETX_P1 0xC458
#define R_AX_BCN_FORCETX_P2 0xC498
#define R_AX_BCN_FORCETX_P3 0xC4D8
#define R_AX_BCN_FORCETX_P4 0xC518
#define B_AX_FORCE_BCN_CURRCNT_MASK GENMASK(23, 16)
#define B_AX_FORCE_BCN_NUM_MASK GENMASK(15, 0)
#define B_AX_BCN_MAX_ERR_MASK GENMASK(7, 0)

#define R_AX_BCN_ERR_CNT_P0 0xC420
#define R_AX_BCN_ERR_CNT_P1 0xC460
#define R_AX_BCN_ERR_CNT_P2 0xC4A0
#define R_AX_BCN_ERR_CNT_P3 0xC4E0
#define R_AX_BCN_ERR_CNT_P4 0xC520
#define B_AX_BCN_ERR_CNT_SUM_MASK GENMASK(31, 24)
#define B_AX_BCN_ERR_CNT_NAV_MASK GENMASK(23, 16)
#define B_AX_BCN_ERR_CNT_EDCCA_MASK GENMASK(15, 0)
#define B_AX_BCN_ERR_CNT_CCA_MASK GENMASK(7, 0)

#define R_AX_BCN_ERR_FLAG_P0 0xC424
#define R_AX_BCN_ERR_FLAG_P1 0xC464
#define R_AX_BCN_ERR_FLAG_P2 0xC4A4
#define R_AX_BCN_ERR_FLAG_P3 0xC4E4
#define R_AX_BCN_ERR_FLAG_P4 0xC524
#define B_AX_BCN_ERR_FLAG_OTHERS BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK BIT(0)

#define R_AX_DTIM_CTRL_P0 0xC426
#define R_AX_DTIM_CTRL_P1 0xC466
#define R_AX_DTIM_CTRL_P2 0xC4A6
#define R_AX_DTIM_CTRL_P3 0xC4E6
#define R_AX_DTIM_CTRL_P4 0xC526
#define B_AX_DTIM_NUM_MASK GENMASK(15, 8)
#define B_AX_DTIM_CURRCNT_MASK GENMASK(7, 0)

#define R_AX_TBTT_SHIFT_P0 0xC428
#define R_AX_TBTT_SHIFT_P1 0xC468
#define R_AX_TBTT_SHIFT_P2 0xC4A8
#define R_AX_TBTT_SHIFT_P3 0xC4E8
#define R_AX_TBTT_SHIFT_P4 0xC528
#define B_AX_TBTT_SHIFT_OFST_MASK GENMASK(11, 0)
#define B_AX_TBTT_SHIFT_OFST_SIGN BIT(11)
#define B_AX_TBTT_SHIFT_OFST_MAG GENMASK(10, 0)

#define R_AX_BCN_CNT_TMR_P0 0xC434
#define R_AX_BCN_CNT_TMR_P1 0xC474
#define R_AX_BCN_CNT_TMR_P2 0xC4B4
#define R_AX_BCN_CNT_TMR_P3 0xC4F4
#define R_AX_BCN_CNT_TMR_P4 0xC534
#define B_AX_BCN_CNT_TMR_MASK GENMASK(31, 0)

#define R_AX_TSFTR_LOW_P0 0xC438
#define R_AX_TSFTR_LOW_P1 0xC478
#define R_AX_TSFTR_LOW_P2 0xC4B8
#define R_AX_TSFTR_LOW_P3 0xC4F8
#define R_AX_TSFTR_LOW_P4 0xC538
#define B_AX_TSFTR_LOW_MASK GENMASK(31, 0)

#define R_AX_TSFTR_HIGH_P0 0xC43C
#define R_AX_TSFTR_HIGH_P1 0xC47C
#define R_AX_TSFTR_HIGH_P2 0xC4BC
#define R_AX_TSFTR_HIGH_P3 0xC4FC
#define R_AX_TSFTR_HIGH_P4 0xC53C
#define B_AX_TSFTR_HIGH_MASK GENMASK(31, 0)

#define R_AX_BCN_DROP_ALL0 0xC560
#define R_AX_BCN_DROP_ALL0_C1 0xE560
#define B_AX_BCN_DROP_ALL_P4 BIT(4)
#define B_AX_BCN_DROP_ALL_P3 BIT(3)
#define B_AX_BCN_DROP_ALL_P2 BIT(2)
#define B_AX_BCN_DROP_ALL_P1 BIT(1)
#define B_AX_BCN_DROP_ALL_P0 BIT(0)

#define R_AX_MBSSID_CTRL 0xC568
#define R_AX_MBSSID_CTRL_C1 0xE568
#define B_AX_P0MB_ALL_MASK GENMASK(23, 1)
#define B_AX_P0MB_NUM_MASK GENMASK(19, 16)
#define B_AX_P0MB15_EN BIT(15)
#define B_AX_P0MB14_EN BIT(14)
#define B_AX_P0MB13_EN BIT(13)
#define B_AX_P0MB12_EN BIT(12)
#define B_AX_P0MB11_EN BIT(11)
#define B_AX_P0MB10_EN BIT(10)
#define B_AX_P0MB9_EN BIT(9)
#define B_AX_P0MB8_EN BIT(8)
#define B_AX_P0MB7_EN BIT(7)
#define B_AX_P0MB6_EN BIT(6)
#define B_AX_P0MB5_EN BIT(5)
#define B_AX_P0MB4_EN BIT(4)
#define B_AX_P0MB3_EN BIT(3)
#define B_AX_P0MB2_EN BIT(2)
#define B_AX_P0MB1_EN BIT(1)

#define R_AX_P0MB_HGQ_WINDOW_CFG_0 0xC590
#define R_AX_P0MB_HGQ_WINDOW_CFG_0_C1 0xE590
#define R_AX_PORT_HGQ_WINDOW_CFG 0xC5A0
#define R_AX_PORT_HGQ_WINDOW_CFG_C1 0xE5A0

#define R_AX_PTCL_COMMON_SETTING_0 0xC600
#define R_AX_PTCL_COMMON_SETTING_0_C1 0xE600
#define B_AX_PCIE_MODE_MASK GENMASK(15, 14)
#define B_AX_CPUMGQ_LIFETIME_EN BIT(8)
#define B_AX_MGQ_LIFETIME_EN BIT(7)
#define B_AX_LIFETIME_EN BIT(6)
#define B_AX_PTCL_TRIGGER_SS_EN_UL BIT(4)
#define B_AX_PTCL_TRIGGER_SS_EN_1 BIT(3)
#define B_AX_PTCL_TRIGGER_SS_EN_0 BIT(2)
#define B_AX_CMAC_TX_MODE_1 BIT(1)
#define B_AX_CMAC_TX_MODE_0 BIT(0)

#define R_AX_AMPDU_AGG_LIMIT 0xC610
#define B_AX_AMPDU_MAX_TIME_MASK GENMASK(31, 24)
#define B_AX_RA_TRY_RATE_AGG_LMT_MASK GENMASK(23, 16)
#define B_AX_RTS_MAX_AGG_NUM_MASK GENMASK(15, 8)
#define B_AX_MAX_AGG_NUM_MASK GENMASK(7, 0)

#define R_AX_AGG_LEN_HT_0 0xC614
#define R_AX_AGG_LEN_HT_0_C1 0xE614
#define B_AX_AMPDU_MAX_LEN_HT_MASK GENMASK(31, 16)
#define B_AX_RTS_TXTIME_TH_MASK GENMASK(15, 8)
#define B_AX_RTS_LEN_TH_MASK GENMASK(7, 0)

#define R_AX_AGG_LEN_VHT_0 0xC618
#define R_AX_AGG_LEN_VHT_0_C1 0xE618
#define B_AX_AMPDU_MAX_LEN_VHT_MASK GENMASK(19, 0)

#define S_AX_CTS2S_TH_SEC_256B 1
#define R_AX_SIFS_SETTING 0xC624
#define R_AX_SIFS_SETTING_C1 0xE624
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_MASK GENMASK(31, 24)
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_TWW_MASK GENMASK(23, 18)
#define B_AX_HW_CTS2SELF_EN BIT(16)
#define B_AX_SPEC_SIFS_OFDM_PTCL_SH 8
#define B_AX_SPEC_SIFS_OFDM_PTCL_MASK GENMASK(15, 8)
#define B_AX_SPEC_SIFS_CCK_PTCL_MASK GENMASK(7, 0)
#define S_AX_CTS2S_TH_1K 4

#define R_AX_TXRATE_CHK 0xC628
#define R_AX_TXRATE_CHK_C1 0xE628
#define B_AX_DEFT_RATE_MASK GENMASK(15, 7)
#define B_AX_BAND_MODE BIT(4)
#define B_AX_MAX_TXNSS_MASK GENMASK(3, 2)
#define B_AX_RTS_LIMIT_IN_OFDM6 BIT(1)
#define B_AX_CHECK_CCK_EN BIT(0)

#define R_AX_TXCNT 0xC62C
#define R_AX_TXCNT_C1 0xE62C
#define B_AX_ADD_TXCNT_BY BIT(31)
#define B_AX_S_TXCNT_LMT_MASK GENMASK(29, 24)
#define B_AX_L_TXCNT_LMT_MASK GENMASK(21, 16)

#define R_AX_MBSSID_DROP_0 0xC63C
#define R_AX_MBSSID_DROP_0_C1 0xE63C
#define B_AX_GI_LTF_FB_SEL BIT(30)
#define B_AX_RATE_SEL_MASK GENMASK(29, 24)
#define B_AX_PORT_DROP_4_0_MASK GENMASK(20, 16)
#define B_AX_MBSSID_DROP_15_0_MASK GENMASK(15, 0)

#define R_AX_PTCLRPT_FULL_HDL 0xC660
#define R_AX_PTCLRPT_FULL_HDL_C1 0xE660
#define B_AX_RPT_LATCH_PHY_TIME_MASK GENMASK(15, 12)
#define B_AX_F2PCMD_FWWD_RLS_MODE BIT(9)
#define B_AX_F2PCMD_RPT_EN BIT(8)
#define B_AX_BCN_RPT_PATH_MASK GENMASK(7, 6)
#define B_AX_SPE_RPT_PATH_MASK GENMASK(5, 4)
#define FWD_TO_WLCPU 1
#define B_AX_TX_RPT_PATH_MASK GENMASK(3, 2)
#define B_AX_F2PCMDRPT_FULL_DROP BIT(1)
#define B_AX_NON_F2PCMDRPT_FULL_DROP BIT(0)

#define R_AX_BT_PLT 0xC67C
#define R_AX_BT_PLT_C1 0xE67C
#define B_AX_BT_PLT_PKT_CNT_MASK GENMASK(31, 16)
#define B_AX_BT_PLT_RST BIT(9)
#define B_AX_PLT_EN BIT(8)
#define B_AX_RX_PLT_GNT_LTE_RX BIT(7)
#define B_AX_RX_PLT_GNT_BT_RX BIT(6)
#define B_AX_RX_PLT_GNT_BT_TX BIT(5)
#define B_AX_RX_PLT_GNT_WL BIT(4)
#define B_AX_TX_PLT_GNT_LTE_RX BIT(3)
#define B_AX_TX_PLT_GNT_BT_RX BIT(2)
#define B_AX_TX_PLT_GNT_BT_TX BIT(1)
#define B_AX_TX_PLT_GNT_WL BIT(0)

#define R_AX_PTCL_BSS_COLOR_0 0xC6A0
#define R_AX_PTCL_BSS_COLOR_0_C1 0xE6A0
#define B_AX_BSS_COLOB_AX_PORT_3_MASK GENMASK(29, 24)
#define B_AX_BSS_COLOB_AX_PORT_2_MASK GENMASK(21, 16)
#define B_AX_BSS_COLOB_AX_PORT_1_MASK GENMASK(13, 8)
#define B_AX_BSS_COLOB_AX_PORT_0_MASK GENMASK(5, 0)

#define R_AX_PTCL_BSS_COLOR_1 0xC6A4
#define R_AX_PTCL_BSS_COLOR_1_C1 0xE6A4
#define B_AX_BSS_COLOB_AX_PORT_4_MASK GENMASK(5, 0)

#define R_AX_PTCL_IMR0 0xC6C0
#define R_AX_PTCL_IMR0_C1 0xE6C0
#define B_AX_F2PCMD_PKTID_ERR_INT_EN BIT(31)
#define B_AX_F2PCMD_RD_PKTID_ERR_INT_EN BIT(30)
#define B_AX_F2PCMD_ASSIGN_PKTID_ERR_INT_EN BIT(29)
#define B_AX_F2PCMD_USER_ALLC_ERR_INT_EN BIT(28)
#define B_AX_RX_SPF_U0_PKTID_ERR_INT_EN BIT(27)
#define B_AX_TX_SPF_U1_PKTID_ERR_INT_EN BIT(26)
#define B_AX_TX_SPF_U2_PKTID_ERR_INT_EN BIT(25)
#define B_AX_TX_SPF_U3_PKTID_ERR_INT_EN BIT(24)
#define B_AX_TX_RECORD_PKTID_ERR_INT_EN BIT(23)
#define B_AX_F2PCMD_EMPTY_ERR_INT_EN BIT(15)
#define B_AX_TWTSP_QSEL_ERR_INT_EN BIT(14)
#define B_AX_BCNQ_ORDER_ERR_INT_EN BIT(12)
#define B_AX_Q_PKTID_ERR_INT_EN BIT(11)
#define B_AX_D_PKTID_ERR_INT_EN BIT(10)
#define B_AX_TXPRT_FULL_DROP_ERR_INT_EN BIT(9)
#define B_AX_F2PCMDRPT_FULL_DROP_ERR_INT_EN BIT(8)
#define B_AX_FSM1_TIMEOUT_ERR_INT_EN BIT(1)
#define B_AX_FSM_TIMEOUT_ERR_INT_EN BIT(0)
#define B_AX_PTCL_IMR_CLR_ALL GENMASK(31, 0)
#define B_AX_PTCL_IMR_CLR (B_AX_FSM_TIMEOUT_ERR_INT_EN | \
			   B_AX_F2PCMDRPT_FULL_DROP_ERR_INT_EN | \
			   B_AX_TXPRT_FULL_DROP_ERR_INT_EN | \
			   B_AX_D_PKTID_ERR_INT_EN | \
			   B_AX_Q_PKTID_ERR_INT_EN | \
			   B_AX_BCNQ_ORDER_ERR_INT_EN | \
			   B_AX_TWTSP_QSEL_ERR_INT_EN | \
			   B_AX_F2PCMD_EMPTY_ERR_INT_EN | \
			   B_AX_TX_RECORD_PKTID_ERR_INT_EN | \
			   B_AX_TX_SPF_U3_PKTID_ERR_INT_EN | \
			   B_AX_TX_SPF_U2_PKTID_ERR_INT_EN | \
			   B_AX_TX_SPF_U1_PKTID_ERR_INT_EN | \
			   B_AX_RX_SPF_U0_PKTID_ERR_INT_EN | \
			   B_AX_F2PCMD_USER_ALLC_ERR_INT_EN | \
			   B_AX_F2PCMD_ASSIGN_PKTID_ERR_INT_EN | \
			   B_AX_F2PCMD_RD_PKTID_ERR_INT_EN | \
			   B_AX_F2PCMD_PKTID_ERR_INT_EN)
#define B_AX_PTCL_IMR_SET (B_AX_FSM_TIMEOUT_ERR_INT_EN | \
			   B_AX_TX_RECORD_PKTID_ERR_INT_EN | \
			   B_AX_F2PCMD_USER_ALLC_ERR_INT_EN)
#define B_AX_PTCL_IMR_CLR_V1 (B_AX_FSM1_TIMEOUT_ERR_INT_EN | \
			      B_AX_FSM_TIMEOUT_ERR_INT_EN)
#define B_AX_PTCL_IMR_SET_V1 (B_AX_FSM1_TIMEOUT_ERR_INT_EN | \
			      B_AX_FSM_TIMEOUT_ERR_INT_EN)

#define R_AX_PTCL_ISR0 0xC6C4
#define R_AX_PTCL_ISR0_C1 0xE6C4

#define S_AX_PTCL_TO_2MS 0x3F
#define R_AX_PTCL_FSM_MON 0xC6E8
#define R_AX_PTCL_FSM_MON_C1 0xE6E8
#define B_AX_PTCL_TX_ARB_TO_MODE BIT(6)
#define B_AX_PTCL_TX_ARB_TO_THR_MASK GENMASK(5, 0)

#define R_AX_PTCL_TX_CTN_SEL 0xC6EC
#define R_AX_PTCL_TX_CTN_SEL_C1 0xE6EC
#define B_AX_PTCL_TX_ON_STAT BIT(7)

#define R_AX_PTCL_DBG_INFO 0xC6F0
#define R_AX_PTCL_DBG_INFO_C1 0xE6F0
#define B_AX_PTCL_DBG_INFO_MASK_BY_PORT(port) \
({\
	typeof(port) _port = (port); \
	GENMASK((_port) * 2 + 1, (_port) * 2); \
})

#define B_AX_PTCL_DBG_INFO_MASK GENMASK(31, 0)
#define R_AX_PTCL_DBG 0xC6F4
#define R_AX_PTCL_DBG_C1 0xE6F4
#define B_AX_PTCL_DBG_EN BIT(8)
#define B_AX_PTCL_DBG_SEL_MASK GENMASK(7, 0)
#define AX_PTCL_DBG_BCNQ_NUM0 8
#define AX_PTCL_DBG_BCNQ_NUM1 9


#define R_AX_DLE_CTRL 0xC800
#define R_AX_DLE_CTRL_C1 0xE800
#define B_AX_NO_RESERVE_PAGE_ERR_IMR BIT(23)
#define B_AX_RXDATA_FSM_HANG_ERROR_IMR BIT(15)
#define B_AX_RXSTS_FSM_HANG_ERROR_IMR BIT(14)
#define B_AX_DLE_IMR_CLR (B_AX_RXSTS_FSM_HANG_ERROR_IMR | \
			  B_AX_RXDATA_FSM_HANG_ERROR_IMR | \
			  B_AX_NO_RESERVE_PAGE_ERR_IMR)
#define B_AX_DLE_IMR_SET (B_AX_RXSTS_FSM_HANG_ERROR_IMR | \
			  B_AX_RXDATA_FSM_HANG_ERROR_IMR)

#define R_AX_RX_ERR_FLAG 0xC800
#define R_AX_RX_ERR_FLAG_C1 0xE800
#define B_AX_RX_GET_NO_PAGE_ERR BIT(31)
#define B_AX_RX_GET_NULL_PKT_ERR BIT(30)
#define B_AX_RX_RU0_FSM_HANG_ERR BIT(29)
#define B_AX_RX_RU1_FSM_HANG_ERR BIT(28)
#define B_AX_RX_RU2_FSM_HANG_ERR BIT(27)
#define B_AX_RX_RU3_FSM_HANG_ERR BIT(26)
#define B_AX_RX_RU4_FSM_HANG_ERR BIT(25)
#define B_AX_RX_RU5_FSM_HANG_ERR BIT(24)
#define B_AX_RX_RU6_FSM_HANG_ERR BIT(23)
#define B_AX_RX_RU7_FSM_HANG_ERR BIT(22)
#define B_AX_RX_RXSTS_FSM_HANG_ERR BIT(21)
#define B_AX_RX_CSI_FSM_HANG_ERR BIT(20)
#define B_AX_RX_TXRPT_FSM_HANG_ERR BIT(19)
#define B_AX_RX_F2PCMD_FSM_HANG_ERR BIT(18)
#define B_AX_RX_RU0_ZERO_LEN_ERR BIT(17)
#define B_AX_RX_RU1_ZERO_LEN_ERR BIT(16)
#define B_AX_RX_RU2_ZERO_LEN_ERR BIT(15)
#define B_AX_RX_RU3_ZERO_LEN_ERR BIT(14)
#define B_AX_RX_RU4_ZERO_LEN_ERR BIT(13)
#define B_AX_RX_RU5_ZERO_LEN_ERR BIT(12)
#define B_AX_RX_RU6_ZERO_LEN_ERR BIT(11)
#define B_AX_RX_RU7_ZERO_LEN_ERR BIT(10)
#define B_AX_RX_RXSTS_ZERO_LEN_ERR BIT(9)
#define B_AX_RX_CSI_ZERO_LEN_ERR BIT(8)
#define B_AX_PLE_DATA_OPT_FSM_HANG BIT(7)
#define B_AX_PLE_RXDATA_REQ_BUF_FSM_HANG BIT(6)
#define B_AX_PLE_TXRPT_REQ_BUF_FSM_HANG BIT(5)
#define B_AX_PLE_WD_OPT_FSM_HANG BIT(4)
#define B_AX_PLE_ENQ_FSM_HANG BIT(3)
#define B_AX_RXDATA_ENQUE_ORDER_ERR BIT(2)
#define B_AX_RXSTS_ENQUE_ORDER_ERR BIT(1)
#define B_AX_RX_CSI_PKT_NUM_ERR BIT(0)

#define R_AX_RXDMA_CTRL_0 0xC804
#define R_AX_RXDMA_CTRL_0_C1 0xE804
#define B_AX_RXDMA_DBGOUT_EN BIT(31)
#define B_AX_RXDMA_DBG_SEL_MASK GENMASK(30, 29)
#define B_AX_RXDMA_FIFO_DBG_SEL_MASK GENMASK(28, 25)
#define B_AX_RXDMA_DEFAULT_PAGE_MASK GENMASK(22, 21)
#define B_AX_RXDMA_BUFF_REQ_PRI_MASK GENMASK(20, 19)
#define B_AX_RXDMA_TGT_QUEID_MASK GENMASK(18, 13)
#define B_AX_RXDMA_TGT_PRID_MASK GENMASK(12, 10)
#define B_AX_RXDMA_DIS_CSI_RELEASE BIT(9)
#define B_AX_RXDMA_DIS_RXSTS_WAIT_PTR_CLR BIT(7)
#define B_AX_RXDMA_DIS_CSI_WAIT_PTR_CLR BIT(6)
#define B_AX_RXSTS_PTR_FULL_MODE BIT(5)
#define B_AX_CSI_PTR_FULL_MODE BIT(4)
#define B_AX_RU3_PTR_FULL_MODE BIT(3)
#define B_AX_RU2_PTR_FULL_MODE BIT(2)
#define B_AX_RU1_PTR_FULL_MODE BIT(1)
#define B_AX_RU0_PTR_FULL_MODE BIT(0)
#define RX_FULL_MODE (B_AX_RU0_PTR_FULL_MODE | B_AX_RU1_PTR_FULL_MODE | \
		      B_AX_RU2_PTR_FULL_MODE | B_AX_RU3_PTR_FULL_MODE | \
		      B_AX_CSI_PTR_FULL_MODE | B_AX_RXSTS_PTR_FULL_MODE)

#define R_AX_RX_CTRL0 0xC808
#define R_AX_RX_CTRL0_C1 0xE808
#define B_AX_DLE_CLOCK_FORCE_V1 BIT(31)
#define B_AX_TXDMA_CLOCK_FORCE_V1 BIT(30)
#define B_AX_RXDMA_CLOCK_FORCE_V1 BIT(29)
#define B_AX_RXDMA_DEFAULT_PAGE_V1_MASK GENMASK(28, 24)
#define B_AX_RXDMA_CSI_TGT_QUEID_MASK GENMASK(23, 18)
#define B_AX_RXDMA_CSI_TGT_PRID_MASK GENMASK(17, 15)
#define B_AX_RXDMA_DIS_CSI_RELEASE_V1 BIT(14)
#define B_AX_CSI_PTR_FULL_MODE_V1 BIT(13)
#define B_AX_RXDATA_PTR_FULL_MODE BIT(12)
#define B_AX_RXSTS_PTR_FULL_MODE_V1 BIT(11)
#define B_AX_TXRPT_FULL_RSV_DEPTH_V1_MASK GENMASK(10, 8)
#define B_AX_RXDATA_FULL_RSV_DEPTH_MASK GENMASK(7, 5)
#define B_AX_RXSTS_FULL_RSV_DEPTH_V1_MASK GENMASK(4, 2)
#define B_AX_ORDER_FIFO_MASK GENMASK(1, 0)

#define R_AX_RX_CTRL1 0xC80C
#define R_AX_RX_CTRL1_C1 0xE80C
#define B_AX_RXDMA_TXRPT_QUEUE_ID_SW_EN BIT(31)
#define B_AX_RXDMA_TXRPT_QUEUE_ID_SW_V1_MASK GENMASK(30, 25)
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_SW_EN BIT(24)
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_SW_V1_MASK GENMASK(23, 18)
#define B_AX_RXDMA_TXRPT_QUEUE_ID_TGT_SW_EN BIT(17)
#define B_AX_RXDMA_TXRPT_QUEUE_ID_TGT_SW_1_MASK GENMASK(16, 11)
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_EN BIT(10)
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_1_MASK GENMASK(9, 4)
#define B_AX_ORDER_FIFO_OUT BIT(3)
#define B_AX_ORDER_FIFO_EMPTY BIT(2)
#define B_AX_DBG_SEL_MASK GENMASK(1, 0)

#define R_AX_RX_CTRL2 0xC810
#define R_AX_RX_CTRL2_C1 0xE810
#define B_AX_DLE_WDE_STATE_V1_MASK GENMASK(31, 30)
#define B_AX_DLE_PLE_STATE_V1_MASK GENMASK(29, 28)
#define B_AX_DLE_REQ_BUF_STATE_MASK GENMASK(27, 26)
#define B_AX_DLE_ENQ_STATE_V1 BIT(25)
#define B_AX_RX_DBG_SEL_MASK GENMASK(24, 19)
#define B_AX_MACRX_CS_MASK GENMASK(18, 14)
#define B_AX_RXSTS_CS_MASK GENMASK(13, 9)
#define B_AX_ERR_INDICATOR BIT(5)
#define B_AX_TXRPT_CS_MASK GENMASK(4, 0)

#define R_AX_RXDMA_PKT_INFO_0 0xC814
#define R_AX_RXDMA_PKT_INFO_1 0xC818
#define R_AX_RXDMA_PKT_INFO_2 0xC81C

#define R_AX_RX_ERR_FLAG_IMR 0xC804
#define R_AX_RX_ERR_FLAG_IMR_C1 0xE804
#define B_AX_RX_GET_NULL_PKT_ERR_MSK BIT(30)
#define B_AX_RX_RU0_FSM_HANG_MSK_ERR_MSK BIT(29)
#define B_AX_RX_RU1_FSM_HANG_MSK_ERR_MSK BIT(28)
#define B_AX_RX_RU2_FSM_HANG_MSK_ERR_MSK BIT(27)
#define B_AX_RX_RU3_FSM_HANG_MSK_ERR_MSK BIT(26)
#define B_AX_RX_RU4_FSM_HANG_MSK_ERR_MSK BIT(25)
#define B_AX_RX_RU5_FSM_HANG_MSK_ERR_MSK BIT(24)
#define B_AX_RX_RU6_FSM_HANG_MSK_ERR_MSK BIT(23)
#define B_AX_RX_RU7_FSM_HANG_MSK_ERR_MSK BIT(22)
#define B_AX_RX_RXSTS_FSM_HANG_MSK_ERR_MSK BIT(21)
#define B_AX_RX_CSI_FSM_HANG_MSK_ERR_MSK BIT(20)
#define B_AX_RX_TXRPT_FSM_HANG_MSK_ERR_MSK BIT(19)
#define B_AX_RX_F2PCMD_FSM_HANG_MSK_ERR_MSK BIT(18)
#define B_AX_RX_RU0_ZERO_LEN_ERR_MSK BIT(17)
#define B_AX_RX_RU1_ZERO_LEN_ERR_MSK BIT(16)
#define B_AX_RX_RU2_ZERO_LEN_ERR_MSK BIT(15)
#define B_AX_RX_RU3_ZERO_LEN_ERR_MSK BIT(14)
#define B_AX_RX_RU4_ZERO_LEN_ERR_MSK BIT(13)
#define B_AX_RX_RU5_ZERO_LEN_ERR_MSK BIT(12)
#define B_AX_RX_RU6_ZERO_LEN_ERR_MSK BIT(11)
#define B_AX_RX_RU7_ZERO_LEN_ERR_MSK BIT(10)
#define B_AX_RX_RXSTS_ZERO_LEN_ERR_MSK BIT(9)
#define B_AX_RX_CSI_ZERO_LEN_ERR_MSK BIT(8)
#define B_AX_PLE_DATA_OPT_FSM_HANG_MSK BIT(7)
#define B_AX_PLE_RXDATA_REQ_BUF_FSM_HANG_MSK BIT(6)
#define B_AX_PLE_TXRPT_REQ_BUF_FSM_HANG_MSK BIT(5)
#define B_AX_PLE_WD_OPT_FSM_HANG_MSK BIT(4)
#define B_AX_PLE_ENQ_FSM_HANG_MSK BIT(3)
#define B_AX_RXDATA_ENQUE_ORDER_ERR_MSK BIT(2)
#define B_AX_RXSTS_ENQUE_ORDER_ERR_MSK BIT(1)
#define B_AX_RX_CSI_PKT_NUM_ERR_MSK BIT(0)
#define B_AX_RX_ERR_IMR_CLR_V1 (B_AX_RXSTS_ENQUE_ORDER_ERR_MSK | \
				B_AX_RXDATA_ENQUE_ORDER_ERR_MSK | \
				B_AX_RX_CSI_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RXSTS_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU7_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU6_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU5_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU4_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU3_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU2_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU1_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU0_ZERO_LEN_ERR_MSK | \
				B_AX_RX_F2PCMD_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_TXRPT_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_CSI_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RXSTS_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU7_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU6_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU5_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU4_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU3_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU2_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU1_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU0_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_GET_NULL_PKT_ERR_MSK)
#define B_AX_RX_ERR_IMR_SET_V1 (B_AX_RXSTS_ENQUE_ORDER_ERR_MSK | \
				B_AX_RXDATA_ENQUE_ORDER_ERR_MSK | \
				B_AX_RX_CSI_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RXSTS_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU7_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU6_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU5_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU4_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU3_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU2_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU1_ZERO_LEN_ERR_MSK | \
				B_AX_RX_RU0_ZERO_LEN_ERR_MSK | \
				B_AX_RX_F2PCMD_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_TXRPT_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_CSI_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RXSTS_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU7_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU6_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU5_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU4_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU3_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU2_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU1_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_RU0_FSM_HANG_MSK_ERR_MSK | \
				B_AX_RX_GET_NULL_PKT_ERR_MSK)

#define R_AX_TX_ERR_FLAG_IMR 0xC870
#define R_AX_TX_ERR_FLAG_IMR_C1 0xE870
#define B_AX_TX_RU0_FSM_HANG_ERR_MSK BIT(31)
#define B_AX_TX_RU1_FSM_HANG_ERR_MSK BIT(30)
#define B_AX_TX_RU2_FSM_HANG_ERR_MSK BIT(29)
#define B_AX_TX_RU3_FSM_HANG_ERR_MSK BIT(28)
#define B_AX_TX_RU4_FSM_HANG_ERR_MSK BIT(27)
#define B_AX_TX_RU5_FSM_HANG_ERR_MSK BIT(26)
#define B_AX_TX_RU6_FSM_HANG_ERR_MSK BIT(25)
#define B_AX_TX_RU7_FSM_HANG_ERR_MSK BIT(24)
#define B_AX_TX_RU8_FSM_HANG_ERR_MSK BIT(23)
#define B_AX_TX_RU9_FSM_HANG_ERR_MSK BIT(22)
#define B_AX_TX_RU10_FSM_HANG_ERR_MSK BIT(21)
#define B_AX_TX_RU11_FSM_HANG_ERR_MSK BIT(20)
#define B_AX_TX_RU12_FSM_HANG_ERR_MSK BIT(19)
#define B_AX_TX_RU13_FSM_HANG_ERR_MSK BIT(18)
#define B_AX_TX_RU14_FSM_HANG_ERR_MSK BIT(17)
#define B_AX_TX_RU15_FSM_HANG_ERR_MSK BIT(16)
#define B_AX_TX_CSI_FSM_HANG_ERR_MSK BIT(15)
#define B_AX_TX_WD_PLD_ID_FSM_HANG_ERR_MSK BIT(14)
#define B_AX_TX_ERR_IMR_CLR_V1 (B_AX_TX_WD_PLD_ID_FSM_HANG_ERR_MSK | \
				B_AX_TX_CSI_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU7_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU6_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU5_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU4_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU3_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU2_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU1_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU0_FSM_HANG_ERR_MSK)
#define B_AX_TX_ERR_IMR_SET_V1 (B_AX_TX_WD_PLD_ID_FSM_HANG_ERR_MSK | \
				B_AX_TX_CSI_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU7_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU6_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU5_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU4_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU3_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU2_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU1_FSM_HANG_ERR_MSK | \
				B_AX_TX_RU0_FSM_HANG_ERR_MSK)

#define R_AX_TCR0 0xCA00
#define R_AX_TCR0_C1 0xEA00
#define B_AX_TCR_ZLD_NUM_MASK GENMASK(31, 24)
#define B_AX_TCR_UDF_EN BIT(23)
#define B_AX_TCR_UDF_THSD_MASK GENMASK(22, 16)
#define TCR_UDF_THSD 0x6
#define B_AX_TCR_ERRSTEN_MASK GENMASK(15, 10)
#define B_AX_TCR_VHTSIGA1_TXPS BIT(9)
#define B_AX_TCR_PLCP_ERRHDL_EN BIT(8)
#define B_AX_TCR_PADSEL BIT(7)
#define B_AX_TCR_MASK_SIGBCRC BIT(6)
#define B_AX_TCR_SR_VAL15_ALLOW BIT(5)
#define B_AX_TCR_EN_EOF BIT(4)
#define B_AX_TCR_EN_SCRAM_INC BIT(3)
#define B_AX_TCR_EN_20MST BIT(2)
#define B_AX_TCR_CRC BIT(1)
#define B_AX_TCR_DISGCLK BIT(0)

#define R_AX_TCR1 0xCA04
#define R_AX_TCR1_C1 0xEA04
#define B_AX_TXDFIFO_THRESHOLD GENMASK(31, 28)
#define B_AX_TCR_CCK_LOCK_CLK BIT(27)
#define B_AX_TCR_FORCE_READ_TXDFIFO BIT(26)
#define B_AX_TCR_USTIME GENMASK(23, 16)
#define B_AX_TCR_SMOOTH_VAL BIT(15)
#define B_AX_TCR_SMOOTH_CTRL BIT(14)
#define B_AX_CS_REQ_VAL BIT(13)
#define B_AX_CS_REQ_SEL BIT(12)
#define B_AX_TCR_ZLD_USTIME_AFTERPHYTXON GENMASK(11, 8)
#define B_AX_TCR_TXTIMEOUT GENMASK(7, 0)

#define R_AX_MD_TSFT_STMP_CTL 0xCA08
#define R_AX_MD_TSFT_STMP_CTL_C1 0xEA08
#define B_AX_TSFT_OFS_MASK GENMASK(31, 16)
#define B_AX_STMP_THSD_MASK GENMASK(15, 8)
#define B_AX_UPD_HGQMD BIT(1)
#define B_AX_UPD_TIMIE BIT(0)

#define R_AX_PPWRBIT_SETTING 0xCA0C
#define R_AX_PPWRBIT_SETTING_C1 0xEA0C

#define R_AX_TXD_FIFO_CTRL 0xCA1C
#define R_AX_TXD_FIFO_CTRL_C1 0xEA1C
#define B_AX_NON_LEGACY_PPDU_ZLD_USTIMER_MASK GENMASK(28, 24)
#define B_AX_LEGACY_PPDU_ZLD_USTIMER_MASK GENMASK(20, 16)
#define B_AX_TXDFIFO_HIGH_MCS_THRE_MASK GENMASK(15, 12)
#define TXDFIFO_HIGH_MCS_THRE 0x7
#define B_AX_TXDFIFO_LOW_MCS_THRE_MASK GENMASK(11, 8)
#define TXDFIFO_LOW_MCS_THRE  0x7
#define B_AX_HIGH_MCS_PHY_RATE_MASK GENMASK(7, 4)
#define B_AX_BW_PHY_RATE_MASK GENMASK(1, 0)

#define R_AX_MACTX_DBG_SEL_CNT 0xCA20
#define R_AX_MACTX_DBG_SEL_CNT_C1 0xEA20
#define B_AX_MACTX_MPDU_CNT GENMASK(31, 24)
#define B_AX_MACTX_DMA_CNT GENMASK(23, 16)
#define B_AX_LENGTH_ERR_FLAG_U3 BIT(11)
#define B_AX_LENGTH_ERR_FLAG_U2 BIT(10)
#define B_AX_LENGTH_ERR_FLAG_U1 BIT(9)
#define B_AX_LENGTH_ERR_FLAG_U0 BIT(8)
#define B_AX_DBGSEL_MACTX_MASK GENMASK(5, 0)

#define R_AX_WMAC_TX_CTRL_DEBUG 0xCAE4
#define R_AX_WMAC_TX_CTRL_DEBUG_C1 0xEAE4
#define B_AX_TX_CTRL_DEBUG_SEL_MASK GENMASK(3, 0)

#define R_AX_WMAC_TX_INFO0_DEBUG 0xCAE8
#define R_AX_WMAC_TX_INFO0_DEBUG_C1 0xEAE8
#define B_AX_TX_CTRL_INFO_P0_MASK GENMASK(31, 0)

#define R_AX_WMAC_TX_INFO1_DEBUG 0xCAEC
#define R_AX_WMAC_TX_INFO1_DEBUG_C1 0xEAEC
#define B_AX_TX_CTRL_INFO_P1_MASK GENMASK(31, 0)

#define R_AX_RSP_CHK_SIG 0xCC00
#define R_AX_RSP_CHK_SIG_C1 0xEC00
#define B_AX_RSP_STATIC_RTS_CHK_SERV_BW_EN BIT(30)
#define B_AX_RSP_TBPPDU_CHK_PWR BIT(29)
#define B_AX_RSP_CHK_BASIC_NAV BIT(21)
#define B_AX_RSP_CHK_INTRA_NAV BIT(20)
#define B_AX_RSP_CHK_TXNAV BIT(19)
#define B_AX_TXDATA_END_PS_OPT BIT(18)
#define B_AX_CHECK_SOUNDING_SEQ BIT(17)
#define B_AX_RXBA_IGNOREA2 BIT(16)
#define B_AX_ACKTO_CCK_MASK GENMASK(15, 8)
#define B_AX_ACKTO_MASK GENMASK(7, 0)

#define R_AX_TRXPTCL_RESP_0 0xCC04
#define R_AX_TRXPTCL_RESP_0_C1 0xEC04
#define B_AX_WMAC_RESP_STBC_EN BIT(31)
#define B_AX_WMAC_RXFTM_TXACK_SC BIT(30)
#define B_AX_WMAC_RXFTM_TXACKBWEQ BIT(29)
#define B_AX_RSP_CHK_SEC_CCA_80 BIT(28)
#define B_AX_RSP_CHK_SEC_CCA_40 BIT(27)
#define B_AX_RSP_CHK_SEC_CCA_20 BIT(26)
#define B_AX_RSP_CHK_BTCCA BIT(25)
#define B_AX_RSP_CHK_EDCCA BIT(24)
#define B_AX_RSP_CHK_CCA BIT(23)
#define B_AX_WMAC_LDPC_EN BIT(22)
#define B_AX_WMAC_SGIEN BIT(21)
#define B_AX_WMAC_SPLCPEN BIT(20)
#define B_AX_WMAC_BESP_EARLY_TXBA BIT(17)
#define B_AX_WMAC_SPEC_SIFS_OFDM_MASK GENMASK(15, 8)
#define B_AX_WMAC_SPEC_SIFS_CCK_MASK GENMASK(7, 0)
#define WMAC_SPEC_SIFS_OFDM_52A 0x15
#define WMAC_SPEC_SIFS_OFDM_52B 0x11
#define WMAC_SPEC_SIFS_OFDM_52C 0x11
#define WMAC_SPEC_SIFS_CCK	 0xA

#define R_AX_TRXPTCL_RRSR_CTL_0 0xCC08
#define R_AX_TRXPTCL_RRSR_CTL_0_C1 0xEC08
#define B_AX_RESP_TX_MACID_CCA_TH_EN BIT(31)
#define B_AX_RESP_TX_PWRMODE_MASK GENMASK(30, 28)
#define B_AX_FTM_RRSR_RATE_EN_MASK GENMASK(27, 24)
#define B_AX_NESS_MASK GENMASK(23, 22)
#define B_AX_WMAC_RESP_DOPPLEB_AX_EN BIT(21)
#define B_AX_WMAC_RESP_DCM_EN BIT(20)
#define B_AX_WMAC_RRSB_AX_CCK_MASK GENMASK(19, 16)
#define B_AX_WMAC_RESP_RATE_EN_MASK GENMASK(15, 12)
#define B_AX_WMAC_RESP_RSC_MASK GENMASK(11, 10)
#define B_AX_WMAC_RESP_REF_RATE_SEL BIT(9)
#define B_AX_WMAC_RESP_REF_RATE_MASK GENMASK(8, 0)

#define R_AX_MAC_LOOPBACK 0xCC20
#define R_AX_MAC_LOOPBACK_C1 0xEC20
#define B_AX_MACLBK_EN BIT(0)

#define R_AX_WMAC_NAV_CTL 0xCC80
#define R_AX_WMAC_NAV_CTL_C1 0xEC80
#define B_AX_WMAC_NAV_UPPER_EN BIT(26)
#define B_AX_WMAC_0P125US_TIMER_MASK GENMASK(25, 18)
#define B_AX_WMAC_PLCP_UP_NAV_EN BIT(17)
#define B_AX_WMAC_TF_UP_NAV_EN BIT(16)
#define B_AX_WMAC_NAV_UPPER_MASK GENMASK(15, 8)
#define NAV_12MS 0xBC
#define NAV_25MS 0xC4
#define B_AX_WMAC_RTS_RST_DUR_MASK GENMASK(7, 0)

#define R_AX_RXTRIG_TEST_USER_2 0xCCB0
#define R_AX_RXTRIG_TEST_USER_2_C1 0xECB0
#define B_AX_RXTRIG_MACID_MASK GENMASK(31, 24)
#define B_AX_RXTRIG_RU26_DIS BIT(21)
#define B_AX_RXTRIG_FCSCHK_EN BIT(20)
#define B_AX_RXTRIG_PORT_SEL_MASK GENMASK(19, 17)
#define B_AX_RXTRIG_EN BIT(16)
#define B_AX_RXTRIG_USERINFO_2_MASK GENMASK(15, 0)

#define R_AX_TRXPTCL_ERROR_INDICA_MASK 0xCCBC
#define R_AX_TRXPTCL_ERROR_INDICA_MASK_C1 0xECBC
#define B_AX_WMAC_MODE BIT(22)
#define B_AX_WMAC_TIMETOUT_THR_MASK GENMASK(21, 16)
#define B_AX_RMAC_FTM BIT(8)
#define B_AX_RMAC_CSI BIT(7)
#define B_AX_TMAC_MIMO_CTRL BIT(6)
#define B_AX_TMAC_RXTB BIT(5)
#define B_AX_TMAC_HWSIGB_GEN BIT(4)
#define B_AX_TMAC_TXPLCP BIT(3)
#define B_AX_TMAC_RESP BIT(2)
#define B_AX_TMAC_TXCTL BIT(1)
#define B_AX_TMAC_MACTX BIT(0)
#define B_AX_TMAC_IMR_CLR_V1 (B_AX_TMAC_MACTX | \
			      B_AX_TMAC_TXCTL | \
			      B_AX_TMAC_RESP | \
			      B_AX_TMAC_TXPLCP | \
			      B_AX_TMAC_HWSIGB_GEN | \
			      B_AX_TMAC_RXTB | \
			      B_AX_TMAC_MIMO_CTRL | \
			      B_AX_RMAC_CSI | \
			      B_AX_RMAC_FTM)
#define B_AX_TMAC_IMR_SET_V1 (B_AX_TMAC_MACTX | \
			      B_AX_TMAC_TXCTL | \
			      B_AX_TMAC_RESP | \
			      B_AX_TMAC_TXPLCP | \
			      B_AX_TMAC_HWSIGB_GEN | \
			      B_AX_TMAC_RXTB | \
			      B_AX_TMAC_MIMO_CTRL | \
			      B_AX_RMAC_FTM)

#define R_AX_TRXPTCL_ERROR_INDICA 0xCCC0
#define R_AX_TRXPTCL_ERROR_INDICA_C1 0xECC0
#define B_AX_FTM_ERROR_FLAG_CLR BIT(8)
#define B_AX_CSI_ERROR_FLAG_CLR BIT(7)
#define B_AX_MIMOCTRL_ERROR_FLAG_CLR BIT(6)
#define B_AX_RXTB_ERROR_FLAG_CLR BIT(5)
#define B_AX_HWSIGB_GEN_ERROR_FLAG_CLR BIT(4)
#define B_AX_TXPLCP_ERROR_FLAG_CLR BIT(3)
#define B_AX_RESP_ERROR_FLAG_CLR BIT(2)
#define B_AX_TXCTL_ERROR_FLAG_CLR BIT(1)
#define B_AX_MACTX_ERROR_FLAG_CLR BIT(0)

#define R_AX_WMAC_TX_TF_INFO_0 0xCCD0
#define R_AX_WMAC_TX_TF_INFO_0_C1 0xECD0
#define B_AX_WMAC_TX_TF_INFO_SEL_MASK GENMASK(2, 0)

#define R_AX_WMAC_TX_TF_INFO_1 0xCCD4
#define R_AX_WMAC_TX_TF_INFO_1_C1 0xECD4
#define B_AX_WMAC_TX_TF_INFO_P0_MASK GENMASK(31, 0)

#define R_AX_WMAC_TX_TF_INFO_2 0xCCD8
#define R_AX_WMAC_TX_TF_INFO_2_C1 0xECD8
#define B_AX_WMAC_TX_TF_INFO_P1_MASK GENMASK(31, 0)

#define R_AX_TMAC_ERR_IMR_ISR 0xCCEC
#define R_AX_TMAC_ERR_IMR_ISR_C1 0xECEC
#define B_AX_TMAC_TXPLCP_ERR_CLR BIT(19)
#define B_AX_TMAC_RESP_ERR_CLR BIT(18)
#define B_AX_TMAC_TXCTL_ERR_CLR BIT(17)
#define B_AX_TMAC_MACTX_ERR_CLR BIT(16)
#define B_AX_TMAC_TXPLCP_ERR BIT(14)
#define B_AX_TMAC_RESP_ERR BIT(13)
#define B_AX_TMAC_TXCTL_ERR BIT(12)
#define B_AX_TMAC_MACTX_ERR BIT(11)
#define B_AX_TMAC_TXPLCP_INT_EN BIT(10)
#define B_AX_TMAC_RESP_INT_EN BIT(9)
#define B_AX_TMAC_TXCTL_INT_EN BIT(8)
#define B_AX_TMAC_MACTX_INT_EN BIT(7)
#define B_AX_WMAC_INT_MODE BIT(6)
#define B_AX_TMAC_TIMETOUT_THR_MASK GENMASK(5, 0)
#define B_AX_TMAC_IMR_CLR (B_AX_TMAC_MACTX_INT_EN | \
			   B_AX_TMAC_TXCTL_INT_EN | \
			   B_AX_TMAC_RESP_INT_EN | \
			   B_AX_TMAC_TXPLCP_INT_EN)
#define B_AX_TMAC_IMR_SET (B_AX_TMAC_MACTX_INT_EN | \
			   B_AX_TMAC_TXCTL_INT_EN | \
			   B_AX_TMAC_RESP_INT_EN | \
			   B_AX_TMAC_TXPLCP_INT_EN)

#define R_AX_DBGSEL_TRXPTCL 0xCCF4
#define R_AX_DBGSEL_TRXPTCL_C1 0xECF4
#define B_AX_DBGSEL_TRXPTCL_MASK GENMASK(7, 0)

#define R_AX_PHYINFO_ERR_IMR_V1 0xCCF8
#define R_AX_PHYINFO_ERR_IMR_V1_C1 0xECF8
#define B_AX_PHYINTF_TIMEOUT_THR_MSAK_V1 GENMASK(21, 16)
#define B_AX_CSI_ON_TIMEOUT_EN BIT(5)
#define B_AX_STS_ON_TIMEOUT_EN BIT(4)
#define B_AX_DATA_ON_TIMEOUT_EN BIT(3)
#define B_AX_OFDM_CCA_TIMEOUT_EN BIT(2)
#define B_AX_CCK_CCA_TIMEOUT_EN BIT(1)
#define B_AX_PHY_TXON_TIMEOUT_EN BIT(0)
#define B_AX_PHYINFO_IMR_CLR_V1 (B_AX_PHY_TXON_TIMEOUT_EN | \
				 B_AX_CCK_CCA_TIMEOUT_EN | \
				 B_AX_OFDM_CCA_TIMEOUT_EN | \
				 B_AX_DATA_ON_TIMEOUT_EN | \
				 B_AX_STS_ON_TIMEOUT_EN | \
				 B_AX_CSI_ON_TIMEOUT_EN)
#define B_AX_PHYINFO_IMR_SET_V1 (B_AX_PHY_TXON_TIMEOUT_EN | \
				 B_AX_CCK_CCA_TIMEOUT_EN | \
				 B_AX_OFDM_CCA_TIMEOUT_EN | \
				 B_AX_DATA_ON_TIMEOUT_EN | \
				 B_AX_STS_ON_TIMEOUT_EN | \
				 B_AX_CSI_ON_TIMEOUT_EN)

#define R_AX_PHYINFO_ERR_IMR 0xCCFC
#define R_AX_PHYINFO_ERR_IMR_C1 0xECFC
#define B_AX_CSI_ON_TIMEOUT BIT(29)
#define B_AX_STS_ON_TIMEOUT BIT(28)
#define B_AX_DATA_ON_TIMEOUT BIT(27)
#define B_AX_OFDM_CCA_TIMEOUT BIT(26)
#define B_AX_CCK_CCA_TIMEOUT BIT(25)
#define B_AXC_PHY_TXON_TIMEOUT BIT(24)
#define B_AX_CSI_ON_TIMEOUT_INT_EN BIT(21)
#define B_AX_STS_ON_TIMEOUT_INT_EN BIT(20)
#define B_AX_DATA_ON_TIMEOUT_INT_EN BIT(19)
#define B_AX_OFDM_CCA_TIMEOUT_INT_EN BIT(18)
#define B_AX_CCK_CCA_TIMEOUT_INT_EN BIT(17)
#define B_AX_PHY_TXON_TIMEOUT_INT_EN BIT(16)
#define B_AX_PHYINTF_TIMEOUT_THR_MSAK GENMASK(5, 0)
#define B_AX_PHYINFO_IMR_EN_ALL (B_AX_PHY_TXON_TIMEOUT_INT_EN | \
				 B_AX_CCK_CCA_TIMEOUT_INT_EN | \
				 B_AX_OFDM_CCA_TIMEOUT_INT_EN | \
				 B_AX_DATA_ON_TIMEOUT_INT_EN | \
				 B_AX_STS_ON_TIMEOUT_INT_EN | \
				 B_AX_CSI_ON_TIMEOUT_INT_EN | \
				 B_AX_PHYINTF_TIMEOUT_THR_MSAK)
#define B_AX_PHYINFO_IMR_SET (B_AX_PHY_TXON_TIMEOUT_INT_EN | 0x7)

#define R_AX_PHYINFO_ERR_ISR 0xCCFC
#define R_AX_PHYINFO_ERR_ISR_C1 0xECFC

#define R_AX_BFMER_CTRL_0 0xCD78
#define R_AX_BFMER_CTRL_0_C1 0xED78
#define B_AX_BFMER_HE_CSI_OFFSET_MASK GENMASK(31, 24)
#define B_AX_BFMER_VHT_CSI_OFFSET_MASK GENMASK(23, 16)
#define B_AX_BFMER_HT_CSI_OFFSET_MASK GENMASK(15, 8)
#define B_AX_BFMER_NDP_BFEN BIT(2)
#define B_AX_BFMER_VHT_BFPRT_CHK BIT(0)

#define R_AX_BFMEE_RESP_OPTION 0xCD80
#define R_AX_BFMEE_RESP_OPTION_C1 0xED80
#define B_AX_BFMEE_NDP_RX_STANDBY_TIMER_MASK GENMASK(31, 24)
#define B_AX_BFMEE_BFRP_RX_STANDBY_TIMER_MASK GENMASK(23, 20)
#define BFRP_RX_STANDBY_TIMER_KEEP 0x0
#define BFRP_RX_STANDBY_TIMER_RELEASE 0x1
#define B_AX_MU_BFRPTSEG_SEL_MASK GENMASK(18, 17)
#define B_AX_BFMEE_NDP_RXSTDBY_SEL BIT(16)
#define BFRP_RX_STANDBY_TIMER		0x0
#define NDP_RX_STANDBY_TIMER		0xFF
#define B_AX_BFMEE_HE_NDPA_EN BIT(2)
#define B_AX_BFMEE_VHT_NDPA_EN BIT(1)
#define B_AX_BFMEE_HT_NDPA_EN BIT(0)

#define R_AX_TRXPTCL_RESP_CSI_CTRL_0 0xCD88
#define R_AX_TRXPTCL_RESP_CSI_CTRL_0_C1 0xED88
#define R_AX_TRXPTCL_RESP_CSI_CTRL_1 0xCD94
#define R_AX_TRXPTCL_RESP_CSI_CTRL_1_C1 0xED94
#define B_AX_BFMEE_CSISEQ_SEL BIT(29)
#define B_AX_BFMEE_BFPARAM_SEL BIT(28)
#define B_AX_BFMEE_OFDM_LEN_TH_MASK GENMASK(27, 24)
#define B_AX_BFMEE_BF_PORT_SEL BIT(23)
#define B_AX_BFMEE_USE_NSTS BIT(22)
#define B_AX_BFMEE_CSI_RATE_FB_EN BIT(21)
#define B_AX_BFMEE_CSI_GID_SEL BIT(20)
#define B_AX_BFMEE_CSI_RSC_MASK GENMASK(19, 18)
#define B_AX_BFMEE_CSI_FORCE_RETE_EN BIT(17)
#define B_AX_BFMEE_CSI_USE_NDPARATE BIT(16)
#define B_AX_BFMEE_CSI_WITHHTC_EN BIT(15)
#define B_AX_BFMEE_CSIINFO0_BF_EN BIT(14)
#define B_AX_BFMEE_CSIINFO0_STBC_EN BIT(13)
#define B_AX_BFMEE_CSIINFO0_LDPC_EN BIT(12)
#define B_AX_BFMEE_CSIINFO0_CS_MASK GENMASK(11, 10)
#define B_AX_BFMEE_CSIINFO0_CB_MASK GENMASK(9, 8)
#define B_AX_BFMEE_CSIINFO0_NG_MASK GENMASK(7, 6)
#define B_AX_BFMEE_CSIINFO0_NR_MASK GENMASK(5, 3)
#define B_AX_BFMEE_CSIINFO0_NC_MASK GENMASK(2, 0)

#define R_AX_TRXPTCL_RESP_CSI_RRSC 0xCD8C
#define R_AX_TRXPTCL_RESP_CSI_RRSC_C1 0xED8C
#define CSI_RRSC_BMAP 0x29292911

#define R_AX_TRXPTCL_RESP_CSI_RATE 0xCD90
#define R_AX_TRXPTCL_RESP_CSI_RATE_C1 0xED90
#define B_AX_BFMEE_HE_CSI_RATE_MASK GENMASK(22, 16)
#define B_AX_BFMEE_VHT_CSI_RATE_MASK GENMASK(14, 8)
#define B_AX_BFMEE_HT_CSI_RATE_MASK GENMASK(6, 0)
#define CSI_INIT_RATE_HE		0x3
#define CSI_INIT_RATE_VHT		0x3
#define CSI_INIT_RATE_HT		0x3

#define R_AX_RCR 0xCE00
#define R_AX_RCR_C1 0xEE00
#define B_AX_STOP_RX_IN BIT(11)
#define B_AX_DRV_INFO_SIZE_MASK GENMASK(10, 8)
#define B_AX_CH_EN_MASK GENMASK(3, 0)

#define R_AX_DLK_PROTECT_CTL 0xCE02
#define R_AX_DLK_PROTECT_CTL_C1 0xEE02
#define B_AX_RX_DLK_CCA_TIME_MASK GENMASK(15, 8)
#define B_AX_RX_DLK_DATA_TIME_MASK GENMASK(7, 4)
#define B_AX_RX_DLK_RST_EN BIT(1)
#define B_AX_RX_DLK_INT_EN BIT(0)

#define R_AX_PLCP_HDR_FLTR 0xCE04
#define R_AX_PLCP_HDR_FLTR_C1 0xEE04
#define B_AX_DIS_CHK_MIN_LEN BIT(8)
#define B_AX_HE_SIGB_CRC_CHK BIT(6)
#define B_AX_VHT_MU_SIGB_CRC_CHK BIT(5)
#define B_AX_VHT_SU_SIGB_CRC_CHK BIT(4)
#define B_AX_SIGA_CRC_CHK BIT(3)
#define B_AX_LSIG_PARITY_CHK_EN BIT(2)
#define B_AX_CCK_SIG_CHK BIT(1)
#define B_AX_CCK_CRC_CHK BIT(0)

#define R_AX_RX_FLTR_OPT 0xCE20
#define R_AX_RX_FLTR_OPT_C1 0xEE20
#define B_AX_UID_FILTER_MASK GENMASK(31, 24)
#define B_AX_UNSPT_FILTER_SH 22
#define B_AX_UNSPT_FILTER_MASK GENMASK(23, 22)
#define B_AX_RX_MPDU_MAX_LEN_MASK GENMASK(21, 16)
#define B_AX_RX_MPDU_MAX_LEN_SIZE 0x3f
#define B_AX_A_FTM_REQ BIT(14)
#define B_AX_A_ERR_PKT BIT(13)
#define B_AX_A_UNSUP_PKT BIT(12)
#define B_AX_A_CRC32_ERR BIT(11)
#define B_AX_A_PWR_MGNT BIT(10)
#define B_AX_A_BCN_CHK_RULE_MASK GENMASK(9, 8)
#define B_AX_A_BCN_CHK_EN BIT(7)
#define B_AX_A_MC_LIST_CAM_MATCH BIT(6)
#define B_AX_A_BC_CAM_MATCH BIT(5)
#define B_AX_A_UC_CAM_MATCH BIT(4)
#define B_AX_A_MC BIT(3)
#define B_AX_A_BC BIT(2)
#define B_AX_A_A1_MATCH BIT(1)
#define B_AX_SNIFFER_MODE BIT(0)
#define DEFAULT_AX_RX_FLTR (B_AX_A_A1_MATCH | B_AX_A_BC | B_AX_A_MC |	       \
			    B_AX_A_UC_CAM_MATCH | B_AX_A_BC_CAM_MATCH |	       \
			    B_AX_A_PWR_MGNT | B_AX_A_FTM_REQ |		       \
			    u32_encode_bits(3, B_AX_UID_FILTER_MASK) |	       \
			    B_AX_A_BCN_CHK_EN)
#define B_AX_RX_FLTR_CFG_MASK ((u32)~B_AX_RX_MPDU_MAX_LEN_MASK)

#define R_AX_CTRL_FLTR 0xCE24
#define R_AX_CTRL_FLTR_C1 0xEE24
#define R_AX_MGNT_FLTR 0xCE28
#define R_AX_MGNT_FLTR_C1 0xEE28
#define R_AX_DATA_FLTR 0xCE2C
#define R_AX_DATA_FLTR_C1 0xEE2C
#define RX_FLTR_FRAME_DROP	0x00000000
#define RX_FLTR_FRAME_TO_HOST	0x55555555
#define RX_FLTR_FRAME_TO_WLCPU	0xAAAAAAAA

#define R_AX_ADDR_CAM_CTRL 0xCE34
#define R_AX_ADDR_CAM_CTRL_C1 0xEE34
#define B_AX_ADDR_CAM_RANGE_MASK GENMASK(23, 16)
#define B_AX_ADDR_CAM_CMPLIMT_MASK GENMASK(15, 12)
#define B_AX_ADDR_CAM_CLR BIT(8)
#define B_AX_ADDR_CAM_A2_B0_CHK BIT(2)
#define B_AX_ADDR_CAM_SRCH_PERPKT BIT(1)
#define B_AX_ADDR_CAM_EN BIT(0)

#define R_AX_RESPBA_CAM_CTRL 0xCE3C
#define R_AX_RESPBA_CAM_CTRL_C1 0xEE3C
#define B_AX_SSN_SEL BIT(2)
#define B_AX_BACAM_RST_MASK GENMASK(1, 0)
#define S_AX_BACAM_RST_ALL 2

#define R_AX_PPDU_STAT 0xCE40
#define R_AX_PPDU_STAT_C1 0xEE40
#define B_AX_PPDU_STAT_RPT_TRIG BIT(8)
#define B_AX_PPDU_STAT_RPT_CRC32 BIT(5)
#define B_AX_PPDU_STAT_RPT_A1M BIT(4)
#define B_AX_APP_PLCP_HDR_RPT BIT(3)
#define B_AX_APP_RX_CNT_RPT BIT(2)
#define B_AX_APP_MAC_INFO_RPT BIT(1)
#define B_AX_PPDU_STAT_RPT_EN BIT(0)

#define R_AX_RX_SR_CTRL 0xCE4A
#define R_AX_RX_SR_CTRL_C1 0xEE4A
#define B_AX_SR_EN BIT(0)

#define R_AX_BSSID_SRC_CTRL 0xCE4B
#define R_AX_BSSID_SRC_CTRL_C1 0xEE4B
#define B_AX_BSSID_MATCH BIT(3)
#define B_AX_PARTIAL_AID_MATCH BIT(2)
#define B_AX_BSSCOLOR_MATCH BIT(1)
#define B_AX_PLCP_SRC_EN BIT(0)

#define R_AX_CSIRPT_OPTION 0xCE64
#define R_AX_CSIRPT_OPTION_C1 0xEE64
#define B_AX_CSIPRT_HESU_AID_EN BIT(25)
#define B_AX_CSIPRT_VHTSU_AID_EN BIT(24)

#define R_AX_BCN_PSR_RPT_P0 0xCE84
#define R_AX_BCN_PSR_RPT_P0_C1 0xEE84
#define B_AX_BCAID_P0_MASK GENMASK(10, 0)

#define R_AX_RX_STATE_MONITOR 0xCEF0
#define R_AX_RX_STATE_MONITOR_C1 0xEEF0
#define B_AX_RX_STATE_MONITOR_MASK GENMASK(31, 0)
#define B_AX_STATE_CUR_MASK GENMASK(31, 16)
#define B_AX_STATE_NXT_MASK GENMASK(13, 8)
#define B_AX_STATE_UPD BIT(7)
#define B_AX_STATE_SEL_MASK GENMASK(4, 0)

#define R_AX_RMAC_ERR_ISR 0xCEF4
#define R_AX_RMAC_ERR_ISR_C1 0xEEF4
#define B_AX_RXERR_INTPS_EN BIT(31)
#define B_AX_RMAC_RX_CSI_TIMEOUT_INT_EN BIT(19)
#define B_AX_RMAC_RX_TIMEOUT_INT_EN BIT(18)
#define B_AX_RMAC_CSI_TIMEOUT_INT_EN BIT(17)
#define B_AX_RMAC_DATA_ON_TIMEOUT_INT_EN BIT(16)
#define B_AX_RMAC_CCA_TIMEOUT_INT_EN BIT(15)
#define B_AX_RMAC_DMA_TIMEOUT_INT_EN BIT(14)
#define B_AX_RMAC_DATA_ON_TO_IDLE_TIMEOUT_INT_EN BIT(13)
#define B_AX_RMAC_CCA_TO_IDLE_TIMEOUT_INT_EN BIT(12)
#define B_AX_RMAC_RX_CSI_TIMEOUT_FLAG BIT(7)
#define B_AX_RMAC_RX_TIMEOUT_FLAG BIT(6)
#define B_AX_BMAC_CSI_TIMEOUT_FLAG BIT(5)
#define B_AX_BMAC_DATA_ON_TIMEOUT_FLAG BIT(4)
#define B_AX_BMAC_CCA_TIMEOUT_FLAG BIT(3)
#define B_AX_BMAC_DMA_TIMEOUT_FLAG BIT(2)
#define B_AX_BMAC_DATA_ON_TO_IDLE_TIMEOUT_FLAG BIT(1)
#define B_AX_BMAC_CCA_TO_IDLE_TIMEOUT_FLAG BIT(0)
#define B_AX_RMAC_IMR_CLR (B_AX_RMAC_CCA_TO_IDLE_TIMEOUT_INT_EN | \
			   B_AX_RMAC_DATA_ON_TO_IDLE_TIMEOUT_INT_EN | \
			   B_AX_RMAC_DMA_TIMEOUT_INT_EN | \
			   B_AX_RMAC_CCA_TIMEOUT_INT_EN | \
			   B_AX_RMAC_DATA_ON_TIMEOUT_INT_EN | \
			   B_AX_RMAC_CSI_TIMEOUT_INT_EN | \
			   B_AX_RMAC_RX_TIMEOUT_INT_EN | \
			   B_AX_RMAC_RX_CSI_TIMEOUT_INT_EN)
#define B_AX_RMAC_IMR_SET (B_AX_RMAC_DMA_TIMEOUT_INT_EN | \
			   B_AX_RMAC_CSI_TIMEOUT_INT_EN | \
			   B_AX_RMAC_RX_TIMEOUT_INT_EN | \
			   B_AX_RMAC_RX_CSI_TIMEOUT_INT_EN)

#define R_AX_RX_ERR_IMR 0xCEF8
#define R_AX_RX_ERR_IMR_C1 0xEEF8
#define B_AX_RX_ERR_TRIG_ACT_TO_MSK BIT(9)
#define B_AX_RX_ERR_STS_ACT_TO_MSK BIT(8)
#define B_AX_RX_ERR_CSI_ACT_TO_MSK BIT(7)
#define B_AX_RX_ERR_ACT_TO_MSK BIT(6)
#define B_AX_CSI_DATAON_ASSERT_TO_MSK BIT(5)
#define B_AX_DATAON_ASSERT_TO_MSK BIT(4)
#define B_AX_CCA_ASSERT_TO_MSK BIT(3)
#define B_AX_RX_ERR_DMA_TO_MSK BIT(2)
#define B_AX_RX_ERR_DATA_TO_MSK BIT(1)
#define B_AX_RX_ERR_CCA_TO_MSK BIT(0)
#define B_AX_RMAC_IMR_CLR_V1 (B_AX_RX_ERR_CCA_TO_MSK | \
			      B_AX_RX_ERR_DATA_TO_MSK | \
			      B_AX_RX_ERR_DMA_TO_MSK | \
			      B_AX_CCA_ASSERT_TO_MSK | \
			      B_AX_DATAON_ASSERT_TO_MSK | \
			      B_AX_CSI_DATAON_ASSERT_TO_MSK | \
			      B_AX_RX_ERR_ACT_TO_MSK | \
			      B_AX_RX_ERR_CSI_ACT_TO_MSK | \
			      B_AX_RX_ERR_STS_ACT_TO_MSK | \
			      B_AX_RX_ERR_TRIG_ACT_TO_MSK)
#define B_AX_RMAC_IMR_SET_V1 (B_AX_RX_ERR_CCA_TO_MSK | \
			      B_AX_RX_ERR_DATA_TO_MSK | \
			      B_AX_RX_ERR_DMA_TO_MSK | \
			      B_AX_CCA_ASSERT_TO_MSK | \
			      B_AX_DATAON_ASSERT_TO_MSK | \
			      B_AX_CSI_DATAON_ASSERT_TO_MSK | \
			      B_AX_RX_ERR_ACT_TO_MSK | \
			      B_AX_RX_ERR_CSI_ACT_TO_MSK | \
			      B_AX_RX_ERR_STS_ACT_TO_MSK | \
			      B_AX_RX_ERR_TRIG_ACT_TO_MSK)

#define R_AX_RMAC_PLCP_MON 0xCEF8
#define R_AX_RMAC_PLCP_MON_C1 0xEEF8
#define B_AX_RMAC_PLCP_MON_MASK GENMASK(31, 0)
#define B_AX_PCLP_MON_SEL_MASK GENMASK(31, 28)
#define B_AX_PCLP_MON_CONT_MASK GENMASK(27, 0)

#define R_AX_RX_DEBUG_SELECT 0xCEFC
#define R_AX_RX_DEBUG_SELECT_C1 0xEEFC
#define B_AX_DEBUG_SEL_MASK GENMASK(7, 0)

#define R_AX_PWR_RATE_CTRL 0xD200
#define R_AX_PWR_RATE_CTRL_C1 0xF200
#define B_AX_PWR_REF GENMASK(27, 10)
#define B_AX_FORCE_PWR_BY_RATE_EN BIT(9)
#define B_AX_FORCE_PWR_BY_RATE_VALUE_MASK GENMASK(8, 0)

#define R_AX_PWR_RATE_OFST_CTRL 0xD204
#define R_AX_PWR_COEXT_CTRL 0xD220
#define B_AX_TXAGC_BT_EN BIT(1)
#define B_AX_TXAGC_BT_MASK GENMASK(11, 3)

#define R_AX_PWR_SWING_OTHER_CTRL0 0xD230
#define R_AX_PWR_SWING_OTHER_CTRL0_C1 0xF230
#define B_AX_CFIR_BY_RATE_OFF_MASK GENMASK(17, 0)

#define R_AX_PWR_UL_CTRL0 0xD240
#define R_AX_PWR_UL_CTRL2 0xD248
#define B_AX_PWR_UL_CFO_MASK GENMASK(2, 0)
#define B_AX_PWR_UL_CTRL2_MASK 0x07700007

#define R_AX_PWR_NORM_FORCE1 0xD260
#define R_AX_PWR_NORM_FORCE1_C1 0xF260
#define B_AX_TXAGC_BF_PWR_BOOST_FORCE_VAL_EN BIT(29)
#define B_AX_TXAGC_BF_PWR_BOOST_FORCE_VAL_MASK GENMASK(28, 24)
#define B_AX_FORCE_HE_ER_SU_EN_EN BIT(23)
#define B_AX_FORCE_HE_ER_SU_EN_VALUE BIT(22)
#define B_AX_FORCE_MACID_CCA_TH_EN_EN BIT(21)
#define B_AX_FORCE_MACID_CCA_TH_EN_VALUE BIT(20)
#define B_AX_FORCE_BT_GRANT_EN BIT(19)
#define B_AX_FORCE_BT_GRANT_VALUE BIT(18)
#define B_AX_FORCE_RX_LTE_EN BIT(17)
#define B_AX_FORCE_RX_LTE_VALUE BIT(16)
#define B_AX_FORCE_TXBF_EN_EN BIT(15)
#define B_AX_FORCE_TXBF_EN_VALUE BIT(14)
#define B_AX_FORCE_TXSC_EN BIT(13)
#define B_AX_FORCE_TXSC_VALUE_MASK GENMASK(12, 9)
#define B_AX_FORCE_NTX_EN BIT(6)
#define B_AX_FORCE_NTX_VALUE BIT(5)
#define B_AX_FORCE_PWR_MODE_EN BIT(3)
#define B_AX_FORCE_PWR_MODE_VALUE_MASK GENMASK(2, 0)

#define R_AX_PWR_UL_TB_CTRL 0xD288
#define B_AX_PWR_UL_TB_CTRL_EN BIT(31)
#define R_AX_PWR_UL_TB_1T 0xD28C
#define B_AX_PWR_UL_TB_1T_MASK GENMASK(4, 0)
#define B_AX_PWR_UL_TB_1T_V1_MASK GENMASK(7, 0)
#define B_AX_PWR_UL_TB_1T_NORM_BW160 GENMASK(31, 24)
#define R_AX_PWR_UL_TB_2T 0xD290
#define B_AX_PWR_UL_TB_2T_MASK GENMASK(4, 0)
#define B_AX_PWR_UL_TB_2T_V1_MASK GENMASK(7, 0)
#define B_AX_PWR_UL_TB_2T_NORM_BW160 GENMASK(31, 24)
#define R_AX_PWR_BY_RATE_TABLE0 0xD2C0
#define R_AX_PWR_BY_RATE_TABLE6 0xD2D8
#define R_AX_PWR_BY_RATE_TABLE10 0xD2E8
#define R_AX_PWR_BY_RATE R_AX_PWR_BY_RATE_TABLE0
#define R_AX_PWR_BY_RATE_1SS_MAX R_AX_PWR_BY_RATE_TABLE6
#define R_AX_PWR_BY_RATE_MAX R_AX_PWR_BY_RATE_TABLE10
#define R_AX_PWR_LMT_TABLE0 0xD2EC
#define R_AX_PWR_LMT_TABLE9 0xD310
#define R_AX_PWR_LMT_TABLE19 0xD338
#define R_AX_PWR_LMT R_AX_PWR_LMT_TABLE0
#define R_AX_PWR_LMT_1SS_MAX R_AX_PWR_LMT_TABLE9
#define R_AX_PWR_LMT_MAX R_AX_PWR_LMT_TABLE19
#define R_AX_PWR_RU_LMT_TABLE0 0xD33C
#define R_AX_PWR_RU_LMT_TABLE5 0xD350
#define R_AX_PWR_RU_LMT_TABLE11 0xD368
#define R_AX_PWR_RU_LMT R_AX_PWR_RU_LMT_TABLE0
#define R_AX_PWR_RU_LMT_1SS_MAX R_AX_PWR_RU_LMT_TABLE5
#define R_AX_PWR_RU_LMT_MAX R_AX_PWR_RU_LMT_TABLE11
#define R_AX_PWR_MACID_LMT_TABLE0 0xD36C
#define R_AX_PWR_MACID_LMT_TABLE127 0xD568

#define R_AX_PATH_COM0 0xD800
#define AX_PATH_COM0_DFVAL 0x00000000
#define AX_PATH_COM0_PATHA 0x08889880
#define AX_PATH_COM0_PATHB 0x11111900
#define AX_PATH_COM0_PATHAB 0x19999980
#define R_AX_PATH_COM1 0xD804
#define B_AX_PATH_COM1_NORM_1STS GENMASK(31, 28)
#define AX_PATH_COM1_DFVAL 0x00000000
#define AX_PATH_COM1_PATHA 0x13111111
#define AX_PATH_COM1_PATHB 0x23222222
#define AX_PATH_COM1_PATHAB 0x33333333
#define R_AX_PATH_COM2 0xD808
#define B_AX_PATH_COM2_RESP_1STS_PATH GENMASK(7, 4)
#define AX_PATH_COM2_DFVAL 0x00000000
#define AX_PATH_COM2_PATHA 0x01209313
#define AX_PATH_COM2_PATHB 0x01209323
#define AX_PATH_COM2_PATHAB 0x01209333
#define R_AX_PATH_COM3 0xD80C
#define AX_PATH_COM3_DFVAL 0x49249249
#define R_AX_PATH_COM4 0xD810
#define AX_PATH_COM4_DFVAL 0x1C9C9C49
#define R_AX_PATH_COM5 0xD814
#define AX_PATH_COM5_DFVAL 0x39393939
#define R_AX_PATH_COM6 0xD818
#define AX_PATH_COM6_DFVAL 0x39393939
#define R_AX_PATH_COM7 0xD81C
#define AX_PATH_COM7_DFVAL 0x39393939
#define AX_PATH_COM7_PATHA 0x39393939
#define AX_PATH_COM7_PATHB 0x39383939
#define AX_PATH_COM7_PATHAB 0x39393939
#define R_AX_PATH_COM8 0xD820
#define AX_PATH_COM8_DFVAL 0x00000000
#define AX_PATH_COM8_PATHA 0x00003939
#define AX_PATH_COM8_PATHB 0x00003938
#define AX_PATH_COM8_PATHAB 0x00003939
#define R_AX_PATH_COM9 0xD824
#define AX_PATH_COM9_DFVAL 0x000007C0
#define R_AX_PATH_COM10 0xD828
#define AX_PATH_COM10_DFVAL 0xE0000000
#define R_AX_PATH_COM11 0xD82C
#define AX_PATH_COM11_DFVAL 0x00000000
#define R_P80_AT_HIGH_FREQ_BB_WRP 0xD848
#define B_P80_AT_HIGH_FREQ_BB_WRP BIT(28)
#define R_AX_TSSI_CTRL_HEAD 0xD908
#define R_AX_BANDEDGE_CFG 0xD94C
#define B_AX_BANDEDGE_CFG_IDX_MASK GENMASK(31, 30)
#define R_AX_TSSI_CTRL_TAIL 0xD95C

#define R_AX_TXPWR_IMR 0xD9E0
#define R_AX_TXPWR_IMR_C1 0xF9E0
#define R_AX_TXPWR_ISR 0xD9E4
#define R_AX_TXPWR_ISR_C1 0xF9E4

#define R_AX_BTC_CFG 0xDA00
#define B_AX_BTC_EN BIT(31)
#define B_AX_EN_EXT_BT_PINMUX BIT(29)
#define B_AX_BTC_RST BIT(28)
#define B_AX_BTC_DBG_SRC_SEL BIT(27)
#define B_AX_BTC_MODE_MASK GENMASK(25, 24)
#define B_AX_INV_WL_ACT2 BIT(17)
#define B_AX_BTG_LNA1_GAIN_SEL BIT(16)
#define B_AX_COEX_DLY_CLK_MASK GENMASK(15, 8)
#define B_AX_IGN_GNT_BT2_RX BIT(7)
#define B_AX_IGN_GNT_BT2_TX BIT(6)
#define B_AX_IGN_GNT_BT2 BIT(5)
#define B_AX_BTC_DBG_SEL_MASK GENMASK(4, 3)
#define B_AX_DIS_BTC_CLK_G BIT(2)
#define B_AX_GNT_WL_RX_CTRL BIT(1)
#define B_AX_WL_SRC BIT(0)

#define R_AX_RTK_MODE_CFG_V1 0xDA04
#define R_AX_RTK_MODE_CFG_V1_C1 0xFA04
#define B_AX_BT_BLE_EN_V1 BIT(24)
#define B_AX_BT_ULTRA_EN BIT(16)
#define B_AX_BT_L_RX_ULTRA_MASK GENMASK(15, 14)
#define B_AX_BT_L_TX_ULTRA_MASK GENMASK(13, 12)
#define B_AX_BT_H_RX_ULTRA_MASK GENMASK(11, 10)
#define B_AX_BT_H_TX_ULTRA_MASK GENMASK(9, 8)
#define B_AX_SAMPLE_CLK_MASK GENMASK(7, 0)

#define R_AX_WL_PRI_MSK 0xDA10
#define B_AX_PTA_WL_PRI_MASK_BCNQ BIT(8)

#define R_AX_BT_CNT_CFG 0xDA10
#define R_AX_BT_CNT_CFG_C1 0xFA10
#define B_AX_BT_CNT_RST_V1 BIT(1)
#define B_AX_BT_CNT_EN BIT(0)

#define R_BTC_BT_CNT_HIGH 0xDA14
#define R_BTC_BT_CNT_LOW 0xDA18

#define R_AX_BTC_FUNC_EN 0xDA20
#define R_AX_BTC_FUNC_EN_C1 0xFA20
#define B_AX_PTA_WL_TX_EN BIT(1)
#define B_AX_PTA_EDCCA_EN BIT(0)

#define R_BTC_COEX_WL_REQ 0xDA24
#define R_BTC_COEX_WL_REQ_BE 0xE324
#define B_BTC_TX_NULL_HI BIT(23)
#define B_BTC_TX_BCN_HI BIT(22)
#define B_BTC_TX_TRI_HI BIT(17)
#define B_BTC_RSP_ACK_HI BIT(10)
#define B_BTC_PRI_MASK_TX_TIME GENMASK(4, 3)
#define B_BTC_PRI_MASK_RX_TIME_V1 GENMASK(2, 1)

#define R_BTC_BREAK_TABLE 0xDA2C
#define BTC_BREAK_PARAM 0xf0ffffff

#define R_BTC_BT_COEX_MSK_TABLE 0xDA30
#define B_BTC_PRI_MASK_RXCCK_V1 BIT(28)
#define B_BTC_PRI_MASK_TX_RESP_V1 BIT(3)

#define R_AX_BT_COEX_CFG_2 0xDA34
#define R_AX_BT_COEX_CFG_2_C1 0xFA34
#define B_AX_GNT_BT_BYPASS_PRIORITY BIT(12)
#define B_AX_GNT_BT_POLARITY BIT(8)
#define B_AX_TIMER_MASK GENMASK(7, 0)
#define MAC_AX_CSR_RATE 80

#define R_AX_CSR_MODE 0xDA40
#define R_AX_CSR_MODE_C1 0xFA40
#define B_AX_BT_CNT_RST BIT(16)
#define B_AX_BT_STAT_DELAY_MASK GENMASK(15, 12)
#define MAC_AX_CSR_DELAY 0
#define B_AX_BT_TRX_INIT_DETECT_MASK GENMASK(11, 8)
#define MAC_AX_CSR_TRX_TO 4
#define B_AX_BT_PRI_DETECT_TO_MASK GENMASK(7, 4)
#define MAC_AX_CSR_PRI_TO 5
#define B_AX_WL_ACT_MSK BIT(3)
#define B_AX_STATIS_BT_EN BIT(2)
#define B_AX_WL_ACT_MASK_ENABLE BIT(1)
#define B_AX_ENHANCED_BT BIT(0)

#define R_AX_BT_BREAK_TABLE 0xDA44

#define R_AX_BT_STAST_HIGH 0xDA44
#define B_AX_STATIS_BT_HI_RX_MASK GENMASK(31, 16)
#define B_AX_STATIS_BT_HI_TX_MASK GENMASK(15, 0)
#define R_AX_BT_STAST_LOW 0xDA48
#define B_AX_STATIS_BT_LO_TX_1_MASK GENMASK(15, 0)
#define B_AX_STATIS_BT_LO_RX_1_MASK GENMASK(31, 16)

#define R_AX_GNT_SW_CTRL 0xDA48
#define R_AX_GNT_SW_CTRL_C1 0xFA48
#define B_AX_WL_ACT2_VAL BIT(21)
#define B_AX_WL_ACT2_SWCTRL BIT(20)
#define B_AX_WL_ACT_VAL BIT(19)
#define B_AX_WL_ACT_SWCTRL BIT(18)
#define B_AX_GNT_BT_RX_VAL BIT(17)
#define B_AX_GNT_BT_RX_SWCTRL BIT(16)
#define B_AX_GNT_BT_TX_VAL BIT(15)
#define B_AX_GNT_BT_TX_SWCTRL BIT(14)
#define B_AX_GNT_WL_RX_VAL BIT(13)
#define B_AX_GNT_WL_RX_SWCTRL BIT(12)
#define B_AX_GNT_WL_TX_VAL BIT(11)
#define B_AX_GNT_WL_TX_SWCTRL BIT(10)
#define B_AX_GNT_BT_RFC_S1_VAL BIT(9)
#define B_AX_GNT_BT_RFC_S1_SWCTRL BIT(8)
#define B_AX_GNT_WL_RFC_S1_VAL BIT(7)
#define B_AX_GNT_WL_RFC_S1_SWCTRL BIT(6)
#define B_AX_GNT_BT_RFC_S0_VAL BIT(5)
#define B_AX_GNT_BT_RFC_S0_SWCTRL BIT(4)
#define B_AX_GNT_WL_RFC_S0_VAL BIT(3)
#define B_AX_GNT_WL_RFC_S0_SWCTRL BIT(2)
#define B_AX_GNT_WL_BB_VAL BIT(1)
#define B_AX_GNT_WL_BB_SWCTRL BIT(0)

#define R_AX_GNT_VAL 0x0054
#define B_AX_GNT_BT_RFC_S1_STA BIT(5)
#define B_AX_GNT_WL_RFC_S1_STA BIT(4)
#define B_AX_GNT_BT_RFC_S0_STA BIT(3)
#define B_AX_GNT_WL_RFC_S0_STA BIT(2)

#define R_AX_GNT_VAL_V1 0xDA4C
#define B_AX_GNT_BT_RFC_S1 BIT(4)
#define B_AX_GNT_BT_RFC_S0 BIT(3)
#define B_AX_GNT_WL_RFC_S1 BIT(2)
#define B_AX_GNT_WL_RFC_S0 BIT(1)

#define R_AX_TDMA_MODE 0xDA4C
#define R_AX_TDMA_MODE_C1 0xFA4C
#define B_AX_R_BT_CMD_RPT_MASK GENMASK(31, 16)
#define B_AX_R_RPT_FROM_BT_MASK GENMASK(15, 8)
#define B_AX_BT_HID_ISR_SET_MASK GENMASK(7, 6)
#define B_AX_TDMA_BT_START_NOTIFY BIT(5)
#define B_AX_ENABLE_TDMA_FW_MODE BIT(4)
#define B_AX_ENABLE_PTA_TDMA_MODE BIT(3)
#define B_AX_ENABLE_COEXIST_TAB_IN_TDMA BIT(2)
#define B_AX_GPIO2_GPIO3_EXANGE_OR_NO_BT_CCA BIT(1)
#define B_AX_RTK_BT_ENABLE BIT(0)

#define R_AX_BT_COEX_CFG_5 0xDA6C
#define R_AX_BT_COEX_CFG_5_C1 0xFA6C
#define B_AX_BT_TIME_MASK GENMASK(31, 6)
#define B_AX_BT_RPT_SAMPLE_RATE_MASK GENMASK(5, 0)
#define MAC_AX_RTK_RATE 5

#define R_AX_LTE_CTRL 0xDAF0
#define R_AX_LTE_WDATA 0xDAF4
#define R_AX_LTE_RDATA 0xDAF8

#define R_AX_MACID_ANT_TABLE 0xDC00
#define R_AX_MACID_ANT_TABLE_LAST 0xDDFC

#define CMAC1_START_ADDR_AX 0xE000
#define CMAC1_END_ADDR_AX 0xFFFF
#define R_AX_CMAC_REG_END 0xFFFF

#define R_AX_LTE_SW_CFG_1 0x0038
#define R_AX_LTE_SW_CFG_1_C1 0x2038
#define B_AX_GNT_BT_RFC_S1_SW_VAL BIT(31)
#define B_AX_GNT_BT_RFC_S1_SW_CTRL BIT(30)
#define B_AX_GNT_WL_RFC_S1_SW_VAL BIT(29)
#define B_AX_GNT_WL_RFC_S1_SW_CTRL BIT(28)
#define B_AX_GNT_BT_BB_S1_SW_VAL BIT(27)
#define B_AX_GNT_BT_BB_S1_SW_CTRL BIT(26)
#define B_AX_GNT_WL_BB_S1_SW_VAL BIT(25)
#define B_AX_GNT_WL_BB_S1_SW_CTRL BIT(24)
#define B_AX_BT_SW_CTRL_WL_PRIORITY BIT(19)
#define B_AX_WL_SW_CTRL_WL_PRIORITY BIT(18)
#define B_AX_LTE_PATTERN_2_EN BIT(17)
#define B_AX_LTE_PATTERN_1_EN BIT(16)
#define B_AX_GNT_BT_RFC_S0_SW_VAL BIT(15)
#define B_AX_GNT_BT_RFC_S0_SW_CTRL BIT(14)
#define B_AX_GNT_WL_RFC_S0_SW_VAL BIT(13)
#define B_AX_GNT_WL_RFC_S0_SW_CTRL BIT(12)
#define B_AX_GNT_BT_BB_S0_SW_VAL BIT(11)
#define B_AX_GNT_BT_BB_S0_SW_CTRL BIT(10)
#define B_AX_GNT_WL_BB_S0_SW_VAL BIT(9)
#define B_AX_GNT_WL_BB_S0_SW_CTRL BIT(8)
#define B_AX_LTECOEX_FUN_EN BIT(7)
#define B_AX_LTECOEX_3WIRE_CTRL_MUX BIT(6)
#define B_AX_LTECOEX_OP_MODE_SEL_MASK GENMASK(5, 4)
#define B_AX_LTECOEX_UART_MUX BIT(3)
#define B_AX_LTECOEX_UART_MODE_SEL_MASK GENMASK(2, 0)

#define R_AX_LTE_SW_CFG_2 0x003C
#define R_AX_LTE_SW_CFG_2_C1 0x203C
#define B_AX_WL_RX_CTRL BIT(8)
#define B_AX_GNT_WL_RX_SW_VAL BIT(7)
#define B_AX_GNT_WL_RX_SW_CTRL BIT(6)
#define B_AX_GNT_WL_TX_SW_VAL BIT(5)
#define B_AX_GNT_WL_TX_SW_CTRL BIT(4)
#define B_AX_GNT_BT_RX_SW_VAL BIT(3)
#define B_AX_GNT_BT_RX_SW_CTRL BIT(2)
#define B_AX_GNT_BT_TX_SW_VAL BIT(1)
#define B_AX_GNT_BT_TX_SW_CTRL BIT(0)

#define R_BE_SYS_ISO_CTRL 0x0000
#define B_BE_PWC_EV2EF_B BIT(15)
#define B_BE_PWC_EV2EF_S BIT(14)
#define B_BE_PA33V_EN BIT(13)
#define B_BE_PA12V_EN BIT(12)
#define B_BE_PAOOBS33V_EN BIT(11)
#define B_BE_PAOOBS12V_EN BIT(10)
#define B_BE_ISO_RFDIO BIT(9)
#define B_BE_ISO_EB2CORE BIT(8)
#define B_BE_ISO_DIOE BIT(7)
#define B_BE_ISO_WLPON2PP BIT(6)
#define B_BE_ISO_IP2MAC_WA02PP BIT(5)
#define B_BE_ISO_PD2CORE BIT(4)
#define B_BE_ISO_PA2PCIE BIT(3)
#define B_BE_ISO_PAOOBS2PCIE BIT(1)
#define B_BE_ISO_WD2PP BIT(0)

#define R_BE_SYS_PW_CTRL 0x0004
#define B_BE_SOP_ASWRM BIT(31)
#define B_BE_SOP_EASWR BIT(30)
#define B_BE_SOP_PWMM_DSWR BIT(29)
#define B_BE_SOP_EDSWR BIT(28)
#define B_BE_SOP_ACKF BIT(27)
#define B_BE_SOP_ERCK BIT(26)
#define B_BE_SOP_ANA_CLK_DIVISION_2 BIT(25)
#define B_BE_SOP_EXTL BIT(24)
#define B_BE_SOP_OFF_CAPC_EN BIT(23)
#define B_BE_XTAL_OFF_A_DIE BIT(22)
#define B_BE_ROP_SWPR BIT(21)
#define B_BE_DIS_HW_LPLDM BIT(20)
#define B_BE_DIS_HW_LPURLDO BIT(19)
#define B_BE_DIS_WLBT_PDNSUSEN_SOPC BIT(18)
#define B_BE_RDY_SYSPWR BIT(17)
#define B_BE_EN_WLON BIT(16)
#define B_BE_APDM_HPDN BIT(15)
#define B_BE_PSUS_OFF_CAPC_EN BIT(14)
#define B_BE_USUS_OFFCAPC_EN BIT(13)
#define B_BE_AFSM_PCIE_SUS_EN BIT(12)
#define B_BE_AFSM_WLSUS_EN BIT(11)
#define B_BE_APFM_SWLPS BIT(10)
#define B_BE_APFM_OFFMAC BIT(9)
#define B_BE_APFN_ONMAC BIT(8)
#define B_BE_CHIP_PDN_EN BIT(7)
#define B_BE_RDY_MACDIS BIT(6)

#define R_BE_SYS_CLK_CTRL 0x0008
#define B_BE_CPU_CLK_EN BIT(14)
#define B_BE_SYMR_BE_CLK_EN BIT(13)
#define B_BE_MAC_CLK_EN BIT(11)
#define B_BE_EXT_32K_EN BIT(8)
#define B_BE_WL_CLK_TEST BIT(7)
#define B_BE_LOADER_CLK_EN BIT(5)
#define B_BE_ANA_CLK_DIVISION_2 BIT(1)
#define B_BE_CNTD16V_EN BIT(0)

#define R_BE_SYS_WL_EFUSE_CTRL 0x000A
#define B_BE_OTP_B_PWC_RPT BIT(15)
#define B_BE_OTP_S_PWC_RPT BIT(14)
#define B_BE_OTP_ISO_RPT BIT(13)
#define B_BE_OTP_BURST_RPT BIT(12)
#define B_BE_OTP_AUTOLOAD_RPT BIT(11)
#define B_BE_AUTOLOAD_DIS_A_DIE BIT(6)
#define B_BE_AUTOLOAD_SUS BIT(5)
#define B_BE_AUTOLOAD_DIS BIT(4)

#define R_BE_SYS_PAGE_CLK_GATED 0x000C
#define B_BE_USB_APHY_PC_DLP_OP BIT(27)
#define B_BE_PCIE_APHY_PC_DLP_OP BIT(26)
#define B_BE_UPHY_POWER_READY_CHK BIT(25)
#define B_BE_CPHY_POWER_READY_CHK BIT(24)
#define B_BE_PCIE_PRST_DEBUNC_PERIOD_MASK GENMASK(23, 22)
#define B_BE_SYM_PRST_DEBUNC_SEL BIT(21)
#define B_BE_CPHY_AUXCLK_OP BIT(20)
#define B_BE_SOP_OFFUA_PC BIT(19)
#define B_BE_SOP_OFFPOOBS_PC BIT(18)
#define B_BE_PCIE_LAN1_MASK BIT(17)
#define B_BE_PCIE_LAN0_MASK BIT(16)
#define B_BE_DIS_CLK_REGF_GATE BIT(15)
#define B_BE_DIS_CLK_REGE_GATE BIT(14)
#define B_BE_DIS_CLK_REGD_GATE BIT(13)
#define B_BE_DIS_CLK_REGC_GATE BIT(12)
#define B_BE_DIS_CLK_REGB_GATE BIT(11)
#define B_BE_DIS_CLK_REGA_GATE BIT(10)
#define B_BE_DIS_CLK_REG9_GATE BIT(9)
#define B_BE_DIS_CLK_REG8_GATE BIT(8)
#define B_BE_DIS_CLK_REG7_GATE BIT(7)
#define B_BE_DIS_CLK_REG6_GATE BIT(6)
#define B_BE_DIS_CLK_REG5_GATE BIT(5)
#define B_BE_DIS_CLK_REG4_GATE BIT(4)
#define B_BE_DIS_CLK_REG3_GATE BIT(3)
#define B_BE_DIS_CLK_REG2_GATE BIT(2)
#define B_BE_DIS_CLK_REG1_GATE BIT(1)
#define B_BE_DIS_CLK_REG0_GATE BIT(0)

#define R_BE_ANAPAR_POW_MAC 0x0016
#define B_BE_POW_PC_LDO_PORT1 BIT(3)
#define B_BE_POW_PC_LDO_PORT0 BIT(2)
#define B_BE_POW_PLL_V1 BIT(1)
#define B_BE_POW_POWER_CUT_POW_LDO BIT(0)

#define R_BE_SYS_ADIE_PAD_PWR_CTRL 0x0018
#define B_BE_SYM_PADPDN_WL_RFC1_1P3 BIT(6)
#define B_BE_SYM_PADPDN_WL_RFC0_1P3 BIT(5)

#define R_BE_RSV_CTRL 0x001C
#define B_BE_R_SYM_PRST_CPHY_RST BIT(25)
#define B_BE_R_SYM_PRST_PDN_EN BIT(24)
#define B_BE_HR_BE_DBG GENMASK(23, 12)
#define B_BE_R_SYM_DIS_PCIE_FLR BIT(9)
#define B_BE_R_EN_HRST_PWRON BIT(8)
#define B_BE_LOCK_ALL_EN BIT(7)
#define B_BE_R_DIS_PRST BIT(6)
#define B_BE_WLOCK_1C_BIT6 BIT(5)
#define B_BE_WLOCK_40 BIT(4)
#define B_BE_WLOCK_08 BIT(3)
#define B_BE_WLOCK_04 BIT(2)
#define B_BE_WLOCK_00 BIT(1)
#define B_BE_WLOCK_ALL BIT(0)

#define R_BE_AFE_LDO_CTRL 0x0020
#define B_BE_FORCE_MACBBBT_PWR_ON BIT(31)
#define B_BE_R_SYM_WLPOFF_P4_PC_EN BIT(28)
#define B_BE_R_SYM_WLPOFF_P3_PC_EN BIT(27)
#define B_BE_R_SYM_WLPOFF_P2_PC_EN BIT(26)
#define B_BE_R_SYM_WLPOFF_P1_PC_EN BIT(25)
#define B_BE_R_SYM_WLPOFF_PC_EN BIT(24)
#define B_BE_AON_OFF_PC_EN BIT(23)
#define B_BE_R_SYM_WLPON_P3_PC_EN BIT(21)
#define B_BE_R_SYM_WLPON_P2_PC_EN BIT(20)
#define B_BE_R_SYM_WLPON_P1_PC_EN BIT(19)
#define B_BE_R_SYM_WLPON_PC_EN BIT(18)
#define B_BE_R_SYM_WLBBPON1_P1_PC_EN BIT(15)
#define B_BE_R_SYM_WLBBPON1_PC_EN BIT(14)
#define B_BE_R_SYM_WLBBPON_P1_PC_EN BIT(13)
#define B_BE_R_SYM_WLBBPON_PC_EN BIT(12)
#define B_BE_R_SYM_DIS_WPHYBBOFF_PC BIT(10)
#define B_BE_R_SYM_WLBBOFF1_P4_PC_EN BIT(9)
#define B_BE_R_SYM_WLBBOFF1_P3_PC_EN BIT(8)
#define B_BE_R_SYM_WLBBOFF1_P2_PC_EN BIT(7)
#define B_BE_R_SYM_WLBBOFF1_P1_PC_EN BIT(6)
#define B_BE_R_SYM_WLBBOFF1_PC_EN BIT(5)
#define B_BE_R_SYM_WLBBOFF_P4_PC_EN BIT(4)
#define B_BE_R_SYM_WLBBOFF_P3_PC_EN BIT(3)
#define B_BE_R_SYM_WLBBOFF_P2_PC_EN BIT(2)
#define B_BE_R_SYM_WLBBOFF_P1_PC_EN BIT(1)
#define B_BE_R_SYM_WLBBOFF_PC_EN BIT(0)

#define R_BE_AFE_CTRL1 0x0024
#define B_BE_R_SYM_WLCMAC0_P4_PC_EN BIT(28)
#define B_BE_R_SYM_WLCMAC0_P3_PC_EN BIT(27)
#define B_BE_R_SYM_WLCMAC0_P2_PC_EN BIT(26)
#define B_BE_R_SYM_WLCMAC0_P1_PC_EN BIT(25)
#define B_BE_R_SYM_WLCMAC0_PC_EN BIT(24)
#define B_BE_R_SYM_WLCMAC0_ALL_EN (B_BE_R_SYM_WLCMAC0_PC_EN | \
				   B_BE_R_SYM_WLCMAC0_P1_PC_EN | \
				   B_BE_R_SYM_WLCMAC0_P2_PC_EN | \
				   B_BE_R_SYM_WLCMAC0_P3_PC_EN | \
				   B_BE_R_SYM_WLCMAC0_P4_PC_EN)
#define B_BE_DATAMEM_PC3_EN BIT(23)
#define B_BE_DATAMEM_PC2_EN BIT(22)
#define B_BE_DATAMEM_PC1_EN BIT(21)
#define B_BE_DATAMEM_PC_EN BIT(20)
#define B_BE_DMEM7_PC_EN BIT(19)
#define B_BE_DMEM6_PC_EN BIT(18)
#define B_BE_DMEM5_PC_EN BIT(17)
#define B_BE_DMEM4_PC_EN BIT(16)
#define B_BE_DMEM3_PC_EN BIT(15)
#define B_BE_DMEM2_PC_EN BIT(14)
#define B_BE_DMEM1_PC_EN BIT(13)
#define B_BE_IMEM4_PC_EN BIT(12)
#define B_BE_IMEM3_PC_EN BIT(11)
#define B_BE_IMEM2_PC_EN BIT(10)
#define B_BE_IMEM1_PC_EN BIT(9)
#define B_BE_IMEM0_PC_EN BIT(8)
#define B_BE_R_SYM_WLCMAC1_P4_PC_EN BIT(4)
#define B_BE_R_SYM_WLCMAC1_P3_PC_EN BIT(3)
#define B_BE_R_SYM_WLCMAC1_P2_PC_EN BIT(2)
#define B_BE_R_SYM_WLCMAC1_P1_PC_EN BIT(1)
#define B_BE_R_SYM_WLCMAC1_PC_EN BIT(0)
#define B_BE_R_SYM_WLCMAC1_ALL_EN (B_BE_R_SYM_WLCMAC1_PC_EN | \
				   B_BE_R_SYM_WLCMAC1_P1_PC_EN | \
				   B_BE_R_SYM_WLCMAC1_P2_PC_EN | \
				   B_BE_R_SYM_WLCMAC1_P3_PC_EN | \
				   B_BE_R_SYM_WLCMAC1_P4_PC_EN)

#define R_BE_EFUSE_CTRL 0x0030
#define B_BE_EF_MODE_SEL_MASK GENMASK(31, 30)
#define B_BE_EF_RDY BIT(29)
#define B_BE_EF_COMP_RESULT BIT(28)
#define B_BE_EF_ADDR_MASK GENMASK(15, 0)

#define R_BE_EFUSE_CTRL_1_V1 0x0034
#define B_BE_EF_DATA_MASK GENMASK(31, 0)

#define R_BE_GPIO_MUXCFG 0x0040
#define B_BE_WCPU_AUTO_EN BIT(26)
#define B_BE_WCPU_JTAG_EN BIT(24)
#define B_BE_WCPU_DBG_EN BIT(23)
#define B_BE_JTAG_CHAIN_EN BIT(20)
#define B_BE_BOOT_MODE BIT(19)
#define B_BE_WL_EECS_EXT_32K_SEL BIT(18)
#define B_BE_WL_SEC_BONDING_OPT_STS BIT(17)
#define B_BE_SECSIC_SEL BIT(16)
#define B_BE_ENHTP BIT(14)
#define B_BE_ENSIC BIT(12)
#define B_BE_SIC_SWRST BIT(11)
#define B_BE_PINMUX_PTA_EN BIT(10)
#define B_BE_WL_BT_PTA_SEC BIT(9)
#define B_BE_ENUARTTX BIT(8)
#define B_BE_DBG_GNT_BT_S1_POLARITY BIT(4)
#define B_BE_ENUARTRX BIT(2)

#define R_BE_GPIO_EXT_CTRL 0x0060
#define B_BE_GPIO_MOD_15_TO_8_MASK GENMASK(31, 24)
#define B_BE_GPIO_MOD_9 BIT(25)
#define B_BE_GPIO_IO_SEL_15_TO_8_MASK GENMASK(23, 16)
#define B_BE_GPIO_IO_SEL_9 BIT(17)
#define B_BE_GPIO_OUT_15_TO_8_MASK GENMASK(15, 8)
#define B_BE_GPIO_IN_15_TO_8_MASK GENMASK(7, 0)
#define B_BE_GPIO_IN_9 BIT(1)

#define R_BE_WL_BT_PWR_CTRL 0x0068
#define B_BE_ISO_BD2PP BIT(31)
#define B_BE_LDOV12B_EN BIT(30)
#define B_BE_CKEN_BT BIT(29)
#define B_BE_FEN_BT BIT(28)
#define B_BE_BTCPU_BOOTSEL BIT(27)
#define B_BE_SPI_SPEEDUP BIT(26)
#define B_BE_BT_LDO_MODE BIT(25)
#define B_BE_ISO_BTPON2PP BIT(22)
#define B_BE_BT_FUNC_EN BIT(18)
#define B_BE_BT_HWPDN_SL BIT(17)
#define B_BE_BT_DISN_EN BIT(16)
#define B_BE_SDM_SRC_SEL BIT(12)
#define B_BE_ISO_BA2PP BIT(11)
#define B_BE_BT_AFE_LDO_EN BIT(10)
#define B_BE_BT_AFE_PLL_EN BIT(9)
#define B_BE_WLAN_32K_SEL BIT(6)
#define B_BE_WL_DRV_EXIST_IDX BIT(5)
#define B_BE_DOP_EHPAD BIT(4)
#define B_BE_WL_FUNC_EN BIT(2)
#define B_BE_WL_HWPDN_SL BIT(1)
#define B_BE_WL_HWPDN_EN BIT(0)

#define R_BE_SYS_SDIO_CTRL 0x0070
#define B_BE_MCM_FLASH_EN BIT(28)
#define B_BE_SER_DETECT_EN BIT(26)
#define B_BE_PCIE_SEC_LOAD BIT(26)
#define B_BE_PCIE_SER_RSTB BIT(25)
#define B_BE_PCIE_SEC_LOAD_CLR BIT(24)
#define B_BE_SDIO_CMD_SW_RST BIT(20)
#define B_BE_SDIO_INT_POLARITY BIT(19)
#define B_BE_SDIO_OFF_EN BIT(17)
#define B_BE_SDIO_ON_EN BIT(16)
#define B_BE_PCIE_DIS_L2__CTRL_LDO_HCI BIT(15)
#define B_BE_PCIE_DIS_L2_RTK_PERST BIT(14)
#define B_BE_PCIE_FORCE_PWR_NGAT BIT(13)
#define B_BE_PCIE_FORCE_IBX_EN BIT(12)
#define B_BE_PCIE_AUXCLK_GATE BIT(11)
#define B_BE_PCIE_WAIT_TIMEOUT_EVENT BIT(10)
#define B_BE_PCIE_WAIT_TIME BIT(9)
#define B_BE_L1OFF_TO_L0_RESUME_EVT BIT(8)
#define B_BE_USBA_FORCE_PWR_NGAT BIT(7)
#define B_BE_USBD_FORCE_PWR_NGAT BIT(6)
#define B_BE_BT_CTRL_USB_PWR BIT(5)
#define B_BE_USB_D_STATE_HOLD BIT(4)
#define B_BE_R_BE_FORCE_DP BIT(3)
#define B_BE_R_BE_DP_MODE BIT(2)
#define B_BE_RES_USB_MASS_STORAGE_DESC BIT(1)
#define B_BE_USB_WAIT_TIME BIT(0)

#define R_BE_HCI_OPT_CTRL 0x0074
#define B_BE_HCI_WLAN_IO_ST BIT(31)
#define B_BE_HCI_WLAN_IO_EN BIT(28)
#define B_BE_HAXIDMA_IO_ST BIT(27)
#define B_BE_HAXIDMA_BACKUP_RESTORE_ST BIT(26)
#define B_BE_HAXIDMA_IO_EN BIT(24)
#define B_BE_EN_PCIE_WAKE BIT(23)
#define B_BE_SDIO_PAD_H3L1 BIT(22)
#define B_BE_USBMAC_ANACLK_SW BIT(21)
#define B_BE_PCIE_CPHY_CCK_XTAL_SEL BIT(20)
#define B_BE_SDIO_DATA_PAD_SMT BIT(19)
#define B_BE_SDIO_PAD_E5 BIT(18)
#define B_BE_FORCE_PCIE_AUXCLK BIT(17)
#define B_BE_HCI_LA_ADDR_MAP BIT(16)
#define B_BE_HCI_LA_GLO_RST BIT(15)
#define B_BE_USB3_SUS_DIS BIT(14)
#define B_BE_NOPWR_CTRL_SEL BIT(13)
#define B_BE_USB_HOST_PWR_OFF_EN BIT(12)
#define B_BE_SYM_LPS_BLOCK_EN BIT(11)
#define B_BE_USB_LPM_ACT_EN BIT(10)
#define B_BE_USB_LPM_NY BIT(9)
#define B_BE_USB2_SUS_DIS BIT(8)
#define B_BE_SDIO_PAD_E_MASK GENMASK(7, 5)
#define B_BE_USB_LPPLL_EN BIT(4)
#define B_BE_USB1_1_USB2_0_DECISION BIT(3)
#define B_BE_ROP_SW15 BIT(2)
#define B_BE_PCI_CKRDY_OPT BIT(1)
#define B_BE_PCI_VAUX_EN BIT(0)

#define R_BE_SYS_ISO_CTRL_EXTEND 0x0080
#define B_BE_R_SYM_ISO_DMEM62PP BIT(29)
#define B_BE_R_SYM_ISO_DMEM52PP BIT(28)
#define B_BE_R_SYM_ISO_DMEM42PP BIT(27)
#define B_BE_R_SYM_ISO_DMEM32PP BIT(26)
#define B_BE_R_SYM_ISO_DMEM22PP BIT(25)
#define B_BE_R_SYM_ISO_DMEM12PP BIT(24)
#define B_BE_R_SYM_ISO_IMEM42PP BIT(22)
#define B_BE_R_SYM_ISO_IMEM32PP BIT(21)
#define B_BE_R_SYM_ISO_IMEM22PP BIT(20)
#define B_BE_R_SYM_ISO_IMEM12PP BIT(19)
#define B_BE_R_SYM_ISO_IMEM02PP BIT(18)
#define B_BE_R_SYM_ISO_AON_OFF2PP BIT(15)
#define B_BE_R_SYM_PWC_HCILA BIT(13)
#define B_BE_R_SYM_PWC_PD12V BIT(12)
#define B_BE_R_SYM_PWC_UD12V BIT(11)
#define B_BE_R_SYM_PWC_BTBRG BIT(10)
#define B_BE_R_SYM_LDOBTSDIO_EN BIT(9)
#define B_BE_R_SYM_LDOSPDIO_EN BIT(8)
#define B_BE_R_SYM_ISO_HCILA BIT(4)
#define B_BE_R_SYM_ISO_BTBRG2PP BIT(2)
#define B_BE_R_SYM_ISO_BTSDIO2PP BIT(1)
#define B_BE_R_SYM_ISO_SPDIO2PP BIT(0)

#define R_BE_FEN_RST_ENABLE 0x0084
#define B_BE_R_SYM_FEN_WLMACOFF BIT(31)
#define B_BE_R_SYM_ISO_WA12PP BIT(28)
#define B_BE_R_SYM_ISO_CMAC12PP BIT(25)
#define B_BE_R_SYM_ISO_CMAC02PP BIT(24)
#define B_BE_R_SYM_ISO_ADDA_P32PP BIT(23)
#define B_BE_R_SYM_ISO_ADDA_P22PP BIT(22)
#define B_BE_R_SYM_ISO_ADDA_P12PP BIT(21)
#define B_BE_R_SYM_ISO_ADDA_P02PP BIT(20)
#define B_BE_CMAC1_FEN BIT(17)
#define B_BE_CMAC0_FEN BIT(16)
#define B_BE_SYM_ISO_BBPON12PP BIT(13)
#define B_BE_SYM_ISO_BB12PP BIT(12)
#define B_BE_BOOT_RDY1 BIT(10)
#define B_BE_FEN_BB1_IP_RSTN BIT(9)
#define B_BE_FEN_BB1PLAT_RSTB BIT(8)
#define B_BE_SYM_ISO_BBPON02PP BIT(5)
#define B_BE_SYM_ISO_BB02PP BIT(4)
#define B_BE_BOOT_RDY0 BIT(2)
#define B_BE_FEN_BB_IP_RSTN BIT(1)
#define B_BE_FEN_BBPLAT_RSTB BIT(0)

#define R_BE_PLATFORM_ENABLE 0x0088
#define B_BE_HOLD_AFTER_RESET BIT(11)
#define B_BE_SYM_WLPLT_MEM_MUX_EN BIT(10)
#define B_BE_WCPU_WARM_EN BIT(9)
#define B_BE_SPIC_EN BIT(8)
#define B_BE_UART_EN BIT(7)
#define B_BE_IDDMA_EN BIT(6)
#define B_BE_IPSEC_EN BIT(5)
#define B_BE_HIOE_EN BIT(4)
#define B_BE_APB_WRAP_EN BIT(2)
#define B_BE_WCPU_EN BIT(1)
#define B_BE_PLATFORM_EN BIT(0)

#define R_BE_WLLPS_CTRL 0x0090
#define B_BE_LPSOP_BBMEMDS BIT(30)
#define B_BE_LPSOP_BBOFF BIT(29)
#define B_BE_LPSOP_MACOFF BIT(28)
#define B_BE_LPSOP_OFF_CAPC_EN BIT(27)
#define B_BE_LPSOP_MEM_DS BIT(26)
#define B_BE_LPSOP_XTALM_LPS BIT(23)
#define B_BE_LPSOP_XTAL BIT(22)
#define B_BE_LPSOP_ACLK_DIV_2 BIT(21)
#define B_BE_LPSOP_ACLK_SEL BIT(20)
#define B_BE_LPSOP_ASWRM BIT(17)
#define B_BE_LPSOP_ASWR BIT(16)
#define B_BE_LPSOP_DSWR_ADJ_MASK GENMASK(15, 12)
#define B_BE_LPSOP_DSWRSD BIT(10)
#define B_BE_LPSOP_DSWRM BIT(9)
#define B_BE_LPSOP_DSWR BIT(8)
#define B_BE_LPSOP_OLD_ADJ_MASK GENMASK(7, 4)
#define B_BE_FORCE_LEAVE_LPS BIT(3)
#define B_BE_LPSOP_OLDSD BIT(2)
#define B_BE_DIS_WLBT_LPSEN_LOPC BIT(1)
#define B_BE_WL_LPS_EN BIT(0)

#define R_BE_WLRESUME_CTRL 0x0094
#define B_BE_LPSROP_DMEM5_RSU_EN BIT(31)
#define B_BE_LPSROP_DMEM4_RSU_EN BIT(30)
#define B_BE_LPSROP_DMEM3_RSU_EN BIT(29)
#define B_BE_LPSROP_DMEM2_RSU_EN BIT(28)
#define B_BE_LPSROP_DMEM1_RSU_EN BIT(27)
#define B_BE_LPSROP_DMEM0_RSU_EN BIT(26)
#define B_BE_LPSROP_IMEM5_RSU_EN BIT(25)
#define B_BE_LPSROP_IMEM4_RSU_EN BIT(24)
#define B_BE_LPSROP_IMEM3_RSU_EN BIT(23)
#define B_BE_LPSROP_IMEM2_RSU_EN BIT(22)
#define B_BE_LPSROP_IMEM1_RSU_EN BIT(21)
#define B_BE_LPSROP_IMEM0_RSU_EN BIT(20)
#define B_BE_LPSROP_BB1_W_BB0 BIT(14)
#define B_BE_LPSROP_CMAC1 BIT(13)
#define B_BE_LPSROP_CMAC0 BIT(12)
#define B_BE_LPSROP_XTALM BIT(11)
#define B_BE_LPSROP_PLLM BIT(10)
#define B_BE_LPSROP_HIOE BIT(9)
#define B_BE_LPSROP_CPU BIT(8)
#define B_BE_LPSROP_LOWPWRPLL BIT(7)
#define B_BE_LPSROP_DSWRSD_SEL_MASK GENMASK(5, 4)

#define R_BE_SYSON_FSM_MON 0x00A0
#define B_BE_FSM_MON_SEL_MASK GENMASK(26, 24)
#define B_BE_DOP_ELDO BIT(23)
#define B_BE_AFE_PLL_BYPASS BIT(22)
#define B_BE_PON_SWR_BYPASS BIT(21)
#define B_BE_PON_ADIE_BYPASS BIT(20)
#define B_BE_AFE_LS_BYPASS BIT(19)
#define B_BE_BTPMC_XTAL_SI_BYPASS BIT(17)
#define B_BE_WLPMC_XTAL_SI_BYPASS BIT(16)
#define B_BE_FSM_MON_UPD BIT(15)
#define B_BE_FSM_PAR_MASK GENMASK(14, 0)
#define WLAN_FSM_MASK 0xFFFFFF
#define WLAN_FSM_SET 0x4000000
#define WLAN_FSM_STATE_MASK 0x1FF
#define WLAN_FSM_IDLE 0

#define R_BE_EFUSE_CTRL_2_V1 0x00A4
#define B_BE_EF_ENT BIT(31)
#define B_BE_EF_TCOLUMN_EN BIT(29)
#define B_BE_BT_OTP_PWC_DIS BIT(28)
#define B_BE_EF_RDT BIT(27)
#define B_BE_R_SYM_AUTOLOAD_WITH_PMC_SEL BIT(24)
#define B_BE_EF_PGTS_MASK GENMASK(23, 20)
#define B_BE_EF_BURST BIT(19)
#define B_BE_EF_TEST_SEL_MASK GENMASK(18, 16)
#define B_BE_EF_TROW_EN BIT(15)
#define B_BE_EF_ERR_FLAG BIT(14)
#define B_BE_EF_FBURST_DIS BIT(13)
#define B_BE_EF_HT_SEL BIT(12)
#define B_BE_EF_DSB_EN BIT(11)
#define B_BE_EF_DLY_SEL_MASK GENMASK(3, 0)

#define R_BE_PAD_CTRL2 0x00C4
#define B_BE_USB23_SW_MODE BIT(31)
#define B_BE_USB3_GEN_MODE BIT(30)
#define B_BE_USB3_LANE_MODE BIT(29)
#define B_BE_USB_AUTO_INSTALL_MASK BIT(28)
#define B_BE_FORCE_CLK_U2 BIT(25)
#define B_BE_FORCE_U2_CK BIT(24)
#define B_BE_FORCE_U3_CK BIT(23)
#define B_BE_USB2_FORCE BIT(22)
#define B_BE_USB3_FORCE BIT(21)
#define B_BE_NO_PDN_CHIPOFF_V1 BIT(17)
#define B_BE_RSM_EN_V1 BIT(16)
#define B_BE_MATCH_CNT GENMASK(15, 8)

#define R_BE_SCOREBOARD 0x00AC
#define B_BE_TOGGLE BIT(31)
#define B_BE_DATA_LINE_MASK GENMASK(30, 0)

#define R_BE_PMC_DBG_CTRL2 0x00CC
#define B_BE_EFUSE_BURN_GNT_MASK GENMASK(31, 24)
#define B_BE_DIS_IOWRAP_TIMEOUT BIT(16)
#define B_BE_STOP_WL_PMC BIT(9)
#define B_BE_STOP_SYM_PMC BIT(8)
#define B_BE_SYM_REG_PCIE_WRMSK BIT(7)
#define B_BE_BT_ACCESS_WL_PAGE0 BIT(6)
#define B_BE_R_BE_RST_WLPMC BIT(5)
#define B_BE_R_BE_RST_PD12N BIT(4)
#define B_BE_SYSON_DIS_WLR_BE_WRMSK BIT(3)
#define B_BE_SYSON_DIS_PMCR_BE_WRMSK BIT(2)
#define B_BE_SYSON_R_BE_ARB_MASK GENMASK(1, 0)

#define R_BE_MEM_PWR_CTRL 0x00D0
#define B_BE_DMEM5_WLMCU_DS BIT(31)
#define B_BE_DMEM4_WLMCU_DS BIT(30)
#define B_BE_DMEM3_WLMCU_DS BIT(29)
#define B_BE_DMEM2_WLMCU_DS BIT(28)
#define B_BE_DMEM1_WLMCU_DS BIT(27)
#define B_BE_DMEM0_WLMCU_DS BIT(26)
#define B_BE_IMEM5_WLMCU_DS BIT(25)
#define B_BE_IMEM4_WLMCU_DS BIT(24)
#define B_BE_IMEM3_WLMCU_DS BIT(23)
#define B_BE_IMEM2_WLMCU_DS BIT(22)
#define B_BE_IMEM1_WLMCU_DS BIT(21)
#define B_BE_IMEM0_WLMCU_DS BIT(20)
#define B_BE_MEM_BBMCU1_DS BIT(19)
#define B_BE_MEM_BBMCU0_DS_V1 BIT(17)
#define B_BE_MEM_BT_DS BIT(10)
#define B_BE_MEM_SDIO_LS BIT(9)
#define B_BE_MEM_SDIO_DS BIT(8)
#define B_BE_MEM_USB_LS BIT(7)
#define B_BE_MEM_USB_DS BIT(6)
#define B_BE_MEM_PCI_LS BIT(5)
#define B_BE_MEM_PCI_DS BIT(4)
#define B_BE_MEM_WLMAC_LS BIT(3)

#define R_BE_PCIE_MIO_INTF 0x00E4
#define B_BE_AON_MIO_EPHY_1K_SEL_MASK GENMASK(29, 24)
#define B_BE_PCIE_MIO_ADDR_PAGE_V1_MASK GENMASK(20, 16)
#define B_BE_PCIE_MIO_ASIF BIT(15)
#define B_BE_PCIE_MIO_BYIOREG BIT(13)
#define B_BE_PCIE_MIO_RE BIT(12)
#define B_BE_PCIE_MIO_WE_MASK GENMASK(11, 8)
#define B_BE_PCIE_MIO_ADDR_MASK GENMASK(7, 0)

#define R_BE_PCIE_MIO_INTD 0x00E8
#define B_BE_PCIE_MIO_DATA_MASK GENMASK(31, 0)

#define R_BE_SYS_CHIPINFO 0x00FC
#define B_BE_USB2_SEL BIT(31)
#define B_BE_U3PHY_RST_V1 BIT(30)
#define B_BE_U3_TERM_DETECT BIT(29)
#define B_BE_VERIFY_ENV_MASK GENMASK(9, 8)
#define B_BE_HW_ID_MASK GENMASK(7, 0)

#define R_BE_HALT_H2C_CTRL 0x0160
#define B_BE_HALT_H2C_TRIGGER BIT(0)

#define R_BE_HALT_C2H_CTRL 0x0164
#define B_BE_HALT_C2H_TRIGGER BIT(0)

#define R_BE_HALT_H2C 0x0168
#define B_BE_HALT_H2C_MASK GENMASK(31, 0)

#define R_BE_HALT_C2H 0x016C
#define B_BE_HALT_C2H_ERROR_SENARIO_MASK GENMASK(31, 28)
#define B_BE_ERROR_CODE_MASK GENMASK(15, 0)

#define R_BE_SYS_CFG5 0x0170
#define B_BE_WDT_DATACPU_WAKE_PCIE_EN BIT(12)
#define B_BE_WDT_DATACPU_WAKE_USB_EN BIT(11)
#define B_BE_WDT_WAKE_PCIE_EN BIT(10)
#define B_BE_WDT_WAKE_USB_EN BIT(9)
#define B_BE_SYM_DIS_HC_ACCESS_MAC BIT(8)
#define B_BE_LPS_STATUS BIT(3)
#define B_BE_HCI_TXDMA_BUSY BIT(2)

#define R_BE_SECURE_BOOT_MALLOC_INFO 0x0184

#define R_BE_FWS0IMR 0x0190
#define B_BE_FS_HALT_H2C_INT_EN BIT(31)
#define B_BE_FS_FSM_HIOE_TO_EVENT_INT_EN BIT(30)
#define B_BE_FS_HCI_SUS_INT_EN BIT(29)
#define B_BE_FS_HCI_RES_INT_EN BIT(28)
#define B_BE_FS_HCI_RESET_INT_EN BIT(27)
#define B_BE_FS_BT_SB1_INT_EN BIT(26)
#define B_BE_FS_ACT2RECOVERY_INT_EN BIT(25)
#define B_BE_FS_GEN1GEN2_SWITCH_INT_EN BIT(24)
#define B_BE_FS_USB_LPMRSM_INT_EN BIT(22)
#define B_BE_FS_USB_LPMINT_INT_EN BIT(21)
#define B_BE_FS_PWMERR_INT_EN BIT(20)
#define B_BE_FS_PDNINT_EN BIT(19)
#define B_BE_FS_SPSA_OCP_INT_EN BIT(18)
#define B_BE_FS_SPSD_OCP_INT_EN BIT(17)
#define B_BE_FS_BT_SB0_INT_EN BIT(16)
#define B_BE_FS_GPIOF_INT_EN BIT(15)
#define B_BE_FS_GPIOE_INT_EN BIT(14)
#define B_BE_FS_GPIOD_INT_EN BIT(13)
#define B_BE_FS_GPIOC_INT_EN BIT(12)
#define B_BE_FS_GPIOB_INT_EN BIT(11)
#define B_BE_FS_GPIOA_INT_EN BIT(10)
#define B_BE_FS_GPIO9_INT_EN BIT(9)
#define B_BE_FS_GPIO8_INT_EN BIT(8)
#define B_BE_FS_GPIO7_INT_EN BIT(7)
#define B_BE_FS_GPIO6_INT_EN BIT(6)
#define B_BE_FS_GPIO5_INT_EN BIT(5)
#define B_BE_FS_GPIO4_INT_EN BIT(4)
#define B_BE_FS_GPIO3_INT_EN BIT(3)
#define B_BE_FS_GPIO2_INT_EN BIT(2)
#define B_BE_FS_GPIO1_INT_EN BIT(1)
#define B_BE_FS_GPIO0_INT_EN BIT(0)

#define R_BE_FWS0ISR 0x0194
#define B_BE_FS_HALT_H2C_INT BIT(31)
#define B_BE_FS_FSM_HIOE_TO_EVENT_INT BIT(30)
#define B_BE_FS_HCI_SUS_INT BIT(29)
#define B_BE_FS_HCI_RES_INT BIT(28)
#define B_BE_FS_HCI_RESET_INT BIT(27)
#define B_BE_FS_BT_SB1_INT BIT(26)
#define B_BE_FS_ACT2RECOVERY_INT BIT(25)
#define B_BE_FS_GEN1GEN2_SWITCH_INT BIT(24)
#define B_BE_FS_USB_LPMRSM_INT BIT(22)
#define B_BE_FS_USB_LPMINT_INT BIT(21)
#define B_BE_FS_PWMERR_INT BIT(20)
#define B_BE_FS_PDNINT BIT(19)
#define B_BE_FS_SPSA_OCP_INT BIT(18)
#define B_BE_FS_SPSD_OCP_INT BIT(17)
#define B_BE_FS_BT_SB0_INT BIT(16)
#define B_BE_FS_GPIOF_INT BIT(15)
#define B_BE_FS_GPIOE_INT BIT(14)
#define B_BE_FS_GPIOD_INT BIT(13)
#define B_BE_FS_GPIOC_INT BIT(12)
#define B_BE_FS_GPIOB_INT BIT(11)
#define B_BE_FS_GPIOA_INT BIT(10)
#define B_BE_FS_GPIO9_INT BIT(9)
#define B_BE_FS_GPIO8_INT BIT(8)
#define B_BE_FS_GPIO7_INT BIT(7)
#define B_BE_FS_GPIO6_INT BIT(6)
#define B_BE_FS_GPIO5_INT BIT(5)
#define B_BE_FS_GPIO4_INT BIT(4)
#define B_BE_FS_GPIO3_INT BIT(3)
#define B_BE_FS_GPIO2_INT BIT(2)
#define B_BE_FS_GPIO1_INT BIT(1)
#define B_BE_FS_GPIO0_INT BIT(0)

#define R_BE_FWS1IMR 0x0198
#define B_BE_FS_RPWM_INT_EN_V1 BIT(24)
#define B_BE_PCIE_HOTRST_EN BIT(22)
#define B_BE_PCIE_SER_TIMEOUT_INDIC_EN BIT(21)
#define B_BE_PCIE_RXI300_SLVTOUT_INDIC_EN BIT(20)
#define B_BE_AON_PCIE_FLR_INT_EN BIT(19)
#define B_BE_PCIE_ERR_INDIC_INT_EN BIT(18)
#define B_BE_SDIO_ERR_INDIC_INT_EN BIT(17)
#define B_BE_USB_ERR_INDIC_INT_EN BIT(16)
#define B_BE_FS_GPIO27_INT_EN BIT(11)
#define B_BE_FS_GPIO26_INT_EN BIT(10)
#define B_BE_FS_GPIO25_INT_EN BIT(9)
#define B_BE_FS_GPIO24_INT_EN BIT(8)
#define B_BE_FS_GPIO23_INT_EN BIT(7)
#define B_BE_FS_GPIO22_INT_EN BIT(6)
#define B_BE_FS_GPIO21_INT_EN BIT(5)
#define B_BE_FS_GPIO20_INT_EN BIT(4)
#define B_BE_FS_GPIO19_INT_EN BIT(3)
#define B_BE_FS_GPIO18_INT_EN BIT(2)
#define B_BE_FS_GPIO17_INT_EN BIT(1)
#define B_BE_FS_GPIO16_INT_EN BIT(0)

#define R_BE_HIMR0 0x01A0
#define B_BE_WDT_DATACPU_TIMEOUT_INT_EN BIT(25)
#define B_BE_HALT_D2H_INT_EN BIT(24)
#define B_BE_WDT_TIMEOUT_INT_EN BIT(22)
#define B_BE_HALT_C2H_INT_EN BIT(21)
#define B_BE_RON_INT_EN BIT(20)
#define B_BE_PDNINT_EN BIT(19)
#define B_BE_SPSANA_OCP_INT_EN BIT(18)
#define B_BE_SPS_OCP_INT_EN BIT(17)
#define B_BE_BTON_STS_UPDATE_INT_EN BIT(16)
#define B_BE_GPIOF_INT_EN BIT(15)
#define B_BE_GPIOE_INT_EN BIT(14)
#define B_BE_GPIOD_INT_EN BIT(13)
#define B_BE_GPIOC_INT_EN BIT(12)
#define B_BE_GPIOB_INT_EN BIT(11)
#define B_BE_GPIOA_INT_EN BIT(10)
#define B_BE_GPIO9_INT_EN BIT(9)
#define B_BE_GPIO8_INT_EN BIT(8)
#define B_BE_GPIO7_INT_EN BIT(7)
#define B_BE_GPIO6_INT_EN BIT(6)
#define B_BE_GPIO5_INT_EN BIT(5)
#define B_BE_GPIO4_INT_EN BIT(4)
#define B_BE_GPIO3_INT_EN BIT(3)
#define B_BE_GPIO2_INT_EN BIT(2)
#define B_BE_GPIO1_INT_EN BIT(1)
#define B_BE_GPIO0_INT_EN BIT(0)

#define R_BE_HISR0 0x01A4
#define B_BE_WDT_DATACPU_TIMEOUT_INT BIT(25)
#define B_BE_HALT_D2H_INT BIT(24)
#define B_BE_WDT_TIMEOUT_INT BIT(22)
#define B_BE_HALT_C2H_INT BIT(21)
#define B_BE_RON_INT BIT(20)
#define B_BE_PDNINT BIT(19)
#define B_BE_SPSANA_OCP_INT BIT(18)
#define B_BE_SPS_OCP_INT BIT(17)
#define B_BE_BTON_STS_UPDATE_INT BIT(16)
#define B_BE_GPIOF_INT BIT(15)
#define B_BE_GPIOE_INT BIT(14)
#define B_BE_GPIOD_INT BIT(13)
#define B_BE_GPIOC_INT BIT(12)
#define B_BE_GPIOB_INT BIT(11)
#define B_BE_GPIOA_INT BIT(10)
#define B_BE_GPIO9_INT BIT(9)
#define B_BE_GPIO8_INT BIT(8)
#define B_BE_GPIO7_INT BIT(7)
#define B_BE_GPIO6_INT BIT(6)
#define B_BE_GPIO5_INT BIT(5)
#define B_BE_GPIO4_INT BIT(4)
#define B_BE_GPIO3_INT BIT(3)
#define B_BE_GPIO2_INT BIT(2)
#define B_BE_GPIO1_INT BIT(1)
#define B_BE_GPIO0_INT BIT(0)

#define R_BE_WCPU_FW_CTRL 0x01E0
#define B_BE_RUN_ENV_MASK GENMASK(31, 30)
#define B_BE_WCPU_FWDL_STATUS_MASK GENMASK(29, 26)
#define B_BE_WDT_PLT_RST_EN BIT(17)
#define B_BE_HOST_EXIST BIT(16)
#define B_BE_FW_SEC_AUTH_DONE BIT(14)
#define B_BE_FW_CPU_UTIL_STS_EN BIT(13)
#define B_BE_BBMCU1_FWDL_EN BIT(12)
#define B_BE_BBMCU0_FWDL_EN BIT(11)
#define B_BE_DATACPU_FWDL_EN BIT(10)
#define B_BE_WLANCPU_FWDL_EN BIT(9)
#define B_BE_WCPU_ROM_CUT_GET BIT(8)
#define B_BE_WCPU_ROM_CUT_VAL_MASK GENMASK(7, 4)
#define B_BE_FW_BOOT_MODE_MASK GENMASK(3, 2)
#define B_BE_H2C_PATH_RDY BIT(1)
#define B_BE_DLFW_PATH_RDY BIT(0)

#define R_BE_BOOT_REASON 0x01E6
#define B_BE_BOOT_REASON_MASK GENMASK(2, 0)

#define R_BE_LDM 0x01E8
#define B_BE_EN_32K BIT(31)
#define B_BE_LDM_MASK GENMASK(30, 0)

#define R_BE_UDM0 0x01F0
#define B_BE_UDM0_SEND2RA_CNT_MASK GENMASK(31, 28)
#define B_BE_UDM0_TX_RPT_CNT_MASK GENMASK(27, 24)
#define B_BE_UDM0_FS_CODE_MASK GENMASK(23, 8)
#define B_BE_NULL_POINTER_INDC BIT(7)
#define B_BE_ROM_ASSERT_INDC BIT(6)
#define B_BE_RAM_ASSERT_INDC BIT(5)
#define B_BE_FW_IMAGE_TYPE BIT(4)
#define B_BE_UDM0_TRAP_LOOP_CTRL BIT(2)
#define B_BE_UDM0_SEND_HALTC2H_CTRL BIT(1)
#define B_BE_UDM0_DBG_MODE_CTRL BIT(0)

#define R_BE_UDM1 0x01F4
#define B_BE_UDM1_ERROR_ADDR_MASK GENMASK(31, 16)
#define B_BE_UDM1_HALMAC_C2H_ENQ_CNT_MASK GENMASK(15, 12)
#define B_BE_UDM1_HALMAC_H2C_DEQ_CNT_MASK GENMASK(11, 8)
#define B_BE_UDM1_WCPU_C2H_ENQ_CNT_MASK GENMASK(7, 4)
#define B_BE_UDM1_WCPU_H2C_DEQ_CNT_MASK GENMASK(3, 0)

#define R_BE_UDM2 0x01F8
#define B_BE_UDM2_EPC_RA_MASK GENMASK(31, 0)

#define R_BE_AFE_ON_CTRL0 0x0240
#define B_BE_REG_LPF_R3_3_0_MASK GENMASK(31, 29)
#define B_BE_REG_LPF_R2_MASK GENMASK(28, 24)
#define B_BE_REG_LPF_C3_MASK GENMASK(23, 21)
#define B_BE_REG_LPF_C2_MASK GENMASK(20, 18)
#define B_BE_REG_LPF_C1_MASK GENMASK(17, 15)
#define B_BE_REG_CP_ICPX2 BIT(14)
#define B_BE_REG_CP_ICP_SEL_FAST_MASK GENMASK(13, 10)
#define B_BE_REG_CP_ICP_SEL_MASK GENMASK(9, 6)
#define B_BE_REG_IB_PI_MASK GENMASK(5, 4)
#define B_BE_REG_CK_DEBUG_BT BIT(3)
#define B_BE_EN_PC_LDO BIT(2)
#define B_BE_LDO_VSEL_MASK GENMASK(1, 0)

#define R_BE_AFE_ON_CTRL1 0x0244
#define B_BE_REG_CK_MON_SEL_MASK GENMASK(31, 29)
#define B_BE_REG_CK_MON_CK960M_EN BIT(28)
#define B_BE_REG_XTAL_FREQ_SEL BIT(27)
#define B_BE_REG_XTAL_EDGE_SEL BIT(26)
#define B_BE_REG_VCO_KVCO BIT(25)
#define B_BE_REG_SDM_EDGE_SEL BIT(24)
#define B_BE_REG_SDM_CK_SEL BIT(23)
#define B_BE_REG_SDM_CK_GATED BIT(22)
#define B_BE_REG_PFD_RESET_GATED BIT(21)
#define B_BE_REG_LPF_R3_FAST_MASK GENMASK(20, 16)
#define B_BE_REG_LPF_R2_FAST_MASK GENMASK(15, 11)
#define B_BE_REG_LPF_C3_FAST_MASK GENMASK(10, 8)
#define B_BE_REG_LPF_C2_FAST_MASK GENMASK(7, 5)
#define B_BE_REG_LPF_C1_FAST_MASK GENMASK(4, 2)
#define B_BE_REG_LPF_R3_4_MASK GENMASK(1, 0)

#define R_BE_AFE_ON_CTRL3 0x024C
#define B_BE_LDO_VSEL_DA_1_MASK GENMASK(31, 30)
#define B_BE_LDO_VSEL_DA_0_MASK GENMASK(29, 28)
#define B_BE_LDO_VSEL_D2S_1_MASK GENMASK(27, 26)
#define B_BE_LDO_VSEL_D2S_0_MASK GENMASK(25, 24)
#define B_BE_LDO_VSEL_BUF_MASK GENMASK(23, 22)
#define B_BE_REG_R2_L_MASK GENMASK(21, 19)
#define B_BE_REG_R1_L_MASK GENMASK(18, 16)
#define B_BE_REG_CK_DEBUG_BT_MON BIT(15)
#define B_BE_REG_BT_CLK_BUF_POWER BIT(14)
#define B_BE_REG_BG_OUT_BTADC_V1 BIT(13)
#define B_BE_REG_SEL_V18 BIT(11)
#define B_BE_REG_FRAC_EN BIT(10)
#define B_BE_REG_CK1920M_EN BIT(9)
#define B_BE_REG_CK1280M_EN BIT(8)
#define B_BE_REG_12LDO_SEL_MASK GENMASK(7, 6)
#define B_BE_REG_09LDO_SEL_MASK GENMASK(5, 4)
#define B_BE_REG_VC_TH BIT(3)
#define B_BE_REG_VC_TL BIT(2)
#define B_BE_REG_CK40M_EN BIT(1)
#define B_BE_REG_CK640M_EN BIT(0)

#define R_BE_GPIO8_15_FUNC_SEL 0x02D4
#define B_BE_PINMUX_GPIO9_FUNC_SEL_MASK GENMASK(7, 4)

#define R_BE_WLAN_XTAL_SI_CTRL 0x0270
#define B_BE_WL_XTAL_SI_CMD_POLL BIT(31)
#define B_BE_WL_XTAL_SI_CHIPID_MASK GENMASK(30, 28)
#define B_BE_WL_XTAL_SI_MODE_MASK GENMASK(25, 24)
#define B_BE_WL_XTAL_SI_BITMASK_MASK GENMASK(23, 16)
#define B_BE_WL_XTAL_SI_DATA_MASK GENMASK(15, 8)
#define B_BE_WL_XTAL_SI_ADDR_MASK GENMASK(7, 0)

#define R_BE_PCIE_SER_DBG 0x02FC
#define B_BE_PCIE_SER_DBG_MASK GENMASK(31, 10)
#define B_BE_PCIE_SER_PHY_PROTECT BIT(9)
#define B_BE_PCIE_SER_MAC_PROTECT BIT(8)
#define B_BE_PCIE_SER_FLUSH_RSTB BIT(4)
#define B_BE_PCIE_AXI_BRG_FLUSH_EN BIT(3)
#define B_BE_PCIE_SER_AUXCLK_RDY BIT(2)
#define B_BE_PCIE_SER_FRZ_REG_RST BIT(1)
#define B_BE_PCIE_SER_FRZ_CFG_SPC_RST BIT(0)

#define R_BE_IC_PWR_STATE 0x03F0
#define B_BE_WHOLE_SYS_PWR_STE_MASK GENMASK(25, 16)
#define MAC_AX_SYS_ACT 0x220
#define B_BE_WLMAC_PWR_STE_MASK GENMASK(9, 8)
#define B_BE_UART_HCISYS_PWR_STE_MASK GENMASK(7, 6)
#define B_BE_SDIO_HCISYS_PWR_STE_MASK GENMASK(5, 4)
#define B_BE_USB_HCISYS_PWR_STE_MASK GENMASK(3, 2)
#define B_BE_PCIE_HCISYS_PWR_STE_MASK GENMASK(1, 0)

#define R_BE_WLCPU_PORT_PC 0x03FC

#define R_BE_DBG_WOW 0x0504

#define R_BE_DCPU_PLATFORM_ENABLE 0x0888
#define B_BE_DCPU_SYM_DPLT_MEM_MUX_EN BIT(10)
#define B_BE_DCPU_WARM_EN BIT(9)
#define B_BE_DCPU_UART_EN BIT(7)
#define B_BE_DCPU_IDDMA_EN BIT(6)
#define B_BE_DCPU_APB_WRAP_EN BIT(2)
#define B_BE_DCPU_EN BIT(1)
#define B_BE_DCPU_PLATFORM_EN BIT(0)

#define R_BE_PL_AXIDMA_IDCT_MSK 0x0910
#define B_BE_PL_AXIDMA_RRESP_ERR_MASK BIT(6)
#define B_BE_PL_AXIDMA_BRESP_ERR_MASK BIT(5)
#define B_BE_PL_AXIDMA_FC_ERR_MASK BIT(4)
#define B_BE_PL_AXIDMA_TXBD_LEN0_MASK BIT(3)
#define B_BE_PL_AXIDMA_TXBD_4KBOUD_LENERR_MASK BIT(2)
#define B_BE_PL_AXIDMA_TXBD_RX_STUCK_MASK BIT(1)
#define B_BE_PL_AXIDMA_TXBD_TX_STUCK_MASK BIT(0)
#define B_BE_PL_AXIDMA_IDCT_MSK_CLR (B_BE_PL_AXIDMA_TXBD_TX_STUCK_MASK | \
				     B_BE_PL_AXIDMA_TXBD_RX_STUCK_MASK | \
				     B_BE_PL_AXIDMA_TXBD_LEN0_MASK | \
				     B_BE_PL_AXIDMA_FC_ERR_MASK | \
				     B_BE_PL_AXIDMA_BRESP_ERR_MASK | \
				     B_BE_PL_AXIDMA_RRESP_ERR_MASK)
#define B_BE_PL_AXIDMA_IDCT_MSK_SET (B_BE_PL_AXIDMA_TXBD_TX_STUCK_MASK | \
				     B_BE_PL_AXIDMA_TXBD_RX_STUCK_MASK | \
				     B_BE_PL_AXIDMA_TXBD_LEN0_MASK | \
				     B_BE_PL_AXIDMA_FC_ERR_MASK)

#define R_BE_PL_AXIDMA_IDCT 0x0914
#define B_BE_PL_AXIDMA_RRESP_ERR BIT(6)
#define B_BE_PL_AXIDMA_BRESP_ERR BIT(5)
#define B_BE_PL_AXIDMA_FC_ERR BIT(4)
#define B_BE_PL_AXIDMA_TXBD_LEN0 BIT(3)
#define B_BE_PL_AXIDMA_TXBD_4KBOUD_LENERR BIT(2)
#define B_BE_PL_AXIDMA_TXBD_RX_STUCK BIT(1)
#define B_BE_PL_AXIDMA_TXBD_TX_STUCK BIT(0)

#define R_BE_FILTER_MODEL_ADDR 0x0C04

#define R_BE_WLAN_WDT 0x3050
#define B_BE_WLAN_WDT_TIMEOUT BIT(31)
#define B_BE_WLAN_WDT_TIMER_CLEAR BIT(4)
#define B_BE_WLAN_WDT_BYPASS BIT(1)
#define B_BE_WLAN_WDT_ENABLE BIT(0)

#define R_BE_AXIDMA_WDT 0x305C
#define B_BE_AXIDMA_WDT_TIMEOUT BIT(31)
#define B_BE_AXIDMA_WDT_TIMER_CLEAR BIT(4)
#define B_BE_AXIDMA_WDT_BYPASS BIT(1)
#define B_BE_AXIDMA_WDT_ENABLE BIT(0)

#define R_BE_AON_WDT 0x3068
#define B_BE_AON_WDT_TIMEOUT BIT(31)
#define B_BE_AON_WDT_TIMER_CLEAR BIT(4)
#define B_BE_AON_WDT_BYPASS BIT(1)
#define B_BE_AON_WDT_ENABLE BIT(0)

#define R_BE_AON_WDT_TMR 0x306C
#define R_BE_MDIO_WDT_TMR 0x3090
#define R_BE_LA_MODE_WDT_TMR 0x309C
#define R_BE_WDT_AR_TMR 0x3144
#define R_BE_WDT_AW_TMR 0x3150
#define R_BE_WLAN_WDT_TMR 0x3054
#define R_BE_WDT_W_TMR 0x315C
#define R_BE_AXIDMA_WDT_TMR 0x3060
#define R_BE_WDT_B_TMR 0x3164
#define R_BE_WDT_R_TMR 0x316C
#define R_BE_LOCAL_WDT_TMR 0x3084

#define R_BE_LOCAL_WDT 0x3080
#define B_BE_LOCAL_WDT_TIMEOUT BIT(31)
#define B_BE_LOCAL_WDT_TIMER_CLEAR BIT(4)
#define B_BE_LOCAL_WDT_BYPASS BIT(1)
#define B_BE_LOCAL_WDT_ENABLE BIT(0)

#define R_BE_MDIO_WDT 0x308C
#define B_BE_MDIO_WDT_TIMEOUT BIT(31)
#define B_BE_MDIO_WDT_TIMER_CLEAR BIT(4)
#define B_BE_MDIO_WDT_BYPASS BIT(1)
#define B_BE_MDIO_WDT_ENABLE BIT(0)

#define R_BE_LA_MODE_WDT 0x3098
#define B_BE_LA_MODE_WDT_TIMEOUT BIT(31)
#define B_BE_LA_MODE_WDT_TIMER_CLEAR BIT(4)
#define B_BE_LA_MODE_WDT_BYPASS BIT(1)
#define B_BE_LA_MODE_WDT_ENABLE BIT(0)

#define R_BE_WDT_AR 0x3140
#define B_BE_WDT_AR_TIMEOUT BIT(31)
#define B_BE_WDT_AR_TIMER_CLEAR BIT(4)
#define B_BE_WDT_AR_BYPASS BIT(1)
#define B_BE_WDT_AR_ENABLE BIT(0)

#define R_BE_WDT_AW 0x314C
#define B_BE_WDT_AW_TIMEOUT BIT(31)
#define B_BE_WDT_AW_TIMER_CLEAR BIT(4)
#define B_BE_WDT_AW_BYPASS BIT(1)
#define B_BE_WDT_AW_ENABLE BIT(0)

#define R_BE_WDT_W 0x3158
#define B_BE_WDT_W_TIMEOUT BIT(31)
#define B_BE_WDT_W_TIMER_CLEAR BIT(4)
#define B_BE_WDT_W_BYPASS BIT(1)
#define B_BE_WDT_W_ENABLE BIT(0)

#define R_BE_WDT_B 0x3160
#define B_BE_WDT_B_TIMEOUT BIT(31)
#define B_BE_WDT_B_TIMER_CLEAR BIT(4)
#define B_BE_WDT_B_BYPASS BIT(1)
#define B_BE_WDT_B_ENABLE BIT(0)

#define R_BE_WDT_R 0x3168
#define B_BE_WDT_R_TIMEOUT BIT(31)
#define B_BE_WDT_R_TIMER_CLEAR BIT(4)
#define B_BE_WDT_R_BYPASS BIT(1)
#define B_BE_WDT_R_ENABLE BIT(0)

#define R_BE_LTR_DECISION_CTRL_V1 0x3610
#define B_BE_ENABLE_LTR_CTL_DECISION BIT(31)
#define B_BE_LAT_LTR_IDX_DRV_VLD_V1 BIT(24)
#define B_BE_LAT_LTR_IDX_DRV_V1_MASK GENMASK(23, 22)
#define B_BE_LAT_LTR_IDX_FW_VLD_V1 BIT(21)
#define B_BE_LAT_LTR_IDX_FW_V1_MASK GENMASK(20, 19)
#define B_BE_LAT_LTR_IDX_HW_VLD_V1 BIT(18)
#define B_BE_LAT_LTR_IDX_HW_V1_MASK GENMASK(17, 16)
#define B_BE_LTR_IDX_DRV_V1_MASK GENMASK(15, 14)
#define B_BE_LTR_REQ_DRV_V1 BIT(13)
#define B_BE_LTR_IDX_DISABLE_V1_MASK GENMASK(9, 8)
#define B_BE_LTR_EN_PORT_V1_MASK GENMASK(6, 4)
#define B_BE_LTR_DRV_DEC_EN_V1 BIT(6)
#define B_BE_LTR_FW_DEC_EN_V1 BIT(5)
#define B_BE_LTR_HW_DEC_EN_V1 BIT(4)
#define B_BE_LTR_SPACE_IDX_MASK GENMASK(1, 0)

#define R_BE_LTR_LATENCY_IDX0_V1 0x3614
#define R_BE_LTR_LATENCY_IDX1_V1 0x3618
#define R_BE_LTR_LATENCY_IDX2_V1 0x361C
#define R_BE_LTR_LATENCY_IDX3_V1 0x3620

#define R_BE_HCI_BUF_IMR 0x6018
#define B_BE_HCI_BUF_IMR_CLR 0xC0000303
#define B_BE_HCI_BUF_IMR_SET 0xC0000301

#define R_BE_H2CREG_DATA0 0x7140
#define R_BE_H2CREG_DATA1 0x7144
#define R_BE_H2CREG_DATA2 0x7148
#define R_BE_H2CREG_DATA3 0x714C
#define R_BE_C2HREG_DATA0 0x7150
#define R_BE_C2HREG_DATA1 0x7154
#define R_BE_C2HREG_DATA2 0x7158
#define R_BE_C2HREG_DATA3 0x715C
#define R_BE_H2CREG_CTRL 0x7160
#define B_BE_H2CREG_TRIGGER BIT(0)
#define R_BE_C2HREG_CTRL 0x7164
#define B_BE_C2HREG_TRIGGER BIT(0)

#define R_BE_HCI_FUNC_EN 0x7880
#define B_BE_HCI_CR_PROTECT BIT(31)
#define B_BE_HCI_TRXBUF_EN BIT(2)
#define B_BE_HCI_RXDMA_EN BIT(1)
#define B_BE_HCI_TXDMA_EN BIT(0)

#define R_BE_BOOT_DBG 0x78F0
#define B_BE_BOOT_STATUS_MASK GENMASK(31, 16)
#define B_BE_SECUREBOOT_STATUS_MASK GENMASK(15, 0)

#define R_BE_DBG_WOW_READY 0x815E
#define B_BE_DBG_WOW_READY GENMASK(7, 0)

#define R_BE_DMAC_FUNC_EN 0x8400
#define B_BE_DMAC_CRPRT BIT(31)
#define B_BE_MAC_FUNC_EN BIT(30)
#define B_BE_DMAC_FUNC_EN BIT(29)
#define B_BE_MPDU_PROC_EN BIT(28)
#define B_BE_WD_RLS_EN BIT(27)
#define B_BE_DLE_WDE_EN BIT(26)
#define B_BE_TXPKT_CTRL_EN BIT(25)
#define B_BE_STA_SCH_EN BIT(24)
#define B_BE_DLE_PLE_EN BIT(23)
#define B_BE_PKT_BUF_EN BIT(22)
#define B_BE_DMAC_TBL_EN BIT(21)
#define B_BE_PKT_IN_EN BIT(20)
#define B_BE_DLE_CPUIO_EN BIT(19)
#define B_BE_DISPATCHER_EN BIT(18)
#define B_BE_BBRPT_EN BIT(17)
#define B_BE_MAC_SEC_EN BIT(16)
#define B_BE_DMACREG_GCKEN BIT(15)
#define B_BE_H_AXIDMA_EN BIT(14)
#define B_BE_DMAC_MLO_EN BIT(11)
#define B_BE_PLRLS_EN BIT(10)
#define B_BE_P_AXIDMA_EN BIT(9)
#define B_BE_DLE_DATACPUIO_EN BIT(8)
#define B_BE_LTR_CTL_EN BIT(7)

#define R_BE_DMAC_CLK_EN 0x8404
#define B_BE_MAC_CKEN BIT(30)
#define B_BE_DMAC_CKEN BIT(29)
#define B_BE_MPDU_CKEN BIT(28)
#define B_BE_WD_RLS_CLK_EN BIT(27)
#define B_BE_DLE_WDE_CLK_EN BIT(26)
#define B_BE_TXPKT_CTRL_CLK_EN BIT(25)
#define B_BE_STA_SCH_CLK_EN BIT(24)
#define B_BE_DLE_PLE_CLK_EN BIT(23)
#define B_BE_PKTBUF_CKEN BIT(22)
#define B_BE_DMAC_TABLE_CLK_EN BIT(21)
#define B_BE_PKT_IN_CLK_EN BIT(20)
#define B_BE_DLE_CPUIO_CLK_EN BIT(19)
#define B_BE_DISPATCHER_CLK_EN BIT(18)
#define B_BE_BBRPT_CLK_EN BIT(17)
#define B_BE_MAC_SEC_CLK_EN BIT(16)
#define B_BE_H_AXIDMA_CKEN BIT(14)
#define B_BE_DMAC_MLO_CKEN BIT(11)
#define B_BE_PLRLS_CKEN BIT(10)
#define B_BE_P_AXIDMA_CKEN BIT(9)
#define B_BE_DLE_DATACPUIO_CKEN BIT(8)

#define R_BE_LTR_CTRL_0 0x8410
#define B_BE_LTR_REQ_FW BIT(18)
#define B_BE_LTR_IDX_FW_MASK GENMASK(17, 16)
#define B_BE_LTR_IDLE_TIMER_IDX_MASK GENMASK(10, 8)
#define B_BE_LTR_WD_NOEMP_CHK BIT(1)
#define B_BE_LTR_HW_EN BIT(0)

#define R_BE_LTR_CFG_0 0x8414
#define B_BE_LTR_IDX_DISABLE_MASK GENMASK(17, 16)
#define B_BE_LTR_IDX_IDLE_MASK GENMASK(15, 14)
#define B_BE_LTR_IDX_ACTIVE_MASK GENMASK(13, 12)
#define B_BE_LTR_IDLE_TIMER_IDX_MASK GENMASK(10, 8)
#define B_BE_EN_LTR_CMAC_RX_USE_PG_CHK BIT(3)
#define B_BE_EN_LTR_WD_NON_EMPTY_CHK BIT(2)
#define B_BE_EN_LTR_HAXIDMA_TX_IDLE_CHK BIT(1)
#define B_BE_EN_LTR_HAXIDMA_RX_IDLE_CHK BIT(0)

#define R_BE_LTR_CFG_1 0x8418
#define B_BE_LTR_CMAC1_RX_USE_PG_TH_MASK GENMASK(27, 16)
#define B_BE_LTR_CMAC0_RX_USE_PG_TH_MASK GENMASK(11, 0)

#define R_BE_NO_RX_ERR_CFG 0x841C
#define B_BE_NO_RX_ERR_TO_MASK GENMASK(31, 29)

#define R_BE_DMAC_TABLE_CTRL 0x8420
#define B_BE_HWAMSDU_PADDING_MODE BIT(31)
#define B_BE_MACID_MPDU_PROCESSOR_OFFSET_MASK GENMASK(26, 16)
#define B_BE_DMAC_ADDR_MODE BIT(12)
#define B_BE_DMAC_CTRL_INFO_SER_IO BIT(11)
#define B_BE_DMAC_CTRL_INFO_OFFSET_MASK GENMASK(10, 0)

#define R_BE_SER_DBG_INFO 0x8424
#define B_BE_SER_L0_PROMOTE_L1_EVENT_MASK GENMASK(31, 28)
#define B_BE_SER_L1_COUNTER_MASK GENMASK(27, 24)
#define B_BE_RMAC_PPDU_HANG_CNT_MASK GENMASK(23, 16)
#define B_BE_SER_L0_COUNTER_MASK GENMASK(7, 0)

#define R_BE_DMAC_SYS_CR32B 0x842C
#define B_BE_DMAC_BB_PHY1_MASK GENMASK(31, 16)
#define B_BE_DMAC_BB_PHY0_MASK GENMASK(15, 0)
#define B_BE_DMAC_BB_CTRL_39 BIT(31)
#define B_BE_DMAC_BB_CTRL_38 BIT(30)
#define B_BE_DMAC_BB_CTRL_37 BIT(29)
#define B_BE_DMAC_BB_CTRL_36 BIT(28)
#define B_BE_DMAC_BB_CTRL_35 BIT(27)
#define B_BE_DMAC_BB_CTRL_34 BIT(26)
#define B_BE_DMAC_BB_CTRL_33 BIT(25)
#define B_BE_DMAC_BB_CTRL_32 BIT(24)
#define B_BE_DMAC_BB_CTRL_31 BIT(23)
#define B_BE_DMAC_BB_CTRL_30 BIT(22)
#define B_BE_DMAC_BB_CTRL_29 BIT(21)
#define B_BE_DMAC_BB_CTRL_28 BIT(20)
#define B_BE_DMAC_BB_CTRL_27 BIT(19)
#define B_BE_DMAC_BB_CTRL_26 BIT(18)
#define B_BE_DMAC_BB_CTRL_25 BIT(17)
#define B_BE_DMAC_BB_CTRL_24 BIT(16)
#define B_BE_DMAC_BB_CTRL_23 BIT(15)
#define B_BE_DMAC_BB_CTRL_22 BIT(14)
#define B_BE_DMAC_BB_CTRL_21 BIT(13)
#define B_BE_DMAC_BB_CTRL_20 BIT(12)
#define B_BE_DMAC_BB_CTRL_19 BIT(11)
#define B_BE_DMAC_BB_CTRL_18 BIT(10)
#define B_BE_DMAC_BB_CTRL_17 BIT(9)
#define B_BE_DMAC_BB_CTRL_16 BIT(8)
#define B_BE_DMAC_BB_CTRL_15 BIT(7)
#define B_BE_DMAC_BB_CTRL_14 BIT(6)
#define B_BE_DMAC_BB_CTRL_13 BIT(5)
#define B_BE_DMAC_BB_CTRL_12 BIT(4)
#define B_BE_DMAC_BB_CTRL_11 BIT(3)
#define B_BE_DMAC_BB_CTRL_10 BIT(2)
#define B_BE_DMAC_BB_CTRL_9 BIT(1)
#define B_BE_DMAC_BB_CTRL_8 BIT(0)

#define R_BE_DLE_EMPTY0 0x8430
#define B_BE_PLE_EMPTY_QTA_DMAC_H2D BIT(27)
#define B_BE_PLE_EMPTY_QTA_DMAC_CPUIO BIT(26)
#define B_BE_PLE_EMPTY_QTA_DMAC_MPDU_TX BIT(25)
#define B_BE_PLE_EMPTY_QTA_DMAC_WLAN_CPU BIT(24)
#define B_BE_PLE_EMPTY_QTA_DMAC_H2C BIT(23)
#define B_BE_PLE_EMPTY_QTA_DMAC_B1_TXPL BIT(22)
#define B_BE_PLE_EMPTY_QTA_DMAC_B0_TXPL BIT(21)
#define B_BE_WDE_EMPTY_QTA_DMAC_CPUIO BIT(20)
#define B_BE_WDE_EMPTY_QTA_DMAC_PKTIN BIT(19)
#define B_BE_WDE_EMPTY_QTA_DMAC_DATA_CPU BIT(18)
#define B_BE_WDE_EMPTY_QTA_DMAC_WLAN_CPU BIT(17)
#define B_BE_WDE_EMPTY_QTA_DMAC_HIF BIT(16)
#define B_BE_WDE_EMPTY_QUE_CMAC_B1_HIQ BIT(15)
#define B_BE_WDE_EMPTY_QUE_CMAC_B1_MBH BIT(14)
#define B_BE_WDE_EMPTY_QUE_CMAC_B0_OTHERS BIT(13)
#define B_BE_WDE_EMPTY_QUE_DMAC_MLO_ACQ BIT(12)
#define B_BE_WDE_EMPTY_QUE_DMAC_MLO_MISC BIT(11)
#define B_BE_WDE_EMPTY_QUE_DMAC_PKTIN BIT(10)
#define B_BE_PLE_EMPTY_QUE_DMAC_SEC_TX BIT(9)
#define B_BE_PLE_EMPTY_QUE_DMAC_MPDU_TX BIT(8)
#define B_BE_WDE_EMPTY_QUE_OTHERS BIT(7)
#define B_BE_WDE_EMPTY_QUE_CMAC_WMM3 BIT(6)
#define B_BE_WDE_EMPTY_QUE_CMAC_WMM2 BIT(5)
#define B_BE_WDE_EMPTY_QUE_CMAC0_WMM1 BIT(4)
#define B_BE_WDE_EMPTY_QUE_CMAC0_WMM0 BIT(3)
#define B_BE_WDE_EMPTY_QUE_CMAC1_MBH BIT(2)
#define B_BE_WDE_EMPTY_QUE_CMAC0_MBH BIT(1)
#define B_BE_WDE_EMPTY_QUE_CMAC0_ALL_AC BIT(0)

#define R_BE_DLE_EMPTY1 0x8434
#define B_BE_PLE_EMPTY_QTA_CMAC_DMA_TXRPT BIT(21)
#define B_BE_PLE_EMPTY_QTA_DMAC_WDRLS BIT(20)
#define B_BE_PLE_EMPTY_QTA_CMAC1_DMA_BBRPT BIT(19)
#define B_BE_PLE_EMPTY_QTA_CMAC1_DMA_RX BIT(18)
#define B_BE_PLE_EMPTY_QTA_CMAC0_DMA_RX BIT(17)
#define B_BE_PLE_EMPTY_QTA_DMAC_C2H BIT(16)
#define B_BE_PLE_EMPTY_QUE_DMAC_PLRLS BIT(5)
#define B_BE_PLE_EMPTY_QUE_DMAC_CPUIO BIT(4)
#define B_BE_PLE_EMPTY_QUE_DMAC_SEC_RX BIT(3)
#define B_BE_PLE_EMPTY_QUE_DMAC_MPDU_RX BIT(2)
#define B_BE_PLE_EMPTY_QUE_DMAC_HDP BIT(1)
#define B_BE_WDE_EMPTY_QUE_DMAC_WDRLS BIT(0)

#define R_BE_SER_L1_DBG_CNT_0 0x8440
#define B_BE_SER_L1_WDRLS_CNT_MASK GENMASK(31, 24)
#define B_BE_SER_L1_SEC_CNT_MASK GENMASK(23, 16)
#define B_BE_SER_L1_MPDU_CNT_MASK GENMASK(15, 8)
#define B_BE_SER_L1_STA_SCH_CNT_MASK GENMASK(7, 0)

#define R_BE_SER_L1_DBG_CNT_1 0x8444
#define B_BE_SER_L1_WDE_CNT_MASK GENMASK(31, 24)
#define B_BE_SER_L1_TXPKTCTRL_CNT_MASK GENMASK(23, 16)
#define B_BE_SER_L1_PLE_CNT_MASK GENMASK(15, 8)
#define B_BE_SER_L1_PKTIN_CNT_MASK GENMASK(7, 0)

#define R_BE_SER_L1_DBG_CNT_2 0x8448
#define B_BE_SER_L1_DISP_CNT_MASK GENMASK(31, 24)
#define B_BE_SER_L1_APB_BRIDGE_CNT_MASK GENMASK(23, 16)
#define B_BE_SER_L1_DLE_W_CPUIO_CNT_MASK GENMASK(15, 8)
#define B_BE_SER_L1_BBRPT_CNT_MASK GENMASK(7, 0)

#define R_BE_SER_L1_DBG_CNT_3 0x844C
#define B_BE_SER_L1_HCI_BUF_CNT_MASK GENMASK(31, 24)
#define B_BE_SER_L1_P_AXIDMA_CNT_MASK GENMASK(23, 16)
#define B_BE_SER_L1_H_AXIDMA_CNT_MASK GENMASK(15, 8)
#define B_BE_SER_L1_MLO_ERR_CNT_MASK GENMASK(7, 0)

#define R_BE_SER_L1_DBG_CNT_4 0x8450
#define B_BE_SER_L1_PLDRLS_ERR_CNT_MASK GENMASK(31, 24)
#define B_BE_SER_L1_DLE_D_CPUIO_CNT_MASK GENMASK(23, 16)

#define R_BE_SER_L1_DBG_CNT_5 0x8454
#define B_BE_SER_L1_DBG_0_MASK GENMASK(31, 0)

#define R_BE_SER_L1_DBG_CNT_6 0x8458
#define B_BE_SER_L1_DBG_1_MASK GENMASK(31, 0)

#define R_BE_SER_L1_DBG_CNT_7 0x845C
#define B_BE_SER_L1_DBG_2_MASK GENMASK(31, 0)

#define R_BE_FW_TRIGGER_IDCT_ISR 0x8508
#define B_BE_DMAC_FW_ERR_IDCT_IMR BIT(31)
#define B_BE_DMAC_FW_TRIG_IDCT BIT(0)

#define R_BE_DMAC_ERR_IMR 0x8520
#define B_BE_DMAC_NOTX_ERR_INT_EN BIT(21)
#define B_BE_DMAC_NORX_ERR_INT_EN BIT(20)
#define B_BE_DLE_DATACPUIO_ERR_INT_EN BIT(19)
#define B_BE_PLRSL_ERR_INT_EN BIT(18)
#define B_BE_MLO_ERR_INT_EN BIT(17)
#define B_BE_DMAC_FW_ERR_INT_EN BIT(16)
#define B_BE_H_AXIDMA_ERR_INT_EN BIT(14)
#define B_BE_P_AXIDMA_ERR_INT_EN BIT(13)
#define B_BE_HCI_BUF_ERR_INT_EN BIT(12)
#define B_BE_BBRPT_ERR_INT_EN BIT(11)
#define B_BE_DLE_CPUIO_ERR_INT_EN BIT(10)
#define B_BE_APB_BRIDGE_ERR_INT_EN BIT(9)
#define B_BE_DISPATCH_ERR_INT_EN BIT(8)
#define B_BE_PKTIN_ERR_INT_EN BIT(7)
#define B_BE_PLE_DLE_ERR_INT_EN BIT(6)
#define B_BE_TXPKTCTRL_ERR_INT_EN BIT(5)
#define B_BE_WDE_DLE_ERR_INT_EN BIT(4)
#define B_BE_STA_SCHEDULER_ERR_INT_EN BIT(3)
#define B_BE_MPDU_ERR_INT_EN BIT(2)
#define B_BE_WSEC_ERR_INT_EN BIT(1)
#define B_BE_WDRLS_ERR_INT_EN BIT(0)

#define R_BE_DMAC_ERR_ISR 0x8524
#define B_BE_DLE_DATACPUIO_ERR_INT BIT(19)
#define B_BE_PLRLS_ERR_INT BIT(18)
#define B_BE_MLO_ERR_INT BIT(17)
#define B_BE_DMAC_FW_ERR_IDCT BIT(16)
#define B_BE_H_AXIDMA_ERR_INT BIT(14)
#define B_BE_P_AXIDMA_ERR_INT BIT(13)
#define B_BE_HCI_BUF_ERR_FLAG BIT(12)
#define B_BE_BBRPT_ERR_FLAG BIT(11)
#define B_BE_DLE_CPUIO_ERR_FLAG BIT(10)
#define B_BE_APB_BRIDGE_ERR_FLAG BIT(9)
#define B_BE_DISPATCH_ERR_FLAG BIT(8)
#define B_BE_PKTIN_ERR_FLAG BIT(7)
#define B_BE_PLE_DLE_ERR_FLAG BIT(6)
#define B_BE_TXPKTCTRL_ERR_FLAG BIT(5)
#define B_BE_WDE_DLE_ERR_FLAG BIT(4)
#define B_BE_STA_SCHEDULER_ERR_FLAG BIT(3)
#define B_BE_MPDU_ERR_FLAG BIT(2)
#define B_BE_WSEC_ERR_FLAG BIT(1)
#define B_BE_WDRLS_ERR_FLAG BIT(0)

#define R_BE_DISP_ERROR_ISR0 0x8804
#define B_BE_REUSE_SIZE_ERR BIT(31)
#define B_BE_REUSE_EN_ERR BIT(30)
#define B_BE_STF_OQT_UNDERFLOW_ERR BIT(29)
#define B_BE_STF_OQT_OVERFLOW_ERR BIT(28)
#define B_BE_STF_WRFF_UNDERFLOW_ERR BIT(27)
#define B_BE_STF_WRFF_OVERFLOW_ERR BIT(26)
#define B_BE_STF_CMD_UNDERFLOW_ERR BIT(25)
#define B_BE_STF_CMD_OVERFLOW_ERR BIT(24)
#define B_BE_REUSE_SIZE_ZERO_ERR BIT(23)
#define B_BE_REUSE_PKT_CNT_ERR BIT(22)
#define B_BE_CDT_PTR_TIMEOUT_ERR BIT(21)
#define B_BE_CDT_HCI_TIMEOUT_ERR BIT(20)
#define B_BE_HDT_PTR_TIMEOUT_ERR BIT(19)
#define B_BE_HDT_HCI_TIMEOUT_ERR BIT(18)
#define B_BE_CDT_ADDR_INFO_LEN_ERR BIT(17)
#define B_BE_HDT_ADDR_INFO_LEN_ERR BIT(16)
#define B_BE_CDR_DMA_TIMEOUT_ERR BIT(15)
#define B_BE_CDR_RX_TIMEOUT_ERR BIT(14)
#define B_BE_PLE_OUTPUT_ERR BIT(12)
#define B_BE_PLE_RESPOSE_ERR BIT(11)
#define B_BE_PLE_BURST_NUM_ERR BIT(10)
#define B_BE_PLE_NULL_PKT_ERR BIT(9)
#define B_BE_PLE_FLOW_CTRL_ERR BIT(8)
#define B_BE_HDR_DMA_TIMEOUT_ERR BIT(7)
#define B_BE_HDR_RX_TIMEOUT_ERR BIT(6)
#define B_BE_WDE_OUTPUT_ERR BIT(4)
#define B_BE_WDE_RESPONSE_ERR BIT(3)
#define B_BE_WDE_BURST_NUM_ERR BIT(2)
#define B_BE_WDE_NULL_PKT_ERR BIT(1)
#define B_BE_WDE_FLOW_CTRL_ERR BIT(0)

#define R_BE_DISP_ERROR_ISR1 0x8808
#define B_BE_HR_WRFF_UNDERFLOW_ERR BIT(31)
#define B_BE_HR_WRFF_OVERFLOW_ERR BIT(30)
#define B_BE_HR_CHKSUM_FSM_ERR BIT(29)
#define B_BE_HR_SHIFT_DMA_CFG_ERR BIT(28)
#define B_BE_HR_DMA_PROCESS_ERR BIT(27)
#define B_BE_HR_TOTAL_LEN_UNDER_ERR BIT(26)
#define B_BE_HR_SHIFT_EN_ERR BIT(25)
#define B_BE_HR_AGG_CFG_ERR BIT(24)
#define B_BE_HR_PLD_LEN_ZERO_ERR BIT(22)
#define B_BE_HT_ILL_CH_ERR BIT(20)
#define B_BE_HT_ADDR_INFO_LEN_ERR BIT(18)
#define B_BE_HT_WD_LEN_OVER_ERR BIT(17)
#define B_BE_HT_PLD_CMD_UNDERFLOW_ERR BIT(16)
#define B_BE_HT_PLD_CMD_OVERFLOW_ERR BIT(15)
#define B_BE_HT_WRFF_UNDERFLOW_ERR BIT(14)
#define B_BE_HT_WRFF_OVERFLOW_ERR BIT(13)
#define B_BE_HT_CHKSUM_FSM_ERR BIT(12)
#define B_BE_HT_NON_IDLE_PKT_STR_ERR BIT(11)
#define B_BE_HT_PRE_SUB_BE_ERR BIT(10)
#define B_BE_HT_WD_CHKSUM_ERR BIT(9)
#define B_BE_HT_CHANNEL_DMA_ERR BIT(8)
#define B_BE_HT_OFFSET_UNMATCH_ERR BIT(7)
#define B_BE_HT_PAYLOAD_UNDER_ERR BIT(6)
#define B_BE_HT_PAYLOAD_OVER_ERR BIT(5)
#define B_BE_HT_PERMU_FF_UNDERFLOW_ERR BIT(4)
#define B_BE_HT_PERMU_FF_OVERFLOW_ERR BIT(3)
#define B_BE_HT_PKT_FAIL_ERR BIT(2)
#define B_BE_HT_CH_ID_ERR BIT(1)
#define B_BE_HT_EP_CH_DIFF_ERR BIT(0)

#define R_BE_DISP_ERROR_ISR2 0x880C
#define B_BE_CR_PLD_LEN_ERR BIT(30)
#define B_BE_CR_WRFF_UNDERFLOW_ERR BIT(29)
#define B_BE_CR_WRFF_OVERFLOW_ERR BIT(28)
#define B_BE_CR_SHIFT_DMA_CFG_ERR BIT(27)
#define B_BE_CR_DMA_PROCESS_ERR BIT(26)
#define B_BE_CR_SHIFT_EN_ERR BIT(24)
#define B_BE_REUSE_FIFO_B_UNDER_ERR BIT(22)
#define B_BE_REUSE_FIFO_B_OVER_ERR BIT(21)
#define B_BE_REUSE_FIFO_A_UNDER_ERR BIT(20)
#define B_BE_REUSE_FIFO_A_OVER_ERR BIT(19)
#define B_BE_CT_ADDR_INFO_LEN_MISS_ERR BIT(17)
#define B_BE_CT_WD_LEN_OVER_ERR BIT(16)
#define B_BE_CT_F2P_SEQ_ERR BIT(15)
#define B_BE_CT_F2P_QSEL_ERR BIT(14)
#define B_BE_CT_PLD_CMD_UNDERFLOW_ERR BIT(13)
#define B_BE_CT_PLD_CMD_OVERFLOW_ERR BIT(12)
#define B_BE_CT_PRE_SUB_ERR BIT(11)
#define B_BE_CT_WD_CHKSUM_ERR BIT(10)
#define B_BE_CT_CHANNEL_DMA_ERR BIT(9)
#define B_BE_CT_OFFSET_UNMATCH_ERR BIT(8)
#define B_BE_F2P_TOTAL_NUM_ERR BIT(7)
#define B_BE_CT_PAYLOAD_UNDER_ERR BIT(6)
#define B_BE_CT_PAYLOAD_OVER_ERR BIT(5)
#define B_BE_CT_PERMU_FF_UNDERFLOW_ERR BIT(4)
#define B_BE_CT_PERMU_FF_OVERFLOW_ERR BIT(3)
#define B_BE_CT_CH_ID_ERR BIT(2)
#define B_BE_CT_EP_CH_DIFF_ERR BIT(0)

#define R_BE_DISP_OTHER_IMR 0x8870
#define B_BE_REUSE_SIZE_ERR_INT_EN BIT(31)
#define B_BE_REUSE_EN_ERR_INT_EN BIT(30)
#define B_BE_STF_OQT_UNDERFLOW_ERR_INT_EN BIT(29)
#define B_BE_STF_OQT_OVERFLOW_ERR_INT_EN BIT(28)
#define B_BE_STF_WRFF_UNDERFLOW_ERR_INT_EN BIT(27)
#define B_BE_STF_WRFF_OVERFLOW_ERR_INT_EN BIT(26)
#define B_BE_STF_CMD_UNDERFLOW_ERR_INT_EN BIT(25)
#define B_BE_STF_CMD_OVERFLOW_ERR_INT_EN BIT(24)
#define B_BE_REUSE_SIZE_ZERO_ERR_INT_EN BIT(23)
#define B_BE_REUSE_PKT_CNT_ERR_INT_EN BIT(22)
#define B_BE_CDT_PTR_TIMEOUT_ERR_INT_EN BIT(21)
#define B_BE_CDT_HCI_TIMEOUT_ERR_INT_EN BIT(20)
#define B_BE_HDT_PTR_TIMEOUT_ERR_INT_EN BIT(19)
#define B_BE_HDT_HCI_TIMEOUT_ERR_INT_EN BIT(18)
#define B_BE_CDT_ADDR_INFO_LEN_ERR_INT_EN BIT(17)
#define B_BE_HDT_ADDR_INFO_LEN_ERR_INT_EN BIT(16)
#define B_BE_CDR_DMA_TIMEOUT_ERR_INT_EN BIT(15)
#define B_BE_CDR_RX_TIMEOUT_ERR_INT_EN BIT(14)
#define B_BE_PLE_OUTPUT_ERR_INT_EN BIT(12)
#define B_BE_PLE_RESPOSE_ERR_INT_EN BIT(11)
#define B_BE_PLE_BURST_NUM_ERR_INT_EN BIT(10)
#define B_BE_PLE_NULL_PKT_ERR_INT_EN BIT(9)
#define B_BE_PLE_FLOW_CTRL_ERR_INT_EN BIT(8)
#define B_BE_HDR_DMA_TIMEOUT_ERR_INT_EN BIT(7)
#define B_BE_HDR_RX_TIMEOUT_ERR_INT_EN BIT(6)
#define B_BE_WDE_OUTPUT_ERR_INT_EN BIT(4)
#define B_BE_WDE_RESPONSE_ERR_INT_EN BIT(3)
#define B_BE_WDE_BURST_NUM_ERR_INT_EN BIT(2)
#define B_BE_WDE_NULL_PKT_ERR_INT_EN BIT(1)
#define B_BE_WDE_FLOW_CTRL_ERR_INT_EN BIT(0)
#define B_BE_DISP_OTHER_IMR_CLR (B_BE_WDE_FLOW_CTRL_ERR_INT_EN | \
				 B_BE_WDE_NULL_PKT_ERR_INT_EN | \
				 B_BE_WDE_BURST_NUM_ERR_INT_EN | \
				 B_BE_WDE_RESPONSE_ERR_INT_EN | \
				 B_BE_WDE_OUTPUT_ERR_INT_EN | \
				 B_BE_HDR_RX_TIMEOUT_ERR_INT_EN | \
				 B_BE_HDR_DMA_TIMEOUT_ERR_INT_EN | \
				 B_BE_PLE_FLOW_CTRL_ERR_INT_EN | \
				 B_BE_PLE_NULL_PKT_ERR_INT_EN | \
				 B_BE_PLE_BURST_NUM_ERR_INT_EN | \
				 B_BE_PLE_RESPOSE_ERR_INT_EN | \
				 B_BE_PLE_OUTPUT_ERR_INT_EN | \
				 B_BE_CDR_RX_TIMEOUT_ERR_INT_EN | \
				 B_BE_CDR_DMA_TIMEOUT_ERR_INT_EN | \
				 B_BE_HDT_ADDR_INFO_LEN_ERR_INT_EN | \
				 B_BE_CDT_ADDR_INFO_LEN_ERR_INT_EN | \
				 B_BE_HDT_HCI_TIMEOUT_ERR_INT_EN | \
				 B_BE_HDT_PTR_TIMEOUT_ERR_INT_EN | \
				 B_BE_CDT_HCI_TIMEOUT_ERR_INT_EN | \
				 B_BE_CDT_PTR_TIMEOUT_ERR_INT_EN | \
				 B_BE_REUSE_PKT_CNT_ERR_INT_EN | \
				 B_BE_REUSE_SIZE_ZERO_ERR_INT_EN | \
				 B_BE_STF_CMD_OVERFLOW_ERR_INT_EN | \
				 B_BE_STF_CMD_UNDERFLOW_ERR_INT_EN | \
				 B_BE_STF_WRFF_OVERFLOW_ERR_INT_EN | \
				 B_BE_STF_WRFF_UNDERFLOW_ERR_INT_EN | \
				 B_BE_STF_OQT_OVERFLOW_ERR_INT_EN | \
				 B_BE_STF_OQT_UNDERFLOW_ERR_INT_EN | \
				 B_BE_REUSE_EN_ERR_INT_EN | \
				 B_BE_REUSE_SIZE_ERR_INT_EN)
#define B_BE_DISP_OTHER_IMR_SET (B_BE_STF_CMD_OVERFLOW_ERR_INT_EN | \
				 B_BE_STF_CMD_UNDERFLOW_ERR_INT_EN | \
				 B_BE_STF_WRFF_OVERFLOW_ERR_INT_EN | \
				 B_BE_STF_WRFF_UNDERFLOW_ERR_INT_EN | \
				 B_BE_STF_OQT_OVERFLOW_ERR_INT_EN | \
				 B_BE_STF_OQT_UNDERFLOW_ERR_INT_EN)
#define B_BE_DISP_OTHER_IMR_CLR_V1 0xFFFFFFFF
#define B_BE_DISP_OTHER_IMR_SET_V1 0x3F002000

#define R_BE_DISP_HOST_IMR 0x8874
#define B_BE_HR_WRFF_UNDERFLOW_ERR_INT_EN BIT(31)
#define B_BE_HR_WRFF_OVERFLOW_ERR_INT_EN BIT(30)
#define B_BE_HR_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_BE_HR_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_BE_HR_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_BE_HR_TOTAL_LEN_UNDER_ERR_INT_EN BIT(26)
#define B_BE_HR_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_BE_HR_AGG_CFG_ERR_INT_EN BIT(24)
#define B_BE_HR_PLD_LEN_ZERO_ERR_INT_EN BIT(22)
#define B_BE_HT_ILL_CH_ERR_INT_EN BIT(20)
#define B_BE_HT_ADDR_INFO_LEN_ERR_INT_EN BIT(18)
#define B_BE_HT_WD_LEN_OVER_ERR_INT_EN BIT(17)
#define B_BE_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN BIT(16)
#define B_BE_HT_PLD_CMD_OVERFLOW_ERR_INT_EN BIT(15)
#define B_BE_HT_WRFF_UNDERFLOW_ERR_INT_EN BIT(14)
#define B_BE_HT_WRFF_OVERFLOW_ERR_INT_EN BIT(13)
#define B_BE_HT_CHKSUM_FSM_ERR_INT_EN BIT(12)
#define B_BE_HT_NON_IDLE_PKT_STR_ERR_EN BIT(11)
#define B_BE_HT_PRE_SUB_ERR_INT_EN BIT(10)
#define B_BE_HT_WD_CHKSUM_ERR_INT_EN BIT(9)
#define B_BE_HT_CHANNEL_DMA_ERR_INT_EN BIT(8)
#define B_BE_HT_OFFSET_UNMATCH_ERR_INT_EN BIT(7)
#define B_BE_HT_PAYLOAD_UNDER_ERR_INT_EN BIT(6)
#define B_BE_HT_PAYLOAD_OVER_ERR_INT_EN BIT(5)
#define B_BE_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN BIT(4)
#define B_BE_HT_PERMU_FF_OVERFLOW_ERR_INT_EN BIT(3)
#define B_BE_HT_PKT_FAIL_ERR_INT_EN BIT(2)
#define B_BE_HT_CH_ID_ERR_INT_EN BIT(1)
#define B_BE_HT_EP_CH_DIFF_ERR_INT_EN BIT(0)
#define B_BE_DISP_HOST_IMR_CLR (B_BE_HT_EP_CH_DIFF_ERR_INT_EN | \
				B_BE_HT_CH_ID_ERR_INT_EN | \
				B_BE_HT_PKT_FAIL_ERR_INT_EN | \
				B_BE_HT_PERMU_FF_OVERFLOW_ERR_INT_EN | \
				B_BE_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN | \
				B_BE_HT_PAYLOAD_OVER_ERR_INT_EN | \
				B_BE_HT_PAYLOAD_UNDER_ERR_INT_EN | \
				B_BE_HT_OFFSET_UNMATCH_ERR_INT_EN | \
				B_BE_HT_CHANNEL_DMA_ERR_INT_EN | \
				B_BE_HT_WD_CHKSUM_ERR_INT_EN | \
				B_BE_HT_PRE_SUB_ERR_INT_EN | \
				B_BE_HT_NON_IDLE_PKT_STR_ERR_EN | \
				B_BE_HT_CHKSUM_FSM_ERR_INT_EN | \
				B_BE_HT_WRFF_OVERFLOW_ERR_INT_EN | \
				B_BE_HT_WRFF_UNDERFLOW_ERR_INT_EN | \
				B_BE_HT_PLD_CMD_OVERFLOW_ERR_INT_EN | \
				B_BE_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN | \
				B_BE_HT_WD_LEN_OVER_ERR_INT_EN | \
				B_BE_HT_ADDR_INFO_LEN_ERR_INT_EN | \
				B_BE_HT_ILL_CH_ERR_INT_EN | \
				B_BE_HR_PLD_LEN_ZERO_ERR_INT_EN | \
				B_BE_HR_AGG_CFG_ERR_INT_EN | \
				B_BE_HR_SHIFT_EN_ERR_INT_EN | \
				B_BE_HR_TOTAL_LEN_UNDER_ERR_INT_EN | \
				B_BE_HR_DMA_PROCESS_ERR_INT_EN | \
				B_BE_HR_SHIFT_DMA_CFG_ERR_INT_EN | \
				B_BE_HR_CHKSUM_FSM_ERR_INT_EN | \
				B_BE_HR_WRFF_OVERFLOW_ERR_INT_EN | \
				B_BE_HR_WRFF_UNDERFLOW_ERR_INT_EN)
#define B_BE_DISP_HOST_IMR_SET (B_BE_HT_EP_CH_DIFF_ERR_INT_EN | \
				B_BE_HT_PERMU_FF_OVERFLOW_ERR_INT_EN | \
				B_BE_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN | \
				B_BE_HT_PAYLOAD_OVER_ERR_INT_EN | \
				B_BE_HT_PAYLOAD_UNDER_ERR_INT_EN | \
				B_BE_HT_CHANNEL_DMA_ERR_INT_EN | \
				B_BE_HT_PRE_SUB_ERR_INT_EN | \
				B_BE_HT_WRFF_OVERFLOW_ERR_INT_EN | \
				B_BE_HT_WRFF_UNDERFLOW_ERR_INT_EN | \
				B_BE_HT_PLD_CMD_OVERFLOW_ERR_INT_EN | \
				B_BE_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN | \
				B_BE_HT_WD_LEN_OVER_ERR_INT_EN | \
				B_BE_HT_ILL_CH_ERR_INT_EN | \
				B_BE_HR_TOTAL_LEN_UNDER_ERR_INT_EN | \
				B_BE_HR_DMA_PROCESS_ERR_INT_EN | \
				B_BE_HR_WRFF_OVERFLOW_ERR_INT_EN | \
				B_BE_HR_WRFF_UNDERFLOW_ERR_INT_EN)
#define B_BE_DISP_HOST_IMR_CLR_V1 0xFBFFFFFF
#define B_BE_DISP_HOST_IMR_SET_V1 0xC8B3E579

#define R_BE_DISP_CPU_IMR 0x8878
#define B_BE_CR_PLD_LEN_ERR_INT_EN BIT(30)
#define B_BE_CR_WRFF_UNDERFLOW_ERR_INT_EN BIT(29)
#define B_BE_CR_WRFF_OVERFLOW_ERR_INT_EN BIT(28)
#define B_BE_CR_SHIFT_DMA_CFG_ERR_INT_EN BIT(27)
#define B_BE_CR_DMA_PROCESS_ERR_INT_EN BIT(26)
#define B_BE_CR_TOTAL_LEN_UNDER_ERR_INT_EN BIT(25)
#define B_BE_CR_SHIFT_EN_ERR_INT_EN BIT(24)
#define B_BE_REUSE_FIFO_B_UNDER_ERR_INT_EN BIT(22)
#define B_BE_REUSE_FIFO_B_OVER_ERR_INT_EN BIT(21)
#define B_BE_REUSE_FIFO_A_UNDER_ERR_INT_EN BIT(20)
#define B_BE_REUSE_FIFO_A_OVER_ERR_INT_EN BIT(19)
#define B_BE_CT_ADDR_INFO_LEN_MISS_ERR_INT_EN BIT(17)
#define B_BE_CT_WD_LEN_OVER_ERR_INT_EN BIT(16)
#define B_BE_CT_F2P_SEQ_ERR_INT_EN BIT(15)
#define B_BE_CT_F2P_QSEL_ERR_INT_EN BIT(14)
#define B_BE_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN BIT(13)
#define B_BE_CT_PLD_CMD_OVERFLOW_ERR_INT_EN BIT(12)
#define B_BE_CT_PRE_SUB_ERR_INT_EN BIT(11)
#define B_BE_CT_WD_CHKSUM_ERR_INT_EN BIT(10)
#define B_BE_CT_CHANNEL_DMA_ERR_INT_EN BIT(9)
#define B_BE_CT_OFFSET_UNMATCH_ERR_INT_EN BIT(8)
#define B_BE_CT_PAYLOAD_CHKSUM_ERR_INT_EN BIT(7)
#define B_BE_CT_PAYLOAD_UNDER_ERR_INT_EN BIT(6)
#define B_BE_CT_PAYLOAD_OVER_ERR_INT_EN BIT(5)
#define B_BE_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN BIT(4)
#define B_BE_CT_PERMU_FF_OVERFLOW_ERR_INT_EN BIT(3)
#define B_BE_CT_CH_ID_ERR_INT_EN BIT(2)
#define B_BE_CT_PKT_FAIL_ERR_INT_EN BIT(1)
#define B_BE_CT_EP_CH_DIFF_ERR_INT_EN BIT(0)
#define B_BE_DISP_CPU_IMR_CLR (B_BE_CT_EP_CH_DIFF_ERR_INT_EN | \
			       B_BE_CT_CH_ID_ERR_INT_EN | \
			       B_BE_CT_PERMU_FF_OVERFLOW_ERR_INT_EN | \
			       B_BE_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN | \
			       B_BE_CT_PAYLOAD_OVER_ERR_INT_EN | \
			       B_BE_CT_PAYLOAD_UNDER_ERR_INT_EN | \
			       B_BE_CT_OFFSET_UNMATCH_ERR_INT_EN | \
			       B_BE_CT_CHANNEL_DMA_ERR_INT_EN | \
			       B_BE_CT_WD_CHKSUM_ERR_INT_EN | \
			       B_BE_CT_PRE_SUB_ERR_INT_EN | \
			       B_BE_CT_PLD_CMD_OVERFLOW_ERR_INT_EN | \
			       B_BE_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN | \
			       B_BE_CT_F2P_QSEL_ERR_INT_EN | \
			       B_BE_CT_F2P_SEQ_ERR_INT_EN | \
			       B_BE_CT_WD_LEN_OVER_ERR_INT_EN | \
			       B_BE_CT_ADDR_INFO_LEN_MISS_ERR_INT_EN | \
			       B_BE_REUSE_FIFO_A_OVER_ERR_INT_EN | \
			       B_BE_REUSE_FIFO_A_UNDER_ERR_INT_EN | \
			       B_BE_REUSE_FIFO_B_OVER_ERR_INT_EN | \
			       B_BE_REUSE_FIFO_B_UNDER_ERR_INT_EN | \
			       B_BE_CR_SHIFT_EN_ERR_INT_EN | \
			       B_BE_CR_DMA_PROCESS_ERR_INT_EN | \
			       B_BE_CR_SHIFT_DMA_CFG_ERR_INT_EN | \
			       B_BE_CR_WRFF_OVERFLOW_ERR_INT_EN | \
			       B_BE_CR_WRFF_UNDERFLOW_ERR_INT_EN | \
			       B_BE_CR_PLD_LEN_ERR_INT_EN)
#define B_BE_DISP_CPU_IMR_SET (B_BE_CT_EP_CH_DIFF_ERR_INT_EN | \
			       B_BE_CT_CH_ID_ERR_INT_EN | \
			       B_BE_CT_PERMU_FF_OVERFLOW_ERR_INT_EN | \
			       B_BE_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN | \
			       B_BE_CT_PAYLOAD_OVER_ERR_INT_EN | \
			       B_BE_CT_PAYLOAD_UNDER_ERR_INT_EN | \
			       B_BE_CT_PRE_SUB_ERR_INT_EN | \
			       B_BE_CT_PLD_CMD_OVERFLOW_ERR_INT_EN | \
			       B_BE_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN | \
			       B_BE_CT_WD_LEN_OVER_ERR_INT_EN | \
			       B_BE_REUSE_FIFO_A_OVER_ERR_INT_EN | \
			       B_BE_REUSE_FIFO_A_UNDER_ERR_INT_EN | \
			       B_BE_REUSE_FIFO_B_OVER_ERR_INT_EN | \
			       B_BE_REUSE_FIFO_B_UNDER_ERR_INT_EN | \
			       B_BE_CR_DMA_PROCESS_ERR_INT_EN | \
			       B_BE_CR_WRFF_OVERFLOW_ERR_INT_EN | \
			       B_BE_CR_WRFF_UNDERFLOW_ERR_INT_EN)
#define B_BE_DISP_CPU_IMR_CLR_V1 0x7DFFFFFD
#define B_BE_DISP_CPU_IMR_SET_V1 0x34F938FD

#define R_BE_RX_STOP 0x8914
#define B_BE_CPU_RX_STOP BIT(17)
#define B_BE_HOST_RX_STOP BIT(16)
#define B_BE_CPU_RX_CH_STOP_MSK GENMASK(15, 8)
#define B_BE_HOST_RX_CH_STOP_MSK GENMASK(5, 0)

#define R_BE_DISP_FWD_WLAN_0 0x8938
#define B_BE_FWD_WLAN_CPU_TYPE_13_MASK GENMASK(31, 30)
#define B_BE_FWD_WLAN_CPU_TYPE_12_MASK GENMASK(29, 28)
#define B_BE_FWD_WLAN_CPU_TYPE_11_MASK GENMASK(27, 26)
#define B_BE_FWD_WLAN_CPU_TYPE_10_MASK GENMASK(25, 24)
#define B_BE_FWD_WLAN_CPU_TYPE_9_MASK GENMASK(23, 22)
#define B_BE_FWD_WLAN_CPU_TYPE_8_MASK GENMASK(21, 20)
#define B_BE_FWD_WLAN_CPU_TYPE_7_MASK GENMASK(19, 18)
#define B_BE_FWD_WLAN_CPU_TYPE_6_MASK GENMASK(17, 16)
#define B_BE_FWD_WLAN_CPU_TYPE_5_MASK GENMASK(15, 14)
#define B_BE_FWD_WLAN_CPU_TYPE_4_MASK GENMASK(13, 12)
#define B_BE_FWD_WLAN_CPU_TYPE_3_MASK GENMASK(11, 10)
#define B_BE_FWD_WLAN_CPU_TYPE_2_MASK GENMASK(9, 8)
#define B_BE_FWD_WLAN_CPU_TYPE_1_MASK GENMASK(7, 6)
#define B_BE_FWD_WLAN_CPU_TYPE_0_CTL_MASK GENMASK(5, 4)
#define B_BE_FWD_WLAN_CPU_TYPE_0_MNG_MASK GENMASK(3, 2)
#define B_BE_FWD_WLAN_CPU_TYPE_0_DATA_MASK GENMASK(1, 0)

#define R_BE_WDE_PKTBUF_CFG 0x8C08
#define B_BE_WDE_FREE_PAGE_NUM_MASK GENMASK(28, 16)
#define B_BE_WDE_START_BOUND_MASK GENMASK(14, 8)
#define B_BE_WDE_PAGE_SEL_MASK GENMASK(1, 0)

#define R_BE_WDE_BUFMGN_CTL 0x8C10
#define B_BE_WDE_AVAL_UPD_REQ BIT(29)
#define B_BE_WDE_AVAL_UPD_QTAID_MASK GENMASK(27, 24)
#define B_BE_WDE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_BE_WDE_ERR_IMR 0x8C38
#define B_BE_WDE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_BE_WDE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_BE_WDE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_BE_WDE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_BE_WDE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_BE_WDE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_BE_WDE_QUEMGN_FRZTO_ERR_INT_EN BIT(23)
#define B_BE_WDE_NXTPKTLL_AD_ERR_INT_EN BIT(22)
#define B_BE_WDE_PREPKTLLT_AD_ERR_INT_EN BIT(21)
#define B_BE_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(20)
#define B_BE_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(19)
#define B_BE_WDE_QUE_SRCQUEID_ERR_INT_EN BIT(18)
#define B_BE_WDE_QUE_DSTQUEID_ERR_INT_EN BIT(17)
#define B_BE_WDE_QUE_CMDTYPE_ERR_INT_EN BIT(16)
#define B_BE_WDE_BUFMGN_MRG_SZLMT_ERR_INT_EN BIT(13)
#define B_BE_WDE_BUFMGN_MRG_QTAID_ERR_INT_EN BIT(12)
#define B_BE_WDE_BUFMGN_MRG_ENDPKTID_ERR_INT_EN BIT(11)
#define B_BE_WDE_ERR_BUFMGN_MRG_STRPKTID_ERR_INT_EN BIT(10)
#define B_BE_WDE_BUFMGN_FRZTO_ERR_INT_EN BIT(9)
#define B_BE_WDE_GETNPG_PGOFST_ERR_INT_EN BIT(8)
#define B_BE_WDE_GETNPG_STRPG_ERR_INT_EN BIT(7)
#define B_BE_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(6)
#define B_BE_WDE_BUFRTN_SIZE_ERR_INT_EN BIT(5)
#define B_BE_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(4)
#define B_BE_WDE_BUFREQ_UNAVAL_ERR_INT_EN BIT(3)
#define B_BE_WDE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_BE_WDE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_BE_WDE_BUFREQ_QTAID_ERR_INT_EN BIT(0)
#define B_BE_WDE_ERR_IMR_CLR (B_BE_WDE_BUFREQ_QTAID_ERR_INT_EN | \
			      B_BE_WDE_BUFREQ_SIZE0_INT_EN | \
			      B_BE_WDE_BUFREQ_SIZELMT_INT_EN | \
			      B_BE_WDE_BUFREQ_UNAVAL_ERR_INT_EN | \
			      B_BE_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			      B_BE_WDE_BUFRTN_SIZE_ERR_INT_EN | \
			      B_BE_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			      B_BE_WDE_GETNPG_STRPG_ERR_INT_EN | \
			      B_BE_WDE_GETNPG_PGOFST_ERR_INT_EN | \
			      B_BE_WDE_BUFMGN_FRZTO_ERR_INT_EN | \
			      B_BE_WDE_ERR_BUFMGN_MRG_STRPKTID_ERR_INT_EN | \
			      B_BE_WDE_BUFMGN_MRG_ENDPKTID_ERR_INT_EN | \
			      B_BE_WDE_BUFMGN_MRG_QTAID_ERR_INT_EN | \
			      B_BE_WDE_BUFMGN_MRG_SZLMT_ERR_INT_EN | \
			      B_BE_WDE_QUE_CMDTYPE_ERR_INT_EN | \
			      B_BE_WDE_QUE_DSTQUEID_ERR_INT_EN | \
			      B_BE_WDE_QUE_SRCQUEID_ERR_INT_EN | \
			      B_BE_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			      B_BE_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			      B_BE_WDE_PREPKTLLT_AD_ERR_INT_EN | \
			      B_BE_WDE_NXTPKTLL_AD_ERR_INT_EN | \
			      B_BE_WDE_QUEMGN_FRZTO_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_ARBT_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_NULLPG_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_FRZTO_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_RRDY_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_ADRERR_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_CAMREQ_ERR_INT_EN)
#define B_BE_WDE_ERR_IMR_SET (B_BE_WDE_BUFREQ_QTAID_ERR_INT_EN | \
			      B_BE_WDE_BUFREQ_SIZE0_INT_EN | \
			      B_BE_WDE_BUFREQ_SIZELMT_INT_EN | \
			      B_BE_WDE_BUFREQ_UNAVAL_ERR_INT_EN | \
			      B_BE_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			      B_BE_WDE_BUFRTN_SIZE_ERR_INT_EN | \
			      B_BE_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			      B_BE_WDE_GETNPG_STRPG_ERR_INT_EN | \
			      B_BE_WDE_GETNPG_PGOFST_ERR_INT_EN | \
			      B_BE_WDE_BUFMGN_FRZTO_ERR_INT_EN | \
			      B_BE_WDE_ERR_BUFMGN_MRG_STRPKTID_ERR_INT_EN | \
			      B_BE_WDE_BUFMGN_MRG_ENDPKTID_ERR_INT_EN | \
			      B_BE_WDE_BUFMGN_MRG_QTAID_ERR_INT_EN | \
			      B_BE_WDE_BUFMGN_MRG_SZLMT_ERR_INT_EN | \
			      B_BE_WDE_QUE_CMDTYPE_ERR_INT_EN | \
			      B_BE_WDE_QUE_DSTQUEID_ERR_INT_EN | \
			      B_BE_WDE_QUE_SRCQUEID_ERR_INT_EN | \
			      B_BE_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			      B_BE_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			      B_BE_WDE_PREPKTLLT_AD_ERR_INT_EN | \
			      B_BE_WDE_NXTPKTLL_AD_ERR_INT_EN | \
			      B_BE_WDE_QUEMGN_FRZTO_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_ARBT_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_NULLPG_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_FRZTO_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_RRDY_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_ADRERR_ERR_INT_EN | \
			      B_BE_WDE_DATCHN_CAMREQ_ERR_INT_EN)

#define R_BE_WDE_QTA0_CFG 0x8C40
#define B_BE_WDE_Q0_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_WDE_Q0_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_WDE_QTA1_CFG 0x8C44
#define B_BE_WDE_Q1_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_WDE_Q1_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_WDE_QTA2_CFG 0x8C48
#define B_BE_WDE_Q2_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_WDE_Q2_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_WDE_QTA3_CFG 0x8C4C
#define B_BE_WDE_Q3_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_WDE_Q3_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_WDE_QTA4_CFG 0x8C50
#define B_BE_WDE_Q4_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_WDE_Q4_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_WDE_ERR1_IMR 0x8CC0
#define B_BE_WDE_QUEMGN_CMACACQ_DEQNTFY_INT_EN BIT(8)
#define B_BE_WDE_ERR1_IMR_CLR B_BE_WDE_QUEMGN_CMACACQ_DEQNTFY_INT_EN
#define B_BE_WDE_ERR1_IMR_SET B_BE_WDE_QUEMGN_CMACACQ_DEQNTFY_INT_EN

#define R_BE_PLE_PKTBUF_CFG 0x9008
#define B_BE_PLE_FREE_PAGE_NUM_MASK GENMASK(28, 16)
#define B_BE_PLE_START_BOUND_MASK GENMASK(14, 8)
#define B_BE_PLE_PAGE_SEL_MASK GENMASK(1, 0)

#define R_BE_PLE_BUFMGN_CTL 0x9010
#define B_BE_PLE_AVAL_UPD_REQ BIT(29)
#define B_BE_PLE_AVAL_UPD_QTAID_MASK GENMASK(27, 24)
#define B_BE_PLE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_BE_PLE_ERR_IMR 0x9038
#define B_BE_PLE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_BE_PLE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_BE_PLE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_BE_PLE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_BE_PLE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_BE_PLE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_BE_PLE_QUEMGN_FRZTO_ERR_INT_EN BIT(23)
#define B_BE_PLE_NXTPKTLL_AD_ERR_INT_EN BIT(22)
#define B_BE_PLE_PREPKTLLT_AD_ERR_INT_EN BIT(21)
#define B_BE_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(20)
#define B_BE_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(19)
#define B_BE_PLE_QUE_SRCQUEID_ERR_INT_EN BIT(18)
#define B_BE_PLE_QUE_DSTQUEID_ERR_INT_EN BIT(17)
#define B_BE_PLE_QUE_CMDTYPE_ERR_INT_EN BIT(16)
#define B_BE_PLE_BUFMGN_MRG_SZLMT_ERR_INT_EN BIT(13)
#define B_BE_PLE_BUFMGN_MRG_QTAID_ERR_INT_EN BIT(12)
#define B_BE_PLE_BUFMGN_MRG_ENDPKTID_ERR_INT_EN BIT(11)
#define B_BE_PLE_BUFMGN_MRG_STRPKTID_ERR_INT_EN BIT(10)
#define B_BE_PLE_BUFMGN_FRZTO_ERR_INT_EN BIT(9)
#define B_BE_PLE_GETNPG_PGOFST_ERR_INT_EN BIT(8)
#define B_BE_PLE_GETNPG_STRPG_ERR_INT_EN BIT(7)
#define B_BE_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(6)
#define B_BE_PLE_BUFRTN_SIZE_ERR_INT_EN BIT(5)
#define B_BE_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(4)
#define B_BE_PLE_BUFREQ_UNAVAL_ERR_INT_EN BIT(3)
#define B_BE_PLE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_BE_PLE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_BE_PLE_BUFREQ_QTAID_ERR_INT_EN BIT(0)
#define B_BE_PLE_ERR_IMR_CLR (B_BE_PLE_BUFREQ_QTAID_ERR_INT_EN | \
			      B_BE_PLE_BUFREQ_SIZE0_INT_EN | \
			      B_BE_PLE_BUFREQ_SIZELMT_INT_EN | \
			      B_BE_PLE_BUFREQ_UNAVAL_ERR_INT_EN | \
			      B_BE_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			      B_BE_PLE_BUFRTN_SIZE_ERR_INT_EN | \
			      B_BE_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			      B_BE_PLE_GETNPG_STRPG_ERR_INT_EN | \
			      B_BE_PLE_GETNPG_PGOFST_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_FRZTO_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_MRG_STRPKTID_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_MRG_ENDPKTID_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_MRG_QTAID_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_MRG_SZLMT_ERR_INT_EN | \
			      B_BE_PLE_QUE_CMDTYPE_ERR_INT_EN | \
			      B_BE_PLE_QUE_DSTQUEID_ERR_INT_EN | \
			      B_BE_PLE_QUE_SRCQUEID_ERR_INT_EN | \
			      B_BE_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			      B_BE_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			      B_BE_PLE_PREPKTLLT_AD_ERR_INT_EN | \
			      B_BE_PLE_NXTPKTLL_AD_ERR_INT_EN | \
			      B_BE_PLE_QUEMGN_FRZTO_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_ARBT_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_NULLPG_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_FRZTO_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_RRDY_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_ADRERR_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_CAMREQ_ERR_INT_EN)
#define B_BE_PLE_ERR_IMR_SET (B_BE_PLE_BUFREQ_QTAID_ERR_INT_EN | \
			      B_BE_PLE_BUFREQ_SIZE0_INT_EN | \
			      B_BE_PLE_BUFREQ_SIZELMT_INT_EN | \
			      B_BE_PLE_BUFREQ_UNAVAL_ERR_INT_EN | \
			      B_BE_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN | \
			      B_BE_PLE_BUFRTN_SIZE_ERR_INT_EN | \
			      B_BE_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN | \
			      B_BE_PLE_GETNPG_STRPG_ERR_INT_EN | \
			      B_BE_PLE_GETNPG_PGOFST_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_FRZTO_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_MRG_STRPKTID_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_MRG_ENDPKTID_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_MRG_QTAID_ERR_INT_EN | \
			      B_BE_PLE_BUFMGN_MRG_SZLMT_ERR_INT_EN | \
			      B_BE_PLE_QUE_CMDTYPE_ERR_INT_EN | \
			      B_BE_PLE_QUE_DSTQUEID_ERR_INT_EN | \
			      B_BE_PLE_QUE_SRCQUEID_ERR_INT_EN | \
			      B_BE_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN | \
			      B_BE_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN | \
			      B_BE_PLE_PREPKTLLT_AD_ERR_INT_EN | \
			      B_BE_PLE_NXTPKTLL_AD_ERR_INT_EN | \
			      B_BE_PLE_QUEMGN_FRZTO_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_ARBT_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_NULLPG_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_FRZTO_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_RRDY_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_ADRERR_ERR_INT_EN | \
			      B_BE_PLE_DATCHN_CAMREQ_ERR_INT_EN)

#define R_BE_PLE_QTA0_CFG 0x9040
#define B_BE_PLE_Q0_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q0_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA1_CFG 0x9044
#define B_BE_PLE_Q1_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q1_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA2_CFG 0x9048
#define B_BE_PLE_Q2_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q2_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA3_CFG 0x904C
#define B_BE_PLE_Q3_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q3_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA4_CFG 0x9050
#define B_BE_PLE_Q4_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q4_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA5_CFG 0x9054
#define B_BE_PLE_Q5_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q5_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA6_CFG 0x9058
#define B_BE_PLE_Q6_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q6_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA7_CFG 0x905C
#define B_BE_PLE_Q7_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q7_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA8_CFG 0x9060
#define B_BE_PLE_Q8_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q8_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA9_CFG 0x9064
#define B_BE_PLE_Q9_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q9_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA10_CFG 0x9068
#define B_BE_PLE_Q10_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q10_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA11_CFG 0x906C
#define B_BE_PLE_Q11_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q11_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA12_CFG 0x9070
#define B_BE_PLE_Q12_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q12_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_QTA13_CFG 0x9074
#define B_BE_PLE_Q13_MAX_SIZE_MASK GENMASK(27, 16)
#define B_BE_PLE_Q13_MIN_SIZE_MASK GENMASK(11, 0)

#define R_BE_PLE_ERRFLAG1_IMR 0x90C0
#define B_BE_PLE_SRCHPG_PGOFST_IMR BIT(26)
#define B_BE_PLE_SRCHPG_STRPG_IMR BIT(25)
#define B_BE_PLE_SRCHPG_FRZTO_IMR BIT(24)
#define B_BE_PLE_ERRFLAG1_IMR_CLR (B_BE_PLE_SRCHPG_FRZTO_IMR | \
				   B_BE_PLE_SRCHPG_STRPG_IMR | \
				   B_BE_PLE_SRCHPG_PGOFST_IMR)
#define B_BE_PLE_ERRFLAG1_IMR_SET (B_BE_PLE_SRCHPG_FRZTO_IMR | \
				   B_BE_PLE_SRCHPG_STRPG_IMR | \
				   B_BE_PLE_SRCHPG_PGOFST_IMR)

#define R_BE_PLE_DBG_FUN_INTF_CTL 0x9110
#define B_BE_PLE_DFI_ACTIVE BIT(31)
#define B_BE_PLE_DFI_TRGSEL_MASK GENMASK(19, 16)
#define B_BE_PLE_DFI_ADDR_MASK GENMASK(15, 0)

#define R_BE_PLE_DBG_FUN_INTF_DATA 0x9114
#define B_BE_PLE_DFI_DATA_MASK GENMASK(31, 0)

#define R_BE_WDRLS_CFG 0x9408
#define B_BE_WDRLS_DIS_AGAC BIT(31)
#define B_BE_RLSRPT_BUFREQ_TO_MASK GENMASK(15, 8)
#define B_BE_RLSRPT_BUFREQ_TO_SEL_MASK GENMASK(7, 6)
#define B_BE_WDRLS_MODE_MASK GENMASK(1, 0)

#define R_BE_WDRLS_ERR_IMR 0x9430
#define B_BE_WDRLS_RPT3_FRZTO_ERR_INT_EN BIT(21)
#define B_BE_WDRLS_RPT3_AGGNUM0_ERR_INT_EN BIT(20)
#define B_BE_WDRLS_RPT2_FRZTO_ERR_INT_EN BIT(17)
#define B_BE_WDRLS_RPT2_AGGNUM0_ERR_INT_EN BIT(16)
#define B_BE_WDRLS_RPT1_FRZTO_ERR_INT_EN BIT(13)
#define B_BE_WDRLS_RPT1_AGGNUM0_ERR_INT_EN BIT(12)
#define B_BE_WDRLS_RPT0_FRZTO_ERR_INT_EN BIT(9)
#define B_BE_WDRLS_RPT0_AGGNUM0_ERR_INT_EN BIT(8)
#define B_BE_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN BIT(5)
#define B_BE_WDRLS_PLEBREQ_TO_ERR_INT_EN BIT(4)
#define B_BE_WDRLS_CTL_FRZTO_ERR_INT_EN BIT(2)
#define B_BE_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN BIT(1)
#define B_BE_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN BIT(0)
#define B_BE_WDRLS_ERR_IMR_CLR (B_BE_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN | \
				B_BE_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN | \
				B_BE_WDRLS_CTL_FRZTO_ERR_INT_EN | \
				B_BE_WDRLS_PLEBREQ_TO_ERR_INT_EN | \
				B_BE_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN | \
				B_BE_WDRLS_RPT0_AGGNUM0_ERR_INT_EN | \
				B_BE_WDRLS_RPT0_FRZTO_ERR_INT_EN | \
				B_BE_WDRLS_RPT1_AGGNUM0_ERR_INT_EN | \
				B_BE_WDRLS_RPT1_FRZTO_ERR_INT_EN)
#define B_BE_WDRLS_ERR_IMR_SET (B_BE_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN | \
				B_BE_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN | \
				B_BE_WDRLS_CTL_FRZTO_ERR_INT_EN | \
				B_BE_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN | \
				B_BE_WDRLS_RPT0_AGGNUM0_ERR_INT_EN | \
				B_BE_WDRLS_RPT0_FRZTO_ERR_INT_EN | \
				B_BE_WDRLS_RPT1_AGGNUM0_ERR_INT_EN | \
				B_BE_WDRLS_RPT1_FRZTO_ERR_INT_EN)

#define R_BE_RLSRPT0_CFG0 0x9440
#define B_BE_RLSRPT0_FWRLS BIT(31)
#define B_BE_RLSRPT0_FWD_TRGT_MASK GENMASK(23, 16)
#define B_BE_RLSRPT0_PID_MASK GENMASK(10, 8)
#define B_BE_RLSRPT0_QID_MASK GENMASK(5, 0)
#define WDRLS_DEST_QID_POH 1
#define WDRLS_DEST_QID_STF 0

#define R_BE_RLSRPT0_CFG1 0x9444
#define B_BE_RLSRPT0_FLTR_MAP_V1_MASK GENMASK(28, 24)
#define S_BE_WDRLS_FLTR_TXOK_V1 BIT(0)
#define S_BE_WDRLS_FLTR_RTYLMT_V1 BIT(1)
#define S_BE_WDRLS_FLTR_LIFTIM_V1 BIT(2)
#define S_BE_WDRLS_FLTR_MACID_V1 BIT(3)
#define S_BE_WDRLS_FLTR_RELINK_V1 BIT(4)
#define B_BE_RLSRPT0_FLTR_MAP_MASK GENMASK(27, 24)
#define S_BE_WDRLS_FLTR_TXOK 1
#define S_BE_WDRLS_FLTR_RTYLMT 2
#define S_BE_WDRLS_FLTR_LIFTIM 4
#define S_BE_WDRLS_FLTR_MACID 8
#define B_BE_RLSRPT0_TO_MASK GENMASK(23, 16)
#define B_BE_RLSRPT0_AGGNUM_MASK GENMASK(7, 0)

#define R_BE_BBRPT_COM_ERR_IMR 0x9608
#define B_BE_BBRPT_COM_EVT01_ISR_EN BIT(1)
#define B_BE_BBRPT_COM_NULL_PLPKTID_ISR_EN BIT(0)
#define B_BE_BBRPT_COM_ERR_IMR_CLR (B_BE_BBRPT_COM_NULL_PLPKTID_ISR_EN | \
				    B_BE_BBRPT_COM_EVT01_ISR_EN)
#define B_BE_BBRPT_COM_ERR_IMR_SET B_BE_BBRPT_COM_NULL_PLPKTID_ISR_EN

#define R_BE_BBRPT_CHINFO_ERR_IMR 0x9628
#define B_BE_ERR_BB_ONETEN_INT_EN BIT(1)
#define B_BE_ERR_GEN_FRZTO_INT_EN BIT(0)
#define B_BE_BBRPT_CHINFO_ERR_IMR_CLR (B_BE_ERR_GEN_FRZTO_INT_EN | \
				       B_BE_ERR_BB_ONETEN_INT_EN)
#define B_BE_BBRPT_CHINFO_ERR_IMR_SET (B_BE_ERR_GEN_FRZTO_INT_EN | \
				       B_BE_ERR_BB_ONETEN_INT_EN)

#define R_BE_BBRPT_DFS_ERR_IMR 0x9638
#define B_BE_BBRPT_DFS_TO_ERR_INT_EN BIT(0)
#define B_BE_BBRPT_DFS_ERR_IMR_CLR B_BE_BBRPT_DFS_TO_ERR_INT_EN
#define B_BE_BBRPT_DFS_ERR_IMR_SET B_BE_BBRPT_DFS_TO_ERR_INT_EN

#define R_BE_LA_ERRFLAG_IMR 0x9668
#define B_BE_LA_IMR_DATA_LOSS BIT(0)
#define B_BE_LA_ERRFLAG_IMR_CLR B_BE_LA_IMR_DATA_LOSS
#define B_BE_LA_ERRFLAG_IMR_SET B_BE_LA_IMR_DATA_LOSS

#define R_BE_LA_ERRFLAG_ISR 0x966C
#define B_BE_LA_ISR_DATA_LOSS BIT(0)

#define R_BE_CH_INFO_DBGFLAG_IMR 0x9688
#define B_BE_BCHN_EVT01_ISR_EN BIT(29)
#define B_BE_BCHN_REQTO_ISR_EN BIT(28)
#define B_BE_CHIF_RXDATA_AFACT_ISR_EN BIT(11)
#define B_BE_CHIF_RXDATA_BFACT_ISR_EN BIT(10)
#define B_BE_CHIF_HDR_SEGLEN_ISR_EN BIT(9)
#define B_BE_CHIF_HDR_INVLD_ISR_EN BIT(8)
#define B_BE_CHIF_BBONL_BFACT_ISR_EN BIT(4)
#define B_BE_CHIF_RPT_OVF_ISR_EN BIT(3)
#define B_BE_DBG_CHIF_DATA_LOSS_ISR_EN BIT(2)
#define B_BE_CHIF_DATA_WTOUT_ISR_EN BIT(1)
#define B_BE_CHIF_RPT_WTOUT_ISR_EN BIT(0)
#define B_BE_CH_INFO_DBGFLAG_IMR_CLR (B_BE_CHIF_RPT_WTOUT_ISR_EN | \
				      B_BE_CHIF_DATA_WTOUT_ISR_EN | \
				      B_BE_DBG_CHIF_DATA_LOSS_ISR_EN | \
				      B_BE_CHIF_RPT_OVF_ISR_EN | \
				      B_BE_CHIF_HDR_INVLD_ISR_EN | \
				      B_BE_CHIF_HDR_SEGLEN_ISR_EN | \
				      B_BE_CHIF_RXDATA_BFACT_ISR_EN | \
				      B_BE_CHIF_RXDATA_AFACT_ISR_EN)
#define B_BE_CH_INFO_DBGFLAG_IMR_SET 0

#define R_BE_WD_BUF_REQ 0x9800
#define B_BE_WD_BUF_REQ_EXEC BIT(31)
#define B_BE_WD_BUF_REQ_QUOTA_ID_MASK GENMASK(23, 16)
#define B_BE_WD_BUF_REQ_LEN_MASK GENMASK(15, 0)

#define R_BE_WD_BUF_STATUS 0x9804
#define B_BE_WD_BUF_STAT_DONE BIT(31)
#define B_BE_WD_BUF_STAT_PKTID_MASK GENMASK(11, 0)

#define R_BE_WD_CPUQ_OP_0 0x9810
#define B_BE_WD_CPUQ_OP_EXEC BIT(31)
#define B_BE_WD_CPUQ_OP_CMD_TYPE_MASK GENMASK(27, 24)
#define B_BE_WD_CPUQ_OP_PKTNUM_MASK GENMASK(7, 0)

#define R_BE_WD_CPUQ_OP_1 0x9814
#define B_BE_WD_CPUQ_OP_SRC_MACID_MASK GENMASK(19, 12)
#define B_BE_WD_CPUQ_OP_SRC_QID_MASK GENMASK(9, 4)
#define B_BE_WD_CPUQ_OP_SRC_PID_MASK GENMASK(2, 0)

#define R_BE_WD_CPUQ_OP_2 0x9818
#define B_BE_WD_CPUQ_OP_DST_MACID_MASK GENMASK(19, 12)
#define B_BE_WD_CPUQ_OP_DST_QID_MASK GENMASK(9, 4)
#define B_BE_WD_CPUQ_OP_DST_PID_MASK GENMASK(2, 0)

#define R_BE_WD_CPUQ_OP_3 0x981C
#define B_BE_WD_CPUQ_OP_STRT_PKTID_MASK GENMASK(27, 16)
#define B_BE_WD_CPUQ_OP_END_PKTID_MASK GENMASK(11, 0)

#define R_BE_WD_CPUQ_OP_STATUS 0x9820
#define B_BE_WD_CPUQ_OP_STAT_DONE BIT(31)
#define B_BE_WD_CPUQ_OP_PKTCNT_MASK GENMASK(27, 16)
#define B_BE_WD_CPUQ_OP_PKTID_MASK GENMASK(11, 0)

#define R_BE_PL_BUF_REQ 0x9840
#define B_BE_PL_BUF_REQ_EXEC BIT(31)
#define B_BE_PL_BUF_REQ_QUOTA_ID_MASK GENMASK(19, 16)
#define B_BE_PL_BUF_REQ_LEN_MASK GENMASK(15, 0)

#define R_BE_PL_BUF_STATUS 0x9844
#define B_BE_PL_BUF_STAT_DONE BIT(31)
#define B_BE_PL_BUF_STAT_PKTID_MASK GENMASK(11, 0)

#define R_BE_PL_CPUQ_OP_0 0x9850
#define B_BE_PL_CPUQ_OP_EXEC BIT(31)
#define B_BE_PL_CPUQ_OP_CMD_TYPE_MASK GENMASK(27, 24)
#define B_BE_PL_CPUQ_OP_PKTNUM_MASK GENMASK(7, 0)

#define R_BE_PL_CPUQ_OP_1 0x9854
#define B_BE_PL_CPUQ_OP_SRC_MACID_MASK GENMASK(19, 12)
#define B_BE_PL_CPUQ_OP_SRC_QID_MASK GENMASK(9, 4)
#define B_BE_PL_CPUQ_OP_SRC_PID_MASK GENMASK(2, 0)

#define R_BE_PL_CPUQ_OP_2 0x9858
#define B_BE_PL_CPUQ_OP_DST_MACID_MASK GENMASK(19, 12)
#define B_BE_PL_CPUQ_OP_DST_QID_MASK GENMASK(9, 4)
#define B_BE_PL_CPUQ_OP_DST_PID_MASK GENMASK(2, 0)

#define R_BE_PL_CPUQ_OP_3 0x985C
#define B_BE_PL_CPUQ_OP_STRT_PKTID_MASK GENMASK(27, 16)
#define B_BE_PL_CPUQ_OP_END_PKTID_MASK GENMASK(11, 0)

#define R_BE_PL_CPUQ_OP_STATUS 0x9860
#define B_BE_PL_CPUQ_OP_STAT_DONE BIT(31)
#define B_BE_PL_CPUQ_OP_PKTCNT_MASK GENMASK(27, 16)
#define B_BE_PL_CPUQ_OP_PKTID_MASK GENMASK(11, 0)

#define R_BE_CPUIO_ERR_IMR 0x9888
#define B_BE_PLEQUE_OP_ERR_INT_EN BIT(12)
#define B_BE_PLEBUF_OP_ERR_INT_EN BIT(8)
#define B_BE_WDEQUE_OP_ERR_INT_EN BIT(4)
#define B_BE_WDEBUF_OP_ERR_INT_EN BIT(0)
#define B_BE_CPUIO_ERR_IMR_CLR (B_BE_WDEBUF_OP_ERR_INT_EN | \
				B_BE_WDEQUE_OP_ERR_INT_EN | \
				B_BE_PLEBUF_OP_ERR_INT_EN | \
				B_BE_PLEQUE_OP_ERR_INT_EN)
#define B_BE_CPUIO_ERR_IMR_SET (B_BE_WDEBUF_OP_ERR_INT_EN | \
				B_BE_WDEQUE_OP_ERR_INT_EN | \
				B_BE_PLEBUF_OP_ERR_INT_EN | \
				B_BE_PLEQUE_OP_ERR_INT_EN)

#define R_BE_PKTIN_ERR_IMR 0x9A20
#define B_BE_SW_MERGE_ERR_INT_EN BIT(1)
#define B_BE_GET_NULL_PKTID_ERR_INT_EN BIT(0)
#define B_BE_PKTIN_ERR_IMR_CLR (B_BE_SW_MERGE_ERR_INT_EN | \
				B_BE_GET_NULL_PKTID_ERR_INT_EN)
#define B_BE_PKTIN_ERR_IMR_SET (B_BE_SW_MERGE_ERR_INT_EN | \
				B_BE_GET_NULL_PKTID_ERR_INT_EN)

#define R_BE_HDR_SHCUT_SETTING 0x9B00
#define B_BE_TX_ADDR_MLD_TO_LIK BIT(4)
#define B_BE_TX_HW_SEC_HDR_EN BIT(3)
#define B_BE_TX_MAC_MPDU_PROC_EN BIT(2)
#define B_BE_TX_HW_ACK_POLICY_EN BIT(1)
#define B_BE_TX_HW_SEQ_EN BIT(0)

#define R_BE_MPDU_TX_ERR_IMR 0x9BF4
#define B_BE_TX_TIMEOUT_ERR_EN BIT(0)
#define B_BE_MPDU_TX_ERR_IMR_CLR B_BE_TX_TIMEOUT_ERR_EN
#define B_BE_MPDU_TX_ERR_IMR_SET 0

#define R_BE_MPDU_PROC 0x9C00
#define B_BE_PORT_SEL BIT(29)
#define B_BE_WPKT_WLANCPU_QSEL_MASK GENMASK(28, 27)
#define B_BE_WPKT_DATACPU_QSEL_MASK GENMASK(26, 25)
#define B_BE_WPKT_FW_RLS BIT(24)
#define B_BE_FWD_RPKT_MASK GENMASK(23, 16)
#define B_BE_FWD_WPKT_MASK GENMASK(15, 8)
#define B_BE_RXFWD_PRIO_MASK GENMASK(5, 4)
#define B_BE_RXFWD_EN BIT(3)
#define B_BE_DROP_NONDMA_PPDU BIT(2)
#define B_BE_APPEND_FCS BIT(0)

#define R_BE_FWD_ERR 0x9C10
#define R_BE_FWD_ACTN0 0x9C14
#define R_BE_FWD_ACTN1 0x9C18
#define R_BE_FWD_ACTN2 0x9C1C
#define R_BE_FWD_TF0 0x9C20
#define R_BE_FWD_TF1 0x9C24

#define R_BE_HW_PPDU_STATUS 0x9C30
#define B_BE_FWD_RPKTTYPE_MASK GENMASK(31, 26)
#define B_BE_FWD_PPDU_PRTID_MASK GENMASK(25, 23)
#define B_BE_FWD_PPDU_FW_RLS BIT(22)
#define B_BE_FWD_PPDU_QUEID_MASK GENMASK(21, 16)
#define B_BE_FWD_OTHER_RPKT_MASK GENMASK(15, 8)
#define B_BE_FWD_PPDU_STAT_MASK GENMASK(7, 0)

#define R_BE_CUT_AMSDU_CTRL 0x9C94
#define B_BE_EN_CUT_AMSDU BIT(31)
#define B_BE_CUT_AMSDU_CHKLEN_EN BIT(30)
#define B_BE_CA_CHK_ADDRCAM_EN BIT(29)
#define B_BE_MPDU_CUT_CTRL_EN BIT(24)
#define B_BE_CUT_AMSDU_CHKLEN_L_TH_MASK GENMASK(23, 16)
#define B_BE_CUT_AMSDU_CHKLEN_H_TH_MASK GENMASK(15, 0)

#define R_BE_WOW_CTRL 0x9CB8
#define B_BE_WOW_HCI BIT(5)
#define B_BE_WOW_DROP BIT(2)
#define B_BE_WOW_WOWEN BIT(1)
#define B_BE_WOW_FORCE_WAKEUP BIT(0)

#define R_BE_RX_HDRTRNS 0x9CC0
#define B_BE_RX_MGN_MLD_ADDR_EN BIT(6)
#define B_BE_HDR_INFO_MASK GENMASK(5, 4)
#define B_BE_HC_ADDR_HIT_EN BIT(3)
#define B_BE_RX_ADDR_LINK_TO_MLO BIT(2)
#define B_BE_HDR_CNV BIT(1)
#define B_BE_RX_HDR_CNV_EN BIT(0)
#define TRXCFG_MPDU_PROC_RX_HDR_CONV	0x00000000

#define R_BE_MPDU_RX_ERR_IMR 0x9CF4
#define B_BE_LEN_ERR_IMR BIT(3)
#define B_BE_TIMEOUT_ERR_IMR BIT(1)
#define B_BE_MPDU_RX_ERR_IMR_CLR B_BE_TIMEOUT_ERR_IMR
#define B_BE_MPDU_RX_ERR_IMR_SET 0

#define R_BE_SEC_ENG_CTRL 0x9D00
#define B_BE_SEC_ENG_EN BIT(31)
#define B_BE_CCMP_SPP_MIC BIT(30)
#define B_BE_CCMP_SPP_CTR BIT(29)
#define B_BE_SEC_CAM_ACC BIT(28)
#define B_BE_WMAC_SEC_PN_SEL_MASK GENMASK(27, 26)
#define B_BE_WMAC_SEC_MASKIV BIT(25)
#define B_BE_WAPI_SPEC BIT(24)
#define B_BE_REVERT_TA_RA_MLD_EN BIT(23)
#define B_BE_SEC_DBG_SEL_MASK GENMASK(19, 16)
#define B_BE_CAM_FORCE_CLK BIT(15)
#define B_BE_SEC_FORCE_CLK BIT(14)
#define B_BE_SEC_RX_SHORT_ADD_ICVERR BIT(13)
#define B_BE_SRAM_IO_PROT BIT(12)
#define B_BE_SEC_PRE_ENQUE_TX BIT(11)
#define B_BE_CLK_EN_CGCMP BIT(10)
#define B_BE_CLK_EN_WAPI BIT(9)
#define B_BE_CLK_EN_WEP_TKIP BIT(8)
#define B_BE_BMC_MGNT_DEC BIT(5)
#define B_BE_UC_MGNT_DEC BIT(4)
#define B_BE_MC_DEC BIT(3)
#define B_BE_BC_DEC BIT(2)
#define B_BE_SEC_RX_DEC BIT(1)
#define B_BE_SEC_TX_ENC BIT(0)

#define R_BE_SEC_MPDU_PROC 0x9D04
#define B_BE_DBG_ENGINE_SEL BIT(8)
#define B_BE_STOP_RX_PKT_HANDLE BIT(7)
#define B_BE_STOP_TX_PKT_HANDLE BIT(6)
#define B_BE_QUEUE_FOWARD_SEL BIT(5)
#define B_BE_RESP1_PROTECT BIT(4)
#define B_BE_RESP0_PROTECT BIT(3)
#define B_BE_TX_ACTIVE_PROTECT BIT(2)
#define B_BE_APPEND_ICV BIT(1)
#define B_BE_APPEND_MIC BIT(0)

#define R_BE_SEC_CAM_ACCESS 0x9D10
#define B_BE_SEC_TIME_OUT_MASK GENMASK(31, 16)
#define B_BE_SEC_CAM_POLL BIT(15)
#define B_BE_SEC_CAM_RW BIT(14)
#define B_BE_SEC_CAM_ACC_FAIL BIT(13)
#define B_BE_SEC_CAM_OFFSET_MASK GENMASK(10, 0)

#define R_BE_SEC_CAM_RDATA 0x9D14
#define B_BE_SEC_CAM_RDATA_MASK GENMASK(31, 0)

#define R_BE_SEC_DEBUG2 0x9D28
#define B_BE_DBG_READ_MASK GENMASK(31, 0)

#define R_BE_SEC_ERROR_IMR 0x9D2C
#define B_BE_QUEUE_OPERATION_HANG_IMR BIT(4)
#define B_BE_SEC1_RX_HANG_IMR BIT(3)
#define B_BE_SEC1_TX_HANG_IMR BIT(2)
#define B_BE_RX_HANG_IMR BIT(1)
#define B_BE_TX_HANG_IMR BIT(0)
#define B_BE_SEC_ERROR_IMR_CLR (B_BE_TX_HANG_IMR | \
				B_BE_RX_HANG_IMR | \
				B_BE_SEC1_TX_HANG_IMR | \
				B_BE_SEC1_RX_HANG_IMR | \
				B_BE_QUEUE_OPERATION_HANG_IMR)
#define B_BE_SEC_ERROR_IMR_SET (B_BE_TX_HANG_IMR | \
				B_BE_RX_HANG_IMR | \
				B_BE_SEC1_TX_HANG_IMR | \
				B_BE_SEC1_RX_HANG_IMR | \
				B_BE_QUEUE_OPERATION_HANG_IMR)

#define R_BE_SEC_ERROR_FLAG 0x9D30
#define B_BE_TXD_DIFF_KEYCAM_TYPE_ERROR BIT(5)
#define B_BE_QUEUE_OPERATION_HANG_ERROR BIT(4)
#define B_BE_SEC1_RX_HANG_ERROR BIT(3)
#define B_BE_SEC1_TX_HANG_ERROR BIT(2)
#define B_BE_RX_HANG_ERROR BIT(1)
#define B_BE_TX_HANG_ERROR BIT(0)

#define R_BE_TXPKTCTL_MPDUINFO_CFG 0x9F10
#define B_BE_MPDUINFO_FEN BIT(31)
#define B_BE_MPDUINFO_PKTID_MASK GENMASK(27, 16)
#define B_BE_MPDUINFO_B1_BADDR_MASK GENMASK(5, 0)
#define MPDU_INFO_B1_OFST 18
#define MPDU_INFO_TBL_FACTOR 3

#define R_BE_TXPKTCTL_B0_PRELD_CFG0 0x9F48
#define B_BE_B0_PRELD_FEN BIT(31)
#define B_BE_B0_PRELD_USEMAXSZ_MASK GENMASK(25, 16)
#define B_BE_B0_PRELD_CAM_G1ENTNUM_MASK GENMASK(12, 8)
#define PRELD_MISCQ_ENT_NUM_8922A 2
#define PRELD_MISCQ_ENT_NUM_8922D 1
#define B_BE_B0_PRELD_CAM_G0ENTNUM_MASK GENMASK(4, 0)
#define PRELD_B0_ACQ_ENT_NUM_8922A 8
#define PRELD_B1_ACQ_ENT_NUM_8922A 2
#define PRELD_ACQ_ENT_NUM_8922D 1

#define R_BE_TXPKTCTL_B0_PRELD_CFG1 0x9F4C
#define B_BE_B0_PRELD_NXT_TXENDWIN_MASK GENMASK(11, 8)
#define B_BE_B0_PRELD_NXT_RSVMINSZ_MASK GENMASK(7, 0)

#define R_BE_TXPKTCTL_B0_ERRFLAG_IMR 0x9F78
#define B_BE_B0_IMR_DBG_USRCTL_RLSBMPLEN BIT(25)
#define B_BE_B0_IMR_DBG_USRCTL_RDNRLSCMD BIT(24)
#define B_BE_B0_IMR_ERR_PRELD_ENTNUMCFG BIT(17)
#define B_BE_B0_IMR_ERR_PRELD_RLSPKTSZERR BIT(16)
#define B_BE_B0_IMR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_BE_B0_IMR_ERR_CMDPSR_FRZTO BIT(10)
#define B_BE_B0_IMR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_BE_B0_IMR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_BE_B0_IMR_ERR_USRCTL_NOINIT BIT(1)
#define B_BE_B0_IMR_ERR_USRCTL_REINIT BIT(0)
#define B_BE_TXPKTCTL_B0_ERRFLAG_IMR_CLR (B_BE_B0_IMR_ERR_USRCTL_REINIT | \
					  B_BE_B0_IMR_ERR_USRCTL_NOINIT | \
					  B_BE_B0_IMR_DBG_USRCTL_RDNRLSCMD | \
					  B_BE_B0_IMR_DBG_USRCTL_RLSBMPLEN | \
					  B_BE_B0_IMR_ERR_CMDPSR_1STCMDERR | \
					  B_BE_B0_IMR_ERR_CMDPSR_CMDTYPE | \
					  B_BE_B0_IMR_ERR_CMDPSR_FRZTO | \
					  B_BE_B0_IMR_ERR_CMDPSR_TBLSZ | \
					  B_BE_B0_IMR_ERR_PRELD_RLSPKTSZERR | \
					  B_BE_B0_IMR_ERR_PRELD_ENTNUMCFG)
#define B_BE_TXPKTCTL_B0_ERRFLAG_IMR_SET (B_BE_B0_IMR_ERR_USRCTL_REINIT | \
					  B_BE_B0_IMR_ERR_USRCTL_NOINIT | \
					  B_BE_B0_IMR_ERR_CMDPSR_1STCMDERR | \
					  B_BE_B0_IMR_ERR_CMDPSR_CMDTYPE | \
					  B_BE_B0_IMR_ERR_CMDPSR_FRZTO | \
					  B_BE_B0_IMR_ERR_CMDPSR_TBLSZ | \
					  B_BE_B0_IMR_ERR_PRELD_RLSPKTSZERR | \
					  B_BE_B0_IMR_ERR_PRELD_ENTNUMCFG)

#define R_BE_TXPKTCTL_B1_PRELD_CFG0 0x9F88
#define B_BE_B1_PRELD_FEN BIT(31)
#define B_BE_B1_PRELD_USEMAXSZ_MASK GENMASK(25, 16)
#define B_BE_B1_PRELD_CAM_G1ENTNUM_MASK GENMASK(12, 8)
#define B_BE_B1_PRELD_CAM_G0ENTNUM_MASK GENMASK(4, 0)

#define R_BE_TXPKTCTL_B1_PRELD_CFG1 0x9F8C
#define B_BE_B1_PRELD_NXT_TXENDWIN_MASK GENMASK(11, 8)
#define B_BE_B1_PRELD_NXT_RSVMINSZ_MASK GENMASK(7, 0)

#define R_BE_TXPKTCTL_B1_ERRFLAG_IMR 0x9FB8
#define B_BE_B1_IMR_DBG_USRCTL_RLSBMPLEN BIT(25)
#define B_BE_B1_IMR_DBG_USRCTL_RDNRLSCMD BIT(24)
#define B_BE_B1_IMR_ERR_PRELD_ENTNUMCFG BIT(17)
#define B_BE_B1_IMR_ERR_PRELD_RLSPKTSZERR BIT(16)
#define B_BE_B1_IMR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_BE_B1_IMR_ERR_CMDPSR_FRZTO BIT(10)
#define B_BE_B1_IMR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_BE_B1_IMR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_BE_B1_IMR_ERR_USRCTL_NOINIT BIT(1)
#define B_BE_B1_IMR_ERR_USRCTL_REINIT BIT(0)
#define B_BE_TXPKTCTL_B1_ERRFLAG_IMR_CLR (B_BE_B1_IMR_ERR_USRCTL_REINIT | \
					  B_BE_B1_IMR_ERR_USRCTL_NOINIT | \
					  B_BE_B1_IMR_DBG_USRCTL_RDNRLSCMD | \
					  B_BE_B1_IMR_DBG_USRCTL_RLSBMPLEN | \
					  B_BE_B1_IMR_ERR_CMDPSR_1STCMDERR | \
					  B_BE_B1_IMR_ERR_CMDPSR_CMDTYPE | \
					  B_BE_B1_IMR_ERR_CMDPSR_FRZTO | \
					  B_BE_B1_IMR_ERR_CMDPSR_TBLSZ | \
					  B_BE_B1_IMR_ERR_PRELD_RLSPKTSZERR | \
					  B_BE_B1_IMR_ERR_PRELD_ENTNUMCFG)
#define B_BE_TXPKTCTL_B1_ERRFLAG_IMR_SET (B_BE_B1_IMR_ERR_USRCTL_REINIT | \
					  B_BE_B1_IMR_ERR_USRCTL_NOINIT | \
					  B_BE_B1_IMR_ERR_CMDPSR_1STCMDERR | \
					  B_BE_B1_IMR_ERR_CMDPSR_CMDTYPE | \
					  B_BE_B1_IMR_ERR_CMDPSR_FRZTO | \
					  B_BE_B1_IMR_ERR_CMDPSR_TBLSZ | \
					  B_BE_B1_IMR_ERR_PRELD_RLSPKTSZERR | \
					  B_BE_B1_IMR_ERR_PRELD_ENTNUMCFG)

#define R_BE_MLO_INIT_CTL 0xA114
#define B_BE_MLO_TABLE_INIT_DONE BIT(31)
#define B_BE_MLO_TABLE_CLR_DONE BIT(30)
#define B_BE_MLO_TABLE_REINIT BIT(23)
#define B_BE_MLO_TABLE_HW_FLAG_CLR BIT(22)

#define R_BE_MLO_ERR_IDCT_IMR 0xA128
#define B_BE_MLO_ERR_IDCT_IMR_0 BIT(31)
#define B_BE_MLO_ERR_IDCT_IMR_1 BIT(30)
#define B_BE_MLO_ERR_IDCT_IMR_2 BIT(29)
#define B_BE_MLO_ERR_IDCT_IMR_3 BIT(28)
#define B_BE_MLO_ERR_IDCT_IMR_CLR (B_BE_MLO_ERR_IDCT_IMR_2 | \
				   B_BE_MLO_ERR_IDCT_IMR_1 | \
				   B_BE_MLO_ERR_IDCT_IMR_0)
#define B_BE_MLO_ERR_IDCT_IMR_SET (B_BE_MLO_ERR_IDCT_IMR_2 | \
				   B_BE_MLO_ERR_IDCT_IMR_1 | \
				   B_BE_MLO_ERR_IDCT_IMR_0)

#define R_BE_MLO_ERR_IDCT_ISR 0xA12C
#define B_BE_MLO_ISR_IDCT_0 BIT(31)
#define B_BE_MLO_ISR_IDCT_1 BIT(30)
#define B_BE_MLO_ISR_IDCT_2 BIT(29)
#define B_BE_MLO_ISR_IDCT_3 BIT(28)

#define R_BE_PLRLS_ERR_IMR 0xA218
#define B_BE_PLRLS_CTL_FRZTO_IMR BIT(0)
#define B_BE_PLRLS_ERR_IMR_CLR B_BE_PLRLS_CTL_FRZTO_IMR
#define B_BE_PLRLS_ERR_IMR_SET B_BE_PLRLS_CTL_FRZTO_IMR

#define R_BE_PLRLS_ERR_ISR 0xA21C
#define B_BE_PLRLS_CTL_EVT03_ISR BIT(3)
#define B_BE_PLRLS_CTL_EVT02_ISR BIT(2)
#define B_BE_PLRLS_CTL_EVT01_ISR BIT(1)
#define B_BE_PLRLS_CTL_FRZTO_ISR BIT(0)

#define R_BE_SS_CTRL 0xA310
#define R_BE_SS_CTRL_V1 0xA610
#define B_BE_SS_INIT_DONE BIT(31)
#define B_BE_WDE_STA_DIS BIT(30)
#define B_BE_WARM_INIT BIT(29)
#define B_BE_BAND_TRIG_EN BIT(28)
#define B_BE_RMAC_REQ_DIS BIT(27)
#define B_BE_DLYTX_SEL_MASK GENMASK(25, 24)
#define B_BE_WMM3_SWITCH_MASK GENMASK(23, 22)
#define B_BE_WMM2_SWITCH_MASK GENMASK(21, 20)
#define B_BE_WMM1_SWITCH_MASK GENMASK(19, 18)
#define B_BE_WMM0_SWITCH_MASK GENMASK(17, 16)
#define B_BE_STA_OPTION_CR BIT(15)
#define B_BE_EMLSR_STA_EMPTY_EN BIT(11)
#define B_BE_MLO_HW_CHGLINK_EN BIT(10)
#define B_BE_BAND1_TRIG_EN BIT(9)
#define B_BE_RMAC1_REQ_DIS BIT(8)
#define B_BE_MRT_SRAM_EN BIT(7)
#define B_BE_MRT_INIT_EN BIT(6)
#define B_BE_AVG_LENG_EN BIT(5)
#define B_BE_AVG_INIT_EN BIT(4)
#define B_BE_LENG_INIT_EN BIT(2)
#define B_BE_PMPA_INIT_EN BIT(1)
#define B_BE_SS_EN BIT(0)

#define R_BE_INTERRUPT_MASK_REG 0xA3F0
#define B_BE_PLE_B_PKTID_ERR_IMR BIT(2)
#define B_BE_RPT_TIMEOUT_IMR BIT(1)
#define B_BE_SEARCH_TIMEOUT_IMR BIT(0)
#define B_BE_INTERRUPT_MASK_REG_CLR (B_BE_SEARCH_TIMEOUT_IMR | \
				     B_BE_RPT_TIMEOUT_IMR | \
				     B_BE_PLE_B_PKTID_ERR_IMR)
#define B_BE_INTERRUPT_MASK_REG_SET (B_BE_SEARCH_TIMEOUT_IMR | \
				     B_BE_RPT_TIMEOUT_IMR | \
				     B_BE_PLE_B_PKTID_ERR_IMR)

#define R_BE_INTERRUPT_STS_REG 0xA3F4
#define B_BE_PLE_B_PKTID_ERR_ISR BIT(2)
#define B_BE_RPT_TIMEOUT_ISR BIT(1)
#define B_BE_SEARCH_TIMEOUT_ISR BIT(0)

#define R_BE_PLRLS_ERR_IMR_V1 0xA518
#define B_BE_PLRLS_DUMMY_ISR6 BIT(7)
#define B_BE_PLRLS_DUMMY_ISR5 BIT(6)
#define B_BE_PLRLS_DUMMY_ISR4 BIT(5)
#define B_BE_PLRLS_DUMMY_ISR3 BIT(4)
#define B_BE_PLRLS_DUMMY_ISR2 BIT(3)
#define B_BE_PLRLS_DUMMY_ISR1 BIT(2)
#define B_BE_PLRLS_DUMMY_ISR0 BIT(1)
#define B_BE_PLRLS_ERR_IMR_V1_CLR 0x1
#define B_BE_PLRLS_ERR_IMR_V1_SET 0x1

#define R_BE_SS_LITE_TXL_MACID 0xA790
#define B_BE_RPT_OTHER_BAND_EN BIT(31)
#define B_BE_TXL_CMD_EN BIT(30)
#define B_BE_TXL_READ_MACID_MASK GENMASK(29, 20)
#define B_BE_TXL_MACID_1_MASK GENMASK(19, 10)
#define B_BE_TXL_MACID_0_MASK GENMASK(9, 0)

#define R_BE_HAXI_INIT_CFG1 0xB000
#define B_BE_CFG_WD_PERIOD_IDLE_MASK GENMASK(31, 28)
#define B_BE_CFG_WD_PERIOD_ACTIVE_MASK GENMASK(27, 24)
#define B_BE_EN_RO_IDX_UPD_BY_IO BIT(19)
#define B_BE_RST_KEEP_REG BIT(18)
#define B_BE_FLUSH_HAXI_MST BIT(17)
#define B_BE_SET_BDRAM_BOUND BIT(16)
#define B_BE_ADDRINFO_ALIGN4B_EN BIT(15)
#define B_BE_RXBD_DONE_MODE_MASK GENMASK(14, 13)
#define B_BE_RXQ_RXBD_MODE_MASK GENMASK(12, 11)
#define B_BE_DMA_MODE_MASK GENMASK(10, 8)
#define S_BE_DMA_MOD_PCIE_NO_DATA_CPU 0x0
#define S_BE_DMA_MOD_PCIE_DATA_CPU 0x1
#define S_BE_DMA_MOD_USB 0x4
#define S_BE_DMA_MOD_SDIO 0x6
#define B_BE_STOP_AXI_MST BIT(7)
#define B_BE_RXDMA_ALIGN64B_EN BIT(6)
#define B_BE_RXDMA_EN BIT(5)
#define B_BE_TXDMA_EN BIT(4)
#define B_BE_MAX_RXDMA_MASK GENMASK(3, 2)
#define B_BE_MAX_TXDMA_MASK GENMASK(1, 0)

#define R_BE_HAXI_DMA_STOP1 0xB010
#define B_BE_STOP_WPDMA BIT(31)
#define B_BE_STOP_CH14 BIT(14)
#define B_BE_STOP_CH13 BIT(13)
#define B_BE_STOP_CH12 BIT(12)
#define B_BE_STOP_CH11 BIT(11)
#define B_BE_STOP_CH10 BIT(10)
#define B_BE_STOP_CH9 BIT(9)
#define B_BE_STOP_CH8 BIT(8)
#define B_BE_STOP_CH7 BIT(7)
#define B_BE_STOP_CH6 BIT(6)
#define B_BE_STOP_CH5 BIT(5)
#define B_BE_STOP_CH4 BIT(4)
#define B_BE_STOP_CH3 BIT(3)
#define B_BE_STOP_CH2 BIT(2)
#define B_BE_STOP_CH1 BIT(1)
#define B_BE_STOP_CH0 BIT(0)
#define B_BE_TX_STOP1_MASK (B_BE_STOP_CH0 | B_BE_STOP_CH1 | \
			    B_BE_STOP_CH2 | B_BE_STOP_CH3 | \
			    B_BE_STOP_CH4 | B_BE_STOP_CH5 | \
			    B_BE_STOP_CH6 | B_BE_STOP_CH7 | \
			    B_BE_STOP_CH8 | B_BE_STOP_CH9 | \
			    B_BE_STOP_CH10 | B_BE_STOP_CH11 | \
			    B_BE_STOP_CH12 | B_BE_STOP_CH13 | \
			    B_BE_STOP_CH14)
#define B_BE_TX_STOP1_MASK_V1 (B_BE_STOP_CH0 | B_BE_STOP_CH2 | \
			       B_BE_STOP_CH4 | B_BE_STOP_CH6 | \
			       B_BE_STOP_CH8 | B_BE_STOP_CH10 | \
			       B_BE_STOP_CH12)

#define R_BE_HAXI_MST_WDT_TIMEOUT_SEL_V1 0xB02C
#define B_BE_HAXI_MST_WDT_TIMEOUT_SEL_MASK GENMASK(4, 0)

#define R_BE_HAXI_IDCT_MSK 0xB0B8
#define B_BE_HAXI_RRESP_ERR_IDCT_MSK BIT(7)
#define B_BE_HAXI_BRESP_ERR_IDCT_MSK BIT(6)
#define B_BE_RXDMA_ERR_FLAG_IDCT_MSK BIT(5)
#define B_BE_SET_FC_ERROR_FLAG_IDCT_MSK BIT(4)
#define B_BE_TXBD_LEN0_ERR_IDCT_MSK BIT(3)
#define B_BE_TXBD_4KBOUND_ERR_IDCT_MSK BIT(2)
#define B_BE_RXMDA_STUCK_IDCT_MSK BIT(1)
#define B_BE_TXMDA_STUCK_IDCT_MSK BIT(0)
#define B_BE_HAXI_IDCT_MSK_CLR (B_BE_TXMDA_STUCK_IDCT_MSK | \
				B_BE_RXMDA_STUCK_IDCT_MSK | \
				B_BE_TXBD_LEN0_ERR_IDCT_MSK | \
				B_BE_SET_FC_ERROR_FLAG_IDCT_MSK | \
				B_BE_RXDMA_ERR_FLAG_IDCT_MSK | \
				B_BE_HAXI_BRESP_ERR_IDCT_MSK | \
				B_BE_HAXI_RRESP_ERR_IDCT_MSK)
#define B_BE_HAXI_IDCT_MSK_SET (B_BE_TXMDA_STUCK_IDCT_MSK | \
				B_BE_RXMDA_STUCK_IDCT_MSK | \
				B_BE_TXBD_LEN0_ERR_IDCT_MSK | \
				B_BE_SET_FC_ERROR_FLAG_IDCT_MSK | \
				B_BE_RXDMA_ERR_FLAG_IDCT_MSK | \
				B_BE_HAXI_BRESP_ERR_IDCT_MSK | \
				B_BE_HAXI_RRESP_ERR_IDCT_MSK)

#define R_BE_HAXI_IDCT 0xB0BC
#define B_BE_HAXI_RRESP_ERR_IDCT BIT(7)
#define B_BE_HAXI_BRESP_ERR_IDCT BIT(6)
#define B_BE_RXDMA_ERR_FLAG_IDCT BIT(5)
#define B_BE_SET_FC_ERROR_FLAG_IDCT BIT(4)
#define B_BE__TXBD_LEN0_ERR_IDCT BIT(3)
#define B_BE__TXBD_4KBOUND_ERR_IDCT BIT(2)
#define B_BE_RXMDA_STUCK_IDCT BIT(1)
#define B_BE_TXMDA_STUCK_IDCT BIT(0)

#define R_BE_HCI_FC_CTRL 0xB700
#define B_BE_WD_PAGE_MODE_MASK GENMASK(17, 16)
#define B_BE_HCI_FC_CH14_FULL_COND_MASK GENMASK(15, 14)
#define B_BE_HCI_FC_TWD_FULL_COND_MASK GENMASK(13, 12)
#define B_BE_HCI_FC_CH12_FULL_COND_MASK GENMASK(11, 10)
#define B_BE_HCI_FC_WP_CH811_FULL_COND_MASK GENMASK(9, 8)
#define B_BE_HCI_FC_WP_CH07_FULL_COND_MASK GENMASK(7, 6)
#define B_BE_HCI_FC_WD_FULL_COND_MASK GENMASK(5, 4)
#define B_BE_HCI_FC_CH12_EN BIT(3)
#define B_BE_HCI_FC_MODE_MASK GENMASK(2, 1)
#define B_BE_HCI_FC_EN BIT(0)

#define R_BE_CH_PAGE_CTRL 0xB704
#define B_BE_PREC_PAGE_CH12_V1_MASK GENMASK(21, 16)
#define B_BE_FULL_WD_PG_MASK GENMASK(15, 8)
#define B_BE_PREC_PAGE_CH011_V1_MASK GENMASK(5, 0)

#define R_BE_CH0_PAGE_CTRL 0xB718
#define B_BE_CH0_GRP BIT(31)
#define B_BE_CH0_MAX_PG_MASK GENMASK(28, 16)
#define B_BE_CH0_MIN_PG_MASK GENMASK(12, 0)

#define R_BE_CH0_PAGE_INFO 0xB750
#define B_BE_CH0_AVAL_PG_MASK GENMASK(28, 16)
#define B_BE_CH0_USE_PG_MASK GENMASK(12, 0)

#define R_BE_PUB_PAGE_INFO3 0xB78C
#define B_BE_G1_AVAL_PG_MASK GENMASK(28, 16)
#define B_BE_G0_AVAL_PG_MASK GENMASK(12, 0)

#define R_BE_PUB_PAGE_CTRL1 0xB790
#define B_BE_PUBPG_G1_MASK GENMASK(28, 16)
#define B_BE_PUBPG_G0_MASK GENMASK(12, 0)

#define R_BE_PUB_PAGE_CTRL2 0xB794
#define B_BE_PUBPG_ALL_MASK GENMASK(12, 0)

#define R_BE_PUB_PAGE_INFO1 0xB79C
#define B_BE_G1_USE_PG_MASK GENMASK(28, 16)
#define B_BE_G0_USE_PG_MASK GENMASK(12, 0)

#define R_BE_PUB_PAGE_INFO2 0xB7A0
#define B_BE_PUB_AVAL_PG_MASK GENMASK(12, 0)

#define R_BE_WP_PAGE_CTRL1 0xB7A4
#define B_BE_PREC_PAGE_WP_CH811_MASK GENMASK(24, 16)
#define B_BE_PREC_PAGE_WP_CH07_MASK GENMASK(8, 0)
#define B_BE_FULL_PAGE_WP_CH811_MASK GENMASK(31, 24)
#define B_BE_PREC_PAGE_WP_CH811_V1_MASK GENMASK(23, 16)
#define B_BE_FULL_PAGE_WP_CH07_MASK GENMASK(15, 8)
#define B_BE_PREC_PAGE_WP_CH07_V1_MASK GENMASK(7, 0)

#define R_BE_WP_PAGE_CTRL2 0xB7A8
#define B_BE_WP_THRD_MASK GENMASK(12, 0)

#define R_BE_WP_PAGE_INFO1 0xB7AC
#define B_BE_WP_AVAL_PG_MASK GENMASK(28, 16)

#define R_BE_LTPC_T0_PATH0 0xBA28
#define R_BE_LTPC_T0_PATH1 0xBB28

#define R_BE_CMAC_SHARE_FUNC_EN 0x0E000
#define B_BE_CMAC_SHARE_CRPRT BIT(31)
#define B_BE_CMAC_SHARE_EN BIT(30)
#define B_BE_FORCE_BTCOEX_REG_GCKEN BIT(24)
#define B_BE_FORCE_CMAC_SHARE_COMMON_REG_GCKEN BIT(16)
#define B_BE_FORCE_CMAC_SHARE_REG_GCKEN BIT(15)
#define B_BE_RESPBA_EN BIT(2)
#define B_BE_ADDRSRCH_EN BIT(1)
#define B_BE_BTCOEX_EN BIT(0)

#define R_BE_CMAC_SHARE_ACQCHK_CFG_0 0x0E010
#define B_BE_ACQCHK_ERR_FLAG_MASK GENMASK(31, 24)
#define B_BE_R_ACQCHK_ENTRY_IDX_SEL_MASK GENMASK(7, 4)
#define B_BE_MACID_ACQ_GRP1_CLR_P BIT(3)
#define B_BE_MACID_ACQ_GRP0_CLR_P BIT(2)
#define B_BE_R_MACID_ACQ_CHK_EN BIT(0)

#define R_BE_BTC_CFG 0x0E300
#define R_BE_BT_BREAK_TABLE 0x0E344

#define R_BE_GNT_SW_CTRL 0x0E348
#define B_BE_WL_ACT2_VAL BIT(25)
#define B_BE_WL_ACT2_SWCTRL BIT(24)
#define B_BE_WL_ACT_VAL BIT(23)
#define B_BE_WL_ACT_SWCTRL BIT(22)
#define B_BE_GNT_BT_RX_BB1_VAL BIT(21)
#define B_BE_GNT_BT_RX_BB1_SWCTRL BIT(20)
#define B_BE_GNT_BT_TX_BB1_VAL BIT(19)
#define B_BE_GNT_BT_TX_BB1_SWCTRL BIT(18)
#define B_BE_GNT_BT_RX_BB0_VAL BIT(17)
#define B_BE_GNT_BT_RX_BB0_SWCTRL BIT(16)
#define B_BE_GNT_BT_TX_BB0_VAL BIT(15)
#define B_BE_GNT_BT_TX_BB0_SWCTRL BIT(14)
#define B_BE_GNT_WL_RX_VAL BIT(13)
#define B_BE_GNT_WL_RX_SWCTRL BIT(12)
#define B_BE_GNT_WL_TX_VAL BIT(11)
#define B_BE_GNT_WL_TX_SWCTRL BIT(10)
#define B_BE_GNT_BT_BB1_VAL BIT(9)
#define B_BE_GNT_BT_BB1_SWCTRL BIT(8)
#define B_BE_GNT_WL_BB1_VAL BIT(7)
#define B_BE_GNT_WL_BB1_SWCTRL BIT(6)
#define B_BE_GNT_BT_BB0_VAL BIT(5)
#define B_BE_GNT_BT_BB0_SWCTRL BIT(4)
#define B_BE_GNT_WL_BB0_VAL BIT(3)
#define B_BE_GNT_WL_BB0_SWCTRL BIT(2)
#define B_BE_GNT_WL_BB_PWR_VAL BIT(1)
#define B_BE_GNT_WL_BB_PWR_SWCTRL BIT(0)

#define R_BE_PTA_GNT_SW_CTRL 0x0E348
#define B_BE_PTA_WL_ACT0_VAL BIT(19)
#define B_BE_PTA_WL_ACT0_SWCTRL BIT(18)
#define B_BE_PTA_GNT_BT0_RX_BB1_VAL BIT(17)
#define B_BE_PTA_GNT_BT0_RX_BB1_SWCTRL BIT(16)
#define B_BE_PTA_GNT_BT0_TX_BB1_VAL BIT(15)
#define B_BE_PTA_GNT_BT0_TX_BB1_SWCTRL BIT(14)
#define B_BE_PTA_GNT_BT0_RX_BB0_VAL BIT(13)
#define B_BE_PTA_GNT_BT0_RX_BB0_SWCTRL BIT(12)
#define B_BE_PTA_GNT_BT0_TX_BB0_VAL BIT(11)
#define B_BE_PTA_GNT_BT0_TX_BB0_SWCTRL BIT(10)
#define B_BE_PTA_GNT_BT0_BB_VAL BIT(9)
#define B_BE_PTA_GNT_BT0_BB_SWCTRL BIT(8)
#define B_BE_PTA_WL_ACT_RX_BT0_VAL BIT(7)
#define B_BE_PTA_WL_ACT_RX_BT0_SWCTRL BIT(6)
#define B_BE_PTA_WL_ACT_TX_BT0_VAL BIT(5)
#define B_BE_PTA_WL_ACT_TX_BT0_SWCTRL BIT(4)
#define B_BE_PTA_GNT_WL_BB1_VAL BIT(3)
#define B_BE_PTA_GNT_WL_BB1_SWCTRL BIT(2)
#define B_BE_PTA_GNT_WL_BB0_VAL BIT(1)
#define B_BE_PTA_GNT_WL_BB0_SWCTRL BIT(0)

#define R_BE_PTA_GNT_VAL 0x0E34C
#define B_BE_PTA_WL_ACT2 BIT(20)
#define B_BE_PTA_GNT_ZB_TX_BB1 BIT(19)
#define B_BE_PTA_GNT_ZB_TX_BB0 BIT(18)
#define B_BE_PTA_WL_ACT1 BIT(17)
#define B_BE_PTA_GNT_BT1_RX_BB1 BIT(16)
#define B_BE_PTA_GNT_BT1_RX_BB0 BIT(15)
#define B_BE_PTA_GNT_BT1_TX_BB1 BIT(14)
#define B_BE_PTA_GNT_BT1_TX_BB0 BIT(13)
#define B_BE_PTA_WL_ACT_RX_BT1 BIT(12)
#define B_BE_PTA_WL_ACT_TX_BT1 BIT(11)
#define B_BE_PTA_GNT_BT1_BB BIT(10)
#define B_BE_PTA_WL_ACT0 BIT(9)
#define B_BE_PTA_GNT_BT0_RX_BB1 BIT(8)
#define B_BE_PTA_GNT_BT0_TX_BB1 BIT(7)
#define B_BE_PTA_GNT_BT0_RX_BB0 BIT(6)
#define B_BE_PTA_GNT_BT0_TX_BB0 BIT(5)
#define B_BE_PTA_GNT_BT0_BB BIT(4)
#define B_BE_PTA_WL_ACT_RX_BT0 BIT(3)
#define B_BE_PTA_WL_ACT_TX_BT0 BIT(2)
#define B_BE_PTA_GNT_WL_BB1 BIT(1)
#define B_BE_PTA_GNT_WL_BB0 BIT(0)

#define R_BE_PTA_GNT_ZL_SW_CTRL 0x0E350
#define B_BE_PTA_WL_ACT2_VAL BIT(21)
#define B_BE_PTA_WL_ACT2_SWCTRL BIT(20)
#define B_BE_PTA_GNT_ZB_TX_BB1_VAL BIT(19)
#define B_BE_PTA_GNT_ZB_TX_BB1_SWCTRL BIT(18)
#define B_BE_PTA_GNT_ZB_TX_BB0_VAL BIT(17)
#define B_BE_PTA_GNT_ZB_TX_BB0_SWCTRL BIT(16)
#define B_BE_PTA_WL_ACT1_VAL BIT(15)
#define B_BE_PTA_WL_ACT1_SWCTRL BIT(14)
#define B_BE_PTA_GNT_BT1_RX_BB1_VAL BIT(13)
#define B_BE_PTA_GNT_BT1_RX_BB1_SWCTRL BIT(12)
#define B_BE_PTA_GNT_BT1_RX_BB0_VAL BIT(11)
#define B_BE_PTA_GNT_BT1_RX_BB0_SWCTRL BIT(10)
#define B_BE_PTA_GNT_BT1_TX_BB1_VAL BIT(9)
#define B_BE_PTA_GNT_BT1_TX_BB1_SWCTRL BIT(8)
#define B_BE_PTA_GNT_BT1_TX_BB0_VAL BIT(7)
#define B_BE_PTA_GNT_BT1_TX_BB0_SWCTRL BIT(6)
#define B_BE_PTA_WL_ACT_RX_BT1_VAL BIT(5)
#define B_BE_PTA_WL_ACT_RX_BT1_SWCTRL BIT(4)
#define B_BE_PTA_WL_ACT_TX_BT1_VAL BIT(3)
#define B_BE_PTA_WL_ACT_TX_BT1_SWCTRL BIT(2)
#define B_BE_PTA_GNT_BT1_BB_VAL BIT(1)
#define B_BE_PTA_GNT_BT1_BB_SWCTRL BIT(0)

#define R_BE_PWR_MACID_PATH_BASE 0x0E500
#define R_BE_PWR_MACID_PATH_BASE_V1 0x1C000
#define R_BE_PWR_MACID_LMT_BASE 0x0ED00
#define R_BE_PWR_MACID_LMT_BASE_V1 0x1C800

#define R_BE_CMAC_FUNC_EN 0x10000
#define R_BE_CMAC_FUNC_EN_C1 0x14000
#define B_BE_CMAC_CRPRT BIT(31)
#define B_BE_CMAC_EN BIT(30)
#define B_BE_CMAC_TXEN BIT(29)
#define B_BE_CMAC_RXEN BIT(28)
#define B_BE_FORCE_RESP_PKTCTL_GCKEN BIT(26)
#define B_BE_FORCE_SIGB_REG_GCKEN BIT(25)
#define B_BE_FORCE_POWER_REG_GCKEN BIT(23)
#define B_BE_FORCE_RMAC_REG_GCKEN BIT(22)
#define B_BE_FORCE_TRXPTCL_REG_GCKEN BIT(21)
#define B_BE_FORCE_TMAC_REG_GCKEN BIT(20)
#define B_BE_FORCE_CMAC_DMA_REG_GCKEN BIT(19)
#define B_BE_FORCE_PTCL_REG_GCKEN BIT(18)
#define B_BE_FORCE_SCHEDULER_RREG_GCKEN BIT(17)
#define B_BE_FORCE_CMAC_COMMON_REG_GCKEN BIT(16)
#define B_BE_FORCE_CMACREG_GCKEN BIT(15)
#define B_BE_TXTIME_EN BIT(8)
#define B_BE_RESP_PKTCTL_EN BIT(7)
#define B_BE_SIGB_EN BIT(6)
#define B_BE_PHYINTF_EN BIT(5)
#define B_BE_CMAC_DMA_EN BIT(4)
#define B_BE_PTCLTOP_EN BIT(3)
#define B_BE_SCHEDULER_EN BIT(2)
#define B_BE_TMAC_EN BIT(1)
#define B_BE_RMAC_EN BIT(0)
#define B_BE_CMAC_FUNC_EN_SET (B_BE_CMAC_EN | B_BE_CMAC_TXEN | B_BE_CMAC_RXEN | \
			       B_BE_PHYINTF_EN | B_BE_CMAC_DMA_EN | B_BE_PTCLTOP_EN | \
			       B_BE_SCHEDULER_EN | B_BE_TMAC_EN | B_BE_RMAC_EN | \
			       B_BE_CMAC_CRPRT | B_BE_TXTIME_EN | B_BE_RESP_PKTCTL_EN | \
			       B_BE_SIGB_EN)

#define R_BE_CK_EN 0x10004
#define R_BE_CK_EN_C1 0x14004
#define B_BE_CMAC_CKEN BIT(30)
#define B_BE_BCN_P1_P4_CKEN BIT(15)
#define B_BE_BCN_P0MB1_15_CKEN BIT(14)
#define B_BE_TXTIME_CKEN BIT(8)
#define B_BE_RESP_PKTCTL_CKEN BIT(7)
#define B_BE_SIGB_CKEN BIT(6)
#define B_BE_PHYINTF_CKEN BIT(5)
#define B_BE_CMAC_DMA_CKEN BIT(4)
#define B_BE_PTCLTOP_CKEN BIT(3)
#define B_BE_SCHEDULER_CKEN BIT(2)
#define B_BE_TMAC_CKEN BIT(1)
#define B_BE_RMAC_CKEN BIT(0)
#define B_BE_CK_EN_SET (B_BE_CMAC_CKEN | B_BE_PHYINTF_CKEN | B_BE_CMAC_DMA_CKEN | \
			B_BE_PTCLTOP_CKEN | B_BE_SCHEDULER_CKEN | B_BE_TMAC_CKEN | \
			B_BE_RMAC_CKEN | B_BE_TXTIME_CKEN | B_BE_RESP_PKTCTL_CKEN | \
			B_BE_SIGB_CKEN)

#define R_BE_WMAC_RFMOD 0x10010
#define R_BE_WMAC_RFMOD_C1 0x14010
#define B_BE_CMAC_ASSERTION BIT(31)
#define B_BE_WMAC_RFMOD_MASK GENMASK(2, 0)
#define BE_WMAC_RFMOD_20M 0
#define BE_WMAC_RFMOD_40M 1
#define BE_WMAC_RFMOD_80M 2
#define BE_WMAC_RFMOD_160M 3
#define BE_WMAC_RFMOD_320M 4

#define R_BE_GID_POSITION0 0x10070
#define R_BE_GID_POSITION0_C1 0x14070
#define R_BE_GID_POSITION1 0x10074
#define R_BE_GID_POSITION1_C1 0x14074
#define R_BE_GID_POSITION2 0x10078
#define R_BE_GID_POSITION2_C1 0x14078
#define R_BE_GID_POSITION3 0x1007C
#define R_BE_GID_POSITION3_C1 0x1407C
#define R_BE_GID_POSITION_EN0 0x10080
#define R_BE_GID_POSITION_EN0_C1 0x14080
#define R_BE_GID_POSITION_EN1 0x10084
#define R_BE_GID_POSITION_EN1_C1 0x14084

#define R_BE_TX_SUB_BAND_VALUE 0x10088
#define R_BE_TX_SUB_BAND_VALUE_C1 0x14088
#define B_BE_PRI20_BITMAP_MASK GENMASK(31, 16)
#define BE_PRI20_BITMAP_MAX 15
#define B_BE_TXSB_160M_MASK GENMASK(15, 12)
#define S_BE_TXSB_160M_0 0
#define S_BE_TXSB_160M_1 1
#define B_BE_TXSB_80M_MASK GENMASK(11, 8)
#define S_BE_TXSB_80M_0 0
#define S_BE_TXSB_80M_2 2
#define S_BE_TXSB_80M_4 4
#define B_BE_TXSB_40M_MASK GENMASK(7, 4)
#define S_BE_TXSB_40M_0 0
#define S_BE_TXSB_40M_1 1
#define S_BE_TXSB_40M_4 4
#define B_BE_TXSB_20M_MASK GENMASK(3, 0)
#define S_BE_TXSB_20M_8 8
#define S_BE_TXSB_20M_4 4
#define S_BE_TXSB_20M_2 2

#define R_BE_PTCL_RRSR0 0x1008C
#define R_BE_PTCL_RRSR0_C1 0x1408C
#define B_BE_RRSR_HE_MASK GENMASK(31, 24)
#define B_BE_RRSR_VHT_MASK GENMASK(23, 16)
#define B_BE_RRSR_HT_MASK GENMASK(15, 8)
#define B_BE_RRSR_OFDM_MASK GENMASK(7, 0)

#define R_BE_PTCL_RRSR1 0x10090
#define R_BE_PTCL_RRSR1_C1 0x14090
#define B_BE_RRSR_EHT_MASK GENMASK(23, 16)
#define B_BE_RRSR_RATE_EN_MASK GENMASK(12, 8)
#define B_BE_RSC_MASK GENMASK(7, 6)
#define B_BE_RRSR_CCK_MASK GENMASK(3, 0)

#define R_BE_COMMON_PHYINTF_CTRL_0 0x100B8
#define R_BE_COMMON_PHYINTF_CTRL_0_C1 0x140B8
#define B_BE_SEQ_EN_GUARD_CYE_MASK GENMASK(23, 20)
#define B_BE_PARA_FIFO_CRC_EN BIT(18)
#define B_BE_SEQ_FIFO_TO_EN BIT(17)
#define B_BE_PARA_FIFO_TO_EN BIT(16)
#define B_BE_SEQ_FIFO_CLR_EN BIT(6)
#define B_BE_PARA_FIFO_CLR_EN_V1 BIT(5)
#define B_BE_CSI_FIFO_CLR_EN_V1 BIT(4)
#define B_BE_FTM_FIFO_CLR_EN_V1 BIT(3)
#define B_BE_RXD_FIFO_CLR_EN_V1 BIT(2)
#define B_BE_TXD_FIFO_CLR_EN_V1 BIT(1)
#define B_BE_TXUID_FIFO_CLR_EN_V1 BIT(0)
#define CLEAR_DTOP_DIS	(BIT(1) | BIT(5) | BIT(6))

#define R_BE_CMAC_ERR_IMR 0x10160
#define R_BE_CMAC_ERR_IMR_C1 0x14160
#define B_BE_CMAC_FW_ERR_IDCT_EN BIT(16)
#define B_BE_PTCL_TX_IDLETO_IDCT_EN BIT(9)
#define B_BE_WMAC_RX_IDLETO_IDCT_EN BIT(8)
#define B_BE_WMAC_TX_ERR_IND_EN BIT(7)
#define B_BE_WMAC_RX_ERR_IND_EN BIT(6)
#define B_BE_TXPWR_CTRL_ERR_IND_EN BIT(5)
#define B_BE_PHYINTF_ERR_IND_EN BIT(4)
#define B_BE_DMA_TOP_ERR_IND_EN BIT(3)
#define B_BE_RESP_PKTCTL_ERR_IND_EN BIT(2)
#define B_BE_PTCL_TOP_ERR_IND_EN BIT(1)
#define B_BE_SCHEDULE_TOP_ERR_IND_EN BIT(0)

#define R_BE_CMAC_ERR_ISR 0x10164
#define R_BE_CMAC_ERR_ISR_C1 0x14164
#define B_BE_CMAC_FW_ERR_IDCT BIT(16)
#define B_BE_PTCL_TX_IDLETO_IDCT BIT(9)
#define B_BE_WMAC_RX_IDLETO_IDCT BIT(8)
#define B_BE_WMAC_TX_ERR_IND BIT(7)
#define B_BE_WMAC_RX_ERR_IND BIT(6)
#define B_BE_TXPWR_CTRL_ERR_IND BIT(5)
#define B_BE_PHYINTF_ERR_IND BIT(4)
#define B_BE_DMA_TOP_ERR_IND BIT(3)
#define B_BE_RESP_PKTCTL_ERR_IDCT BIT(2)
#define B_BE_PTCL_TOP_ERR_IND BIT(1)
#define B_BE_SCHEDULE_TOP_ERR_IND BIT(0)

#define R_BE_CMAC_FW_TRIGGER_IDCT_ISR 0x10168
#define R_BE_CMAC_FW_TRIGGER_IDCT_ISR_C1 0x14168
#define B_BE_CMAC_FW_ERR_IDCT_IMR BIT(31)
#define B_BE_CMAC_FW_TRIG_IDCT BIT(0)

#define R_BE_SER_L0_DBG_CNT 0x10170
#define R_BE_SER_L0_DBG_CNT_C1 0x14170
#define B_BE_SER_L0_PHYINTF_CNT_MASK GENMASK(31, 24)
#define B_BE_SER_L0_DMA_CNT_MASK GENMASK(23, 16)
#define B_BE_SER_L0_PTCL_CNT_MASK GENMASK(15, 8)
#define B_BE_SER_L0_SCH_CNT_MASK GENMASK(7, 0)

#define R_BE_SER_L0_DBG_CNT1 0x10174
#define R_BE_SER_L0_DBG_CNT1_C1 0x14174
#define B_BE_SER_L0_TMAC_COUNTER_MASK GENMASK(23, 16)
#define B_BE_SER_L0_RMAC_COUNTER_MASK GENMASK(15, 8)
#define B_BE_SER_L0_TXPWR_COUNTER_MASK GENMASK(7, 0)

#define R_BE_SER_L0_DBG_CNT2 0x10178
#define R_BE_SER_L0_DBG_CNT2_C1 0x14178

#define R_BE_SER_L0_DBG_CNT3 0x1017C
#define R_BE_SER_L0_DBG_CNT3_C1 0x1417C
#define B_BE_SER_L0_SUBMODULE_BIT31_CNT BIT(31)
#define B_BE_SER_L0_SUBMODULE_BIT30_CNT BIT(30)
#define B_BE_SER_L0_SUBMODULE_BIT29_CNT BIT(29)
#define B_BE_SER_L0_SUBMODULE_BIT28_CNT BIT(28)
#define B_BE_SER_L0_SUBMODULE_BIT27_CNT BIT(27)
#define B_BE_SER_L0_SUBMODULE_BIT26_CNT BIT(26)
#define B_BE_SER_L0_SUBMODULE_BIT25_CNT BIT(25)
#define B_BE_SER_L0_SUBMODULE_BIT24_CNT BIT(24)
#define B_BE_SER_L0_SUBMODULE_BIT23_CNT BIT(23)
#define B_BE_SER_L0_SUBMODULE_BIT22_CNT BIT(22)
#define B_BE_SER_L0_SUBMODULE_BIT21_CNT BIT(21)
#define B_BE_SER_L0_SUBMODULE_BIT20_CNT BIT(20)
#define B_BE_SER_L0_SUBMODULE_BIT19_CNT BIT(19)
#define B_BE_SER_L0_SUBMODULE_BIT18_CNT BIT(18)
#define B_BE_SER_L0_SUBMODULE_BIT17_CNT BIT(17)
#define B_BE_SER_L0_SUBMODULE_BIT16_CNT BIT(16)
#define B_BE_SER_L0_SUBMODULE_BIT15_CNT BIT(15)
#define B_BE_SER_L0_SUBMODULE_BIT14_CNT BIT(14)
#define B_BE_SER_L0_SUBMODULE_BIT13_CNT BIT(13)
#define B_BE_SER_L0_SUBMODULE_BIT12_CNT BIT(12)
#define B_BE_SER_L0_SUBMODULE_BIT11_CNT BIT(11)
#define B_BE_SER_L0_SUBMODULE_BIT10_CNT BIT(10)
#define B_BE_SER_L0_SUBMODULE_BIT9_CNT BIT(9)
#define B_BE_SER_L0_SUBMODULE_BIT8_CNT BIT(8)
#define B_BE_SER_L0_SUBMODULE_BIT7_CNT BIT(7)
#define B_BE_SER_L0_SUBMODULE_BIT6_CNT BIT(6)
#define B_BE_SER_L0_SUBMODULE_BIT5_CNT BIT(5)
#define B_BE_SER_L0_SUBMODULE_BIT4_CNT BIT(4)
#define B_BE_SER_L0_SUBMODULE_BIT3_CNT BIT(3)
#define B_BE_SER_L0_SUBMODULE_BIT2_CNT BIT(2)
#define B_BE_SER_L0_SUBMODULE_BIT1_CNT BIT(1)
#define B_BE_SER_L0_SUBMODULE_BIT0_CNT BIT(0)

#define R_BE_PORT_0_TSF_SYNC 0x102A0
#define R_BE_PORT_0_TSF_SYNC_C1 0x142A0
#define B_BE_P0_SYNC_NOW_P BIT(30)
#define B_BE_P0_SYNC_ONCE_P BIT(29)
#define B_BE_P0_AUTO_SYNC BIT(28)
#define B_BE_P0_SYNC_PORT_SRC_SEL_MASK GENMASK(26, 24)
#define B_BE_P0_TSFTR_SYNC_OFFSET_MASK GENMASK(18, 0)

#define R_BE_SCH_EDCA_RST_CFG 0x102E4
#define R_BE_SCH_EDCA_RST_CFG_C1 0x142E4
#define B_BE_EDCCA_S160_RST_EDCA_EN BIT(23)
#define B_BE_EDCCA_S80_RST_EDCA_EN BIT(22)
#define B_BE_EDCCA_S40_RST_EDCA_EN BIT(21)
#define B_BE_EDCCA_S20_RST_EDCA_EN BIT(20)
#define B_BE_OFDM_CCA_S160_RST_EDCA_EN BIT(19)
#define B_BE_CCA_PEB_BE_BITMAP_RST_EDCA_EN BIT(18)
#define B_BE_RX_INTRA_NAV_RST_EDCA_EN BIT(15)
#define B_BE_RX_BASIC_NAV_RST_EDCA_EN BIT(14)
#define B_BE_EDCCA_PER20_BITMAP_SIFS_RST_EDCA_EN BIT(10)
#define B_BE_TX_NAV_RST_EDCA_EN BIT(7)
#define B_BE_NO_GNT_WL_RST_EDCA_EN BIT(5)
#define B_BE_EDCCA_P20_RST_EDCA_EN BIT(4)
#define B_BE_OFDM_CCA_S80_RST_EDCA_EN BIT(3)
#define B_BE_OFDM_CCA_S40_RST_EDCA_EN BIT(2)
#define B_BE_OFDM_CCA_S20_RST_EDCA_EN BIT(1)
#define B_BE_CCA_P20_RST_EDCA_EN BIT(0)

#define R_BE_EDCA_BCNQ_PARAM 0x10324
#define R_BE_EDCA_BCNQ_PARAM_C1 0x14324
#define B_BE_BCNQ_CW_MASK GENMASK(31, 24)
#define B_BE_BCNQ_AIFS_MASK GENMASK(23, 16)
#define BCN_IFS_25US 0x19
#define B_BE_PIFS_MASK GENMASK(15, 8)
#define B_BE_FORCE_BCN_IFS_MASK GENMASK(7, 0)

#define R_BE_PREBKF_CFG_0 0x10338
#define R_BE_PREBKF_CFG_0_C1 0x14338
#define B_BE_100NS_TIME_MASK GENMASK(28, 24)
#define B_BE_RX_AIR_END_TIME_MASK GENMASK(22, 16)
#define B_BE_MACTX_LATENCY_MASK GENMASK(10, 8)
#define B_BE_PREBKF_TIME_MASK GENMASK(4, 0)

#define R_BE_PREBKF_CFG_1 0x1033C
#define R_BE_PREBKF_CFG_1_C1 0x1433C
#define B_BE_SIFS_TIMEOUT_TB_AGGR_MASK GENMASK(31, 24)
#define B_BE_SIFS_PREBKF_MASK GENMASK(23, 16)
#define B_BE_SIFS_TIMEOUT_T2_MASK GENMASK(14, 8)
#define B_BE_SIFS_MACTXEN_T1_MASK GENMASK(6, 0)

#define R_BE_CCA_CFG_0 0x10340
#define R_BE_CCA_CFG_0_C1 0x14340
#define B_BE_R_SIFS_AGGR_TIME_V1_MASK GENMASK(31, 24)
#define B_BE_EDCCA_SEC160_EN BIT(23)
#define B_BE_EDCCA_SEC80_EN BIT(22)
#define B_BE_EDCCA_SEC40_EN BIT(21)
#define B_BE_EDCCA_SEC20_EN BIT(20)
#define B_BE_SEC160_EN BIT(19)
#define B_BE_CCA_BITMAP_EN BIT(18)
#define B_BE_TXPKTCTL_RST_EDCA_EN BIT(17)
#define B_BE_WMAC_RST_EDCA_EN BIT(16)
#define B_BE_TXFAIL_BRK_TXOP_EN BIT(11)
#define B_BE_EDCCA_PER20_BITMAP_SIFS_EN BIT(10)
#define B_BE_NO_GNT_WL_BRK_TXOP_EN BIT(9)
#define B_BE_NAV_BRK_TXOP_EN BIT(8)
#define B_BE_TX_NAV_EN BIT(7)
#define B_BE_BCN_IGNORE_EDCCA BIT(6)
#define B_BE_NO_GNT_WL_EN BIT(5)
#define B_BE_EDCCA_EN BIT(4)
#define B_BE_SEC80_EN BIT(3)
#define B_BE_SEC40_EN BIT(2)
#define B_BE_SEC20_EN BIT(1)
#define B_BE_CCA_EN BIT(0)

#define R_BE_CTN_CFG_0 0x1034C
#define R_BE_CTN_CFG_0_C1 0x1434C
#define B_BE_OTHER_LINK_BKF_BLK_TX_THD_MASK GENMASK(30, 24)
#define B_BE_CCK_SIFS_COMP_MASK GENMASK(22, 16)
#define B_BE_PIFS_TIMEUNIT_MASK GENMASK(15, 14)
#define B_BE_PREBKF_TIME_NONAC_MASK GENMASK(12, 8)
#define B_BE_SR_TX_EN BIT(2)
#define B_BE_NAV_BLK_MGQ BIT(1)
#define B_BE_NAV_BLK_HGQ BIT(0)

#define R_BE_MUEDCA_BE_PARAM_0 0x10350
#define R_BE_MUEDCA_BK_PARAM_0 0x10354
#define R_BE_MUEDCA_VI_PARAM_0 0x10358
#define R_BE_MUEDCA_VO_PARAM_0 0x1035C

#define R_BE_MUEDCA_EN 0x10370
#define R_BE_MUEDCA_EN_C1 0x14370
#define B_BE_SIFS_TIMEOUT_TB_T2_MASK GENMASK(30, 24)
#define B_BE_SIFS_MACTXEN_TB_T1_MASK GENMASK(22, 16)
#define B_BE_MUEDCA_WMM_SEL BIT(8)
#define B_BE_SET_MUEDCATIMER_TF_MASK GENMASK(5, 4)
#define B_BE_SET_MUEDCATIMER_TF_0 BIT(4)
#define B_BE_MUEDCA_EN_MASK GENMASK(1, 0)
#define B_BE_MUEDCA_EN_0 BIT(0)

#define R_BE_CTN_DRV_TXEN 0x10398
#define R_BE_CTN_DRV_TXEN_C1 0x14398
#define B_BE_CTN_TXEN_TWT_3 BIT(17)
#define B_BE_CTN_TXEN_TWT_2 BIT(16)
#define B_BE_CTN_TXEN_TWT_1 BIT(15)
#define B_BE_CTN_TXEN_TWT_0 BIT(14)
#define B_BE_CTN_TXEN_ULQ BIT(13)
#define B_BE_CTN_TXEN_BCNQ BIT(12)
#define B_BE_CTN_TXEN_HGQ BIT(11)
#define B_BE_CTN_TXEN_CPUMGQ BIT(10)
#define B_BE_CTN_TXEN_MGQ1 BIT(9)
#define B_BE_CTN_TXEN_MGQ BIT(8)
#define B_BE_CTN_TXEN_VO_1 BIT(7)
#define B_BE_CTN_TXEN_VI_1 BIT(6)
#define B_BE_CTN_TXEN_BK_1 BIT(5)
#define B_BE_CTN_TXEN_BE_1 BIT(4)
#define B_BE_CTN_TXEN_VO_0 BIT(3)
#define B_BE_CTN_TXEN_VI_0 BIT(2)
#define B_BE_CTN_TXEN_BK_0 BIT(1)
#define B_BE_CTN_TXEN_BE_0 BIT(0)
#define B_BE_CTN_TXEN_ALL_MASK GENMASK(17, 0)

#define R_BE_TB_CHK_CCA_NAV 0x103AC
#define R_BE_TB_CHK_CCA_NAV_C1 0x143AC
#define B_BE_TB_CHK_TX_NAV BIT(15)
#define B_BE_TB_CHK_INTRA_NAV BIT(14)
#define B_BE_TB_CHK_BASIC_NAV BIT(13)
#define B_BE_TB_CHK_NO_GNT_WL BIT(12)
#define B_BE_TB_CHK_EDCCA_S160 BIT(11)
#define B_BE_TB_CHK_EDCCA_S80 BIT(10)
#define B_BE_TB_CHK_EDCCA_S40 BIT(9)
#define B_BE_TB_CHK_EDCCA_S20 BIT(8)
#define B_BE_TB_CHK_CCA_S160 BIT(7)
#define B_BE_TB_CHK_CCA_S80 BIT(6)
#define B_BE_TB_CHK_CCA_S40 BIT(5)
#define B_BE_TB_CHK_CCA_S20 BIT(4)
#define B_BE_TB_CHK_EDCCA_BITMAP BIT(3)
#define B_BE_TB_CHK_CCA_BITMAP BIT(2)
#define B_BE_TB_CHK_EDCCA_P20 BIT(1)
#define B_BE_TB_CHK_CCA_P20 BIT(0)

#define R_BE_HE_SIFS_CHK_CCA_NAV 0x103B4
#define R_BE_HE_SIFS_CHK_CCA_NAV_C1 0x143B4
#define B_BE_HE_SIFS_CHK_TX_NAV BIT(15)
#define B_BE_HE_SIFS_CHK_INTRA_NAV BIT(14)
#define B_BE_HE_SIFS_CHK_BASIC_NAV BIT(13)
#define B_BE_HE_SIFS_CHK_NO_GNT_WL BIT(12)
#define B_BE_HE_SIFS_CHK_EDCCA_S160 BIT(11)
#define B_BE_HE_SIFS_CHK_EDCCA_S80 BIT(10)
#define B_BE_HE_SIFS_CHK_EDCCA_S40 BIT(9)
#define B_BE_HE_SIFS_CHK_EDCCA_S20 BIT(8)
#define B_BE_HE_SIFS_CHK_CCA_S160 BIT(7)
#define B_BE_HE_SIFS_CHK_CCA_S80 BIT(6)
#define B_BE_HE_SIFS_CHK_CCA_S40 BIT(5)
#define B_BE_HE_SIFS_CHK_CCA_S20 BIT(4)
#define B_BE_HE_SIFS_CHK_EDCCA_BITMAP BIT(3)
#define B_BE_HE_SIFS_CHK_CCA_BITMAP BIT(2)
#define B_BE_HE_SIFS_CHK_EDCCA_P20 BIT(1)
#define B_BE_HE_SIFS_CHK_CCA_P20 BIT(0)

#define R_BE_HE_CTN_CHK_CCA_NAV 0x103C4
#define R_BE_HE_CTN_CHK_CCA_NAV_C1 0x143C4
#define B_BE_HE_CTN_CHK_TX_NAV BIT(15)
#define B_BE_HE_CTN_CHK_INTRA_NAV BIT(14)
#define B_BE_HE_CTN_CHK_BASIC_NAV BIT(13)
#define B_BE_HE_CTN_CHK_NO_GNT_WL BIT(12)
#define B_BE_HE_CTN_CHK_EDCCA_S160 BIT(11)
#define B_BE_HE_CTN_CHK_EDCCA_S80 BIT(10)
#define B_BE_HE_CTN_CHK_EDCCA_S40 BIT(9)
#define B_BE_HE_CTN_CHK_EDCCA_S20 BIT(8)
#define B_BE_HE_CTN_CHK_CCA_S160 BIT(7)
#define B_BE_HE_CTN_CHK_CCA_S80 BIT(6)
#define B_BE_HE_CTN_CHK_CCA_S40 BIT(5)
#define B_BE_HE_CTN_CHK_CCA_S20 BIT(4)
#define B_BE_HE_CTN_CHK_EDCCA_BITMAP BIT(3)
#define B_BE_HE_CTN_CHK_CCA_BITMAP BIT(2)
#define B_BE_HE_CTN_CHK_EDCCA_P20 BIT(1)
#define B_BE_HE_CTN_CHK_CCA_P20 BIT(0)

#define R_BE_SCHEDULE_ERR_IMR 0x103E8
#define R_BE_SCHEDULE_ERR_IMR_C1 0x143E8
#define B_BE_FSM_TIMEOUT_ERR_INT_EN BIT(0)
#define B_BE_SCHEDULE_ERR_IMR_CLR B_BE_FSM_TIMEOUT_ERR_INT_EN
#define B_BE_SCHEDULE_ERR_IMR_SET B_BE_FSM_TIMEOUT_ERR_INT_EN

#define R_BE_SCHEDULE_ERR_ISR 0x103EC
#define R_BE_SCHEDULE_ERR_ISR_C1 0x143EC
#define B_BE_SORT_NON_IDLE_ERR_INT BIT(1)
#define B_BE_FSM_TIMEOUT_ERR_INT BIT(0)

#define R_BE_PORT_CFG_P0 0x10400
#define R_BE_PORT_CFG_P0_C1 0x14400
#define B_BE_BCN_ERLY_SORT_EN_P0 BIT(18)
#define B_BE_PROHIB_END_CAL_EN_P0 BIT(17)
#define B_BE_BRK_SETUP_P0 BIT(16)
#define B_BE_TBTT_UPD_SHIFT_SEL_P0 BIT(15)
#define B_BE_BCN_DROP_ALLOW_P0 BIT(14)
#define B_BE_TBTT_PROHIB_EN_P0 BIT(13)
#define B_BE_BCNTX_EN_P0 BIT(12)
#define B_BE_NET_TYPE_P0_MASK GENMASK(11, 10)
#define B_BE_BCN_FORCETX_EN_P0 BIT(9)
#define B_BE_TXBCN_BTCCA_EN_P0 BIT(8)
#define B_BE_BCNERR_CNT_EN_P0 BIT(7)
#define B_BE_BCN_AGRES_P0 BIT(6)
#define B_BE_TSFTR_RST_P0 BIT(5)
#define B_BE_RX_BSSID_FIT_EN_P0 BIT(4)
#define B_BE_TSF_UDT_EN_P0 BIT(3)
#define B_BE_PORT_FUNC_EN_P0 BIT(2)
#define B_BE_TXBCN_RPT_EN_P0 BIT(1)
#define B_BE_RXBCN_RPT_EN_P0 BIT(0)

#define R_BE_TBTT_PROHIB_P0 0x10404
#define R_BE_TBTT_PROHIB_P0_C1 0x14404
#define B_BE_TBTT_HOLD_P0_MASK GENMASK(27, 16)
#define B_BE_TBTT_SETUP_P0_MASK GENMASK(7, 0)

#define R_BE_BCN_AREA_P0 0x10408
#define R_BE_BCN_AREA_P0_C1 0x14408
#define B_BE_BCN_MSK_AREA_P0_MSK 0xfff
#define B_BE_BCN_CTN_AREA_P0_MASK GENMASK(11, 0)

#define R_BE_BCNERLYINT_CFG_P0 0x1040C
#define R_BE_BCNERLYINT_CFG_P0_C1 0x1440C
#define B_BE_BCNERLY_P0_MASK GENMASK(11, 0)

#define R_BE_TBTTERLYINT_CFG_P0 0x1040E
#define R_BE_TBTTERLYINT_CFG_P0_C1 0x1440E
#define B_BE_TBTTERLY_P0_MASK GENMASK(11, 0)

#define R_BE_TBTT_AGG_P0 0x10412
#define R_BE_TBTT_AGG_P0_C1 0x14412
#define B_BE_TBTT_AGG_NUM_P0_MASK GENMASK(15, 8)

#define R_BE_BCN_SPACE_CFG_P0 0x10414
#define R_BE_BCN_SPACE_CFG_P0_C1 0x14414
#define B_BE_SUB_BCN_SPACE_P0_MASK GENMASK(23, 16)
#define B_BE_BCN_SPACE_P0_MASK GENMASK(15, 0)

#define R_BE_BCN_FORCETX_P0 0x10418
#define R_BE_BCN_FORCETX_P0_C1 0x14418
#define B_BE_FORCE_BCN_NUM_P0_MASK GENMASK(15, 8)
#define B_BE_BCN_MAX_ERR_P0_MASK GENMASK(7, 0)

#define R_BE_BCN_ERR_CNT_P0 0x10420
#define R_BE_BCN_ERR_CNT_P0_C1 0x14420
#define B_BE_BCN_ERR_CNT_SUM_P0_MASK GENMASK(31, 24)
#define B_BE_BCN_ERR_CNT_NAV_P0_MASK GENMASK(23, 16)
#define B_BE_BCN_ERR_CNT_EDCCA_P0_MASK GENMASK(15, 8)
#define B_BE_BCN_ERR_CNT_CCA_P0_MASK GENMASK(7, 0)

#define R_BE_BCN_ERR_FLAG_P0 0x10424
#define R_BE_BCN_ERR_FLAG_P0_C1 0x14424
#define B_BE_BCN_ERR_FLAG_SRCHEND_P0 BIT(3)
#define B_BE_BCN_ERR_FLAG_INVALID_P0 BIT(2)
#define B_BE_BCN_ERR_FLAG_CMP_P0 BIT(1)
#define B_BE_BCN_ERR_FLAG_LOCK_P0 BIT(0)

#define R_BE_DTIM_CTRL_P0 0x10426
#define R_BE_DTIM_CTRL_P0_C1 0x14426
#define B_BE_DTIM_NUM_P0_MASK GENMASK(15, 8)
#define B_BE_DTIM_CURRCNT_P0_MASK GENMASK(7, 0)

#define R_BE_TBTT_SHIFT_P0 0x10428
#define R_BE_TBTT_SHIFT_P0_C1 0x14428
#define B_BE_TBTT_SHIFT_OFST_P0_SH 0
#define B_BE_TBTT_SHIFT_OFST_P0_MSK 0xfff

#define R_BE_BCN_CNT_TMR_P0 0x10434
#define R_BE_BCN_CNT_TMR_P0_C1 0x14434
#define B_BE_BCN_CNT_TMR_P0_MASK GENMASK(31, 0)

#define R_BE_TSFTR_LOW_P0 0x10438
#define R_BE_TSFTR_LOW_P0_C1 0x14438
#define B_BE_TSFTR_LOW_P0_MASK GENMASK(31, 0)

#define R_BE_TSFTR_HIGH_P0 0x1043C
#define R_BE_TSFTR_HIGH_P0_C1 0x1443C
#define B_BE_TSFTR_HIGH_P0_MASK GENMASK(31, 0)

#define R_BE_BCN_DROP_ALL0 0x10560

#define R_BE_MBSSID_CTRL 0x10568
#define R_BE_MBSSID_CTRL_C1 0x14568
#define B_BE_MBSSID_MODE_SEL BIT(20)
#define B_BE_P0MB_NUM_MASK GENMASK(19, 16)
#define B_BE_P0MB15_EN BIT(15)
#define B_BE_P0MB14_EN BIT(14)
#define B_BE_P0MB13_EN BIT(13)
#define B_BE_P0MB12_EN BIT(12)
#define B_BE_P0MB11_EN BIT(11)
#define B_BE_P0MB10_EN BIT(10)
#define B_BE_P0MB9_EN BIT(9)
#define B_BE_P0MB8_EN BIT(8)
#define B_BE_P0MB7_EN BIT(7)
#define B_BE_P0MB6_EN BIT(6)
#define B_BE_P0MB5_EN BIT(5)
#define B_BE_P0MB4_EN BIT(4)
#define B_BE_P0MB3_EN BIT(3)
#define B_BE_P0MB2_EN BIT(2)
#define B_BE_P0MB1_EN BIT(1)

#define R_BE_P0MB_HGQ_WINDOW_CFG_0 0x10590
#define R_BE_P0MB_HGQ_WINDOW_CFG_0_C1 0x14590
#define R_BE_PORT_HGQ_WINDOW_CFG 0x105A0
#define R_BE_PORT_HGQ_WINDOW_CFG_C1 0x145A0

#define R_BE_PTCL_COMMON_SETTING_0 0x10800
#define R_BE_PTCL_COMMON_SETTING_0_C1 0x14800
#define B_BE_PCIE_MODE_MASK GENMASK(15, 14)
#define B_BE_CPUMGQ_LIFETIME_EN BIT(8)
#define B_BE_MGQ_LIFETIME_EN BIT(7)
#define B_BE_LIFETIME_EN BIT(6)
#define B_BE_DIS_PTCL_CLK_GATING BIT(5)
#define B_BE_PTCL_TRIGGER_SS_EN_UL BIT(4)
#define B_BE_PTCL_TRIGGER_SS_EN_1 BIT(3)
#define B_BE_PTCL_TRIGGER_SS_EN_0 BIT(2)
#define B_BE_CMAC_TX_MODE_1 BIT(1)
#define B_BE_CMAC_TX_MODE_0 BIT(0)

#define R_BE_AGG_BK_0 0x10804
#define R_BE_AGG_BK_0_C1 0x14804
#define B_BE_DIS_SAMPDU_TXIME_SR_CHECK BIT(24)
#define B_BE_TX_PAIR_MACID_LEN_EN BIT(23)
#define B_BE_DIS_SND_STS_CHECK_SU BIT(22)
#define B_BE_MAX_AGG_NUM_FIX_MODE_EN_V1 BIT(21)
#define B_BE_DIS_SIFS_BK_AGG_AMPDU BIT(20)
#define B_BE_EN_MU2SU_CHK_PROTECT_PPDU BIT(19)
#define B_BE_RPT_TXOP_START_PROTECT BIT(18)
#define B_BE_RANDOM_GEN_CMD_ABORT_EN BIT(17)
#define B_BE_PHYTXON_ENDPS_RESP_CHK BIT(16)
#define B_BE_CTN_CHK_SEQ_REQ_EN BIT(15)
#define B_BE_PTCL_RLS_ALLFAIL_EN BIT(14)
#define B_BE_DIS_MURU_PRI_Q_EMPTY_CHK BIT(13)
#define B_BE_DIS_MURU_SEC_Q_EMPTY_CHK BIT(12)
#define B_BE_EN_SAMPDU_TXIME_TWT_CHECK BIT(11)
#define B_BE_DIS_SAMPDU_TXIME_P2P_CHECK BIT(10)
#define B_BE_DIS_SAMPDU_TXIME_BCN_CHECK BIT(9)
#define B_BE_DIS_UL_SEQ_ABORT_CHECK BIT(8)
#define B_BE_DIS_SND_STS_CHECK BIT(7)
#define B_BE_NAV_PAUS_PHB_EN BIT(6)
#define B_BE_TXOP_SHT_PHB_EN BIT(5)
#define B_BE_AGG_BRK_PHB_EN BIT(4)
#define B_BE_DIS_SSN_CHK BIT(3)
#define B_BE_WDBK_CFG BIT(2)
#define B_BE_EN_RTY_BK BIT(1)
#define B_BE_EN_RTY_BK_COD BIT(0)

#define R_BE_TB_PPDU_CTRL 0x1080C
#define R_BE_TB_PPDU_CTRL_C1 0x1480C
#define B_BE_TB_PPDU_BK_DIS BIT(15)
#define B_BE_TB_PPDU_BE_DIS BIT(14)
#define B_BE_TB_PPDU_VI_DIS BIT(13)
#define B_BE_TB_PPDU_VO_DIS BIT(12)
#define B_BE_QOSNULL_UPD_MUEDCA_EN BIT(3)
#define B_BE_TB_BYPASS_TXPWR BIT(2)
#define B_BE_SW_PREFER_AC_MASK GENMASK(1, 0)

#define R_BE_AMPDU_AGG_LIMIT 0x10810
#define R_BE_AMPDU_AGG_LIMIT_C1 0x14810
#define B_BE_AMPDU_MAX_TIME_MASK GENMASK(31, 24)
#define AMPDU_MAX_TIME 0x9E
#define AMPDU_MAX_TIME_V1 0xA4
#define B_BE_RA_TRY_RATE_AGG_LMT_MASK GENMASK(23, 16)
#define B_BE_RTS_MAX_AGG_NUM_MASK GENMASK(15, 8)
#define B_BE_MAX_AGG_NUM_MASK GENMASK(7, 0)
#define MAX_TX_AMPDU_NUM_V1 128

#define R_BE_AGG_LEN_HT_0 0x10814
#define R_BE_AGG_LEN_HT_0_C1 0x14814
#define B_BE_AMPDU_MAX_LEN_HT_MASK GENMASK(31, 16)
#define B_BE_RTS_TXTIME_TH_MASK GENMASK(15, 8)
#define B_BE_RTS_LEN_TH_MASK GENMASK(7, 0)

#define R_BE_SPECIAL_TX_SETTING 0x10820
#define R_BE_SPECIAL_TX_SETTING_C1 0x14820
#define B_BE_TRI_PADDING_EXTEND BIT(31)
#define B_BE_TX_SN_BYPASS_EN BIT(30)
#define B_BE_USE_DATA_BW BIT(29)
#define B_BE_BW_SIGTA_MASK GENMASK(28, 27)
#define B_BE_BMC_NAV_PROTECT BIT(26)
#define B_BE_F2P_KEEP_NON_SR_CMD BIT(25)
#define B_BE_F2P_SU_FIXRATE_OVER_WD BIT(24)
#define B_BE_BAR_TXRATE_FOR_NULL_WD_MASK GENMASK(23, 20)
#define B_BE_STBC_CFEND_MASK GENMASK(19, 18)
#define B_BE_STBC_CFEND_RATE_MASK GENMASK(17, 9)
#define B_BE_BASIC_CFEND_RATE_MASK GENMASK(8, 0)

#define R_BE_SIFS_SETTING 0x10824
#define R_BE_SIFS_SETTING_C1 0x14824
#define B_BE_HW_CTS2SELF_PKT_LEN_TH_MASK GENMASK(31, 24)
#define B_BE_HW_CTS2SELF_PKT_LEN_TH_TWW_MASK GENMASK(23, 18)
#define B_BE_HW_CTS2SELF_EN BIT(16)
#define B_BE_SPEC_SIFS_OFDM_PTCL_MASK GENMASK(15, 8)
#define B_BE_SPEC_SIFS_CCK_PTCL_MASK GENMASK(7, 0)

#define R_BE_TXRATE_CHK 0x10828
#define R_BE_TXRATE_CHK_C1 0x14828
#define B_BE_LATENCY_PADDING_PKT_TH_MASK GENMASK(31, 24)
#define B_BE_PLCP_FETCH_BUFF_MASK GENMASK(23, 16)
#define B_BE_OFDM_CCK_ERR_PROC BIT(6)
#define B_BE_PKT_LAST_TX BIT(5)
#define B_BE_BAND_MODE BIT(4)
#define B_BE_MAX_TXNSS_MASK GENMASK(3, 2)
#define B_BE_RTS_LIMIT_IN_OFDM6 BIT(1)
#define B_BE_CHECK_CCK_EN BIT(0)

#define R_BE_TXCNT 0x1082C
#define R_BE_TXCNT_C1 0x1482C
#define B_BE_ADD_TXCNT_BY BIT(31)
#define B_BE_TOTAL_TC_OPT BIT(30)
#define B_BE_S_TXCNT_LMT_MASK GENMASK(29, 24)
#define B_BE_L_TXCNT_LMT_MASK GENMASK(21, 16)

#define R_BE_MBSSID_DROP_0 0x1083C
#define R_BE_MBSSID_DROP_0_C1 0x1483C
#define B_BE_GI_LTF_FB_SEL BIT(30)
#define B_BE_RATE_SEL_MASK GENMASK(29, 24)
#define B_BE_PORT_DROP_4_0_MASK GENMASK(20, 16)
#define B_BE_MBSSID_DROP_15_0_MASK GENMASK(15, 0)

#define R_BE_PTCL_PRELD_CTRL 0x10868
#define R_BE_PTCL_PRELD_CTRL_C1 0x14868
#define B_BE_PRELD_MGQ2_EN BIT(22)
#define B_BE_PRELD_MGQ1_EN BIT(21)
#define B_BE_PRELD_MGQ0_EN BIT(20)
#define B_BE_PRELD_HIQ_P4_EN BIT(19)
#define B_BE_PRELD_HIQ_P3_EN BIT(18)
#define B_BE_PRELD_HIQ_P2_EN BIT(17)
#define B_BE_PRELD_HIQ_P1_EN BIT(16)
#define B_BE_PRELD_HIQ_P0MB15_EN BIT(15)
#define B_BE_PRELD_HIQ_P0MB14_EN BIT(14)
#define B_BE_PRELD_HIQ_P0MB13_EN BIT(13)
#define B_BE_PRELD_HIQ_P0MB12_EN BIT(12)
#define B_BE_PRELD_HIQ_P0MB11_EN BIT(11)
#define B_BE_PRELD_HIQ_P0MB10_EN BIT(10)
#define B_BE_PRELD_HIQ_P0MB9_EN BIT(9)
#define B_BE_PRELD_HIQ_P0MB8_EN BIT(8)
#define B_BE_PRELD_HIQ_P0MB7_EN BIT(7)
#define B_BE_PRELD_HIQ_P0MB6_EN BIT(6)
#define B_BE_PRELD_HIQ_P0MB5_EN BIT(5)
#define B_BE_PRELD_HIQ_P0MB4_EN BIT(4)
#define B_BE_PRELD_HIQ_P0MB3_EN BIT(3)
#define B_BE_PRELD_HIQ_P0MB2_EN BIT(2)
#define B_BE_PRELD_HIQ_P0MB1_EN BIT(1)
#define B_BE_PRELD_HIQ_P0_EN BIT(0)
#define B_BE_PRELD_HIQ_ALL_EN (B_BE_PRELD_HIQ_P0_EN | B_BE_PRELD_HIQ_P1_EN | \
			       B_BE_PRELD_HIQ_P2_EN | B_BE_PRELD_HIQ_P3_EN | \
			       B_BE_PRELD_HIQ_P4_EN)
#define B_BE_PRELD_HIQ_P0MB_ALL_EN \
	(B_BE_PRELD_HIQ_P0_EN | B_BE_PRELD_HIQ_P0MB1_EN | \
	 B_BE_PRELD_HIQ_P0MB2_EN | B_BE_PRELD_HIQ_P0MB3_EN | \
	 B_BE_PRELD_HIQ_P0MB4_EN | B_BE_PRELD_HIQ_P0MB5_EN | \
	 B_BE_PRELD_HIQ_P0MB6_EN | B_BE_PRELD_HIQ_P0MB7_EN | \
	 B_BE_PRELD_HIQ_P0MB8_EN | B_BE_PRELD_HIQ_P0MB9_EN | \
	 B_BE_PRELD_HIQ_P0MB10_EN | B_BE_PRELD_HIQ_P0MB11_EN | \
	 B_BE_PRELD_HIQ_P0MB12_EN | B_BE_PRELD_HIQ_P0MB13_EN | \
	 B_BE_PRELD_HIQ_P0MB14_EN | B_BE_PRELD_HIQ_P0MB15_EN)

#define R_BE_BT_PLT 0x1087C
#define R_BE_BT_PLT_C1 0x1487C
#define B_BE_BT_PLT_PKT_CNT_MASK GENMASK(31, 16)
#define B_BE_BT_PLT_RST BIT(9)
#define B_BE_PLT_EN BIT(8)
#define B_BE_RX_PLT_GNT_LTE_RX BIT(7)
#define B_BE_RX_PLT_GNT_BT_RX BIT(6)
#define B_BE_RX_PLT_GNT_BT_TX BIT(5)
#define B_BE_RX_PLT_GNT_WL BIT(4)
#define B_BE_TX_PLT_GNT_LTE_RX BIT(3)
#define B_BE_TX_PLT_GNT_BT_RX BIT(2)
#define B_BE_TX_PLT_GNT_BT_TX BIT(1)
#define B_BE_TX_PLT_GNT_WL BIT(0)

#define R_BE_PTCL_BSS_COLOR_0 0x108A0
#define R_BE_PTCL_BSS_COLOR_0_C1 0x148A0
#define B_BE_BSS_COLOB_BE_PORT_3_MASK GENMASK(29, 24)
#define B_BE_BSS_COLOB_BE_PORT_2_MASK GENMASK(21, 16)
#define B_BE_BSS_COLOB_BE_PORT_1_MASK GENMASK(13, 8)
#define B_BE_BSS_COLOB_BE_PORT_0_MASK GENMASK(5, 0)

#define R_BE_PTCL_BSS_COLOR_1 0x108A4
#define R_BE_PTCL_BSS_COLOR_1_C1 0x148A4
#define B_BE_BSS_COLOB_BE_PORT_4_MASK GENMASK(5, 0)

#define R_BE_PTCL_IMR_2 0x108B8
#define R_BE_PTCL_IMR_2_C1 0x148B8
#define B_BE_NO_TRX_TIMEOUT_IMR BIT(1)
#define B_BE_TX_IDLE_TIMEOUT_IMR BIT(0)
#define B_BE_PTCL_IMR_2_CLR B_BE_TX_IDLE_TIMEOUT_IMR
#define B_BE_PTCL_IMR_2_SET 0

#define R_BE_PTCL_IMR0 0x108C0
#define R_BE_PTCL_IMR0_C1 0x148C0
#define B_BE_PTCL_ERROR_FLAG_IMR BIT(31)
#define B_BE_FSM1_TIMEOUT_ERR_INT_EN BIT(1)
#define B_BE_FSM_TIMEOUT_ERR_INT_EN BIT(0)
#define B_BE_PTCL_IMR0_CLR (B_BE_FSM_TIMEOUT_ERR_INT_EN | \
			    B_BE_FSM1_TIMEOUT_ERR_INT_EN | \
			    B_BE_PTCL_ERROR_FLAG_IMR)
#define B_BE_PTCL_IMR0_SET (B_BE_FSM_TIMEOUT_ERR_INT_EN | \
			    B_BE_FSM1_TIMEOUT_ERR_INT_EN | \
			    B_BE_PTCL_ERROR_FLAG_IMR)

#define R_BE_PTCL_ISR0 0x108C4
#define R_BE_PTCL_ISR0_C1 0x148C4
#define B_BE_PTCL_ERROR_FLAG_ISR BIT(31)
#define B_BE_FSM1_TIMEOUT_ERR BIT(1)
#define B_BE_FSM_TIMEOUT_ERR BIT(0)

#define R_BE_PTCL_IMR1 0x108C8
#define R_BE_PTCL_IMR1_C1 0x148C8
#define B_BE_F2PCMD_PKTID_IMR BIT(30)
#define B_BE_F2PCMD_RD_PKTID_IMR BIT(29)
#define B_BE_F2PCMD_ASSIGN_PKTID_IMR BIT(28)
#define B_BE_F2PCMD_USER_ALLC_IMR BIT(27)
#define B_BE_RX_SPF_U0_PKTID_IMR BIT(26)
#define B_BE_TX_SPF_U1_PKTID_IMR BIT(25)
#define B_BE_TX_SPF_U2_PKTID_IMR BIT(24)
#define B_BE_TX_SPF_U3_PKTID_IMR BIT(23)
#define B_BE_TX_RECORD_PKTID_IMR BIT(22)
#define B_BE_TWTSP_QSEL_IMR BIT(14)
#define B_BE_F2P_RLS_CTN_SEL_IMR BIT(13)
#define B_BE_BCNQ_ORDER_IMR BIT(12)
#define B_BE_Q_PKTID_IMR BIT(11)
#define B_BE_D_PKTID_IMR BIT(10)
#define B_BE_TXPRT_FULL_DROP_IMR BIT(9)
#define B_BE_F2PCMDRPT_FULL_DROP_IMR BIT(8)
#define B_BE_PTCL_IMR1_CLR (B_BE_F2PCMDRPT_FULL_DROP_IMR | \
			    B_BE_TXPRT_FULL_DROP_IMR | \
			    B_BE_D_PKTID_IMR | \
			    B_BE_Q_PKTID_IMR | \
			    B_BE_BCNQ_ORDER_IMR | \
			    B_BE_F2P_RLS_CTN_SEL_IMR | \
			    B_BE_TWTSP_QSEL_IMR | \
			    B_BE_TX_RECORD_PKTID_IMR | \
			    B_BE_TX_SPF_U3_PKTID_IMR | \
			    B_BE_TX_SPF_U2_PKTID_IMR | \
			    B_BE_TX_SPF_U1_PKTID_IMR | \
			    B_BE_RX_SPF_U0_PKTID_IMR | \
			    B_BE_F2PCMD_USER_ALLC_IMR | \
			    B_BE_F2PCMD_ASSIGN_PKTID_IMR | \
			    B_BE_F2PCMD_RD_PKTID_IMR | \
			    B_BE_F2PCMD_PKTID_IMR)
#define B_BE_PTCL_IMR1_SET B_BE_F2PCMD_USER_ALLC_IMR

#define R_BE_PTCL_ISR1 0x108CC
#define R_BE_PTCL_ISR1_C1 0x148CC
#define B_BE_F2PCMD_PKTID_ERR BIT(30)
#define B_BE_F2PCMD_RD_PKTID_ERR BIT(29)
#define B_BE_F2PCMD_ASSIGN_PKTID_ERR BIT(28)
#define B_BE_F2PCMD_USER_ALLC_ERR BIT(27)
#define B_BE_RX_SPF_U0_PKTID_ERR BIT(26)
#define B_BE_TX_SPF_U1_PKTID_ERR BIT(25)
#define B_BE_TX_SPF_U2_PKTID_ERR BIT(24)
#define B_BE_TX_SPF_U3_PKTID_ERR BIT(23)
#define B_BE_TX_RECORD_PKTID_ERR BIT(22)
#define B_BE_TWTSP_QSEL_ERR BIT(14)
#define B_BE_F2P_RLS_CTN_SEL_ERR BIT(13)
#define B_BE_BCNQ_ORDER_ERR BIT(12)
#define B_BE_Q_PKTID_ERR BIT(11)
#define B_BE_D_PKTID_ERR BIT(10)
#define B_BE_TXPRT_FULL_DROP_ERR BIT(9)
#define B_BE_F2PCMDRPT_FULL_DROP_ERR BIT(8)

#define R_BE_PTCL_FSM_MON 0x108E8
#define R_BE_PTCL_FSM_MON_C1 0x148E8
#define B_BE_PTCL_FSM2_TO_MODE BIT(30)
#define B_BE_PTCL_FSM2_TO_THR_MASK GENMASK(29, 24)
#define B_BE_PTCL_FSM1_TO_MODE BIT(22)
#define B_BE_PTCL_FSM1_TO_THR_MASK GENMASK(21, 16)
#define B_BE_PTCL_FSM0_TO_MODE BIT(14)
#define B_BE_PTCL_FSM0_TO_THR_MASK GENMASK(13, 8)
#define B_BE_PTCL_TX_ARB_TO_MODE BIT(6)
#define B_BE_PTCL_TX_ARB_TO_THR_MASK GENMASK(5, 0)

#define R_BE_PTCL_TX_CTN_SEL 0x108EC
#define R_BE_PTCL_TX_CTN_SEL_C1 0x148EC
#define B_BE_PTCL_TXOP_STAT BIT(8)
#define B_BE_PTCL_BUSY BIT(7)
#define B_BE_PTCL_DROP BIT(5)
#define B_BE_PTCL_TX_QUEUE_IDX_MASK GENMASK(4, 0)

#define R_BE_PTCL_DBG_INFO 0x108F0

#define R_BE_PTCL_DBG 0x108F4

#define R_BE_RX_ERROR_FLAG 0x10C00
#define R_BE_RX_ERROR_FLAG_C1 0x14C00
#define B_BE_RX_CSI_NOT_RELEASE_ERROR BIT(31)
#define B_BE_RX_GET_NULL_PKT_ERROR BIT(30)
#define B_BE_RX_RU0_FSM_HANG_ERROR BIT(29)
#define B_BE_RX_RU1_FSM_HANG_ERROR BIT(28)
#define B_BE_RX_RU2_FSM_HANG_ERROR BIT(27)
#define B_BE_RX_RU3_FSM_HANG_ERROR BIT(26)
#define B_BE_RX_RU4_FSM_HANG_ERROR BIT(25)
#define B_BE_RX_RU5_FSM_HANG_ERROR BIT(24)
#define B_BE_RX_RU6_FSM_HANG_ERROR BIT(23)
#define B_BE_RX_RU7_FSM_HANG_ERROR BIT(22)
#define B_BE_RX_RXSTS_FSM_HANG_ERROR BIT(21)
#define B_BE_RX_CSI_FSM_HANG_ERROR BIT(20)
#define B_BE_RX_TXRPT_FSM_HANG_ERROR BIT(19)
#define B_BE_RX_F2PCMD_FSM_HANG_ERROR BIT(18)
#define B_BE_RX_RU0_ZERO_LENGTH_ERROR BIT(17)
#define B_BE_RX_RU1_ZERO_LENGTH_ERROR BIT(16)
#define B_BE_RX_RU2_ZERO_LENGTH_ERROR BIT(15)
#define B_BE_RX_RU3_ZERO_LENGTH_ERROR BIT(14)
#define B_BE_RX_RU4_ZERO_LENGTH_ERROR BIT(13)
#define B_BE_RX_RU5_ZERO_LENGTH_ERROR BIT(12)
#define B_BE_RX_RU6_ZERO_LENGTH_ERROR BIT(11)
#define B_BE_RX_RU7_ZERO_LENGTH_ERROR BIT(10)
#define B_BE_RX_RXSTS_ZERO_LENGTH_ERROR BIT(9)
#define B_BE_RX_CSI_ZERO_LENGTH_ERROR BIT(8)
#define B_BE_PLE_DATA_OPT_FSM_HANG BIT(7)
#define B_BE_PLE_RXDATA_REQUEST_BUFFER_FSM_HANG BIT(6)
#define B_BE_PLE_TXRPT_REQUEST_BUFFER_FSM_HANG BIT(5)
#define B_BE_PLE_WD_OPT_FSM_HANG BIT(4)
#define B_BE_PLE_ENQ_FSM_HANG BIT(3)
#define B_BE_RXDATA_ENQUE_ORDER_ERROR BIT(2)
#define B_BE_RXSTS_ENQUE_ORDER_ERROR BIT(1)
#define B_BE_RX_CSI_PKT_NUM_ERROR BIT(0)

#define R_BE_RX_ERROR_FLAG_IMR 0x10C04
#define R_BE_RX_ERROR_FLAG_IMR_C1 0x14C04
#define B_BE_RX_CSI_NOT_RELEASE_ERROR_IMR BIT(31)
#define B_BE_RX_GET_NULL_PKT_ERROR_IMR BIT(30)
#define B_BE_RX_RU0_FSM_HANG_ERROR_IMR BIT(29)
#define B_BE_RX_RU1_FSM_HANG_ERROR_IMR BIT(28)
#define B_BE_RX_RU2_FSM_HANG_ERROR_IMR BIT(27)
#define B_BE_RX_RU3_FSM_HANG_ERROR_IMR BIT(26)
#define B_BE_RX_RU4_FSM_HANG_ERROR_IMR BIT(25)
#define B_BE_RX_RU5_FSM_HANG_ERROR_IMR BIT(24)
#define B_BE_RX_RU6_FSM_HANG_ERROR_IMR BIT(23)
#define B_BE_RX_RU7_FSM_HANG_ERROR_IMR BIT(22)
#define B_BE_RX_RXSTS_FSM_HANG_ERROR_IMR BIT(21)
#define B_BE_RX_CSI_FSM_HANG_ERROR_IMR BIT(20)
#define B_BE_RX_TXRPT_FSM_HANG_ERROR_IMR BIT(19)
#define B_BE_RX_F2PCMD_FSM_HANG_ERROR_IMR BIT(18)
#define B_BE_RX_RU0_ZERO_LENGTH_ERROR_IMR BIT(17)
#define B_BE_RX_RU1_ZERO_LENGTH_ERROR_IMR BIT(16)
#define B_BE_RX_RU2_ZERO_LENGTH_ERROR_IMR BIT(15)
#define B_BE_RX_RU3_ZERO_LENGTH_ERROR_IMR BIT(14)
#define B_BE_RX_RU4_ZERO_LENGTH_ERROR_IMR BIT(13)
#define B_BE_RX_RU5_ZERO_LENGTH_ERROR_IMR BIT(12)
#define B_BE_RX_RU6_ZERO_LENGTH_ERROR_IMR BIT(11)
#define B_BE_RX_RU7_ZERO_LENGTH_ERROR_IMR BIT(10)
#define B_BE_RX_RXSTS_ZERO_LENGTH_ERROR_IMR BIT(9)
#define B_BE_RX_CSI_ZERO_LENGTH_ERROR_IMR BIT(8)
#define B_BE_PLE_DATA_OPT_FSM_HANG_IMR BIT(7)
#define B_BE_PLE_RXDATA_REQUEST_BUFFER_FSM_HANG_IMR BIT(6)
#define B_BE_PLE_TXRPT_REQUEST_BUFFER_FSM_HANG_IMR BIT(5)
#define B_BE_PLE_WD_OPT_FSM_HANG_IMR BIT(4)
#define B_BE_PLE_ENQ_FSM_HANG_IMR BIT(3)
#define B_BE_RXDATA_ENQUE_ORDER_ERROR_IMR BIT(2)
#define B_BE_RXSTS_ENQUE_ORDER_ERROR_IMR BIT(1)
#define B_BE_RX_CSI_PKT_NUM_ERROR_IMR BIT(0)
#define B_BE_RX_ERROR_FLAG_IMR_CLR (B_BE_RX_RXSTS_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU7_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU6_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU5_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU4_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU3_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU2_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU1_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU0_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_F2PCMD_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_TXRPT_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_CSI_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RXSTS_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU7_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU6_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU5_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU4_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU3_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU2_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU1_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU0_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_GET_NULL_PKT_ERROR_IMR)
#define B_BE_RX_ERROR_FLAG_IMR_SET (B_BE_RX_RXSTS_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU7_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU6_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU5_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU4_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU3_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU2_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU1_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_RU0_ZERO_LENGTH_ERROR_IMR | \
				    B_BE_RX_F2PCMD_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_TXRPT_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_CSI_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RXSTS_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU7_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU6_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU5_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU4_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU3_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU2_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU1_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_RU0_FSM_HANG_ERROR_IMR | \
				    B_BE_RX_GET_NULL_PKT_ERROR_IMR)
#define B_BE_RX_ERROR_FLAG_IMR_CLR_V1 0x7FFFFFF8
#define B_BE_RX_ERROR_FLAG_IMR_SET_V1 0x7FFFFF38

#define R_BE_RX_CTRL_1 0x10C0C
#define R_BE_RX_CTRL_1_C1 0x14C0C
#define B_BE_RXDMA_TXRPT_QUEUE_ID_SW_MASK GENMASK(30, 25)
#define B_BE_RXDMA_F2PCMDRPT_QUEUE_ID_SW_MASK GENMASK(23, 18)
#define B_BE_RXDMA_TXRPT_PORT_ID_SW_MASK GENMASK(17, 14)
#define B_BE_RXDMA_F2PCMDRPT_PORT_ID_SW_MASK GENMASK(13, 10)
#define B_BE_DBG_SEL_MASK GENMASK(1, 0)
#define WLCPU_RXCH2_QID 0xA

#define R_BE_TX_ERROR_FLAG 0x10C6C
#define R_BE_TX_ERROR_FLAG_C1 0x14C6C
#define B_BE_TX_RU0_FSM_HANG_ERROR BIT(31)
#define B_BE_TX_RU1_FSM_HANG_ERROR BIT(30)
#define B_BE_TX_RU2_FSM_HANG_ERROR BIT(29)
#define B_BE_TX_RU3_FSM_HANG_ERROR BIT(28)
#define B_BE_TX_RU4_FSM_HANG_ERROR BIT(27)
#define B_BE_TX_RU5_FSM_HANG_ERROR BIT(26)
#define B_BE_TX_RU6_FSM_HANG_ERROR BIT(25)
#define B_BE_TX_RU7_FSM_HANG_ERROR BIT(24)
#define B_BE_TX_RU8_FSM_HANG_ERROR BIT(23)
#define B_BE_TX_RU9_FSM_HANG_ERROR BIT(22)
#define B_BE_TX_RU10_FSM_HANG_ERROR BIT(21)
#define B_BE_TX_RU11_FSM_HANG_ERROR BIT(20)
#define B_BE_TX_RU12_FSM_HANG_ERROR BIT(19)
#define B_BE_TX_RU13_FSM_HANG_ERROR BIT(18)
#define B_BE_TX_RU14_FSM_HANG_ERROR BIT(17)
#define B_BE_TX_RU15_FSM_HANG_ERROR BIT(16)
#define B_BE_TX_CSI_FSM_HANG_ERROR BIT(15)
#define B_BE_TX_WD_PLD_ID_FSM_HANG_ERROR BIT(14)

#define R_BE_TX_ERROR_FLAG_IMR 0x10C70
#define R_BE_TX_ERROR_FLAG_IMR_C1 0x14C70
#define B_BE_TX_RU0_FSM_HANG_ERROR_IMR BIT(31)
#define B_BE_TX_RU1_FSM_HANG_ERROR_IMR BIT(30)
#define B_BE_TX_RU2_FSM_HANG_ERROR_IMR BIT(29)
#define B_BE_TX_RU3_FSM_HANG_ERROR_IMR BIT(28)
#define B_BE_TX_RU4_FSM_HANG_ERROR_IMR BIT(27)
#define B_BE_TX_RU5_FSM_HANG_ERROR_IMR BIT(26)
#define B_BE_TX_RU6_FSM_HANG_ERROR_IMR BIT(25)
#define B_BE_TX_RU7_FSM_HANG_ERROR_IMR BIT(24)
#define B_BE_TX_RU8_FSM_HANG_ERROR_IMR BIT(23)
#define B_BE_TX_RU9_FSM_HANG_ERROR_IMR BIT(22)
#define B_BE_TX_RU10_FSM_HANG_ERROR_IMR BIT(21)
#define B_BE_TX_RU11_FSM_HANG_ERROR_IMR BIT(20)
#define B_BE_TX_RU12_FSM_HANG_ERROR_IMR BIT(19)
#define B_BE_TX_RU13_FSM_HANG_ERROR_IMR BIT(18)
#define B_BE_TX_RU14_FSM_HANG_ERROR_IMR BIT(17)
#define B_BE_TX_RU15_FSM_HANG_ERROR_IMR BIT(16)
#define B_BE_TX_CSI_FSM_HANG_ERROR_IMR BIT(15)
#define B_BE_TX_WD_PLD_ID_FSM_HANG_ERROR_IMR BIT(14)
#define B_BE_TX_ERROR_FLAG_IMR_CLR (B_BE_TX_WD_PLD_ID_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_CSI_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU15_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU14_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU13_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU12_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU11_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU10_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU9_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU8_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU7_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU6_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU5_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU4_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU3_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU2_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU1_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU0_FSM_HANG_ERROR_IMR)
#define B_BE_TX_ERROR_FLAG_IMR_SET (B_BE_TX_WD_PLD_ID_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_CSI_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU15_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU14_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU13_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU12_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU11_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU10_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU9_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU8_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU7_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU6_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU5_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU4_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU3_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU2_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU1_FSM_HANG_ERROR_IMR | \
				    B_BE_TX_RU0_FSM_HANG_ERROR_IMR)

#define R_BE_RX_ERROR_FLAG_1 0x10C84
#define R_BE_RX_ERROR_FLAG_1_C1 0x14C84
#define B_BE_RX_RU8_FSM_HANG_ERROR BIT(29)
#define B_BE_RX_RU9_FSM_HANG_ERROR BIT(28)
#define B_BE_RX_RU10_FSM_HANG_ERROR BIT(27)
#define B_BE_RX_RU11_FSM_HANG_ERROR BIT(26)
#define B_BE_RX_RU12_FSM_HANG_ERROR BIT(25)
#define B_BE_RX_RU13_FSM_HANG_ERROR BIT(24)
#define B_BE_RX_RU14_FSM_HANG_ERROR BIT(23)
#define B_BE_RX_RU15_FSM_HANG_ERROR BIT(22)
#define B_BE_RX_RU8_ZERO_LENGTH_ERROR BIT(17)
#define B_BE_RX_RU9_ZERO_LENGTH_ERROR BIT(16)
#define B_BE_RX_RU10_ZERO_LENGTH_ERROR BIT(15)
#define B_BE_RX_RU11_ZERO_LENGTH_ERROR BIT(14)
#define B_BE_RX_RU12_ZERO_LENGTH_ERROR BIT(13)
#define B_BE_RX_RU13_ZERO_LENGTH_ERROR BIT(12)
#define B_BE_RX_RU14_ZERO_LENGTH_ERROR BIT(11)
#define B_BE_RX_RU15_ZERO_LENGTH_ERROR BIT(10)

#define R_BE_RX_ERROR_FLAG_IMR_1 0x10C88
#define R_BE_RX_ERROR_FLAG_IMR_1_C1 0x14C88
#define B_BE_RX_RU8_FSM_HANG_ERROR_IMR BIT(29)
#define B_BE_RX_RU9_FSM_HANG_ERROR_IMR BIT(28)
#define B_BE_RX_RU10_FSM_HANG_ERROR_IMR BIT(27)
#define B_BE_RX_RU11_FSM_HANG_ERROR_IMR BIT(26)
#define B_BE_RX_RU12_FSM_HANG_ERROR_IMR BIT(25)
#define B_BE_RX_RU13_FSM_HANG_ERROR_IMR BIT(24)
#define B_BE_RX_RU14_FSM_HANG_ERROR_IMR BIT(23)
#define B_BE_RX_RU15_FSM_HANG_ERROR_IMR BIT(22)
#define B_BE_RX_RU8_ZERO_LENGTH_ERROR_IMR BIT(17)
#define B_BE_RX_RU9_ZERO_LENGTH_ERROR_IMR BIT(16)
#define B_BE_RX_RU10_ZERO_LENGTH_ERROR_IMR BIT(15)
#define B_BE_RX_RU11_ZERO_LENGTH_ERROR_IMR BIT(14)
#define B_BE_RX_RU12_ZERO_LENGTH_ERROR_IMR BIT(13)
#define B_BE_RX_RU13_ZERO_LENGTH_ERROR_IMR BIT(12)
#define B_BE_RX_RU14_ZERO_LENGTH_ERROR_IMR BIT(11)
#define B_BE_RX_RU15_ZERO_LENGTH_ERROR_IMR BIT(10)
#define B_BE_TX_ERROR_FLAG_IMR_1_CLR (B_BE_RX_RU8_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU9_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU10_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU11_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU12_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU13_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU14_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU15_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU8_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU9_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU10_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU11_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU12_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU13_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU14_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU15_ZERO_LENGTH_ERROR_IMR)
#define B_BE_TX_ERROR_FLAG_IMR_1_SET (B_BE_RX_RU8_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU9_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU10_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU11_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU12_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU13_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU14_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU15_FSM_HANG_ERROR_IMR | \
				      B_BE_RX_RU8_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU9_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU10_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU11_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU12_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU13_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU14_ZERO_LENGTH_ERROR_IMR | \
				      B_BE_RX_RU15_ZERO_LENGTH_ERROR_IMR)

#define R_BE_WMTX_MOREDATA_TSFT_STMP_CTL 0x10E08
#define R_BE_WMTX_MOREDATA_TSFT_STMP_CTL_C1 0x14E08
#define B_BE_TSFT_OFS_MASK GENMASK(31, 16)
#define B_BE_STMP_THSD_MASK GENMASK(15, 8)
#define B_BE_UPD_HGQMD BIT(1)
#define B_BE_UPD_TIMIE BIT(0)

#define R_BE_WMTX_POWER_BE_BIT_CTL 0x10E0C
#define R_BE_WMTX_POWER_BE_BIT_CTL_C1 0x14E0C

#define R_BE_WMTX_TCR_BE_4 0x10E2C
#define R_BE_WMTX_TCR_BE_4_C1 0x14E2C
#define B_BE_UL_EHT_MUMIMO_LTF_MODE BIT(30)
#define B_BE_UL_HE_MUMIMO_LTF_MODE BIT(29)
#define B_BE_EHT_HE_PPDU_4XLTF_ZLD_USTIMER_MASK GENMASK(28, 24)
#define B_BE_EHT_HE_PPDU_2XLTF_ZLD_USTIMER_MASK GENMASK(20, 16)
#define B_BE_NON_LEGACY_PPDU_ZLD_USTIMER_MASK GENMASK(12, 8)
#define B_BE_LEGACY_PPDU_ZLD_USTIMER_MASK GENMASK(4, 0)

#define R_BE_RSP_CHK_SIG 0x11000
#define R_BE_RSP_CHK_SIG_C1 0x15000
#define B_BE_RSP_STATIC_RTS_CHK_SERV_BW_EN BIT(30)
#define B_BE_RSP_TBPPDU_CHK_PWR BIT(29)
#define B_BE_RESP_PAIR_MACID_LEN_EN BIT(25)
#define B_BE_RESP_TX_ABORT_TEST_EN BIT(24)
#define B_BE_RESP_ER_SU_RU106_EN BIT(23)
#define B_BE_RESP_ER_SU_EN BIT(22)
#define B_BE_TXDATA_END_PS_OPT BIT(18)
#define B_BE_CHECK_SOUNDING_SEQ BIT(17)
#define B_BE_RXBA_IGNOREA2 BIT(16)
#define B_BE_ACKTO_CCK_MASK GENMASK(15, 8)
#define B_BE_ACKTO_MASK GENMASK(8, 0)

#define R_BE_TRXPTCL_RESP_0 0x11004
#define R_BE_TRXPTCL_RESP_0_C1 0x15004
#define B_BE_WMAC_RESP_STBC_EN BIT(31)
#define B_BE_WMAC_RXFTM_TXACK_SB BIT(30)
#define B_BE_WMAC_RXFTM_TXACKBWEQ BIT(29)
#define B_BE_RESP_TB_CHK_TXTIME BIT(24)
#define B_BE_RSP_CHK_CCA BIT(23)
#define B_BE_WMAC_LDPC_EN BIT(22)
#define B_BE_WMAC_SGIEN BIT(21)
#define B_BE_WMAC_SPLCPEN BIT(20)
#define B_BE_RESP_EHT_MCS15_REF BIT(19)
#define B_BE_RESP_EHT_MCS14_REF BIT(18)
#define B_BE_WMAC_BESP_EARLY_TXBA BIT(17)
#define B_BE_WMAC_MBA_DUR_FORCE BIT(16)
#define B_BE_WMAC_SPEC_SIFS_OFDM_MASK GENMASK(15, 8)
#define WMAC_SPEC_SIFS_OFDM_1115E 0x11
#define B_BE_WMAC_SPEC_SIFS_CCK_MASK GENMASK(7, 0)

#define R_BE_TRXPTCL_RESP_1 0x11008
#define R_BE_TRXPTCL_RESP_1_C1 0x15008
#define B_BE_WMAC_RESP_SR_MODE_EN BIT(31)
#define B_BE_FTM_RRSR_RATE_EN_MASK GENMASK(28, 24)
#define B_BE_NESS_MASK GENMASK(23, 22)
#define B_BE_WMAC_RESP_DOPPLEB_BE_EN BIT(21)
#define B_BE_WMAC_RESP_DCM_EN BIT(20)
#define B_BE_WMAC_CLR_ABORT_RESP_TX_CNT BIT(15)
#define B_BE_WMAC_RESP_REF_RATE_SEL BIT(12)
#define B_BE_WMAC_RESP_REF_RATE_MASK GENMASK(11, 0)

#define R_BE_MAC_LOOPBACK 0x11020
#define R_BE_MAC_LOOPBACK_C1 0x15020
#define B_BE_MACLBK_DIS_GCLK BIT(30)
#define B_BE_MACLBK_STS_EN BIT(29)
#define B_BE_MACLBK_RDY_PERIOD_MASK GENMASK(28, 17)
#define B_BE_MACLBK_PLCP_DLY_MASK GENMASK(16, 8)
#define S_BE_MACLBK_PLCP_DLY_DEF 0x28
#define B_BE_MACLBK_RDY_NUM_MASK GENMASK(7, 3)
#define B_BE_MACLBK_EN BIT(0)

#define R_BE_CLIENT_OM_CTRL 0x11040
#define R_BE_CLIENT_OM_CTRL_C1 0x15040
#define B_BE_TRIG_DIS_EHTTB BIT(24)

#define R_BE_WMAC_NAV_CTL 0x11080
#define R_BE_WMAC_NAV_CTL_C1 0x15080
#define B_BE_WMAC_NAV_UPPER_EN BIT(26)
#define B_BE_WMAC_0P125US_TIMER_MASK GENMASK(25, 18)
#define B_BE_WMAC_PLCP_UP_NAV_EN BIT(17)
#define B_BE_WMAC_TF_UP_NAV_EN BIT(16)
#define B_BE_WMAC_NAV_UPPER_MASK GENMASK(15, 8)
#define NAV_25MS 0xC4
#define B_BE_WMAC_RTS_RST_DUR_MASK GENMASK(7, 0)

#define R_BE_RXTRIG_TEST_USER_2 0x110B0
#define R_BE_RXTRIG_TEST_USER_2_C1 0x150B0
#define B_BE_RXTRIG_MACID_MASK GENMASK(31, 24)
#define B_BE_RXTRIG_RU26_DIS BIT(21)
#define B_BE_RXTRIG_FCSCHK_EN BIT(20)
#define B_BE_RXTRIG_PORT_SEL_MASK GENMASK(19, 17)
#define B_BE_RXTRIG_EN BIT(16)
#define B_BE_RXTRIG_USERINFO_2_MASK GENMASK(15, 0)

#define R_BE_TRXPTCL_ERROR_INDICA_MASK 0x110BC
#define R_BE_TRXPTCL_ERROR_INDICA_MASK_C1 0x150BC
#define B_BE_WMAC_FTM_TIMEOUT_MODE BIT(30)
#define B_BE_WMAC_FTM_TIMEOUT_THR_MASK GENMASK(29, 24)
#define B_BE_WMAC_MODE BIT(22)
#define B_BE_WMAC_TIMETOUT_THR_MASK GENMASK(21, 16)
#define B_BE_RMAC_BFMER BIT(9)
#define B_BE_RMAC_FTM BIT(8)
#define B_BE_RMAC_CSI BIT(7)
#define B_BE_TMAC_MIMO_CTRL BIT(6)
#define B_BE_TMAC_RXTB BIT(5)
#define B_BE_TMAC_HWSIGB_GEN BIT(4)
#define B_BE_TMAC_TXPLCP BIT(3)
#define B_BE_TMAC_RESP BIT(2)
#define B_BE_TMAC_TXCTL BIT(1)
#define B_BE_TMAC_MACTX BIT(0)
#define B_BE_TRXPTCL_ERROR_INDICA_MASK_CLR (B_BE_TMAC_MACTX | \
					    B_BE_TMAC_TXCTL | \
					    B_BE_TMAC_RESP | \
					    B_BE_TMAC_TXPLCP | \
					    B_BE_TMAC_HWSIGB_GEN | \
					    B_BE_TMAC_RXTB | \
					    B_BE_TMAC_MIMO_CTRL | \
					    B_BE_RMAC_CSI | \
					    B_BE_RMAC_FTM | \
					    B_BE_RMAC_BFMER)
#define B_BE_TRXPTCL_ERROR_INDICA_MASK_SET (B_BE_TMAC_MACTX | \
					    B_BE_TMAC_TXCTL | \
					    B_BE_TMAC_RESP | \
					    B_BE_TMAC_TXPLCP | \
					    B_BE_TMAC_HWSIGB_GEN | \
					    B_BE_TMAC_RXTB | \
					    B_BE_TMAC_MIMO_CTRL | \
					    B_BE_RMAC_CSI | \
					    B_BE_RMAC_FTM | \
					    B_BE_RMAC_BFMER)

#define R_BE_TRXPTCL_ERROR_INDICA 0x110C0
#define R_BE_TRXPTCL_ERROR_INDICA_C1 0x150C0
#define B_BE_BFMER_ERR_FLAG BIT(9)
#define B_BE_FTM_ERROR_FLAG_CLR BIT(8)
#define B_BE_CSI_ERROR_FLAG_CLR BIT(7)
#define B_BE_MIMOCTRL_ERROR_FLAG_CLR BIT(6)
#define B_BE_RXTB_ERROR_FLAG_CLR BIT(5)
#define B_BE_HWSIGB_GEN_ERROR_FLAG_CLR BIT(4)
#define B_BE_TXPLCP_ERROR_FLAG_CLR BIT(3)
#define B_BE_RESP_ERROR_FLAG_CLR BIT(2)
#define B_BE_TXCTL_ERROR_FLAG_CLR BIT(1)
#define B_BE_MACTX_ERROR_FLAG_CLR BIT(0)

#define R_BE_DBGSEL_TRXPTCL 0x110F4
#define R_BE_DBGSEL_TRXPTCL_C1 0x150F4
#define B_BE_WMAC_CHNSTS_STATE_MASK GENMASK(19, 16)
#define B_BE_DBGSEL_TRIGCMD_SEL_MASK GENMASK(11, 8)
#define B_BE_DBGSEL_TRXPTCL_MASK GENMASK(7, 0)

#define R_BE_PHYINFO_ERR_IMR_V1 0x110F8
#define R_BE_PHYINFO_ERR_IMR_V1_C1 0x150F8
#define B_BE_PHYINTF_RXTB_WIDTH_MASK GENMASK(31, 30)
#define B_BE_PHYINTF_RXTB_EN_PHASE_MASK GENMASK(29, 28)
#define B_BE_PHYINTF_MIMO_WIDTH_MASK GENMASK(27, 26)
#define B_BE_PHYINTF_MIMO_EN_PHASE_MASK GENMASK(25, 24)
#define B_BE_PHYINTF_TIMEOUT_THR_V1_MASK GENMASK(21, 16)
#define B_BE_CSI_ON_TIMEOUT_EN BIT(5)
#define B_BE_STS_ON_TIMEOUT_EN BIT(4)
#define B_BE_DATA_ON_TIMEOUT_EN BIT(3)
#define B_BE_OFDM_CCA_TIMEOUT_EN BIT(2)
#define B_BE_CCK_CCA_TIMEOUT_EN BIT(1)
#define B_BE_PHY_TXON_TIMEOUT_EN BIT(0)
#define  B_BE_PHYINFO_ERR_IMR_V1_CLR (B_BE_PHY_TXON_TIMEOUT_EN | \
				      B_BE_CCK_CCA_TIMEOUT_EN | \
				      B_BE_OFDM_CCA_TIMEOUT_EN | \
				      B_BE_DATA_ON_TIMEOUT_EN | \
				      B_BE_STS_ON_TIMEOUT_EN | \
				      B_BE_CSI_ON_TIMEOUT_EN)
#define B_BE_PHYINFO_ERR_IMR_V1_SET 0

#define R_BE_PHYINFO_ERR_ISR 0x110FC
#define R_BE_PHYINFO_ERR_ISR_C1 0x150FC
#define B_BE_CSI_ON_TIMEOUT_ERR BIT(5)
#define B_BE_STS_ON_TIMEOUT_ERR BIT(4)
#define B_BE_DATA_ON_TIMEOUT_ERR BIT(3)
#define B_BE_OFDM_CCA_TIMEOUT_ERR BIT(2)
#define B_BE_CCK_CCA_TIMEOUT_ERR BIT(1)
#define B_BE_PHY_TXON_TIMEOUT_ERR BIT(0)

#define R_BE_BFMEE_RESP_OPTION 0x11180
#define R_BE_BFMEE_RESP_OPTION_C1 0x15180
#define B_BE_BFMEE_CSI_SEC_TYPE_SH 20
#define B_BE_BFMEE_CSI_SEC_TYPE_MSK 0xf
#define B_BE_BFMEE_BFRPT_SEG_SIZE_SH 16
#define B_BE_BFMEE_BFRPT_SEG_SIZE_MSK 0x3
#define B_BE_BFMEE_MIMO_EN_SEL BIT(8)
#define B_BE_BFMEE_MU_BFEE_DIS BIT(7)
#define B_BE_BFMEE_CHECK_RPTPOLL_MACID_DIS BIT(6)
#define B_BE_BFMEE_NOCHK_BFPOLL_BMP BIT(5)
#define B_BE_BFMEE_VHTBFRPT_CHK BIT(4)
#define B_BE_BFMEE_EHT_NDPA_EN BIT(3)
#define B_BE_BFMEE_HE_NDPA_EN BIT(2)
#define B_BE_BFMEE_VHT_NDPA_EN BIT(1)
#define B_BE_BFMEE_HT_NDPA_EN BIT(0)

#define R_BE_TRXPTCL_RESP_CSI_CTRL_0 0x11188
#define R_BE_TRXPTCL_RESP_CSI_CTRL_0_C1 0x15188
#define B_BE_BFMEE_CSISEQ_SEL BIT(29)
#define B_BE_BFMEE_BFPARAM_SEL BIT(28)
#define B_BE_BFMEE_OFDM_LEN_TH_MASK GENMASK(27, 24)
#define B_BE_BFMEE_BF_PORT_SEL BIT(23)
#define B_BE_BFMEE_USE_NSTS BIT(22)
#define B_BE_BFMEE_CSI_RATE_FB_EN BIT(21)
#define B_BE_BFMEE_CSI_GID_SEL BIT(20)
#define B_BE_BFMEE_CSI_RSC_MASK GENMASK(19, 18)
#define B_BE_BFMEE_CSI_FORCE_RETE_EN BIT(17)
#define B_BE_BFMEE_CSI_USE_NDPARATE BIT(16)
#define B_BE_BFMEE_CSI_WITHHTC_EN BIT(15)
#define B_BE_BFMEE_CSIINFO0_BF_EN BIT(14)
#define B_BE_BFMEE_CSIINFO0_STBC_EN BIT(13)
#define B_BE_BFMEE_CSIINFO0_LDPC_EN BIT(12)
#define B_BE_BFMEE_CSIINFO0_CS_MASK GENMASK(11, 10)
#define B_BE_BFMEE_CSIINFO0_CB_MASK GENMASK(9, 8)
#define B_BE_BFMEE_CSIINFO0_NG_MASK GENMASK(7, 6)
#define B_BE_BFMEE_CSIINFO0_NR_MASK GENMASK(5, 3)
#define B_BE_BFMEE_CSIINFO0_NC_MASK GENMASK(2, 0)
#define CSI_RX_BW_CFG 0x1
#define R_BE_TRXPTCL_RESP_CSI_CTRL_1 0x11194
#define R_BE_TRXPTCL_RESP_CSI_CTRL_1_C1 0x15194
#define B_BE_BFMEE_BE_CSI_RRSC_BITMAP_MASK GENMASK(31, 24)
#define CSI_RRSC_BITMAP_CFG 0x2A

#define R_BE_TRXPTCL_RESP_CSI_RRSC 0x1118C
#define R_BE_TRXPTCL_RESP_CSI_RRSC_C1 0x1518C
#define CSI_RRSC_BMAP_BE 0x2A2AFF

#define R_BE_TRXPTCL_RESP_CSI_RATE 0x11190
#define R_BE_TRXPTCL_RESP_CSI_RATE_C1 0x15190
#define B_BE_BFMEE_EHT_CSI_RATE_MASK GENMASK(31, 24)
#define B_BE_BFMEE_HE_CSI_RATE_MASK GENMASK(23, 16)
#define B_BE_BFMEE_VHT_CSI_RATE_MASK GENMASK(15, 8)
#define B_BE_BFMEE_HT_CSI_RATE_MASK GENMASK(7, 0)
#define CSI_INIT_RATE_EHT 0x3

#define R_BE_WMAC_ACK_BA_RESP_LEGACY 0x11200
#define R_BE_WMAC_ACK_BA_RESP_LEGACY_C1 0x15200
#define B_BE_ACK_BA_RESP_LEGACY_CHK_NSTR BIT(16)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_TX_NAV BIT(15)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_INTRA_NAV BIT(14)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_BASIC_NAV BIT(13)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_BTCCA BIT(12)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_SEC_CCA160 BIT(5)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_SEC_CCA80 BIT(4)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_SEC_CCA40 BIT(3)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_SEC_CCA20 BIT(2)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_EDCCA BIT(1)
#define B_BE_ACK_BA_RESP_LEGACY_CHK_CCA BIT(0)
#define RESP_ACK_CFG_BE (B_BE_ACK_BA_RESP_LEGACY_CHK_BTCCA | \
			 B_BE_ACK_BA_RESP_LEGACY_CHK_TX_NAV)

#define R_BE_WMAC_ACK_BA_RESP_HE 0x11204
#define R_BE_WMAC_ACK_BA_RESP_HE_C1 0x15204
#define B_BE_ACK_BA_RESP_HE_CHK_NSTR BIT(16)
#define B_BE_ACK_BA_RESP_HE_CHK_TX_NAV BIT(15)
#define B_BE_ACK_BA_RESP_HE_CHK_INTRA_NAV BIT(14)
#define B_BE_ACK_BA_RESP_HE_CHK_BASIC_NAV BIT(13)
#define B_BE_ACK_BA_RESP_HE_CHK_BTCCA BIT(12)
#define B_BE_ACK_BA_RESP_HE_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_ACK_BA_RESP_HE_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_ACK_BA_RESP_HE_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_ACK_BA_RESP_HE_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_ACK_BA_RESP_HE_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_ACK_BA_RESP_HE_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_ACK_BA_RESP_HE_CHK_SEC_CCA160 BIT(5)
#define B_BE_ACK_BA_RESP_HE_CHK_SEC_CCA80 BIT(4)
#define B_BE_ACK_BA_RESP_HE_CHK_SEC_CCA40 BIT(3)
#define B_BE_ACK_BA_RESP_HE_CHK_SEC_CCA20 BIT(2)
#define B_BE_ACK_BA_RESP_HE_CHK_EDCCA BIT(1)
#define B_BE_ACK_BA_RESP_HE_CHK_CCA BIT(0)

#define R_BE_WMAC_ACK_BA_RESP_EHT_LEG_PUNC 0x11208
#define R_BE_WMAC_ACK_BA_RESP_EHT_LEG_PUNC_C1 0x15208
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_NSTR BIT(16)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_TX_NAV BIT(15)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_INTRA_NAV BIT(14)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_BASIC_NAV BIT(13)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_BTCCA BIT(12)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_SEC_CCA160 BIT(5)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_SEC_CCA80 BIT(4)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_SEC_CCA40 BIT(3)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_SEC_CCA20 BIT(2)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_EDCCA BIT(1)
#define B_BE_ACK_BA_EHT_LEG_PUNC_CHK_CCA BIT(0)

#define R_BE_WMAC_RX_RTS_RESP_LEGACY 0x1120C
#define R_BE_WMAC_RX_RTS_RESP_LEGACY_C1 0x1520C
#define B_BE_RX_RTS_RESP_LEGACY_CHK_NSTR BIT(16)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_TX_NAV BIT(15)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_INTRA_NAV BIT(14)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_BASIC_NAV BIT(13)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_BTCCA BIT(12)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA160 BIT(5)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA80 BIT(4)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA40 BIT(3)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA20 BIT(2)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_EDCCA BIT(1)
#define B_BE_RX_RTS_RESP_LEGACY_CHK_CCA BIT(0)
#define RESP_RTS_CFG_BE (B_BE_RX_RTS_RESP_LEGACY_CHK_CCA | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_EDCCA | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA20 | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA40 | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA80 | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA160 | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA20 | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA40 | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA80 | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA160 | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_BTCCA | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_BASIC_NAV | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_INTRA_NAV | \
			 B_BE_RX_RTS_RESP_LEGACY_CHK_TX_NAV)
#define RESP_RTS_PUNC_CFG_BE (B_BE_RX_RTS_RESP_LEGACY_CHK_CCA | \
			      B_BE_RX_RTS_RESP_LEGACY_CHK_EDCCA | \
			      B_BE_RX_RTS_RESP_LEGACY_CHK_CCA_PER20_BMP | \
			      B_BE_RX_RTS_RESP_LEGACY_CHK_EDCCA_PER20_BMP | \
			      B_BE_RX_RTS_RESP_LEGACY_CHK_BTCCA | \
			      B_BE_RX_RTS_RESP_LEGACY_CHK_BASIC_NAV | \
			      B_BE_RX_RTS_RESP_LEGACY_CHK_INTRA_NAV | \
			      B_BE_RX_RTS_RESP_LEGACY_CHK_TX_NAV)
#define RESP_NORMAL_CFG_BE (B_BE_RX_RTS_RESP_LEGACY_CHK_CCA | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_EDCCA | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA20 | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA40 | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA80 | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_CCA160 | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA20 | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA40 | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA80 | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_SEC_EDCCA160 | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_BTCCA | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_BASIC_NAV | \
			    B_BE_RX_RTS_RESP_LEGACY_CHK_TX_NAV)
#define RESP_NORMAL_PUNC_CFG_BE (B_BE_RX_RTS_RESP_LEGACY_CHK_CCA | \
				 B_BE_RX_RTS_RESP_LEGACY_CHK_EDCCA | \
				 B_BE_RX_RTS_RESP_LEGACY_CHK_CCA_PER20_BMP | \
				 B_BE_RX_RTS_RESP_LEGACY_CHK_EDCCA_PER20_BMP | \
				 B_BE_RX_RTS_RESP_LEGACY_CHK_BTCCA | \
				 B_BE_RX_RTS_RESP_LEGACY_CHK_BASIC_NAV | \
				 B_BE_RX_RTS_RESP_LEGACY_CHK_TX_NAV)

#define R_BE_WMAC_RX_RTS_RESP_LEGACY_PUNC 0x11210
#define R_BE_WMAC_RX_RTS_RESP_LEGACY_PUNC_C1 0x15210
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_NSTR BIT(16)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_TX_NAV BIT(15)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_INTRA_NAV BIT(14)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_BASIC_NAV BIT(13)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_BTCCA BIT(12)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_SEC_CCA160 BIT(5)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_SEC_CCA80 BIT(4)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_SEC_CCA40 BIT(3)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_SEC_CCA20 BIT(2)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_EDCCA BIT(1)
#define B_BE_RX_RTS_RESP_LEGACY_PUNC_CHK_CCA BIT(0)

#define R_BE_WMAC_RX_MURTS_RESP_LEGACY 0x11214
#define R_BE_WMAC_RX_MURTS_RESP_LEGACY_C1 0x15214
#define B_BE_MURTS_RESP_LEGACY_CHK_NSTR BIT(16)
#define B_BE_MURTS_RESP_LEGACY_CHK_TX_NAV BIT(15)
#define B_BE_MURTS_RESP_LEGACY_CHK_INTRA_NAV BIT(14)
#define B_BE_MURTS_RESP_LEGACY_CHK_BASIC_NAV BIT(13)
#define B_BE_MURTS_RESP_LEGACY_CHK_BTCCA BIT(12)
#define B_BE_MURTS_RESP_LEGACY_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_MURTS_RESP_LEGACY_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_MURTS_RESP_LEGACY_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_MURTS_RESP_LEGACY_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_MURTS_RESP_LEGACY_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_MURTS_RESP_LEGACY_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_MURTS_RESP_LEGACY_CHK_SEC_CCA160 BIT(5)
#define B_BE_MURTS_RESP_LEGACY_CHK_SEC_CCA80 BIT(4)
#define B_BE_MURTS_RESP_LEGACY_CHK_SEC_CCA40 BIT(3)
#define B_BE_MURTS_RESP_LEGACY_CHK_SEC_CCA20 BIT(2)
#define B_BE_MURTS_RESP_LEGACY_CHK_EDCCA BIT(1)
#define B_BE_MURTS_RESP_LEGACY_CHK_CCA BIT(0)

#define R_BE_WMAC_RX_MURTS_RESP_LEGACY_PUNC 0x11218
#define R_BE_WMAC_RX_MURTS_RESP_LEGACY_PUNC_C1 0x15218
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_NSTR BIT(16)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_TX_NAV BIT(15)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_INTRA_NAV BIT(14)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_BASIC_NAV BIT(13)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_BTCCA BIT(12)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_SEC_CCA160 BIT(5)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_SEC_CCA80 BIT(4)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_SEC_CCA40 BIT(3)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_SEC_CCA20 BIT(2)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_EDCCA BIT(1)
#define B_BE_MURTS_RESP_LEGACY_PUNC_CHK_CCA BIT(0)

#define R_BE_WMAC_OTHERS_RESP_LEGACY 0x1121C
#define R_BE_WMAC_OTHERS_RESP_LEGACY_C1 0x1521C
#define B_BE_OTHERS_RESP_LEGACY_CHK_NSTR BIT(16)
#define B_BE_OTHERS_RESP_LEGACY_CHK_TX_NAV BIT(15)
#define B_BE_OTHERS_RESP_LEGACY_CHK_INTRA_NAV BIT(14)
#define B_BE_OTHERS_RESP_LEGACY_CHK_BASIC_NAV BIT(13)
#define B_BE_OTHERS_RESP_LEGACY_CHK_BTCCA BIT(12)
#define B_BE_OTHERS_RESP_LEGACY_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_OTHERS_RESP_LEGACY_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_OTHERS_RESP_LEGACY_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_OTHERS_RESP_LEGACY_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_OTHERS_RESP_LEGACY_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_OTHERS_RESP_LEGACY_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_OTHERS_RESP_LEGACY_CHK_SEC_CCA160 BIT(5)
#define B_BE_OTHERS_RESP_LEGACY_CHK_SEC_CCA80 BIT(4)
#define B_BE_OTHERS_RESP_LEGACY_CHK_SEC_CCA40 BIT(3)
#define B_BE_OTHERS_RESP_LEGACY_CHK_SEC_CCA20 BIT(2)
#define B_BE_OTHERS_RESP_LEGACY_CHK_EDCCA BIT(1)
#define B_BE_OTHERS_RESP_LEGACY_CHK_CCA BIT(0)

#define R_BE_WMAC_OTHERS_RESP_HE 0x11220
#define R_BE_WMAC_OTHERS_RESP_HE_C1 0x15220
#define B_BE_OTHERS_RESP_HE_CHK_NSTR BIT(16)
#define B_BE_OTHERS_RESP_HE_CHK_TX_NAV BIT(15)
#define B_BE_OTHERS_RESP_HE_CHK_INTRA_NAV BIT(14)
#define B_BE_OTHERS_RESP_HE_CHK_BASIC_NAV BIT(13)
#define B_BE_OTHERS_RESP_HE_CHK_BTCCA BIT(12)
#define B_BE_OTHERS_RESP_HE_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_OTHERS_RESP_HE_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_OTHERS_RESP_HE_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_OTHERS_RESP_HE_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_OTHERS_RESP_HE_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_OTHERS_RESP_HE_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_OTHERS_RESP_HE_CHK_SEC_CCA160 BIT(5)
#define B_BE_OTHERS_RESP_HE_CHK_SEC_CCA80 BIT(4)
#define B_BE_OTHERS_RESP_HE_CHK_SEC_CCA40 BIT(3)
#define B_BE_OTHERS_RESP_HE_CHK_SEC_CCA20 BIT(2)
#define B_BE_OTHERS_RESP_HE_CHK_EDCCA BIT(1)
#define B_BE_OTHERS_RESP_HE_CHK_CCA BIT(0)

#define R_BE_WMAC_OTHERS_RESP_EHT_LEG_PUNC 0x11224
#define R_BE_WMAC_OTHERS_RESP_EHT_LEG_PUNC_C1 0x15224
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_NSTR BIT(16)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_TX_NAV BIT(15)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_INTRA_NAV BIT(14)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_BASIC_NAV BIT(13)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_BTCCA BIT(12)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_SEC_EDCCA160 BIT(11)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_SEC_EDCCA80 BIT(10)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_SEC_EDCCA40 BIT(9)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_SEC_EDCCA20 BIT(8)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_EDCCA_PER20_BMP BIT(7)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_CCA_PER20_BMP BIT(6)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_SEC_CCA160 BIT(5)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_SEC_CCA80 BIT(4)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_SEC_CCA40 BIT(3)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_SEC_CCA20 BIT(2)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_EDCCA BIT(1)
#define B_BE_OTHERS_RESP_EHT_LEG_PUNC_CHK_CCA BIT(0)

#define R_BE_RCR 0x11400
#define R_BE_RCR_C1 0x15400
#define B_BE_BUSY_CHKSN BIT(15)
#define B_BE_DYN_CHEN BIT(14)
#define B_BE_AUTO_RST BIT(13)
#define B_BE_TIMER_SEL BIT(12)
#define B_BE_STOP_RX_IN BIT(11)
#define B_BE_PSR_RDY_CHKDIS BIT(10)
#define B_BE_DRV_INFO_SZ_MASK GENMASK(9, 8)
#define B_BE_HDR_CNV_SZ_MASK GENMASK(7, 6)
#define B_BE_PHY_RPT_SZ_MASK GENMASK(5, 4)
#define B_BE_CH_EN BIT(0)

#define R_BE_DLK_PROTECT_CTL 0x11402
#define R_BE_DLK_PROTECT_CTL_C1 0x15402
#define B_BE_RX_DLK_CCA_TIME_MASK GENMASK(15, 8)
#define TRXCFG_RMAC_CCA_TO 32
#define B_BE_RX_DLK_DATA_TIME_MASK GENMASK(7, 4)
#define TRXCFG_RMAC_DATA_TO 15
#define B_BE_RX_DLK_RST_FSM BIT(3)
#define B_BE_RX_DLK_RST_SKIPDMA BIT(2)
#define B_BE_RX_DLK_RST_EN BIT(1)
#define B_BE_RX_DLK_INT_EN BIT(0)

#define R_BE_PLCP_HDR_FLTR 0x11404
#define R_BE_PLCP_HDR_FLTR_C1 0x15404
#define B_BE_PLCP_RXFA_RESET_TYPE_MASK GENMASK(15, 12)
#define B_BE_PLCP_RXFA_RESET_EN BIT(11)
#define B_BE_DIS_CHK_MIN_LEN BIT(8)
#define B_BE_HE_SIGB_CRC_CHK BIT(6)
#define B_BE_VHT_MU_SIGB_CRC_CHK BIT(5)
#define B_BE_VHT_SU_SIGB_CRC_CHK BIT(4)
#define B_BE_SIGA_CRC_CHK BIT(3)
#define B_BE_LSIG_PARITY_CHK_EN BIT(2)
#define B_BE_CCK_SIG_CHK BIT(1)
#define B_BE_CCK_CRC_CHK BIT(0)

#define R_BE_RXGCK_CTRL 0x11406
#define R_BE_RXGCK_CTRL_C1 0x15406
#define B_BE_RXGCK_BCNPRS_DISGCLK BIT(12)
#define B_BE_RXGCK_GCK_RATE_LIMIT_MASK GENMASK(9, 8)
#define RX_GCK_LEGACY 2
#define B_BE_RXGCK_DISREG_GCLK BIT(7)
#define B_BE_RXGCK_ENTRY_DELAY_MASK GENMASK(6, 4)
#define B_BE_RXGCK_GCK_CYCLE_MASK GENMASK(3, 2)
#define B_BE_RXGCK_CCA_EN BIT(1)
#define B_BE_DISGCLK BIT(0)

#define R_BE_RX_FLTR_OPT 0x11420
#define R_BE_RX_FLTR_OPT_C1 0x15420
#define B_BE_UID_FILTER_MASK GENMASK(31, 24)
#define B_BE_UNSPT_TYPE BIT(22)
#define B_BE_RX_MPDU_MAX_LEN_MASK GENMASK(21, 16)
#define B_BE_A_FTM_REQ BIT(14)
#define B_BE_A_ERR_PKT BIT(13)
#define B_BE_A_UNSUP_PKT BIT(12)
#define B_BE_A_CRC32_ERR BIT(11)
#define B_BE_A_BCN_CHK_RULE_MASK GENMASK(9, 8)
#define B_BE_A_BCN_CHK_EN BIT(7)
#define B_BE_A_MC_LIST_CAM_MATCH BIT(6)
#define B_BE_A_BC_CAM_MATCH BIT(5)
#define B_BE_A_UC_CAM_MATCH BIT(4)
#define B_BE_A_MC BIT(3)
#define B_BE_A_BC BIT(2)
#define B_BE_A_A1_MATCH BIT(1)
#define B_BE_SNIFFER_MODE BIT(0)

#define R_BE_CTRL_FLTR 0x11424
#define R_BE_CTRL_FLTR_C1 0x15424
#define B_BE_CTRL_STYPE_MASK GENMASK(15, 0)
#define RX_FLTR_FRAME_DROP_BE 0x0000
#define RX_FLTR_FRAME_ACCEPT_BE 0xFFFF

#define R_BE_MGNT_FLTR 0x11428
#define R_BE_MGNT_FLTR_C1 0x15428
#define B_BE_MGNT_STYPE_MASK GENMASK(15, 0)

#define R_BE_DATA_FLTR 0x1142C
#define R_BE_DATA_FLTR_C1 0x1542C
#define B_BE_DATA_STYPE_MASK GENMASK(15, 0)

#define R_BE_ADDR_CAM_CTRL 0x11434
#define R_BE_ADDR_CAM_CTRL_C1 0x15434
#define B_BE_ADDR_CAM_RANGE_MASK GENMASK(23, 16)
#define ADDR_CAM_SERCH_RANGE  0x7f
#define B_BE_ADDR_CAM_CMPLIMT_MASK GENMASK(15, 12)
#define B_BE_ADDR_CAM_IORST BIT(10)
#define B_BE_DIS_ADDR_CLK_GATED BIT(9)
#define B_BE_ADDR_CAM_CLR BIT(8)
#define B_BE_ADDR_CAM_A2_B0_CHK BIT(2)
#define B_BE_ADDR_CAM_SRCH_PERPKT BIT(1)
#define B_BE_ADDR_CAM_EN BIT(0)

#define R_BE_RESPBA_CAM_CTRL 0x1143C
#define R_BE_RESPBA_CAM_CTRL_C1 0x1543C
#define B_BE_BACAM_SKIP_ALL_QOSNULL BIT(24)
#define B_BE_BACAM_STD_SSN_SEL BIT(20)
#define B_BE_BACAM_TEMP_SZ_MASK GENMASK(17, 16)
#define B_BE_BACAM_RST_IDX_MASK GENMASK(15, 8)
#define B_BE_BACAM_SHIFT_POLL BIT(7)
#define B_BE_BACAM_IORST BIT(6)
#define B_BE_BACAM_GCK_DIS BIT(5)
#define B_BE_COMPL_VAL BIT(3)
#define B_BE_SSN_SEL BIT(2)
#define B_BE_BACAM_RST_MASK GENMASK(1, 0)
#define S_BE_BACAM_RST_DONE 0
#define S_BE_BACAM_RST_ENT 1
#define S_BE_BACAM_RST_ALL 2

#define R_BE_PPDU_STAT 0x11440
#define R_BE_PPDU_STAT_C1 0x15440
#define B_BE_STAT_IORST BIT(13)
#define B_BE_STAT_GCKDIS BIT(12)
#define B_BE_PPDU_STAT_WR_BW_MASK GENMASK(11, 10)
#define B_BE_PPDU_STAT_RPT_TRIG BIT(8)
#define B_BE_PPDU_STAT_RPT_DMA BIT(6)
#define B_BE_PPDU_STAT_RPT_CRC32 BIT(5)
#define B_BE_PPDU_STAT_RPT_ADDR BIT(4)
#define B_BE_APP_PLCP_HDR_RPT BIT(3)
#define B_BE_APP_RX_CNT_RPT BIT(2)
#define B_BE_PPDU_STAT_RPT_EN BIT(0)

#define R_BE_RX_SR_CTRL 0x1144A
#define R_BE_RX_SR_CTRL_C1 0x1544A
#define B_BE_SR_OP_MODE_MASK GENMASK(5, 4)
#define B_BE_SRG_CHK_EN BIT(2)
#define B_BE_SR_CTRL_PLCP_EN BIT(1)
#define B_BE_SR_EN BIT(0)

#define R_BE_BSSID_SRC_CTRL 0x1144B
#define R_BE_BSSID_SRC_CTRL_C1 0x1544B
#define B_BE_BSSID_MATCH BIT(3)
#define B_BE_PARTIAL_AID_MATCH BIT(2)
#define B_BE_BSSCOLOR_MATCH BIT(1)
#define B_BE_PLCP_SRC_EN BIT(0)

#define R_BE_CSIRPT_OPTION 0x11464
#define R_BE_CSIRPT_OPTION_C1 0x15464
#define B_BE_CSIPRT_EHTSU_AID_EN BIT(26)
#define B_BE_CSIPRT_HESU_AID_EN BIT(25)
#define B_BE_CSIPRT_VHTSU_AID_EN BIT(24)

#define R_BE_BSR_UPD_CTRL 0x11468
#define R_BE_BSR_UPD_CTRL_C1 0x15468
#define B_BE_QSIZE_RULE BIT(1)
#define B_BE_QSIZE_UPD BIT(0)

#define R_BE_DRV_INFO_OPTION 0x11470
#define R_BE_DRV_INFO_OPTION_C1 0x15470
#define B_BE_DRV_INFO_PHYRPT_EN BIT(0)

#define R_BE_BCN_PSR_RPT_P0 0x11484
#define R_BE_BCN_PSR_RPT_P0_C1 0x15484
#define B_BE_BCAID_P0_MASK GENMASK(10, 0)

#define R_BE_RX_ERR_ISR 0x114F4
#define R_BE_RX_ERR_ISR_C1 0x154F4
#define B_BE_RX_ERR_TRIG_ACT_TO BIT(9)
#define B_BE_RX_ERR_STS_ACT_TO BIT(8)
#define B_BE_RX_ERR_CSI_ACT_TO BIT(7)
#define B_BE_RX_ERR_ACT_TO BIT(6)
#define B_BE_CSI_DATAON_ASSERT_TO BIT(5)
#define B_BE_DATAON_ASSERT_TO BIT(4)
#define B_BE_CCA_ASSERT_TO BIT(3)
#define B_BE_RX_ERR_DMA_TO BIT(2)
#define B_BE_RX_ERR_DATA_TO BIT(1)
#define B_BE_RX_ERR_CCA_TO BIT(0)

#define R_BE_RX_ERR_IMR 0x114F8
#define R_BE_RX_ERR_IMR_C1 0x154F8
#define B_BE_RX_ERR_TRIG_ACT_TO_MSK BIT(9)
#define B_BE_RX_ERR_STS_ACT_TO_MSK BIT(8)
#define B_BE_RX_ERR_CSI_ACT_TO_MSK BIT(7)
#define B_BE_RX_ERR_ACT_TO_MSK BIT(6)
#define B_BE_CSI_DATAON_ASSERT_TO_MSK BIT(5)
#define B_BE_DATAON_ASSERT_TO_MSK BIT(4)
#define B_BE_CCA_ASSERT_TO_MSK BIT(3)
#define B_BE_RX_ERR_DMA_TO_MSK BIT(2)
#define B_BE_RX_ERR_DATA_TO_MSK BIT(1)
#define B_BE_RX_ERR_CCA_TO_MSK BIT(0)
#define B_BE_RX_ERR_IMR_CLR (B_BE_RX_ERR_CCA_TO_MSK | \
			     B_BE_RX_ERR_DATA_TO_MSK | \
			     B_BE_RX_ERR_DMA_TO_MSK | \
			     B_BE_CCA_ASSERT_TO_MSK | \
			     B_BE_DATAON_ASSERT_TO_MSK | \
			     B_BE_CSI_DATAON_ASSERT_TO_MSK | \
			     B_BE_RX_ERR_ACT_TO_MSK | \
			     B_BE_RX_ERR_CSI_ACT_TO_MSK | \
			     B_BE_RX_ERR_STS_ACT_TO_MSK | \
			     B_BE_RX_ERR_TRIG_ACT_TO_MSK)
#define B_BE_RX_ERR_IMR_SET (B_BE_RX_ERR_ACT_TO_MSK | \
			     B_BE_RX_ERR_STS_ACT_TO_MSK | \
			     B_BE_RX_ERR_TRIG_ACT_TO_MSK)

#define R_BE_RX_PLCP_EXT_OPTION_1 0x11514
#define R_BE_RX_PLCP_EXT_OPTION_1_C1 0x15514
#define B_BE_PLCP_CLOSE_RX_UNSPUUORT BIT(19)
#define B_BE_PLCP_CLOSE_RX_BB_BRK BIT(18)
#define B_BE_PLCP_CLOSE_RX_PSDU_PRES BIT(17)
#define B_BE_PLCP_CLOSE_RX_NDP BIT(16)
#define B_BE_PLCP_NSS_SRC BIT(11)
#define B_BE_PLCP_DOPPLEB_BE_SRC BIT(10)
#define B_BE_PLCP_STBC_SRC BIT(9)
#define B_BE_PLCP_SU_PSDU_LEN_SRC BIT(8)
#define B_BE_PLCP_RXSB_SRC BIT(7)
#define B_BE_PLCP_BW_SRC_MASK GENMASK(6, 5)
#define B_BE_PLCP_GILTF_SRC BIT(4)
#define B_BE_PLCP_NSTS_SRC BIT(3)
#define B_BE_PLCP_MCS_SRC BIT(2)
#define B_BE_PLCP_CH20_WIDATA_SRC BIT(1)
#define B_BE_PLCP_PPDU_TYPE_SRC BIT(0)

#define R_BE_RX_PLCP_EXT_OPTION_2 0x11518
#define R_BE_RX_PLCP_EXT_OPTION_2_C1 0x15518
#define B_BE_PLCP_PHASE_B_CRC_CHK_EN BIT(17)
#define B_BE_PLCP_PHASE_A_CRC_CHK_EN BIT(16)
#define B_BE_EHTTB_EHTSIG_CRC_CHK_EN BIT(3)
#define B_BE_EHTTB_USIG_CRC_CHK_EN BIT(2)
#define B_BE_EHTMU_EHTSIG_CRC_CHK_EN BIT(1)
#define B_BE_EHTMU_USIG_CRC_CHK_EN BIT(0)

#define R_BE_RESP_CSI_RESERVED_PAGE 0x11810
#define R_BE_RESP_CSI_RESERVED_PAGE_C1 0x15810
#define B_BE_CSI_RESERVED_PAGE_NUM_MASK GENMASK(27, 16)
#define B_BE_CSI_RESERVED_START_PAGE_MASK GENMASK(11, 0)

#define R_BE_RESP_IMR1 0x11878
#define R_BE_RESP_IMR1_C1 0x15878
#define B_BE_RESP_IMR_1_MASK GENMASK(31, 9)
#define B_BE_FSM_TIMEOUT_ERR_IMR BIT(8)
#define B_BE_SEC_DOUBLE_HIT_ERR_IMR BIT(7)
#define B_BE_WRPTR_ERR_IMR BIT(6)
#define B_BE_SMR_TOO_MANY_PLD_ERR_IMR BIT(5)
#define B_BE_LMR_TOO_MANY_PLD_ERR_IMR BIT(4)
#define B_BE_CSI_TOO_MANY_PLD_ERR_IMR BIT(3)
#define B_BE_FTM_LMR_PLDID_READY_ERR_IMR BIT(2)
#define B_BE_SMR_PLDID_READY_ERR_IMR BIT(1)
#define B_BE_CSI_PLDID_READY_ERR_IMR BIT(0)
#define B_BE_RESP_IMR1_CLR 0x1FF
#define B_BE_RESP_IMR1_SET 0xFF

#define R_BE_RESP_IMR 0x11884
#define R_BE_RESP_IMR_C1 0x15884
#define B_BE_RESP_TBL_FLAG_ERR_ISR_EN BIT(17)
#define B_BE_RESP_SEC_DOUBLE_HIT_ERR_ISR_EN BIT(16)
#define B_BE_RESP_WRPTR_CROSS_ERR_ISR_EN BIT(15)
#define B_BE_RESP_TOO_MANY_PLD_ERR_ISR_EN BIT(14)
#define B_BE_RESP_TXDMA_READ_DATA_ERR_ISR_EN BIT(13)
#define B_BE_RESP_PLDID_RDY_ERR_ISR_EN BIT(12)
#define B_BE_RESP_RX_OVERWRITE_ERR_ISR_EN BIT(11)
#define B_BE_RESP_RXDMA_WRPTR_INVLD_ERR_ISR_EN BIT(10)
#define B_BE_RESP_RXDMA_REQ_INVLD_ERR_ISR_EN BIT(9)
#define B_BE_RESP_RXDMA_REQ_MACID_ERR_ISR_EN BIT(8)
#define B_BE_RESP_TXCMD_TX_ST_ABORT_ERR_ISR_EN BIT(6)
#define B_BE_RESP_TXCMD_DMAC_PROC_ERR_ISR_EN BIT(5)
#define B_BE_RESP_TXCMD_TBL_ERR_ISR_EN BIT(4)
#define B_BE_RESP_INITCMD_RX_ST_ABORT_ERR_ISR_EN BIT(3)
#define B_BE_RESP_INITCMD_RESERVD_PAGE_ABORT_ERR_ISR_EN BIT(2)
#define B_BE_RESP_INITCMD_TX_ST_ABORT_ERR_ISR_EN BIT(1)
#define B_BE_RESP_DMAC_PROC_ERR_ISR_EN BIT(0)
#define B_BE_RESP_IMR_CLR (B_BE_RESP_DMAC_PROC_ERR_ISR_EN | \
			   B_BE_RESP_INITCMD_TX_ST_ABORT_ERR_ISR_EN | \
			   B_BE_RESP_INITCMD_RX_ST_ABORT_ERR_ISR_EN | \
			   B_BE_RESP_TXCMD_TBL_ERR_ISR_EN | \
			   B_BE_RESP_TXCMD_DMAC_PROC_ERR_ISR_EN | \
			   B_BE_RESP_TXCMD_TX_ST_ABORT_ERR_ISR_EN | \
			   B_BE_RESP_RXDMA_REQ_MACID_ERR_ISR_EN | \
			   B_BE_RESP_RXDMA_REQ_INVLD_ERR_ISR_EN | \
			   B_BE_RESP_RXDMA_WRPTR_INVLD_ERR_ISR_EN | \
			   B_BE_RESP_RX_OVERWRITE_ERR_ISR_EN | \
			   B_BE_RESP_PLDID_RDY_ERR_ISR_EN | \
			   B_BE_RESP_TXDMA_READ_DATA_ERR_ISR_EN | \
			   B_BE_RESP_TOO_MANY_PLD_ERR_ISR_EN | \
			   B_BE_RESP_WRPTR_CROSS_ERR_ISR_EN | \
			   B_BE_RESP_SEC_DOUBLE_HIT_ERR_ISR_EN)
#define B_BE_RESP_IMR_SET (B_BE_RESP_DMAC_PROC_ERR_ISR_EN | \
			   B_BE_RESP_INITCMD_TX_ST_ABORT_ERR_ISR_EN | \
			   B_BE_RESP_INITCMD_RX_ST_ABORT_ERR_ISR_EN | \
			   B_BE_RESP_TXCMD_TBL_ERR_ISR_EN | \
			   B_BE_RESP_TXCMD_DMAC_PROC_ERR_ISR_EN | \
			   B_BE_RESP_TXCMD_TX_ST_ABORT_ERR_ISR_EN | \
			   B_BE_RESP_RX_OVERWRITE_ERR_ISR_EN | \
			   B_BE_RESP_PLDID_RDY_ERR_ISR_EN | \
			   B_BE_RESP_WRPTR_CROSS_ERR_ISR_EN | \
			   B_BE_RESP_SEC_DOUBLE_HIT_ERR_ISR_EN)
#define B_BE_RESP_IMR_CLR_V1 0xFFFFFFFF
#define B_BE_RESP_IMR_SET_V1 0xFFFFFFFF

#define R_BE_PWR_MODULE 0x11900
#define R_BE_PWR_MODULE_C1 0x15900
#define R_BE_PWR_LISTEN_PATH 0x11988
#define B_BE_PWR_LISTEN_PATH_EN GENMASK(31, 28)

#define R_BE_PWR_REF_CTRL 0x11A20
#define B_BE_PWR_REF_CTRL_OFDM GENMASK(9, 1)
#define B_BE_PWR_REF_CTRL_CCK GENMASK(18, 10)
#define B_BE_PWR_OFST_LMT_DB GENMASK(27, 19)
#define R_BE_PWR_OFST_LMTBF 0x11A24
#define B_BE_PWR_OFST_LMTBF_DB GENMASK(8, 0)
#define R_BE_PWR_FORCE_LMT 0x11A28
#define B_BE_PWR_FORCE_LMT_ON BIT(6)

#define R_BE_PWR_RATE_CTRL 0x11A2C
#define B_BE_PWR_OFST_BYRATE_DB GENMASK(8, 0)
#define B_BE_FORCE_PWR_BY_RATE_EN BIT(19)
#define B_BE_FORCE_PWR_BY_RATE_VAL GENMASK(28, 20)

#define R_BE_PWR_RATE_OFST_CTRL 0x11A30
#define R_BE_PWR_RATE_OFST_END 0x11A38
#define R_BE_PWR_RULMT_START 0x12048
#define R_BE_PWR_RULMT_END 0x120e4

#define R_BE_PWR_BOOST 0x11A40
#define B_BE_PWR_CTRL_SEL BIT(16)
#define B_BE_PWR_FORCE_RATE_ON BIT(29)
#define R_BE_PWR_OFST_RULMT 0x11A44
#define B_BE_PWR_OFST_RULMT_DB GENMASK(17, 9)
#define B_BE_PWR_FORCE_RU_ON BIT(18)
#define B_BE_PWR_FORCE_RU_ENON BIT(28)
#define R_BE_PWR_FORCE_MACID 0x11A48
#define B_BE_PWR_FORCE_MACID_DBM_ON BIT(9)
#define B_BE_PWR_FORCE_MACID_DBM_VAL GENMASK(17, 10)
#define B_BE_PWR_FORCE_MACID_EN_VAL BIT(18)
#define B_BE_PWR_FORCE_MACID_EN_ON BIT(19)
#define B_BE_PWR_FORCE_MACID_ALL \
	(B_BE_PWR_FORCE_MACID_DBM_ON | \
	 B_BE_PWR_FORCE_MACID_DBM_VAL | \
	 B_BE_PWR_FORCE_MACID_EN_VAL | \
	 B_BE_PWR_FORCE_MACID_EN_ON)

#define R_BE_PWR_REG_CTRL 0x11A50
#define B_BE_PWR_BT_EN BIT(23)

#define R_BE_PWR_COEX_CTRL 0x11A54
#define B_BE_PWR_BT_VAL GENMASK(8, 0)
#define B_BE_PWR_FORCE_COEX_ON GENMASK(29, 27)

#define R_BE_PWR_TH 0x11A78
#define R_BE_PWR_RSSI_TARGET_LMT 0x11A84

#define R_BE_PWR_OFST_SW 0x11AE8
#define B_BE_PWR_OFST_SW_DB GENMASK(27, 24)

#define R_BE_PWR_FTM 0x11B00
#define R_BE_PWR_FTM_SS 0x11B04
#define B_BE_PWR_BY_RATE_DBW_ON GENMASK(27, 26)

#define R_BE_PWR_BY_RATE 0x11E00
#define R_BE_PWR_BY_RATE_MAX 0x11FA8
#define R_BE_PWR_LMT 0x11FAC
#define R_BE_PWR_LMT_MAX 0x12040
#define R_BE_PWR_BY_RATE_END 0x12044
#define R_BE_PWR_RU_LMT 0x12048
#define R_BE_PWR_RU_LMT_MAX 0x120E4

#define R_BE_C0_TXPWR_IMR 0x128E0
#define R_BE_C0_TXPWR_IMR_C1 0x168E0
#define B_BE_FSM_TIMEOUT_ERR_INT_EN BIT(0)
#define B_BE_C0_TXPWR_IMR_CLR B_BE_FSM_TIMEOUT_ERR_INT_EN
#define B_BE_C0_TXPWR_IMR_SET B_BE_FSM_TIMEOUT_ERR_INT_EN

#define R_BE_TXPWR_ERR_FLAG 0x128E4
#define R_BE_TXPWR_ERR_IMR 0x128E0
#define R_BE_TXPWR_ERR_FLAG_C1 0x158E4
#define R_BE_TXPWR_ERR_IMR_C1 0x158E0

#define R_BE_SCH_EXT_CTRL 0x103FC
#define R_BE_SCH_EXT_CTRL_C1 0x143FC
#define B_BE_CWCNT_PLUS_MODE BIT(31)

#define CMAC1_START_ADDR_BE 0x14000
#define CMAC1_END_ADDR_BE 0x17FFF

#define RR_MOD 0x00
#define RR_MOD_V1 0x10000
#define RR_MOD_IQK GENMASK(19, 4)
#define RR_MOD_DPK GENMASK(19, 5)
#define RR_MOD_MASK GENMASK(19, 16)
#define RR_MOD_DCK GENMASK(14, 10)
#define RR_MOD_RGM GENMASK(13, 4)
#define RR_MOD_RXB GENMASK(9, 5)
#define RR_MOD_V_DOWN 0x0
#define RR_MOD_V_STANDBY 0x1
#define RR_TXAGC 0x10001
#define RR_MOD_V_TX 0x2
#define RR_MOD_V_RX 0x3
#define RR_MOD_V_TXIQK 0x4
#define RR_MOD_V_DPK 0x5
#define RR_MOD_V_RXK1 0x6
#define RR_MOD_V_RXK2 0x7
#define RR_MOD_NBW GENMASK(15, 14)
#define RR_MOD_M_RXG GENMASK(13, 4)
#define RR_MOD_M_RXBB GENMASK(9, 5)
#define RR_MOD_LO_SEL BIT(1)
#define RR_MODOPT 0x01
#define RR_TXG_SEL GENMASK(19, 17)
#define RR_MODOPT_M_TXPWR GENMASK(5, 0)
#define RR_WLSEL 0x02
#define RR_WLSEL_AG GENMASK(18, 16)
#define RR_RSV1 0x05
#define RR_RSV1_RST BIT(0)
#define RR_BBDC 0x10005
#define RR_BBDC_SEL BIT(0)
#define RR_DTXLOK 0x08
#define RR_RSV2 0x09
#define RR_LOKVB 0x0a
#define RR_LOKVB_COI GENMASK(19, 14)
#define RR_LOKVB_COQ GENMASK(9, 4)
#define RR_TXIG 0x11
#define RR_TXIG_TG GENMASK(16, 12)
#define RR_TXIG_GR1 GENMASK(6, 4)
#define RR_TXIG_GR0 GENMASK(1, 0)
#define RR_CHTR 0x17
#define RR_CHTR_MOD GENMASK(11, 10)
#define RR_CHTR_TXRX GENMASK(9, 0)
#define RR_CFGCH 0x18
#define RR_CFGCH_V1 0x10018
#define RR_CFGCH_BAND1 GENMASK(17, 16)
#define CFGCH_BAND1_2G 0
#define CFGCH_BAND1_5G 1
#define CFGCH_BAND1_6G 3
#define RR_CFGCH_POW_LCK BIT(15)
#define RR_CFGCH_TRX_AH BIT(14)
#define RR_CFGCH_BCN BIT(13)
#define RR_CFGCH_BW2 BIT(12)
#define RR_CFGCH_BAND0 GENMASK(9, 8)
#define CFGCH_BAND0_2G 0
#define CFGCH_BAND0_5G 1
#define CFGCH_BAND0_6G 0
#define RR_CFGCH_BW_V2 GENMASK(12, 10)
#define CFGCH_BW_V2_20M 0
#define CFGCH_BW_V2_40M 1
#define CFGCH_BW_V2_80M 2
#define CFGCH_BW_V2_160M 3
#define CFGCH_BW_V2_320M 4
#define RR_CFGCH_BW GENMASK(11, 10)
#define RR_CFGCH_CH GENMASK(7, 0)
#define CFGCH_BW_20M 3
#define CFGCH_BW_40M 2
#define CFGCH_BW_80M 1
#define CFGCH_BW_160M 0
#define RR_APK 0x19
#define RR_APK_MOD GENMASK(5, 4)
#define RR_BTC 0x1a
#define RR_BTC_TXBB GENMASK(14, 12)
#define RR_BTC_RXBB GENMASK(11, 10)
#define RR_RCKC 0x1b
#define RR_RCKC_CA GENMASK(14, 10)
#define RR_RCKS 0x1c
#define RR_RCKO 0x1d
#define RR_RCKO_OFF GENMASK(13, 9)
#define RR_RXKPLL 0x1e
#define RR_RXKPLL_OFF GENMASK(5, 0)
#define RR_RXKPLL_POW BIT(19)
#define RR_RSV4 0x1f
#define RR_RSV4_AGH GENMASK(17, 16)
#define RR_RSV4_PLLCH GENMASK(9, 0)
#define RR_RXK 0x20
#define RR_RXK_SEL2G BIT(8)
#define RR_RXK_SEL5G BIT(7)
#define RR_RXK_PLLEN BIT(5)
#define RR_LUTWA 0x33
#define RR_LUTWA_MASK GENMASK(9, 0)
#define RR_LUTWA_M1 GENMASK(7, 0)
#define RR_LUTWA_M2 GENMASK(4, 0)
#define RR_LUTWD1 0x3e
#define RR_LUTWD0 0x3f
#define RR_LUTWD0_MB GENMASK(11, 6)
#define RR_LUTWD0_LB GENMASK(5, 0)
#define RR_TM 0x42
#define RR_TM_TRI BIT(19)
#define RR_TM_VAL_V1 GENMASK(7, 0)
#define RR_TM_VAL GENMASK(6, 1)
#define RR_TM2 0x43
#define RR_TM2_OFF GENMASK(19, 16)
#define RR_TXG1 0x51
#define RR_TXG1_ATT2 BIT(19)
#define RR_TXG1_ATT1 BIT(11)
#define RR_TXG2 0x52
#define RR_TXG2_ATT0 BIT(11)
#define RR_BSPAD 0x54
#define RR_TXGA 0x55
#define RR_TXGA_TRK_EN BIT(7)
#define RR_TXGA_LOK_EXT GENMASK(4, 0)
#define RR_TXGA_LOK_EN BIT(0)
#define RR_TXGA_V1 0x10055
#define RR_TXGA_V1_TRK_EN BIT(7)
#define RR_GAINTX 0x56
#define RR_GAINTX_ALL GENMASK(15, 0)
#define RR_GAINTX_PAD GENMASK(9, 5)
#define RR_GAINTX_BB GENMASK(4, 0)
#define RR_TXMO 0x58
#define RR_TXMO_COI GENMASK(19, 15)
#define RR_TXMO_COQ GENMASK(14, 10)
#define RR_TXMO_FII GENMASK(9, 6)
#define RR_TXMO_FIQ GENMASK(5, 2)
#define RR_TXA 0x5d
#define RR_TXA_TRK GENMASK(19, 14)
#define RR_TXRSV 0x5c
#define RR_TXRSV_GAPK BIT(19)
#define RR_BIAS 0x5e
#define RR_BIAS_GAPK BIT(19)
#define RR_TXAC 0x5f
#define RR_TXAC_IQG GENMASK(3, 0)
#define RR_BIASA 0x60
#define RR_BIASA_TXA GENMASK(19, 16)
#define RR_BIASA_TXG GENMASK(15, 12)
#define RR_BIASD_TXA_V1 GENMASK(15, 12)
#define RR_BIASA_TXA_V1 GENMASK(11, 8)
#define RR_BIASD_TXG_V1 GENMASK(7, 4)
#define RR_BIASA_TXG_V1 GENMASK(3, 0)
#define RR_BIASA_A GENMASK(2, 0)
#define RR_BIASA2 0x63
#define RR_BIASA2_LB GENMASK(4, 2)
#define RR_TXATANK 0x64
#define RR_TXATANK_LBSW2 GENMASK(17, 15)
#define RR_TXATANK_LBSW GENMASK(16, 15)
#define RR_TXA2 0x65
#define RR_TXA2_LDO GENMASK(19, 16)
#define RR_TRXIQ 0x66
#define RR_RSV6 0x6d
#define RR_TXVBUF 0x7c
#define RR_TXVBUF_DACEN BIT(5)
#define RR_TXPOW 0x7f
#define RR_TXPOW_TXA BIT(8)
#define RR_TXPOW_TXAS BIT(7)
#define RR_TXPOW_TXG BIT(1)
#define RR_RXPOW 0x80
#define RR_RXPOW_IQK GENMASK(17, 16)
#define RR_RXBB 0x83
#define RR_RXBB_VOBUF GENMASK(15, 12)
#define RR_RXBB_C2G GENMASK(16, 10)
#define RR_RXBB_C2 GENMASK(11, 8)
#define RR_RXBB_C1G GENMASK(9, 8)
#define RR_RXBB_FATT GENMASK(7, 0)
#define RR_RXBB_ATTR GENMASK(7, 4)
#define RR_RXBB_ATTC GENMASK(2, 0)
#define RR_RXG 0x84
#define RR_RXG_IQKMOD GENMASK(19, 16)
#define RR_XGLNA2 0x85
#define RR_XGLNA2_SW GENMASK(1, 0)
#define RR_RXAE 0x89
#define RR_RXAE_IQKMOD GENMASK(3, 0)
#define RR_RXA 0x8a
#define RR_RXA_DPK GENMASK(9, 8)
#define RR_RXA_LNA 0x8b
#define RR_RXA2 0x8c
#define RR_RAA2_SATT GENMASK(15, 13)
#define RR_RAA2_SWATT GENMASK(15, 9)
#define RR_RXA2_C1 GENMASK(12, 10)
#define RR_RXA2_C2 GENMASK(9, 3)
#define RR_RXA2_CC2 GENMASK(8, 7)
#define RR_RXA2_IATT GENMASK(7, 4)
#define RR_RXA2_HATT GENMASK(6, 0)
#define RR_RXA2_ATT GENMASK(3, 0)
#define RR_RXIQGEN 0x8d
#define RR_RXIQGEN_ATTL GENMASK(12, 8)
#define RR_RXIQGEN_ATTH GENMASK(14, 13)
#define RR_RXBB2 0x8f
#define RR_RXBB2_DAC_EN BIT(13)
#define RR_RXBB2_CKT BIT(12)
#define RR_EN_TIA_IDA GENMASK(11, 10)
#define RR_RXBB2_IDAC GENMASK(11, 9)
#define RR_RXBB2_EBW GENMASK(6, 5)
#define RR_XALNA2 0x90
#define RR_XALNA2_SW2 GENMASK(9, 8)
#define RR_XALNA2_SW GENMASK(1, 0)
#define RR_DCK 0x92
#define RR_DCK_S1 GENMASK(19, 16)
#define RR_DCK_TIA GENMASK(15, 9)
#define RR_DCK_DONE GENMASK(7, 5)
#define RR_DCK_FINE BIT(1)
#define RR_DCK_LV BIT(0)
#define RR_DCK1 0x93
#define RR_DCK1_S1 GENMASK(19, 16)
#define RR_DCK1_TIA GENMASK(15, 9)
#define RR_DCK1_DONE BIT(5)
#define RR_DCK1_CLR GENMASK(3, 0)
#define RR_DCK1_SEL BIT(3)
#define RR_DCK2 0x94
#define RR_DCK2_CYCLE GENMASK(7, 2)
#define RR_DCKC 0x95
#define RR_DCKC_CHK BIT(3)
#define RR_IQGEN 0x97
#define RR_IQGEN_BIAS GENMASK(11, 8)
#define RR_TXIQK 0x98
#define RR_TXIQK_ATT2 GENMASK(15, 12)
#define RR_TXIQK_ATT1 GENMASK(6, 0)
#define RR_TIA 0x9e
#define RR_TIA_N6 BIT(8)
#define RR_MIXER 0x9f
#define RR_MIXER_GN GENMASK(4, 3)
#define RR_POW 0xa0
#define RR_POW_SYN GENMASK(3, 2)
#define RR_POW_SYN_V1 GENMASK(3, 0)
#define RR_LOGEN 0xa3
#define RR_LOGEN_RPT GENMASK(19, 16)
#define RR_SX 0xaf
#define RR_IBD 0xc9
#define RR_IBD_VAL GENMASK(4, 0)
#define RR_LDO 0xb1
#define RR_LDO_SEL GENMASK(8, 6)
#define RR_VCO 0xb2
#define RR_VCO_SEL GENMASK(9, 8)
#define RR_VCI 0xb3
#define RR_VCI_ON BIT(7)
#define RR_LPF 0xb7
#define RR_LPF_BUSY BIT(8)
#define RR_XTALX2 0xb8
#define RR_MALSEL 0xbe
#define RR_SYNFB 0xc5
#define RR_SYNFB_LK BIT(15)
#define RR_AACK 0xca
#define RR_LCKST 0xcf
#define RR_LCKST_BIN BIT(0)
#define RR_LCK_TRG 0xd3
#define RR_LCK_TRGSEL BIT(8)
#define RR_LCK_ST BIT(4)
#define RR_MMD 0xd5
#define RR_MMD_RST_EN BIT(8)
#define RR_MMD_RST_SYN BIT(6)
#define RR_SMD 0xd6
#define RR_VCO2 BIT(19)
#define RR_IQKPLL 0xdc
#define RR_IQKPLL_MOD GENMASK(9, 8)
#define RR_SYNLUT 0xdd
#define RR_SYNLUT_MOD BIT(4)
#define RR_RCKD 0xde
#define RR_RCKD_POW GENMASK(19, 13)
#define RR_RCKD_BW BIT(2)
#define RR_TXADBG 0xde
#define RR_LUTDBG 0xdf
#define RR_LUTDBG_TIA BIT(12)
#define RR_LUTDBG_LOK BIT(2)
#define RR_LUTPLL 0xec
#define RR_CAL_RW BIT(19)
#define RR_LUTWE2 0xee
#define RR_LUTWE2_RTXBW BIT(2)
#define RR_LUTWE2_DIS BIT(6)
#define RR_LUTWE 0xef
#define RR_LUTWE_LOK BIT(2)
#define RR_RFC 0xf0
#define RR_WCAL BIT(16)
#define RR_RFC_CKEN BIT(1)

#define R_UPD_P0 0x0000
#define R_BBCLK 0x0000
#define B_CLK_640M BIT(2)
#define R_RSTB_WATCH_DOG 0x000C
#define B_P0_RSTB_WATCH_DOG BIT(0)
#define B_P1_RSTB_WATCH_DOG BIT(1)
#define B_UPD_P0_EN BIT(31)
#define R_EMLSR 0x0044
#define B_EMLSR_PARM GENMASK(27, 12)
#define R_CHK_LPS_STAT_BE4 0x3007C
#define R_CHK_LPS_STAT 0x0058
#define B_CHK_LPS_STAT BIT(0)
#define R_SPOOF_CG 0x00B4
#define B_SPOOF_CG_EN BIT(17)
#define R_CHINFO_SEG 0x00B4
#define B_CHINFO_SEG_LEN GENMASK(2, 0)
#define B_CHINFO_SEG GENMASK(16, 7)
#define R_DFS_FFT_CG 0x00B8
#define B_DFS_CG_EN BIT(1)
#define B_DFS_FFT_EN BIT(0)
#define R_CHINFO_DATA 0x00C0
#define B_CHINFO_DATA_BITMAP GENMASK(22, 0)
#define R_ANAPAR_PW15 0x030C
#define B_ANAPAR_PW15 GENMASK(31, 24)
#define B_ANAPAR_PW15_H GENMASK(27, 24)
#define B_ANAPAR_PW15_H2 GENMASK(27, 26)
#define R_ANAPAR 0x032C
#define B_ANAPAR_15 GENMASK(31, 16)
#define B_ANAPAR_EN1 BIT(31)
#define B_ANAPAR_ADCCLK BIT(30)
#define B_ANAPAR_FLTRST BIT(22)
#define B_ANAPAR_CRXBB GENMASK(18, 16)
#define B_ANAPAR_EN BIT(16)
#define B_ANAPAR_14 GENMASK(15, 0)
#define R_RFE_E_A2 0x0334
#define R_RFE_O_SEL_A2 0x0338
#define R_RFE_SEL0_A2 0x033C
#define B_RFE_SEL0_MASK GENMASK(1, 0)
#define R_RFE_SEL32_A2 0x0340
#define R_CIRST 0x035c
#define B_CIRST_SYN GENMASK(11, 10)
#define R_SWSI_DATA_V1 0x0370
#define B_SWSI_DATA_VAL_V1 GENMASK(19, 0)
#define B_SWSI_DATA_ADDR_V1 GENMASK(27, 20)
#define B_SWSI_DATA_PATH_V1 GENMASK(30, 28)
#define B_SWSI_DATA_BIT_MASK_EN_V1 BIT(31)
#define R_SWSI_BIT_MASK_V1 0x0374
#define B_SWSI_BIT_MASK_V1 GENMASK(19, 0)
#define R_SWSI_READ_ADDR_V1 0x0378
#define B_SWSI_READ_ADDR_ADDR_V1 GENMASK(7, 0)
#define B_SWSI_READ_ADDR_PATH_V1 GENMASK(10, 8)
#define B_SWSI_READ_ADDR_V1 GENMASK(10, 0)
#define R_BRK_R 0x0418
#define B_VHTMCS_LMT GENMASK(22, 21)
#define B_HTMCS_LMT GENMASK(9, 8)
#define R_BRK_EHT 0x0474
#define B_RXEHT_NSS_MAX GENMASK(4, 2)
#define R_BRK_RXEHT 0x0478
#define B_RXEHT_N_USER_MAX GENMASK(31, 24)
#define B_RXEHTTB_NSS_MAX GENMASK(16, 14)
#define R_EN_SND_WO_NDP 0x047c
#define R_EN_SND_WO_NDP_C1 0x147c
#define B_EN_SND_WO_NDP BIT(1)
#define R_BRK_HE 0x0480
#define B_TB_NSS_MAX GENMASK(25, 23)
#define B_NSS_MAX GENMASK(16, 14)
#define B_N_USR_MAX GENMASK(13, 6)
#define R_RXCCA_BE1 0x0520
#define B_RXCCA_BE1_DIS BIT(0)
#define R_UPD_CLK_ADC 0x0700
#define B_UPD_GEN_ON BIT(27)
#define B_UPD_CLK_ADC_VAL GENMASK(26, 25)
#define B_UPD_CLK_ADC_ON BIT(24)
#define B_ENABLE_CCK BIT(5)
#define R_RSTB_ASYNC 0x0704
#define B_RSTB_ASYNC_BW80 GENMASK(9, 8)
#define B_RSTB_ASYNC_ALL BIT(1)
#define R_P0_ANT_SW 0x0728
#define B_P0_HW_ANTSW_DIS_BY_GNT_BT BIT(12)
#define B_P0_TRSW_TX_EXTEND GENMASK(3, 0)
#define R_MAC_PIN_SEL 0x0734
#define B_CH_IDX_SEG0 GENMASK(23, 16)
#define R_PLCP_HISTOGRAM 0x0738
#define R_PLCP_HISTOGRAM_BE_V1 0x20738
#define B_STS_PARSING_TIME GENMASK(19, 16)
#define B_STS_DIS_TRIG_BY_FAIL BIT(3)
#define B_STS_DIS_TRIG_BY_BRK BIT(2)
#define R_PHY_STS_BITMAP_ADDR_START R_PHY_STS_BITMAP_SEARCH_FAIL
#define R_PHY_STS_BITMAP_ADDR_START_BE4 0x2073C
#define B_PHY_STS_BITMAP_ADDR_MASK GENMASK(6, 2)
#define R_PHY_STS_BITMAP_SEARCH_FAIL 0x073C
#define B_PHY_STS_BITMAP_MSK_52A 0x337cff3f
#define R_PHY_STS_BITMAP_R2T 0x0740
#define R_PHY_STS_BITMAP_CCA_SPOOF 0x0744
#define R_PHY_STS_BITMAP_OFDM_BRK 0x0748
#define R_PHY_STS_BITMAP_CCK_BRK 0x074C
#define R_PHY_STS_BITMAP_DL_MU_SPOOF 0x0750
#define R_PHY_STS_BITMAP_HE_MU 0x0754
#define R_PHY_STS_BITMAP_VHT_MU 0x0758
#define R_PHY_STS_BITMAP_UL_TB_SPOOF 0x075C
#define R_PHY_STS_BITMAP_TRIGBASE 0x0760
#define R_PHY_STS_BITMAP_CCK 0x0764
#define R_PHY_STS_BITMAP_LEGACY 0x0768
#define R_PHY_STS_BITMAP_HT 0x076C
#define R_PHY_STS_BITMAP_VHT 0x0770
#define R_PHY_STS_BITMAP_HE 0x0774
#define R_PHY_STS_BITMAP_EHT 0x0788
#define R_PHY_STS_BITMAP_EHT_BE4 0x20788
#define R_EDCCA_RPTREG_SEL_BE 0x078C
#define B_EDCCA_RPTREG_SEL_BE_MSK GENMASK(22, 20)
#define R_PMAC_GNT 0x0980
#define B_PMAC_GNT_TXEN BIT(0)
#define B_PMAC_GNT_RXEN BIT(16)
#define B_PMAC_GNT_P1 GENMASK(20, 17)
#define B_PMAC_GNT_P2 GENMASK(29, 26)
#define R_PMAC_RX_CFG1 0x0988
#define B_PMAC_OPT1_MSK GENMASK(11, 0)
#define R_PMAC_RXMOD 0x0994
#define B_PMAC_RXMOD_MSK GENMASK(7, 4)
#define R_MAC_SEL 0x09A4
#define B_MAC_SEL_OFDM_TRI_FILTER BIT(31)
#define B_MAC_SEL GENMASK(19, 17)
#define B_MAC_SEL_PWR_EN BIT(16)
#define B_MAC_SEL_DPD_EN BIT(10)
#define B_MAC_SEL_MOD GENMASK(4, 2)
#define R_PMAC_TX_CTRL 0x09C0
#define B_PMAC_TXEN_DIS BIT(0)
#define R_PMAC_TX_PRD 0x09C4
#define B_PMAC_TX_PRD_MSK GENMASK(31, 8)
#define B_PMAC_CTX_EN BIT(0)
#define B_PMAC_PTX_EN BIT(4)
#define R_PMAC_TX_CNT 0x09C8
#define B_PMAC_TX_CNT_MSK GENMASK(31, 0)
#define R_P80_AT_HIGH_FREQ 0x09D8
#define B_P80_AT_HIGH_FREQ BIT(26)
#define R_DBCC_80P80_SEL_EVM_RPT 0x0A10
#define B_DBCC_80P80_SEL_EVM_RPT_EN BIT(0)
#define R_CCX 0x0C00
#define R_CCX_BE4 0x20C00
#define B_CCX_EDCCA_OPT_MSK GENMASK(6, 4)
#define B_CCX_EDCCA_OPT_MSK_V1 GENMASK(7, 4)
#define B_MEASUREMENT_TRIG_MSK BIT(2)
#define B_CCX_TRIG_OPT_MSK BIT(1)
#define B_CCX_EN_MSK BIT(0)
#define R_NHM_CFG 0x0C08
#define B_NHM_PERIOD_MSK GENMASK(15, 0)
#define B_NHM_COUNTER_MSK GENMASK(17, 16)
#define B_NHM_EN_MSK BIT(18)
#define B_NHM_INCLUDE_CCA_MSK BIT(19)
#define B_NHM_TH0_MSK GENMASK(31, 24)
#define R_NHM_TH1 0x0C0C
#define B_NHM_TH1_MSK GENMASK(7, 0)
#define B_NHM_TH2_MSK GENMASK(15, 8)
#define B_NHM_TH3_MSK GENMASK(23, 16)
#define B_NHM_TH4_MSK GENMASK(31, 24)
#define R_NHM_TH5 0x0C10
#define B_NHM_TH5_MSK GENMASK(7, 0)
#define B_NHM_TH6_MSK GENMASK(15, 8)
#define B_NHM_TH7_MSK GENMASK(23, 16)
#define B_NHM_TH8_MSK GENMASK(31, 24)
#define R_NHM_TH9 0x0C14
#define B_NHM_TH9_MSK GENMASK(7, 0)
#define B_NHM_TH10_MSK GENMASK(15, 8)
#define B_NHM_PWDB_METHOD_MSK GENMASK(17, 16)
#define R_FAHM 0x0C1C
#define B_RXTD_CKEN BIT(2)
#define R_IFS_COUNTER 0x0C28
#define R_IFS_COUNTER_BE4 0x20C28
#define B_IFS_CLM_PERIOD_MSK GENMASK(31, 16)
#define B_IFS_CLM_COUNTER_UNIT_MSK GENMASK(15, 14)
#define B_IFS_COUNTER_CLR_MSK BIT(13)
#define B_IFS_COLLECT_EN BIT(12)
#define R_IFS_T1 0x0C2C
#define R_IFS_T1_BE4 0x20C2C
#define B_IFS_T1_TH_HIGH_MSK GENMASK(31, 16)
#define B_IFS_T1_EN_MSK BIT(15)
#define B_IFS_T1_TH_LOW_MSK GENMASK(14, 0)
#define R_IFS_T2 0x0C30
#define R_IFS_T2_BE4 0x20C30
#define B_IFS_T2_TH_HIGH_MSK GENMASK(31, 16)
#define B_IFS_T2_EN_MSK BIT(15)
#define B_IFS_T2_TH_LOW_MSK GENMASK(14, 0)
#define R_IFS_T3 0x0C34
#define R_IFS_T3_BE4 0x20C34
#define B_IFS_T3_TH_HIGH_MSK GENMASK(31, 16)
#define B_IFS_T3_EN_MSK BIT(15)
#define B_IFS_T3_TH_LOW_MSK GENMASK(14, 0)
#define R_IFS_T4 0x0C38
#define R_IFS_T4_BE4 0x20C38
#define B_IFS_T4_TH_HIGH_MSK GENMASK(31, 16)
#define B_IFS_T4_EN_MSK BIT(15)
#define B_IFS_T4_TH_LOW_MSK GENMASK(14, 0)
#define R_PD_CTRL 0x0C3C
#define B_PD_HIT_DIS BIT(9)
#define R_IOQ_IQK_DPK 0x0C60
#define R_IOQ_IQK_DPK_BE4 0x20C60
#define B_IOQ_IQK_DPK_CLKEN GENMASK(1, 0)
#define B_IOQ_IQK_DPK_EN BIT(1)
#define B_IOQ_IQK_DPK_RST BIT(0)
#define R_GNT_BT_WGT_EN 0x0C6C
#define B_GNT_BT_WGT_EN BIT(21)
#define R_IQK_DPK_RST 0x0C6C
#define R_IQK_DPK_RST_BE4 0x20C6C
#define R_IQK_DPK_RST_C1 0x1C6C
#define B_IQK_DPK_RST BIT(0)
#define R_TX_COLLISION_T2R_ST 0x0C70
#define B_TX_COLLISION_T2R_ST_M GENMASK(25, 20)
#define B_TXRX_FORCE_VAL GENMASK(9, 0)
#define R_TXGATING 0x0C74
#define B_TXGATING_EN BIT(4)
#define R_TXRFC 0x0C7C
#define R_TXRFC_C1 0x1C7C
#define B_TXRFC_RST GENMASK(23, 21)
#define R_PD_ARBITER_OFF 0x0C80
#define B_PD_ARBITER_OFF BIT(31)
#define R_SNDCCA_A1 0x0C9C
#define B_SNDCCA_A1_EN GENMASK(19, 12)
#define R_SNDCCA_A2 0x0CA0
#define B_SNDCCA_A2_VAL GENMASK(19, 12)
#define R_UDP_COEEF 0x0CBC
#define B_UDP_COEEF BIT(19)
#define R_TX_COLLISION_T2R_ST_BE 0x0CC8
#define B_TX_COLLISION_T2R_ST_BE_M GENMASK(13, 8)
#define R_RXHT_MCS_LIMIT 0x0D18
#define B_RXHT_MCS_LIMIT GENMASK(9, 8)
#define R_RXVHT_MCS_LIMIT 0x0D18
#define B_RXVHT_MCS_LIMIT GENMASK(22, 21)
#define R_P0_EN_SOUND_WO_NDP 0x0D7C
#define B_P0_EN_SOUND_WO_NDP BIT(1)
#define R_RXHE 0x0D80
#define B_RXHETB_MAX_NSS GENMASK(25, 23)
#define B_RXHE_MAX_NSS GENMASK(16, 14)
#define B_RXHE_USER_MAX GENMASK(13, 6)
#define R_SPOOF_ASYNC_RST 0x0D84
#define B_SPOOF_ASYNC_RST BIT(15)
#define R_NDP_BRK0 0xDA0
#define R_NDP_BRK1 0xDA4
#define B_NDP_RU_BRK BIT(0)
#define R_BRK_ASYNC_RST_EN_1 0x0DC0
#define R_BRK_ASYNC_RST_EN_2 0x0DC4
#define R_BRK_ASYNC_RST_EN_3 0x0DC8
#define R_NHM_BE 0x0EA4
#define B_NHM_READY_BE_MSK BIT(16)
#define R_CTLTOP 0x1008
#define B_CTLTOP_ON BIT(23)
#define B_CTLTOP_VAL GENMASK(15, 12)
#define R_CLK_GCK 0x1008
#define B_CLK_GCK GENMASK(24, 0)
#define R_EDCCA_RPT_SEL_BE 0x10CC
#define R_ADC_FIFO_V1 0x10FC
#define B_ADC_FIFO_EN_V1 GENMASK(31, 24)
#define R_S0_HW_SI_DIS 0x1200
#define B_S0_HW_SI_DIS_W_R_TRIG GENMASK(30, 28)
#define R_P0_RXCK 0x12A0
#define B_P0_RXCK_ADJ GENMASK(31, 23)
#define B_P0_RXCK_BW3 BIT(30)
#define B_P0_TXCK_ALL GENMASK(19, 12)
#define B_P0_RXCK_ON BIT(19)
#define B_P0_RXCK_VAL GENMASK(18, 16)
#define B_P0_TXCK_ON BIT(15)
#define B_P0_TXCK_VAL GENMASK(14, 12)
#define R_P0_RFMODE 0x12AC
#define B_P0_RFMODE_ORI_TXRX_FTM_TX GENMASK(31, 4)
#define B_P0_RFMODE_MUX GENMASK(11, 4)
#define R_P0_RFMODE_ORI_RX 0x12AC
#define B_P0_RFMODE_ORI_RX_ALL GENMASK(23, 12)
#define R_P0_RFMODE_FTM_RX 0x12B0
#define B_P0_RFMODE_FTM_RX GENMASK(11, 0)
#define R_P0_NRBW 0x12B8
#define B_P0_NRBW_DBG BIT(30)
#define B_P0_NRBW_RSTB BIT(28)
#define R_S0_RXDC 0x12D4
#define B_S0_RXDC_I GENMASK(25, 16)
#define B_S0_RXDC_Q GENMASK(31, 26)
#define R_S0_RXDC2 0x12D8
#define B_S0_RXDC2_SEL GENMASK(9, 8)
#define B_S0_RXDC2_AVG GENMASK(7, 6)
#define B_S0_RXDC2_MEN GENMASK(5, 4)
#define B_S0_RXDC2_Q2 GENMASK(3, 0)
#define R_CFO_COMP_SEG0_L 0x1384
#define R_CFO_COMP_SEG0_H 0x1388
#define R_CFO_COMP_SEG0_CTRL 0x138C
#define R_DBG32_D 0x1730
#define R_EDCCA_RPT_A 0x1738
#define R_EDCCA_RPT_B 0x173c
#define B_EDCCA_RPT_B_FB BIT(7)
#define B_EDCCA_RPT_B_P20 BIT(6)
#define B_EDCCA_RPT_B_S20 BIT(5)
#define B_EDCCA_RPT_B_S40 BIT(4)
#define B_EDCCA_RPT_B_S80 BIT(3)
#define B_EDCCA_RPT_B_PATH_MASK GENMASK(2, 1)
#define R_EDCCA_RPT_P1_A 0x1740
#define R_EDCCA_RPT_P1_B 0x1744
#define R_SWSI_V1 0x174C
#define B_SWSI_W_BUSY_V1 BIT(24)
#define B_SWSI_R_BUSY_V1 BIT(25)
#define B_SWSI_R_DATA_DONE_V1 BIT(26)
#define R_TX_COUNTER 0x1A40
#define R_NHM_CNT0 0x1A88
#define B_NHM_CNT0_MSK GENMASK(15, 0)
#define B_NHM_CNT1_MSK GENMASK(31, 16)
#define R_NHM_CNT2 0x1A8C
#define B_NHM_CNT2_MSK GENMASK(15, 0)
#define B_NHM_CNT3_MSK GENMASK(31, 16)
#define R_NHM_CNT4 0x1A90
#define B_NHM_CNT4_MSK GENMASK(15, 0)
#define B_NHM_CNT5_MSK GENMASK(31, 16)
#define R_NHM_CNT6 0x1A94
#define B_NHM_CNT6_MSK GENMASK(15, 0)
#define B_NHM_CNT7_MSK GENMASK(31, 16)
#define R_NHM_CNT8 0x1A98
#define B_NHM_CNT8_MSK GENMASK(15, 0)
#define B_NHM_CNT9_MSK GENMASK(31, 16)
#define R_NHM_CNT10 0x1A9C
#define B_NHM_CNT10_MSK GENMASK(15, 0)
#define B_NHM_CNT11_MSK GENMASK(31, 16)
#define R_NHM_AX 0x1AA4
#define B_NHM_READY_MSK BIT(16)
#define R_IFS_CLM_TX_CNT 0x1ACC
#define R_IFS_CLM_TX_CNT_V1 0x0ECC
#define R_IFS_CLM_TX_CNT_BE4 0x20ECC
#define B_IFS_CLM_EDCCA_EXCLUDE_CCA_FA_MSK GENMASK(31, 16)
#define B_IFS_CLM_TX_CNT_MSK GENMASK(15, 0)
#define R_IFS_CLM_CCA 0x1AD0
#define R_IFS_CLM_CCA_V1 0x0ED0
#define R_IFS_CLM_CCA_BE4 0x20ED0
#define B_IFS_CLM_OFDMCCA_EXCLUDE_FA_MSK GENMASK(31, 16)
#define B_IFS_CLM_CCKCCA_EXCLUDE_FA_MSK GENMASK(15, 0)
#define R_IFS_CLM_FA 0x1AD4
#define R_IFS_CLM_FA_V1 0x0ED4
#define R_IFS_CLM_FA_BE4 0x20ED4
#define B_IFS_CLM_OFDM_FA_MSK GENMASK(31, 16)
#define B_IFS_CLM_CCK_FA_MSK GENMASK(15, 0)
#define R_IFS_HIS 0x1AD8
#define R_IFS_HIS_V1 0x0ED8
#define B_IFS_T4_HIS_MSK GENMASK(31, 24)
#define B_IFS_T3_HIS_MSK GENMASK(23, 16)
#define B_IFS_T2_HIS_MSK GENMASK(15, 8)
#define B_IFS_T1_HIS_MSK GENMASK(7, 0)
#define R_IFS_AVG_L 0x1ADC
#define R_IFS_AVG_L_V1 0x0EDC
#define B_IFS_T2_AVG_MSK GENMASK(31, 16)
#define B_IFS_T1_AVG_MSK GENMASK(15, 0)
#define R_IFS_AVG_H 0x1AE0
#define R_IFS_AVG_H_V1 0x0EE0
#define B_IFS_T4_AVG_MSK GENMASK(31, 16)
#define B_IFS_T3_AVG_MSK GENMASK(15, 0)
#define R_IFS_CCA_L 0x1AE4
#define R_IFS_CCA_L_V1 0x0EE4
#define B_IFS_T2_CCA_MSK GENMASK(31, 16)
#define B_IFS_T1_CCA_MSK GENMASK(15, 0)
#define R_IFS_CCA_H 0x1AE8
#define R_IFS_CCA_H_V1 0x0EE8
#define B_IFS_T4_CCA_MSK GENMASK(31, 16)
#define B_IFS_T3_CCA_MSK GENMASK(15, 0)
#define R_IFSCNT 0x1AEC
#define R_IFSCNT_V1 0x0EEC
#define B_IFSCNT_DONE_MSK BIT(16)
#define B_IFSCNT_TOTAL_CNT_MSK GENMASK(15, 0)
#define R_TXAGC_TP 0x1C04
#define B_TXAGC_TP GENMASK(2, 0)
#define R_TSSI_THER 0x1C10
#define B_TSSI_THER GENMASK(29, 24)
#define R_TSSI_CWRPT 0x1C18
#define B_TSSI_CWRPT_RDY BIT(16)
#define B_TSSI_CWRPT GENMASK(8, 0)
#define R_TXAGC_BTP 0x1CA0
#define B_TXAGC_BTP GENMASK(31, 24)
#define R_TXAGC_BB 0x1C60
#define B_TXAGC_BB_OFT GENMASK(31, 16)
#define B_TXAGC_BB GENMASK(31, 24)
#define B_TXAGC_RF GENMASK(5, 0)
#define R_PATH0_TXPWR 0x1C78
#define B_PATH0_TXPWR GENMASK(8, 0)
#define R_S0_ADDCK 0x1E00
#define B_S0_ADDCK_I GENMASK(9, 0)
#define B_S0_ADDCK_Q GENMASK(19, 10)
#define R_TXCKEN_FORCE 0x2008
#define B_TXCKEN_FORCE_ALL GENMASK(24, 0)
#define R_EDCCA_RPT_SEL 0x20CC
#define B_EDCCA_RPT_SEL_MSK GENMASK(2, 0)
#define B_EDCCA_RPT_SEL_P1_MSK GENMASK(5, 3)
#define R_ADC_FIFO 0x20fc
#define B_ADC_FIFO_RST GENMASK(31, 24)
#define B_ADC_FIFO_RXK GENMASK(31, 16)
#define B_ADC_FIFO_A3 BIT(28)
#define B_ADC_FIFO_A2 BIT(24)
#define B_ADC_FIFO_A1 BIT(20)
#define B_ADC_FIFO_A0 BIT(16)
#define R_TXFIR0 0x2300
#define B_TXFIR_C01 GENMASK(23, 0)
#define R_TXFIR2 0x2304
#define B_TXFIR_C23 GENMASK(23, 0)
#define R_TXFIR4 0x2308
#define B_TXFIR_C45 GENMASK(23, 0)
#define R_TXFIR6 0x230c
#define B_TXFIR_C67 GENMASK(23, 0)
#define R_TXFIR8 0x2310
#define B_TXFIR_C89 GENMASK(23, 0)
#define R_TXFIRA 0x2314
#define B_TXFIR_CAB GENMASK(23, 0)
#define R_TXFIRC 0x2318
#define B_TXFIR_CCD GENMASK(23, 0)
#define R_TXFIRE 0x231c
#define B_TXFIR_CEF GENMASK(23, 0)
#define R_11B_RX_V1 0x2320
#define B_11B_RXCCA_DIS_V1 BIT(0)
#define R_RPL_OFST 0x2340
#define B_RPL_OFST_MASK GENMASK(14, 8)
#define R_RXCCA 0x2344
#define B_RXCCA_DIS BIT(31)
#define R_RXCCA_V1 0x2320
#define B_RXCCA_DIS_V1 BIT(0)
#define R_RXSC 0x237C
#define B_RXSC_EN BIT(0)
#define R_RX_RPL_OFST 0x23AC
#define B_RX_RPL_OFST_CCK_MASK GENMASK(6, 0)
#define R_RXSCOBC 0x23B0
#define B_RXSCOBC_TH GENMASK(18, 0)
#define R_RXSCOCCK 0x23B4
#define B_RXSCOCCK_TH GENMASK(18, 0)
#define R_P80_AT_HIGH_FREQ_RU_ALLOC 0x2410
#define B_P80_AT_HIGH_FREQ_RU_ALLOC_PHY1 BIT(14)
#define B_P80_AT_HIGH_FREQ_RU_ALLOC_PHY0 BIT(13)
#define R_DBCC_80P80_SEL_EVM_RPT2 0x2A10
#define B_DBCC_80P80_SEL_EVM_RPT2_EN BIT(0)
#define R_AFEDAC0 0x2A5C
#define B_AFEDAC0 GENMASK(31, 27)
#define R_AFEDAC1 0x2A60
#define B_AFEDAC1 GENMASK(2, 0)
#define R_IQKDPK_HC 0x2AB8
#define B_IQKDPK_HC BIT(28)
#define R_HWSI_ADD0 0x2ADC
#define R_HWSI_ADD1 0x2BDC
#define B_HWSI_ADD_MASK GENMASK(11, 4)
#define B_HWSI_ADD_CTL_MASK GENMASK(2, 0)
#define B_HWSI_ADD_RD BIT(2)
#define B_HWSI_ADD_POLL_MASK GENMASK(1, 0)
#define B_HWSI_ADD_RUN BIT(1)
#define B_HWSI_ADD_BUSY BIT(0)
#define R_HWSI_DATA 0x2AE0
#define B_HWSI_DATA_VAL GENMASK(27, 8)
#define B_HWSI_DATA_ADDR GENMASK(7, 0)
#define R_HWSI_VAL0 0x2C24
#define R_HWSI_VAL1 0x2D24
#define B_HWSI_VAL_RDONE BIT(31)
#define B_HWSI_VAL_BUSY BIT(29)
#define R_P1_EN_SOUND_WO_NDP 0x2D7C
#define B_P1_EN_SOUND_WO_NDP BIT(1)
#define R_EDCCA_RPT_A_BE 0x2E38
#define R_EDCCA_RPT_B_BE 0x2E3C
#define R_EDCCA_RPT_P1_A_BE 0x2E40
#define R_EDCCA_RPT_P1_B_BE 0x2E44
#define R_S1_HW_SI_DIS 0x3200
#define B_S1_HW_SI_DIS_W_R_TRIG GENMASK(30, 28)
#define R_P1_RXCK 0x32A0
#define B_P1_RXCK_BW3 BIT(30)
#define B_P1_TXCK_ALL GENMASK(19, 12)
#define B_P1_RXCK_ON BIT(19)
#define B_P1_RXCK_VAL GENMASK(18, 16)
#define R_P1_RFMODE 0x32AC
#define B_P1_RFMODE_ORI_TXRX_FTM_TX GENMASK(31, 4)
#define B_P1_RFMODE_MUX GENMASK(11, 4)
#define R_P1_RFMODE_ORI_RX 0x32AC
#define B_P1_RFMODE_ORI_RX_ALL GENMASK(23, 12)
#define R_P1_RFMODE_FTM_RX 0x32B0
#define B_P1_RFMODE_FTM_RX GENMASK(11, 0)
#define R_P1_DBGMOD 0x32B8
#define B_P1_DBGMOD_ON BIT(30)
#define R_S1_RXDC 0x32D4
#define B_S1_RXDC_I GENMASK(25, 16)
#define B_S1_RXDC_Q GENMASK(31, 26)
#define R_S1_RXDC2 0x32D8
#define B_S1_RXDC2_EN GENMASK(5, 4)
#define B_S1_RXDC2_SEL GENMASK(9, 8)
#define B_S1_RXDC2_Q2 GENMASK(3, 0)
#define R_TXAGC_BB_S1 0x3C60
#define B_TXAGC_BB_S1_OFT GENMASK(31, 16)
#define B_TXAGC_BB_S1 GENMASK(31, 24)
#define R_PATH1_TXPWR 0x3C78
#define B_PATH1_TXPWR GENMASK(8, 0)
#define R_S1_ADDCK 0x3E00
#define B_S1_ADDCK_I GENMASK(9, 0)
#define B_S1_ADDCK_Q GENMASK(19, 10)
#define R_OP1DB_A 0x40B0
#define B_OP1DB_A GENMASK(31, 24)
#define R_OP1DB1_A 0x40BC
#define B_TIA10_A GENMASK(15, 0)
#define B_TIA1_A GENMASK(15, 8)
#define B_TIA0_A GENMASK(7, 0)
#define R_BKOFF_A 0x40E0
#define B_BKOFF_IBADC_A GENMASK(23, 18)
#define R_BACKOFF_A 0x40E4
#define B_LNA_IBADC_A GENMASK(29, 18)
#define B_BACKOFF_LNA_A GENMASK(29, 24)
#define B_BACKOFF_IBADC_A GENMASK(23, 18)
#define R_RXBY_WBADC_A 0x40F4
#define B_RXBY_WBADC_A GENMASK(14, 10)
#define R_MUIC 0x40F8
#define B_MUIC_EN BIT(0)
#define R_BT_RXBY_WBADC_A 0x4160
#define B_BT_RXBY_WBADC_A BIT(31)
#define R_BT_SHARE_A 0x4164
#define B_BT_SHARE_A BIT(0)
#define B_BT_TRK_OFF_A BIT(1)
#define B_BTG_PATH_A BIT(4)
#define R_FORCE_FIR_A 0x418C
#define B_FORCE_FIR_A GENMASK(1, 0)
#define R_DCFO 0x4264
#define B_DCFO GENMASK(7, 0)
#define R_SEG0CSI 0x42AC
#define R_SEG0CSI_V1 0x42B0
#define B_SEG0CSI_IDX GENMASK(10, 0)
#define R_SEG0CSI_EN 0x42C4
#define R_SEG0CSI_EN_V1 0x42C8
#define B_SEG0CSI_EN BIT(23)
#define R_BSS_CLR_MAP 0x43ac
#define R_BSS_CLR_MAP_V1 0x43B0
#define R_BSS_CLR_MAP_V2 0x4EB0
#define B_BSS_CLR_MAP_VLD0 BIT(28)
#define B_BSS_CLR_MAP_TGT GENMASK(27, 22)
#define B_BSS_CLR_MAP_STAID GENMASK(21, 11)
#define R_CFO_TRK0 0x4404
#define R_CFO_TRK1 0x440C
#define B_CFO_TRK_MSK GENMASK(14, 10)
#define R_T2F_GI_COMB 0x4424
#define B_T2F_GI_COMB_EN BIT(2)
#define R_BT_DYN_DC_EST_EN 0x441C
#define R_BT_DYN_DC_EST_EN_V1 0x4420
#define B_BT_DYN_DC_EST_EN_MSK BIT(31)
#define R_ASSIGN_SBD_OPT_V1 0x4440
#define B_ASSIGN_SBD_OPT_EN_V1 BIT(31)
#define R_ASSIGN_SBD_OPT 0x4450
#define B_ASSIGN_SBD_OPT_EN BIT(24)
#define R_DCFO_COMP_S0 0x448C
#define B_DCFO_COMP_S0_MSK GENMASK(11, 0)
#define R_DCFO_WEIGHT 0x4490
#define B_DAC_CLK_IDX BIT(31)
#define B_DCFO_WEIGHT_MSK GENMASK(27, 24)
#define R_DCFO_OPT 0x4494
#define B_DCFO_OPT_EN BIT(29)
#define B_TXSHAPE_TRIANGULAR_CFG GENMASK(25, 24)
#define R_BANDEDGE 0x4498
#define B_BANDEDGE_EN BIT(30)
#define R_DPD_BF 0x44a0
#define B_DPD_BF_OFDM GENMASK(16, 12)
#define B_DPD_BF_SCA GENMASK(6, 0)
#define R_LNA_OP 0x44B0
#define B_LNA6 GENMASK(31, 24)
#define R_LNA_TIA 0x44BC
#define B_TIA10_B GENMASK(15, 0)
#define B_TIA1_B GENMASK(15, 8)
#define B_TIA0_B GENMASK(7, 0)
#define R_BKOFF_B 0x44E0
#define B_BKOFF_IBADC_B GENMASK(23, 18)
#define R_BACKOFF_B 0x44E4
#define B_LNA_IBADC_B GENMASK(29, 18)
#define B_BACKOFF_LNA_B GENMASK(29, 24)
#define B_BACKOFF_IBADC_B GENMASK(23, 18)
#define R_RXBY_WBADC_B 0x44F4
#define B_RXBY_WBADC_B GENMASK(14, 10)
#define R_BT_RXBY_WBADC_B 0x4560
#define B_BT_RXBY_WBADC_B BIT(31)
#define R_BT_SHARE_B 0x4564
#define B_BT_SHARE_B BIT(0)
#define B_BT_TRK_OFF_B BIT(1)
#define B_BTG_PATH_B BIT(4)
#define R_TXPATH_SEL 0x458C
#define B_TXPATH_SEL_MSK GENMASK(31, 28)
#define R_FORCE_FIR_B 0x458C
#define B_FORCE_FIR_B GENMASK(1, 0)
#define R_TXPWR 0x4594
#define B_TXPWR_MSK GENMASK(30, 22)
#define R_TXNSS_MAP 0x45B4
#define B_TXNSS_MAP_MSK GENMASK(20, 17)
#define R_PCOEFF0_V1 0x45BC
#define B_PCOEFF01_MSK_V1 GENMASK(23, 0)
#define R_PCOEFF2_V1 0x45CC
#define B_PCOEFF23_MSK_V1 GENMASK(23, 0)
#define R_PCOEFF4_V1 0x45D0
#define B_PCOEFF45_MSK_V1 GENMASK(23, 0)
#define R_PCOEFF6_V1 0x45D4
#define B_PCOEFF67_MSK_V1 GENMASK(23, 0)
#define R_PCOEFF8_V1 0x45D8
#define B_PCOEFF89_MSK_V1 GENMASK(23, 0)
#define R_PCOEFFA_V1 0x45C0
#define B_PCOEFFAB_MSK_V1 GENMASK(23, 0)
#define R_PCOEFFC_V1 0x45C4
#define B_PCOEFFCD_MSK_V1 GENMASK(23, 0)
#define R_PCOEFFE_V1 0x45C8
#define B_PCOEFFEF_MSK_V1 GENMASK(23, 0)
#define R_PATH0_IB_PKPW 0x4628
#define B_PATH0_IB_PKPW_MSK GENMASK(11, 6)
#define R_PATH0_LNA_ERR1 0x462C
#define B_PATH0_LNA_ERR_G1_A_MSK GENMASK(29, 24)
#define B_PATH0_LNA_ERR_G0_G_MSK GENMASK(17, 12)
#define B_PATH0_LNA_ERR_G0_A_MSK GENMASK(11, 6)
#define R_PATH0_LNA_ERR2 0x4630
#define B_PATH0_LNA_ERR_G2_G_MSK GENMASK(23, 18)
#define B_PATH0_LNA_ERR_G2_A_MSK GENMASK(17, 12)
#define B_PATH0_LNA_ERR_G1_G_MSK GENMASK(5, 0)
#define R_PATH0_LNA_ERR3 0x4634
#define B_PATH0_LNA_ERR_G4_G_MSK GENMASK(29, 24)
#define B_PATH0_LNA_ERR_G4_A_MSK GENMASK(23, 18)
#define B_PATH0_LNA_ERR_G3_G_MSK GENMASK(11, 6)
#define B_PATH0_LNA_ERR_G3_A_MSK GENMASK(5, 0)
#define R_PATH0_LNA_ERR4 0x4638
#define B_PATH0_LNA_ERR_G6_A_MSK GENMASK(29, 24)
#define B_PATH0_LNA_ERR_G5_G_MSK GENMASK(17, 12)
#define B_PATH0_LNA_ERR_G5_A_MSK GENMASK(11, 6)
#define R_PATH0_LNA_ERR5 0x463C
#define B_PATH0_LNA_ERR_G6_G_MSK GENMASK(5, 0)
#define R_PATH0_TIA_ERR_G0 0x4640
#define B_PATH0_TIA_ERR_G0_G_MSK GENMASK(23, 18)
#define B_PATH0_TIA_ERR_G0_A_MSK GENMASK(17, 12)
#define R_PATH0_TIA_ERR_G1 0x4644
#define B_PATH0_TIA_ERR_G1_SEL GENMASK(31, 30)
#define B_PATH0_TIA_ERR_G1_G_MSK GENMASK(11, 6)
#define B_PATH0_TIA_ERR_G1_A_MSK GENMASK(5, 0)
#define R_PATH0_IB_PBK 0x4650
#define B_PATH0_IB_PBK_MSK GENMASK(14, 10)
#define R_PATH0_RXB_INIT 0x4658
#define B_PATH0_RXB_INIT_IDX_MSK GENMASK(9, 5)
#define R_PATH0_LNA_INIT 0x4668
#define R_PATH0_LNA_INIT_V1 0x472C
#define B_PATH0_LNA_INIT_IDX_MSK GENMASK(26, 24)
#define R_PATH0_BTG 0x466C
#define B_PATH0_BTG_SHEN GENMASK(18, 17)
#define R_PATH0_TIA_INIT 0x4674
#define B_PATH0_TIA_INIT_IDX_MSK BIT(17)
#define R_PATH0_P20_FOLLOW_BY_PAGCUGC 0x46A0
#define R_PATH0_P20_FOLLOW_BY_PAGCUGC_V1 0x4C24
#define R_PATH0_P20_FOLLOW_BY_PAGCUGC_V2 0x46E8
#define R_PATH0_P20_FOLLOW_BY_PAGCUGC_V3 0x41C8
#define B_PATH0_P20_FOLLOW_BY_PAGCUGC_EN_MSK BIT(5)
#define R_PATH0_S20_FOLLOW_BY_PAGCUGC 0x46A4
#define R_PATH0_S20_FOLLOW_BY_PAGCUGC_V1 0x4C28
#define R_PATH0_S20_FOLLOW_BY_PAGCUGC_V2 0x46EC
#define R_PATH0_S20_FOLLOW_BY_PAGCUGC_V3 0x41CC
#define B_PATH0_S20_FOLLOW_BY_PAGCUGC_EN_MSK BIT(5)
#define R_PATH0_RXB_INIT_V1 0x46A8
#define B_PATH0_RXB_INIT_IDX_MSK_V1 GENMASK(14, 10)
#define R_PATH0_G_LNA6_OP1DB_V1 0x4688
#define B_PATH0_G_LNA6_OP1DB_V1 GENMASK(31, 24)
#define R_PATH0_G_TIA0_LNA6_OP1DB_V1 0x4694
#define B_PATH0_G_TIA0_LNA6_OP1DB_V1 GENMASK(7, 0)
#define R_PATH0_G_TIA1_LNA6_OP1DB_V1 0x4694
#define B_PATH0_R_G_OFST_MASK GENMASK(23, 16)
#define B_PATH0_G_TIA1_LNA6_OP1DB_V1 GENMASK(15, 8)
#define R_CDD_EVM_CHK_EN 0x46C0
#define B_CDD_EVM_CHK_EN BIT(0)
#define R_PATH0_BAND_SEL_V1 0x4738
#define B_PATH0_BAND_SEL_MSK_V1 BIT(17)
#define B_PATH0_BAND_NRBW_EN_V1 BIT(16)
#define R_PATH0_BT_SHARE_V1 0x4738
#define B_PATH0_BT_SHARE_V1 BIT(19)
#define R_PATH0_BTG_PATH_V1 0x4738
#define B_PATH0_BTG_PATH_V1 BIT(22)
#define R_P0_NBIIDX 0x469C
#define B_P0_NBIIDX_VAL GENMASK(11, 0)
#define B_P0_NBIIDX_NOTCH_EN BIT(12)
#define R_P0_BACKOFF_IBADC_V1 0x469C
#define B_P0_BACKOFF_IBADC_V1 GENMASK(31, 26)
#define B_P0_NBIIDX_NOTCH_EN_V1 BIT(12)
#define R_P1_MODE 0x4718
#define B_P1_MODE_SEL GENMASK(31, 30)
#define R_P0_AGC_CTL 0x4730
#define B_P0_AGC_EN BIT(31)
#define R_PATH1_LNA_INIT 0x473C
#define R_PATH1_LNA_INIT_V1 0x4A80
#define B_PATH1_LNA_INIT_IDX_MSK GENMASK(26, 24)
#define R_PATH0_TIA_INIT_V1 0x473C
#define B_PATH0_TIA_INIT_IDX_MSK_V1 BIT(9)
#define R_PATH1_TIA_INIT 0x4748
#define B_PATH1_TIA_INIT_IDX_MSK BIT(17)
#define R_PATH1_BTG 0x4740
#define B_PATH1_BTG_SHEN GENMASK(18, 17)
#define R_PATH1_RXB_INIT 0x472C
#define B_PATH1_RXB_INIT_IDX_MSK GENMASK(9, 5)
#define R_PATH1_G_LNA6_OP1DB_V1 0x476C
#define B_PATH1_G_LNA6_OP1DB_V1 GENMASK(31, 24)
#define R_PATH1_P20_FOLLOW_BY_PAGCUGC 0x4774
#define R_PATH1_P20_FOLLOW_BY_PAGCUGC_V1 0x4CE8
#define R_PATH1_P20_FOLLOW_BY_PAGCUGC_V2 0x47A8
#define R_PATH1_P20_FOLLOW_BY_PAGCUGC_V3 0x45C8
#define B_PATH1_P20_FOLLOW_BY_PAGCUGC_EN_MSK BIT(5)
#define R_PATH1_S20_FOLLOW_BY_PAGCUGC 0x4778
#define R_PATH1_S20_FOLLOW_BY_PAGCUGC_V1 0x4CEC
#define R_PATH1_S20_FOLLOW_BY_PAGCUGC_V2 0x47AC
#define R_PATH1_S20_FOLLOW_BY_PAGCUGC_V3 0x45CC
#define B_PATH1_S20_FOLLOW_BY_PAGCUGC_EN_MSK BIT(5)
#define R_PATH1_G_TIA0_LNA6_OP1DB_V1 0x4778
#define B_PATH1_G_TIA0_LNA6_OP1DB_V1 GENMASK(7, 0)
#define R_PATH1_G_TIA1_LNA6_OP1DB_V1 0x4778
#define B_PATH1_G_TIA1_LNA6_OP1DB_V1 GENMASK(15, 8)
#define R_PATH1_BAND_SEL_V1 0x4AA4
#define B_PATH1_BAND_SEL_MSK_V1 BIT(17)
#define B_PATH1_BAND_NRBW_EN_V1 BIT(16)
#define R_PATH1_BT_SHARE_V1 0x4AA4
#define B_PATH1_BT_SHARE_V1 BIT(19)
#define R_PATH1_BTG_PATH_V1 0x4AA4
#define B_PATH1_BTG_PATH_V1 BIT(22)
#define R_P1_NBIIDX 0x4770
#define B_P1_NBIIDX_VAL GENMASK(11, 0)
#define B_P1_NBIIDX_NOTCH_EN BIT(12)
#define R_PKT_CTRL 0x47D4
#define B_PKT_POP_EN BIT(8)
#define R_SEG0R_PD 0x481C
#define R_SEG0R_PD_V1 0x4860
#define R_SEG0R_PD_V2 0x6A74
#define R_SEG0R_EDCCA_LVL 0x4840
#define R_SEG0R_EDCCA_LVL_V1 0x4884
#define B_EDCCA_LVL_MSK3 GENMASK(31, 24)
#define B_EDCCA_LVL_MSK1 GENMASK(15, 8)
#define B_EDCCA_LVL_MSK0 GENMASK(7, 0)
#define B_SEG0R_PD_SPATIAL_REUSE_EN_MSK_V1 BIT(30)
#define B_SEG0R_PD_SPATIAL_REUSE_EN_MSK BIT(29)
#define B_SEG0R_PD_LOWER_BOUND_MSK GENMASK(10, 6)
#define R_PWOFST 0x488C
#define B_PWOFST GENMASK(21, 17)
#define R_2P4G_BAND 0x4970
#define B_2P4G_BAND_SEL BIT(1)
#define R_FC0_BW 0x4974
#define R_FC0_BW_V1 0x49C0
#define B_FC0_BW_SET GENMASK(31, 30)
#define B_ANT_RX_BT_SEG0 GENMASK(25, 22)
#define B_ANT_RX_1RCCA_SEG1 GENMASK(21, 18)
#define B_ANT_RX_1RCCA_SEG0 GENMASK(17, 14)
#define B_FC0_BW_INV GENMASK(6, 0)
#define R_Q_MATRIX_00 0x497C
#define B_Q_MATRIX_00_IMAGINARY GENMASK(15, 0)
#define B_Q_MATRIX_00_REAL GENMASK(31, 16)
#define R_CHBW_MOD 0x4978
#define R_CHBW_MOD_V1 0x49C4
#define B_BT_SHARE BIT(14)
#define B_CHBW_MOD_SBW GENMASK(13, 12)
#define B_CHBW_MOD_PRICH GENMASK(11, 8)
#define B_ANT_RX_SEG0 GENMASK(3, 0)
#define R_Q_MATRIX_11 0x4988
#define B_Q_MATRIX_11_IMAGINARY GENMASK(15, 0)
#define B_Q_MATRIX_11_REAL GENMASK(31, 16)
#define R_CUSTOMIZE_Q_MATRIX 0x498C
#define B_CUSTOMIZE_Q_MATRIX_EN BIT(0)
#define R_P0_RPL1 0x49B0
#define B_P0_RPL1_41_MASK GENMASK(31, 24)
#define B_P0_RPL1_40_MASK GENMASK(23, 16)
#define B_P0_RPL1_20_MASK GENMASK(15, 8)
#define B_P0_RPL1_MASK (B_P0_RPL1_41_MASK | B_P0_RPL1_40_MASK | B_P0_RPL1_20_MASK)
#define B_P0_RPL1_SHIFT 8
#define B_P0_RPL1_BIAS_MASK GENMASK(7, 0)
#define R_P0_RPL2 0x49B4
#define B_P0_RTL2_8A_MASK GENMASK(31, 24)
#define B_P0_RTL2_81_MASK GENMASK(23, 16)
#define B_P0_RTL2_80_MASK GENMASK(15, 8)
#define B_P0_RTL2_42_MASK GENMASK(7, 0)
#define R_P0_RPL3 0x49B8
#define B_P0_RTL3_89_MASK GENMASK(31, 24)
#define B_P0_RTL3_84_MASK GENMASK(23, 16)
#define B_P0_RTL3_83_MASK GENMASK(15, 8)
#define B_P0_RTL3_82_MASK GENMASK(7, 0)
#define R_PD_BOOST_EN 0x49E8
#define B_PD_BOOST_EN BIT(7)
#define R_P1_BACKOFF_IBADC_V1 0x49F0
#define B_P1_BACKOFF_IBADC_V1 GENMASK(31, 26)
#define R_P1_RPL1 0x4A00
#define R_P1_RPL2 0x4A04
#define R_P1_RPL3 0x4A08
#define R_BK_FC0_INV_V1 0x4A1C
#define B_BK_FC0_INV_MSK_V1 GENMASK(18, 0)
#define R_CCK_FC0_INV_V1 0x4A20
#define B_CCK_FC0_INV_MSK_V1 GENMASK(18, 0)
#define R_PATH1_RXB_INIT_V1 0x4A5C
#define B_PATH1_RXB_INIT_IDX_MSK_V1 GENMASK(14, 10)
#define R_P1_AGC_CTL 0x4A9C
#define B_P1_AGC_EN BIT(31)
#define R_PATH1_TIA_INIT_V1 0x4AA8
#define B_PATH1_TIA_INIT_IDX_MSK_V1 BIT(9)
#define R_P0_AGC_RSVD 0x4ACC
#define R_PATH0_RXBB_V1 0x4AD4
#define B_PATH0_RXBB_MSK_V1 GENMASK(31, 0)
#define R_P1_AGC_RSVD 0x4AD8
#define R_PATH1_RXBB_V1 0x4AE0
#define B_PATH1_RXBB_MSK_V1 GENMASK(31, 0)
#define R_PATH0_BT_BACKOFF_V1 0x4AE4
#define B_PATH0_BT_BACKOFF_V1 GENMASK(23, 0)
#define R_PATH1_BT_BACKOFF_V1 0x4AEC
#define B_PATH1_BT_BACKOFF_V1 GENMASK(23, 0)
#define R_DCFO_COMP_S0_V2 0x4B20
#define B_DCFO_COMP_S0_MSK_V2 GENMASK(13, 0)
#define R_PATH0_TX_CFR 0x4B30
#define B_PATH0_TX_CFR_LGC1 GENMASK(19, 10)
#define B_PATH0_TX_CFR_LGC0 GENMASK(9, 0)
#define R_PATH0_TX_POLAR_CLIPPING 0x4B3C
#define B_PATH0_TX_POLAR_CLIPPING_LGC1 GENMASK(19, 16)
#define B_PATH0_TX_POLAR_CLIPPING_LGC0 GENMASK(15, 12)
#define R_PATH0_FRC_FIR_TYPE_V1 0x4C00
#define B_PATH0_FRC_FIR_TYPE_MSK_V1 GENMASK(1, 0)
#define R_PATH0_NOTCH 0x4C14
#define B_PATH0_NOTCH_EN BIT(12)
#define B_PATH0_NOTCH_VAL GENMASK(11, 0)
#define R_PATH0_NOTCH2 0x4C20
#define B_PATH0_NOTCH2_EN BIT(12)
#define B_PATH0_NOTCH2_VAL GENMASK(11, 0)
#define R_PATH0_5MDET 0x4C4C
#define R_PATH0_5MDET_V1 0x46F8
#define B_PATH0_5MDET_EN BIT(12)
#define B_PATH0_5MDET_SB2 BIT(8)
#define B_PATH0_5MDET_SB0 BIT(6)
#define B_PATH0_5MDET_TH GENMASK(5, 0)
#define R_PATH1_FRC_FIR_TYPE_V1 0x4CC4
#define B_PATH1_FRC_FIR_TYPE_MSK_V1 GENMASK(1, 0)
#define R_PATH1_NOTCH 0x4CD8
#define B_PATH1_NOTCH_EN BIT(12)
#define B_PATH1_NOTCH_VAL GENMASK(11, 0)
#define R_PATH1_NOTCH2 0x4CE4
#define B_PATH1_NOTCH2_EN BIT(12)
#define B_PATH1_NOTCH2_VAL GENMASK(11, 0)
#define R_PATH1_5MDET 0x4D10
#define R_PATH1_5MDET_V1 0x47B8
#define B_PATH1_5MDET_EN BIT(12)
#define B_PATH1_5MDET_SB2 BIT(8)
#define B_PATH1_5MDET_SB0 BIT(6)
#define B_PATH1_5MDET_TH GENMASK(5, 0)
#define R_S0S1_CSI_WGT 0x4D34
#define B_S0S1_CSI_WGT_EN BIT(0)
#define B_S0S1_CSI_WGT_TONE_IDX GENMASK(31, 20)
#define R_CHINFO_ELM_SRC 0x4D84
#define B_CHINFO_ELM_BITMAP GENMASK(22, 0)
#define B_CHINFO_SRC GENMASK(31, 30)
#define R_CHINFO_TYPE_SCAL 0x4D88
#define B_CHINFO_TYPE GENMASK(2, 1)
#define B_CHINFO_SCAL BIT(8)
#define R_RPL_BIAS_COMP 0x4DF0
#define B_RPL_BIAS_COMP_MASK GENMASK(7, 0)
#define R_RPL_PATHAB 0x4E0C
#define B_RPL_PATHB_MASK GENMASK(23, 16)
#define B_RPL_PATHA_MASK GENMASK(15, 8)
#define R_RSSI_M_PATHAB 0x4E2C
#define B_RSSI_M_PATHB_MASK GENMASK(15, 8)
#define B_RSSI_M_PATHA_MASK GENMASK(7, 0)
#define R_FC0_V1 0x4E30
#define B_FC0_MSK_V1 GENMASK(12, 0)
#define R_RX_BW40_2XFFT_EN_V1 0x4E30
#define B_RX_BW40_2XFFT_EN_MSK_V1 BIT(26)
#define R_DCFO_COMP_S0_V1 0x4A40
#define B_DCFO_COMP_S0_V1_MSK GENMASK(13, 0)
#define R_BMODE_PDTH_V1 0x4B64
#define R_BMODE_PDTH_V2 0x6708
#define B_BMODE_PDTH_LOWER_BOUND_MSK_V1 GENMASK(31, 24)
#define R_BMODE_PDTH_EN_V1 0x4B74
#define R_BMODE_PDTH_EN_V2 0x6718
#define B_BMODE_PDTH_LIMIT_EN_MSK_V1 BIT(30)
#define R_BSS_CLR_VLD_V2 0x4EBC
#define B_BSS_CLR_VLD0_V2 BIT(2)
#define R_CFO_COMP_SEG1_L 0x5384
#define R_CFO_COMP_SEG1_H 0x5388
#define R_CFO_COMP_SEG1_CTRL 0x538C
#define B_CFO_COMP_VALID_BIT BIT(29)
#define B_CFO_COMP_WEIGHT_MSK GENMASK(27, 24)
#define B_CFO_COMP_VAL_MSK GENMASK(11, 0)
#define R_TSSI_PA_K1 0x5600
#define R_TSSI_PA_K2 0x5604
#define R_P0_TSSI_ALIM1 0x5630
#define B_P0_TSSI_ALIM1 GENMASK(29, 0)
#define B_P0_TSSI_ALIM11 GENMASK(29, 20)
#define B_P0_TSSI_ALIM12 GENMASK(19, 10)
#define B_P0_TSSI_ALIM13 GENMASK(9, 0)
#define R_P0_TSSI_ALIM3 0x5634
#define B_P0_TSSI_ALIM31 GENMASK(9, 0)
#define R_TSSI_PA_K5 0x5638
#define R_P0_TSSI_ALIM2 0x563c
#define B_P0_TSSI_ALIM2 GENMASK(29, 0)
#define R_P0_TSSI_ALIM4 0x5640
#define R_TSSI_PA_K8 0x5644
#define R_P0_TSSI_ADC_CLK 0x566c
#define B_P0_TSSI_ADC_CLK GENMASK(17, 16)
#define R_UPD_CLK 0x5670
#define B_DAC_VAL BIT(31)
#define B_ACK_VAL GENMASK(30, 29)
#define B_DPD_DIS BIT(14)
#define B_DPD_GDIS BIT(13)
#define B_IQK_RFC_ON BIT(1)
#define R_TXPWRB 0x56CC
#define R_P1_TXPWRB 0x76CC
#define B_TXPWRB_ON BIT(28)
#define B_TXPWRB_VAL GENMASK(27, 19)
#define B_TXPWRB_MAX GENMASK(8, 0)
#define R_DPD_OFT_EN 0x5800
#define B_DPD_OFT_EN BIT(28)
#define B_DPD_TSSI_CW GENMASK(26, 18)
#define B_DPD_PWR_CW GENMASK(17, 9)
#define B_DPD_REF GENMASK(8, 0)
#define R_P0_TSSIC 0x5814
#define B_P0_TSSIC_BYPASS BIT(11)
#define R_DPD_OFT_ADDR 0x5804
#define B_DPD_OFT_ADDR GENMASK(31, 27)
#define R_TXPWRB_H 0x580c
#define B_TXPWRB_RDY BIT(15)
#define R_P0_TMETER 0x5810
#define B_P0_TMETER GENMASK(15, 10)
#define B_P0_TMETER_DIS BIT(16)
#define B_P0_TMETER_TRK BIT(24)
#define R_P0_ADCFF_EN 0x58C8
#define B_P0_ADCFF_EN BIT(24)
#define R_P1_TSSIC 0x7814
#define B_P1_TSSIC_BYPASS BIT(11)
#define R_P0_TSSI_TRK 0x5818
#define B_P0_TSSI_TRK_EN BIT(30)
#define B_P0_TSSI_RFC GENMASK(28, 27)
#define B_P0_TSSI_OFT_EN BIT(28)
#define B_P0_TSSI_OFT GENMASK(7, 0)
#define R_P0_TSSI_SLOPE_CAL 0x581c
#define B_P0_TSSI_SLOPE_CAL_EN BIT(20)
#define R_P0_TSSI_AVG 0x5820
#define B_P0_TSSI_EN BIT(31)
#define B_P0_TSSI_AVG GENMASK(15, 12)
#define R_P0_RFCTM 0x5864
#define B_P0_CLKG_FORCE GENMASK(31, 30)
#define B_P0_RFCTM_EN BIT(29)
#define B_P0_GOT_TXRX GENMASK(28, 27)
#define B_P0_RFCTM_VAL GENMASK(25, 20)
#define R_P0_RFCTM_RDY BIT(26)
#define R_P0_TRSW 0x5868
#define B_P0_BT_FORCE_ANTIDX_EN BIT(12)
#define B_P0_TRSW_X BIT(2)
#define B_P0_TRSW_A BIT(1)
#define B_P0_TX_ANT_SEL BIT(1)
#define B_P0_TRSW_B BIT(0)
#define B_P0_ANT_TRAIN_EN BIT(0)
#define B_P0_TRSW_SO_A2 GENMASK(7, 5)
#define R_P0_ANTSEL 0x586C
#define B_P0_ANTSEL_SW_5G BIT(25)
#define B_P0_ANTSEL_SW_2G BIT(23)
#define B_P0_ANTSEL_BTG_TRX BIT(21)
#define B_P0_ANTSEL_CGCS_CTRL BIT(17)
#define B_P0_ANTSEL_HW_CTRL BIT(16)
#define B_P0_ANTSEL_TX_ORI GENMASK(15, 12)
#define B_P0_ANTSEL_RX_ALT GENMASK(11, 8)
#define B_P0_ANTSEL_RX_ORI GENMASK(7, 4)
#define R_RFSW_CTRL_ANT0_BASE 0x5870
#define B_RFSW_CTRL_ANT_MAPPING GENMASK(15, 0)
#define R_RFE_SEL0_BASE 0x5880
#define B_RFE_SEL0_SRC_MASK GENMASK(3, 0)
#define R_RFE_SEL32_BASE 0x5884
#define RFE_SEL0_SRC_ANTSEL_0 8
#define R_RFE_INV0 0x5890
#define R_P0_RFM 0x5894
#define B_P0_RFM_DIS_WL BIT(7)
#define B_P0_RFM_TX_OPT BIT(6)
#define B_P0_RFM_BT_EN BIT(5)
#define B_P0_RFM_OUT GENMASK(4, 0)
#define R_P0_PATH_RST 0x58AC
#define B_P0_PATH_RST BIT(27)
#define R_P0_TXDPD 0x58D4
#define B_P0_TXDPD GENMASK(31, 28)
#define R_P0_TXPW_RSTB 0x58DC
#define B_P0_TXPW_RSTB_MANON BIT(30)
#define B_P0_TXPW_RSTB_TSSI BIT(31)
#define R_P0_TSSI_MV_AVG 0x58E4
#define B_P0_TXPW_RSTB GENMASK(28, 27)
#define B_P0_TSSI_MV_MIX GENMASK(19, 11)
#define B_P0_TSSI_MV_AVG GENMASK(13, 11)
#define B_P0_TSSI_MV_CLR BIT(14)
#define R_TXGAIN_SCALE 0x58F0
#define B_TXGAIN_SCALE_EN BIT(19)
#define B_TXGAIN_SCALE_OFT GENMASK(31, 24)
#define R_P0_DAC_COMP_POST_DPD_EN 0x58F8
#define B_P0_DAC_COMP_POST_DPD_EN BIT(31)
#define R_P0_TSSI_BASE 0x5C00
#define R_S0_DACKI 0x5E00
#define B_S0_DACKI_AR GENMASK(31, 28)
#define B_S0_DACKI_EN BIT(3)
#define R_S0_DACKI2 0x5E30
#define B_S0_DACKI2_K GENMASK(21, 12)
#define R_S0_DACKI7 0x5E44
#define B_S0_DACKI7_K GENMASK(15, 8)
#define R_S0_DACKI8 0x5E48
#define B_S0_DACKI8_K GENMASK(15, 8)
#define R_S0_DACKQ 0x5E50
#define B_S0_DACKQ_AR GENMASK(31, 28)
#define B_S0_DACKQ_EN BIT(3)
#define R_S0_DACKQ2 0x5E80
#define B_S0_DACKQ2_K GENMASK(21, 12)
#define R_S0_DACKQ7 0x5E94
#define B_S0_DACKQ7_K GENMASK(15, 8)
#define R_S0_DACKQ8 0x5E98
#define B_S0_DACKQ8_K GENMASK(15, 8)
#define R_DCFO_WEIGHT_BE 0x6244
#define R_DCFO_WEIGHT_BE_V1 0x24808
#define B_DCFO_WEIGHT_MSK_BE GENMASK(31, 28)
#define R_DAC_CLK 0x625C
#define B_DAC_CLK GENMASK(31, 30)
#define R_DCFO_OPT_BE 0x6260
#define R_DCFO_OPT_BE_V1 0x24824
#define B_DCFO_OPT_EN_BE BIT(17)
#define R_TXFCTR 0x627C
#define B_TXFCTR_THD GENMASK(19, 10)
#define R_TXSCALE 0x6284
#define B_TXFCTR_EN BIT(19)
#define R_PCOEFF01 0x6684
#define B_PCOEFF01 GENMASK(23, 0)
#define R_PCOEFF23 0x6688
#define B_PCOEFF23 GENMASK(23, 0)
#define R_PCOEFF45 0x668c
#define B_PCOEFF45 GENMASK(23, 0)
#define R_PCOEFF67 0x6690
#define B_PCOEFF67 GENMASK(23, 0)
#define R_PCOEFF89 0x6694
#define B_PCOEFF89 GENMASK(23, 0)
#define R_PCOEFFAB 0x6698
#define B_PCOEFFAB GENMASK(23, 0)
#define R_PCOEFFCD 0x669c
#define B_PCOEFFCD GENMASK(23, 0)
#define R_PCOEFFEF 0x66a0
#define B_PCOEFFEF GENMASK(23, 0)
#define R_MGAIN_BIAS 0x672c
#define B_MGAIN_BIAS_BW20 GENMASK(3, 0)
#define B_MGAIN_BIAS_BW40 GENMASK(7, 4)
#define R_CCK_RPL_OFST 0x6750
#define B_CCK_RPL_OFST GENMASK(7, 0)
#define R_BK_FC0INV 0x6758
#define B_BK_FC0INV GENMASK(18, 0)
#define R_CCK_FC0INV 0x675c
#define B_CCK_FC0INV GENMASK(18, 0)
#define R_SEG0R_EDCCA_LVL_BE 0x69EC
#define R_SEG0R_PPDU_LVL_BE 0x69F0
#define R_SEGSND 0x6A14
#define B_SEGSND_EN BIT(31)
#define R_DBCC 0x6B48
#define B_DBCC_EN BIT(0)
#define R_FC0 0x6B4C
#define B_BW40_2XFFT BIT(31)
#define B_FC0 GENMASK(12, 0)
#define R_FC0INV_SBW 0x6B50
#define B_SMALLBW GENMASK(31, 30)
#define B_RX_BT_SG0 GENMASK(25, 22)
#define B_RX_1RCCA GENMASK(17, 14)
#define B_FC0_INV GENMASK(6, 0)
#define R_ANT_CHBW 0x6B54
#define B_ANT_BT_SHARE BIT(16)
#define B_CHBW_BW GENMASK(14, 12)
#define B_CHBW_PRICH GENMASK(11, 8)
#define B_ANT_RX_SG0 GENMASK(3, 0)
#define R_SLOPE 0x6B6C
#define B_EHT_RATE_TH GENMASK(31, 28)
#define B_SLOPE_B GENMASK(27, 14)
#define B_SLOPE_A GENMASK(13, 0)
#define R_SC_CORNER 0x6B70
#define B_SC_CORNER GENMASK(10, 0)
#define R_MAG_A 0x6BF4
#define B_MGA_AEND GENMASK(31, 24)
#define R_MAG_AB 0x6BF8
#define B_BY_SLOPE GENMASK(31, 24)
#define B_MAG_AB GENMASK(23, 0)
#define R_BEDGE 0x6BFC
#define B_EHT_MCS14 BIT(31)
#define B_HE_RATE_TH GENMASK(30, 27)
#define R_BEDGE2 0x6C00
#define B_EHT_MCS15 BIT(31)
#define B_HT_VHT_TH GENMASK(11, 0)
#define R_BEDGE3 0x6C04
#define B_TB_EN BIT(23)
#define B_HEMU_EN BIT(21)
#define B_HEERSU_EN BIT(19)
#define B_EHTTB_EN BIT(15)
#define B_BEDGE_CFG GENMASK(1, 0)
#define R_SU_PUNC 0x6C08
#define B_SU_PUNC_EN BIT(1)
#define R_BEDGE5 0x6C10
#define B_HWGEN_EN BIT(25)
#define B_PWROFST_COMP BIT(20)
#define R_RPL_BIAS_COMP1 0x6DF0
#define B_RPL_BIAS_COMP1_MASK GENMASK(7, 0)
#define R_DBCC_FA 0x703C
#define B_DBCC_FA BIT(12)
#define R_P1_TSSI_ALIM1 0x7630
#define B_P1_TSSI_ALIM1 GENMASK(29, 0)
#define B_P1_TSSI_ALIM11 GENMASK(29, 20)
#define B_P1_TSSI_ALIM12 GENMASK(19, 10)
#define B_P1_TSSI_ALIM13 GENMASK(9, 0)
#define R_P1_TSSI_ALIM3 0x7634
#define B_P1_TSSI_ALIM31 GENMASK(9, 0)
#define R_P1_TSSI_ALIM2 0x763c
#define B_P1_TSSI_ALIM2 GENMASK(29, 0)
#define R_P1_TSSI_ADC_CLK 0x766c
#define B_P1_TSSI_ADC_CLK GENMASK(17, 16)
#define R_P1_TXAGC_TH 0x7800
#define B_P1_TXAGC_MAXMIN GENMASK(15, 0)
#define R_P1_TXPW_FORCE 0x780C
#define B_P1_TXPW_RDY BIT(15)
#define R_P1_TSSIC 0x7814
#define B_P1_TSSIC_BYPASS BIT(11)
#define R_P1_TMETER 0x7810
#define B_P1_TMETER GENMASK(15, 10)
#define B_P1_TMETER_DIS BIT(16)
#define B_P1_TMETER_TRK BIT(24)
#define R_P1_TSSI_TRK 0x7818
#define B_P1_TSSI_TRK_EN BIT(30)
#define B_P1_TSSI_RFC GENMASK(28, 27)
#define B_P1_TSSI_OFT_EN BIT(28)
#define B_P1_TSSI_OFT GENMASK(7, 0)
#define R_P1_TSSI_AVG 0x7820
#define B_P1_TSSI_EN BIT(31)
#define B_P1_TSSI_AVG GENMASK(15, 12)
#define R_P1_RFCTM 0x7864
#define B_P1_CLKG_FORCE GENMASK(31, 30)
#define B_P1_GOT_TXRX GENMASK(28, 27)
#define R_P1_RFCTM_RDY BIT(26)
#define B_P1_RFCTM_VAL GENMASK(25, 20)
#define B_P1_RFCTM_DEL GENMASK(19, 11)
#define R_P1_PATH_RST 0x78AC
#define B_P1_PATH_RST BIT(27)
#define R_P1_ADCFF_EN 0x78C8
#define B_P1_ADCFF_EN BIT(24)
#define R_P1_TXPW_RSTB 0x78DC
#define B_P1_TXPW_RSTB_MANON BIT(30)
#define B_P1_TXPW_RSTB_TSSI BIT(31)
#define R_P1_TSSI_MV_AVG 0x78E4
#define B_P1_TXPW_RSTB GENMASK(28, 27)
#define B_P1_TSSI_MV_MIX GENMASK(19, 11)
#define B_P1_TSSI_MV_AVG GENMASK(13, 11)
#define B_P1_TSSI_MV_CLR BIT(14)
#define R_P1_DAC_COMP_POST_DPD_EN 0x78F8
#define B_P1_DAC_COMP_POST_DPD_EN BIT(31)
#define R_TSSI_THOF 0x7C00
#define R_S1_DACKI 0x7E00
#define B_S1_DACKI_AR GENMASK(31, 28)
#define B_S1_DACKI_EN BIT(3)
#define R_S1_DACKI2 0x7E30
#define B_S1_DACKI2_K GENMASK(21, 12)
#define R_S1_DACKI7 0x7E44
#define B_S1_DACKI_K GENMASK(15, 8)
#define R_S1_DACKI8 0x7E48
#define B_S1_DACKI8_K GENMASK(15, 8)
#define R_S1_DACKQ 0x7E50
#define B_S1_DACKQ_AR GENMASK(31, 28)
#define B_S1_DACKQ_EN BIT(3)
#define R_S1_DACKQ2 0x7E80
#define B_S1_DACKQ2_K GENMASK(21, 12)
#define R_S1_DACKQ7 0x7E94
#define B_S1_DACKQ7_K GENMASK(15, 8)
#define R_S1_DACKQ8 0x7E98
#define B_S1_DACKQ8_K GENMASK(15, 8)
#define R_NCTL_CFG 0x8000
#define B_NCTL_CFG_SPAGE GENMASK(2, 1)
#define R_NCTL_RPT 0x8008
#define B_NCTL_RPT_FLG BIT(26)
#define R_NCTL_N1 0x8010
#define B_NCTL_N1_CIP GENMASK(7, 0)
#define R_NCTL_N2 0x8014
#define R_IQK_COM 0x8018
#define R_IQK_DIF 0x801C
#define B_IQK_DIF_TRX GENMASK(1, 0)
#define R_IQK_DIF1 0x8020
#define B_IQK_DIF1_TXPI GENMASK(19, 0)
#define R_IQK_DIF2 0x8024
#define B_IQK_DIF2_RXPI GENMASK(19, 0)
#define R_IQK_DIF4 0x802C
#define B_IQK_DIF4_RXT GENMASK(27, 16)
#define B_IQK_DIF4_TXT GENMASK(11, 0)
#define IQK_DF4_TXT_8_25MHZ 0x021
#define R_IQK_CFG 0x8034
#define B_IQK_CFG_SET GENMASK(5, 4)
#define R_IQK_RXA 0x8044
#define B_IQK_RXAGC GENMASK(15, 13)
#define R_TPG_SEL 0x8068
#define R_TPG_MOD 0x806C
#define B_TPG_MOD_F GENMASK(2, 1)
#define R_MDPK_SYNC 0x8070
#define B_MDPK_SYNC_SEL BIT(31)
#define B_MDPK_SYNC_MAN GENMASK(31, 28)
#define B_MDPK_SYNC_DMAN GENMASK(30, 28)
#define R_MDPK_RX_DCK 0x8074
#define B_MDPK_RX_DCK_EN BIT(31)
#define R_KIP_MOD 0x8078
#define B_KIP_MOD GENMASK(19, 0)
#define R_NCTL_RW 0x8080
#define R_KIP_SYSCFG 0x8088
#define R_KIP_CLK 0x808C
#define R_DPK_IDL 0x809C
#define B_DPK_IDL_SEL GENMASK(10, 9)
#define B_DPK_IDL BIT(8)
#define R_LDL_NORM 0x80A0
#define B_LDL_NORM_MA BIT(16)
#define B_LDL_NORM_PN GENMASK(12, 8)
#define B_LDL_NORM_OP GENMASK(1, 0)
#define R_DPK_CTL 0x80B0
#define B_DPK_CTL_EN BIT(28)
#define R_DPK_CFG 0x80B8
#define B_DPK_CFG_IDX GENMASK(14, 12)
#define R_DPK_CFG2 0x80BC
#define B_DPK_CFG2_ST BIT(14)
#define R_DPK_CFG3 0x80C0
#define R_KPATH_CFG 0x80D0
#define B_KPATH_CFG_ED GENMASK(21, 20)
#define R_KIP_RPT1 0x80D4
#define B_KIP_RPT1_SEL GENMASK(21, 16)
#define B_KIP_RPT1_SEL_V1 GENMASK(19, 16)
#define R_SRAM_IQRX 0x80D8
#define R_IDL_MPA 0x80DC
#define B_IDL_DN BIT(31)
#define B_IDL_MD530 BIT(1)
#define B_IDL_MD500 BIT(0)
#define R_GAPK 0x80E0
#define B_GAPK_ADR BIT(0)
#define R_SRAM_IQRX2 0x80E8
#define R_DPK_MPA 0x80EC
#define B_DPK_MPA_T0 BIT(10)
#define B_DPK_MPA_T1 BIT(9)
#define B_DPK_MPA_T2 BIT(8)
#define R_DPK_WR 0x80F4
#define B_DPK_WR_ST BIT(29)
#define R_DPK_TRK 0x80f0
#define B_DPK_TRK_DIS BIT(31)
#define R_RPT_COM 0x80FC
#define B_PRT_COM_SYNERR BIT(30)
#define B_PRT_COM_DCI GENMASK(27, 16)
#define B_PRT_COM_CORV GENMASK(15, 8)
#define B_RPT_COM_RDY GENMASK(15, 0)
#define B_PRT_COM_DCQ GENMASK(11, 0)
#define B_PRT_COM_RXOV BIT(8)
#define B_PRT_COM_GL GENMASK(7, 4)
#define B_PRT_COM_CORI GENMASK(7, 0)
#define B_PRT_COM_RXBB GENMASK(5, 0)
#define B_PRT_COM_RXBB_V1 GENMASK(4, 0)
#define B_PRT_COM_DONE BIT(0)
#define R_COEF_SEL 0x8104
#define R_COEF_SEL_C1 0x8204
#define B_COEF_SEL_IQC BIT(0)
#define B_COEF_SEL_IQC_V1 GENMASK(1, 0)
#define B_COEF_SEL_MDPD BIT(8)
#define B_COEF_SEL_MDPD_V1 GENMASK(9, 8)
#define B_COEF_SEL_EN BIT(31)
#define R_CFIR_COEF 0x810c
#define R_CFIR_SYS 0x8120
#define R_IQK_RES 0x8124
#define B_IQK_RES_K BIT(28)
#define B_IQK_RES_TXCFIR GENMASK(11, 8)
#define B_IQK_RES_RXCFIR GENMASK(3, 0)
#define R_TXIQC 0x8138
#define R_RXIQC 0x813c
#define B_RXIQC_BYPASS BIT(0)
#define B_RXIQC_BYPASS2 BIT(2)
#define B_RXIQC_NEWP GENMASK(19, 8)
#define B_RXIQC_NEWX GENMASK(31, 20)
#define R_KIP 0x8140
#define B_KIP_DBCC BIT(0)
#define B_KIP_RFGAIN BIT(8)
#define R_RFGAIN 0x8144
#define B_RFGAIN_PAD GENMASK(4, 0)
#define B_RFGAIN_TXBB GENMASK(12, 8)
#define R_RFGAIN_BND 0x8148
#define B_RFGAIN_BND GENMASK(4, 0)
#define R_CFIR_MAP 0x8150
#define R_CFIR_LUT 0x8154
#define R_CFIR_LUT_C1 0x8254
#define B_CFIR_LUT_SEL BIT(8)
#define B_CFIR_LUT_SET BIT(4)
#define B_CFIR_LUT_G5 BIT(5)
#define B_CFIR_LUT_G3 BIT(3)
#define B_CFIR_LUT_G2 BIT(2)
#define B_CFIR_LUT_GP_V1 GENMASK(2, 0)
#define B_CFIR_LUT_GP GENMASK(1, 0)
#define R_DPK_GN 0x819C
#define B_DPK_GN_EN GENMASK(17, 16)
#define B_DPK_GN_AG GENMASK(9, 0)
#define R_DPD_V1 0x81a0
#define B_DPD_LBK BIT(7)
#define R_DPD_CH0 0x81AC
#define R_DPD_BND 0x81B4
#define B_DPD_BND_1 GENMASK(24, 16)
#define B_DPD_BND_0 GENMASK(8, 0)
#define R_DPD_CH0A 0x81BC
#define B_DPD_MEN GENMASK(31, 28)
#define B_DPD_ORDER GENMASK(26, 24)
#define B_DPD_ORDER_V1 GENMASK(26, 25)
#define B_DPD_CFG GENMASK(22, 0)
#define B_DPD_SEL GENMASK(13, 8)
#define R_TXAGC_RFK 0x81C4
#define B_TXAGC_RFK_CH0 GENMASK(5, 0)
#define R_DPD_COM 0x81C8
#define B_DPD_COM_OF BIT(15)
#define R_KIP_IQP 0x81CC
#define B_KIP_IQP_SW GENMASK(13, 12)
#define B_KIP_IQP_IQSW GENMASK(5, 0)
#define R_KIP_RPT 0x81D4
#define B_KIP_RPT_SEL GENMASK(21, 16)
#define R_W_COEF 0x81D8
#define R_LOAD_COEF 0x81DC
#define B_LOAD_COEF_MDPD BIT(16)
#define B_LOAD_COEF_CFIR GENMASK(1, 0)
#define B_LOAD_COEF_DI BIT(1)
#define B_LOAD_COEF_AUTO BIT(0)
#define R_DPK_GL 0x81F0
#define B_DPK_GL_A0 GENMASK(31, 28)
#define B_DPK_GL_A1 GENMASK(17, 0)
#define R_RPT_PER 0x81FC
#define B_RPT_PER_KSET GENMASK(31, 29)
#define B_RPT_PER_TSSI GENMASK(28, 16)
#define B_RPT_PER_OF GENMASK(15, 8)
#define B_RPT_PER_TH GENMASK(5, 0)
#define R_IQRSN 0x8220
#define B_IQRSN_K1 BIT(28)
#define B_IQRSN_K2 BIT(16)
#define R_DPD_CH0B 0x82BC
#define R_RXCFIR_P0C0 0x8D40
#define R_RXCFIR_P0C1 0x8D84
#define R_RXCFIR_P0C2 0x8DC8
#define R_RXCFIR_P0C3 0x8E0C
#define R_TXCFIR_P0C0 0x8F50
#define R_TXCFIR_P0C1 0x8F84
#define R_TXCFIR_P0C2 0x8FB8
#define R_TXCFIR_P0C3 0x8FEC
#define R_RXCFIR_P1C0 0x9140
#define R_RXCFIR_P1C1 0x9184
#define R_RXCFIR_P1C2 0x91C8
#define R_RXCFIR_P1C3 0x920C
#define R_TXCFIR_P1C0 0x9350
#define R_TXCFIR_P1C1 0x9384
#define R_TXCFIR_P1C2 0x93B8
#define R_TXCFIR_P1C3 0x93EC
#define R_IQKINF 0x9FE0
#define B_IQKINF_VER GENMASK(31, 24)
#define B_IQKINF_FAIL_RXGRP GENMASK(23, 16)
#define B_IQKINF_FAIL_TXGRP GENMASK(15, 8)
#define B_IQKINF_FAIL GENMASK(3, 0)
#define B_IQKINF_F_RX BIT(3)
#define B_IQKINF_FTX BIT(2)
#define B_IQKINF_FFIN BIT(1)
#define B_IQKINF_FCOR BIT(0)
#define R_IQKCH 0x9FE4
#define B_IQKCH_CH GENMASK(15, 8)
#define B_IQKCH_BW GENMASK(7, 4)
#define B_IQKCH_BAND GENMASK(3, 0)
#define R_IQKINF2 0x9FE8
#define B_IQKINF2_FCNT GENMASK(23, 16)
#define B_IQKINF2_KCNT GENMASK(15, 8)
#define B_IQKINF2_NCTLV GENMASK(7, 0)
#define R_TXAGC_REF_DBM_RF1_P0 0xBC04
#define B_TXAGC_OFDM_REF_DBM_RF1_P0 GENMASK(10, 2)
#define B_TXAGC_CCK_REF_DBM_RF1_P0 GENMASK(19, 11)
#define R_TSSI_K_RF1_P0 0xBC28
#define B_TSSI_K_OFDM_RF1_P0 GENMASK(9, 0)
#define R_TXAGC_REF_DBM_RF1_P1 0xBD04
#define B_TXAGC_OFDM_REF_DBM_RF1_P1 GENMASK(10, 2)
#define B_TXAGC_CCK_REF_DBM_RF1_P1 GENMASK(19, 11)
#define R_TSSI_K_RF1_P1 0xBD28
#define B_TSSI_K_OFDM_RF1_P1 GENMASK(9, 0)
#define R_RFK_ST 0xBFF8
#define R_DCOF0 0xC000
#define B_DCOF0_RST BIT(17)
#define B_DCOF0_V GENMASK(4, 1)
#define R_DCOF1 0xC004
#define B_DCOF1_VAL GENMASK(31, 20)
#define B_DCOF1_RST BIT(17)
#define B_DCOF1_S BIT(0)
#define R_DCOF8 0xC020
#define B_DCOF8_V GENMASK(4, 1)
#define R_DCOF9 0xC024
#define B_DCOF9_VAL GENMASK(31, 20)
#define B_DCOF9_RST BIT(17)
#define R_DACK_S0P0 0xC040
#define B_DACK_S0P0_OK BIT(31)
#define R_DACK_BIAS00 0xc048
#define B_DACK_BIAS00 GENMASK(11, 2)
#define R_DACK_S0P2 0xC05C
#define B_DACK_S0M0 GENMASK(31, 24)
#define B_DACK_S0P2_OK BIT(2)
#define R_DACK_DADCK00 0xC060
#define B_DACK_DADCK00 GENMASK(31, 24)
#define R_DACK_S0P1 0xC064
#define B_DACK_S0P1_OK BIT(31)
#define R_DACK_BIAS01 0xC06C
#define B_DACK_BIAS01 GENMASK(11, 2)
#define R_DACK_S0P3 0xC080
#define B_DACK_S0M1 GENMASK(31, 24)
#define B_DACK_S0P3_OK BIT(2)
#define R_DACK_DADCK01 0xC084
#define B_DACK_DADCK01 GENMASK(31, 24)
#define R_DRCK_FH 0xC094
#define B_DRCK_LAT BIT(9)
#define R_DRCK 0xC0C4
#define B_DRCK_MUL GENMASK(21, 17)
#define B_DRCK_IDLE BIT(9)
#define B_DRCK_EN BIT(6)
#define B_DRCK_VAL GENMASK(4, 0)
#define R_DRCK_RES 0xC0C8
#define B_DRCK_RES GENMASK(19, 15)
#define B_DRCK_POL BIT(3)
#define R_DRCK_V1 0xC0CC
#define B_DRCK_V1_SEL BIT(9)
#define B_DRCK_V1_KICK BIT(6)
#define B_DRCK_V1_CV GENMASK(4, 0)
#define R_DRCK_RS 0xC0D0
#define B_DRCK_RS_LPS GENMASK(19, 15)
#define B_DRCK_RS_DONE BIT(3)
#define R_PATH0_SAMPL_DLY_T_V1 0xC0D4
#define B_PATH0_SAMPL_DLY_T_MSK_V1 GENMASK(27, 26)
#define R_P0_CFCH_BW0 0xC0D4
#define B_P0_CFCH_BW0 GENMASK(27, 26)
#define B_P0_CFCH_EN GENMASK(14, 11)
#define B_P0_CFCH_CTL GENMASK(10, 7)
#define R_P0_CFCH_BW1 0xC0D8
#define B_P0_CFCH_EX BIT(13)
#define B_P0_CFCH_BW1 GENMASK(8, 5)
#define R_WDADC 0xC0E4
#define B_WDADC_SEL GENMASK(5, 4)
#define R_ADCMOD 0xC0E8
#define B_ADCMOD_LP GENMASK(31, 16)
#define B_ADCMOD_AUTO_RST BIT(6)
#define R_DCIM 0xC0EC
#define B_DCIM_RC GENMASK(23, 16)
#define B_DCIM_FR GENMASK(14, 13)
#define R_ADDCK0D 0xC0F0
#define B_ADDCK0D_VAL2 GENMASK(31, 26)
#define B_ADDCK0D_VAL GENMASK(25, 16)
#define B_ADDCK_DS BIT(16)
#define R_ADDCK0 0xC0F4
#define B_ADDCK0_TRG BIT(11)
#define B_ADDCK0_IQ BIT(10)
#define B_ADDCK0 GENMASK(9, 8)
#define B_ADDCK0_MAN GENMASK(5, 4)
#define B_ADDCK0_EN BIT(4)
#define B_ADDCK0_VAL GENMASK(3, 0)
#define B_ADDCK0_RST BIT(2)
#define R_ADDCK0_RL 0xC0F8
#define B_ADDCK0_RLS GENMASK(29, 28)
#define B_ADDCK0_RL1 GENMASK(27, 18)
#define B_ADDCK0_RL0 GENMASK(17, 8)
#define R_ADDCKR0 0xC0FC
#define B_ADDCKR0_A0 GENMASK(19, 10)
#define B_ADDCKR0_DC GENMASK(15, 4)
#define B_ADDCKR0_A1 GENMASK(9, 0)
#define R_DACK10 0xC100
#define B_DACK10_RST BIT(17)
#define B_DACK10 GENMASK(4, 1)
#define R_DACK1_K 0xc104
#define B_DACK1_VAL GENMASK(31, 20)
#define B_DACK1_RST BIT(17)
#define B_DACK1_EN BIT(0)
#define R_DACK11 0xC120
#define B_DACK11 GENMASK(4, 1)
#define R_DACK2_K 0xC124
#define B_DACK2_VAL GENMASK(31, 20)
#define B_DACK2_RST BIT(17)
#define B_DACK2_EN BIT(0)
#define R_DACK_S1P0 0xC140
#define B_DACK_S1P0_OK BIT(31)
#define R_DACK_BIAS10 0xC148
#define B_DACK_BIAS10 GENMASK(11, 2)
#define R_DACK10S 0xC15C
#define B_DACK10S GENMASK(31, 24)
#define R_DACK_S1P2 0xC15C
#define B_DACK_S1P2_OK BIT(2)
#define R_DACK_DADCK10 0xC160
#define B_DACK_DADCK10 GENMASK(31, 24)
#define R_DACK_S1P1 0xC164
#define B_DACK_S1P1_OK BIT(31)
#define R_DACK_BIAS11 0xC16C
#define B_DACK_BIAS11 GENMASK(11, 2)
#define R_DACK11S 0xC180
#define B_DACK11S GENMASK(31, 24)
#define R_DACK_S1P3 0xC180
#define B_DACK_S1P3_OK BIT(2)
#define R_DACK_DADCK11 0xC184
#define B_DACK_DADCK11 GENMASK(31, 24)
#define R_PATH1_SAMPL_DLY_T_V1 0xC1D4
#define B_PATH1_SAMPL_DLY_T_MSK_V1 GENMASK(27, 26)
#define R_PATH0_BW_SEL_V1 0xC0D8
#define B_PATH0_BW_SEL_MSK_V1 GENMASK(8, 5)
#define R_PATH1_BW_SEL_V1 0xC1D8
#define B_PATH1_BW_SEL_EX BIT(13)
#define B_PATH1_BW_SEL_MSK_V1 GENMASK(8, 5)
#define R_ADDCK1D 0xC1F0
#define B_ADDCK1D_VAL2 GENMASK(31, 26)
#define B_ADDCK1D_VAL GENMASK(25, 16)
#define R_ADDCK1 0xC1F4
#define B_ADDCK1_TRG BIT(11)
#define B_ADDCK1 GENMASK(9, 8)
#define B_ADDCK1_MAN GENMASK(5, 4)
#define B_ADDCK1_EN BIT(4)
#define B_ADDCK1_RST BIT(2)
#define R_ADDCK1_RL 0xC1F8
#define B_ADDCK1_RLS GENMASK(29, 28)
#define B_ADDCK1_RL1 GENMASK(27, 18)
#define B_ADDCK1_RL0 GENMASK(17, 8)
#define R_ADDCKR1 0xC1fC
#define B_ADDCKR1_A0 GENMASK(19, 10)
#define B_ADDCKR1_A1 GENMASK(9, 0)
#define R_DACKN0_CTL 0xC210
#define B_DACKN0_EN BIT(0)
#define B_DACKN0_V GENMASK(21, 14)
#define R_DACKN1_CTL 0xC224
#define B_DACKN1_V GENMASK(21, 14)
#define B_DACKN1_ON BIT(0)
#define R_DACKN2_CTL 0xC238
#define B_DACKN2_ON BIT(0)
#define R_DACKN3_CTL 0xC24C
#define B_DACKN3_ON BIT(0)
#define R_GAIN_MAP0 0xE44C
#define B_GAIN_MAP0_EN BIT(0)
#define R_GAIN_MAP1 0xE54C
#define B_GAIN_MAP1_EN BIT(0)
#define R_GOTX_IQKDPK_C0 0xE464
#define R_GOTX_IQKDPK_C0_BE4 0x2E464
#define R_GOTX_IQKDPK_C1 0xE564
#define R_GOTX_IQKDPK_C1_BE4 0x2E564
#define B_GOTX_IQKDPK GENMASK(28, 27)
#define R_IQK_DPK_PRST 0xE4AC
#define R_IQK_DPK_PRST_BE4 0x2E4AC
#define R_IQK_DPK_PRST_C1 0xE5AC
#define R_IQK_DPK_PRST_C1_BE4 0x2E5AC
#define B_IQK_DPK_PRST BIT(27)
#define R_TXPWR_RSTA 0xE60C
#define B_TXPWR_RSTA BIT(16)
#define R_TSSI_PWR_P0 0xE610
#define R_TSSI_PWR_P1 0xE710
#define B_TSSI_CONT_EN BIT(3)
#define R_P0_TXPWRB_BE 0xE61C
#define R_P1_TXPWRB_BE 0xE71C
#define B_TXPWRB_MAX_BE GENMASK(20, 12)
#define R_TSSI_MAP_OFST_P0 0xE620
#define R_TSSI_MAP_OFST_P1 0xE720
#define B_TSSI_MAP_OFST_OFDM GENMASK(17, 9)
#define B_TSSI_MAP_OFST_CCK GENMASK(26, 18)
#define R_TXAGC_REF_DBM_P0 0xE628
#define B_TXAGC_OFDM_REF_DBM_P0 GENMASK(8, 0)
#define B_TXAGC_CCK_REF_DBM_P0 GENMASK(17, 9)
#define R_TSSI_K_P0 0xE6A0
#define B_TSSI_K_OFDM_P0 GENMASK(29, 20)
#define R_TXPWR_RSTB 0xE70C
#define B_TXPWR_RSTB BIT(16)
#define R_TXAGC_REF_DBM_P1 0xE728
#define B_TXAGC_OFDM_REF_DBM_P1 GENMASK(8, 0)
#define B_TXAGC_CCK_REF_DBM_P1 GENMASK(17, 9)
#define R_TSSI_K_P1 0xE7A0
#define B_TSSI_K_OFDM_P1 GENMASK(29, 20)

#define R_COMP_CIM3K_BE4 0x11998
#define B_COMP_CIM3K_OW_BE4 BIT(1)
#define B_COMP_CIM3K_TH_BE4 BIT(2)
#define B_COMP_CIM3K_TH2_BE4 GENMASK(5, 3)
#define B_COMP_CIM3K_TXPWR_EN_BE4 BIT(6)
#define B_COMP_CIM3K_NONBE_BE4 BIT(7)
#define B_COMP_CIM3K_BANDEDGE_BE4 BIT(8)
#define R_DPD_CBW160_BE4 0x119B4
#define B_DPD_CBW160_TH0_BE4 BIT(0)
#define B_DPD_CBW160_TH1_BE4 BIT(1)
#define B_DPD_CBW160_TH2_BE4 BIT(2)
#define B_DPD_CBW160_TH3_BE4 BIT(3)
#define B_DPD_CBW160_TH4_BE4 BIT(4)
#define B_DPD_CBW160_TH5_BE4 BIT(5)
#define B_DPD_CBW160_TH6_BE4 BIT(6)
#define B_DPD_CBW160_TH7_BE4 BIT(7)
#define B_DPD_CBW160_OW0_BE4 BIT(8)
#define B_DPD_CBW160_OW1_BE4 BIT(9)
#define B_DPD_CBW160_OW2_BE4 BIT(10)
#define B_DPD_CBW160_OW3_BE4 BIT(11)
#define B_DPD_CBW160_OW4_BE4 BIT(12)
#define B_DPD_CBW160_OW5_BE4 BIT(13)
#define B_DPD_CBW160_OW6_BE4 BIT(14)
#define B_DPD_CBW160_OW7_BE4 BIT(15)
#define R_OOB_CBW20_BE4 0x119B4
#define B_OOB_CBW20_CCK0_BE4 BIT(16)
#define B_OOB_CBW20_CCK1_BE4 BIT(17)
#define B_OOB_CBW20_CCK2_BE4 BIT(18)
#define B_OOB_CBW20_CCK3_BE4 BIT(19)
#define B_OOB_CBW20_CCK4_BE4 BIT(20)
#define B_OOB_CBW20_CCK5_BE4 BIT(21)
#define B_OOB_CBW20_CCK6_BE4 BIT(22)
#define B_OOB_CBW20_CCK7_BE4 BIT(23)
#define B_OOB_CBW20_TH0_BE4 BIT(24)
#define B_OOB_CBW20_TH1_BE4 BIT(25)
#define B_OOB_CBW20_TH2_BE4 BIT(26)
#define B_OOB_CBW20_TH3_BE4 BIT(27)
#define B_OOB_CBW20_TH4_BE4 BIT(28)
#define B_OOB_CBW20_TH5_BE4 BIT(29)
#define B_OOB_CBW20_TH6_BE4 BIT(30)
#define B_OOB_CBW20_TH7_BE4 BIT(31)
#define R_OOB_CBW40_BE4 0x119B8
#define B_OOB_CBW20_OW0_BE4 BIT(0)
#define B_OOB_CBW20_OW1_BE4 BIT(1)
#define B_OOB_CBW20_OW2_BE4 BIT(2)
#define B_OOB_CBW20_OW3_BE4 BIT(3)
#define B_OOB_CBW20_OW4_BE4 BIT(4)
#define B_OOB_CBW20_OW5_BE4 BIT(5)
#define B_OOB_CBW20_OW6_BE4 BIT(6)
#define B_OOB_CBW20_OW7_BE4 BIT(7)
#define B_OOB_CBW40_CCK0_BE4 BIT(8)
#define B_OOB_CBW40_CCK1_BE4 BIT(9)
#define B_OOB_CBW40_CCK2_BE4 BIT(10)
#define B_OOB_CBW40_CCK3_BE4 BIT(11)
#define B_OOB_CBW40_CCK4_BE4 BIT(12)
#define B_OOB_CBW40_CCK5_BE4 BIT(13)
#define B_OOB_CBW40_CCK6_BE4 BIT(14)
#define B_OOB_CBW40_CCK7_BE4 BIT(15)
#define B_OOB_CBW40_TH0_BE4 BIT(16)
#define B_OOB_CBW40_TH1_BE4 BIT(17)
#define B_OOB_CBW40_TH2_BE4 BIT(18)
#define B_OOB_CBW40_TH3_BE4 BIT(19)
#define B_OOB_CBW40_TH4_BE4 BIT(20)
#define B_OOB_CBW40_TH5_BE4 BIT(21)
#define B_OOB_CBW40_TH6_BE4 BIT(22)
#define B_OOB_CBW40_TH7_BE4 BIT(23)
#define B_OOB_CBW40_OW0_BE4 BIT(24)
#define B_OOB_CBW40_OW1_BE4 BIT(25)
#define B_OOB_CBW40_OW2_BE4 BIT(26)
#define B_OOB_CBW40_OW3_BE4 BIT(27)
#define B_OOB_CBW40_OW4_BE4 BIT(28)
#define B_OOB_CBW40_OW5_BE4 BIT(29)
#define B_OOB_CBW40_OW6_BE4 BIT(30)
#define B_OOB_CBW40_OW7_BE4 BIT(31)
#define R_OOB_CBW80_BE4 0x119BC
#define B_OOB_CBW80_TH0_BE4 BIT(0)
#define B_OOB_CBW80_TH1_BE4 BIT(1)
#define B_OOB_CBW80_TH2_BE4 BIT(2)
#define B_OOB_CBW80_TH3_BE4 BIT(3)
#define B_OOB_CBW80_TH4_BE4 BIT(4)
#define B_OOB_CBW80_TH5_BE4 BIT(5)
#define B_OOB_CBW80_TH6_BE4 BIT(6)
#define B_OOB_CBW80_TH7_BE4 BIT(7)
#define B_OOB_CBW80_OW0_BE4 BIT(8)
#define B_OOB_CBW80_OW1_BE4 BIT(9)
#define B_OOB_CBW80_OW2_BE4 BIT(10)
#define B_OOB_CBW80_OW3_BE4 BIT(11)
#define B_OOB_CBW80_OW4_BE4 BIT(12)
#define B_OOB_CBW80_OW5_BE4 BIT(13)
#define B_OOB_CBW80_OW6_BE4 BIT(14)
#define B_OOB_CBW80_OW7_BE4 BIT(15)
#define R_DPD_DBW160_TH0_BE4 0x119BC
#define B_DPD_DBW160_TH0_0_BE4 GENMASK(18, 16)
#define B_DPD_DBW160_TH0_1_BE4 GENMASK(21, 19)
#define B_DPD_DBW160_TH0_2_BE4 GENMASK(24, 22)
#define B_DPD_DBW160_TH0_3_BE4 GENMASK(27, 25)
#define B_DPD_DBW160_TH0_4_BE4 GENMASK(30, 28)
#define R_DPD_DBW160_TH1_BE4 0x119C0
#define B_DPD_DBW160_TH1_5_BE4 GENMASK(2, 0)
#define B_DPD_DBW160_TH1_6_BE4 GENMASK(5, 3)
#define B_DPD_DBW160_TH1_7_BE4 GENMASK(8, 6)
#define R_DPD_CBW_TH0_BE4 0x119C0
#define B_DPD_CBW20_TH0_0_BE4 GENMASK(11, 9)
#define B_DPD_CBW20_TH0_1_BE4 GENMASK(14, 12)
#define B_DPD_CBW20_TH0_2_BE4 GENMASK(17, 15)
#define B_DPD_CBW20_TH0_3_BE4 GENMASK(20, 18)
#define B_DPD_CBW20_TH0_4_BE4 GENMASK(23, 21)
#define B_DPD_CBW20_TH0_5_BE4 GENMASK(26, 24)
#define B_DPD_CBW20_TH0_6_BE4 GENMASK(29, 27)
#define R_DPD_CBW_TH1_BE4 0x119C4
#define B_DPD_CBW20_TH1_7_BE4 GENMASK(2, 0)
#define B_DPD_CBW40_TH1_0_BE4 GENMASK(5, 3)
#define B_DPD_CBW40_TH1_1_BE4 GENMASK(8, 6)
#define B_DPD_CBW40_TH1_2_BE4 GENMASK(11, 9)
#define B_DPD_CBW40_TH1_3_BE4 GENMASK(14, 12)
#define B_DPD_CBW40_TH1_4_BE4 GENMASK(17, 15)
#define B_DPD_CBW40_TH1_5_BE4 GENMASK(20, 18)
#define B_DPD_CBW40_TH1_6_BE4 GENMASK(23, 21)
#define B_DPD_CBW40_TH1_7_BE4 GENMASK(26, 24)
#define B_DPD_CBW80_TH1_0_BE4 GENMASK(29, 27)
#define R_DPD_CBW_TH2_BE4 0x119C8
#define B_DPD_CBW80_TH2_1_BE4 GENMASK(2, 0)
#define B_DPD_CBW80_TH2_2_BE4 GENMASK(5, 3)
#define B_DPD_CBW80_TH2_3_BE4 GENMASK(8, 6)
#define B_DPD_CBW80_TH2_4_BE4 GENMASK(11, 9)
#define B_DPD_CBW80_TH2_5_BE4 GENMASK(14, 12)
#define B_DPD_CBW80_TH2_6_BE4 GENMASK(17, 15)
#define B_DPD_CBW80_TH2_7_BE4 GENMASK(20, 18)
#define R_QAM_TH0_BE4 0x119E4
#define B_QAM_TH0_0_BE4 GENMASK(18, 16)
#define B_QAM_TH0_1_BE4 GENMASK(21, 19)
#define B_QAM_TH0_2_BE4 GENMASK(24, 22)
#define B_QAM_TH0_3_BE4 GENMASK(27, 25)
#define B_QAM_TH0_4_BE4 GENMASK(30, 28)
#define R_QAM_TH1_BE4 0x119E8
#define B_QAM_TH1_0_BE4 GENMASK(2, 0)
#define B_QAM_TH1_1_BE4 GENMASK(5, 3)
#define B_QAM_TH1_2_BE4 GENMASK(8, 6)
#define B_QAM_TH1_3_BE4 GENMASK(11, 9)
#define B_QAM_TH1_4_BE4 GENMASK(14, 12)
#define B_QAM_TH1_5_BE4 GENMASK(17, 15)
#define B_QAM_TH1_6_BE4 GENMASK(20, 18)
#define B_QAM_TH1_7_BE4 GENMASK(23, 21)
#define B_QAM_TH1_8_BE4 GENMASK(26, 24)
#define B_QAM_TH1_9_BE4 GENMASK(29, 27)
#define R_QAM_TH2_BE4 0x119EC
#define B_QAM_TH2_0_BE4 GENMASK(2, 0)
#define B_QAM_TH2_1_BE4 GENMASK(5, 3)
#define B_QAM_TH2_2_BE4 GENMASK(8, 6)
#define B_QAM_TH2_3_BE4 GENMASK(11, 9)
#define B_QAM_TH2_4_BE4 GENMASK(14, 12)
#define B_QAM_TH2_5_BE4 GENMASK(17, 15)
#define B_QAM_TH2_6_BE4 GENMASK(20, 18)
#define B_QAM_TH2_7_BE4 GENMASK(23, 21)
#define B_QAM_TH2_8_BE4 GENMASK(26, 24)
#define R_RFSI_CT_DEF_BE4 0x119F0
#define B_RFSI_CT_ER_BE4 GENMASK(18, 15)
#define B_RFSI_CT_SUBF_BE4 GENMASK(22, 19)
#define B_RFSI_CT_FTM_BE4 GENMASK(26, 23)
#define B_RFSI_CT_SENS_BE4 GENMASK(30, 27)
#define R_FBTB_CT_DEF_BE4 0x119F4
#define B_FBTB_CT_DEF_BE GENMASK(3, 0)
#define B_FBTB_CT_PB_BE4 GENMASK(7, 4)
#define B_FBTB_CT_DL_WO_BE4 GENMASK(11, 8)
#define B_FBTB_CT_DL_BF_BE4 GENMASK(15, 12)
#define B_FBTB_CT_MUMIMO_BE4 GENMASK(19, 16)
#define B_FBTB_CT_FTM_BE4 GENMASK(23, 20)
#define B_FBTB_CT_SENS_BE4 GENMASK(27, 24)
#define R_RFSI_CT_OPT_0_BE4 0x11A94
#define R_RFSI_CT_OPT_8_BE4 0x11A98
#define R_QAM_COMP_TH0_BE4 0x11A9C
#define R_QAM_COMP_TH1_BE4 0x11AA0
#define R_QAM_COMP_TH2_BE4 0x11AA4
#define R_QAM_COMP_TH3_BE4 0x11AA8
#define R_QAM_COMP_TH4_BE4 0x11ABC
#define B_QAM_COMP_TH4_L GENMASK(4, 0)
#define B_QAM_COMP_TH4_M GENMASK(14, 10)
#define B_QAM_COMP_TH4_H GENMASK(24, 20)
#define B_QAM_COMP_TH4_2L GENMASK(9, 5)
#define B_QAM_COMP_TH4_2M GENMASK(19, 15)
#define B_QAM_COMP_TH4_2H GENMASK(29, 25)
#define R_QAM_COMP_TH5_BE4 0x11AC0
#define B_QAM_COMP_TH5_L GENMASK(4, 0)
#define B_QAM_COMP_TH5_M GENMASK(14, 10)
#define B_QAM_COMP_TH5_H GENMASK(24, 20)
#define B_QAM_COMP_TH5_2L GENMASK(9, 5)
#define B_QAM_COMP_TH5_2M GENMASK(19, 15)
#define B_QAM_COMP_TH5_2H GENMASK(29, 25)
#define R_QAM_COMP_TH6_BE4 0x11AC4
#define B_QAM_COMP_TH6_L GENMASK(4, 0)
#define B_QAM_COMP_TH6_M GENMASK(14, 10)
#define B_QAM_COMP_TH6_2L GENMASK(9, 5)
#define B_QAM_COMP_TH6_2M GENMASK(19, 15)
#define R_OW_VAL_0_BE4 0x11AAC
#define R_OW_VAL_1_BE4 0x11AB0
#define R_OW_VAL_2_BE4 0x11AB4
#define R_OW_VAL_3_BE4 0x11AB8
#define R_BANDEDGE_DBWX_BE4 0x11ACC
#define B_BANDEDGE_DBW20_BE4 BIT(29)
#define B_BANDEDGE_DBW40_BE4 BIT(30)
#define B_BANDEDGE_DBW80_BE4 BIT(31)
#define R_BANDEDGE_DBWY_BE4 0x11AD0
#define B_BANDEDGE_DBW160_BE4 BIT(0)

#define R_CHINFO_SEG_BE4 0x200B4
#define B_CHINFO_SEG_LEN_BE4 GENMASK(12, 10)
#define R_STS_HDR2_PARSING_BE4 0x2070C
#define B_STS_HDR2_PARSING_BE4 BIT(10)
#define R_SW_SI_WDATA_BE4 0x20370
#define B_SW_SI_DATA_PATH_BE4 GENMASK(31, 28)
#define B_SW_SI_DATA_ADR_BE4 GENMASK(27, 20)
#define B_SW_SI_DATA_DAT_BE4 GENMASK(19, 0)
#define R_SW_SI_READ_ADDR_BE4 0x20378
#define B_SW_SI_READ_ADDR_BE4 GENMASK(10, 0)
#define R_IFS_T1_AVG_BE4 0x20EDC
#define B_IFS_T1_AVG_BE4 GENMASK(15, 0)
#define B_IFS_T2_AVG_BE4 GENMASK(31, 16)
#define R_IFS_T3_AVG_BE4 0x20EE0
#define B_IFS_T3_AVG_BE4 GENMASK(15, 0)
#define B_IFS_T4_AVG_BE4 GENMASK(31, 16)
#define R_IFS_T1_CLM_BE4 0x20EE4
#define B_IFS_T1_CLM_BE4 GENMASK(15, 0)
#define B_IFS_T2_CLM_BE4 GENMASK(31, 16)
#define R_IFS_T3_CLM_BE4 0x20EE8
#define B_IFS_T3_CLM_BE4 GENMASK(15, 0)
#define B_IFS_T4_CLM_BE4 GENMASK(31, 16)
#define R_IFS_TOTAL_BE4 0x20EEC
#define B_IFS_TOTAL_BE4 GENMASK(15, 0)
#define B_IFS_CNT_DONE_BE4 BIT(16)
#define R_IFS_T1_HIS_BE4 0x20F50
#define B_IFS_T1_HIS_BE4 GENMASK(15, 0)
#define B_IFS_T2_HIS_BE4 GENMASK(31, 16)
#define R_IFS_T3_HIS_BE4 0x20F54
#define B_IFS_T3_HIS_BE4 GENMASK(15, 0)
#define B_IFS_T4_HIS_BE4 GENMASK(31, 16)

#define R_TX_CFR_MANUAL_EN_BE4 0x2483C
#define B_TX_CFR_MANUAL_EN_BE4_M BIT(30)

#define R_CHINFO_OPT_BE4 0x267C8
#define B_CHINFO_OPT_BE4 GENMASK(14, 13)
#define R_CHINFO_NX_BE4 0x267D0
#define B_CHINFO_NX_BE4 GENMASK(16, 6)
#define R_CHINFO_ALG_BE4 0x267C8
#define B_CHINFO_ALG_BE4 GENMASK(31, 30)

#define R_SW_SI_DATA_BE4 0x2CF4C
#define B_SW_SI_READ_DATA_BE4 GENMASK(19, 0)
#define B_SW_SI_W_BUSY_BE4 BIT(24)
#define B_SW_SI_R_BUSY_BE4 BIT(25)
#define B_SW_SI_READ_DATA_DONE_BE4 BIT(26)

/* WiFi CPU local domain */
#define R_AX_WDT_CTRL 0x0040
#define B_AX_WDT_EN BIT(31)
#define B_AX_WDT_OPT_RESET_PLATFORM_EN BIT(29)
#define B_AX_IO_HANG_IMR BIT(27)
#define B_AX_IO_HANG_CMAC_RDATA_EN BIT(26)
#define B_AX_IO_HANG_DMAC_EN BIT(25)
#define B_AX_WDT_CLR BIT(16)
#define B_AX_WDT_COUNT_MASK GENMASK(15, 0)
#define WDT_CTRL_ALL_DIS 0

#define R_AX_WDT_STATUS 0x0044
#define B_AX_FS_WDT_INT BIT(8)
#define B_AX_FS_WDT_INT_MSK BIT(0)

#endif
