/* SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause */
/* Copyright(c) 2019-2020  Realtek Corporation
 */

#ifndef __RTW89_CAM_H__
#define __RTW89_CAM_H__

#include "core.h"

#define RTW89_SEC_CAM_LEN	20

#define RTW89_BSSID_MATCH_ALL GENMASK(5, 0)
#define RTW89_BSSID_MATCH_5_BYTES GENMASK(4, 0)

struct rtw89_h2c_addr_cam_v0 {
	__le32 w0;
	__le32 w1;
	__le32 w2;
	__le32 w3;
	__le32 w4;
	__le32 w5;
	__le32 w6;
	__le32 w7;
	__le32 w8;
	__le32 w9;
	__le32 w10;
	__le32 w11;
	__le32 w12;
	__le32 w13;
	__le32 w14;
} __packed;

struct rtw89_h2c_addr_cam {
	struct rtw89_h2c_addr_cam_v0 v0;
	__le32 w15;
} __packed;

#define ADDR_CAM_W1_IDX GENMASK(7, 0)
#define ADDR_CAM_W1_OFFSET GENMASK(15, 8)
#define ADDR_CAM_W1_LEN GENMASK(23, 16)
#define ADDR_CAM_W1_V1_IDX GENMASK(9, 0)
#define ADDR_CAM_W1_V1_OFFSET GENMASK(23, 16)
#define ADDR_CAM_W1_V1_LEN GENMASK(31, 24)
#define ADDR_CAM_W2_VALID BIT(0)
#define ADDR_CAM_W2_NET_TYPE GENMASK(2, 1)
#define ADDR_CAM_W2_BCN_HIT_COND GENMASK(4, 3)
#define ADDR_CAM_W2_HIT_RULE GENMASK(6, 5)
#define ADDR_CAM_W2_BB_SEL BIT(7)
#define ADDR_CAM_W2_ADDR_MASK GENMASK(13, 8)
#define ADDR_CAM_W2_MASK_SEL GENMASK(15, 14)
#define ADDR_CAM_W2_SMA_HASH GENMASK(23, 16)
#define ADDR_CAM_W2_TMA_HASH GENMASK(31, 24)
#define ADDR_CAM_W3_BSSID_CAM_IDX GENMASK(5, 0)
#define ADDR_CAM_W4_SMA0 GENMASK(7, 0)
#define ADDR_CAM_W4_SMA1 GENMASK(15, 8)
#define ADDR_CAM_W4_SMA2 GENMASK(23, 16)
#define ADDR_CAM_W4_SMA3 GENMASK(31, 24)
#define ADDR_CAM_W5_SMA4 GENMASK(7, 0)
#define ADDR_CAM_W5_SMA5 GENMASK(15, 8)
#define ADDR_CAM_W5_TMA0 GENMASK(23, 16)
#define ADDR_CAM_W5_TMA1 GENMASK(31, 24)
#define ADDR_CAM_W6_TMA2 GENMASK(7, 0)
#define ADDR_CAM_W6_TMA3 GENMASK(15, 8)
#define ADDR_CAM_W6_TMA4 GENMASK(23, 16)
#define ADDR_CAM_W6_TMA5 GENMASK(31, 24)
#define ADDR_CAM_W8_MACID GENMASK(7, 0)
#define ADDR_CAM_W8_PORT_INT GENMASK(10, 8)
#define ADDR_CAM_W8_TSF_SYNC GENMASK(13, 11)
#define ADDR_CAM_W8_TF_TRS BIT(14)
#define ADDR_CAM_W8_LSIG_TXOP BIT(15)
#define ADDR_CAM_W8_TGT_IND GENMASK(26, 24)
#define ADDR_CAM_W8_FRM_TGT_IND GENMASK(29, 27)
#define ADDR_CAM_W8_V1_MACID GENMASK(9, 0)
#define ADDR_CAM_W8_V1_PORT_INT GENMASK(18, 16)
#define ADDR_CAM_W8_V1_TSF_SYNC GENMASK(21, 19)
#define ADDR_CAM_W8_V1_TF_TRS BIT(22)
#define ADDR_CAM_W8_V1_LSIG_TXOP BIT(23)
#define ADDR_CAM_W8_V1_TB_RANGING BIT(24)
#define ADDR_CAM_W8_V1_TB_SENSING BIT(25)
#define ADDR_CAM_W8_V1_SENS_EN BIT(26)
#define ADDR_CAM_W9_AID12 GENMASK(11, 0)
#define ADDR_CAM_W9_AID12_0 GENMASK(7, 0)
#define ADDR_CAM_W9_AID12_1 GENMASK(11, 8)
#define ADDR_CAM_W9_WOL_PATTERN BIT(12)
#define ADDR_CAM_W9_WOL_UC BIT(13)
#define ADDR_CAM_W9_WOL_MAGIC BIT(14)
#define ADDR_CAM_W9_WAPI BIT(15)
#define ADDR_CAM_W9_SEC_ENT_MODE GENMASK(17, 16)
#define ADDR_CAM_W9_SEC_ENT0_KEYID GENMASK(19, 18)
#define ADDR_CAM_W9_SEC_ENT1_KEYID GENMASK(21, 20)
#define ADDR_CAM_W9_SEC_ENT2_KEYID GENMASK(23, 22)
#define ADDR_CAM_W9_SEC_ENT3_KEYID GENMASK(25, 24)
#define ADDR_CAM_W9_SEC_ENT4_KEYID GENMASK(27, 26)
#define ADDR_CAM_W9_SEC_ENT5_KEYID GENMASK(29, 28)
#define ADDR_CAM_W9_SEC_ENT6_KEYID GENMASK(31, 30)
#define ADDR_CAM_W10_SEC_ENT_VALID GENMASK(7, 0)
#define ADDR_CAM_W10_SEC_ENT0 GENMASK(15, 8)
#define ADDR_CAM_W10_SEC_ENT1 GENMASK(23, 16)
#define ADDR_CAM_W10_SEC_ENT2 GENMASK(31, 24)
#define ADDR_CAM_W11_SEC_ENT3 GENMASK(7, 0)
#define ADDR_CAM_W11_SEC_ENT4 GENMASK(15, 8)
#define ADDR_CAM_W11_SEC_ENT5 GENMASK(23, 16)
#define ADDR_CAM_W11_SEC_ENT6 GENMASK(31, 24)
#define ADDR_CAM_W12_BSSID_IDX GENMASK(7, 0)
#define ADDR_CAM_W12_BSSID_OFFSET GENMASK(15, 8)
#define ADDR_CAM_W12_BSSID_LEN GENMASK(23, 16)
#define ADDR_CAM_W13_BSSID_VALID BIT(0)
#define ADDR_CAM_W13_BSSID_BB_SEL BIT(1)
#define ADDR_CAM_W13_BSSID_MASK GENMASK(7, 2)
#define ADDR_CAM_W13_BSSID_BSS_COLOR GENMASK(13, 8)
#define ADDR_CAM_W13_BSSID_BSSID0 GENMASK(23, 16)
#define ADDR_CAM_W13_BSSID_BSSID1 GENMASK(31, 24)
#define ADDR_CAM_W14_BSSID_BSSID2 GENMASK(7, 0)
#define ADDR_CAM_W14_BSSID_BSSID3 GENMASK(15, 8)
#define ADDR_CAM_W14_BSSID_BSSID4 GENMASK(23, 16)
#define ADDR_CAM_W14_BSSID_BSSID5 GENMASK(31, 24)
#define ADDR_CAM_W15_UPD_MODE GENMASK(2, 0)

struct rtw89_h2c_dctlinfo_ud_v1 {
	__le32 c0;
	__le32 w0;
	__le32 w1;
	__le32 w2;
	__le32 w3;
	__le32 w4;
	__le32 w5;
	__le32 w6;
	__le32 w7;
	__le32 m0;
	__le32 m1;
	__le32 m2;
	__le32 m3;
	__le32 m4;
	__le32 m5;
	__le32 m6;
	__le32 m7;
} __packed;

#define DCTLINFO_V1_C0_MACID GENMASK(6, 0)
#define DCTLINFO_V1_C0_OP BIT(7)

#define DCTLINFO_V1_W0_QOS_FIELD_H GENMASK(7, 0)
#define DCTLINFO_V1_W0_HW_EXSEQ_MACID GENMASK(14, 8)
#define DCTLINFO_V1_W0_QOS_DATA BIT(15)
#define DCTLINFO_V1_W0_AES_IV_L GENMASK(31, 16)
#define DCTLINFO_V1_W0_ALL GENMASK(31, 0)
#define DCTLINFO_V1_W1_AES_IV_H GENMASK(31, 0)
#define DCTLINFO_V1_W1_ALL GENMASK(31, 0)
#define DCTLINFO_V1_W2_SEQ0 GENMASK(11, 0)
#define DCTLINFO_V1_W2_SEQ1 GENMASK(23, 12)
#define DCTLINFO_V1_W2_AMSDU_MAX_LEN GENMASK(26, 24)
#define DCTLINFO_V1_W2_STA_AMSDU_EN BIT(27)
#define DCTLINFO_V1_W2_CHKSUM_OFLD_EN BIT(28)
#define DCTLINFO_V1_W2_WITH_LLC BIT(29)
#define DCTLINFO_V1_W2_ALL GENMASK(29, 0)
#define DCTLINFO_V1_W3_SEQ2 GENMASK(11, 0)
#define DCTLINFO_V1_W3_SEQ3 GENMASK(23, 12)
#define DCTLINFO_V1_W3_TGT_IND GENMASK(27, 24)
#define DCTLINFO_V1_W3_TGT_IND_EN BIT(28)
#define DCTLINFO_V1_W3_HTC_LB GENMASK(31, 29)
#define DCTLINFO_V1_W3_ALL GENMASK(31, 0)
#define DCTLINFO_V1_W4_MHDR_LEN GENMASK(4, 0)
#define DCTLINFO_V1_W4_VLAN_TAG_VALID BIT(5)
#define DCTLINFO_V1_W4_VLAN_TAG_SEL GENMASK(7, 6)
#define DCTLINFO_V1_W4_HTC_ORDER BIT(8)
#define DCTLINFO_V1_W4_SEC_KEY_ID GENMASK(10, 9)
#define DCTLINFO_V1_W4_WAPI BIT(15)
#define DCTLINFO_V1_W4_SEC_ENT_MODE GENMASK(17, 16)
#define DCTLINFO_V1_W4_SEC_ENT0_KEYID GENMASK(19, 18)
#define DCTLINFO_V1_W4_SEC_ENT1_KEYID GENMASK(21, 20)
#define DCTLINFO_V1_W4_SEC_ENT2_KEYID GENMASK(23, 22)
#define DCTLINFO_V1_W4_SEC_ENT3_KEYID GENMASK(25, 24)
#define DCTLINFO_V1_W4_SEC_ENT4_KEYID GENMASK(27, 26)
#define DCTLINFO_V1_W4_SEC_ENT5_KEYID GENMASK(29, 28)
#define DCTLINFO_V1_W4_SEC_ENT6_KEYID GENMASK(31, 30)
#define DCTLINFO_V1_W4_ALL (GENMASK(31, 15) | GENMASK(10, 0))
#define DCTLINFO_V1_W5_SEC_ENT_VALID GENMASK(7, 0)
#define DCTLINFO_V1_W5_SEC_ENT0 GENMASK(15, 8)
#define DCTLINFO_V1_W5_SEC_ENT1 GENMASK(23, 16)
#define DCTLINFO_V1_W5_SEC_ENT2 GENMASK(31, 24)
#define DCTLINFO_V1_W5_ALL GENMASK(31, 0)
#define DCTLINFO_V1_W6_SEC_ENT3 GENMASK(7, 0)
#define DCTLINFO_V1_W6_SEC_ENT4 GENMASK(15, 8)
#define DCTLINFO_V1_W6_SEC_ENT5 GENMASK(23, 16)
#define DCTLINFO_V1_W6_SEC_ENT6 GENMASK(31, 24)
#define DCTLINFO_V1_W6_ALL GENMASK(31, 0)

struct rtw89_h2c_dctlinfo_ud_v2 {
	__le32 c0;
	__le32 w0;
	__le32 w1;
	__le32 w2;
	__le32 w3;
	__le32 w4;
	__le32 w5;
	__le32 w6;
	__le32 w7;
	__le32 w8;
	__le32 w9;
	__le32 w10;
	__le32 w11;
	__le32 w12;
	__le32 w13;
	__le32 w14;
	__le32 w15;
	__le32 m0;
	__le32 m1;
	__le32 m2;
	__le32 m3;
	__le32 m4;
	__le32 m5;
	__le32 m6;
	__le32 m7;
	__le32 m8;
	__le32 m9;
	__le32 m10;
	__le32 m11;
	__le32 m12;
	__le32 m13;
	__le32 m14;
	__le32 m15;
} __packed;

#define DCTLINFO_V2_C0_MACID GENMASK(6, 0)
#define DCTLINFO_V2_C0_OP BIT(7)

#define DCTLINFO_V2_W0_QOS_FIELD_H GENMASK(7, 0)
#define DCTLINFO_V2_W0_HW_EXSEQ_MACID GENMASK(14, 8)
#define DCTLINFO_V2_W0_QOS_DATA BIT(15)
#define DCTLINFO_V2_W0_AES_IV_L GENMASK(31, 16)
#define DCTLINFO_V2_W0_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W1_AES_IV_H GENMASK(31, 0)
#define DCTLINFO_V2_W1_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W2_SEQ0 GENMASK(11, 0)
#define DCTLINFO_V2_W2_SEQ1 GENMASK(23, 12)
#define DCTLINFO_V2_W2_AMSDU_MAX_LEN GENMASK(26, 24)
#define DCTLINFO_V2_W2_STA_AMSDU_EN BIT(27)
#define DCTLINFO_V2_W2_CHKSUM_OFLD_EN BIT(28)
#define DCTLINFO_V2_W2_WITH_LLC BIT(29)
#define DCTLINFO_V2_W2_NAT25_EN BIT(30)
#define DCTLINFO_V2_W2_IS_MLD BIT(31)
#define DCTLINFO_V2_W2_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W3_SEQ2 GENMASK(11, 0)
#define DCTLINFO_V2_W3_SEQ3 GENMASK(23, 12)
#define DCTLINFO_V2_W3_TGT_IND GENMASK(27, 24)
#define DCTLINFO_V2_W3_TGT_IND_EN BIT(28)
#define DCTLINFO_V2_W3_HTC_LB GENMASK(31, 29)
#define DCTLINFO_V2_W3_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W4_VLAN_TAG_SEL GENMASK(7, 5)
#define DCTLINFO_V2_W4_HTC_ORDER BIT(8)
#define DCTLINFO_V2_W4_SEC_KEY_ID GENMASK(10, 9)
#define DCTLINFO_V2_W4_VLAN_RX_DYNAMIC_PCP_EN BIT(11)
#define DCTLINFO_V2_W4_VLAN_RX_PKT_DROP BIT(12)
#define DCTLINFO_V2_W4_VLAN_RX_VALID BIT(13)
#define DCTLINFO_V2_W4_VLAN_TX_VALID BIT(14)
#define DCTLINFO_V2_W4_WAPI BIT(15)
#define DCTLINFO_V2_W4_SEC_ENT_MODE GENMASK(17, 16)
#define DCTLINFO_V2_W4_SEC_ENT0_KEYID GENMASK(19, 18)
#define DCTLINFO_V2_W4_SEC_ENT1_KEYID GENMASK(21, 20)
#define DCTLINFO_V2_W4_SEC_ENT2_KEYID GENMASK(23, 22)
#define DCTLINFO_V2_W4_SEC_ENT3_KEYID GENMASK(25, 24)
#define DCTLINFO_V2_W4_SEC_ENT4_KEYID GENMASK(27, 26)
#define DCTLINFO_V2_W4_SEC_ENT5_KEYID GENMASK(29, 28)
#define DCTLINFO_V2_W4_SEC_ENT6_KEYID GENMASK(31, 30)
#define DCTLINFO_V2_W4_ALL GENMASK(31, 5)
#define DCTLINFO_V2_W5_SEC_ENT7_KEYID GENMASK(1, 0)
#define DCTLINFO_V2_W5_SEC_ENT8_KEYID GENMASK(3, 2)
#define DCTLINFO_V2_W5_SEC_ENT_VALID_V1 GENMASK(23, 8)
#define DCTLINFO_V2_W5_SEC_ENT0_V1 GENMASK(31, 24)
#define DCTLINFO_V2_W5_ALL (GENMASK(31, 8) | GENMASK(3, 0))
#define DCTLINFO_V2_W6_SEC_ENT1_V1 GENMASK(7, 0)
#define DCTLINFO_V2_W6_SEC_ENT2_V1 GENMASK(15, 8)
#define DCTLINFO_V2_W6_SEC_ENT3_V1 GENMASK(23, 16)
#define DCTLINFO_V2_W6_SEC_ENT4_V1 GENMASK(31, 24)
#define DCTLINFO_V2_W6_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W7_SEC_ENT5_V1 GENMASK(7, 0)
#define DCTLINFO_V2_W7_SEC_ENT6_V1 GENMASK(15, 8)
#define DCTLINFO_V2_W7_SEC_ENT7 GENMASK(23, 16)
#define DCTLINFO_V2_W7_SEC_ENT8 GENMASK(31, 24)
#define DCTLINFO_V2_W7_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W8_MLD_SMA_0 GENMASK(7, 0)
#define DCTLINFO_V2_W8_MLD_SMA_1 GENMASK(15, 8)
#define DCTLINFO_V2_W8_MLD_SMA_2 GENMASK(23, 16)
#define DCTLINFO_V2_W8_MLD_SMA_3 GENMASK(31, 24)
#define DCTLINFO_V2_W8_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W9_MLD_SMA_4 GENMASK(7, 0)
#define DCTLINFO_V2_W9_MLD_SMA_5 GENMASK(15, 8)
#define DCTLINFO_V2_W9_MLD_TMA_0 GENMASK(23, 16)
#define DCTLINFO_V2_W9_MLD_TMA_1 GENMASK(31, 24)
#define DCTLINFO_V2_W9_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W10_MLD_TMA_2 GENMASK(7, 0)
#define DCTLINFO_V2_W10_MLD_TMA_3 GENMASK(15, 8)
#define DCTLINFO_V2_W10_MLD_TMA_4 GENMASK(23, 16)
#define DCTLINFO_V2_W10_MLD_TMA_5 GENMASK(31, 24)
#define DCTLINFO_V2_W10_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W11_MLD_BSSID_0 GENMASK(7, 0)
#define DCTLINFO_V2_W11_MLD_BSSID_1 GENMASK(15, 8)
#define DCTLINFO_V2_W11_MLD_BSSID_2 GENMASK(23, 16)
#define DCTLINFO_V2_W11_MLD_BSSID_3 GENMASK(31, 24)
#define DCTLINFO_V2_W11_ALL GENMASK(31, 0)
#define DCTLINFO_V2_W12_MLD_BSSID_4 GENMASK(7, 0)
#define DCTLINFO_V2_W12_MLD_BSSID_5 GENMASK(15, 8)
#define DCTLINFO_V2_W12_ALL GENMASK(15, 0)

struct rtw89_h2c_dctlinfo_ud_v3 {
	__le32 c0;
	__le32 w0;
	__le32 w1;
	__le32 w2;
	__le32 w3;
	__le32 w4;
	__le32 w5;
	__le32 w6;
	__le32 w7;
	__le32 w8;
	__le32 w9;
	__le32 w10;
	__le32 w11;
	__le32 w12;
	__le32 w13;
	__le32 w14;
	__le32 w15;
	__le32 m0;
	__le32 m1;
	__le32 m2;
	__le32 m3;
	__le32 m4;
	__le32 m5;
	__le32 m6;
	__le32 m7;
	__le32 m8;
	__le32 m9;
	__le32 m10;
	__le32 m11;
	__le32 m12;
	__le32 m13;
	__le32 m14;
	__le32 m15;
} __packed;

#define DCTLINFO_V3_C0_MACID GENMASK(15, 0)
#define DCTLINFO_V3_C0_OP BIT(16)

#define DCTLINFO_V3_W0_QOS_FIELD_H GENMASK(7, 0)
#define DCTLINFO_V3_W0_HW_EXSEQ_MACID GENMASK(14, 8)
#define DCTLINFO_V3_W0_QOS_DATA BIT(15)
#define DCTLINFO_V3_W0_AES_IV_L GENMASK(31, 16)
#define DCTLINFO_V3_W0_ALL GENMASK(31, 0)
#define DCTLINFO_V3_W1_AES_IV_H GENMASK(31, 0)
#define DCTLINFO_V3_W1_ALL GENMASK(31, 0)
#define DCTLINFO_V3_W2_SEQ0 GENMASK(11, 0)
#define DCTLINFO_V3_W2_SEQ1 GENMASK(23, 12)
#define DCTLINFO_V3_W2_AMSDU_MAX_LEN GENMASK(26, 24)
#define DCTLINFO_V3_W2_STA_AMSDU_EN BIT(27)
#define DCTLINFO_V3_W2_CHKSUM_OFLD_EN BIT(28)
#define DCTLINFO_V3_W2_WITH_LLC BIT(29)
#define DCTLINFO_V3_W2_NAT25_EN BIT(30)
#define DCTLINFO_V3_W2_IS_MLD BIT(31)
#define DCTLINFO_V3_W2_ALL GENMASK(31, 0)
#define DCTLINFO_V3_W3_SEQ2 GENMASK(11, 0)
#define DCTLINFO_V3_W3_SEQ3 GENMASK(23, 12)
#define DCTLINFO_V3_W3_TGT_IND GENMASK(27, 24)
#define DCTLINFO_V3_W3_TGT_IND_EN BIT(28)
#define DCTLINFO_V3_W3_HTC_LB GENMASK(31, 29)
#define DCTLINFO_V3_W3_ALL GENMASK(31, 0)
#define DCTLINFO_V3_W4_VLAN_TAG_SEL GENMASK(7, 5)
#define DCTLINFO_V3_W4_HTC_ORDER BIT(8)
#define DCTLINFO_V3_W4_SEC_KEY_ID GENMASK(10, 9)
#define DCTLINFO_V3_W4_VLAN_RX_DYNAMIC_PCP_EN BIT(11)
#define DCTLINFO_V3_W4_VLAN_RX_PKT_DROP BIT(12)
#define DCTLINFO_V3_W4_VLAN_RX_VALID BIT(13)
#define DCTLINFO_V3_W4_VLAN_TX_VALID BIT(14)
#define DCTLINFO_V3_W4_WAPI BIT(15)
#define DCTLINFO_V3_W4_SEC_ENT_MODE GENMASK(17, 16)
#define DCTLINFO_V3_W4_SEC_ENT0_KEYID GENMASK(19, 18)
#define DCTLINFO_V3_W4_SEC_ENT1_KEYID GENMASK(21, 20)
#define DCTLINFO_V3_W4_SEC_ENT2_KEYID GENMASK(23, 22)
#define DCTLINFO_V3_W4_SEC_ENT3_KEYID GENMASK(25, 24)
#define DCTLINFO_V3_W4_SEC_ENT4_KEYID GENMASK(27, 26)
#define DCTLINFO_V3_W4_SEC_ENT5_KEYID GENMASK(29, 28)
#define DCTLINFO_V3_W4_SEC_ENT6_KEYID GENMASK(31, 30)
#define DCTLINFO_V3_W4_ALL GENMASK(31, 5)
#define DCTLINFO_V3_W5_SEC_ENT7_KEYID GENMASK(1, 0)
#define DCTLINFO_V3_W5_SEC_ENT8_KEYID GENMASK(3, 2)
#define DCTLINFO_V3_W5_SEC_ENT_VALID_V1 GENMASK(23, 8)
#define DCTLINFO_V3_W5_ALL (GENMASK(23, 8) | GENMASK(3, 0))
#define DCTLINFO_V3_W6_SEC_ENT0_V2 GENMASK(8, 0)
#define DCTLINFO_V3_W6_SEC_ENT1_V2 GENMASK(18, 10)
#define DCTLINFO_V3_W6_SEC_ENT2_V2 GENMASK(28, 20)
#define DCTLINFO_V3_W6_ALL GENMASK(28, 0)
#define DCTLINFO_V3_W7_SEC_ENT3_V2 GENMASK(8, 0)
#define DCTLINFO_V3_W7_SEC_ENT4_V2 GENMASK(18, 10)
#define DCTLINFO_V3_W7_SEC_ENT5_V2 GENMASK(28, 20)
#define DCTLINFO_V3_W7_ALL GENMASK(28, 0)
#define DCTLINFO_V3_W8_SEC_ENT6_V2 GENMASK(8, 0)
#define DCTLINFO_V3_W8_SEC_ENT7_V1 GENMASK(18, 10)
#define DCTLINFO_V3_W8_SEC_ENT8_V1 GENMASK(28, 20)
#define DCTLINFO_V3_W8_ALL GENMASK(28, 0)
#define DCTLINFO_V3_W9_MLD_SMA_0_V2 GENMASK(7, 0)
#define DCTLINFO_V3_W9_MLD_SMA_1_V2 GENMASK(15, 8)
#define DCTLINFO_V3_W9_MLD_SMA_2_V2 GENMASK(23, 16)
#define DCTLINFO_V3_W9_MLD_SMA_3_V2 GENMASK(31, 24)
#define DCTLINFO_V3_W9_MLD_SMA_L_V2 GENMASK(31, 0)
#define DCTLINFO_V3_W9_ALL GENMASK(31, 0)
#define DCTLINFO_V3_W10_MLD_SMA_4_V2 GENMASK(7, 0)
#define DCTLINFO_V3_W10_MLD_SMA_5_V2 GENMASK(15, 8)
#define DCTLINFO_V3_W10_MLD_SMA_H_V2 GENMASK(15, 0)
#define DCTLINFO_V3_W10_MLD_TMA_0_V2 GENMASK(23, 16)
#define DCTLINFO_V3_W10_MLD_TMA_1_V2 GENMASK(31, 24)
#define DCTLINFO_V3_W10_MLD_TMA_L_V2 GENMASK(31, 16)
#define DCTLINFO_V3_W10_ALL GENMASK(31, 0)
#define DCTLINFO_V3_W11_MLD_TMA_2_V2 GENMASK(7, 0)
#define DCTLINFO_V3_W11_MLD_TMA_3_V2 GENMASK(15, 8)
#define DCTLINFO_V3_W11_MLD_TMA_4_V2 GENMASK(23, 16)
#define DCTLINFO_V3_W11_MLD_TMA_5_V2 GENMASK(31, 24)
#define DCTLINFO_V3_W11_MLD_TMA_H_V2 GENMASK(31, 0)
#define DCTLINFO_V3_W11_ALL GENMASK(31, 0)
#define DCTLINFO_V3_W12_MLD_TA_BSSID_0_V2 GENMASK(7, 0)
#define DCTLINFO_V3_W12_MLD_TA_BSSID_1_V2 GENMASK(15, 8)
#define DCTLINFO_V3_W12_MLD_TA_BSSID_2_V2 GENMASK(23, 16)
#define DCTLINFO_V3_W12_MLD_TA_BSSID_3_V2 GENMASK(31, 24)
#define DCTLINFO_V3_W12_MLD_TA_BSSID_L_V2 GENMASK(31, 0)
#define DCTLINFO_V3_W12_ALL GENMASK(31, 0)
#define DCTLINFO_V3_W13_MLD_TA_BSSID_4_V2 GENMASK(7, 0)
#define DCTLINFO_V3_W13_MLD_TA_BSSID_5_V2 GENMASK(15, 8)
#define DCTLINFO_V3_W13_MLD_TA_BSSID_H_V2 GENMASK(15, 0)
#define DCTLINFO_V3_W13_HW_EXSEQ_MACID_V1 GENMASK(24, 16)
#define DCTLINFO_V3_W13_ALL GENMASK(24, 0)

int rtw89_cam_init(struct rtw89_dev *rtwdev, struct rtw89_vif_link *vif);
void rtw89_cam_deinit(struct rtw89_dev *rtwdev, struct rtw89_vif_link *vif);
int rtw89_cam_init_addr_cam(struct rtw89_dev *rtwdev,
			    struct rtw89_addr_cam_entry *addr_cam,
			    const struct rtw89_bssid_cam_entry *bssid_cam);
void rtw89_cam_deinit_addr_cam(struct rtw89_dev *rtwdev,
			       struct rtw89_addr_cam_entry *addr_cam);
int rtw89_cam_init_bssid_cam(struct rtw89_dev *rtwdev,
			     struct rtw89_vif_link *rtwvif_link,
			     struct rtw89_bssid_cam_entry *bssid_cam,
			     const u8 *bssid);
void rtw89_cam_deinit_bssid_cam(struct rtw89_dev *rtwdev,
				struct rtw89_bssid_cam_entry *bssid_cam);
void rtw89_cam_fill_addr_cam_info(struct rtw89_dev *rtwdev,
				  struct rtw89_vif_link *rtwvif_link,
				  struct rtw89_sta_link *rtwsta_link,
				  const u8 *scan_mac_addr,
				  struct rtw89_h2c_addr_cam_v0 *h2c);
void rtw89_cam_fill_dctl_sec_cam_info_v1(struct rtw89_dev *rtwdev,
					 struct rtw89_vif_link *rtwvif_link,
					 struct rtw89_sta_link *rtwsta_link,
					 struct rtw89_h2c_dctlinfo_ud_v1 *h2c);
void rtw89_cam_fill_dctl_sec_cam_info_v2(struct rtw89_dev *rtwdev,
					 struct rtw89_vif_link *rtwvif_link,
					 struct rtw89_sta_link *rtwsta_link,
					 struct rtw89_h2c_dctlinfo_ud_v2 *h2c);
void rtw89_cam_fill_dctl_sec_cam_info_v3(struct rtw89_dev *rtwdev,
					 struct rtw89_vif_link *rtwvif_link,
					 struct rtw89_sta_link *rtwsta_link,
					 struct rtw89_h2c_dctlinfo_ud_v3 *h2c);
int rtw89_cam_fill_bssid_cam_info(struct rtw89_dev *rtwdev,
				  struct rtw89_vif_link *rtwvif_link,
				  struct rtw89_sta_link *rtwsta_link,
				  struct rtw89_h2c_addr_cam_v0 *h2c);
int rtw89_cam_sec_key_add(struct rtw89_dev *rtwdev,
			  struct ieee80211_vif *vif,
			  struct ieee80211_sta *sta,
			  struct ieee80211_key_conf *key);
int rtw89_cam_sec_key_del(struct rtw89_dev *rtwdev,
			  struct ieee80211_vif *vif,
			  struct ieee80211_sta *sta,
			  struct ieee80211_key_conf *key,
			  bool inform_fw);
void rtw89_cam_bssid_changed(struct rtw89_dev *rtwdev,
			     struct rtw89_vif_link *rtwvif_link);
void rtw89_cam_reset_keys(struct rtw89_dev *rtwdev);
int rtw89_cam_attach_link_sec_cam(struct rtw89_dev *rtwdev,
				  struct rtw89_vif_link *rtwvif_link,
				  struct rtw89_sta_link *rtwsta_link,
				  u8 sec_cam_idx);

#endif
