#pragma once
#include "Tr.h"
#include "IFlashOperation.h"

class CFlashOperationImpl : public IFlashOperation, public CTr
{
public:
    CFlashOperationImpl( LPVOID pLogUtil );
    virtual ~CFlashOperationImpl();
    
public:
    virtual void Release( void );
    virtual SPRESULT EnableOperation( DL_TYPE_ENUM eType, LPFLASH_OPERATION_SWITCH lpOperation );
    virtual SPRESULT CheckReadBuffer( LPCSTR lpReadBuffer, LPFLASH_READ_FILE lpReadFile );
    virtual SPRESULT PrepareReadFlashAfterFDL2( LPFLASH_READ_FILE lpReadFile, INT& nCount );
    virtual SPRESULT PrepareWriteFlashAfterFDL2( LPFLASH_WRITE_FILE lpWriteFile, INT& nCount );
    virtual SPRESULT PrepareWriteFlashAfterDlEnd( LPFLASH_WRITE_FILE lpWriteFile, INT& nCount );
    virtual SPRESULT PrepareEraseFlashAfterFDL2( LPFLASH_ERASE_FILE lpEraseFile, INT& nCount );
    
private:
    BOOL SaveFileToLocal( LPCSTR pszFileName, LPBYTE pBuf, DWORD dwSize );
    
private:
    INT m_nCount = 0;
    INT m_nCheckOffset1 = 12288 + 50;
    INT m_nCheckOffset2 = 12288 * 3 + 50;
};