#include "StdAfx.h"
#include <io.h>
#include "bn.h"
#include "sha.h"
#include "rsa.h"
#include "aes.h"
#include "ec.h"
#include "ecdsa.h"
#include "rand.h"
#include "hmac.h"
#include "err.h"
#include "ec_lcl.h"
#include "pem.h"
#include "ossl_typ.h"
#include "bio.h"
#include "Security_Encryption.h"
#include "AuthenticationImpl.h"

extern HMODULE g_hModule;

#define AUTH_NAME "Authorize"
// aes key must be 32 bytes
static unsigned char aes_key[32] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 };

// rsa private key data must be 1160 bytes
static unsigned char privite_key[1160] =
{
    0x00, 0x01, 0x00, 0x00, 0x03, 0x85, 0x5D, 0x39, 0x15, 0xF1, 0xCC, 0xA8, 0x84, 0x60, 0x3C, 0x18,
    0xF4, 0xCF, 0xAB, 0x87, 0x63, 0x3F, 0x1B, 0xF7, 0xD2, 0xAE, 0x8A, 0x66, 0x42, 0x1E, 0xFA, 0xD5,
    0xB1, 0x8D, 0x69, 0x45, 0x21, 0xFD, 0xD8, 0xB4, 0x90, 0x6C, 0x48, 0x24, 0x00, 0xDC, 0xB7, 0x93,
    0x6F, 0x4B, 0x27, 0x03, 0xDF, 0xBA, 0x96, 0x72, 0x4E, 0x2A, 0x06, 0xE2, 0xBD, 0x99, 0x75, 0x51,
    0x2D, 0x09, 0xE5, 0xC0, 0x9C, 0x78, 0x54, 0x30, 0x0C, 0xE8, 0xC3, 0x9F, 0x7B, 0x57, 0x33, 0x0F,
    0xEB, 0xC6, 0xA2, 0x7E, 0x5A, 0x36, 0x12, 0xEE, 0xC9, 0xA5, 0x81, 0x5D, 0x39, 0x15, 0xF1, 0xCC,
    0xA8, 0x84, 0x60, 0x3C, 0x18, 0xF4, 0xCF, 0xAB, 0x87, 0x63, 0x3F, 0x1B, 0xF7, 0xD2, 0xAE, 0x8A,
    0x66, 0x42, 0x1E, 0xFA, 0xD5, 0xB1, 0x8D, 0x69, 0x45, 0x21, 0xFD, 0xD8, 0xB4, 0x90, 0x6C, 0x48,
    0x24, 0x00, 0xDC, 0xB7, 0x62, 0xC1, 0xE4, 0x08, 0x2D, 0x51, 0x75, 0x99, 0xBD, 0xE1, 0x05, 0x2A,
    0x4E, 0x72, 0x96, 0xBA, 0xDE, 0x02, 0x27, 0x4B, 0x6F, 0x93, 0xB7, 0xDB, 0xFF, 0x23, 0x48, 0x6C,
    0x90, 0xB4, 0xD8, 0xFC, 0x20, 0x45, 0x69, 0x8D, 0xB1, 0xD5, 0xF9, 0x1D, 0x42, 0x66, 0x8A, 0xAE,
    0xD2, 0xF6, 0x1A, 0x3F, 0x63, 0x87, 0xAB, 0xCF, 0xF3, 0x17, 0x3C, 0x60, 0x84, 0xA8, 0xCC, 0xF0,
    0x14, 0x39, 0x5D, 0x81, 0xA5, 0xC9, 0xED, 0x11, 0x36, 0x5A, 0x7E, 0xA2, 0xC6, 0xEA, 0x0E, 0x33,
    0x57, 0x7B, 0x9F, 0xC3, 0xE7, 0x0B, 0x30, 0x54, 0x78, 0x9C, 0xC0, 0xE4, 0x08, 0x2D, 0x51, 0x75,
    0x99, 0xBD, 0xE1, 0x05, 0x2A, 0x4E, 0x72, 0x96, 0xBA, 0xDE, 0x02, 0x27, 0x4B, 0x6F, 0x93, 0xB7,
    0xDB, 0xFF, 0x23, 0x48, 0x6C, 0x90, 0xB4, 0xD8, 0xFC, 0x20, 0x45, 0x69, 0x8D, 0xB1, 0xD5, 0xF9,
    0x1D, 0x42, 0x66, 0x8A, 0x01, 0x00, 0x01, 0x00, 0x01, 0x51, 0x41, 0xAE, 0x34, 0x40, 0x32, 0x9F,
    0x25, 0x31, 0x23, 0x90, 0x16, 0x22, 0x14, 0x81, 0x07, 0x13, 0x05, 0x72, 0xF8, 0x03, 0xF6, 0x62,
    0xE9, 0xF4, 0xE6, 0x53, 0xDA, 0xE5, 0xD7, 0x44, 0xCB, 0xD6, 0xC8, 0x35, 0xBC, 0xC7, 0xB9, 0x26,
    0xAD, 0xB8, 0xAA, 0x17, 0x9E, 0xA9, 0x9B, 0x08, 0x8F, 0x9A, 0x8C, 0xF9, 0x7F, 0x8B, 0x7D, 0xEA,
    0x70, 0x7C, 0x6E, 0xDB, 0x61, 0x6D, 0x5F, 0xCC, 0x52, 0x5E, 0x50, 0xBD, 0x43, 0x4F, 0x41, 0xAE,
    0x34, 0x40, 0x32, 0x9F, 0x25, 0x31, 0x23, 0x90, 0x16, 0x22, 0x14, 0x81, 0x07, 0x13, 0x05, 0x72,
    0xF8, 0x03, 0xF6, 0x62, 0xE9, 0xF4, 0xE6, 0x53, 0xDA, 0xE5, 0xD7, 0x44, 0xCB, 0xD6, 0xC8, 0x35,
    0xBC, 0xC7, 0xB9, 0x26, 0xAD, 0xB8, 0xAA, 0x17, 0x9E, 0xA9, 0x9B, 0x08, 0x8F, 0x9A, 0x8C, 0xF9,
    0x7F, 0x8B, 0x7D, 0xEA, 0x70, 0x7C, 0x6E, 0xDB, 0xF5, 0x22, 0xCD, 0x94, 0x71, 0x31, 0xDC, 0xA3,
    0x80, 0x40, 0xEB, 0xB2, 0x8F, 0x4F, 0xFA, 0xC1, 0x9E, 0x5E, 0x09, 0xD1, 0xAD, 0x6D, 0x18, 0xE0,
    0xBC, 0x7C, 0x27, 0xEF, 0xCB, 0x8B, 0x36, 0xFE, 0xDA, 0x9A, 0x45, 0x0D, 0xEA, 0xA9, 0x54, 0x1C,
    0xF9, 0xB8, 0x63, 0x2B, 0x08, 0xC8, 0x72, 0x3A, 0x17, 0xD7, 0x81, 0x49, 0x26, 0xE6, 0x90, 0x58,
    0x35, 0xF5, 0x9F, 0x67, 0x44, 0x04, 0xAF, 0x76, 0x53, 0x13, 0xBE, 0x85, 0x62, 0x22, 0xCD, 0x94,
    0x71, 0x31, 0xDC, 0xA3, 0x80, 0x40, 0xEB, 0xB2, 0x8F, 0x4F, 0xFA, 0xC1, 0x9E, 0x5E, 0x09, 0xD1,
    0xAD, 0x6D, 0x18, 0xE0, 0xBC, 0x7C, 0x27, 0xEF, 0xCB, 0x8B, 0x36, 0xFE, 0xDA, 0x9A, 0x45, 0x0D,
    0xEA, 0xA9, 0x54, 0x1C, 0xF9, 0xB8, 0x63, 0x2B, 0x08, 0xC8, 0x72, 0x3A, 0x17, 0xD7, 0x81, 0x49,
    0x26, 0xE6, 0x90, 0x58, 0x35, 0xF5, 0x9F, 0x67, 0xC1, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
    0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
    0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
    0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
    0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
    0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
    0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
    0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
    0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xC3, 0xBB, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA,
    0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA,
    0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA,
    0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA,
    0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA,
    0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA,
    0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA,
    0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA,
    0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0x41, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E,
    0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E,
    0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E,
    0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E,
    0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E,
    0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E,
    0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E,
    0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E,
    0x3F, 0x3F, 0x7E, 0x7E, 0x3F, 0x3F, 0x7E, 0x7E, 0x11, 0x9C, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D,
    0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D,
    0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D,
    0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D,
    0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D,
    0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D,
    0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D,
    0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D,
    0xD0, 0x9B, 0xF9, 0x2D, 0xD0, 0x9B, 0xF9, 0x2D, 0x1C, 0x4D, 0xA6, 0xC9, 0x68, 0x59, 0x7D, 0xC2,
    0x9C, 0x24, 0x3D, 0x65, 0x75, 0x03, 0x6B, 0xA8, 0x51, 0x0B, 0xA4, 0xF8, 0xF3, 0xC7, 0xBB, 0x2D,
    0x07, 0x1A, 0x95, 0x38, 0x00, 0x9B, 0x73, 0xD0, 0x5D, 0x58, 0x7A, 0xC1, 0x1B, 0xC4, 0x04, 0xBF,
    0xFD, 0x3B, 0x9B, 0x42, 0x84, 0x7E, 0xCD, 0x1F, 0xC8, 0x86, 0xA0, 0x96, 0x1A, 0xB9, 0x81, 0x1B,
    0xB4, 0x00, 0x7A, 0x2B, 0x36, 0xA5, 0x03, 0x77, 0x6B, 0x05, 0x69, 0x28, 0x31, 0xE3, 0x11, 0xCA,
    0x43, 0xD0, 0x51, 0x95, 0xC6, 0x63, 0x97, 0x8B, 0x15, 0x75, 0xEF, 0x25, 0xD2, 0x0A, 0x84, 0xF0,
    0x69, 0x23, 0xB0, 0x41, 0x89, 0xFF, 0x6E, 0xA8, 0x92, 0x5B, 0xC8, 0x55, 0x54, 0xB7, 0x8F, 0x5E,
    0x88, 0x86, 0x90, 0x92, 0xD5, 0xE6, 0x7B, 0x25, 0x75, 0xF3, 0x66, 0x63, 0x7F, 0x05, 0xAE, 0xB9,
    0xE6, 0xB4, 0xF3, 0x76, 0x67, 0xC4, 0xD7, 0xB3,
};

CAuthenticationImpl::CAuthenticationImpl( LPVOID pLogUtil )
{
    BindLog( ( ISpLog* )pLogUtil, AUTH_NAME );
}

CAuthenticationImpl::~CAuthenticationImpl()
{

}

void CAuthenticationImpl::Release( void )
{
    delete this;
}

SPRESULT CAuthenticationImpl::EnableAuth( LPCRANDOM_DATA lpRandomData, AUTH_MODE& eMode )
{
    CTrLog log( this, _T( "EnableAuth" ) );
    //ȷǷҪ򿪼Ȩ
    eMode = E_AUTH_DISABLE;
    
    return SP_OK;
}

SPRESULT CAuthenticationImpl::ServerAuth( LPAUTH_DUT lpDut, LPAUTH_SERVER lpServer, DWORD& dwLength )
{
    CTrLog log( this, _T( "ServerAuth" ) );
    
    AUTH_DUT tDutReq;     //M1DUT
    AUTH_SERVER tServerReq;   //M2
    
    std::string strRet;
    FILE* fp_pri = NULL;
    unsigned char pPriKey[2048] = { 0 };
    int nPriKeyLen = 0;
    
    CHAR szAppPath[_MAX_PATH] = { 0 };
    GetModuleFileNameA( g_hModule, szAppPath, _MAX_PATH );
    LPSTR lpChar = strrchr( szAppPath, '\\' );
    if ( NULL != lpChar )
    {
        *lpChar = '\0';
    }
    
    CHAR szKeyPath[_MAX_PATH] = { 0 };
    strcpy_s( szKeyPath, szAppPath );
    strcat_s( szKeyPath, "\\rsa2048.pem" );
    
    if ( 0 != fopen_s( &fp_pri, szKeyPath, "r" ) )
    {
        return SP_E_AUTH_PRIVITE_KEY_SIZE_ERROR;
    }
    
    nPriKeyLen = _filelength( _fileno( fp_pri ) );
    fread( pPriKey, 1, nPriKeyLen, fp_pri );
    fclose( fp_pri );
    
    
    RSA* p_rsa_pri = NULL;
    p_rsa_pri = RSA_new();
    
    BIO* keybio_pri = NULL;
    keybio_pri = BIO_new_mem_buf( pPriKey, -1 );
    
    // ȡ˽ԿRSA
    p_rsa_pri = PEM_read_bio_RSAPrivateKey( keybio_pri, &p_rsa_pri, NULL, NULL );
    
    unsigned char rsaEnData[256] = { 0 };
    
    X_RSA_KEY rsa_key;
    memset( &rsa_key, 0, sizeof( X_RSA_KEY ) );
    
    memcpy( rsa_key.szRsa_n, p_rsa_pri->n->d, 256 );
    memcpy( rsa_key.szRsa_e, p_rsa_pri->e->d, 4 );
    memcpy( rsa_key.szRsa_d, p_rsa_pri->d->d, 256 );
    memcpy( rsa_key.szRsa_p, p_rsa_pri->p->d, 128 );
    memcpy( rsa_key.szRsa_q, p_rsa_pri->q->d, 128 );
    memcpy( rsa_key.szRsa_dmp1, p_rsa_pri->dmp1->d, 128 );
    memcpy( rsa_key.szRsa_dmq1, p_rsa_pri->dmq1->d, 128 );
    memcpy( rsa_key.szRsa_iqmp, p_rsa_pri->iqmp->d, 128 );
    int pOutputLength = 0;
    RSA_Decryption( rsa_key,
                    RsaKey_Private,
                    lpDut->u8M1,
                    sizeof( lpDut->u8M1 ),
                    rsaEnData,
                    &pOutputLength,
                    RSA2048,
                    RsaPadding_OAEP
                  );
                  
                  
    int pOutputLength2 = 0;
    std::vector<unsigned char> arrSignBuf( 100, 0 );
    //std::vector<unsigned char> arrHashBuf(68, 0);
    //memcpy(arrHashBuf.data(), rsaEnData, pOutputLength);
    std::vector<unsigned char> arrSign( KEY_LENGTH, 0 );
    HASH_256_Encrypt( /*arrHashBuf.data()*/rsaEnData, pOutputLength, arrSignBuf.data() );
    int nSignOutLength = 0;
    RSA_Sign( rsa_key, RsaKey_Private, arrSignBuf.data(), 32, arrSign.data(), &nSignOutLength, RSA2048, RsaPadding_Pkcs, Hash_Type_RAW_1 );
    
    memcpy( lpServer->u8M2, arrSign.data(), nSignOutLength );
    memcpy( lpServer->u8Nonce, rsaEnData + 4, 32 );
    int outlength = sizeof( lpServer );
    dwLength = ( unsigned long )288;
    
    return SP_OK;
    //Server
    if ( NULL == lpDut ) //DUTصM1쳣
    {
        return SP_E_AUTH_DUT_FAIL;
    }
    else if ( NULL == lpServer ) //ӷصM2쳣
    {
        return SP_E_AUTH_SURVER_FAIL;
    }
    else if ( dwLength == 0 ) //жϷصsizeΪ0
    {
        return SP_E_AUTH_SURVER_SIZE_IS_ZEOR;
    }
    else            //ɹӷM2
    {
        return SP_OK;
    }
    
    return SP_OK;
}

SPRESULT CAuthenticationImpl::GetSecureKey( LPSECURE_KEY lpKey )
{
    CTrLog log( this, _T( "GetSecureKey" ) );
    if ( sizeof( lpKey->u8PriviteKey ) != sizeof( privite_key ) )
    {
        return SP_E_AUTH_PRIVITE_KEY_SIZE_ERROR;
    }
    else
    {
        memcpy( lpKey->u8PriviteKey, privite_key, sizeof( lpKey->u8PriviteKey ) );
    }
    
    if ( sizeof( lpKey->u8AesKey ) != sizeof( aes_key ) )
    {
        return SP_E_AUTH_AES_KEY_SIZE_ERROR;
    }
    else
    {
        memcpy( lpKey->u8AesKey, aes_key, sizeof( lpKey->u8AesKey ) );
    }
    
    return SP_OK;
}
